// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/monitoring/v3/common.proto

/*
Package monitoring is a generated protocol buffer package.

It is generated from these files:
	google/monitoring/v3/common.proto
	google/monitoring/v3/group.proto
	google/monitoring/v3/group_service.proto
	google/monitoring/v3/metric.proto
	google/monitoring/v3/metric_service.proto

It has these top-level messages:
	TypedValue
	TimeInterval
	Aggregation
	Group
	ListGroupsRequest
	ListGroupsResponse
	GetGroupRequest
	CreateGroupRequest
	UpdateGroupRequest
	DeleteGroupRequest
	ListGroupMembersRequest
	ListGroupMembersResponse
	Point
	TimeSeries
	ListMonitoredResourceDescriptorsRequest
	ListMonitoredResourceDescriptorsResponse
	GetMonitoredResourceDescriptorRequest
	ListMetricDescriptorsRequest
	ListMetricDescriptorsResponse
	GetMetricDescriptorRequest
	CreateMetricDescriptorRequest
	DeleteMetricDescriptorRequest
	ListTimeSeriesRequest
	ListTimeSeriesResponse
	CreateTimeSeriesRequest
	CreateTimeSeriesError
*/
package monitoring

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_api2 "google.golang.org/genproto/googleapis/api/distribution"
import google_protobuf3 "github.com/golang/protobuf/ptypes/duration"
import google_protobuf2 "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The Aligner describes how to bring the data points in a single
// time series into temporal alignment.
type Aggregation_Aligner int32

const (
	// No alignment. Raw data is returned. Not valid if cross-time
	// series reduction is requested. The value type of the result is
	// the same as the value type of the input.
	Aggregation_ALIGN_NONE Aggregation_Aligner = 0
	// Align and convert to delta metric type. This alignment is valid
	// for cumulative metrics and delta metrics. Aligning an existing
	// delta metric to a delta metric requires that the alignment
	// period be increased. The value type of the result is the same
	// as the value type of the input.
	Aggregation_ALIGN_DELTA Aggregation_Aligner = 1
	// Align and convert to a rate. This alignment is valid for
	// cumulative metrics and delta metrics with numeric values. The output is a
	// gauge metric with value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_RATE Aggregation_Aligner = 2
	// Align by interpolating between adjacent points around the
	// period boundary. This alignment is valid for gauge
	// metrics with numeric values. The value type of the result is the same
	// as the value type of the input.
	Aggregation_ALIGN_INTERPOLATE Aggregation_Aligner = 3
	// Align by shifting the oldest data point before the period
	// boundary to the boundary. This alignment is valid for gauge
	// metrics. The value type of the result is the same as the
	// value type of the input.
	Aggregation_ALIGN_NEXT_OLDER Aggregation_Aligner = 4
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the minimum of all data points in the
	// period. This alignment is valid for gauge and delta metrics with numeric
	// values. The value type of the result is the same as the value
	// type of the input.
	Aggregation_ALIGN_MIN Aggregation_Aligner = 10
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the maximum of all data points in the
	// period. This alignment is valid for gauge and delta metrics with numeric
	// values. The value type of the result is the same as the value
	// type of the input.
	Aggregation_ALIGN_MAX Aggregation_Aligner = 11
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the average or arithmetic mean of all
	// data points in the period. This alignment is valid for gauge and delta
	// metrics with numeric values. The value type of the output is
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_MEAN Aggregation_Aligner = 12
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the count of all data points in the
	// period. This alignment is valid for gauge and delta metrics with numeric
	// or Boolean values. The value type of the output is
	// [INT64][google.api.MetricDescriptor.ValueType.INT64].
	Aggregation_ALIGN_COUNT Aggregation_Aligner = 13
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the sum of all data points in the
	// period. This alignment is valid for gauge and delta metrics with numeric
	// and distribution values. The value type of the output is the
	// same as the value type of the input.
	Aggregation_ALIGN_SUM Aggregation_Aligner = 14
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the standard deviation of all data
	// points in the period. This alignment is valid for gauge and delta metrics
	// with numeric values. The value type of the output is
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_STDDEV Aggregation_Aligner = 15
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the count of True-valued data points in the
	// period. This alignment is valid for gauge metrics with
	// Boolean values. The value type of the output is
	// [INT64][google.api.MetricDescriptor.ValueType.INT64].
	Aggregation_ALIGN_COUNT_TRUE Aggregation_Aligner = 16
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the fraction of True-valued data points in the
	// period. This alignment is valid for gauge metrics with Boolean values.
	// The output value is in the range [0, 1] and has value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_FRACTION_TRUE Aggregation_Aligner = 17
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the 99th percentile of all data
	// points in the period. This alignment is valid for gauge and delta metrics
	// with distribution values. The output is a gauge metric with value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_PERCENTILE_99 Aggregation_Aligner = 18
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the 95th percentile of all data
	// points in the period. This alignment is valid for gauge and delta metrics
	// with distribution values. The output is a gauge metric with value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_PERCENTILE_95 Aggregation_Aligner = 19
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the 50th percentile of all data
	// points in the period. This alignment is valid for gauge and delta metrics
	// with distribution values. The output is a gauge metric with value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_PERCENTILE_50 Aggregation_Aligner = 20
	// Align time series via aggregation. The resulting data point in
	// the alignment period is the 5th percentile of all data
	// points in the period. This alignment is valid for gauge and delta metrics
	// with distribution values. The output is a gauge metric with value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_ALIGN_PERCENTILE_05 Aggregation_Aligner = 21
)

var Aggregation_Aligner_name = map[int32]string{
	0:  "ALIGN_NONE",
	1:  "ALIGN_DELTA",
	2:  "ALIGN_RATE",
	3:  "ALIGN_INTERPOLATE",
	4:  "ALIGN_NEXT_OLDER",
	10: "ALIGN_MIN",
	11: "ALIGN_MAX",
	12: "ALIGN_MEAN",
	13: "ALIGN_COUNT",
	14: "ALIGN_SUM",
	15: "ALIGN_STDDEV",
	16: "ALIGN_COUNT_TRUE",
	17: "ALIGN_FRACTION_TRUE",
	18: "ALIGN_PERCENTILE_99",
	19: "ALIGN_PERCENTILE_95",
	20: "ALIGN_PERCENTILE_50",
	21: "ALIGN_PERCENTILE_05",
}
var Aggregation_Aligner_value = map[string]int32{
	"ALIGN_NONE":          0,
	"ALIGN_DELTA":         1,
	"ALIGN_RATE":          2,
	"ALIGN_INTERPOLATE":   3,
	"ALIGN_NEXT_OLDER":    4,
	"ALIGN_MIN":           10,
	"ALIGN_MAX":           11,
	"ALIGN_MEAN":          12,
	"ALIGN_COUNT":         13,
	"ALIGN_SUM":           14,
	"ALIGN_STDDEV":        15,
	"ALIGN_COUNT_TRUE":    16,
	"ALIGN_FRACTION_TRUE": 17,
	"ALIGN_PERCENTILE_99": 18,
	"ALIGN_PERCENTILE_95": 19,
	"ALIGN_PERCENTILE_50": 20,
	"ALIGN_PERCENTILE_05": 21,
}

func (x Aggregation_Aligner) String() string {
	return proto.EnumName(Aggregation_Aligner_name, int32(x))
}
func (Aggregation_Aligner) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2, 0} }

// A Reducer describes how to aggregate data points from multiple
// time series into a single time series.
type Aggregation_Reducer int32

const (
	// No cross-time series reduction. The output of the aligner is
	// returned.
	Aggregation_REDUCE_NONE Aggregation_Reducer = 0
	// Reduce by computing the mean across time series for each
	// alignment period. This reducer is valid for delta and
	// gauge metrics with numeric or distribution values. The value type of the
	// output is [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_REDUCE_MEAN Aggregation_Reducer = 1
	// Reduce by computing the minimum across time series for each
	// alignment period. This reducer is valid for delta and
	// gauge metrics with numeric values. The value type of the output
	// is the same as the value type of the input.
	Aggregation_REDUCE_MIN Aggregation_Reducer = 2
	// Reduce by computing the maximum across time series for each
	// alignment period. This reducer is valid for delta and
	// gauge metrics with numeric values. The value type of the output
	// is the same as the value type of the input.
	Aggregation_REDUCE_MAX Aggregation_Reducer = 3
	// Reduce by computing the sum across time series for each
	// alignment period. This reducer is valid for delta and
	// gauge metrics with numeric and distribution values. The value type of
	// the output is the same as the value type of the input.
	Aggregation_REDUCE_SUM Aggregation_Reducer = 4
	// Reduce by computing the standard deviation across time series
	// for each alignment period. This reducer is valid for delta
	// and gauge metrics with numeric or distribution values. The value type of
	// the output is [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_REDUCE_STDDEV Aggregation_Reducer = 5
	// Reduce by computing the count of data points across time series
	// for each alignment period. This reducer is valid for delta
	// and gauge metrics of numeric, Boolean, distribution, and string value
	// type. The value type of the output is
	// [INT64][google.api.MetricDescriptor.ValueType.INT64].
	Aggregation_REDUCE_COUNT Aggregation_Reducer = 6
	// Reduce by computing the count of True-valued data points across time
	// series for each alignment period. This reducer is valid for delta
	// and gauge metrics of Boolean value type. The value type of
	// the output is [INT64][google.api.MetricDescriptor.ValueType.INT64].
	Aggregation_REDUCE_COUNT_TRUE Aggregation_Reducer = 7
	// Reduce by computing the fraction of True-valued data points across time
	// series for each alignment period. This reducer is valid for delta
	// and gauge metrics of Boolean value type. The output value is in the
	// range [0, 1] and has value type
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_REDUCE_FRACTION_TRUE Aggregation_Reducer = 8
	// Reduce by computing 99th percentile of data points across time series
	// for each alignment period. This reducer is valid for gauge and delta
	// metrics of numeric and distribution type. The value of the output is
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE]
	Aggregation_REDUCE_PERCENTILE_99 Aggregation_Reducer = 9
	// Reduce by computing 95th percentile of data points across time series
	// for each alignment period. This reducer is valid for gauge and delta
	// metrics of numeric and distribution type. The value of the output is
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE]
	Aggregation_REDUCE_PERCENTILE_95 Aggregation_Reducer = 10
	// Reduce by computing 50th percentile of data points across time series
	// for each alignment period. This reducer is valid for gauge and delta
	// metrics of numeric and distribution type. The value of the output is
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE]
	Aggregation_REDUCE_PERCENTILE_50 Aggregation_Reducer = 11
	// Reduce by computing 5th percentile of data points across time series
	// for each alignment period. This reducer is valid for gauge and delta
	// metrics of numeric and distribution type. The value of the output is
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE]
	Aggregation_REDUCE_PERCENTILE_05 Aggregation_Reducer = 12
)

var Aggregation_Reducer_name = map[int32]string{
	0:  "REDUCE_NONE",
	1:  "REDUCE_MEAN",
	2:  "REDUCE_MIN",
	3:  "REDUCE_MAX",
	4:  "REDUCE_SUM",
	5:  "REDUCE_STDDEV",
	6:  "REDUCE_COUNT",
	7:  "REDUCE_COUNT_TRUE",
	8:  "REDUCE_FRACTION_TRUE",
	9:  "REDUCE_PERCENTILE_99",
	10: "REDUCE_PERCENTILE_95",
	11: "REDUCE_PERCENTILE_50",
	12: "REDUCE_PERCENTILE_05",
}
var Aggregation_Reducer_value = map[string]int32{
	"REDUCE_NONE":          0,
	"REDUCE_MEAN":          1,
	"REDUCE_MIN":           2,
	"REDUCE_MAX":           3,
	"REDUCE_SUM":           4,
	"REDUCE_STDDEV":        5,
	"REDUCE_COUNT":         6,
	"REDUCE_COUNT_TRUE":    7,
	"REDUCE_FRACTION_TRUE": 8,
	"REDUCE_PERCENTILE_99": 9,
	"REDUCE_PERCENTILE_95": 10,
	"REDUCE_PERCENTILE_50": 11,
	"REDUCE_PERCENTILE_05": 12,
}

func (x Aggregation_Reducer) String() string {
	return proto.EnumName(Aggregation_Reducer_name, int32(x))
}
func (Aggregation_Reducer) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2, 1} }

// A single strongly-typed value.
type TypedValue struct {
	// The typed value field.
	//
	// Types that are valid to be assigned to Value:
	//	*TypedValue_BoolValue
	//	*TypedValue_Int64Value
	//	*TypedValue_DoubleValue
	//	*TypedValue_StringValue
	//	*TypedValue_DistributionValue
	Value isTypedValue_Value `protobuf_oneof:"value"`
}

func (m *TypedValue) Reset()                    { *m = TypedValue{} }
func (m *TypedValue) String() string            { return proto.CompactTextString(m) }
func (*TypedValue) ProtoMessage()               {}
func (*TypedValue) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type isTypedValue_Value interface {
	isTypedValue_Value()
}

type TypedValue_BoolValue struct {
	BoolValue bool `protobuf:"varint,1,opt,name=bool_value,json=boolValue,oneof"`
}
type TypedValue_Int64Value struct {
	Int64Value int64 `protobuf:"varint,2,opt,name=int64_value,json=int64Value,oneof"`
}
type TypedValue_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,3,opt,name=double_value,json=doubleValue,oneof"`
}
type TypedValue_StringValue struct {
	StringValue string `protobuf:"bytes,4,opt,name=string_value,json=stringValue,oneof"`
}
type TypedValue_DistributionValue struct {
	DistributionValue *google_api2.Distribution `protobuf:"bytes,5,opt,name=distribution_value,json=distributionValue,oneof"`
}

func (*TypedValue_BoolValue) isTypedValue_Value()         {}
func (*TypedValue_Int64Value) isTypedValue_Value()        {}
func (*TypedValue_DoubleValue) isTypedValue_Value()       {}
func (*TypedValue_StringValue) isTypedValue_Value()       {}
func (*TypedValue_DistributionValue) isTypedValue_Value() {}

func (m *TypedValue) GetValue() isTypedValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *TypedValue) GetBoolValue() bool {
	if x, ok := m.GetValue().(*TypedValue_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (m *TypedValue) GetInt64Value() int64 {
	if x, ok := m.GetValue().(*TypedValue_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (m *TypedValue) GetDoubleValue() float64 {
	if x, ok := m.GetValue().(*TypedValue_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *TypedValue) GetStringValue() string {
	if x, ok := m.GetValue().(*TypedValue_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (m *TypedValue) GetDistributionValue() *google_api2.Distribution {
	if x, ok := m.GetValue().(*TypedValue_DistributionValue); ok {
		return x.DistributionValue
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*TypedValue) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _TypedValue_OneofMarshaler, _TypedValue_OneofUnmarshaler, _TypedValue_OneofSizer, []interface{}{
		(*TypedValue_BoolValue)(nil),
		(*TypedValue_Int64Value)(nil),
		(*TypedValue_DoubleValue)(nil),
		(*TypedValue_StringValue)(nil),
		(*TypedValue_DistributionValue)(nil),
	}
}

func _TypedValue_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*TypedValue)
	// value
	switch x := m.Value.(type) {
	case *TypedValue_BoolValue:
		t := uint64(0)
		if x.BoolValue {
			t = 1
		}
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *TypedValue_Int64Value:
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Int64Value))
	case *TypedValue_DoubleValue:
		b.EncodeVarint(3<<3 | proto.WireFixed64)
		b.EncodeFixed64(math.Float64bits(x.DoubleValue))
	case *TypedValue_StringValue:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.StringValue)
	case *TypedValue_DistributionValue:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DistributionValue); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("TypedValue.Value has unexpected type %T", x)
	}
	return nil
}

func _TypedValue_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*TypedValue)
	switch tag {
	case 1: // value.bool_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &TypedValue_BoolValue{x != 0}
		return true, err
	case 2: // value.int64_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &TypedValue_Int64Value{int64(x)}
		return true, err
	case 3: // value.double_value
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Value = &TypedValue_DoubleValue{math.Float64frombits(x)}
		return true, err
	case 4: // value.string_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &TypedValue_StringValue{x}
		return true, err
	case 5: // value.distribution_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_api2.Distribution)
		err := b.DecodeMessage(msg)
		m.Value = &TypedValue_DistributionValue{msg}
		return true, err
	default:
		return false, nil
	}
}

func _TypedValue_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*TypedValue)
	// value
	switch x := m.Value.(type) {
	case *TypedValue_BoolValue:
		n += proto.SizeVarint(1<<3 | proto.WireVarint)
		n += 1
	case *TypedValue_Int64Value:
		n += proto.SizeVarint(2<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.Int64Value))
	case *TypedValue_DoubleValue:
		n += proto.SizeVarint(3<<3 | proto.WireFixed64)
		n += 8
	case *TypedValue_StringValue:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.StringValue)))
		n += len(x.StringValue)
	case *TypedValue_DistributionValue:
		s := proto.Size(x.DistributionValue)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A time interval extending just after a start time through an end time.
// If the start time is the same as the end time, then the interval
// represents a single point in time.
type TimeInterval struct {
	// Required. The end of the time interval.
	EndTime *google_protobuf2.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
	// Optional. The beginning of the time interval.  The default value
	// for the start time is the end time. The start time must not be
	// later than the end time.
	StartTime *google_protobuf2.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
}

func (m *TimeInterval) Reset()                    { *m = TimeInterval{} }
func (m *TimeInterval) String() string            { return proto.CompactTextString(m) }
func (*TimeInterval) ProtoMessage()               {}
func (*TimeInterval) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *TimeInterval) GetEndTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *TimeInterval) GetStartTime() *google_protobuf2.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

// Describes how to combine multiple time series to provide different views of
// the data.  Aggregation consists of an alignment step on individual time
// series (`per_series_aligner`) followed by an optional reduction of the data
// across different time series (`cross_series_reducer`).  For more details, see
// [Aggregation](/monitoring/api/learn_more#aggregation).
type Aggregation struct {
	// The alignment period for per-[time series][google.monitoring.v3.TimeSeries]
	// alignment. If present, `alignmentPeriod` must be at least 60
	// seconds.  After per-time series alignment, each time series will
	// contain data points only on the period boundaries. If
	// `perSeriesAligner` is not specified or equals `ALIGN_NONE`, then
	// this field is ignored. If `perSeriesAligner` is specified and
	// does not equal `ALIGN_NONE`, then this field must be defined;
	// otherwise an error is returned.
	AlignmentPeriod *google_protobuf3.Duration `protobuf:"bytes,1,opt,name=alignment_period,json=alignmentPeriod" json:"alignment_period,omitempty"`
	// The approach to be used to align individual time series. Not all
	// alignment functions may be applied to all time series, depending
	// on the metric type and value type of the original time
	// series. Alignment may change the metric type or the value type of
	// the time series.
	//
	// Time series data must be aligned in order to perform cross-time
	// series reduction. If `crossSeriesReducer` is specified, then
	// `perSeriesAligner` must be specified and not equal `ALIGN_NONE`
	// and `alignmentPeriod` must be specified; otherwise, an error is
	// returned.
	PerSeriesAligner Aggregation_Aligner `protobuf:"varint,2,opt,name=per_series_aligner,json=perSeriesAligner,enum=google.monitoring.v3.Aggregation_Aligner" json:"per_series_aligner,omitempty"`
	// The approach to be used to combine time series. Not all reducer
	// functions may be applied to all time series, depending on the
	// metric type and the value type of the original time
	// series. Reduction may change the metric type of value type of the
	// time series.
	//
	// Time series data must be aligned in order to perform cross-time
	// series reduction. If `crossSeriesReducer` is specified, then
	// `perSeriesAligner` must be specified and not equal `ALIGN_NONE`
	// and `alignmentPeriod` must be specified; otherwise, an error is
	// returned.
	CrossSeriesReducer Aggregation_Reducer `protobuf:"varint,4,opt,name=cross_series_reducer,json=crossSeriesReducer,enum=google.monitoring.v3.Aggregation_Reducer" json:"cross_series_reducer,omitempty"`
	// The set of fields to preserve when `crossSeriesReducer` is
	// specified. The `groupByFields` determine how the time series are
	// partitioned into subsets prior to applying the aggregation
	// function. Each subset contains time series that have the same
	// value for each of the grouping fields. Each individual time
	// series is a member of exactly one subset. The
	// `crossSeriesReducer` is applied to each subset of time series.
	// It is not possible to reduce across different resource types, so
	// this field implicitly contains `resource.type`.  Fields not
	// specified in `groupByFields` are aggregated away.  If
	// `groupByFields` is not specified and all the time series have
	// the same resource type, then the time series are aggregated into
	// a single output time series. If `crossSeriesReducer` is not
	// defined, this field is ignored.
	GroupByFields []string `protobuf:"bytes,5,rep,name=group_by_fields,json=groupByFields" json:"group_by_fields,omitempty"`
}

func (m *Aggregation) Reset()                    { *m = Aggregation{} }
func (m *Aggregation) String() string            { return proto.CompactTextString(m) }
func (*Aggregation) ProtoMessage()               {}
func (*Aggregation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Aggregation) GetAlignmentPeriod() *google_protobuf3.Duration {
	if m != nil {
		return m.AlignmentPeriod
	}
	return nil
}

func (m *Aggregation) GetPerSeriesAligner() Aggregation_Aligner {
	if m != nil {
		return m.PerSeriesAligner
	}
	return Aggregation_ALIGN_NONE
}

func (m *Aggregation) GetCrossSeriesReducer() Aggregation_Reducer {
	if m != nil {
		return m.CrossSeriesReducer
	}
	return Aggregation_REDUCE_NONE
}

func (m *Aggregation) GetGroupByFields() []string {
	if m != nil {
		return m.GroupByFields
	}
	return nil
}

func init() {
	proto.RegisterType((*TypedValue)(nil), "google.monitoring.v3.TypedValue")
	proto.RegisterType((*TimeInterval)(nil), "google.monitoring.v3.TimeInterval")
	proto.RegisterType((*Aggregation)(nil), "google.monitoring.v3.Aggregation")
	proto.RegisterEnum("google.monitoring.v3.Aggregation_Aligner", Aggregation_Aligner_name, Aggregation_Aligner_value)
	proto.RegisterEnum("google.monitoring.v3.Aggregation_Reducer", Aggregation_Reducer_name, Aggregation_Reducer_value)
}

func init() { proto.RegisterFile("google/monitoring/v3/common.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 792 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x55, 0xdd, 0x6a, 0xe3, 0x46,
	0x14, 0xb6, 0xec, 0x64, 0x1d, 0x1f, 0x39, 0xf1, 0x64, 0xd6, 0x4b, 0xdd, 0x40, 0xbb, 0x5e, 0x17,
	0x8a, 0x7b, 0x23, 0x87, 0xb8, 0x2e, 0x84, 0x42, 0x41, 0xb1, 0xb5, 0x1b, 0x83, 0x23, 0x9b, 0x59,
	0x25, 0x0d, 0x6d, 0x40, 0xc8, 0xd1, 0xac, 0x10, 0xc8, 0x1a, 0x31, 0x92, 0x0d, 0xb9, 0xeb, 0x6b,
	0xf4, 0xba, 0x77, 0xfb, 0x28, 0x7d, 0x84, 0x3e, 0x44, 0x9f, 0xa1, 0x68, 0x66, 0xb4, 0x52, 0x5a,
	0x97, 0xf6, 0xf2, 0xfb, 0x39, 0xdf, 0xe8, 0x7c, 0x23, 0xd9, 0xf0, 0x26, 0x60, 0x2c, 0x88, 0xe8,
	0x68, 0xc3, 0xe2, 0x30, 0x63, 0x3c, 0x8c, 0x83, 0xd1, 0x6e, 0x3c, 0x7a, 0x64, 0x9b, 0x0d, 0x8b,
	0x8d, 0x84, 0xb3, 0x8c, 0xe1, 0xae, 0xb4, 0x18, 0xa5, 0xc5, 0xd8, 0x8d, 0xcf, 0xbe, 0x50, 0x83,
	0x5e, 0x12, 0x8e, 0xfc, 0x30, 0xcd, 0x78, 0xb8, 0xde, 0x66, 0x61, 0x31, 0x74, 0xf6, 0xa5, 0x92,
	0x05, 0x5a, 0x6f, 0x3f, 0x8c, 0xfc, 0x2d, 0xf7, 0x2a, 0xfa, 0xeb, 0xbf, 0xeb, 0x59, 0xb8, 0xa1,
	0x69, 0xe6, 0x6d, 0x12, 0x69, 0x18, 0xfc, 0xa9, 0x01, 0x38, 0x4f, 0x09, 0xf5, 0xef, 0xbc, 0x68,
	0x4b, 0xf1, 0x6b, 0x80, 0x35, 0x63, 0x91, 0xbb, 0xcb, 0x51, 0x4f, 0xeb, 0x6b, 0xc3, 0xa3, 0xeb,
	0x1a, 0x69, 0xe5, 0x9c, 0x34, 0xbc, 0x01, 0x3d, 0x8c, 0xb3, 0xef, 0xbe, 0x55, 0x8e, 0x7a, 0x5f,
	0x1b, 0x36, 0xae, 0x6b, 0x04, 0x04, 0x29, 0x2d, 0x5f, 0x41, 0xdb, 0x67, 0xdb, 0x75, 0x44, 0x95,
	0xa7, 0xd1, 0xd7, 0x86, 0xda, 0x75, 0x8d, 0xe8, 0x92, 0xfd, 0x64, 0xca, 0x97, 0x89, 0x03, 0x65,
	0x3a, 0xe8, 0x6b, 0xc3, 0x56, 0x6e, 0x92, 0xac, 0x34, 0xcd, 0x01, 0x57, 0x77, 0x56, 0xd6, 0xc3,
	0xbe, 0x36, 0xd4, 0x2f, 0x7a, 0x86, 0xea, 0xcb, 0x4b, 0x42, 0x63, 0x56, 0x71, 0x5d, 0xd7, 0xc8,
	0x69, 0x75, 0x4a, 0x44, 0x5d, 0x35, 0xe1, 0x50, 0x4c, 0x0f, 0x7e, 0xd1, 0xa0, 0xed, 0x84, 0x1b,
	0x3a, 0x8f, 0x33, 0xca, 0x77, 0x5e, 0x84, 0x27, 0x70, 0x44, 0x63, 0xdf, 0xcd, 0x8b, 0x11, 0xeb,
	0xe8, 0x17, 0x67, 0x45, 0x74, 0xd1, 0x9a, 0xe1, 0x14, 0xad, 0x91, 0x26, 0x8d, 0xfd, 0x1c, 0xe1,
	0x4b, 0x80, 0x34, 0xf3, 0x78, 0x26, 0x07, 0xb5, 0xff, 0x1c, 0x6c, 0x09, 0x77, 0x8e, 0x07, 0x1f,
	0x9b, 0xa0, 0x9b, 0x41, 0xc0, 0x69, 0x20, 0xae, 0x0a, 0xcf, 0x00, 0x79, 0x51, 0x18, 0xc4, 0x1b,
	0x1a, 0x67, 0x6e, 0x42, 0x79, 0xc8, 0x7c, 0x15, 0xf8, 0xf9, 0x3f, 0x02, 0x67, 0xea, 0x7e, 0x49,
	0xe7, 0xd3, 0xc8, 0x4a, 0x4c, 0xe0, 0x1f, 0x01, 0x27, 0x94, 0xbb, 0x29, 0xe5, 0x21, 0x4d, 0x5d,
	0xa1, 0x52, 0x2e, 0x36, 0x3a, 0xb9, 0xf8, 0xc6, 0xd8, 0xf7, 0x72, 0x19, 0x95, 0x87, 0x30, 0x4c,
	0x39, 0x40, 0x50, 0x42, 0xf9, 0x7b, 0x91, 0xa1, 0x18, 0xfc, 0x33, 0x74, 0x1f, 0x39, 0x4b, 0xd3,
	0x22, 0x9a, 0x53, 0x7f, 0xfb, 0x48, 0xb9, 0xb8, 0xb2, 0xff, 0x15, 0x4d, 0xe4, 0x00, 0xc1, 0x22,
	0x46, 0x86, 0x2b, 0x0e, 0x7f, 0x0d, 0x9d, 0x80, 0xb3, 0x6d, 0xe2, 0xae, 0x9f, 0xdc, 0x0f, 0x21,
	0x8d, 0xfc, 0xb4, 0x77, 0xd8, 0x6f, 0x0c, 0x5b, 0xe4, 0x58, 0xd0, 0x57, 0x4f, 0x6f, 0x05, 0x39,
	0xf8, 0xa3, 0x0e, 0xcd, 0xe2, 0x81, 0x4e, 0x00, 0xcc, 0xc5, 0xfc, 0x9d, 0xed, 0xda, 0x4b, 0xdb,
	0x42, 0x35, 0xdc, 0x01, 0x5d, 0xe2, 0x99, 0xb5, 0x70, 0x4c, 0xa4, 0x95, 0x06, 0x62, 0x3a, 0x16,
	0xaa, 0xe3, 0x57, 0x70, 0x2a, 0xf1, 0xdc, 0x76, 0x2c, 0xb2, 0x5a, 0x2e, 0x72, 0xba, 0x81, 0xbb,
	0x80, 0x54, 0x8e, 0x75, 0xef, 0xb8, 0xcb, 0xc5, 0xcc, 0x22, 0xe8, 0x00, 0x1f, 0x43, 0x4b, 0xb2,
	0x37, 0x73, 0x1b, 0x41, 0x05, 0x9a, 0xf7, 0x48, 0x2f, 0xa3, 0x6f, 0x2c, 0xd3, 0x46, 0xed, 0xf2,
	0xec, 0xe9, 0xf2, 0xd6, 0x76, 0xd0, 0x71, 0xe9, 0x7f, 0x7f, 0x7b, 0x83, 0x4e, 0x30, 0x82, 0xb6,
	0x82, 0xce, 0x6c, 0x66, 0xdd, 0xa1, 0x4e, 0x79, 0xaa, 0x98, 0x70, 0x1d, 0x72, 0x6b, 0x21, 0x84,
	0x3f, 0x83, 0x97, 0x92, 0x7d, 0x4b, 0xcc, 0xa9, 0x33, 0x5f, 0xda, 0x52, 0x38, 0x2d, 0x85, 0x95,
	0x45, 0xa6, 0x96, 0xed, 0xcc, 0x17, 0x96, 0x7b, 0x79, 0x89, 0xf0, 0x7e, 0x61, 0x82, 0x5e, 0xee,
	0x15, 0x26, 0xe7, 0xa8, 0xbb, 0x57, 0x38, 0x9f, 0xa0, 0x57, 0x83, 0x5f, 0xeb, 0xd0, 0x2c, 0x2e,
	0xa4, 0x03, 0x3a, 0xb1, 0x66, 0xb7, 0x53, 0xab, 0xd2, 0xae, 0x22, 0xc4, 0xca, 0xa2, 0xdd, 0x82,
	0x98, 0xdb, 0xa8, 0x5e, 0xc5, 0xe6, 0x3d, 0x6a, 0x54, 0x70, 0x5e, 0xc1, 0x01, 0x3e, 0x85, 0xe3,
	0x02, 0xcb, 0x0e, 0x0e, 0xf3, 0x56, 0x14, 0x25, 0x6b, 0x7b, 0x91, 0x5f, 0x51, 0x95, 0x91, 0xdb,
	0x37, 0x71, 0x0f, 0xba, 0x8a, 0x7e, 0xde, 0xcb, 0x51, 0x45, 0x79, 0x5e, 0x4c, 0xeb, 0x5f, 0x94,
	0x09, 0x82, 0xfd, 0xca, 0xe4, 0x1c, 0xe9, 0xfb, 0x95, 0xf3, 0x09, 0x6a, 0x5f, 0xfd, 0xa6, 0x41,
	0xef, 0x91, 0x6d, 0xf6, 0xbe, 0xe5, 0x57, 0xfa, 0x54, 0xfc, 0x82, 0xaf, 0xf2, 0xaf, 0x73, 0xa5,
	0xfd, 0xf4, 0x83, 0x32, 0x05, 0x2c, 0xf2, 0xe2, 0xc0, 0x60, 0x3c, 0x18, 0x05, 0x34, 0x16, 0xdf,
	0xee, 0x48, 0x4a, 0x5e, 0x12, 0xa6, 0xcf, 0xff, 0x04, 0xbe, 0x2f, 0xd1, 0xc7, 0xfa, 0xd9, 0x3b,
	0x19, 0x30, 0x8d, 0xd8, 0xd6, 0x37, 0x6e, 0xca, 0xb3, 0xee, 0xc6, 0xbf, 0x17, 0xe2, 0x83, 0x10,
	0x1f, 0x4a, 0xf1, 0xe1, 0x6e, 0xbc, 0x7e, 0x21, 0x0e, 0x19, 0xff, 0x15, 0x00, 0x00, 0xff, 0xff,
	0x57, 0xa4, 0xb9, 0xce, 0x68, 0x06, 0x00, 0x00,
}
