// Generated by gmmproc 2.50.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gstreamermm/miniobject.h>
#include <gstreamermm/private/miniobject_p.h>


/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/miniobject.h>
#include <gstreamermm/private/miniobject_p.h>

namespace Gst
{

std::map<GstMiniObject*, MiniObject::SlotFinalizer*> MiniObject::finalizers;

MiniObject::~MiniObject()
{
    GstMiniObject *const gobject_ = reinterpret_cast<GstMiniObject*>(const_cast<MiniObject*>(this));
  // The value of the reference count is checked so that if this mini object is
  // being destroyed as a result of weak reference notification no
  // unreferencing is done and thus no error is issued on unreferencing a mini
  // object with a reference of 0.
  if (gobject_ && GST_MINI_OBJECT_REFCOUNT_VALUE(gobject_) > 0)
  {
    gst_mini_object_unref(gobject_);
  }

  if (finalizers.find(gobject_) != finalizers.end())
  {
    delete finalizers[gobject_];
    finalizers[gobject_] = nullptr;
  }
}

Glib::RefPtr<Gst::MiniObject> MiniObject::create_writable()
{
  /*
   * This function is generally used in the following pattern:
   * RefPtr<Buffer> p = (...);
   * p = p->create_writable();
   *
   * There are two cases:
   * 1. object is not writable, therefore:
   *   - somebody else may have another reference to the object (but it this might change in the meantime)
   *   - gst_mini_object_make_writable may return a new copy of object
   *   - we have to make additional ref, that will be unreffed in gst_mini_object_make_writable
   * 2. object is_writable, then:
   *   - our caller has the only one reference to object (therefore nobody can increase refcount in the meantime)
   *   - gst_mini_object_make_writable will return the same object and will not do any reffing/unreffing
   *   - we cannot make any additional refs before calling gst_mini_object_make_writable, since it would enforce unnecessary
   *     copying of the object
   *   - we are supposed to create a new RefPtr with is own reference to the object, therefore we need to "take copy"
   *   - however when caller release the pointer (implicitly, during assignment) the refcount will be 1 again
   */
  if(is_writable())
  {
    return Glib::wrap(gst_mini_object_make_writable(gobj()), true); // take copy so original object is left to the current owner (and hopefully will be released soon)
  }
  else
  {
    reference(); // gst_mini_object_make_writable(buf) will unref the old buffer, but our caller is still holding RefPtr to it
    return Glib::wrap(gst_mini_object_make_writable(gobj()));
  }
}

void MiniObject::set_qdata(GQuark quark, QuarkData *data)
{
  gst_mini_object_set_qdata(gobj(), quark, static_cast<gpointer>(data), &MiniObject::destroy_qdata);
}

void MiniObject::destroy_qdata(gpointer qdata)
{
  QuarkData *data = static_cast<QuarkData*>(qdata);
  delete data;
}

QuarkData* MiniObject::get_qdata(GQuark quark) const
{
  gpointer qdata = gst_mini_object_get_qdata(const_cast<GstMiniObject*>(gobj()), quark);
  return static_cast<QuarkData*>(qdata);
}

void MiniObject::add_finalize_notifier(const SlotFinalizer& slot)
{
  SlotFinalizer *finalizer = new SlotFinalizer(slot);
  if (finalizers.find(gobj()) != finalizers.end())
  {
    delete finalizers[gobj()];
    finalizers[gobj()] = finalizer;
  }
  else
  {
    finalizers.insert(std::make_pair(gobj(), finalizer));
  }
  gst_mini_object_weak_ref(gobj(), &MiniObject::MiniObject_Finalizer_gstreamermm_callback, static_cast<gpointer>(finalizer));
}

void MiniObject::MiniObject_Finalizer_gstreamermm_callback(gpointer userdata, GstMiniObject*)
{
  (*static_cast<SlotFinalizer*>(userdata))();
}

void MiniObject::remove_finalize_notifier()
{
  if (finalizers.find(gobj()) != finalizers.end())
  {
    gst_mini_object_weak_unref(gobj(), &MiniObject::MiniObject_Finalizer_gstreamermm_callback, finalizers[gobj()]);
    delete finalizers[gobj()];
    finalizers[gobj()] = nullptr;
  }
}

} //namespace Gst

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gst::MiniObjectFlags>::value_type()
{
  return gst_mini_object_flags_get_type();
}

// static
GType Glib::Value<Gst::LockFlags>::value_type()
{
  return gst_lock_flags_get_type();
}


/* Why reinterpret_cast<MiniObject*>(gobject) is needed:
 *
 * A MiniObject instance is in fact always a GstMiniObject instance.
 * Unfortunately, GstMiniObject cannot be a member of MiniObject,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because MiniObject does not have any member data, and
 * it is impossible to derive from it.  This is ensured by using final on the
 * class and by using = delete on the default constructor.
 */

namespace Glib
{

Glib::RefPtr<Gst::MiniObject> wrap(GstMiniObject* object, bool take_copy)
{
  if(take_copy && object)
    gst_mini_object_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::RefPtr<Gst::MiniObject>(reinterpret_cast<Gst::MiniObject*>(object));
}

} // namespace Glib


namespace Gst
{


void MiniObject::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_mini_object_ref(reinterpret_cast<GstMiniObject*>(const_cast<MiniObject*>(this)));
}

void MiniObject::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gst_mini_object_unref(reinterpret_cast<GstMiniObject*>(const_cast<MiniObject*>(this)));
}

GstMiniObject* MiniObject::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GstMiniObject*>(this);
}

const GstMiniObject* MiniObject::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GstMiniObject*>(this);
}

GstMiniObject* MiniObject::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  const auto gobject = reinterpret_cast<GstMiniObject*>(const_cast<MiniObject*>(this));
  gst_mini_object_ref(gobject);
  return gobject;
}


guint MiniObject::get_flags() const
{
  return gobj()->flags;
}

void MiniObject::set_flags(const guint& value)
{
  gobj()->flags = value;
}

gint MiniObject::get_refcount() const
{
  return gobj()->refcount;
}

gint MiniObject::get_lockstate() const
{
  return gobj()->lockstate;
}

bool MiniObject::lock(LockFlags flags)
{
  return gst_mini_object_lock(gobj(), ((GstLockFlags)(flags)));
}

void MiniObject::unlock(LockFlags flags)
{
  gst_mini_object_unlock(gobj(), ((GstLockFlags)(flags)));
}

bool MiniObject::is_writable() const
{
  return gst_mini_object_is_writable(const_cast<GstMiniObject*>(gobj()));
}

QuarkData* MiniObject::steal_qdata(GQuark quark)
{
  return static_cast<QuarkData*>(gst_mini_object_steal_qdata(gobj(), quark));
}


} // namespace Gst


