/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class SetsTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}

public void testCartesianProductTooBig() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testCartesianProductTooBig();
}

public void testCartesianProduct_2x2x2() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testCartesianProduct_2x2x2();
}

public void testCartesianProduct_binary0x0() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testCartesianProduct_binary0x0();
}

public void testCartesianProduct_binary0x1() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testCartesianProduct_binary0x1();
}

public void testCartesianProduct_binary1x0() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testCartesianProduct_binary1x0();
}

public void testCartesianProduct_binary1x1() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testCartesianProduct_binary1x1();
}

public void testCartesianProduct_binary1x2() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testCartesianProduct_binary1x2();
}

public void testCartesianProduct_binary2x2() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testCartesianProduct_binary2x2();
}

public void testCartesianProduct_contains() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testCartesianProduct_contains();
}

public void testCartesianProduct_hashCode() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testCartesianProduct_hashCode();
}

public void testCartesianProduct_unary() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testCartesianProduct_unary();
}

public void testCartesianProduct_unrelatedTypes() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testCartesianProduct_unrelatedTypes();
}

public void testCartesianProduct_zeroary() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testCartesianProduct_zeroary();
}

public void testComplementOfEmptyEnumSetWithoutType() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testComplementOfEmptyEnumSetWithoutType();
}

public void testComplementOfEmptySet() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testComplementOfEmptySet();
}

public void testComplementOfEmptySetWithoutTypeDoesntWork() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testComplementOfEmptySetWithoutTypeDoesntWork();
}

public void testComplementOfEnumSet() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testComplementOfEnumSet();
}

public void testComplementOfEnumSetWithType() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testComplementOfEnumSetWithType();
}

public void testComplementOfFullSet() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testComplementOfFullSet();
}

public void testComplementOfRegularSet() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testComplementOfRegularSet();
}

public void testComplementOfRegularSetWithType() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testComplementOfRegularSetWithType();
}

public void testImmutableEnumSet() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testImmutableEnumSet();
}

public void testImmutableEnumSet_fromIterable() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testImmutableEnumSet_fromIterable();
}

public void testNewConcurrentHashSetEmpty() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewConcurrentHashSetEmpty();
}

public void testNewConcurrentHashSetFromCollection() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewConcurrentHashSetFromCollection();
}

public void testNewEnumSet_collection() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewEnumSet_collection();
}

public void testNewEnumSet_empty() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewEnumSet_empty();
}

public void testNewEnumSet_enumSet() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewEnumSet_enumSet();
}

public void testNewEnumSet_iterable() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewEnumSet_iterable();
}

public void testNewHashSetEmpty() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewHashSetEmpty();
}

public void testNewHashSetFromCollection() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewHashSetFromCollection();
}

public void testNewHashSetFromIterable() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewHashSetFromIterable();
}

public void testNewHashSetFromIterator() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewHashSetFromIterator();
}

public void testNewHashSetVarArgs() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewHashSetVarArgs();
}

public void testNewHashSetWithExpectedSizeLarge() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewHashSetWithExpectedSizeLarge();
}

public void testNewHashSetWithExpectedSizeSmall() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewHashSetWithExpectedSizeSmall();
}

public void testNewIdentityHashSet() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewIdentityHashSet();
}

public void testNewLinkedHashSetEmpty() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewLinkedHashSetEmpty();
}

public void testNewLinkedHashSetFromCollection() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewLinkedHashSetFromCollection();
}

public void testNewLinkedHashSetFromIterable() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewLinkedHashSetFromIterable();
}

public void testNewLinkedHashSetWithExpectedSizeLarge() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewLinkedHashSetWithExpectedSizeLarge();
}

public void testNewLinkedHashSetWithExpectedSizeSmall() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewLinkedHashSetWithExpectedSizeSmall();
}

public void testNewSetFromMap() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewSetFromMap();
}

public void testNewSetFromMapIllegal() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewSetFromMapIllegal();
}

public void testNewTreeSetEmpty() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewTreeSetEmpty();
}

public void testNewTreeSetEmptyDerived() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewTreeSetEmptyDerived();
}

public void testNewTreeSetEmptyNonGeneric() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewTreeSetEmptyNonGeneric();
}

public void testNewTreeSetEmptyWithComparator() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewTreeSetEmptyWithComparator();
}

public void testNewTreeSetFromCollection() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewTreeSetFromCollection();
}

public void testNewTreeSetFromIterable() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewTreeSetFromIterable();
}

public void testNewTreeSetFromIterableDerived() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewTreeSetFromIterableDerived();
}

public void testNewTreeSetFromIterableNonGeneric() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testNewTreeSetFromIterableNonGeneric();
}

public void testPowerSetContents() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testPowerSetContents();
}

public void testPowerSetCreationErrors() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testPowerSetCreationErrors();
}

public void testPowerSetEmpty() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testPowerSetEmpty();
}

public void testPowerSetEqualsAndHashCode_verifyAgainstHashSet() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testPowerSetEqualsAndHashCode_verifyAgainstHashSet();
}

public void testPowerSetHashCode_inputHashCodeTimesTooFarValueIsZero() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testPowerSetHashCode_inputHashCodeTimesTooFarValueIsZero();
}

public void testPowerSetIteration_iteratorTester_fast() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testPowerSetIteration_iteratorTester_fast();
}

public void testPowerSetIteration_manual() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testPowerSetIteration_manual();
}

public void testPowerSetShowOff() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testPowerSetShowOff();
}

public void testPowerSetSize() throws Exception {
  com.google.common.collect.SetsTest testCase = new com.google.common.collect.SetsTest();
  testCase.testPowerSetSize();
}
}
