/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class ImmutableTableTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testBuilder() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testBuilder();
}

public void testBuilder_noDuplicates() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testBuilder_noDuplicates();
}

public void testBuilder_noNulls() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testBuilder_noNulls();
}

public void testBuilder_orderColumnsBy_dense() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testBuilder_orderColumnsBy_dense();
}

public void testBuilder_orderColumnsBy_sparse() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testBuilder_orderColumnsBy_sparse();
}

public void testBuilder_orderRowsAndColumnsBy_dense() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testBuilder_orderRowsAndColumnsBy_dense();
}

public void testBuilder_orderRowsAndColumnsBy_putAll() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testBuilder_orderRowsAndColumnsBy_putAll();
}

public void testBuilder_orderRowsAndColumnsBy_sparse() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testBuilder_orderRowsAndColumnsBy_sparse();
}

public void testBuilder_orderRowsBy_dense() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testBuilder_orderRowsBy_dense();
}

public void testBuilder_orderRowsBy_sparse() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testBuilder_orderRowsBy_sparse();
}

public void testBuilder_withImmutableCell() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testBuilder_withImmutableCell();
}

public void testBuilder_withImmutableCellAndNullContents() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testBuilder_withImmutableCellAndNullContents();
}

public void testBuilder_withMutableCell() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testBuilder_withMutableCell();
}

public void testColumn() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testColumn();
}

public void testColumnNull() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testColumnNull();
}

public void testColumnSetPartialOverlap() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testColumnSetPartialOverlap();
}

public void testContains() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testContains();
}

public void testContainsColumn() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testContainsColumn();
}

public void testContainsRow() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testContainsRow();
}

public void testContainsValue() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testContainsValue();
}

public void testCopyOf() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testCopyOf();
}

public void testCopyOfDense() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testCopyOfDense();
}

public void testCopyOfSparse() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testCopyOfSparse();
}

public void testEquals() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testEquals();
}

public void testGet() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testGet();
}

public void testHashCode() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testHashCode();
}

public void testIsEmpty() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testIsEmpty();
}

public void testRow() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testRow();
}

public void testRowNull() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testRowNull();
}

public void testSize() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testSize();
}

public void testToStringSize1() throws Exception {
  com.google.common.collect.ImmutableTableTest testCase = new com.google.common.collect.ImmutableTableTest();
  testCase.setUp();
  testCase.testToStringSize1();
}
}
