/* game-view.c generated by valac 0.26.0.19-b2255, the Vala compiler
 * generated from game-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <librsvg/rsvg.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;

#define TYPE_PLAYER (player_get_type ())

struct _GameView {
	GtkDrawingArea parent_instance;
	GameViewPrivate * priv;
};

struct _GameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _GameViewPrivate {
	guint render_size;
	cairo_pattern_t* tiles_pattern;
	gint* pixmaps;
	gint pixmaps_length1;
	gint pixmaps_length2;
	guint animate_timeout;
	gboolean flip_final_result_now;
	Game* _game;
	gchar* _theme;
};

struct _Block1Data {
	int _ref_count_;
	GameView* self;
	gint x;
	gint y;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;


static gpointer game_view_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY,
	GAME_VIEW_GAME,
	GAME_VIEW_THEME
};
#define GAME_VIEW_GRID_WIDTH 1
#define GAME_VIEW_PIXMAP_FLIP_DELAY 20
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static GtkSizeRequestMode game_view_real_get_request_mode (GtkWidget* base);
static void game_view_real_get_preferred_width_for_height (GtkWidget* base, gint height, gint* minimum_width, gint* natural_width);
static void game_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural);
static void game_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural);
static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr);
Game* game_view_get_game (GameView* self);
static gint game_view_get_tile_size (GameView* self);
static void game_view_load_theme (GameView* self, cairo_t* c);
static gint game_view_get_x_offset (GameView* self);
static gint game_view_get_y_offset (GameView* self);
static gint game_view_get_board_size (GameView* self);
const gchar* game_view_get_theme (GameView* self);
void game_view_redraw (GameView* self);
static void game_view_square_changed_cb (GameView* self, gint x, gint y);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
GType player_get_type (void) G_GNUC_CONST;
static gint game_view_get_pixmap (GameView* self, Player color);
Player game_get_owner (Game* self, gint x, gint y);
gboolean game_is_complete (Game* self);
gint game_get_width (Game* self);
gint game_get_n_light_tiles (Game* self);
gint game_get_n_dark_tiles (Game* self);
static void game_view_set_square (GameView* self, gint x, gint y, gint pixmap);
static gboolean ___lambda4_ (Block1Data* _data1_);
static gboolean ____lambda4__gsource_func (gpointer self);
static gboolean game_view_animate_cb (GameView* self);
static gboolean _game_view_animate_cb_gsource_func (gpointer self);
static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
void game_view_set_game (GameView* self, Game* value);
static void _game_view_square_changed_cb_game_square_changed (Game* _sender, gint x, gint y, gpointer self);
void game_view_set_theme (GameView* self, const gchar* value);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void game_view_finalize (GObject* obj);
static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GameView* game_view_construct (GType object_type) {
	GameView * self = NULL;
	gint* _tmp0_ = NULL;
#line 61 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self = (GameView*) g_object_new (object_type, NULL);
#line 63 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	gtk_widget_set_events ((GtkWidget*) self, (gint) (GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK));
#line 64 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = g_new0 (gint, 8 * 8);
#line 64 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
#line 64 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->pixmaps = _tmp0_;
#line 64 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->pixmaps_length1 = 8;
#line 64 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->pixmaps_length2 = 8;
#line 66 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, 350, 350);
#line 61 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return self;
#line 167 "game-view.c"
}


GameView* game_view_new (void) {
#line 61 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return game_view_construct (TYPE_GAME_VIEW);
#line 174 "game-view.c"
}


static GtkSizeRequestMode game_view_real_get_request_mode (GtkWidget* base) {
	GameView * self;
	GtkSizeRequestMode result = 0;
#line 96 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self = (GameView*) base;
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	result = GTK_SIZE_REQUEST_WIDTH_FOR_HEIGHT;
#line 98 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 187 "game-view.c"
}


static void game_view_real_get_preferred_width_for_height (GtkWidget* base, gint height, gint* minimum_width, gint* natural_width) {
	GameView * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	gint _tmp0_ = 0;
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self = (GameView*) base;
#line 104 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = height;
#line 104 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_vala_natural_width = _tmp0_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_vala_minimum_width = _vala_natural_width;
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (minimum_width) {
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		*minimum_width = _vala_minimum_width;
#line 208 "game-view.c"
	}
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (natural_width) {
#line 101 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		*natural_width = _vala_natural_width;
#line 214 "game-view.c"
	}
}


static void game_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural) {
	GameView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self = (GameView*) base;
#line 109 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_vala_natural = (gint) (8 * (20 + GAME_VIEW_GRID_WIDTH));
#line 109 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_vala_minimum = _vala_natural;
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (minimum) {
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		*minimum = _vala_minimum;
#line 233 "game-view.c"
	}
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (natural) {
#line 107 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		*natural = _vala_natural;
#line 239 "game-view.c"
	}
}


static void game_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural) {
	GameView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self = (GameView*) base;
#line 114 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_vala_natural = (gint) (8 * (20 + GAME_VIEW_GRID_WIDTH));
#line 114 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_vala_minimum = _vala_natural;
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (minimum) {
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		*minimum = _vala_minimum;
#line 258 "game-view.c"
	}
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (natural) {
#line 112 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		*natural = _vala_natural;
#line 264 "game-view.c"
	}
}


static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr) {
	GameView * self;
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	cairo_pattern_t* _tmp3_ = NULL;
	cairo_t* _tmp65_ = NULL;
	cairo_t* _tmp66_ = NULL;
	cairo_t* _tmp67_ = NULL;
	cairo_t* _tmp93_ = NULL;
	gint _tmp94_ = 0;
	gint _tmp95_ = 0;
	gint _tmp96_ = 0;
	gint _tmp97_ = 0;
	gint _tmp98_ = 0;
	gint _tmp99_ = 0;
	gint _tmp100_ = 0;
	gint _tmp101_ = 0;
	cairo_t* _tmp102_ = NULL;
#line 117 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self = (GameView*) base;
#line 117 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 119 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = game_view_get_game (self);
#line 119 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 119 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp1_ == NULL) {
#line 120 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		result = FALSE;
#line 120 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		return result;
#line 303 "game-view.c"
	}
#line 122 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp3_ = self->priv->tiles_pattern;
#line 122 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp3_ == NULL) {
#line 122 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp2_ = TRUE;
#line 311 "game-view.c"
	} else {
		guint _tmp4_ = 0U;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 122 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp4_ = self->priv->render_size;
#line 122 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp5_ = game_view_get_tile_size (self);
#line 122 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp6_ = _tmp5_;
#line 122 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp2_ = _tmp4_ != ((guint) _tmp6_);
#line 324 "game-view.c"
	}
#line 122 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp2_) {
#line 328 "game-view.c"
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		cairo_surface_t* surface = NULL;
		cairo_t* _tmp9_ = NULL;
		cairo_surface_t* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		cairo_surface_t* _tmp15_ = NULL;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp16_ = NULL;
		cairo_t* _tmp17_ = NULL;
		cairo_t* _tmp18_ = NULL;
		cairo_surface_t* _tmp19_ = NULL;
		cairo_pattern_t* _tmp20_ = NULL;
#line 124 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp7_ = game_view_get_tile_size (self);
#line 124 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp8_ = _tmp7_;
#line 124 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		self->priv->render_size = (guint) _tmp8_;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp9_ = cr;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp10_ = cairo_get_target (_tmp9_);
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp11_ = game_view_get_tile_size (self);
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp12_ = _tmp11_;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp13_ = game_view_get_tile_size (self);
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp14_ = _tmp13_;
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp15_ = cairo_surface_create_similar (_tmp10_, CAIRO_CONTENT_COLOR_ALPHA, _tmp12_ * 8, _tmp14_ * 4);
#line 125 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		surface = _tmp15_;
#line 126 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp16_ = surface;
#line 126 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp17_ = cairo_create (_tmp16_);
#line 126 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		c = _tmp17_;
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp18_ = c;
#line 127 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		game_view_load_theme (self, _tmp18_);
#line 128 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp19_ = surface;
#line 128 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp20_ = cairo_pattern_create_for_surface (_tmp19_);
#line 128 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_cairo_pattern_destroy0 (self->priv->tiles_pattern);
#line 128 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		self->priv->tiles_pattern = _tmp20_;
#line 122 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_cairo_destroy0 (c);
#line 122 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_cairo_surface_destroy0 (surface);
#line 389 "game-view.c"
	}
	{
		gint x = 0;
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		x = 0;
#line 395 "game-view.c"
		{
			gboolean _tmp21_ = FALSE;
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp21_ = TRUE;
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			while (TRUE) {
#line 402 "game-view.c"
				gint _tmp23_ = 0;
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				if (!_tmp21_) {
#line 406 "game-view.c"
					gint _tmp22_ = 0;
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					_tmp22_ = x;
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					x = _tmp22_ + 1;
#line 412 "game-view.c"
				}
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp21_ = FALSE;
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp23_ = x;
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				if (!(_tmp23_ < 8)) {
#line 131 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					break;
#line 422 "game-view.c"
				}
				{
					gint y = 0;
#line 133 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					y = 0;
#line 428 "game-view.c"
					{
						gboolean _tmp24_ = FALSE;
#line 133 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
						_tmp24_ = TRUE;
#line 133 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
						while (TRUE) {
#line 435 "game-view.c"
							gint _tmp26_ = 0;
							gint tile_x = 0;
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							gint tile_y = 0;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							gint texture_x = 0;
							gint* _tmp37_ = NULL;
							gint _tmp37__length1 = 0;
							gint _tmp37__length2 = 0;
							gint _tmp38_ = 0;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gint _tmp41_ = 0;
							gint _tmp42_ = 0;
							gint texture_y = 0;
							gint* _tmp43_ = NULL;
							gint _tmp43__length1 = 0;
							gint _tmp43__length2 = 0;
							gint _tmp44_ = 0;
							gint _tmp45_ = 0;
							gint _tmp46_ = 0;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							cairo_matrix_t matrix = {0};
							gint _tmp49_ = 0;
							gint _tmp50_ = 0;
							gint _tmp51_ = 0;
							gint _tmp52_ = 0;
							cairo_pattern_t* _tmp53_ = NULL;
							cairo_matrix_t _tmp54_ = {0};
							cairo_t* _tmp55_ = NULL;
							cairo_pattern_t* _tmp56_ = NULL;
							cairo_t* _tmp57_ = NULL;
							gint _tmp58_ = 0;
							gint _tmp59_ = 0;
							gint _tmp60_ = 0;
							gint _tmp61_ = 0;
							gint _tmp62_ = 0;
							gint _tmp63_ = 0;
							cairo_t* _tmp64_ = NULL;
#line 133 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							if (!_tmp24_) {
#line 486 "game-view.c"
								gint _tmp25_ = 0;
#line 133 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp25_ = y;
#line 133 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								y = _tmp25_ + 1;
#line 492 "game-view.c"
							}
#line 133 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp24_ = FALSE;
#line 133 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp26_ = y;
#line 133 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							if (!(_tmp26_ < 8)) {
#line 133 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								break;
#line 502 "game-view.c"
							}
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp27_ = game_view_get_x_offset (self);
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp28_ = _tmp27_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp29_ = x;
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp30_ = game_view_get_tile_size (self);
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp31_ = _tmp30_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							tile_x = _tmp28_ + (_tmp29_ * (_tmp31_ + GAME_VIEW_GRID_WIDTH));
#line 136 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp32_ = game_view_get_y_offset (self);
#line 136 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp33_ = _tmp32_;
#line 136 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp34_ = y;
#line 136 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp35_ = game_view_get_tile_size (self);
#line 136 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp36_ = _tmp35_;
#line 136 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							tile_y = _tmp33_ + (_tmp34_ * (_tmp36_ + GAME_VIEW_GRID_WIDTH));
#line 137 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp37_ = self->priv->pixmaps;
#line 137 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp37__length1 = self->priv->pixmaps_length1;
#line 137 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp37__length2 = self->priv->pixmaps_length2;
#line 137 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp38_ = x;
#line 137 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp39_ = y;
#line 137 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp40_ = _tmp37_[(_tmp38_ * _tmp37__length2) + _tmp39_];
#line 137 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp41_ = game_view_get_tile_size (self);
#line 137 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp42_ = _tmp41_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							texture_x = (_tmp40_ % 8) * _tmp42_;
#line 138 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp43_ = self->priv->pixmaps;
#line 138 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp43__length1 = self->priv->pixmaps_length1;
#line 138 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp43__length2 = self->priv->pixmaps_length2;
#line 138 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp44_ = x;
#line 138 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp45_ = y;
#line 138 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp46_ = _tmp43_[(_tmp44_ * _tmp43__length2) + _tmp45_];
#line 138 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp47_ = game_view_get_tile_size (self);
#line 138 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp48_ = _tmp47_;
#line 138 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							texture_y = (_tmp46_ / 8) * _tmp48_;
#line 140 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							cairo_matrix_init_identity (&matrix);
#line 141 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp49_ = texture_x;
#line 141 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp50_ = tile_x;
#line 141 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp51_ = texture_y;
#line 141 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp52_ = tile_y;
#line 141 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							cairo_matrix_translate (&matrix, (gdouble) (_tmp49_ - _tmp50_), (gdouble) (_tmp51_ - _tmp52_));
#line 142 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp53_ = self->priv->tiles_pattern;
#line 142 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp54_ = matrix;
#line 142 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							cairo_pattern_set_matrix (_tmp53_, &_tmp54_);
#line 143 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp55_ = cr;
#line 143 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp56_ = self->priv->tiles_pattern;
#line 143 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							cairo_set_source (_tmp55_, _tmp56_);
#line 144 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp57_ = cr;
#line 144 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp58_ = tile_x;
#line 144 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp59_ = tile_y;
#line 144 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp60_ = game_view_get_tile_size (self);
#line 144 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp61_ = _tmp60_;
#line 144 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp62_ = game_view_get_tile_size (self);
#line 144 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp63_ = _tmp62_;
#line 144 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							cairo_rectangle (_tmp57_, (gdouble) _tmp58_, (gdouble) _tmp59_, (gdouble) _tmp61_, (gdouble) _tmp63_);
#line 145 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp64_ = cr;
#line 145 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							cairo_fill (_tmp64_);
#line 608 "game-view.c"
						}
					}
				}
			}
		}
	}
#line 149 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp65_ = cr;
#line 149 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	cairo_set_source_rgba (_tmp65_, 1.0, 1.0, 1.0, 1.0);
#line 150 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp66_ = cr;
#line 150 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	cairo_set_operator (_tmp66_, CAIRO_OPERATOR_DIFFERENCE);
#line 151 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp67_ = cr;
#line 151 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	cairo_set_line_width (_tmp67_, (gdouble) GAME_VIEW_GRID_WIDTH);
#line 627 "game-view.c"
	{
		gint i = 0;
#line 152 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		i = 1;
#line 632 "game-view.c"
		{
			gboolean _tmp68_ = FALSE;
#line 152 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp68_ = TRUE;
#line 152 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			while (TRUE) {
#line 639 "game-view.c"
				gint _tmp70_ = 0;
				cairo_t* _tmp71_ = NULL;
				gint _tmp72_ = 0;
				gint _tmp73_ = 0;
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
				gint _tmp78_ = 0;
				cairo_t* _tmp79_ = NULL;
				gint _tmp80_ = 0;
				gint _tmp81_ = 0;
				cairo_t* _tmp82_ = NULL;
				gint _tmp83_ = 0;
				gint _tmp84_ = 0;
				gint _tmp85_ = 0;
				gint _tmp86_ = 0;
				gint _tmp87_ = 0;
				gint _tmp88_ = 0;
				gint _tmp89_ = 0;
				cairo_t* _tmp90_ = NULL;
				gint _tmp91_ = 0;
				gint _tmp92_ = 0;
#line 152 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				if (!_tmp68_) {
#line 665 "game-view.c"
					gint _tmp69_ = 0;
#line 152 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					_tmp69_ = i;
#line 152 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					i = _tmp69_ + 1;
#line 671 "game-view.c"
				}
#line 152 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp68_ = FALSE;
#line 152 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp70_ = i;
#line 152 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				if (!(_tmp70_ < 8)) {
#line 152 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					break;
#line 681 "game-view.c"
				}
#line 154 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp71_ = cr;
#line 154 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp72_ = game_view_get_x_offset (self);
#line 154 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp73_ = _tmp72_;
#line 154 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp74_ = i;
#line 154 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp75_ = game_view_get_board_size (self);
#line 154 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp76_ = _tmp75_;
#line 154 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp77_ = game_view_get_y_offset (self);
#line 154 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp78_ = _tmp77_;
#line 154 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				cairo_move_to (_tmp71_, (_tmp73_ + ((_tmp74_ * _tmp76_) / 8)) - 0.5, (gdouble) _tmp78_);
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp79_ = cr;
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp80_ = game_view_get_board_size (self);
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp81_ = _tmp80_;
#line 155 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				cairo_rel_line_to (_tmp79_, (gdouble) 0, (gdouble) _tmp81_);
#line 157 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp82_ = cr;
#line 157 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp83_ = game_view_get_x_offset (self);
#line 157 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp84_ = _tmp83_;
#line 157 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp85_ = game_view_get_y_offset (self);
#line 157 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp86_ = _tmp85_;
#line 157 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp87_ = i;
#line 157 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp88_ = game_view_get_board_size (self);
#line 157 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp89_ = _tmp88_;
#line 157 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				cairo_move_to (_tmp82_, (gdouble) _tmp84_, (_tmp86_ + ((_tmp87_ * _tmp89_) / 8)) - 0.5);
#line 158 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp90_ = cr;
#line 158 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp91_ = game_view_get_board_size (self);
#line 158 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp92_ = _tmp91_;
#line 158 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				cairo_rel_line_to (_tmp90_, (gdouble) _tmp92_, (gdouble) 0);
#line 735 "game-view.c"
			}
		}
	}
#line 161 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp93_ = cr;
#line 161 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp94_ = game_view_get_x_offset (self);
#line 161 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp95_ = _tmp94_;
#line 161 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp96_ = game_view_get_y_offset (self);
#line 161 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp97_ = _tmp96_;
#line 161 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp98_ = game_view_get_board_size (self);
#line 161 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp99_ = _tmp98_;
#line 161 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp100_ = game_view_get_board_size (self);
#line 161 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp101_ = _tmp100_;
#line 161 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	cairo_rectangle (_tmp93_, _tmp95_ + 0.5, _tmp97_ + 0.5, (gdouble) (_tmp99_ - 1), (gdouble) (_tmp101_ - 1));
#line 163 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp102_ = cr;
#line 163 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	cairo_stroke (_tmp102_);
#line 165 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	result = FALSE;
#line 165 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 767 "game-view.c"
}


static void game_view_load_theme (GameView* self, cairo_t* c) {
	gint width = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint height = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GError * _inner_error_ = NULL;
#line 168 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 168 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_if_fail (c != NULL);
#line 170 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = game_view_get_tile_size (self);
#line 170 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	width = _tmp1_ * 8;
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp2_ = game_view_get_tile_size (self);
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp3_ = _tmp2_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	height = _tmp3_ * 4;
#line 795 "game-view.c"
	{
		RsvgHandle* h = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		RsvgHandle* _tmp6_ = NULL;
		cairo_matrix_t m = {0};
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		cairo_t* _tmp11_ = NULL;
		cairo_matrix_t _tmp12_ = {0};
		cairo_t* _tmp13_ = NULL;
#line 175 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp4_ = game_view_get_theme (self);
#line 175 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp5_ = _tmp4_;
#line 175 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp6_ = rsvg_handle_new_from_file (_tmp5_, &_inner_error_);
#line 175 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		h = _tmp6_;
#line 175 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 819 "game-view.c"
			goto __catch0_g_error;
		}
#line 177 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		cairo_matrix_init_identity (&m);
#line 178 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_object_get (h, "width", &_tmp7_, NULL);
#line 178 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp8_ = _tmp7_;
#line 178 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_object_get (h, "height", &_tmp9_, NULL);
#line 178 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp10_ = _tmp9_;
#line 178 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		cairo_matrix_scale (&m, ((gdouble) width) / _tmp8_, ((gdouble) height) / _tmp10_);
#line 179 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp11_ = c;
#line 179 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp12_ = m;
#line 179 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		cairo_set_matrix (_tmp11_, &_tmp12_);
#line 180 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp13_ = c;
#line 180 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		rsvg_handle_render_cairo (h, _tmp13_);
#line 182 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_g_object_unref0 (h);
#line 182 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		return;
#line 848 "game-view.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
#line 173 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		e = _inner_error_;
#line 173 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_inner_error_ = NULL;
#line 173 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_g_error_free0 (e);
#line 860 "game-view.c"
	}
	__finally0:
#line 173 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 173 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 173 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 173 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		return;
#line 871 "game-view.c"
	}
	{
		GdkPixbuf* p = NULL;
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		GdkPixbuf* _tmp16_ = NULL;
		cairo_t* _tmp17_ = NULL;
		GdkPixbuf* _tmp18_ = NULL;
		cairo_t* _tmp19_ = NULL;
#line 191 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp14_ = game_view_get_theme (self);
#line 191 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp15_ = _tmp14_;
#line 191 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp16_ = gdk_pixbuf_new_from_file_at_scale (_tmp15_, width, height, FALSE, &_inner_error_);
#line 191 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		p = _tmp16_;
#line 191 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 891 "game-view.c"
			goto __catch1_g_error;
		}
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp17_ = c;
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp18_ = p;
#line 192 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		gdk_cairo_set_source_pixbuf (_tmp17_, _tmp18_, (gdouble) 0, (gdouble) 0);
#line 193 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp19_ = c;
#line 193 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		cairo_paint (_tmp19_);
#line 189 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_g_object_unref0 (p);
#line 906 "game-view.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		GError* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
#line 189 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		e = _inner_error_;
#line 189 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_inner_error_ = NULL;
#line 197 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp20_ = game_view_get_theme (self);
#line 197 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp21_ = _tmp20_;
#line 197 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp22_ = e;
#line 197 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp23_ = _tmp22_->message;
#line 197 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_warning ("game-view.vala:197: Failed to load theme %s: %s", _tmp21_, _tmp23_);
#line 189 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_g_error_free0 (e);
#line 932 "game-view.c"
	}
	__finally1:
#line 189 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 189 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 189 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 189 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		return;
#line 943 "game-view.c"
	}
}


void game_view_redraw (GameView* self) {
#line 201 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 203 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 953 "game-view.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 206 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 206 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return _data1_;
#line 962 "game-view.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 206 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 971 "game-view.c"
		GameView* self;
#line 206 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		self = _data1_->self;
#line 206 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_g_object_unref0 (self);
#line 206 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_slice_free (Block1Data, _data1_);
#line 979 "game-view.c"
	}
}


static gboolean ___lambda4_ (Block1Data* _data1_) {
	GameView* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self = _data1_->self;
#line 249 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->flip_final_result_now = TRUE;
#line 250 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = _data1_->x;
#line 250 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = _data1_->y;
#line 250 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	game_view_square_changed_cb (self, _tmp0_, _tmp1_);
#line 252 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	result = FALSE;
#line 252 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 1003 "game-view.c"
}


static gboolean ____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda4_ (self);
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 1012 "game-view.c"
}


static void game_view_square_changed_cb (GameView* self, gint x, gint y) {
	Block1Data* _data1_;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint pixmap = 0;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Player _tmp6_ = 0;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
	Game* _tmp52_ = NULL;
	Game* _tmp53_ = NULL;
	gboolean _tmp54_ = FALSE;
#line 206 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 206 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 206 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_data1_->_ref_count_ = 1;
#line 206 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_data1_->self = g_object_ref (self);
#line 206 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = x;
#line 206 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_data1_->x = _tmp0_;
#line 206 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = y;
#line 206 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_data1_->y = _tmp1_;
#line 208 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp2_ = game_view_get_game (self);
#line 208 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp3_ = _tmp2_;
#line 208 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp4_ = _data1_->x;
#line 208 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp5_ = _data1_->y;
#line 208 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp6_ = game_get_owner (_tmp3_, _tmp4_, _tmp5_);
#line 208 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp7_ = game_view_get_pixmap (self, _tmp6_);
#line 208 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	pixmap = _tmp7_;
#line 211 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp9_ = self->priv->flip_final_result_now;
#line 211 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp9_) {
#line 1071 "game-view.c"
		Game* _tmp10_ = NULL;
		Game* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
#line 211 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp10_ = game_view_get_game (self);
#line 211 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp11_ = _tmp10_;
#line 211 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp12_ = game_is_complete (_tmp11_);
#line 211 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp8_ = _tmp12_;
#line 1083 "game-view.c"
	} else {
#line 211 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp8_ = FALSE;
#line 1087 "game-view.c"
	}
#line 211 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp8_) {
#line 1091 "game-view.c"
		gint n = 0;
		gint _tmp13_ = 0;
		Game* _tmp14_ = NULL;
		Game* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		Player winning_color = 0;
		Player losing_color = 0;
		gint n_winning_tiles = 0;
		Game* _tmp19_ = NULL;
		Game* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint n_losing_tiles = 0;
		Game* _tmp23_ = NULL;
		Game* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp13_ = _data1_->y;
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp14_ = game_view_get_game (self);
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp15_ = _tmp14_;
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp16_ = game_get_width (_tmp15_);
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp17_ = _tmp16_;
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp18_ = _data1_->x;
#line 213 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		n = (_tmp13_ * _tmp17_) + _tmp18_;
#line 214 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		winning_color = PLAYER_LIGHT;
#line 215 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		losing_color = PLAYER_DARK;
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp19_ = game_view_get_game (self);
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp20_ = _tmp19_;
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp21_ = game_get_n_light_tiles (_tmp20_);
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp22_ = _tmp21_;
#line 216 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		n_winning_tiles = _tmp22_;
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp23_ = game_view_get_game (self);
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp24_ = _tmp23_;
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp25_ = game_get_n_dark_tiles (_tmp24_);
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp26_ = _tmp25_;
#line 217 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		n_losing_tiles = _tmp26_;
#line 218 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp27_ = n_losing_tiles;
#line 218 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp28_ = n_winning_tiles;
#line 218 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (_tmp27_ > _tmp28_) {
#line 1159 "game-view.c"
			gint t = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
#line 220 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			winning_color = PLAYER_DARK;
#line 221 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			losing_color = PLAYER_LIGHT;
#line 222 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp29_ = n_winning_tiles;
#line 222 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			t = _tmp29_;
#line 223 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp30_ = n_losing_tiles;
#line 223 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			n_winning_tiles = _tmp30_;
#line 224 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp31_ = t;
#line 224 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			n_losing_tiles = _tmp31_;
#line 1180 "game-view.c"
		}
#line 226 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp32_ = n;
#line 226 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp33_ = n_winning_tiles;
#line 226 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (_tmp32_ < _tmp33_) {
#line 1188 "game-view.c"
			Player _tmp34_ = 0;
			gint _tmp35_ = 0;
#line 227 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp34_ = winning_color;
#line 227 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp35_ = game_view_get_pixmap (self, _tmp34_);
#line 227 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			pixmap = _tmp35_;
#line 1197 "game-view.c"
		} else {
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
#line 228 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp36_ = n;
#line 228 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp37_ = n_winning_tiles;
#line 228 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp38_ = n_losing_tiles;
#line 228 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			if (_tmp36_ < (_tmp37_ + _tmp38_)) {
#line 1210 "game-view.c"
				Player _tmp39_ = 0;
				gint _tmp40_ = 0;
#line 229 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp39_ = losing_color;
#line 229 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp40_ = game_view_get_pixmap (self, _tmp39_);
#line 229 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				pixmap = _tmp40_;
#line 1219 "game-view.c"
			} else {
				gint _tmp41_ = 0;
#line 231 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp41_ = game_view_get_pixmap (self, PLAYER_NONE);
#line 231 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				pixmap = _tmp41_;
#line 1226 "game-view.c"
			}
		}
	} else {
		gboolean _tmp42_ = FALSE;
		gboolean _tmp43_ = FALSE;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp43_ = self->priv->flip_final_result_now;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (_tmp43_) {
#line 1236 "game-view.c"
			Game* _tmp44_ = NULL;
			Game* _tmp45_ = NULL;
			gboolean _tmp46_ = FALSE;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp44_ = game_view_get_game (self);
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp45_ = _tmp44_;
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp46_ = game_is_complete (_tmp45_);
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp42_ = !_tmp46_;
#line 1248 "game-view.c"
		} else {
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp42_ = FALSE;
#line 1252 "game-view.c"
		}
#line 234 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (_tmp42_) {
#line 236 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			self->priv->flip_final_result_now = FALSE;
#line 1258 "game-view.c"
		}
	}
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp47_ = _data1_->x;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp48_ = _data1_->y;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp49_ = pixmap;
#line 239 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	game_view_set_square (self, _tmp47_, _tmp48_, _tmp49_);
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp52_ = game_view_get_game (self);
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp53_ = _tmp52_;
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp54_ = game_is_complete (_tmp53_);
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp54_) {
#line 1277 "game-view.c"
		Game* _tmp55_ = NULL;
		Game* _tmp56_ = NULL;
		gint _tmp57_ = 0;
		gint _tmp58_ = 0;
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp55_ = game_view_get_game (self);
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp56_ = _tmp55_;
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp57_ = game_get_n_light_tiles (_tmp56_);
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp58_ = _tmp57_;
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp51_ = _tmp58_ > 0;
#line 1292 "game-view.c"
	} else {
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp51_ = FALSE;
#line 1296 "game-view.c"
	}
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp51_) {
#line 1300 "game-view.c"
		Game* _tmp59_ = NULL;
		Game* _tmp60_ = NULL;
		gint _tmp61_ = 0;
		gint _tmp62_ = 0;
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp59_ = game_view_get_game (self);
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp60_ = _tmp59_;
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp61_ = game_get_n_dark_tiles (_tmp60_);
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp62_ = _tmp61_;
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp50_ = _tmp62_ > 0;
#line 1315 "game-view.c"
	} else {
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp50_ = FALSE;
#line 1319 "game-view.c"
	}
#line 241 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp50_) {
#line 247 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, ____lambda4__gsource_func, block1_data_ref (_data1_), block1_data_unref);
#line 1325 "game-view.c"
	}
#line 206 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	block1_data_unref (_data1_);
#line 206 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_data1_ = NULL;
#line 1331 "game-view.c"
}


static gboolean _game_view_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = game_view_animate_cb ((GameView*) self);
#line 271 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 1340 "game-view.c"
}


static void game_view_set_square (GameView* self, gint x, gint y, gint pixmap) {
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
#line 257 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = self->priv->pixmaps;
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0__length1 = self->priv->pixmaps_length1;
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0__length2 = self->priv->pixmaps_length2;
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = x;
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp2_ = y;
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp4_ = pixmap;
#line 259 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp3_ == _tmp4_) {
#line 260 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		return;
#line 1388 "game-view.c"
	}
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp6_ = pixmap;
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp6_ == 0) {
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp5_ = TRUE;
#line 1396 "game-view.c"
	} else {
		gint* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gint _tmp7__length2 = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp7_ = self->priv->pixmaps;
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp7__length1 = self->priv->pixmaps_length1;
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp7__length2 = self->priv->pixmaps_length2;
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp8_ = x;
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp9_ = y;
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp5_ = _tmp10_ == 0;
#line 1418 "game-view.c"
	}
#line 262 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp5_) {
#line 1422 "game-view.c"
		gint* _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gint _tmp11__length2 = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
#line 263 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp11_ = self->priv->pixmaps;
#line 263 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp11__length1 = self->priv->pixmaps_length1;
#line 263 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp11__length2 = self->priv->pixmaps_length2;
#line 263 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp12_ = x;
#line 263 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp13_ = y;
#line 263 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp14_ = pixmap;
#line 263 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_] = _tmp14_;
#line 263 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp15_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
#line 1446 "game-view.c"
	} else {
		gint _tmp16_ = 0;
		gint* _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		gint _tmp17__length2 = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		guint _tmp29_ = 0U;
#line 266 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp16_ = pixmap;
#line 266 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp17_ = self->priv->pixmaps;
#line 266 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp17__length1 = self->priv->pixmaps_length1;
#line 266 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp17__length2 = self->priv->pixmaps_length2;
#line 266 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp18_ = x;
#line 266 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp19_ = y;
#line 266 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp20_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
#line 266 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (_tmp16_ > _tmp20_) {
#line 1472 "game-view.c"
			gint* _tmp21_ = NULL;
			gint _tmp21__length1 = 0;
			gint _tmp21__length2 = 0;
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp21_ = self->priv->pixmaps;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp21__length1 = self->priv->pixmaps_length1;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp21__length2 = self->priv->pixmaps_length2;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp22_ = x;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp23_ = y;
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp24_ = _tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_];
#line 267 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_] = _tmp24_ + 1;
#line 1493 "game-view.c"
		} else {
			gint* _tmp25_ = NULL;
			gint _tmp25__length1 = 0;
			gint _tmp25__length2 = 0;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp25_ = self->priv->pixmaps;
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp25__length1 = self->priv->pixmaps_length1;
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp25__length2 = self->priv->pixmaps_length2;
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp26_ = x;
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp27_ = y;
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
#line 269 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_] = _tmp28_ - 1;
#line 1515 "game-view.c"
		}
#line 270 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp29_ = self->priv->animate_timeout;
#line 270 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (_tmp29_ == ((guint) 0)) {
#line 1521 "game-view.c"
			guint _tmp30_ = 0U;
#line 271 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp30_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GAME_VIEW_PIXMAP_FLIP_DELAY, _game_view_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 271 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			self->priv->animate_timeout = _tmp30_;
#line 1527 "game-view.c"
		}
	}
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp31_ = game_view_get_x_offset (self);
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp32_ = _tmp31_;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp33_ = x;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp34_ = game_view_get_tile_size (self);
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp35_ = _tmp34_;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp36_ = game_view_get_y_offset (self);
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp37_ = _tmp36_;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp38_ = y;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp39_ = game_view_get_tile_size (self);
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp40_ = _tmp39_;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp41_ = game_view_get_tile_size (self);
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp42_ = _tmp41_;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp43_ = game_view_get_tile_size (self);
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp44_ = _tmp43_;
#line 273 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	gtk_widget_queue_draw_area ((GtkWidget*) self, _tmp32_ + (_tmp33_ * ((gint) (_tmp35_ + GAME_VIEW_GRID_WIDTH))), _tmp37_ + (_tmp38_ * ((gint) (_tmp40_ + GAME_VIEW_GRID_WIDTH))), _tmp42_, _tmp44_);
#line 1560 "game-view.c"
}


static gboolean game_view_animate_cb (GameView* self) {
	gboolean result = FALSE;
	gboolean animating = FALSE;
	gboolean _tmp17_ = FALSE;
#line 276 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 278 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	animating = FALSE;
#line 1572 "game-view.c"
	{
		gint x = 0;
#line 280 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		x = 0;
#line 1577 "game-view.c"
		{
			gboolean _tmp0_ = FALSE;
#line 280 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp0_ = TRUE;
#line 280 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			while (TRUE) {
#line 1584 "game-view.c"
				gint _tmp2_ = 0;
#line 280 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				if (!_tmp0_) {
#line 1588 "game-view.c"
					gint _tmp1_ = 0;
#line 280 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					_tmp1_ = x;
#line 280 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					x = _tmp1_ + 1;
#line 1594 "game-view.c"
				}
#line 280 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp0_ = FALSE;
#line 280 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp2_ = x;
#line 280 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				if (!(_tmp2_ < 8)) {
#line 280 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					break;
#line 1604 "game-view.c"
				}
				{
					gint y = 0;
#line 282 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					y = 0;
#line 1610 "game-view.c"
					{
						gboolean _tmp3_ = FALSE;
#line 282 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
						_tmp3_ = TRUE;
#line 282 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
						while (TRUE) {
#line 1617 "game-view.c"
							gint _tmp5_ = 0;
							gint old = 0;
							gint* _tmp6_ = NULL;
							gint _tmp6__length1 = 0;
							gint _tmp6__length2 = 0;
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint* _tmp12_ = NULL;
							gint _tmp12__length1 = 0;
							gint _tmp12__length2 = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
#line 282 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							if (!_tmp3_) {
#line 1637 "game-view.c"
								gint _tmp4_ = 0;
#line 282 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp4_ = y;
#line 282 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								y = _tmp4_ + 1;
#line 1643 "game-view.c"
							}
#line 282 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp3_ = FALSE;
#line 282 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp5_ = y;
#line 282 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							if (!(_tmp5_ < 8)) {
#line 282 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								break;
#line 1653 "game-view.c"
							}
#line 284 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp6_ = self->priv->pixmaps;
#line 284 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp6__length1 = self->priv->pixmaps_length1;
#line 284 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp6__length2 = self->priv->pixmaps_length2;
#line 284 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp7_ = x;
#line 284 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp8_ = y;
#line 284 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
#line 284 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							old = _tmp9_;
#line 285 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp10_ = x;
#line 285 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp11_ = y;
#line 285 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							game_view_square_changed_cb (self, _tmp10_, _tmp11_);
#line 286 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp12_ = self->priv->pixmaps;
#line 286 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp12__length1 = self->priv->pixmaps_length1;
#line 286 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp12__length2 = self->priv->pixmaps_length2;
#line 286 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp13_ = x;
#line 286 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp14_ = y;
#line 286 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp15_ = _tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_];
#line 286 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp16_ = old;
#line 286 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							if (_tmp15_ != _tmp16_) {
#line 287 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								animating = TRUE;
#line 1693 "game-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 291 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp17_ = animating;
#line 291 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (!_tmp17_) {
#line 293 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		self->priv->animate_timeout = (guint) 0;
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		result = FALSE;
#line 294 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		return result;
#line 1711 "game-view.c"
	}
#line 297 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	result = TRUE;
#line 297 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 1717 "game-view.c"
}


static gint game_view_get_pixmap (GameView* self, Player color) {
	gint result = 0;
	Player _tmp0_ = 0;
#line 300 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 302 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = color;
#line 302 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	switch (_tmp0_) {
#line 1730 "game-view.c"
		default:
#line 302 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		case PLAYER_NONE:
#line 1734 "game-view.c"
		{
#line 306 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			result = 0;
#line 306 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			return result;
#line 1740 "game-view.c"
		}
#line 302 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		case PLAYER_DARK:
#line 1744 "game-view.c"
		{
#line 308 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			result = 1;
#line 308 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			return result;
#line 1750 "game-view.c"
		}
#line 302 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		case PLAYER_LIGHT:
#line 1754 "game-view.c"
		{
#line 310 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			result = 31;
#line 310 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			return result;
#line 1760 "game-view.c"
		}
	}
}


static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	GameView * self;
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
#line 314 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self = (GameView*) base;
#line 314 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 316 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = event;
#line 316 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = _tmp0_->button;
#line 316 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp1_ == ((guint) 1)) {
#line 1781 "game-view.c"
		gint x = 0;
		GdkEventButton* _tmp2_ = NULL;
		gdouble _tmp3_ = 0.0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint y = 0;
		GdkEventButton* _tmp8_ = NULL;
		gdouble _tmp9_ = 0.0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gint _tmp17_ = 0;
#line 318 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp2_ = event;
#line 318 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp3_ = _tmp2_->x;
#line 318 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp4_ = game_view_get_x_offset (self);
#line 318 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp5_ = _tmp4_;
#line 318 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp6_ = game_view_get_tile_size (self);
#line 318 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp7_ = _tmp6_;
#line 318 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		x = ((gint) (_tmp3_ - _tmp5_)) / (_tmp7_ + GAME_VIEW_GRID_WIDTH);
#line 319 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp8_ = event;
#line 319 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp9_ = _tmp8_->y;
#line 319 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp10_ = game_view_get_y_offset (self);
#line 319 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp11_ = _tmp10_;
#line 319 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp12_ = game_view_get_tile_size (self);
#line 319 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp13_ = _tmp12_;
#line 319 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		y = ((gint) (_tmp9_ - _tmp11_)) / (_tmp13_ + GAME_VIEW_GRID_WIDTH);
#line 320 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp17_ = x;
#line 320 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (_tmp17_ >= 0) {
#line 1832 "game-view.c"
			gint _tmp18_ = 0;
#line 320 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp18_ = x;
#line 320 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp16_ = _tmp18_ < 8;
#line 1838 "game-view.c"
		} else {
#line 320 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp16_ = FALSE;
#line 1842 "game-view.c"
		}
#line 320 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (_tmp16_) {
#line 1846 "game-view.c"
			gint _tmp19_ = 0;
#line 320 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp19_ = y;
#line 320 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp15_ = _tmp19_ >= 0;
#line 1852 "game-view.c"
		} else {
#line 320 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp15_ = FALSE;
#line 1856 "game-view.c"
		}
#line 320 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (_tmp15_) {
#line 1860 "game-view.c"
			gint _tmp20_ = 0;
#line 320 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp20_ = y;
#line 320 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp14_ = _tmp20_ < 8;
#line 1866 "game-view.c"
		} else {
#line 320 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp14_ = FALSE;
#line 1870 "game-view.c"
		}
#line 320 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		if (_tmp14_) {
#line 1874 "game-view.c"
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
#line 321 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp21_ = x;
#line 321 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			_tmp22_ = y;
#line 321 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			g_signal_emit_by_name (self, "move", _tmp21_, _tmp22_);
#line 1883 "game-view.c"
		}
	}
#line 324 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	result = TRUE;
#line 324 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 1890 "game-view.c"
}


static gint game_view_get_tile_size (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 37 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 39 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 39 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 39 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp2_ = MIN (_tmp0_ / 8, _tmp1_ / ((gint) 8));
#line 39 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	result = _tmp2_ - GAME_VIEW_GRID_WIDTH;
#line 39 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 1911 "game-view.c"
}


static gint game_view_get_x_offset (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 45 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 47 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 47 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = game_view_get_tile_size (self);
#line 47 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp2_ = _tmp1_;
#line 47 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	result = (_tmp0_ - (8 * (_tmp2_ + GAME_VIEW_GRID_WIDTH))) / 2;
#line 47 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 1932 "game-view.c"
}


static gint game_view_get_y_offset (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 53 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 55 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 55 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = game_view_get_tile_size (self);
#line 55 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp2_ = _tmp1_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	result = (_tmp0_ - (8 * (_tmp2_ + GAME_VIEW_GRID_WIDTH))) / 2;
#line 55 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 1953 "game-view.c"
}


static gint game_view_get_board_size (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 59 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 59 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = game_view_get_tile_size (self);
#line 59 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 59 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	result = (_tmp1_ + GAME_VIEW_GRID_WIDTH) * 8;
#line 59 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 1971 "game-view.c"
}


Game* game_view_get_game (GameView* self) {
	Game* result;
	Game* _tmp0_ = NULL;
#line 72 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 72 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_game;
#line 72 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	result = _tmp0_;
#line 72 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 1986 "game-view.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 77 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 1993 "game-view.c"
}


static void _game_view_square_changed_cb_game_square_changed (Game* _sender, gint x, gint y, gpointer self) {
#line 80 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	game_view_square_changed_cb ((GameView*) self, x, y);
#line 2000 "game-view.c"
}


void game_view_set_game (GameView* self, Game* value) {
	Game* _tmp0_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
#line 73 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 75 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_game;
#line 75 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp0_ != NULL) {
#line 2015 "game-view.c"
		Game* _tmp1_ = NULL;
#line 76 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp1_ = self->priv->_game;
#line 76 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 2021 "game-view.c"
	}
#line 77 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp2_ = value;
#line 77 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 77 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 77 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->_game = _tmp3_;
#line 78 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp4_ = self->priv->_game;
#line 78 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (_tmp4_ != NULL) {
#line 2035 "game-view.c"
		Game* _tmp5_ = NULL;
#line 80 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		_tmp5_ = self->priv->_game;
#line 80 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_signal_connect_object (_tmp5_, "square-changed", (GCallback) _game_view_square_changed_cb_game_square_changed, self, 0);
#line 2041 "game-view.c"
		{
			gint x = 0;
#line 81 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
			x = 0;
#line 2046 "game-view.c"
			{
				gboolean _tmp6_ = FALSE;
#line 81 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				_tmp6_ = TRUE;
#line 81 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
				while (TRUE) {
#line 2053 "game-view.c"
					gint _tmp8_ = 0;
#line 81 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					if (!_tmp6_) {
#line 2057 "game-view.c"
						gint _tmp7_ = 0;
#line 81 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
						_tmp7_ = x;
#line 81 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
						x = _tmp7_ + 1;
#line 2063 "game-view.c"
					}
#line 81 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					_tmp6_ = FALSE;
#line 81 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					_tmp8_ = x;
#line 81 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
					if (!(_tmp8_ < 8)) {
#line 81 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
						break;
#line 2073 "game-view.c"
					}
					{
						gint y = 0;
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
						y = 0;
#line 2079 "game-view.c"
						{
							gboolean _tmp9_ = FALSE;
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							_tmp9_ = TRUE;
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
							while (TRUE) {
#line 2086 "game-view.c"
								gint _tmp11_ = 0;
								gint* _tmp12_ = NULL;
								gint _tmp12__length1 = 0;
								gint _tmp12__length2 = 0;
								gint _tmp13_ = 0;
								gint _tmp14_ = 0;
								Game* _tmp15_ = NULL;
								gint _tmp16_ = 0;
								gint _tmp17_ = 0;
								Player _tmp18_ = 0;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								if (!_tmp9_) {
#line 2101 "game-view.c"
									gint _tmp10_ = 0;
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
									_tmp10_ = y;
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
									y = _tmp10_ + 1;
#line 2107 "game-view.c"
								}
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp9_ = FALSE;
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp11_ = y;
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								if (!(_tmp11_ < 8)) {
#line 82 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
									break;
#line 2117 "game-view.c"
								}
#line 83 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp12_ = self->priv->pixmaps;
#line 83 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp12__length1 = self->priv->pixmaps_length1;
#line 83 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp12__length2 = self->priv->pixmaps_length2;
#line 83 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp13_ = x;
#line 83 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp14_ = y;
#line 83 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp15_ = self->priv->_game;
#line 83 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp16_ = x;
#line 83 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp17_ = y;
#line 83 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp18_ = game_get_owner (_tmp15_, _tmp16_, _tmp17_);
#line 83 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp19_ = game_view_get_pixmap (self, _tmp18_);
#line 83 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_] = _tmp19_;
#line 83 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
								_tmp20_ = _tmp12_[(_tmp13_ * _tmp12__length2) + _tmp14_];
#line 2143 "game-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 85 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	game_view_redraw (self);
#line 73 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_object_notify ((GObject *) self, "game");
#line 2155 "game-view.c"
}


const gchar* game_view_get_theme (GameView* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 92 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 92 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_theme;
#line 92 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	result = _tmp0_;
#line 92 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	return result;
#line 2170 "game-view.c"
}


void game_view_set_theme (GameView* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 93 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 93 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp0_ = value;
#line 93 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 93 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_g_free0 (self->priv->_theme);
#line 93 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->_theme = _tmp1_;
#line 93 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
#line 93 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->tiles_pattern = NULL;
#line 93 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 93 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_object_notify ((GObject *) self, "theme");
#line 2195 "game-view.c"
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_return_if_fail (n_param_values == 3);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		data1 = closure->data;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		data2 = param_values->data[0].v_pointer;
#line 2214 "game-view.c"
	} else {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		data1 = param_values->data[0].v_pointer;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		data2 = closure->data;
#line 2220 "game-view.c"
	}
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
#line 2226 "game-view.c"
}


static void game_view_class_init (GameViewClass * klass) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	game_view_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	((GtkWidgetClass *) klass)->get_request_mode = game_view_real_get_request_mode;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	((GtkWidgetClass *) klass)->get_preferred_width_for_height = game_view_real_get_preferred_width_for_height;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	((GtkWidgetClass *) klass)->get_preferred_width = game_view_real_get_preferred_width;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	((GtkWidgetClass *) klass)->get_preferred_height = game_view_real_get_preferred_height;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	((GtkWidgetClass *) klass)->draw = game_view_real_draw;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	((GtkWidgetClass *) klass)->button_press_event = game_view_real_button_press_event;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME, g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME, g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	g_signal_new ("move", TYPE_GAME_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
#line 2259 "game-view.c"
}


static void game_view_instance_init (GameView * self) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv = GAME_VIEW_GET_PRIVATE (self);
#line 21 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->render_size = (guint) 0;
#line 22 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->tiles_pattern = NULL;
#line 28 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->animate_timeout = (guint) 0;
#line 33 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->flip_final_result_now = FALSE;
#line 69 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->_game = NULL;
#line 89 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->_theme = NULL;
#line 2278 "game-view.c"
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
#line 22 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
#line 25 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
#line 69 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 89 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	_g_free0 (self->priv->_theme);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
#line 2296 "game-view.c"
}


GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}


static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	switch (property_id) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		case GAME_VIEW_GAME:
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_value_set_object (value, game_view_get_game (self));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		break;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		case GAME_VIEW_THEME:
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		g_value_set_string (value, game_view_get_theme (self));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		break;
#line 2329 "game-view.c"
		default:
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		break;
#line 2335 "game-view.c"
	}
}


static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
	switch (property_id) {
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		case GAME_VIEW_GAME:
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		game_view_set_game (self, g_value_get_object (value));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		break;
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		case GAME_VIEW_THEME:
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		game_view_set_theme (self, g_value_get_string (value));
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		break;
#line 2357 "game-view.c"
		default:
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 12 "/home/mcatanzaro/jhbuild/checkout/iagno/src/game-view.vala"
		break;
#line 2363 "game-view.c"
	}
}



