#!/bin/sh

TMPDIR=`mktemp -d`
[ -d $TMPDIR ] || exit 1
TMPDIR=`cd $TMPDIR > /dev/null && pwd`
VERSION=$2
VERSION_FLAT=`echo $VERSION | sed "s/\./_/g"`
MAJOR=`echo $VERSION | cut -d . -f 1,2`

mkdir $TMPDIR/icu4j-$MAJOR
echo "Unzipping..."
unzip -qq -d $TMPDIR/icu4j-$MAJOR $3
rm -f $3
echo "Tar'ing..."
tar -c -z -f ../icu4j-${MAJOR}_$VERSION.orig.tar.gz -C $TMPDIR icu4j-$MAJOR
rm -fr $TMPDIR
echo ../icu4j-${MAJOR}_$VERSION.orig.tar.gz
