U = fakewebpack-unpacked
B = fakewebpack-build

ORIG_GIF = $(wildcard $U/jquery-ui/themes/smoothness/images/*.gif.real)
ORIG_PNG = $(wildcard $U/jquery-ui/themes/smoothness/images/*.png.real)
ORIG_FONT = $(wildcard $U/font-awesome/fonts/fontawesome-webfont.*.real)

STATIC_RESOURCES = \
  $(ORIG_GIF:$U/jquery-ui/themes/smoothness/images/%.gif.real=$B/docs/%.gif) \
  $(ORIG_PNG:$U/jquery-ui/themes/smoothness/images/%.png.real=$B/docs/%.png) \
  $(ORIG_FONT:$U/font-awesome/fonts/fontawesome-webfont.%.real=$B/docs/fontawesome-webfont.%)

PACKED_GIF = $U/jquery-ui/themes/smoothness/images/animated-overlay.gif
PACKED_PNG = $(ORIG_PNG:%.png.real=%.png)
PACKED_FONT = $(ORIG_FONT:%.real=%)

ALL = \
  $U/docs/webpack/bootstrap\ 133a151519d479576449 \
  $U/font-awesome/css/font-awesome.css \
  $U/font-awesome/css/font-awesome.css?9b7c \
  $(PACKED_FONT) \
  $U/jquery-ui/themes/smoothness/jquery-ui.min.css \
  $U/jquery-ui/themes/smoothness/jquery-ui.min.css?fe0d \
  $(PACKED_GIF) \
  $(PACKED_PNG) \
  $U/jupyter-js-widgets/package.json \
  $U/jupyter-js-widgets/css/widgets.css \
  $U/jupyter-js-widgets/css/widgets.min.css \
  $U/jupyter-js-widgets/css/widgets.min.css?ce57 \
  $U/widgetsnbextension/webpack/bootstrap\ f5345dd1af7cf96a8788 \
  $U/widgetsnbextension/package.json \
  $(STATIC_RESOURCES) \
  $B/prep.stamp

all: $(ALL)


%/package.json: %/package.json.real
	printf "module.exports = $$(cat "$<");" > "$@"


$(PACKED_GIF) $(PACKED_PNG) $(PACKED_FONT):
	echo 'module.exports = __webpack_public_path__ + "$(notdir $@)";' > "$@"


$U/jupyter-js-widgets/css/widgets.css:
	cd $U/jupyter-js-widgets && lessc --include-path=node_modules ./less/widgets.less ./css/widgets.css

PACK_CSS = 	mkdir -p "$(dir $@)" && cleancss --source-map --skip-restructuring -o "$@.tmp" "$<" \
	&& ./css-loader-pack.py < "$@.tmp" > "$@" \
	&& rm -f "$@.tmp"

$U/jquery-ui/themes/smoothness/jquery-ui.min.css: /usr/share/javascript/jquery-ui-themes/smoothness/jquery-ui.css
	$(PACK_CSS)

$U/font-awesome/css/font-awesome.css: /usr/share/fonts-font-awesome/css/font-awesome.css
	$(PACK_CSS)

%.min.css: %.css
	$(PACK_CSS)


$U/jupyter-js-widgets/css/widgets.min.css?%: style-loader.js.m4
	mkdir -p "$(dir $@)" && m4 -DNODE_PATH=./../.. -DCSS_INPUT=./widgets.min.css "$<" > "$@"

$U/font-awesome/css/font-awesome.css?%: style-loader.js.m4
	mkdir -p "$(dir $@)" && m4 -DNODE_PATH=./../.. -DCSS_INPUT=./font-awesome.css "$<" > "$@"

$U/jquery-ui/themes/smoothness/jquery-ui.min.css?%: style-loader.js.m4
	mkdir -p "$(dir $@)" && m4 -DNODE_PATH=./../../../../.. -DCSS_INPUT=./jquery-ui.min.css "$<" > "$@"

$U/docs/webpack/bootstrap%: webpack-bootstrap.js.m4
	mkdir -p "$(dir $@)" && m4 -DWEBPACK_PUBLIC_PATH=./_static/built/ "$<" > "$@"

$U/widgetsnbextension/webpack/bootstrap%: webpack-bootstrap.js.m4
	mkdir -p "$(dir $@)" && m4 -DWEBPACK_PUBLIC_PATH= "$<" > "$@"


$B/prep.stamp: $(STATIC_RESOURCES)
	touch "$@"

$B/docs/%.gif: $U/jquery-ui/themes/smoothness/images/%.gif.real
	mkdir -p "$(dir $@)" && cp "$<" "$@"

$B/docs/%.png: $U/jquery-ui/themes/smoothness/images/%.png.real
	mkdir -p "$(dir $@)" && cp -P "$<" "$@"

$B/docs/fontawesome-webfont.%: $U/font-awesome/fonts/fontawesome-webfont.%.real
	mkdir -p "$(dir $@)" && cp -P "$<" "$@"


clean:
	rm -rf $(ALL)

.PHONY: all clean
