/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.naming.CompositeName;
import javax.naming.Name;

public class NamingException
extends Exception {
    protected Name resolvedName = null;
    protected Object resolvedObj = null;
    protected Name remainingName = null;
    protected Throwable rootException = null;
    private static final long serialVersionUID = -1299181962103167177L;

    public NamingException() {
    }

    public NamingException(String string) {
        super(string);
    }

    public void appendRemainingComponent(String string) {
        if (string != null) {
            try {
                if (this.remainingName == null) {
                    this.remainingName = new CompositeName();
                }
                this.remainingName.add(string);
            }
            catch (NamingException namingException) {
                throw new IllegalArgumentException(namingException.toString());
            }
        }
    }

    public void appendRemainingName(Name name) {
        if (name == null) {
            return;
        }
        if (this.remainingName != null) {
            try {
                this.remainingName.addAll(name);
            }
            catch (NamingException namingException) {
                throw new IllegalArgumentException(namingException.toString());
            }
        } else {
            this.remainingName = (Name)name.clone();
        }
    }

    public String getExplanation() {
        return this.getMessage();
    }

    public Name getRemainingName() {
        return this.remainingName;
    }

    public Name getResolvedName() {
        return this.resolvedName;
    }

    public Object getResolvedObj() {
        return this.resolvedObj;
    }

    public Throwable getRootCause() {
        return this.rootException;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        if (this.rootException != null) {
            String string = super.toString();
            PrintStream printStream2 = printStream;
            synchronized (printStream2) {
                printStream.print(String.valueOf(string) + (string.endsWith(".") ? "" : ".") + "  Root exception is ");
                this.rootException.printStackTrace(printStream);
            }
        } else {
            super.printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        if (this.rootException != null) {
            String string = super.toString();
            PrintWriter printWriter2 = printWriter;
            synchronized (printWriter2) {
                printWriter.print(String.valueOf(string) + (string.endsWith(".") ? "" : ".") + "  Root exception is ");
                this.rootException.printStackTrace(printWriter);
            }
        } else {
            super.printStackTrace(printWriter);
        }
    }

    public void setRemainingName(Name name) {
        this.remainingName = name != null ? (Name)name.clone() : null;
    }

    public void setResolvedName(Name name) {
        this.resolvedName = name != null ? (Name)name.clone() : null;
    }

    public void setResolvedObj(Object object) {
        this.resolvedObj = object;
    }

    public void setRootCause(Throwable throwable) {
        if (throwable != this) {
            this.rootException = throwable;
        }
    }

    public String toString() {
        String string = super.toString();
        if (this.rootException != null) {
            string = String.valueOf(string) + " [Root exception is " + this.rootException + "]";
        }
        if (this.remainingName != null) {
            string = String.valueOf(string) + "; remaining name '" + this.remainingName + "'";
        }
        return string;
    }

    public String toString(boolean bl) {
        if (!bl || this.resolvedObj == null) {
            return this.toString();
        }
        return String.valueOf(this.toString()) + "; resolved object " + this.resolvedObj;
    }
}

