# -*- cperl -*-
use strict;
use warnings;
use 5.010;

use Test::More;   # see done_testing()
use Path::Tiny;
use Test::File::Contents;

use Dpkg::Copyright::Scanner;


# global tests
my $dir = path('t/scanner/examples/') ;
my $temp = Path::Tiny->tempfile ;

foreach my $in ($dir->children(qr/\.in$/)) {
    my $test_name = $in->basename('.in');
    next if @ARGV and not grep { $test_name =~ /$_/; } @ARGV;
    note("scanning $test_name");
    my $out_name =  $test_name. '.out';
    my $out = $dir->child($out_name);
    print_copyright( in => $in, out => $temp , quiet => 1);

    files_eq_or_diff($out, $temp, "check $test_name copyright");
}


done_testing();
