/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbml {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html SBML converter to convert a model's units to SI units.
 * 
 * @htmlinclude libsbml-facility-only-warning.html
 *
 * This SBML converter converts the units in a model to base SI units,
 * namely metre, kilogram, second, Ampere, Kelvin, mole and candela.
 *
 * Unit conversion will only be performed on models that are fully unit
 * consistent; that is, all objects have associated units, and there are no
 * literal numbers with no units specified.  In the case of an SBML
 * Level&nbsp;3 model involving math expressions, this means that the @c
 * timeUnits attribute on the Model object must be set, and if there are
 * any reactions in the model, the @c extentUnits attribute on the Model
 * object must also be set.
 *
 * This converter has the additional Boolean property 'removeUnusedUnits'
 * that can be used to tell the converter whether to remove any
 * UnitDefinition objects that are not referred to, after conversion is
 * complete.  You can set this value by adding the property using
 * @verbatim
prop.addOption('removeUnusedUnits', false);
@endverbatim
 * The converter's default behavior is to remove the unused
 * UnitDefinition objects in the model.
 *
 * @see SBMLFunctionDefinitionConverter
 * @see SBMLLevelVersionConverter
 * @see SBMLRuleConverter
 * @see SBMLStripPackageConverter
 * @see SBMLUnitsConverter
 */

public class SBMLUnitsConverter : SBMLConverter {
	private HandleRef swigCPtr;
	
	internal SBMLUnitsConverter(IntPtr cPtr, bool cMemoryOwn) : base(libsbmlPINVOKE.SBMLUnitsConverter_SWIGUpcast(cPtr), cMemoryOwn)
	{
		//super(libsbmlPINVOKE.SBMLUnitsConverterUpcast(cPtr), cMemoryOwn);
		swigCPtr = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(SBMLUnitsConverter obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (SBMLUnitsConverter obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~SBMLUnitsConverter() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_SBMLUnitsConverter(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  public static void init() {
    libsbmlPINVOKE.SBMLUnitsConverter_init();
  }

  
/**
   * Creates a new SBMLUnitsConverter object.
   */ public
 SBMLUnitsConverter() : this(libsbmlPINVOKE.new_SBMLUnitsConverter__SWIG_0(), true) {
  }

  
/**
   * Copy constructor; creates a copy of an SBMLUnitsConverter
   * object.
   *
   * @param obj the SBMLUnitsConverter object to copy.
   */ public
 SBMLUnitsConverter(SBMLUnitsConverter obj) : this(libsbmlPINVOKE.new_SBMLUnitsConverter__SWIG_1(SBMLUnitsConverter.getCPtr(obj)), true) {
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
  }

  
/**
   * Creates and returns a deep copy of this SBMLUnitsConverter
   * object.
   * 
   * @return a (deep) copy of this converter.
   */ public
 SBMLConverter clone() {
    IntPtr cPtr = libsbmlPINVOKE.SBMLUnitsConverter_clone(swigCPtr);
    SBMLUnitsConverter ret = (cPtr == IntPtr.Zero) ? null : new SBMLUnitsConverter(cPtr, true);
    return ret;
  }

  
/**
   * Returns @c true if this converter object's properties match the given
   * properties. 
   *
   * A typical use of this method involves creating a ConversionProperties
   * object, setting the options desired, and then calling this method on
   * an SBMLUnitsConverter object to find out if the object's
   * property values match the given ones.  This method is also used by
   * SBMLConverterRegistry::getConverterFor(@if java ConversionProperties props@endif)
   * to search across all registered converters for one matching particular
   * properties.
   * 
   * @param props the properties to match.
   * 
   * @return @c true if this converter's properties match, @c false
   * otherwise.
   */ public
 bool matchesProperties(ConversionProperties props) {
    bool ret = libsbmlPINVOKE.SBMLUnitsConverter_matchesProperties(swigCPtr, ConversionProperties.getCPtr(props));
    if (libsbmlPINVOKE.SWIGPendingException.Pending) throw libsbmlPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  
/**
   * Convers the units in the model to base SI units; namely metre,
   * kilogram, second, Ampere, Kelvin, mole and candela.
   * 
   * @return  integer value indicating the success/failure of the operation.
   * @if clike The value is drawn from the enumeration
   * #OperationReturnValues_t. @endif The possible values are:
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_INVALID_OBJECT LIBSBML_INVALID_OBJECT @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_CONV_CONVERSION_NOT_AVAILABLE LIBSBML_CONV_CONVERSION_NOT_AVAILABLE @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_CONV_INVALID_SRC_DOCUMENT LIBSBML_CONV_INVALID_SRC_DOCUMENT @endlink
   * @li @link libsbmlcs.libsbml.LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED @endlink
   */ public
 int convert() {
    int ret = libsbmlPINVOKE.SBMLUnitsConverter_convert(swigCPtr);
    return ret;
  }

  
/**
   * Returns the default properties of this converter.
   * 
   * A given converter exposes one or more properties that can be adjusted
   * in order to influence the behavior of the converter.  This method
   * returns the @em default property settings for this converter.  It is
   * meant to be called in order to discover all the settings for the
   * converter object.
   *
   * @return the ConversionProperties object describing the default properties
   * for this converter.
   */ public
 ConversionProperties getDefaultProperties() {
    ConversionProperties ret = new ConversionProperties(libsbmlPINVOKE.SBMLUnitsConverter_getDefaultProperties(swigCPtr), true);
    return ret;
  }

}

}
