/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File SimpleEditorObserver.h
// Sylvie Thepaut - ECMWF Sep 99

#ifndef SimpleEditorObserver_H
#define SimpleEditorObserver_H

// Headers

// #ifndef   machine_H
// #include <machine.h>
// #endif

// Forward declarations

// class ostream;
// typedef class _Pvts os_typespec; // Remove if not persistant

//

class Request;
class SimpleEditor;

#ifndef IconObject_H
#include "IconObject.h"
#endif

class SimpleEditorObserver {
public:

// -- Exceptions
	// None

// -- Contructors
	SimpleEditorObserver(SimpleEditor&);

// -- Destructor

	virtual ~SimpleEditorObserver(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods
	virtual bool reset(const Request&) = 0;
	virtual bool update(const Request&) = 0;
	virtual bool apply(const Request&) = 0;

	virtual void set(Request&);

	virtual void show();
	virtual void hide();
	virtual void edit(IconObjectH);


// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	SimpleEditor& owner_;
	IconObjectH   currentObject_;

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	SimpleEditorObserver(const SimpleEditorObserver&);
	SimpleEditorObserver& operator=(const SimpleEditorObserver&);

// -- Members
	// None

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const SimpleEditorObserver& p)
	//	{ p.print(s); return s; }

};

inline void destroy(SimpleEditorObserver**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(SimpleEditorObserver);
//#endif

#endif
