/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "netcdfcpp.h"

#include <math.h>

#include <QDebug>
#include <QFile>
#include <QTextStream>

#include "MvQObstatCurveData.h"

#include "MvKeyProfile.h"

MvQObstatCurveData::MvQObstatCurveData()
{
	itemNum_=0;
	//filePath_="/var/tmp/cgr/metview/Local/OBSTAT/scat_0001_DCDA_synop_pressure.200809";
}

MvQObstatCurveData::~MvQObstatCurveData()
{
	clearData();
}

void MvQObstatCurveData::clearData()
{
	itemNum_=0;

}

void MvQObstatCurveData::setFileName(QString fileName)
{
	fileName_=fileName;
	clearData();
	loadData();

	//QString nc="/var/tmp/cgr/metview/Local/OBSTAT/scat.nc";
	//blocks_[0]->items().at(0)->writeMatrixToNc(nc);
}

void MvQObstatCurveData::loadData()
{	
	path_ = (fileName_.toStdString());
	decode();

	itemNum_=data_.size();

	/*
	QFile file(fileName_);

	if(file.open(QFile::ReadOnly | QFile::Text) == false)
	{
		return;
	}

	QTextStream in(&file);

	itemNum_=0;

	while (!in.atEnd() ) 
	{
        	QString line = in.readLine();
		while(line.contains("#BEGIN STATDEF") == false)
		{
			line = in.readLine();
		}
		
		QStringList lst;
		lst << line;

		while(line.contains("#BEGIN STATDEF") == false)
		{
			lst << in.readLine();
		}
		
	}	




	while (!in.atEnd()) 
	{
        	QString line = in.readLine();
		while(line.contains("#BEGIN STATDEF") == false)
		{
			line = in.readLine();
		}
		
		line = in.readLine();
		if(!line.contains("comment="))
		{
			return;
		}

		//Comment
		QString comment;
		QStringList lst=line.split("comment=",QString::SkipEmptyParts);
		if(lst.count() == 2)
			comment=lst[1];

		
		//Statkind
		int statkind=-1;
		lst=line.split("statkind=",QString::SkipEmptyParts);
		if(lst.count() == 2)
			statkind=lst[1].toInt();

		if(statKind != 1)
		{
			continue;
		}


		//=========================================
		// Statkind 1
		//=========================================

			
	

		if(!lst.contains("HEADER=") || lst.count() != 11)
		{
			return;
		}

		MvQCurveBlock *block= new MvQCurveBlock;
		
		//Start date
		QString dstr=lst[1];
		dstr+=lst[2];
		block->setStartDate(QDateTime::fromString(dstr,"yyyyMMddHHmm"));
		
		//End date
		dstr=lst[3];
		dstr+=lst[4];
		block->setEndDate(QDateTime::fromString(dstr,"yyyyMMddHHmm"));
		
		//
		block->setSatId(lst[5].toInt());
		block->setSensorId(lst[6].toInt());
		int itemNum=lst[7].toInt();
		int channelNum=lst[8].toInt();
		int flagNum=lst[9].toInt();
		int areaNum=lst[10].toInt();
		//block->setItemNum(lst[7].toInt());
		//block->setChannelNum(lst[8].toInt());
		//block->setFlagNum(lst[9].toInt());
		//block->setAreaNum(lst[10].toInt());


		line = in.readLine();
		if(!line.contains("title="))
		{
			return;
		}

		lst=line.split("title=",QString::SkipEmptyParts);
		qDebug() << "title:" << lst << lst.last();
		if(lst.count() > 0)
		{	
			block->setTitle(lst.last().simplified());
		}
		qDebug() << "title:" << block->title();

		line = in.readLine();
		lst=line.split(" ",QString::SkipEmptyParts);		
		if(!lst.contains("press="))
		{
			return;
		}

		if(lst[1] == "yes")
		{
		
		}
		
		//X params		
		line = in.readLine();
		lst=line.split(" ",QString::SkipEmptyParts);
		qDebug() << line;
		qDebug() << lst;
		
		if(lst.count() != itemNum)
		{
			return;
		}
	
		QStringList paramsX=lst;

		//Y params	
		line = in.readLine();
		lst=line.split(" ",QString::SkipEmptyParts);
		if(lst.count() != itemNum)
		{
			return;
		}
	
		QStringList paramsY=lst;
	
		//Flags	
		line = in.readLine();
		lst=line.split(" ",QString::SkipEmptyParts);
		if(lst.count() != flagNum)
		{
			return;
		}

		QStringList flags=lst;

		//Areas
		line = in.readLine();
		lst=line.split(" ",QString::SkipEmptyParts);
		if(lst.count() != areaNum)
		{
			return;
		}

		block->setAreaNames(lst);
		
		//read titles
		QMap<int,QString> titles;
	
		for(int i=0; i < itemNum; i++)
		{
			line = in.readLine();
			titles[paramsX[i].toInt()]=line.simplified();

			line = in.readLine();
			titles[paramsY[i].toInt()]=line.simplified();
		}

		block->setParams(titles);

		int totalItemNum=itemNum*flagNum*areaNum*channelNum;
		
		for(int i=0; i < totalItemNum; i++)
		{
			//BEGIN SCATITEM
			line = in.readLine();
			lst=line.split(" ",QString::SkipEmptyParts);
			if(lst[0] != "BEGIN" && lst[1] != "SCATITEM" && lst.count() != 13)
			{
				return;
			}
			
			MvQCurveItem *item=new MvQCurveItem;

			item->setArea(lst[2].toInt());
			item->setLevel(lst[3].toInt());	
			item->setFlag(lst[4].toInt());	
			item->setParamX(lst[5].toInt());	
			item->setParamY(lst[6].toInt());			
			item->setStartX(lst[7].toFloat());			
			item->setStartY(lst[8].toFloat());	
			item->setDX(lst[9].toFloat());			
			item->setDY(lst[10].toFloat());	
			item->setNX(lst[11].toInt());			
			item->setNY(lst[12].toInt());		

			item->setTitleX(titles[item->paramX()]);
			item->setTitleY(titles[item->paramY()]);
			

			//GLOBAL STATS
			line = in.readLine();
			lst=line.split(" ",QString::SkipEmptyParts);
			if(lst[0] != "GLOBAL" && lst[1] != "STATS" && lst.count() != 13)
			{
				return;
			}

			item->setMaxX(lst[2].toFloat());
			item->setMinX(lst[3].toFloat());	
			item->setMaxY(lst[4].toFloat());
			item->setMinY(lst[5].toFloat());
			item->setSumX(lst[6].toFloat());
			item->setSumY(lst[7].toFloat());
			item->setSumXX(lst[8].toFloat());
			item->setSumYY(lst[9].toFloat());
			item->setSumXY(lst[10].toFloat());
			item->setSumDiffSqr(lst[11].toFloat());
			item->setSourceDataNum(lst[12].toInt());

			int num=0;
			int totalNum=item->nX()*item->nY(); 
			float *data = new float[totalNum];

			while(num != totalNum)
			{
				line = in.readLine();
				lst=line.split(" ",QString::SkipEmptyParts);
				foreach(QString s,lst)
				{
					data[num]=s.toFloat();
					num++;
				}
			}

			item->setData(data);
	
			block->addItem(item);	

			line = in.readLine();
			lst=line.split(" ",QString::SkipEmptyParts);
			if(!line.contains("END SCATITEM"))
			{
				return;
			}
			itemNum_++;
		}

		blocks_ << block;  
	}

	file.close();
*/

}

void MvQObstatCurveData::getStatItem(QList<MvQObstatCurveItem*> &items)
{
	map<string,StatDef>::iterator it=data_.find("1");
	StatDef &def=it->second; 

	for(int i=0; i < def.data_.size(); i++)
	{		
		MvQObstatCurveItem *item = new MvQObstatCurveItem;

		getStatColumnData(1, &(def.data_[i]),"Pressure",item->data["y"]);
		getStatColumnData(1, &(def.data_[i]),"avg",item->data["avg"]);
		getStatColumnData(1, &(def.data_[i]),"rms",item->data["rms"]);
		getStatColumnData(1, &(def.data_[i]),"number",item->data["num"]);
		
		QList<float> minV;
		QList<float> maxV;

		getStatColumnData(1, &(def.data_[i]),"min",minV); 
		qSort(minV.begin(),minV.end());
		
		getStatColumnData(1, &(def.data_[i]),"max",maxV);
		qSort(maxV.begin(),maxV.end());
		
		item->min=minV.first();
		item->max=maxV.last();

		items << item;
	}
}

void MvQObstatCurveData::loadKeyProfile(MvKeyProfile *prof)
{
	//prof->addKey(new MvKey("Index","Index"));	
	//prof->addKey(new MvKey("Satellite","Satellite"));
	//prof->addKey(new MvKey("Sensor","Sensor"));
	//prof->addKey(new MvKey("Area","Area"));
	//prof->addKey(new MvKey("Level","Level"));
	//prof->addKey(new MvKey("Flag","Flag"));
	//prof->addKey(new MvKey("ParX","ParX"));
	//prof->addKey(new MvKey("ParY","ParY"));


	prof->addKey(new MvKey("Type","Type"));
	prof->addKey(new MvKey("Comment","Comment"));
	prof->addKey(new MvKey("Param","Param"));
	prof->addKey(new MvKey("Flags","Flags"));
	prof->addKey(new MvKey("Area","Area"));

	string str;
	int i=0;
	for(map<string,StatDef>::iterator it=data_.begin(); it != data_.end() ; it++)
	{
			//qDebug() << QString::fromStdString(it->first);

			StatDef *def=&(it->second); 

			//foreach(MvQCurveItem* item, block->items())
		//{
			//prof->key("Index")->addValue(QString::number(i).toStdString());
		//	prof->key("Area")->addValue(QString::number(item->area()).toStdString());
		//	prof->key("Level")->addValue(QString::number(item->level()).toStdString());
		//	prof->key("Flag")->addValue(QString::number(item->flag()).toStdString());
		//	prof->key("ParX")->addValue(QString::number(item->paramX()).toStdString());
		//	prof->key("ParY")->addValue(QString::number(item->paramY()).toStdString());

			prof->key("Type")->addValue(def->definitions_["statkind"].at(0));
			
			catStringVector(def->definitions_["areaNSEW"],str);	
			prof->key("Area")->addValue(str);

			catStringVector(def->definitions_["comment"],str);
			prof->key("Comment")->addValue(str);

			catStringVector(def->definitions_["params"],str);
			prof->key("Param")->addValue(str);

			catStringVector(def->definitions_["flagfilter"],str);
			prof->key("Flags")->addValue(str);

//prof->key("Area")->addValue(def->definitions_["areaNSEW"].at(0));

			//prof->key("Comment")->addValue(def->definitions_["comment"].at(0));
			//prof->key("Param")->addValue(def->definitions_["params"].at(0));

			/*prof->key("Start date")->addValue(block->startDate().toString("yyyy-MM-dd hh:mm ").toStdString());
			prof->key("End date")->addValue(block->endDate().toString("yyyy-MM-dd hh:mm ").toStdString());
			prof->key("Satellite")->addValue(QString::number(block->satId()).toStdString());
			prof->key("Sensor")->addValue(QString::number(block->sensorId()).toStdString());
			prof->key("Title")->addValue(block->title().toStdString());*/
		
		//}
	}	
}


void MvQObstatCurveData::catStringVector(vector<string> &vec,string &str)
{
	str.clear();
	for(vector<string>::iterator it=vec.begin(); it !=vec.end();it++)
	{
		if(it != vec.begin())
			str+=" ";
		str+=*it;
	}
}


void MvQObstatCurveData::getStatColumnData(int statKind, StatItem* item,string colName, QList<float> &vec)
{
	if(item->columns_.find(colName) != item->columns_.end())
	{
		int colId=item->columns_[colName];
		for(int row=0; row < item->rows_.size(); row++)
		{
			vec << item->rows_[row].at(colId);
		}
	}	
}
