/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "FolderInfo.h"

#include <iostream>
#include <fstream>

#include "Folder.h"
#include "IconInfo.h"
#include "Request.h"
#include "Tokenizer.h"

std::string FolderInfo::fileName_="._mv_iconlist_";

FolderInfo::FolderInfo(Folder *folder) : 
	folder_(folder),
	checkWasDone_(false)
{
  	read();
  
}	
	
void FolderInfo::read()
{
	info_.clear(); //need to delete the objects!!!
	
	std::string path=folder_->path().add(fileName_).str();
	ifstream in(path.c_str());

	if(!in.good())
	  	return;
		
	string line;
	
	//getline(in,line);

	Tokenizer parse(",");
	vector<string> n;
	int cnt=0;
	std::size_t pos;
	
	while(getline(in,line))
	{
		parse(line,n);
		if(n.size() >= 4)
		{
			int x,y;
		  	istringstream issX(n[0]);
 			issX >> x;
 			istringstream issY(n[1]);
 			issY >> y;
 				
			pos=line.find("," + n[3]);
			string name=line.substr(pos+1);
						
		  	info_[name]=new IconInfo(n[2],x,y);
		}
				
		n.clear();
		cnt++;
	}
	
	in.close();
}



void FolderInfo::write()
{
	//Remove non-existing icons from info
	check();
	
	std::string path=folder_->path().add(fileName_).str();
	ofstream out;				
	out.open(path.c_str());
	if(!out.good())
	  	return;

	for(map<string,IconInfo*>::iterator it=info_.begin(); it != info_.end();it++)
	{	
		out  << it->second->x() <<  "," << it->second->y() << "," << it->second->type() << "," << it->first << endl; 
	}		

	out.close();
}


void FolderInfo::check()
{
 	//For performance reason we do it only once!  	
  	if(checkWasDone_)
	  	return;
  
  	const std::map<std::string,IconObjectH>& kids=folder_->kids();
	std::vector<std::string> removeVec;
	for(map<std::string,IconInfo*>::iterator it=info_.begin(); it != info_.end();it++)
	{
	  	if(kids.find(it->first) == kids.end())
		{
		  	removeVec.push_back(it->first);
		}
	}
	
	for(std::vector<std::string>::const_iterator it=removeVec.begin(); it != removeVec.end(); it++)
	{
	  	remove(*it);
	}
	
	checkWasDone_=true;
}

IconInfo* FolderInfo::add(const string &name, IconInfo* info)
{	
	info_[name]=info;	
	return info;
}  

IconInfo* FolderInfo::add(const string &name, const string& type)
{
	IconInfo* info=find(name);
	
	if(!info)
	{  	
		info=new IconInfo(type);
		info_[name]=info;
	}
	
	return info;
}  

IconInfo* FolderInfo::add(const string &name, const Request& dotInfo)
{
	IconInfo* info=new IconInfo(dotInfo);
		
	info_[name]=info;
	
	return info;
}


IconInfo* FolderInfo::find(const string& name)
{
	map<string,IconInfo*>::iterator it=info_.find(name);
	return (it != info_.end())?it->second:0;
}	

void FolderInfo::remove(const string &name)
{
	map<string,IconInfo*>::iterator it=info_.find(name);
	if(it != info_.end())
		info_.erase(it);
}  

void FolderInfo::rename(const string &oldName,const string &newName)
{
	map<string,IconInfo*>::iterator it=info_.find(oldName);
	if(it != info_.end())
	{	
	  	IconInfo *data=it->second;
	  	info_.erase(it);
		info_[newName]=data;
	}	
}  

bool FolderInfo::read(const Path& folderPath,std::map<std::string,std::string>& icons)
{
	std::string path=folderPath.add(fileName_).str();
	ifstream in(path.c_str());

	if(!in.good())
	  	return false;
		
	string line;
	
	//getline(in,line);

	Tokenizer parse(",");
	vector<string> n;
	std::size_t pos;
	
	while(getline(in,line))
	{
		parse(line,n);
		if(n.size() >= 4)
		{
			pos=line.find("," + n[3]);			
			icons[line.substr(pos+1)]=n[2];
		}
				
		n.clear();
	}
	
	in.close();
	
	return true;
}

