/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef TemplateDrawer_H
#include "TemplateDrawer.h"
#endif

#ifndef Editor_H
#include "Editor.h"
#endif

#ifndef XMLabel_H
#include "XMLabel.h"
#endif


#ifndef EditorDrawer_H
#include "EditorDrawer.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif


#ifndef IconClass_H
#include "IconClass.h"
#endif
#ifndef FolderWindow_H
#include "FolderWindow.h"
#endif

#ifndef IconFactory_H
#include "IconFactory.h"
#endif
#ifndef EditorDrawerFactory_H
#include "EditorDrawerFactory.h"
#endif

#ifndef Folder_H
#include "Folder.h"
#endif

#ifndef SyncFolders_H
#include "SyncFolders.h"
#endif

#include <Drag.h>

TemplateDrawer::TemplateDrawer(InternalEditor& e):
	XEditorDrawer<UITemplateDrawer_c>(e), 
		FolderViewer(Folder::folder("templates",e.iconClass().defaultName())) 
{
	FolderViewer::install(drag_);

	// Synchronize those two folders

	SyncFolders::add(
	
		  Folder::folder("templates",
			  	e.iconClass().defaultName()),

		  Folder::folder("system_templates",
			  	e.iconClass().defaultName(),false)
	
	);
}

TemplateDrawer::~TemplateDrawer()
{
}

void TemplateDrawer::edit(IconObject* o)
{	  	  
}


Widget TemplateDrawer::menu()
{	  	
	if ( current_.size() == 0 ) 	 
		return menu2_;
	 
	XtSetSensitive(replace_, current_.size() == 1); 
	XtSetSensitive(merge_, current_.size() == 1);

	return menu1_;
}

void TemplateDrawer::makeCB(Widget, XtPointer data) 
{
	// create a template in the template Folder... 

	string name = folder_->fullName() + "/" + editor_.current()->name();
	editor_.copy(name);
}

bool TemplateDrawer::accept(IconObject *o)
{
	return o->iconClass().isSubClassOf(editor_.iconClass());
}

void TemplateDrawer:: replaceCB( Widget, XtPointer ) 
{
 	for(vector<IconObjectH>::iterator j = current_.begin() ; 
		j != current_.end(); ++j)
			editor_.replace(*j);
}

void TemplateDrawer::mergeCB( Widget, XtPointer )
{	   
 	for(vector<IconObjectH>::iterator j = current_.begin() ; 
		j != current_.end(); ++j)
			editor_.merge(*j);

}

void TemplateDrawer::editCB( Widget, XtPointer )
{	       
 	for(vector<IconObjectH>::iterator j = current_.begin() ; 
		j != current_.end(); ++j)
			(*j)->edit();
}

void TemplateDrawer::openFolderCB( Widget, XtPointer )
{	
	folder_->open();
}

bool TemplateDrawer::fill(int pass)
{
	Folder* system = Folder::folder("system_templates",
			  	editor_.iconClass().defaultName(),false);

	switch(pass)
	{
		case 0:
			// Try system 
			SyncFolders::sync(folder_,system);
			return true;

		case 1:
			// Make a default one ????
			return true;

		default:
			return false;
	}
	
}

static EditorDrawerMaker<TemplateDrawer,InternalEditor> maker(1);

