#!/bin/sh
# Simple wrapper script used to start mkgmap-splitter in Debian
set -e

# Override to a specific one using $JAVACMD
ALTERNATIVE_JDK="`readlink -n -f /etc/alternatives/java`"

# Let's get the current architecture -- needed for multiarchified Java
ARCH="`dpkg --print-architecture`"

JAVA_CMDS="$JAVA_HOME/bin/java"
JAVA_CMDS="${JAVA_CMDS} /usr/lib/jvm/java-8-openjdk-$ARCH/bin/java"
JAVA_CMDS="${JAVA_CMDS} /usr/bin/java"

if [ -z "$JAVA_OPTS" -o $(echo "$JAVA_OPTS" | grep "\-Xmx" | wc -l) -eq 0 ]; then
   JAVA_OPTS="$JAVA_OPTS -Xmx2000m"
fi

if [ -z "${JAVACMD}" ]; then
    JAVACMD=/usr/lib/jvm/java-8-openjdk-$ARCH/bin/java

    for jcmd in $JAVA_CMDS; do
       if [ "z$ALTERNATIVE_JDK" = "z`readlink -n -f $jcmd`" ] && [ -z "${JAVACMD}" ]; then
          JAVACMD="$jcmd"
          break
       fi
    done
fi

if [ -z "${JAVACMD}" ]; then
    for jcmd in $JAVA_CMDS; do
       if [ -x "$jcmd" -a -z "${JAVACMD}" ]; then
          JAVACMD="$jcmd"
          break
       fi
    done
fi

if [ "$JAVACMD" ]; then
   echo "Using $JAVACMD to execute mkgmap-splitter."
   exec $JAVACMD $JAVA_OPTS -jar /usr/share/mkgmap-splitter/splitter.jar "$@"
else
   echo "No valid JVM found to run mkgmap-splitter."
   exit 1
fi
