"use strict";

var helpers = require("../../helpers/helpers");

exports["America/Cuiaba"] = {

	"guess:by:offset" : helpers.makeTestGuess("America/Cuiaba", { offset: true, expect: "America/Campo_Grande" }),

	"guess:by:abbr" : helpers.makeTestGuess("America/Cuiaba", { abbr: true, expect: "America/Campo_Grande" }),

	"1914" : helpers.makeTestYear("America/Cuiaba", [
		["1914-01-01T03:44:19+00:00", "23:59:59", "LMT", 13460 / 60],
		["1914-01-01T03:44:20+00:00", "23:44:20", "-04", 240]
	]),

	"1931" : helpers.makeTestYear("America/Cuiaba", [
		["1931-10-03T14:59:59+00:00", "10:59:59", "-04", 240],
		["1931-10-03T15:00:00+00:00", "12:00:00", "-03", 180]
	]),

	"1932" : helpers.makeTestYear("America/Cuiaba", [
		["1932-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1932-04-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1932-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["1932-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1933" : helpers.makeTestYear("America/Cuiaba", [
		["1933-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1933-04-01T03:00:00+00:00", "23:00:00", "-04", 240]
	]),

	"1949" : helpers.makeTestYear("America/Cuiaba", [
		["1949-12-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1949-12-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1950" : helpers.makeTestYear("America/Cuiaba", [
		["1950-04-16T03:59:59+00:00", "00:59:59", "-03", 180],
		["1950-04-16T04:00:00+00:00", "00:00:00", "-04", 240],
		["1950-12-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1950-12-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1951" : helpers.makeTestYear("America/Cuiaba", [
		["1951-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1951-04-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1951-12-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1951-12-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1952" : helpers.makeTestYear("America/Cuiaba", [
		["1952-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1952-04-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1952-12-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1952-12-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1953" : helpers.makeTestYear("America/Cuiaba", [
		["1953-03-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1953-03-01T03:00:00+00:00", "23:00:00", "-04", 240]
	]),

	"1963" : helpers.makeTestYear("America/Cuiaba", [
		["1963-12-09T03:59:59+00:00", "23:59:59", "-04", 240],
		["1963-12-09T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1964" : helpers.makeTestYear("America/Cuiaba", [
		["1964-03-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1964-03-01T03:00:00+00:00", "23:00:00", "-04", 240]
	]),

	"1965" : helpers.makeTestYear("America/Cuiaba", [
		["1965-01-31T03:59:59+00:00", "23:59:59", "-04", 240],
		["1965-01-31T04:00:00+00:00", "01:00:00", "-03", 180],
		["1965-03-31T02:59:59+00:00", "23:59:59", "-03", 180],
		["1965-03-31T03:00:00+00:00", "23:00:00", "-04", 240],
		["1965-12-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1965-12-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1966" : helpers.makeTestYear("America/Cuiaba", [
		["1966-03-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1966-03-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1966-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1966-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1967" : helpers.makeTestYear("America/Cuiaba", [
		["1967-03-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1967-03-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1967-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1967-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1968" : helpers.makeTestYear("America/Cuiaba", [
		["1968-03-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1968-03-01T03:00:00+00:00", "23:00:00", "-04", 240]
	]),

	"1985" : helpers.makeTestYear("America/Cuiaba", [
		["1985-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["1985-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1986" : helpers.makeTestYear("America/Cuiaba", [
		["1986-03-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["1986-03-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["1986-10-25T03:59:59+00:00", "23:59:59", "-04", 240],
		["1986-10-25T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1987" : helpers.makeTestYear("America/Cuiaba", [
		["1987-02-14T02:59:59+00:00", "23:59:59", "-03", 180],
		["1987-02-14T03:00:00+00:00", "23:00:00", "-04", 240],
		["1987-10-25T03:59:59+00:00", "23:59:59", "-04", 240],
		["1987-10-25T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1988" : helpers.makeTestYear("America/Cuiaba", [
		["1988-02-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["1988-02-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["1988-10-16T03:59:59+00:00", "23:59:59", "-04", 240],
		["1988-10-16T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1989" : helpers.makeTestYear("America/Cuiaba", [
		["1989-01-29T02:59:59+00:00", "23:59:59", "-03", 180],
		["1989-01-29T03:00:00+00:00", "23:00:00", "-04", 240],
		["1989-10-15T03:59:59+00:00", "23:59:59", "-04", 240],
		["1989-10-15T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1990" : helpers.makeTestYear("America/Cuiaba", [
		["1990-02-11T02:59:59+00:00", "23:59:59", "-03", 180],
		["1990-02-11T03:00:00+00:00", "23:00:00", "-04", 240],
		["1990-10-21T03:59:59+00:00", "23:59:59", "-04", 240],
		["1990-10-21T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1991" : helpers.makeTestYear("America/Cuiaba", [
		["1991-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["1991-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["1991-10-20T03:59:59+00:00", "23:59:59", "-04", 240],
		["1991-10-20T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1992" : helpers.makeTestYear("America/Cuiaba", [
		["1992-02-09T02:59:59+00:00", "23:59:59", "-03", 180],
		["1992-02-09T03:00:00+00:00", "23:00:00", "-04", 240],
		["1992-10-25T03:59:59+00:00", "23:59:59", "-04", 240],
		["1992-10-25T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1993" : helpers.makeTestYear("America/Cuiaba", [
		["1993-01-31T02:59:59+00:00", "23:59:59", "-03", 180],
		["1993-01-31T03:00:00+00:00", "23:00:00", "-04", 240],
		["1993-10-17T03:59:59+00:00", "23:59:59", "-04", 240],
		["1993-10-17T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1994" : helpers.makeTestYear("America/Cuiaba", [
		["1994-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["1994-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["1994-10-16T03:59:59+00:00", "23:59:59", "-04", 240],
		["1994-10-16T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1995" : helpers.makeTestYear("America/Cuiaba", [
		["1995-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["1995-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["1995-10-15T03:59:59+00:00", "23:59:59", "-04", 240],
		["1995-10-15T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1996" : helpers.makeTestYear("America/Cuiaba", [
		["1996-02-11T02:59:59+00:00", "23:59:59", "-03", 180],
		["1996-02-11T03:00:00+00:00", "23:00:00", "-04", 240],
		["1996-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["1996-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1997" : helpers.makeTestYear("America/Cuiaba", [
		["1997-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["1997-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["1997-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["1997-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1998" : helpers.makeTestYear("America/Cuiaba", [
		["1998-03-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1998-03-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1998-10-11T03:59:59+00:00", "23:59:59", "-04", 240],
		["1998-10-11T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1999" : helpers.makeTestYear("America/Cuiaba", [
		["1999-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["1999-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["1999-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["1999-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2000" : helpers.makeTestYear("America/Cuiaba", [
		["2000-02-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2000-02-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2000-10-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2000-10-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2001" : helpers.makeTestYear("America/Cuiaba", [
		["2001-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2001-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2001-10-14T03:59:59+00:00", "23:59:59", "-04", 240],
		["2001-10-14T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2002" : helpers.makeTestYear("America/Cuiaba", [
		["2002-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2002-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2002-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2002-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2003" : helpers.makeTestYear("America/Cuiaba", [
		["2003-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2003-02-16T03:00:00+00:00", "23:00:00", "-04", 240]
	]),

	"2004" : helpers.makeTestYear("America/Cuiaba", [
		["2004-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2004-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2005" : helpers.makeTestYear("America/Cuiaba", [
		["2005-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2005-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2005-10-16T03:59:59+00:00", "23:59:59", "-04", 240],
		["2005-10-16T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2006" : helpers.makeTestYear("America/Cuiaba", [
		["2006-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2006-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2006-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2006-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2007" : helpers.makeTestYear("America/Cuiaba", [
		["2007-02-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2007-02-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2007-10-14T03:59:59+00:00", "23:59:59", "-04", 240],
		["2007-10-14T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2008" : helpers.makeTestYear("America/Cuiaba", [
		["2008-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2008-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2008-10-19T03:59:59+00:00", "23:59:59", "-04", 240],
		["2008-10-19T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2009" : helpers.makeTestYear("America/Cuiaba", [
		["2009-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2009-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2009-10-18T03:59:59+00:00", "23:59:59", "-04", 240],
		["2009-10-18T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2010" : helpers.makeTestYear("America/Cuiaba", [
		["2010-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2010-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2010-10-17T03:59:59+00:00", "23:59:59", "-04", 240],
		["2010-10-17T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2011" : helpers.makeTestYear("America/Cuiaba", [
		["2011-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2011-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2011-10-16T03:59:59+00:00", "23:59:59", "-04", 240],
		["2011-10-16T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2012" : helpers.makeTestYear("America/Cuiaba", [
		["2012-02-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2012-02-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2012-10-21T03:59:59+00:00", "23:59:59", "-04", 240],
		["2012-10-21T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2013" : helpers.makeTestYear("America/Cuiaba", [
		["2013-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2013-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2013-10-20T03:59:59+00:00", "23:59:59", "-04", 240],
		["2013-10-20T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2014" : helpers.makeTestYear("America/Cuiaba", [
		["2014-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2014-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2014-10-19T03:59:59+00:00", "23:59:59", "-04", 240],
		["2014-10-19T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2015" : helpers.makeTestYear("America/Cuiaba", [
		["2015-02-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2015-02-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2015-10-18T03:59:59+00:00", "23:59:59", "-04", 240],
		["2015-10-18T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2016" : helpers.makeTestYear("America/Cuiaba", [
		["2016-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2016-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2016-10-16T03:59:59+00:00", "23:59:59", "-04", 240],
		["2016-10-16T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2017" : helpers.makeTestYear("America/Cuiaba", [
		["2017-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2017-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2017-10-15T03:59:59+00:00", "23:59:59", "-04", 240],
		["2017-10-15T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2018" : helpers.makeTestYear("America/Cuiaba", [
		["2018-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2018-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2018-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2018-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2019" : helpers.makeTestYear("America/Cuiaba", [
		["2019-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2019-02-17T03:00:00+00:00", "23:00:00", "-04", 240]
	])
};