'use strict';

var ASPIdiocy = XSS.ASPIdiocy = {
  _replaceRx: /%u([0-9a-fA-F]{4})/g,
  _affectsRx: /%u[0-9a-fA-F]{4}/,
  _badPercentRx: /%(?!u[0-9a-fA-F]{4}|[0-9a-fA-F]{2})|%(?:00|u0000)[^&=]*/g,

  hasBadPercents(s) {
    return this._badPercentRx.test(s)
  },
  removeBadPercents(s) {
    return s.replace(this._badPercentRx, '');
  },
  affects(s) {
    return this._affectsRx.test(s);
  },
  process(s) {
    s = this.filter(s);
    return /[\uff5f-\uffff]/.test(s) ? s + '&' + s.replace(/[\uff5f-\uffff]/g, '?') : s;
  },
  filter(s) {
    return this.removeBadPercents(s).replace(this._replaceRx, this._replace)
  },

  coalesceQuery(s) { // HPP protection, see https://www.owasp.org/images/b/ba/AppsecEU09_CarettoniDiPaola_v0.8.pdf
    let qm = s.indexOf("?");
    if (qm < 0) return s;
    let p = s.substring(0, qm);
    let q = s.substring(qm + 1);
    if (!q) return s;

    let unchanged = true;
    let emptyParams = false;

    let pairs = (function rearrange(joinNames) {
      let pairs = q.split("&");
      let accumulator = {
        __proto__: null
      };
      for (let j = 0, len = pairs.length; j < len; j++) {
        let nv = pairs[j];
        let eq = nv.indexOf("=");
        if (eq === -1) {
          emptyParams = true;
          if (joinNames && j < len - 1) {
            pairs[j + 1] = nv + "&" + pairs[j + 1];
            delete pairs[j];
          }
          continue;
        }
        let key = "#" + unescape(nv.substring(0, eq)).toLowerCase();
        if (key in accumulator) {
          delete pairs[j];
          pairs[accumulator[key]] += ", " + nv.substring(eq + 1);
          unchanged = false;
        } else {
          accumulator[key] = j;
        }
      }
      return (emptyParams && !(unchanged || joinNames)) ?
        pairs.concat(rearrange(true).filter(p => pairs.indexOf(p) === -1)) :
        pairs;
    })();

    if (unchanged) return s;
    for (let j = pairs.length; j-- > 0;)
      if (!pairs[j]) pairs.splice(j, 1);
    return p + pairs.join("&");
  },

  _replace(match, hex) {
    const k = parseInt(hex, 16);
    const map = ASPIdiocy.map;
    if (k in map) return map[k];
    const range = ASPIdiocy._findRange(k);
    return range && range.data || String.fromCharCode(k);
  },
  _findRange(k) {
    const ranges = this.ranges;
    for (let low = 0, high = ranges.length - 1; low <= high;) {
      let i = parseInt((low + high) / 2);
      let r = ranges[i];
      let comparison = k < r.start ? 1 : k > r.end ? -1 : 0;
      if (comparison < 0) low = i + 1;
      else if (comparison > 0) high = i - 1;
      else return r;
    }
    return null;
  }
}

XSS.ASPIdiocy.map = {
  0x100: "\x41",
  0x101: "\x61",
  0x102: "\x41",
  0x103: "\x61",
  0x104: "\x41",
  0x105: "\x61",
  0x106: "\x43",
  0x107: "\x63",
  0x108: "\x43",
  0x109: "\x63",
  0x10a: "\x43",
  0x10b: "\x63",
  0x10c: "\x43",
  0x10d: "\x63",
  0x10e: "\x44",
  0x10f: "\x64",
  0x110: "\ufffd",
  0x111: "\x64",
  0x112: "\x45",
  0x113: "\x65",
  0x114: "\x45",
  0x115: "\x65",
  0x116: "\x45",
  0x117: "\x65",
  0x118: "\x45",
  0x119: "\x65",
  0x11a: "\x45",
  0x11b: "\x65",
  0x11c: "\x47",
  0x11d: "\x67",
  0x11e: "\x47",
  0x11f: "\x67",
  0x120: "\x47",
  0x121: "\x67",
  0x122: "\x47",
  0x123: "\x67",
  0x124: "\x48",
  0x125: "\x68",
  0x126: "\x48",
  0x127: "\x68",
  0x128: "\x49",
  0x129: "\x69",
  0x12a: "\x49",
  0x12b: "\x69",
  0x12c: "\x49",
  0x12d: "\x69",
  0x12e: "\x49",
  0x12f: "\x69",
  0x130: "\x49",
  0x131: "\x69",
  0x134: "\x4a",
  0x135: "\x6a",
  0x136: "\x4b",
  0x137: "\x6b",
  0x138: "\x3f",
  0x139: "\x4c",
  0x13a: "\x6c",
  0x13b: "\x4c",
  0x13c: "\x6c",
  0x13d: "\x4c",
  0x13e: "\x6c",
  0x141: "\x4c",
  0x142: "\x6c",
  0x143: "\x4e",
  0x144: "\x6e",
  0x145: "\x4e",
  0x146: "\x6e",
  0x147: "\x4e",
  0x148: "\x6e",
  0x14c: "\x4f",
  0x14d: "\x6f",
  0x14e: "\x4f",
  0x14f: "\x6f",
  0x150: "\x4f",
  0x151: "\x6f",
  0x154: "\x52",
  0x155: "\x72",
  0x156: "\x52",
  0x157: "\x72",
  0x158: "\x52",
  0x159: "\x72",
  0x15a: "\x53",
  0x15b: "\x73",
  0x15c: "\x53",
  0x15d: "\x73",
  0x15e: "\x53",
  0x15f: "\x73",
  0x162: "\x54",
  0x163: "\x74",
  0x164: "\x54",
  0x165: "\x74",
  0x166: "\x54",
  0x167: "\x74",
  0x168: "\x55",
  0x169: "\x75",
  0x16a: "\x55",
  0x16b: "\x75",
  0x16c: "\x55",
  0x16d: "\x75",
  0x16e: "\x55",
  0x16f: "\x75",
  0x170: "\x55",
  0x171: "\x75",
  0x172: "\x55",
  0x173: "\x75",
  0x174: "\x57",
  0x175: "\x77",
  0x176: "\x59",
  0x177: "\x79",
  0x178: "\ufffd",
  0x179: "\x5a",
  0x17a: "\x7a",
  0x17b: "\x5a",
  0x17c: "\x7a",
  0x17f: "\x3f",
  0x180: "\x62",
  0x189: "\ufffd",
  0x197: "\x49",
  0x19a: "\x6c",
  0x1a1: "\x6f",
  0x1ab: "\x74",
  0x1ae: "\x54",
  0x1af: "\x55",
  0x1b0: "\x75",
  0x1b6: "\x7a",
  0x1c0: "\x7c",
  0x1c3: "\x21",
  0x1cd: "\x41",
  0x1ce: "\x61",
  0x1cf: "\x49",
  0x1d0: "\x69",
  0x1d1: "\x4f",
  0x1d2: "\x6f",
  0x1d3: "\x55",
  0x1d4: "\x75",
  0x1d5: "\x55",
  0x1d6: "\x75",
  0x1d7: "\x55",
  0x1d8: "\x75",
  0x1d9: "\x55",
  0x1da: "\x75",
  0x1db: "\x55",
  0x1dc: "\x75",
  0x1dd: "\x3f",
  0x1de: "\x41",
  0x1df: "\x61",
  0x1e4: "\x47",
  0x1e5: "\x67",
  0x1e6: "\x47",
  0x1e7: "\x67",
  0x1e8: "\x4b",
  0x1e9: "\x6b",
  0x1ea: "\x4f",
  0x1eb: "\x6f",
  0x1ec: "\x4f",
  0x1ed: "\x6f",
  0x1f0: "\x6a",
  0x261: "\x67",
  0x2b9: "\x27",
  0x2ba: "\x22",
  0x2bb: "\x3f",
  0x2bc: "\x27",
  0x2c4: "\x5e",
  0x2c5: "\x3f",
  0x2c6: "\ufffd",
  0x2c7: "\x3f",
  0x2c8: "\x27",
  0x2cb: "\x60",
  0x2cc: "\x3f",
  0x2cd: "\x5f",
  0x2da: "\ufffd",
  0x2db: "\x3f",
  0x2dc: "\ufffd",
  0x300: "\x60",
  0x301: "\ufffd",
  0x302: "\x5e",
  0x303: "\x7e",
  0x308: "\ufffd",
  0x309: "\x3f",
  0x30a: "\ufffd",
  0x30e: "\x22",
  0x327: "\ufffd",
  0x37e: "\x3b",
  0x393: "\x47",
  0x398: "\x54",
  0x3a3: "\x53",
  0x3a6: "\x46",
  0x3a9: "\x4f",
  0x3b1: "\x61",
  0x3b2: "\ufffd",
  0x3b3: "\x3f",
  0x3b4: "\x64",
  0x3b5: "\x65",
  0x3bc: "\ufffd",
  0x3c0: "\x70",
  0x3c3: "\x73",
  0x3c4: "\x74",
  0x3c5: "\x3f",
  0x3c6: "\x66",
  0x4bb: "\x68",
  0x589: "\x3a",
  0x66a: "\x25",
  0x2012: "\x3f",
  0x2017: "\x3d",
  0x201b: "\x3f",
  0x201f: "\x3f",
  0x2023: "\x3f",
  0x2024: "\ufffd",
  0x2025: "\x3f",
  0x2026: "\ufffd",
  0x2030: "\ufffd",
  0x2031: "\x3f",
  0x2032: "\x27",
  0x2035: "\x60",
  0x2044: "\x2f",
  0x2070: "\ufffd",
  0x2074: "\x34",
  0x2075: "\x35",
  0x2076: "\x36",
  0x2077: "\x37",
  0x2078: "\x38",
  0x207f: "\x6e",
  0x2080: "\x30",
  0x2081: "\x31",
  0x2082: "\x32",
  0x2083: "\x33",
  0x2084: "\x34",
  0x2085: "\x35",
  0x2086: "\x36",
  0x2087: "\x37",
  0x2088: "\x38",
  0x2089: "\x39",
  0x20a1: "\ufffd",
  0x20a4: "\ufffd",
  0x20a7: "\x50",
  0x20ac: "\ufffd",
  0x2102: "\x43",
  0x2107: "\x45",
  0x210a: "\x67",
  0x210e: "\x68",
  0x210f: "\x3f",
  0x2112: "\x4c",
  0x2113: "\x6c",
  0x2114: "\x3f",
  0x2115: "\x4e",
  0x211a: "\x51",
  0x2122: "\ufffd",
  0x2123: "\x3f",
  0x2124: "\x5a",
  0x2128: "\x5a",
  0x2129: "\x3f",
  0x212a: "\x4b",
  0x212b: "\ufffd",
  0x212c: "\x42",
  0x212d: "\x43",
  0x2130: "\x45",
  0x2131: "\x46",
  0x2132: "\x3f",
  0x2133: "\x4d",
  0x2134: "\x6f",
  0x2205: "\ufffd",
  0x2212: "\x2d",
  0x2213: "\ufffd",
  0x2214: "\x3f",
  0x2215: "\x2f",
  0x2216: "\x5c",
  0x2217: "\x2a",
  0x221a: "\x76",
  0x221e: "\x38",
  0x2223: "\x7c",
  0x2229: "\x6e",
  0x2236: "\x3a",
  0x223c: "\x7e",
  0x2248: "\ufffd",
  0x2261: "\x3d",
  0x22c5: "\ufffd",
  0x2302: "\ufffd",
  0x2303: "\x5e",
  0x2310: "\ufffd",
  0x2320: "\x28",
  0x2321: "\x29",
  0x2329: "\x3c",
  0x232a: "\x3e",
  0x2500: "\x2d",
  0x2501: "\x3f",
  0x2502: "\ufffd",
  0x250c: "\x2b",
  0x2510: "\x2b",
  0x2514: "\x2b",
  0x2518: "\x2b",
  0x251c: "\x2b",
  0x2524: "\ufffd",
  0x252c: "\x2d",
  0x2534: "\x2d",
  0x253c: "\x2b",
  0x2550: "\x2d",
  0x2551: "\ufffd",
  0x2580: "\ufffd",
  0x2584: "\x5f",
  0x2588: "\ufffd",
  0x258c: "\ufffd",
  0x25a0: "\ufffd",
  0x263c: "\ufffd",
  0x2758: "\x7c",
  0x3000: "\x20",
  0x3008: "\x3c",
  0x3009: "\x3e",
  0x301a: "\x5b",
  0x301b: "\x5d",
  0x30fb: "\ufffd",
  0xff01: "\x21",
  0xff02: "\x22",
  0xff03: "\x23",
  0xff04: "\x24",
  0xff05: "\x25",
  0xff06: "\x26",
  0xff07: "\x27",
  0xff08: "\x28",
  0xff09: "\x29",
  0xff0a: "\x2a",
  0xff0b: "\x2b",
  0xff0c: "\x2c",
  0xff0d: "\x2d",
  0xff0e: "\x2e",
  0xff0f: "\x2f",
  0xff10: "\x30",
  0xff11: "\x31",
  0xff12: "\x32",
  0xff13: "\x33",
  0xff14: "\x34",
  0xff15: "\x35",
  0xff16: "\x36",
  0xff17: "\x37",
  0xff18: "\x38",
  0xff19: "\x39",
  0xff1a: "\x3a",
  0xff1b: "\x3b",
  0xff1c: "\x3c",
  0xff1d: "\x3d",
  0xff1e: "\x3e",
  0xff1f: "\x3f",
  0xff20: "\x40",
  0xff21: "\x41",
  0xff22: "\x42",
  0xff23: "\x43",
  0xff24: "\x44",
  0xff25: "\x45",
  0xff26: "\x46",
  0xff27: "\x47",
  0xff28: "\x48",
  0xff29: "\x49",
  0xff2a: "\x4a",
  0xff2b: "\x4b",
  0xff2c: "\x4c",
  0xff2d: "\x4d",
  0xff2e: "\x4e",
  0xff2f: "\x4f",
  0xff30: "\x50",
  0xff31: "\x51",
  0xff32: "\x52",
  0xff33: "\x53",
  0xff34: "\x54",
  0xff35: "\x55",
  0xff36: "\x56",
  0xff37: "\x57",
  0xff38: "\x58",
  0xff39: "\x59",
  0xff3a: "\x5a",
  0xff3b: "\x5b",
  0xff3c: "\x5c",
  0xff3d: "\x5d",
  0xff3e: "\x5e",
  0xff3f: "\x5f",
  0xff40: "\x60",
  0xff41: "\x61",
  0xff42: "\x62",
  0xff43: "\x63",
  0xff44: "\x64",
  0xff45: "\x65",
  0xff46: "\x66",
  0xff47: "\x67",
  0xff48: "\x68",
  0xff49: "\x69",
  0xff4a: "\x6a",
  0xff4b: "\x6b",
  0xff4c: "\x6c",
  0xff4d: "\x6d",
  0xff4e: "\x6e",
  0xff4f: "\x6f",
  0xff50: "\x70",
  0xff51: "\x71",
  0xff52: "\x72",
  0xff53: "\x73",
  0xff54: "\x74",
  0xff55: "\x75",
  0xff56: "\x76",
  0xff57: "\x77",
  0xff58: "\x78",
  0xff59: "\x79",
  0xff5a: "\x7a",
  0xff5b: "\x7b",
  0xff5c: "\x7c",
  0xff5d: "\x7d",
  0xff5e: "\x7e"
};

{
   let Range = class {
     constructor(start, end, data) {
      this.start = start;
      this.end = end;
      this.data = data;
    }
  };

  XSS.ASPIdiocy.ranges = [
    new Range(0x80, 0xff, "\ufffd"),
    new Range(0x132, 0x133, "\x3f"),
    new Range(0x13f, 0x140, "\x3f"),
    new Range(0x149, 0x14b, "\x3f"),
    new Range(0x152, 0x153, "\ufffd"),
    new Range(0x160, 0x161, "\ufffd"),
    new Range(0x17d, 0x17e, "\ufffd"),
    new Range(0x181, 0x188, "\x3f"),
    new Range(0x18a, 0x190, "\x3f"),
    new Range(0x191, 0x192, "\ufffd"),
    new Range(0x193, 0x196, "\x3f"),
    new Range(0x198, 0x199, "\x3f"),
    new Range(0x19b, 0x19e, "\x3f"),
    new Range(0x19f, 0x1a0, "\x4f"),
    new Range(0x1a2, 0x1aa, "\x3f"),
    new Range(0x1ac, 0x1ad, "\x3f"),
    new Range(0x1b1, 0x1b5, "\x3f"),
    new Range(0x1b7, 0x1bf, "\x3f"),
    new Range(0x1c1, 0x1c2, "\x3f"),
    new Range(0x1c4, 0x1cc, "\x3f"),
    new Range(0x1e0, 0x1e3, "\x3f"),
    new Range(0x1ee, 0x1ef, "\x3f"),
    new Range(0x1f1, 0x260, "\x3f"),
    new Range(0x262, 0x2b8, "\x3f"),
    new Range(0x2bd, 0x2c3, "\x3f"),
    new Range(0x2c9, 0x2ca, "\ufffd"),
    new Range(0x2ce, 0x2d9, "\x3f"),
    new Range(0x2dd, 0x2ff, "\x3f"),
    new Range(0x304, 0x305, "\ufffd"),
    new Range(0x306, 0x307, "\x3f"),
    new Range(0x30b, 0x30d, "\x3f"),
    new Range(0x30f, 0x326, "\x3f"),
    new Range(0x328, 0x330, "\x3f"),
    new Range(0x331, 0x332, "\x5f"),
    new Range(0x333, 0x37d, "\x3f"),
    new Range(0x37f, 0x392, "\x3f"),
    new Range(0x394, 0x397, "\x3f"),
    new Range(0x399, 0x3a2, "\x3f"),
    new Range(0x3a4, 0x3a5, "\x3f"),
    new Range(0x3a7, 0x3a8, "\x3f"),
    new Range(0x3aa, 0x3b0, "\x3f"),
    new Range(0x3b6, 0x3bb, "\x3f"),
    new Range(0x3bd, 0x3bf, "\x3f"),
    new Range(0x3c1, 0x3c2, "\x3f"),
    new Range(0x3c7, 0x4ba, "\x3f"),
    new Range(0x4bc, 0x588, "\x3f"),
    new Range(0x58a, 0x669, "\x3f"),
    new Range(0x66b, 0x1fff, "\x3f"),
    new Range(0x2000, 0x2006, "\x20"),
    new Range(0x2007, 0x200f, "\x3f"),
    new Range(0x2010, 0x2011, "\x2d"),
    new Range(0x2013, 0x2014, "\ufffd"),
    new Range(0x2015, 0x2016, "\x3f"),
    new Range(0x2018, 0x201a, "\ufffd"),
    new Range(0x201c, 0x201e, "\ufffd"),
    new Range(0x2020, 0x2022, "\ufffd"),
    new Range(0x2027, 0x202f, "\x3f"),
    new Range(0x2033, 0x2034, "\x3f"),
    new Range(0x2036, 0x2038, "\x3f"),
    new Range(0x2039, 0x203a, "\ufffd"),
    new Range(0x203b, 0x2043, "\x3f"),
    new Range(0x2045, 0x206f, "\x3f"),
    new Range(0x2071, 0x2073, "\x3f"),
    new Range(0x2079, 0x207e, "\x3f"),
    new Range(0x208a, 0x20a0, "\x3f"),
    new Range(0x20a2, 0x20a3, "\x3f"),
    new Range(0x20a5, 0x20a6, "\x3f"),
    new Range(0x20a8, 0x20ab, "\x3f"),
    new Range(0x20ad, 0x2101, "\x3f"),
    new Range(0x2103, 0x2106, "\x3f"),
    new Range(0x2108, 0x2109, "\x3f"),
    new Range(0x210b, 0x210d, "\x48"),
    new Range(0x2110, 0x2111, "\x49"),
    new Range(0x2116, 0x2117, "\x3f"),
    new Range(0x2118, 0x2119, "\x50"),
    new Range(0x211b, 0x211d, "\x52"),
    new Range(0x211e, 0x2121, "\x3f"),
    new Range(0x2125, 0x2127, "\x3f"),
    new Range(0x212e, 0x212f, "\x65"),
    new Range(0x2135, 0x2204, "\x3f"),
    new Range(0x2206, 0x2211, "\x3f"),
    new Range(0x2218, 0x2219, "\ufffd"),
    new Range(0x221b, 0x221d, "\x3f"),
    new Range(0x221f, 0x2222, "\x3f"),
    new Range(0x2224, 0x2228, "\x3f"),
    new Range(0x222a, 0x2235, "\x3f"),
    new Range(0x2237, 0x223b, "\x3f"),
    new Range(0x223d, 0x2247, "\x3f"),
    new Range(0x2249, 0x2260, "\x3f"),
    new Range(0x2262, 0x2263, "\x3f"),
    new Range(0x2264, 0x2265, "\x3d"),
    new Range(0x2266, 0x2269, "\x3f"),
    new Range(0x226a, 0x226b, "\ufffd"),
    new Range(0x226c, 0x22c4, "\x3f"),
    new Range(0x22c6, 0x2301, "\x3f"),
    new Range(0x2304, 0x230f, "\x3f"),
    new Range(0x2311, 0x231f, "\x3f"),
    new Range(0x2322, 0x2328, "\x3f"),
    new Range(0x232b, 0x24ff, "\x3f"),
    new Range(0x2503, 0x250b, "\x3f"),
    new Range(0x250d, 0x250f, "\x3f"),
    new Range(0x2511, 0x2513, "\x3f"),
    new Range(0x2515, 0x2517, "\x3f"),
    new Range(0x2519, 0x251b, "\x3f"),
    new Range(0x251d, 0x2523, "\x3f"),
    new Range(0x2525, 0x252b, "\x3f"),
    new Range(0x252d, 0x2533, "\x3f"),
    new Range(0x2535, 0x253b, "\x3f"),
    new Range(0x253d, 0x254f, "\x3f"),
    new Range(0x2552, 0x255d, "\x2b"),
    new Range(0x255e, 0x2563, "\ufffd"),
    new Range(0x2564, 0x2569, "\x2d"),
    new Range(0x256a, 0x256c, "\x2b"),
    new Range(0x256d, 0x257f, "\x3f"),
    new Range(0x2581, 0x2583, "\x3f"),
    new Range(0x2585, 0x2587, "\x3f"),
    new Range(0x2589, 0x258b, "\x3f"),
    new Range(0x258d, 0x258f, "\x3f"),
    new Range(0x2590, 0x2593, "\ufffd"),
    new Range(0x2594, 0x259f, "\x3f"),
    new Range(0x25a1, 0x263b, "\x3f"),
    new Range(0x263d, 0x2757, "\x3f"),
    new Range(0x2759, 0x2fff, "\x3f"),
    new Range(0x3001, 0x3007, "\x3f"),
    new Range(0x300a, 0x300b, "\ufffd"),
    new Range(0x300c, 0x3019, "\x3f"),
    new Range(0x301c, 0x30fa, "\x3f"),
    new Range(0x30fc, 0xff00, "\x3f")
  ];
}
