/* 
 * Copyright (c) 2007, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WB_PHYSICAL_MODEL_DIAGRAM_FEATURES_H_
#define _WB_PHYSICAL_MODEL_DIAGRAM_FEATURES_H_

#include <mdc.h>
#include <grts/structs.model.h>
#include <grts/structs.workbench.physical.h>

#include "grt/grt_manager.h"

namespace MySQL {
  namespace Geometry {
    struct Point;
  };
};

namespace wb {
  
  class ModelDiagramForm;
  class Tooltip;
  
  /** Implementation of diagram manipulation goodies (basic stuff is in wb_model_diagram_form)
   */
  class PhysicalModelDiagramFeatures : public base::trackable
  {
    ModelDiagramForm *_diagram;
    mdc::Timestamp _last_click;
    MySQL::Geometry::Point _last_click_pos;

    mdc::CanvasItem *_last_over_item;
    Tooltip *_tooltip;
    bec::GRTManager::Timer *_tooltip_timer;
    
    std::string _highlighted_connection_id;
    std::string _highlighted_table_id;
    
    void on_figure_double_click(const model_ObjectRef &owner, mdc::CanvasItem *item, const MySQL::Geometry::Point &pos, mdc::MouseButton button, mdc::EventState state);
    void on_figure_mouse_button(const model_ObjectRef &owner, mdc::CanvasItem *item, bool press, const MySQL::Geometry::Point &pos, mdc::MouseButton button, mdc::EventState state);
    void on_figure_crossed(const model_ObjectRef &owner, mdc::CanvasItem *item, bool enter, const MySQL::Geometry::Point &pos);

    void on_selection_changed();
    
    void on_figure_will_unrealize(const model_ObjectRef &object);
    
    void activate_item(const model_ObjectRef &owner, mdc::CanvasItem *item, mdc::EventState state);
    
    void highlight_connection(const workbench_physical_ConnectionRef &conn, bool flag);
    void highlight_table(const workbench_physical_TableFigureRef &table, bool flag);
    void highlight_table_index(const workbench_physical_TableFigureRef &table,
                               const db_IndexRef &index, bool entered);
    
    void tooltip_setup(const model_ObjectRef &owner);
    void tooltip_cancel();
    void show_tooltip(const model_ObjectRef &owner, mdc::CanvasItem *item);
    
    mdc::CanvasView *get_canvas_view();
    bec::GRTManager::Timer *run_every(const boost::function<bool ()> &slot, double seconds);
    void cancel_timer(bec::GRTManager::Timer *timer);
    
  public:
    PhysicalModelDiagramFeatures(ModelDiagramForm *diagram);
    virtual ~PhysicalModelDiagramFeatures();
        
    virtual void mouse_moved(int x, int y, mdc::EventState state);
    
//    virtual bool key_pressed();
  };
  
};

#endif
