#ifndef _WB_USER_DATATYPES_H_
#define _WB_USER_DATATYPES_H_

#include "grt/tree_model.h"
#include "grts/structs.db.h"
#include "grts/structs.db.mgmt.h"

#include <grtpp_undo_manager.h>

#include "workbench/wb_backend_public_interface.h"

namespace wb {
  class WBContext;

  class MYSQLWBBACKEND_PUBLIC_FUNC UserDatatypeListBE : public bec::ListModel
  {
  private:
  public:
    enum Columns {
      Name,
      Definition,
      Flags
    };

    UserDatatypeListBE(WBContext *wb);

    void set_rdbms(const db_mgmt_RdbmsRef &rdbms);
    void set_catalog(const db_CatalogRef &catalog);

    virtual int count();

    virtual bool get_field(const bec::NodeId &node, int column, std::string &value);
    virtual bec::IconId get_field_icon(const bec::NodeId &node, int column, bec::IconSize size);

    virtual void refresh();

    virtual bool is_editable(const bec::NodeId &node) const;
    
    // for editable lists only
    virtual grt::Type get_field_type(const bec::NodeId &node, int column);

    virtual bool set_field(const bec::NodeId &node, int column, const std::string &value);

    virtual grt::ValueRef get_grt_value(const bec::NodeId &node, int column);

    virtual bool delete_node(const bec::NodeId &node);
  
  protected:
    db_mgmt_RdbmsRef _rdbms;
    db_CatalogRef _catalog;
    WBContext *_wb;
  };
};


#endif 
