//!
//! \addtogroup linuxui Linux UI
//! @{
//! 

#include <gtkmm/box.h>
#include <gtkmm/builder.h>
#include "widgets_auto_cleaner.h"

namespace Gtk
{
class Entry;
}

class AutoCompletable;
class ListModelWrapper;

namespace wb
{
  class WBContextUI;
  class FindDialogBE;
};


class FindPanel : public Gtk::VBox, protected WidgetsAutoCleaner
{
  wb::WBContextUI *_wbui;
  Glib::RefPtr<Gtk::Builder> _ui;
  wb::FindDialogBE *_be;

  void init(wb::WBContextUI *wbui, Glib::RefPtr<Gtk::Builder> ui);

  void find_next();
  void find_previous();

  void setup_arguments();
  
  void key_press(GdkEventKey *ev, Gtk::Entry *entry);

  void handle_close();
  
  
public:
  FindPanel(GtkVBox *box, const Glib::RefPtr<Gtk::Builder> &b);

  virtual ~FindPanel();

  virtual void show();
  
  static FindPanel *create(wb::WBContextUI *wbui);
  
};

//!                                                                                                                                     
//! @}                                                                                                                                  
//!
