/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

//#include "stdafx.h"

#include "base/ui_form.h"
#include "base/string_utilities.h"


using namespace bec;

static std::map<std::string, UIForm*> ui_form_instances;


UIForm::UIForm()
: _owner_data(0), _frontend_data(0)
{
  ui_form_instances[form_id()] = this;
}

void UIForm::set_frontend_data(void *data)
{
  _frontend_data= data;
}

std::string UIForm::form_id()
{
  return base::strfmt("<UIForm %p>", this);
}

void *UIForm::get_frontend_data()
{
  return _frontend_data;
}



UIForm::~UIForm()
{
  ui_form_instances.erase(ui_form_instances.find(form_id()));

  if (slot_destroyed)
    slot_destroyed();
}

bec::UIForm *UIForm::form_with_id(const std::string &id)
{
  if (ui_form_instances.find(id) != ui_form_instances.end())
    return ui_form_instances[id];
  return 0;
}

void UIForm::set_owner_data(void *data) { _owner_data= data; }
void *UIForm::get_owner_data() { return _owner_data; }

bool UIForm::is_main_form() { return false; }

// target description for cuy/copy/delete menu items and for paste, after a copy is made
std::string UIForm::get_edit_target_name() { return ""; }

bool UIForm::can_undo(/*Clipboard *clip*/) { return false; }
bool UIForm::can_redo(/*Clipboard *clip*/) { return false; }
bool UIForm::can_cut(/*Clipboard *clip*/) { return can_copy() && can_delete(); }
bool UIForm::can_copy(/*Clipboard *clip*/) { return false; }
bool UIForm::can_paste(/*Clipboard *clip*/) { return false; }
bool UIForm::can_delete() { return false; }
bool UIForm::can_select_all() { return false; }

void UIForm::undo() {}
void UIForm::redo() {}
void UIForm::cut(/*Clipboard *clip*/) {}
void UIForm::copy(/*Clipboard *clip*/) {}
void UIForm::paste(/*Clipboard *clip*/) {}
void UIForm::delete_selection() {}
void UIForm::select_all() {}
