"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _scheduler = require("scheduler");

var _reactReconciler = _interopRequireDefault(require("react-reconciler"));

var _dom = require("./dom");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const NO_CONTEXT = true;
const hostConfig = {
  schedulePassiveEffects: _scheduler.unstable_scheduleCallback,
  cancelPassiveEffects: _scheduler.unstable_cancelCallback,
  now: Date.now,
  getRootHostContext: () => NO_CONTEXT,
  prepareForCommit: () => {},
  resetAfterCommit: rootNode => {
    rootNode.onRender();
  },
  getChildHostContext: () => NO_CONTEXT,
  shouldSetTextContent: (type, props) => {
    return typeof props.children === 'string' || typeof props.children === 'number';
  },
  createInstance: (type, newProps) => {
    const node = (0, _dom.createNode)(type);

    for (const [key, value] of Object.entries(newProps)) {
      if (key === 'children') {
        if (typeof value === 'string' || typeof value === 'number') {
          if (type === 'div') {
            // Text node must be wrapped in another node, so that text can be aligned within container
            const textElement = (0, _dom.createNode)('div');
            textElement.textContent = String(value);
            (0, _dom.appendChildNode)(node, textElement);
          }

          if (type === 'span') {
            node.textContent = String(value);
          }
        }
      } else if (key === 'style') {
        node.style = value;
      } else if (key === 'unstable__transformChildren') {
        node.unstable__transformChildren = value; // eslint-disable-line camelcase
      } else if (key === 'unstable__static') {
        node.unstable__static = true; // eslint-disable-line camelcase
      } else {
        (0, _dom.setAttribute)(node, key, value);
      }
    }

    return node;
  },
  createTextInstance: _dom.createTextNode,
  resetTextContent: node => {
    if (node.textContent) {
      node.textContent = '';
    }

    if (node.childNodes.length > 0) {
      for (const childNode of node.childNodes) {
        childNode.yogaNode.free();
        (0, _dom.removeChildNode)(node, childNode);
      }
    }
  },
  getPublicInstance: instance => instance,
  appendInitialChild: _dom.appendChildNode,
  appendChild: _dom.appendChildNode,
  insertBefore: _dom.insertBeforeNode,
  finalizeInitialChildren: () => {},
  supportsMutation: true,
  appendChildToContainer: _dom.appendChildNode,
  insertInContainerBefore: _dom.insertBeforeNode,
  removeChildFromContainer: _dom.removeChildNode,
  prepareUpdate: () => true,
  commitUpdate: (node, updatePayload, type, oldProps, newProps) => {
    for (const [key, value] of Object.entries(newProps)) {
      if (key === 'children') {
        if (typeof value === 'string' || typeof value === 'number') {
          if (type === 'div') {
            // Text node must be wrapped in another node, so that text can be aligned within container
            // If there's no such node, a new one must be created
            if (node.childNodes.length === 0) {
              const textElement = (0, _dom.createNode)('div');
              textElement.textContent = String(value);
              (0, _dom.appendChildNode)(node, textElement);
            } else {
              node.childNodes[0].textContent = String(value);
            }
          }

          if (type === 'span') {
            node.textContent = String(value);
          }
        }
      } else if (key === 'style') {
        node.style = value;
      } else if (key === 'unstable__transformChildren') {
        node.unstable__transformChildren = value; // eslint-disable-line camelcase
      } else if (key === 'unstable__static') {
        node.unstable__static = true; // eslint-disable-line camelcase
      } else {
        (0, _dom.setAttribute)(node, key, value);
      }
    }
  },
  commitTextUpdate: (node, oldText, newText) => {
    if (node.nodeName === '#text') {
      node.nodeValue = newText;
    } else {
      node.textContent = newText;
    }
  },
  removeChild: _dom.removeChildNode
};

var _default = (0, _reactReconciler.default)(hostConfig); // eslint-disable-line new-cap


exports.default = _default;