// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Aspect_ColorScale_HeaderFile
#define _Aspect_ColorScale_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Aspect_ColorScale.hxx>

#include <Standard_Real.hxx>
#include <TCollection_ExtendedString.hxx>
#include <TCollection_AsciiString.hxx>
#include <Standard_Integer.hxx>
#include <Aspect_TypeOfColorScaleData.hxx>
#include <Standard_Boolean.hxx>
#include <Aspect_SequenceOfColor.hxx>
#include <TColStd_SequenceOfExtendedString.hxx>
#include <Aspect_TypeOfColorScalePosition.hxx>
#include <MMgt_TShared.hxx>
class Quantity_Color;
class TCollection_ExtendedString;
class TCollection_AsciiString;
class TColStd_SequenceOfExtendedString;
class Aspect_SequenceOfColor;


//! Defines a color scale for viewer.
class Aspect_ColorScale : public MMgt_TShared
{

public:

  
  //! Calculate color according passed value; returns true if value is in range or false, if isn't
  Standard_EXPORT   Standard_Boolean FindColor (const Standard_Real Value, Quantity_Color& Color)  const;
  
  Standard_EXPORT static   Standard_Boolean FindColor (const Standard_Real Value, const Standard_Real Min, const Standard_Real Max, const Standard_Integer ColorsCount, Quantity_Color& Color) ;
  
  //! Returns minimal value of color scale;
  Standard_EXPORT   Standard_Real GetMin()  const;
  
  //! Returns maximal value of color scale;
  Standard_EXPORT   Standard_Real GetMax()  const;
  
  //! Returns minimal and maximal values of color scale;
  Standard_EXPORT   void GetRange (Standard_Real& aMin, Standard_Real& aMax)  const;
  
  //! Returns the type of labels;
  //! Aspect_TOCSD_AUTO - labels as boundary values for intervals
  //! Aspect_TOCSD_USER - user specified label is used
  Standard_EXPORT   Aspect_TypeOfColorScaleData GetLabelType()  const;
  
  //! Returns the type of colors;
  //! Aspect_TOCSD_AUTO - value between Red and Blue
  //! Aspect_TOCSD_USER - user specified color from color map
  Standard_EXPORT   Aspect_TypeOfColorScaleData GetColorType()  const;
  
  //! Returns the number of color scale intervals;
  Standard_EXPORT   Standard_Integer GetNumberOfIntervals()  const;
  
  //! Returns the color scale title string;
  Standard_EXPORT   TCollection_ExtendedString GetTitle()  const;
  
  //! Returns the format for numbers.
  //! The same like format for function printf().
  //! Used if GetLabelType() is TOCSD_AUTO;
  Standard_EXPORT   TCollection_AsciiString GetFormat()  const;
  
  //! Returns the user specified label with index <anIndex>.
  //! Returns empty string if label not defined.
  Standard_EXPORT   TCollection_ExtendedString GetLabel (const Standard_Integer anIndex)  const;
  
  //! Returns the user specified color from color map with index <anIndex>.
  //! Returns default color if index out of range in color map.
  Standard_EXPORT   Quantity_Color GetColor (const Standard_Integer anIndex)  const;
  
  //! Returns the user specified labels.
  Standard_EXPORT   void GetLabels (TColStd_SequenceOfExtendedString& aLabels)  const;
  
  //! Returns the user specified colors.
  Standard_EXPORT   void GetColors (Aspect_SequenceOfColor& aColors)  const;
  
  //! Returns the position of labels concerning color filled rectangles.
  Standard_EXPORT   Aspect_TypeOfColorScalePosition GetLabelPosition()  const;
  
  //! Returns the position of color scale title.
  Standard_EXPORT   Aspect_TypeOfColorScalePosition GetTitlePosition()  const;
  
  //! Returns true if the labels and colors used in reversed order.
  Standard_EXPORT   Standard_Boolean IsReversed()  const;
  
  //! Returns true if the labels placed at border of color filled rectangles.
  Standard_EXPORT   Standard_Boolean IsLabelAtBorder()  const;
  
  //! Sets the minimal value of color scale.
  Standard_EXPORT   void SetMin (const Standard_Real aMin) ;
  
  //! Sets the maximal value of color scale.
  Standard_EXPORT   void SetMax (const Standard_Real aMax) ;
  
  //! Sets the minimal and maximal value of color scale.
  Standard_EXPORT   void SetRange (const Standard_Real aMin, const Standard_Real aMax) ;
  
  //! Sets the type of labels.
  //! Aspect_TOCSD_AUTO - labels as boundary values for intervals
  //! Aspect_TOCSD_USER - user specified label is used
  Standard_EXPORT   void SetLabelType (const Aspect_TypeOfColorScaleData aType) ;
  
  //! Sets the type of colors.
  //! Aspect_TOCSD_AUTO - value between Red and Blue
  //! Aspect_TOCSD_USER - user specified color from color map
  Standard_EXPORT   void SetColorType (const Aspect_TypeOfColorScaleData aType) ;
  
  //! Sets the number of color scale intervals.
  Standard_EXPORT   void SetNumberOfIntervals (const Standard_Integer aNum) ;
  
  //! Sets the color scale title string.
  Standard_EXPORT   void SetTitle (const TCollection_ExtendedString& aTitle) ;
  
  //! Sets the color scale auto label format specification.
  Standard_EXPORT   void SetFormat (const TCollection_AsciiString& aFormat) ;
  
  //! Sets the color scale label at index. Index started from 1.
  Standard_EXPORT   void SetLabel (const TCollection_ExtendedString& aLabel, const Standard_Integer anIndex = -1) ;
  
  //! Sets the color scale color at index. Index started from 1.
  Standard_EXPORT   void SetColor (const Quantity_Color& aColor, const Standard_Integer anIndex = -1) ;
  
  //! Sets the color scale labels.
  Standard_EXPORT   void SetLabels (const TColStd_SequenceOfExtendedString& aSeq) ;
  
  //! Sets the color scale colors.
  Standard_EXPORT   void SetColors (const Aspect_SequenceOfColor& aSeq) ;
  
  //! Sets the color scale labels position concerning color filled rectangles.
  Standard_EXPORT   void SetLabelPosition (const Aspect_TypeOfColorScalePosition aPos) ;
  
  //! Sets the color scale title position.
  Standard_EXPORT   void SetTitlePosition (const Aspect_TypeOfColorScalePosition aPos) ;
  
  //! Sets true if the labels and colors used in reversed order.
  Standard_EXPORT   void SetReversed (const Standard_Boolean aReverse) ;
  
  //! Sets true if the labels placed at border of color filled rectangles.
  Standard_EXPORT   void SetLabelAtBorder (const Standard_Boolean anOn) ;
  
  //! Returns the size of color scale.
  Standard_EXPORT   void GetSize (Standard_Real& aWidth, Standard_Real& aHeight)  const;
  
  //! Returns the width of color scale.
  Standard_EXPORT   Standard_Real GetWidth()  const;
  
  //! Returns the height of color scale.
  Standard_EXPORT   Standard_Real GetHeight()  const;
  
  //! Sets the size of color scale.
  Standard_EXPORT   void SetSize (const Standard_Real aWidth, const Standard_Real aHeight) ;
  
  //! Sets the width of color scale.
  Standard_EXPORT   void SetWidth (const Standard_Real aWidth) ;
  
  //! Sets the height of color scale.
  Standard_EXPORT   void SetHeight (const Standard_Real aHeight) ;
  
  //! Returns the position of color scale.
  Standard_EXPORT   void GetPosition (Standard_Real& aX, Standard_Real& aY)  const;
  
  //! Returns the X position of color scale.
  Standard_EXPORT   Standard_Real GetXPosition()  const;
  
  //! Returns the height of color scale.
  Standard_EXPORT   Standard_Real GetYPosition()  const;
  
  //! Sets the position of color scale.
  Standard_EXPORT   void SetPosition (const Standard_Real aX, const Standard_Real aY) ;
  
  //! Sets the X position of color scale.
  Standard_EXPORT   void SetXPosition (const Standard_Real aX) ;
  
  //! Sets the Y position of color scale.
  Standard_EXPORT   void SetYPosition (const Standard_Real aY) ;
  
  Standard_EXPORT   Standard_Integer GetTextHeight()  const;
  
  Standard_EXPORT   void SetTextHeight (const Standard_Integer aHeigh) ;
  
  Standard_EXPORT virtual   void PaintRect (const Standard_Integer X, const Standard_Integer Y, const Standard_Integer W, const Standard_Integer H, const Quantity_Color& aColor, const Standard_Boolean aFilled = Standard_False)  = 0;
  
  Standard_EXPORT virtual   void PaintText (const TCollection_ExtendedString& aText, const Standard_Integer X, const Standard_Integer Y, const Quantity_Color& aColor)  = 0;
  
  Standard_EXPORT virtual   Standard_Integer TextWidth (const TCollection_ExtendedString& aText)  const = 0;
  
  Standard_EXPORT virtual   Standard_Integer TextHeight (const TCollection_ExtendedString& aText)  const = 0;




  DEFINE_STANDARD_RTTI(Aspect_ColorScale)

protected:

  
  Standard_EXPORT Aspect_ColorScale();
  
  Standard_EXPORT   void SizeHint (Standard_Integer& aWidth, Standard_Integer& aHeight)  const;
  
  Standard_EXPORT virtual   void UpdateColorScale() ;
  
  Standard_EXPORT   void DrawScale (const Quantity_Color& aBgColor, const Standard_Integer X, const Standard_Integer Y, const Standard_Integer W, const Standard_Integer H) ;
  
  Standard_EXPORT virtual   Standard_Boolean BeginPaint() ;
  
  Standard_EXPORT virtual   Standard_Boolean EndPaint() ;



private: 

  
  Standard_EXPORT   TCollection_AsciiString Format()  const;
  
  Standard_EXPORT   TCollection_ExtendedString GetCurrentLabel (const Standard_Integer anIndex)  const;
  
  Standard_EXPORT   Quantity_Color GetCurrentColor (const Standard_Integer anIndex)  const;
  
  Standard_EXPORT   Standard_Real GetNumber (const Standard_Integer anIndex)  const;
  
  Standard_EXPORT static   Standard_Integer HueFromValue (const Standard_Integer aValue, const Standard_Integer aMin, const Standard_Integer aMax) ;

  Standard_Real myMin;
  Standard_Real myMax;
  TCollection_ExtendedString myTitle;
  TCollection_AsciiString myFormat;
  Standard_Integer myInterval;
  Aspect_TypeOfColorScaleData myColorType;
  Aspect_TypeOfColorScaleData myLabelType;
  Standard_Boolean myAtBorder;
  Standard_Boolean myReversed;
  Aspect_SequenceOfColor myColors;
  TColStd_SequenceOfExtendedString myLabels;
  Aspect_TypeOfColorScalePosition myLabelPos;
  Aspect_TypeOfColorScalePosition myTitlePos;
  Standard_Real myXPos;
  Standard_Real myYPos;
  Standard_Real myWidth;
  Standard_Real myHeight;
  Standard_Integer myTextHeight;


};







#endif // _Aspect_ColorScale_HeaderFile
