/*
-----------------------------------------------------------------------------
This source file is part of OGRE
(Object-oriented Graphics Rendering Engine)
For the latest info, see http://www.ogre3d.org/

Copyright (c) 2000-2012 Torus Knot Software Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
-----------------------------------------------------------------------------
*/
#ifndef __ParticleIterator_H__
#define __ParticleIterator_H__

#include "OgrePrerequisites.h"

namespace Ogre {


	/** \addtogroup Core
	*  @{
	*/
	/** \addtogroup Effects
	*  @{
	*/
	/** Convenience class to make it easy to step through all particles in a ParticleSystem.
    */
    class _OgreExport ParticleIterator
    {
        friend class ParticleSystem;
    protected:
        list<Particle*>::type::iterator mPos;
        list<Particle*>::type::iterator mStart;
        list<Particle*>::type::iterator mEnd;

        /// Protected constructor, only available from ParticleSystem::getIterator
        ParticleIterator(list<Particle*>::type::iterator start, list<Particle*>::type::iterator end);

    public:
        // Returns true when at the end of the particle list
        bool end(void);

        /** Returns a pointer to the next particle, and moves the iterator on by 1 element. */
        Particle* getNext(void);
    };
	/** @} */
	/** @} */
}


#endif

