//@ skip

function shouldBe(actual, expected) {
    if (actual !== expected)
        throw new Error('bad value: ' + actual);
}

function shouldThrow(func, message) {
    var error = null;
    try {
        func();
    } catch (e) {
        error = e;
    }
    if (!error)
        throw new Error("not thrown.");
    if (String(error) !== message)
        throw new Error("bad error: " + String(error));
}

/*
wasm/arithmetic-int32.wasm is generated by pack-asmjs <https://github.com/WebAssembly/polyfill-prototype-1> from the following script:

function asmModule(global, env, buffer) {
    "use asm";

    var clz32 = global.Math.clz32;
    var imul = global.Math.imul;
    var abs = global.Math.abs;
    var min = global.Math.min;
    var max = global.Math.max;

    function negate(x) {
        x = x | 0;
        return (-x) | 0;
    }

    function add(x, y) {
        x = x | 0;
        y = y | 0;
        return (x + y) | 0;
    }

    function subtract(x, y) {
        x = x | 0;
        y = y | 0;
        return (x - y) | 0;
    }

    function multiply(x, y) {
        x = x | 0;
        y = y | 0;
        return imul(x, y) | 0;
    }

    function divide(x, y) {
        x = x | 0;
        y = y | 0;
        return ((x | 0) / (y | 0)) | 0;
    }

    function unsignedDivide(x, y) {
        x = x | 0;
        y = y | 0;
        return ((x >>> 0) / (y >>> 0)) | 0;
    }

    function modulo(x, y) {
        x = x | 0;
        y = y | 0;
        return ((x | 0) % (y | 0)) | 0;
    }

    function unsignedModulo(x, y) {
        x = x | 0;
        y = y | 0;
        return ((x >>> 0) % (y >>> 0)) | 0;
    }

    function bitNot(x) {
        x = x | 0;
        return ~x;
    }

    function bitOr(x, y) {
        x = x | 0;
        y = y | 0;
        return x | y;
    }

    function bitAnd(x, y) {
        x = x | 0;
        y = y | 0;
        return x & y;
    }

    function bitXor(x, y) {
        x = x | 0;
        y = y | 0;
        return x ^ y;
    }

    function leftShift(x, y) {
        x = x | 0;
        y = y | 0;
        return x << y;
    }

    function arithmeticRightShift(x, y) {
        x = x | 0;
        y = y | 0;
        return x >> y;
    }

    function logicalRightShift(x, y) {
        x = x | 0;
        y = y | 0;
        return (x >>> y) | 0;
    }

    function countLeadingZeros(x) {
        x = x | 0;
        return clz32(x);
    }

    function logicalNot(x) {
        x = x | 0;
        return (!x) | 0;
    }

    function absolute(x) {
        x = x | 0;
        return abs(x | 0) | 0;
    }

    function minimum(x, y, z) {
        x = x | 0;
        y = y | 0;
        z = z | 0;
        return min(x | 0, y | 0, z | 0);
    }

    function maximum(x, y, z) {
        x = x | 0;
        y = y | 0;
        z = z | 0;
        return max(x | 0, y | 0, z | 0);
    }

    return {
        negate: negate,
        add: add,
        subtract: subtract,
        multiply: multiply,
        divide: divide,
        unsignedDivide: unsignedDivide,
        modulo: modulo,
        unsignedModulo: unsignedModulo,
        bitNot: bitNot,
        bitOr: bitOr,
        bitAnd: bitAnd,
        bitXor: bitXor,
        leftShift: leftShift,
        arithmeticRightShift: arithmeticRightShift,
        logicalRightShift: logicalRightShift,
        countLeadingZeros: countLeadingZeros,
        logicalNot: logicalNot,
        absolute: absolute,
        minimum: minimum,
        maximum: maximum,
    };
}
*/

var module = loadWebAssembly("wasm/arithmetic-int32.wasm");

shouldBe(module.negate(42), -42);
shouldBe(module.add(1, 2), 3);
shouldBe(module.add(2147483647, 1), -2147483648);
shouldBe(module.subtract(1, 2), -1);
shouldBe(module.multiply(2, 3), 6);
shouldBe(module.multiply(-2147483648, -1), -2147483648);
shouldBe(module.divide(7, 3), 2);
shouldThrow(() => {
    module.divide(1, 0);
}, "Error: Division by zero or division overflow.");
shouldThrow(() => {
    module.divide(-2147483648, -1);
}, "Error: Division by zero or division overflow.");
shouldBe(module.unsignedDivide(-1, 2), 2147483647);
shouldThrow(() => {
    module.unsignedDivide(-1, 0);
}, "Error: Division by zero or division overflow.");
shouldBe(module.modulo(7, 3), 1);
shouldBe(module.modulo(-7, 3), -1);
shouldThrow(() => {
    module.modulo(1, 0);
}, "Error: Division by zero or division overflow.");
shouldThrow(() => {
    module.modulo(-2147483648, -1);
}, "Error: Division by zero or division overflow.");
shouldBe(module.unsignedModulo(-1, 100000), 67295);
shouldThrow(() => {
    module.unsignedModulo(-1, 0);
}, "Error: Division by zero or division overflow.");
shouldBe(module.bitNot(1), -2);
shouldBe(module.bitOr(3, 5), 7);
shouldBe(module.bitAnd(3, 5), 1);
shouldBe(module.bitXor(3, 5), 6);
shouldBe(module.leftShift(1, 16), 65536);
shouldBe(module.arithmeticRightShift(-1, 16), -1);
shouldBe(module.logicalRightShift(-1, 16), 65535);
shouldBe(module.countLeadingZeros(42), 26);
shouldBe(module.countLeadingZeros(0), 32);
shouldBe(module.logicalNot(42), 0);
shouldBe(module.logicalNot(0), 1);
shouldBe(module.absolute(-42), 42);
shouldBe(module.absolute(42), 42);
shouldBe(module.minimum(1, -2, 3), -2);
shouldBe(module.maximum(1, -2, 3), 3);
