OTRS Administrator's Manual
===========================

This repository contains the sources of the OTRS admin manual.
They are located in en/ and stored in docbook format. The other languages are
automatically generated with the help of po4a and the translation files in i18n.


How to Generate HTML from the Sources
-------------------------------------

You need to install the xsltproc and docbook-xsl packages (names may vary depending
on your distribution).

Then you can run

```
cd /tmp
xsltproc --xinclude /usr/share/xsl/docbook-xsl/html/chunk.xsl /path/to/doc-admin/en/book.xml
```

The paths may vary, on MacOS docbook-xsl is located in /opt/local/xsl/...


How to Validate the Sources
---------------------------

You need to install the xmllint and docbook-xml packages.

Then you can run
```
xmllint --postvalid --nonet --xinclude --noout /path/to/doc-admin/en/book.xml
```

You will see some errors like

```
content/administration/ticket/states.xml:154: element link: validity error : IDREF attribute linkend references an unknown ID "Ticket:Frontend::Agent::Ticket::ViewEmailNew:Ticket::Frontend::AgentTicketEmail_StateDefault"
```

These are not problematic as a part of the admin manual is autogenerated -
the configuration parameter reference. If you only see these link validity errors
everything should be fine.


Translating the Sources
-----------------------

Please refer to http://doc.otrs.org/developer/3.3/en/html/translating-docs.html.
