require 'spec_helper'

describe 'collectd::plugin::ping', type: :class do
  on_supported_os(baseline_os_hash).each do |os, facts|
    context "on #{os} " do
      let :facts do
        facts
      end
      let :pre_condition do
        'include collectd'
      end

      options = os_specific_options(facts)

      context ':hosts => [\'google.com\']' do
        let :params do
          { hosts: ['google.com'] }
        end

        it { is_expected.to compile.with_all_deps }

        it "Will create #{options[:plugin_conf_dir]}/10-ping.conf" do
          is_expected.to contain_file('ping.load').with(
            ensure: 'present',
            path: "#{options[:plugin_conf_dir]}/10-ping.conf",
            content: %r{Host "google.com"}
          )
        end
      end

      context 'all options set' do
        let :params do
          {
            hosts: ['google.com'],
            manage_package: true,
            interval: 1.23,
            timeout: 0.5,
            ttl: 5,
            source_address: '123.123.123.123',
            device: 'eth0',
            max_missed: 12,
            size: 5
          }
        end

        content = <<EOS
# Generated by Puppet
<LoadPlugin ping>
  Globals false
  Interval 1.23
</LoadPlugin>

<Plugin ping>
  Host "google.com"
  Interval "1.23"
  Timeout "0.5"
  TTL "5"
  SourceAddress "123.123.123.123"
  Device "eth0"
  MaxMissed "12"
  Size "5"
</Plugin>

EOS

        it "Will create #{options[:plugin_conf_dir]}/10-ping.conf" do
          is_expected.to contain_file('ping.load').with(
            ensure: 'present',
            path: "#{options[:plugin_conf_dir]}/10-ping.conf",
            content: content
          )
        end
      end

      context ':hosts => [\'google.com\', \'puppetlabs.com\']' do
        let :params do
          { hosts: ['google.com', 'puppetlabs.com'] }
        end

        it "Will create #{options[:plugin_conf_dir]}/10-ping.conf" do
          is_expected.to contain_file('ping.load').with(
            ensure: 'present',
            path: "#{options[:plugin_conf_dir]}/10-ping.conf"
          ).with_content(
            %r{Host "google.com"}
          ).with_content(
            %r{Host "puppetlabs.com"}
          )
        end
      end

      context ':ensure => absent' do
        let :params do
          { hosts: ['google.com'], ensure: 'absent' }
        end

        it "Will not create #{options[:plugin_conf_dir]}/10-ping.conf" do
          is_expected.to contain_file('ping.load').with(
            ensure: 'absent',
            path: "#{options[:plugin_conf_dir]}/10-ping.conf"
          )
        end
      end

      context ':hosts is not an array' do
        let :params do
          { hosts: 'google.com' }
        end

        it 'Will raise an error about :interfaces being a String' do
          is_expected.to compile.and_raise_error(%r{String})
        end
      end
    end
  end
end
