/*
 * Decompiled with CFR 0.152.
 */
package visad.install;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public abstract class Download {
    public static void getFile(URL url, File saveFile, boolean verbose) {
        Download.getFile(url, saveFile, false, verbose);
    }

    public static void getFile(URL url, File saveFile, boolean backUpExisting, boolean verbose) {
        BufferedOutputStream out;
        BufferedInputStream in;
        URLConnection conn;
        String baseName;
        File target;
        if (verbose) {
            System.err.println("Downloading " + url + " to " + saveFile);
        }
        if (!saveFile.isDirectory()) {
            target = saveFile;
            baseName = saveFile.getName();
        } else {
            File baseFile = new File(url.getFile());
            baseName = baseFile.getName();
            if (baseName.length() == 0) {
                baseName = "file";
            }
            target = new File(saveFile, baseName);
        }
        try {
            conn = url.openConnection();
        }
        catch (IOException ioe) {
            System.err.println("Couldn't open \"" + url + "\"");
            return;
        }
        if (target.exists()) {
            conn.setIfModifiedSince(target.lastModified());
        }
        if (conn.getContentLength() < 0) {
            if (verbose) {
                System.err.println(url + " is not newer than " + target);
            }
            return;
        }
        if (backUpExisting && target.exists()) {
            int idx = 0;
            while (true) {
                File tmpFile;
                if (!(tmpFile = new File(saveFile, baseName + "." + idx)).exists()) {
                    if (target.renameTo(tmpFile)) break;
                    System.err.println("Couldn't rename \"" + target + "\" to \"" + tmpFile + "\"");
                    target.delete();
                    break;
                }
                ++idx;
            }
        }
        try {
            InputStream uIn = conn.getInputStream();
            in = new BufferedInputStream(uIn);
        }
        catch (IOException ioe) {
            System.err.println("Couldn't read \"" + url + "\"");
            return;
        }
        try {
            FileOutputStream fOut = new FileOutputStream(target);
            out = new BufferedOutputStream(fOut);
        }
        catch (IOException ioe) {
            System.err.println("Couldn't write \"" + target + "\"");
            return;
        }
        byte[] block = new byte[1024];
        while (true) {
            int len;
            try {
                len = in.read(block);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                break;
            }
            if (len < 0) break;
            try {
                out.write(block, 0, len);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                break;
            }
        }
        try {
            out.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            in.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        long connMod = conn.getLastModified();
        if (connMod != 0L) {
            target.setLastModified(connMod);
        }
        if (verbose) {
            System.out.println("Successfully updated " + target);
        }
    }
}

