/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public class LIMReader
extends FormatReader {
    private boolean isCompressed;

    public LIMReader() {
        super("Laboratory Imaging", "lim");
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        this.in.seek(2379L);
        this.in.read(buf);
        if (this.core.rgb[0]) {
            for (int i = 0; i < buf.length / 3; ++i) {
                byte tmp = buf[i * 3];
                buf[i * 3] = buf[i * 3 + 2];
                buf[i * 3 + 2] = tmp;
            }
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("LIMReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.core.littleEndian[0] = true;
        this.in.order(this.core.littleEndian[0]);
        this.core.sizeX[0] = this.in.readShort() & Short.MAX_VALUE;
        this.core.sizeY[0] = this.in.readShort();
        int bits = this.in.readShort();
        while (bits % 8 != 0) {
            ++bits;
        }
        switch (bits) {
            case 8: {
                this.core.pixelType[0] = 1;
                break;
            }
            case 16: {
                this.core.pixelType[0] = 3;
                break;
            }
            case 24: {
                this.core.pixelType[0] = 1;
                this.core.sizeC[0] = 3;
                break;
            }
            case 32: {
                this.core.pixelType[0] = 5;
                break;
            }
            case 48: {
                this.core.pixelType[0] = 3;
                this.core.sizeC[0] = 3;
                break;
            }
            default: {
                throw new FormatException("Unsupported bits per pixel : " + bits);
            }
        }
        boolean bl = this.isCompressed = this.in.readShort() != 0;
        if (this.isCompressed) {
            throw new FormatException("Compressed LIM files not supported.");
        }
        this.core.imageCount[0] = 1;
        this.core.sizeZ[0] = 1;
        this.core.sizeT[0] = 1;
        if (this.core.sizeC[0] == 0) {
            this.core.sizeC[0] = 1;
        }
        this.core.rgb[0] = this.core.sizeC[0] > 1;
        this.core.currentOrder[0] = "XYZCT";
        this.core.indexed[0] = false;
        this.core.falseColor[0] = false;
        this.core.interleaved[0] = true;
        this.core.metadataComplete[0] = true;
        MetadataStore store = this.getMetadataStore();
        FormatTools.populatePixels(store, this);
        store.setImage(this.currentId, null, null, null);
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }
}

