/*
 * Decompiled with CFR 0.152.
 */
package thredds.viewer.gis.shapefile;

import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import thredds.datamodel.gis.AbstractGisFeature;
import thredds.datamodel.gis.GisPart;
import thredds.viewer.gis.shapefile.BeLeDataInputStream;

public class EsriShapefile {
    public static final int SHAPEFILE_CODE = 9994;
    public static final int NULL = 0;
    public static final int POINT = 1;
    public static final int POLYLINE = 3;
    public static final int POLYGON = 5;
    public static final int MULTIPOINT = 8;
    public static final int POINTZ = 11;
    public static final int POLYLINEZ = 13;
    public static final int POLYGONZ = 15;
    public static final int MULTIPOINTZ = 18;
    public static final int POINTM = 21;
    public static final int POLYLINEM = 23;
    public static final int POLYGONM = 25;
    public static final int MULTIPOINTM = 28;
    public static final int MULTIPATCH = 31;
    private BeLeDataInputStream bdis;
    private int fileBytes;
    private int bytesSeen = 0;
    private int version;
    private int fileShapeType;
    private ArrayList features;
    private Rectangle2D listBounds;
    private double resolution;
    private static final double defaultCoarseness = 0.0;
    private double coarseness = 0.0;
    private double[] xyPoints = new double[100];

    public EsriShapefile(String filename) throws IOException {
        this(filename, null);
    }

    public EsriShapefile(URL url) throws IOException {
        this(url, null);
    }

    public EsriShapefile(String filename, double coarseness) throws IOException {
        this(filename, null, coarseness);
    }

    public EsriShapefile(URL url, double coarseness) throws IOException {
        this(url, null, coarseness);
    }

    public EsriShapefile(URL url, Rectangle2D bBox, double coarseness) throws IOException {
        this(new DataInputStream(url.openStream()), bBox, coarseness);
    }

    public EsriShapefile(String filename, Rectangle2D bBox, double coarseness) throws IOException {
        this(new FileInputStream(filename), bBox, coarseness);
    }

    public EsriShapefile(URL url, Rectangle2D bBox) throws IOException {
        this(new DataInputStream(url.openStream()), bBox, 0.0);
    }

    public EsriShapefile(String filename, Rectangle2D bBox) throws IOException {
        this(new FileInputStream(filename), bBox, 0.0);
    }

    public EsriShapefile(InputStream iStream, Rectangle2D bBox, double coarseness) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(iStream);
        this.coarseness = coarseness < 0.0 ? 0.0 : coarseness;
        if (EsriShapefile.isZipStream(bin)) {
            ZipInputStream zin = new ZipInputStream(bin);
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                if (ze.getName().endsWith(".shp") || ze.getName().endsWith(".SHP")) {
                    this.bdis = new BeLeDataInputStream(zin);
                    this.Init(bBox);
                    return;
                }
                zin.closeEntry();
            }
            throw new IOException("no .shp entry found in zipped input");
        }
        this.bdis = new BeLeDataInputStream(bin);
        this.Init(bBox);
    }

    static boolean isZipStream(InputStream is) throws IOException {
        is.mark(5);
        int c1 = is.read();
        int c2 = is.read();
        int c3 = is.read();
        int c4 = is.read();
        is.reset();
        return c1 == 80 && c2 == 75 && c3 == 3 && c4 == 4;
    }

    private void Init(Rectangle2D bBox) throws IOException {
        int fileCode = this.readInt();
        if (fileCode != 9994) {
            throw new IOException("Not a shapefile");
        }
        this.skipBytes(20);
        this.fileBytes = 2 * this.readInt();
        this.version = this.readLEInt();
        this.fileShapeType = this.readLEInt();
        this.listBounds = this.readBoundingBox();
        if (bBox == null) {
            bBox = this.listBounds;
        }
        double xu = bBox.getMaxX();
        double yu = bBox.getMaxY();
        double xl = bBox.getMinX();
        double yl = bBox.getMinY();
        double w = 1000.0;
        double h = 1000.0;
        this.resolution = 1.0 / (this.coarseness * Math.min(Math.abs(xu - xl) / w, Math.abs(yu - yl) / h));
        this.skipBytes(32);
        this.features = new ArrayList();
        while (this.bytesSeen < this.fileBytes) {
            EsriFeature gf = this.nextFeature();
            if (!gf.getBounds2D().intersects(bBox)) continue;
            this.features.add(gf);
        }
    }

    public double percentRead() {
        return (double)this.bytesSeen / (double)this.fileBytes;
    }

    public int getNumFeatures() {
        return this.features.size();
    }

    public int numShapes() {
        return this.features.size();
    }

    private Rectangle2D readBoundingBox() throws IOException {
        double xMin = this.readLEDouble();
        double yMin = this.readLEDouble();
        double xMax = this.readLEDouble();
        double yMax = this.readLEDouble();
        double width = xMax - xMin;
        double height = yMax - yMin;
        return new Rectangle2D.Double(xMin, yMin, width, height);
    }

    private EsriFeature nextFeature() throws IOException {
        int recordNumber = this.readInt();
        int contentLength = this.readInt();
        int featureType = this.readLEInt();
        switch (featureType) {
            case 0: {
                return new EsriNull();
            }
            case 1: {
                return new EsriPoint();
            }
            case 8: {
                return new EsriMultipoint();
            }
            case 3: {
                return new EsriPolyline();
            }
            case 5: {
                return new EsriPolygon();
            }
        }
        throw new IOException("can't handle shapefile shape type " + featureType);
    }

    private int readLEInt() throws IOException {
        this.bytesSeen += 4;
        return this.bdis.readLEInt();
    }

    private int readInt() throws IOException {
        this.bytesSeen += 4;
        return this.bdis.readInt();
    }

    private double readLEDouble() throws IOException {
        this.bytesSeen += 8;
        return this.bdis.readLEDouble();
    }

    private void readLEDoubles(double[] d, int n) throws IOException {
        this.bdis.readLEDoubles(d, n);
        this.bytesSeen += 8 * n;
    }

    private void skipBytes(int n) throws IOException {
        this.bdis.skip(n);
        this.bytesSeen += n;
    }

    public int getVersion() {
        return this.version;
    }

    public Rectangle2D getBoundingBox() {
        return this.listBounds;
    }

    public List getFeatures() {
        return this.features;
    }

    public List getFeatures(Rectangle2D bBox) {
        if (bBox == null) {
            return this.features;
        }
        ArrayList<EsriFeature> list = new ArrayList<EsriFeature>();
        for (EsriFeature gf : this.features) {
            if (!gf.getBounds2D().intersects(bBox)) continue;
            list.add(gf);
        }
        return list;
    }

    private void discretize(double[] d, int n) {
        if (this.coarseness == 0.0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            d[i] = Math.rint(this.resolution * d[i]) / this.resolution;
        }
    }

    static /* synthetic */ double[] access$202(EsriShapefile x0, double[] x1) {
        x0.xyPoints = x1;
        return x1;
    }

    class EsriPart
    implements GisPart {
        private int numPoints = 0;
        private double[] x;
        private double[] y;

        public EsriPart(int num, double[] xyPoints, int xyOffset) {
            double yi;
            double xi;
            int ixy = xyOffset;
            this.numPoints = 1;
            double xx = xyPoints[ixy++];
            double yy = xyPoints[ixy++];
            for (int i = 1; i < num; ++i) {
                xi = xyPoints[ixy++];
                yi = xyPoints[ixy++];
                if (xi == xx && yi == yy) continue;
                ++this.numPoints;
                xx = xi;
                yy = yi;
            }
            this.x = new double[this.numPoints];
            this.y = new double[this.numPoints];
            ixy = xyOffset;
            int j = 0;
            this.x[j] = xyPoints[ixy++];
            this.y[j] = xyPoints[ixy++];
            xx = this.x[j];
            yy = this.y[j];
            for (int i = 1; i < num; ++i) {
                xi = xyPoints[ixy++];
                yi = xyPoints[ixy++];
                if (xi == xx && yi == yy) continue;
                this.x[++j] = xi;
                this.y[j] = yi;
                xx = this.x[j];
                yy = this.y[j];
            }
        }

        public int getNumPoints() {
            return this.numPoints;
        }

        public double[] getX() {
            return this.x;
        }

        public double[] getY() {
            return this.y;
        }
    }

    public class EsriNull
    extends EsriFeature {
        public EsriNull() {
            boolean numPoints = false;
        }
    }

    public class EsriPoint
    extends EsriFeature {
        public EsriPoint() throws IOException {
            int numPoints = 1;
            EsriShapefile.this.readLEDoubles(EsriShapefile.this.xyPoints, 2 * numPoints);
            EsriShapefile.this.discretize(EsriShapefile.this.xyPoints, 2 * numPoints);
            EsriPart gp = new EsriPart(numPoints, EsriShapefile.this.xyPoints, 0);
            this.partsList.add(gp);
            this.bounds = new Rectangle2D.Double(EsriShapefile.this.xyPoints[0], EsriShapefile.this.xyPoints[1], 0.0, 0.0);
        }
    }

    public class EsriMultipoint
    extends EsriFeature {
        public EsriMultipoint() throws IOException {
            this.bounds = EsriShapefile.this.readBoundingBox();
            int numPoints = EsriShapefile.this.readLEInt();
            if (EsriShapefile.this.xyPoints.length < 2 * numPoints) {
                EsriShapefile.access$202(EsriShapefile.this, new double[2 * numPoints]);
            }
            EsriShapefile.this.readLEDoubles(EsriShapefile.this.xyPoints, 2 * numPoints);
            EsriShapefile.this.discretize(EsriShapefile.this.xyPoints, 2 * numPoints);
            EsriPart gp = new EsriPart(numPoints, EsriShapefile.this.xyPoints, 0);
            this.partsList.add(gp);
        }
    }

    public class EsriPolyline
    extends EsriFeature {
        public EsriPolyline() throws IOException {
            this.bounds = EsriShapefile.this.readBoundingBox();
            this.numParts = EsriShapefile.this.readLEInt();
            this.numPoints = EsriShapefile.this.readLEInt();
            int[] parts = new int[this.numParts + 1];
            for (int j = 0; j < this.numParts; ++j) {
                parts[j] = EsriShapefile.this.readLEInt();
            }
            parts[this.numParts] = this.numPoints;
            if (EsriShapefile.this.xyPoints.length < 2 * this.numPoints) {
                EsriShapefile.access$202(EsriShapefile.this, new double[2 * this.numPoints]);
            }
            EsriShapefile.this.readLEDoubles(EsriShapefile.this.xyPoints, 2 * this.numPoints);
            EsriShapefile.this.discretize(EsriShapefile.this.xyPoints, 2 * this.numPoints);
            this.numPoints = 0;
            int ixy = 0;
            int numPartsLeft = 0;
            for (int part = 0; part < this.numParts; ++part) {
                int pointsInPart = parts[part + 1] - parts[part];
                EsriPart gp = new EsriPart(pointsInPart, EsriShapefile.this.xyPoints, ixy);
                if (gp.getNumPoints() > 1) {
                    this.partsList.add(gp);
                    this.numPoints += gp.getNumPoints();
                    ++numPartsLeft;
                }
                ixy += 2 * pointsInPart;
            }
            this.numParts = numPartsLeft;
        }
    }

    public class EsriPolygon
    extends EsriFeature {
        public EsriPolygon() throws IOException {
            this.bounds = EsriShapefile.this.readBoundingBox();
            this.numParts = EsriShapefile.this.readLEInt();
            this.numPoints = EsriShapefile.this.readLEInt();
            int[] parts = new int[this.numParts + 1];
            for (int j = 0; j < this.numParts; ++j) {
                parts[j] = EsriShapefile.this.readLEInt();
            }
            parts[this.numParts] = this.numPoints;
            if (EsriShapefile.this.xyPoints.length < 2 * this.numPoints) {
                EsriShapefile.access$202(EsriShapefile.this, new double[2 * this.numPoints]);
            }
            EsriShapefile.this.readLEDoubles(EsriShapefile.this.xyPoints, 2 * this.numPoints);
            EsriShapefile.this.discretize(EsriShapefile.this.xyPoints, 2 * this.numPoints);
            this.numPoints = 0;
            int ixy = 0;
            int numPartsLeft = 0;
            for (int part = 0; part < this.numParts; ++part) {
                int pointsInPart = parts[part + 1] - parts[part];
                EsriPart gp = new EsriPart(pointsInPart, EsriShapefile.this.xyPoints, ixy);
                if (gp.getNumPoints() > 1) {
                    this.partsList.add(gp);
                    this.numPoints += gp.getNumPoints();
                    ++numPartsLeft;
                }
                ixy += 2 * pointsInPart;
            }
            this.numParts = numPartsLeft;
        }
    }

    public abstract class EsriFeature
    extends AbstractGisFeature {
        protected Rectangle2D bounds;
        protected int numPoints;
        protected int numParts;
        protected List partsList = new ArrayList();

        public Rectangle2D getBounds2D() {
            return this.bounds;
        }

        public int getNumPoints() {
            return this.numPoints;
        }

        public int getNumParts() {
            return this.numParts;
        }

        public Iterator getGisParts() {
            return this.partsList.iterator();
        }
    }
}

