/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;

public class NcStreamWriter {
    private static int sizeToCache = 100;
    private NetcdfFile ncfile;
    private NcStreamProto.Header header;
    private boolean show = false;

    public NcStreamWriter(NetcdfFile ncfile, String location) throws IOException {
        this.ncfile = ncfile;
        NcStreamProto.Group.Builder rootBuilder = NcStream.encodeGroup(ncfile.getRootGroup(), sizeToCache);
        NcStreamProto.Header.Builder headerBuilder = NcStreamProto.Header.newBuilder();
        headerBuilder.setLocation(location == null ? ncfile.getLocation() : location);
        if (ncfile.getTitle() != null) {
            headerBuilder.setTitle(ncfile.getTitle());
        }
        if (ncfile.getId() != null) {
            headerBuilder.setId(ncfile.getId());
        }
        headerBuilder.setRoot(rootBuilder);
        this.header = headerBuilder.build();
    }

    public long sendHeader(WritableByteChannel wbc) throws IOException {
        long size = 0L;
        size += (long)this.writeBytes(wbc, NcStream.MAGIC_START);
        size += (long)this.writeBytes(wbc, NcStream.MAGIC_HEADER);
        byte[] b = this.header.toByteArray();
        size += (long)NcStream.writeVInt(wbc, b.length);
        if (this.show) {
            System.out.println("Write Header len=" + b.length);
        }
        size += (long)this.writeBytes(wbc, b);
        if (this.show) {
            System.out.println(" header size=" + size);
        }
        return size;
    }

    public long sendData(Variable v, Section section, WritableByteChannel wbc) throws IOException, InvalidRangeException {
        long size = 0L;
        size += (long)this.writeBytes(wbc, NcStream.MAGIC_DATA);
        NcStreamProto.Data dataProto = NcStream.encodeDataProto(v, section);
        byte[] datab = dataProto.toByteArray();
        size += (long)NcStream.writeVInt(wbc, datab.length);
        size += (long)this.writeBytes(wbc, datab);
        if (this.show) {
            System.out.println(v.getName() + " proto len=" + datab.length);
        }
        long len = section.computeSize();
        if (v.getDataType() != DataType.STRING && v.getDataType() != DataType.OPAQUE) {
            len *= (long)v.getElementSize();
        }
        size += (long)NcStream.writeVInt(wbc, (int)len);
        if (this.show) {
            System.out.println(v.getName() + " vlen=" + len);
        }
        long readCount = v.readToByteChannel(section, wbc);
        return readCount;
    }

    private int writeBytes(WritableByteChannel wbc, byte[] b) throws IOException {
        return wbc.write(ByteBuffer.wrap(b));
    }

    public void streamAll(WritableByteChannel wbc) throws IOException, InvalidRangeException {
        this.sendHeader(wbc);
        long size = 0L;
        for (Variable v : this.ncfile.getVariables()) {
            size += this.sendData(v, v.getShapeAsSection(), wbc);
        }
        if (this.show) {
            System.out.println(" total size=" + size);
        }
    }
}

