# -*- coding: utf-8 -*-

# a helper program takes a list of unordered words and returns a sorted and counted list suitable for the "di" word list. Best run in python3 if non ASCII characters are being used.
import os
import sys

os.chdir(os.path.abspath(os.path.dirname(sys.argv[0])))

mixed_list_of_words = [
"акт", "добави", "възраст", "преди", "въздух", "всички", "и", "всеки", "са", "изкуство", "лошо", "легло", "голямо", "малко", "кутия", "момче", "но", "купуват", "може", "кола", "котка", "вика", "нарязани", "ден", "е", "куче", "сух", "яде", "край", "далеч", "малко", "смокиня", "годни", "грип", "лети", "за", "забавно", "газ", "да", "имам", "имаше", "има", "шапка", "нея", "него", "негов", "хит", "горещ", "как", "лед", "негова", "работа", "ключ", "закон", "лежа", "доведе", "нека", "лъжа", "много", "ниско", "мъж", "карта", "май", "мъже", "нови", "нито", "не", "сега", "на разстояние", "стар", "един", "нашите", "вън", "собствени", "заплати", "на", "издънка", "пусна", "избяга", "червен", "ред", "бягай", "седна", "видя", "кажи", "море", "виж", "постави", "тя", "сър", "седя", "шест", "ски", "небе", "син", "шпионин", "сума", "слънце", "десет", "също", "top", "try", "two", "use", "war", "was", "way", "кой", "защо", "спечели", "да", "все пак", "ти", "можеш", "също", "област", "оръжия", "армия", "далеч", "бебе", "гръб", "топка", "банка", "база", "мечка", "победи", "беше", "звънец", "най-добре", "законопроект", "blab", "взриви", "blip", "петно", "петно", "удар", "син", "лодка", "тяло", "книга", "роден", "и двете", "трици", "brat", "bray", "варя", "ръб", "зает", "дойде", "грижа", "случай", "град", "облечен", "клам", "клан", "нокът", "глина", "клип", "буца", "клуб", "улика", "студ", "дойде", "готвач", "хладно", "копие", "царевица", "цена", "крави", "рак", "ясла врана", "тъмно", "сделката", "дълбоко", "прави", "направи", "врата", "надолу", "мрачен", "влачене", "рисуване", "дроп", "капка", "капка", "барабан", "всеки", "уши", "изток", "лесно", "ръб", "яйца", "друго", "дори", "някога", "очи", "лице", "факт", "справедливо", "падане", "ферма", "бързо", "страх", "чувствам", "крака", "падна", "почувства", "намери", "глоба", "огън", "риба", "пет", "флаг", "клапи", "плосък", "недостатък", "бълха", "летял", "гъвкав", "флип", "флоп", "поток", "храна", "крак", "четири", "безплатно", "жаба", "от", "пълен", "игра", "даде", "момиче", "давам", "радвам", "радост", "глоб", "блясък", "лепило", "злато", "няма", "добър", "граб", "сив", "израснал", "решетка", "мрачен", "усмивка", "сцепление", "песъчинки", "растат", "кърма", "коса", "спира", "ръка", "трудно", "главата", "чувам", "топлина", "държани", "помогне", "тук", "високо", "хълм", "задръжте", "дупка", "у дома", "надежда", "огромен", "идея", "в", "желязо", "просто", "пази", "държат", "вид", "цар", "знаеше", "знам", "дама", "езеро", "земя", "последна", "олово", "ляво", "крака", "по-малко", "живот", "като", "линия", "списък", "жив", "дълъг", "поглед", "загубен", "силен", "любов", "направен", "главен", "направи", "много", "марка",
"срещам", "мляко", "ум", "мина", "мис", "луна", "повече", "повечето", "се движи", "много", "трябва", "име", "близо", "трябва", "следващ", "нос", "бележка", "съществително", "веднъж", "само", "отворено", "над", "страница", "двойка", "парк", "част", "минало", "план", "играя", "полъх", "сюжет", "плуг", "щепсел", "слива", "стихотворение", "полюс", "беден", "молим", "продавай", "опора", "раса", "дъжд", "чета", "почивка", "богат", "езда", "пръстен", "изгрев", "път", "рок", "стая", "корен", "въже", "роза", "правило", "безопасно", "каза", "платно", "същото", "пясък", "спаси", "краста", "сканиране", "белег", "скат", "седалка", "видях", "продавам", "изпращам", "изпращам", "кораб", "магазин", "шоу", "страна", "знак", "пей", "размер", "скок", "кожа", "скип", "слим", "слам", "шамар", "шейна", "плъзгам", "тънък", "приплъзване", "цепка", "слот", "бавен", "слъг", "смог", "усмивка", "щракам", "сноб", "сняг", "плътно", "меко", "почва", "някои", "песен", "скоро", "span", "spat", "спин", "петно", "шпора", "звезда", "престой", "стъбло", "стъпка", "задушено", "разбъркайте", "стоп", "такъв", "сигурен", "плува", "лебед", "суап", "SWAT", "власт", "плувам", "опашка", "вземи", "говори", "висок", "екип", "кажи", "тест", "отколкото", "че", "тях", "тогава", "те", "тънки", "това", "по този начин", "вързани", "време", "малки", "каза", "тон", "взе", "град", "капан", "тава", "дърво", "Трек", "подреден", "пътуване", "тръс", "вярно", "тръба", "завой", "тип", "единица", "на", "глагол", "много", "изглед", "изчакайте", "стена", "искате", "топло", "измиване", "износ", "седмица", "добре", "отиде", "бяха", "запад", "какво", "кога", "широк", "жена", "дива", "ще", "вятър", "тел", "желание", "с", "дърво", "работа", "двор", "си", "за", "по-горе", "след", "отново", "напред", "разреши", "сам", "заедно", "сред", "ъгъл", "ябълка", "попита", "започна", "е", "по-долу", "птици", "черно", "острие", "вино", "празно", "бласт", "блеат", "кървя", "блепе", "бленда", "благослови", "слепи", "мига", "блок", "кръв", "цъфтят", "блъф", "тъп", "руж", "борда", "кости", "скоба", "плитка", "мозък", "спирачка", "марка", "месинг", "смел", "сбиване", "хляб", "почивка", "тухла", "булка", "донесе", "жив", "широк", "Брук", "метла", "бульон", "кафяв", "четка", "изграждане", "построен", "носят", "улов", "причина", "клетки", "центове", "диаграма", "проверка", "дете", "клакса", "претенция", "стяга", "звънец", "сблъсък", "закопчалка", "клас", "чист", "ясен", "чиновник", "клик", "стръм", "катерене", "плащ", "часовник", "клоп", "затваряне", "кърпа", "облак", "карамфил", "клоун", "глупости", "крайбрежие", "може", "брой", "пляскане", "занаят", "кран", "катастрофа", "пълзене", "луд", "крик", "пълзене", "плаче", "крякане", "мошеник", "култури", "кръст", "тълпа", "корона", "троха", "кора", "танц", "проект", "дренаж", "дракон", "пиеше", "драпе", "страх", "мечта", "рокля", "drip фута", "тренировка", "пиене", "шофиране", "дръпване", "задвижване", "рано", "земя", "осем", "наслаждавай се", "равен", "всеки", "поле", "бий се", "първо", "лющене", "пламък", "пламък", "светкавица", "флок", "флот", "плът", "лек удар", "хвърляне", "кремък", "поплавък", "стадо", "наводнение", "етаж", "конци", "брашно", "пух", "флуид", "мехурче", "глух", "вълна", "флейта", "сила", "намерен", "крехък",
"рамка", "Франк", "изрод", "свеж", "навивам", "фриз", "фронт", "слана", "плодове", "отблясъци", "стъкло", "блясък", "плъзгам", "gloat", "глобус", "мрак", "гланц", "ръкавица", "грация", "клас", "присадка", "зърно", "гранд", "грант", "грозде", "граф", "хватка", "трева", "решетка", "гроб", "сос", "паша", "голям", "алчност", "зелен", "поздрав", "грил", "мръсотия", "стон", "младоженец", "група", "ръмжене", "пораснал", "груб", "мързелив тежък", "кон", "часове", "къща", "човек", "познат", "голям", "по-късно", "научи", "най-малко", "остави", "ниво", "светлина", "мажор", "март", "мач", "може би", "означава", "метал", "може", "мили", "пари", "уста", "музика", "никога", "нощ", "север", "океан", "често", "ред", "други", "боя", "хартия", "партия", "парче", "място", "каре", "обикновен", "самолет", "дъска", "растителна", "плоча", "пледирам", "плисе", "пълнеж", "точка", "мощност", "преса", "цена", "гордост", "отпечатък", "награда", "сонда", "доказателство", "гордост", "доказателство", "риба", "река", "тиха", "доста", "радио", "готово", "право", "река", "кръгъл", "скалд", "скалп", "скап", "плач", "шал", "кавга", "скапа", "обхват", "резултат", "излъскване", "разузнавач", "скрам", "скрап", "винт", "търкане", "гмуркане", "счупване", "семена", "смисъл", "сервиране", "седем", "форма", "остри", "обувки", "кратък", "показан", "поглед", "тъй като", "скейт", "умение", "пола", "череп", "скункс", "слаби", "наклонени", "шисти", "лъскав", "сън", "сух", "спал", "парче", "хлъзгав", "слайд", "тиня", "малък", "интелигентен", "смачка", "намазка", "миризма", "усмивка", "халат", "дим", "закуска", "охлюв", "змия", "примка",
"ръмжене", "промъкване", "надушване", "snoop", "snore", "муцуна", "решаване", "звук", "юг", "пространство", "резервна", "искра", "говори", "копие", "петънце", "скорост", "заклинание", "харчене", "изразходване", "спайк", "разсипване", "гръбначен стълб говори", "лъжица", "спорт", "чучур", "спрей", "клон", "клякам", "калмар", "стек", "персонал", "етап", "петно", "стълбище", "залог", "остаряло", "дръжка", "печат", "щанд", "зрелище", "звезди", "начало", "състояние", "пържола", "кражба", "пара", "стомана", "стръмен", "стръв", "пръчка", "скован", "все още", "ходило", "ужилване", "воня", "запас", "камък", "стоял", "табуретка", "навес", "магазин", "буря", "история", "печка", "каишка", "слама", "бездомни", "лента стил", "захар", "блато", "рояк", "пот", "почистване", "сладка", "надута", "пометена", "бърза", "свиня", "люлка", "свир", "замах", "маса", "термини", "техните", "там", "тези", "дебели", "нещо", "мисля", "трето", "тези", "три", "днес", "инструменти", "общо", "докосване", "следа", "търговия", "пътека", "влак", "трамплин", "боклук", "протектора", "лечение", "дървета", "племе", "трик", "тромп", "войски", "пъстърва", "камион", "истински", "багажник", "доверие", "истина", "чичо", "под", "до", "стойност", "посещение", "глас", "гласна", "часовник", "вода", "вълни", "къде", "което", "докато", "бяло", "цяло", "чиито", "крила", "жена", "жени", "думи", "свят", "ще напиша", "греша", "написа", "години", "млади", "през", "действие", "страх", "съгласен", "почти", "винаги", "сума", "отговор", "изглежда", "около", "стана", "стана", "преди", "зад", "принадлежат", "освен", "по-добре", "избелване", "блондинка", "блуза", "дъно", "купено", "задушено", "клон", "дъх", "бриз", "мост", "светло", "счупено", "бронко", "бронз", "сърфиране", "набиване", "наричано", "не", "говеда", "уловени", "център", "шанс", "промяна", "изберете", "църква", "кръг", "килер", "съединител", "цвят", "колона", "общ", "ъгъл", "памук", "курс", "люлка", "пастел", "създаване", "криза", "пустиня", "дизайн", "директен", "лекар", "дракон", "по време", "ефект", "или", "енергия", "двигател", "достатъчно", "цяла", "с изключение на", "очаквам", "семейство", "известен", "баща", "фигура", "пълна", "полет", "цвете", "гора", "замръзване", "приятел", "страх", "ресни", "замразени", "градина", "поглед", "бъг", "грозде", "грес", "грух", "земя", "загриженост", "инчове", "вътре", "остров", "себе си", "присъединил се", "скочил", "убил", "дължина", "повдигнат", "слушал", "малко", "материя", "мелодия", "метод", "среден", "модерен", "момент", "месеци", "майка", "нация", "забележка", "номер", "обект", "офис", "кислород", "преминал", "хора", "период", "човек", "фраза", "избрани", "равнини", "планета", "растения", "играч", "моля", "залог", "изобилие", "множествено число", "паунда", "похвала", "молитва", "красива", "свещеник", "принц", "затвор", "изтеглен", "тласкан", "повдигнат", "по-скоро", "наистина", "причина", "запис", "регион", "остават", "доклад", "резултат", "връщане", "ритъм", "валцувани", "оскъдни", "училище",
"изгарям", "изстъргвай", "драскам", "крещя", "екран", "скрипт", "свитък", "втори", "изглеждаше", "трябва", "тихо", "прост", "единичен", "сестра", "скица", "сънлив", "ръкав", "лек", "бавно", "усмихнат", "гладка", "размазан", "грабнат", "кихане", "реч", "дух", "splash", "шина", "гъба", "навяхване", "sprang", "разпръскване", "разпространение", "пролет", "спринт", "кълнове", "смърч", "квадрат", "скуош", "скърцане", "скърцане", "скърцане", "кашон", "шприц", "мачкам", "стабилна", "щапелни", "нишесте", "гладувам", "статуя", "стабилно", "стерео", "лепкава", "стисна", "бод", "щам", "направление", "серия", "поток", "улица", "строг", "крачка", "стачка", "низ", "лента", "инсулт", "разходка", "силен", "ударен", "суфикс", "лято", "снабдяване", "мостра", "свиване", "система", "макар и към", "пътуване", "корито", "долина", "ходене", "тегло", "колела", "прозорец", "зима", "вътре", "чудо", "жълто", "против", "вече", "животни", "друг", "пристигнал", "защото", "вярвам", "между", "одеяло", "цвят", "брат", "донесе", "изгаряне", "капитал", "капитан", "век", "определено", "климат", "изкачи", "дрехи", "компания", "сравни", "съдържа", "контрол", "правилно", "страна", "покрито", "крикет", "ток", "решено", "десетичен", "подробности", "отдалечен", "разделен", "долари", "рисуване", "влязъл", "вечер", "точно", "например", "обясни", "експрес", "фактори", "фермери", "чувство", "накрая", "пръсти", "цветя", "напред", "товари", "приятели", "генерал", "гравитация", "сам", "история", "обаче", "сто", "лов", "включват насекоми", "вместо това", "смее се", "писма", "намира се", "машина", "мярка", "членове", "милиони", "минути", "сутрин", "естествено", "нищо", "цифра", "наблюдава", "отвън", "модел", "може би", "картина", "планети", "подготви", "представяш", "крендел", "отпечатан", "проблем", "процес", "продукция", "продукт", "програма", "проект", "обещание", "местоимение", "защита", "предоставяне", "бързо", "достигнал", "миди", "наука", "скутер", "скрепер", "надраскване", "писък", "секция", "уреден", "няколко", "извика", "подобен", "тиган", "чехъл", "притискам", "някой", "специален", "стискам", "стадион", "телбод", "започна", "станция", "стреме", "стомах", "странно", "участък", "предмет", "предполагам", "повърхност", "лястовица", "пуловер", "подсладени", "подути", "символи", "учител", "мисъл", "чрез", "неприятности", "тромпет", "обикновено", "различен", "селски", "метеорологичен", "западен", "без", "работници", "написани", "всъщност", "допълнение", "въпреки че", "нещо", "виелица", "клонове", "сграда", "бизнес", "деца", "облекло", "пълна", "съставни", "помислете", "опишете", "разделение", "електрически", "елементи", "уравнение", "всички", "вълнуващи", "упражнения", "завършени", "фракция", "лунички", "случи се", "увеличаване", "показват", "индустрия", "интерес", "език",
"материал", "движение", "северна", "противоположна", "приятна", "позиция", "възможно", "практика", "практика", "скъпоценна", "приготвена", "принцеса", "затворник", "вероятно", "продукти", "собственост", "получена", "помни", "повтаряна", "скалион", "драскане", "драскане", "изречение", "отделно", "рамо", "войници", "решение", "южен", "прекрасен", "раздробен", "поръсва", "катерица", "морска звезда", "чорап", "права", "цедка", "непознат", "сила", "по-силна", "борба", "студенти", "изведнъж", "изненада", "заедно", "триъгълник", "себе си", "прилагателно", "красиво", "начало", "внимателно съгласна", "продължава", "определя", "разработена", "различна", "трудна", "посока", "фабрики", "следваща", "хранителни стоки", "важни", "молекули", "планини", "необходима", "параграф", "президент", "директор", "професор", "произнася се", "пропелер", "въпроси", "представлява", "нещо", "понякога", "пръскачка", "изявление", "опъната", "носилка", "предложени", "срички", "хиляди", "подчертаване", "черна дъска", "условия", "речник", "разлика", "открити", "особено", "всичко", "опит", "експеримент", "фенерче", "правителство", "особено учени", "стационарни", "ягоди", "вещества", "самите", "разбират"
]

a = 0
for each in mixed_list_of_words:
    if len(each) > a:
        a = len(each)

word_sets = [[] for i in range(a)]
alphabet_lc = ['а', 'б', 'в', 'г', 'д', 'е', 'ж', 'з', 'и', 'й', 'к', 'л', 'м', 'н', 'о', 'п', 'р', 'с', 'т', 'у', 'ф',
               'х', 'ц', 'ч', 'ш', 'щ', 'ъ', 'ь', 'ю', 'я']
alphabet_uc = ['А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф',
               'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ь', 'Ю', 'Я']
accents = []
alpha = []
alpha.extend(alphabet_lc)
alpha.extend(alphabet_uc)
alpha.extend(accents)
ignore = [" ", "-", "'"]

for each in mixed_list_of_words:
    b = len(each)
    if 2 < b < 11:
        if each.lower()[0] in alpha:
            one_word = True
            for letter in each:
                if letter in ignore:
                    one_word = False
            if one_word:
                # if not a duplicate
                if each.lower() not in word_sets[b - 1]:
                    word_sets[b - 1].append(each.lower())

# save to file
file_name = os.path.join("new_list.txt")

for each in word_sets:
    a = len(each)
    if a > 0:
        each.sort()
        row = list()
        row.append(a)
        row.extend(each)
        # print(row)
        # save to file instead
        with open(file_name, 'a') as f:
            f.write("      " + str(row) + ",\n")
print("Completed - check the %s file." % file_name)

"""
initial word list
act, add, age, ago, air, all, and, any, are, art, bad, bed, big, bit, box, boy, but, buy, can, car, cat, cry, cut, day, did, dog, dry, eat, end, far, few, fig, fit, flu, fly, for, fun, gas, get, got, had, has, hat, her, him, his, hit, hot, how, ice, its, job, key, law, lay, led, let, lie, lot, low, man, map, may, men, new, nor, not, now, off, old, one, our, out, own, pay, per, pry, put, ran, red, row, run, sat, saw, say, sea, see, set, she, sir, sit, six, ski, sky, son, spy, sum, sun, ten, the, too, top, try, two, use, war, was, way, who, why, win, yes, yet, you, able, also, area, arms, army, away, baby, back, ball, bank, base, bear, beat, been, bell, best, bill, blab, blew, blip, blob, blot, blow, blue, boat, body, book, born, both, bran, brat, bray, brew, brim, busy, came, care, case, city, clad, clam, clan, clap, claw, clay, clip, clod, clog, club, clue, cold, come, cook, cool, copy, corn, cost, cows, crab, crib, crop, crow, dark, deal, deep, does, done, door, down, drab, drag, draw, drew, drip, drop, drum, each, ears, east, easy, edge, eggs, else, even, ever, eyes, face, fact, fair, fall, farm, fast, fear, feel, feet, fell, felt, find, fine, fire, fish, five, flag, flap, flat, flaw, flea, flew, flex, flip, flop, flow, food, foot, four, free, frog, from, full, game, gave, girl, give, glad, glee, glob, glow, glue, gold, gone, good, grab, gram, gray, grew, grid, grim, grin, grip, grit, grow, grub, hair, halt, hand, hard, have, head, hear, heat, held, help, here, high, hill, hold, hole, home, hope, huge, idea, into, iron, just, keep, kept, kind, king, knew, know, lady, lake, land, last, lead, left, legs, less, life, like, line, list, live, long, look, lost, loud, love, made, main, make, many, mark,
meet, milk, mind, mine, miss, moon, more, most, move, much, must, name, near, need, next, nose, note, noun, once, only, open, over, page, pair, park, part, past, plan, play, plod, plot, plow, plug, plum, poem, pole, poor, pray, prod, prop, race, rain, read, rest, rich, ride, ring, rise, road, rock, room, root, rope, rose, rule, safe, said, sail, same, sand, save, scab, scan, scar, scat, seat, seen, sell, send, sent, ship, shop, show, side, sign, sing, size, skid, skin, skip, skit, slab, slam, slap, sled, slid, slim, slip, slit, slot, slow, slug, smog, snag, snap, snip, snob, snow, snug, soft, soil, some, song, soon, span, spat, spin, spot, spur, star, stay, stem, step, stew, stir, stop, such, sure, swam, swan, swap, swat, sway, swim, tail, take, talk, tall, team, tell, test, than, that, them, then, they, thin, this, thus, tied, time, tiny, told, tone, took, town, trap, tray, tree, trek, trim, trip, trot, true, tube, turn, type, unit, upon, verb, very, view, wait, wall, want, warm, wash, wear, week, well, went, were, west, what, when, wide, wife, wild, will, wind, wire, wish, with, wood, work, yard, your, about, above, after, again, ahead, allow, alone, along, among, angle, apple, asked, began, being, below, birds, black, blade, blame, blank, blast, blaze, bleat, bleed, bleep, blend, bless, blind, blink, block, blood, bloom, bluff, blunt, blush, board, bones, brace, braid, brain, brake, brand, brass, brave, brawl, bread, break, brick, bride, bring, brisk, broad, broil, broke, brood, brook, broom, broth, brown, brush, build, built, carry, catch, cause, cells, cents, chart, check, child, clack, claim, clamp, clang, clash, clasp, class, clean, clear, cleat, clerk, click, cliff, climb, cling, clink, cloak, clock, clomp, close, cloth, cloud, clove, clown, cluck, clump, coast, could, count, crack, craft, crane, crash, crawl, crazy, creek, creep, cried, croak, crook, crops, cross, crowd, crown, crumb, crust, dance, draft, drain, drake, drank, drape, dread, dream, dress, drift, drill, drink, drive, droop, drove, early, earth, eight, enjoy, equal, every, field, fight, first, flake, flame, flare, flash, fleck, fleet, flesh, flick, fling, flint, float, flock, flood, floor, floss, flour, fluff, fluid, fluke, flunk, flush, flute, force, found, frail,
frame, frank, freak, fresh, frill, frizz, front, frost, fruit, glare, glass, gleam, glide, gloat, globe, gloom, gloss, glove, grace, grade, graft, grain, grand, grant, grape, graph, grasp, grass, grate, grave, gravy, graze, great, greed, green, greet, grill, grime, grind, groan, groom, group, growl, grown, gruff, grump, guess, happy, heard, heart, heavy, horse, hours, house, human, known, large, later, learn, least, leave, level, light, major, march, match, maybe, means, metal, might, miles, money, mouth, music, never, night, north, ocean, often, order, other, paint, paper, party, piece, place, plaid, plain, plane, plank, plant, plate, plead, pleat, plink, plump, point, power, press, price, pride, print, prize, probe, proof, proud, prove, prowl, prune, quiet, quite, radio, ready, right, river, round, scald, scale, scalp, scamp, scare, scarf, scold, scoop, scoot, scope, score, scour, scout, scram, scrap, screw, scrub, scuba, scuff, seeds, sense, serve, seven, shall, shape, sharp, shoes, short, shown, sight, since, skate, skill, skirt, skull, skunk, slack, slant, slate, sleek, sleep, sleet, slept, slice, slick, slide, slime, sling, slope, slump, slush, smack, small, smart, smash, smear, smell, smile, smock, smoke, snack, snail, snake, snare,
snarl, sneak, sniff, snoop, snore, snout, solve, sound, south, space, spare, spark, speak, spear, speck, speed, spell, spend, spent, spike, spill, spine, spire, split, spoil, spoke, spoon, sport, spout, spray, sprig, squat, squid, stack, staff, stage, stain, stair, stake, stale, stalk, stall, stamp, stand, stare, stars, start, state, steak, steal, steam, steel, steep, steer, stick, stiff, still, stilt, sting, stink, stock, stone, stood, stool, stoop, store, storm, story, stove, strap, straw, stray, strip, strum, study, style, sugar, swamp, swarm, sweat, sweep, sweet, swell, swept, swift, swine, swing, swish, swoop, table, terms, their, there, these, thick, thing, think, third, those, three, today, tools, total, touch, trace, track, trade, trail, train, tramp, trash, tread, treat, trees, tribe, trick, troll, tromp, troop, trout, truck, truly, trunk, trust, truth, uncle, under, until, value, visit, voice, vowel, watch, water, waves, where, which, while, white, whole, whose, wings, woman, women, words, world, would, write, wrong, wrote, years, young, across, action, afraid, agreed, almost, always, amount, answer, appear, around, became, become, before, behind, belong, beside, better, bleach, blonde, blouse, bottom, bought, braise, branch, breath, breeze, bridge, bright, broken, bronco, bronze, browse, bruise, called, cannot, cattle, caught, centre, chance, change, choose, church, circle, closet, clutch, colour, column, common, corner, cotton, course, cradle, crayon, create, crunch, desert, design, direct, doctor, dragon, during, effect, either, energy, engine, enough, entire, except, expect, family, famous, father, figure, filled, flight, flower, forest, freeze, friend, fright, fringe, frozen, garden, glance, glitch, grapes, grease, grouch, ground, grudge, inches, inside, island, itself, joined, jumped, killed, length, lifted, listen, little, matter, melody, method, middle, modern, moment, months, mother, nation, notice, number, object, office, oxygen, passed, people, period, person, phrase,  picked, plains, planet, plants, player, please, pledge, plenty, plural, pounds, praise, prance, prayer, pretty, priest, prince, prison, pulled, pushed, raised, rather, really, reason, record, region, remain, report, result, return, rhythm, rolled, scarce, school,
scorch, scrape, scrawl, scream, screen, script, scroll, second, seemed, should, silent, simple, single, sister, sketch, sleepy, sleeve, slight, slowly, smiled, smooth, smudge, snatch, sneeze, speech, spirit, splash, splint, sponge, sprain, sprang, sprawl, spread, spring, sprint, sprout, spruce, square, squash, squeak, squeal, squint, squirm, squirt, squish, stable, staple, starch, starve, statue, steady, stereo, sticky, stingy, stitch, strain, strand, streak, stream, street, strict, stride, strike, string, stripe, stroke, stroll, strong, struck, suffix, summer, supply, swatch, swerve, switch, system, though, toward, travel, trough, valley, walked, weight, wheels, window, winter, within, wonder, yellow, against, already, animals, another, arrived, because, believe, between, blanket, blossom, brother, brought, burning, capital, captain, century, certain, climate, climbed, clothes, company, compare, contain, control, correct, country, covered, cricket, current, decided, decimal, details, distant, divided, dollars, drawing, entered, evening, exactly, example, explain, express, factors, farmers, feeling, finally, fingers, flowers, forward, freight, friends, general, gravity, himself, history, however, hundred, hunting, include, insects, instead, laughed, letters, located, machine, measure, members, million, minutes, morning, natural, nothing, numeral, observe, outside, pattern, perhaps, picture, planets, prepare, present, pretzel, printed, problem, process, produce, product, program, project, promise, pronoun, protect, provide, quickly, reached, scallop, science, scooter, scraper, scratch, screech, section, settled, several, shouted, similar, skillet, slipper, snuggle, someone, special, squeeze, stadium, stapler, started, station, stirrup, stomach, strange, stretch, subject, suppose, surface, swallow, sweater, sweeten, swollen, symbols, teacher, thought, through, trouble, trumpet, usually, various, village, weather, western, whether, without, workers, written, actually, addition, although, anything, blizzard, branches, building, business, children, clothing, complete, compound, consider, describe, division, electric, elements, equation, everyone, exciting, exercise, finished, fraction, freckles, happened, increase, indicate, industry, interest, language,
material, movement, northern, opposite, pleasant, position, possible, practice, practise, precious, prepared, princess, prisoner, probably, products, property, received, remember, repeated, scallion, scramble, scribble, sentence, separate, shoulder, soldiers, solution, southern, splendid, splinter, sprinkle, squirrel, starfish, stocking, straight, strainer, stranger, strength, stronger, struggle, students, suddenly, surprise, together, triangle, yourself, adjective, beautiful, beginning, carefully, consonant, continued, determine, developed, different, difficult, direction, factories, following, groceries, important, molecules, mountains, necessary, paragraph, president, principal, professor, pronounce, propeller, questions, represent, something, sometimes, sprinkler, statement, stretched, stretcher, suggested, syllables, thousands, underline, blackboard, conditions, dictionary, difference, discovered, especially, everything, experience, experiment, flashlight, government, particular, scientists, stationary, strawberry, substances, themselves, understand
"""

""" after translation
акт, добави, възраст, преди, въздух, всички, и, всеки, са, изкуство, лошо, легло, голямо, малко, кутия, момче, но, купуват, може, кола, котка, вика, нарязани, ден, е, куче, сух, яде, край, далеч, малко, смокиня, годни, грип, лети, за, забавно, газ, да, имам, имаше, има, шапка, нея, него, негов, хит, горещ, как, лед, негова, работа, ключ, закон, лежа, доведе, нека, лъжа, много, ниско, мъж, карта, май, мъже, нови, нито, не, сега, на разстояние, стар, един, нашите, вън, собствени, заплати, на, издънка, пусна, избяга, червен, ред, бягай, седна, видя, кажи, море, виж, постави, тя, сър, седя, шест, ски, небе, син, шпионин, сума, слънце, десет, също, top, try, two, use, war, was, way, кой, защо, спечели, да, все пак, ти, можеш, също, област, оръжия, армия, далеч, бебе, гръб, топка, банка, база, мечка, победи, беше, звънец, най-добре, законопроект, blab, взриви, blip, петно, петно, удар, син, лодка, тяло, книга, роден, и двете, трици, brat, bray, варя, ръб, зает, дойде, грижа, случай, град, облечен, клам, клан, нокът, глина, клип, буца, клуб, улика, студ, дойде, готвач, хладно, копие, царевица, цена, крави, рак, ясла врана, тъмно, сделката, дълбоко, прави, направи, врата, надолу, мрачен, влачене, рисуване , дроп, капка, капка, барабан, всеки, уши, изток, лесно, ръб, яйца, друго, дори, някога, очи, лице, факт, справедливо, падане, ферма, бързо, страх, чувствам, крака, падна, почувства , намери, глоба, огън, риба, пет, флаг, клапи, плосък, недостатък, бълха, летял, гъвкав, флип, флоп, поток, храна, крак, четири, безплатно, жаба, от, пълен, игра, даде, момиче , давам, радвам, радост, глоб, блясък, лепило, злато, няма, добър, граб, сив, израснал, решетка, мрачен, усмивка, сцепление, песъчинки, растат, кърма, коса, спира, ръка, трудно , главата, чувам, топлина, държани, помогне, тук, високо, хълм, задръжте, дупка, у дома, надежда, огромен, идея, в, желязо, просто, пази, държат, вид, цар, знаеше, знам, дама, езеро , земя, последна, олово, ляво, крака, по-малко, живот, като, линия, списък, жив, дълъг, поглед, загубен, силен, любов, направен, главен, направи, много, марка,
срещам, мляко, ум, мина, мис, луна, повече, повечето, се движи, много, трябва, име, близо, трябва, следващ, нос, бележка, съществително, веднъж, само, отворено, над, страница, двойка, парк, част, минало, план, играя, полъх, сюжет, плуг, щепсел, слива, стихотворение, полюс, беден, молим, продавай, опора, раса, дъжд, чета, почивка, богат, езда, пръстен, изгрев, път, рок, стая, корен, въже, роза, правило, безопасно, каза, платно, същото, пясък, спаси, краста, сканиране, белег, скат, седалка, видях, продавам, изпращам, изпращам, кораб, магазин, шоу, страна, знак, пей, размер, скок, кожа, скип, слим, слам, шамар, шейна, плъзгам, тънък, приплъзване, цепка, слот, бавен, слъг, смог, усмивка, щракам, сноб, сняг, плътно, меко, почва, някои, песен, скоро, span, spat, спин, петно, шпора, звезда, престой, стъбло, стъпка, задушено, разбъркайте, стоп, такъв, сигурен, плува, лебед, суап, SWAT, власт, плувам, опашка, вземи, говори, висок, екип, кажи, тест, отколкото, че, тях, тогава, те, тънки, това, по този начин, вързани, време, малки, каза, тон, взе, град, капан, тава, дърво, Трек, подреден, пътуване, тръс, вярно, тръба, завой, тип, единица, на, глагол, много, изглед, изчакайте, стена, искате, топло, измиване , износ, седмица, добре, отиде, бяха, запад, какво, кога, широк, жена, дива, ще, вятър, тел, желание, с, дърво, работа, двор, си, за, по-горе, след, отново, напред , разреши, сам, заедно, сред, ъгъл, ябълка, попита, започна, е, по-долу, птици, черно, острие, вино, празно, бласт, блеат, кървя, блепе, бленда, благослови, слепи, мига, блок , кръв, цъфтят, блъф, тъп, руж, борда, кости, скоба, плитка, мозък, спирачка, марка, месинг, смел, сбиване, хляб, почивка, тухла, булка, донесе, жив, широк , Брук, метла, бульон, кафяв, четка, изграждане, построен, носят, улов, причина, клетки, центове, диаграма, проверка, дете, клакса, претенция, стяга, звънец, сблъсък, закопчалка, клас, чист, ясен , чиновник, клик, стръм, катерене, плащ, часовник, клоп, затваряне, кърпа, облак, карамфил, клоун, глупости, крайбрежие, може, брой, пляскане, занаят, кран, катастрофа, пълзене, луд , крик, пълзене, плаче, крякане, мошеник, култури, кръст, тълпа, корона, троха, кора, танц, проект, дренаж, дракон, пиеше, драпе, страх, мечта, рокля, drip фута, тренировка, пиене, шофиране, дръпване, задвижване, рано, земя, осем, наслаждавай се, равен, всеки, поле, бий се, първо, лющене, пламък, пламък, светкавица, флок, флот, плът, лек удар, хвърляне, кремък, поплавък, стадо, наводнение, етаж, конци, брашно, пух, флуид, мехурче, глух, вълна, флейта, сила, намерен, крехък,
рамка, Франк, изрод, свеж, навивам, фриз, фронт, слана, плодове, отблясъци, стъкло, блясък, плъзгам, gloat, глобус, мрак, гланц, ръкавица, грация, клас, присадка, зърно, гранд, грант, грозде, граф, хватка, трева, решетка, гроб, сос, паша, голям, алчност, зелен, поздрав, грил, мръсотия, стон, младоженец, група, ръмжене, пораснал, груб, мързелив тежък, кон, часове, къща, човек, познат, голям, по-късно, научи, най-малко, остави, ниво, светлина, мажор, март, мач, може би, означава, метал, може, мили, пари, уста, музика, никога, нощ, север, океан, често, ред, други, боя, хартия, партия, парче, място, каре, обикновен, самолет, дъска, растителна, плоча, пледирам, плисе, пълнеж, точка, мощност, преса, цена, гордост, отпечатък, награда, сонда, доказателство, гордост, доказателство, риба, река, тиха, доста, радио, готово, право, река, кръгъл, скалд, скалп, скап, плач, шал, кавга, скапа, обхват, резултат, излъскване, разузнавач, скрам, скрап, винт, търкане, гмуркане, счупване, семена, смисъл, сервиране, седем, форма, остри, обувки, кратък, показан, поглед, тъй като, скейт, умение, пола, череп, скункс, слаби, наклонени, шисти, лъскав, сън, сух, спал, парче, хлъзгав, слайд, тиня, малък, интелигентен, смачка, намазка, миризма, усмивка, халат, дим, закуска, охлюв, змия, примка,
ръмжене, промъкване, надушване, snoop, snore, муцуна, решаване, звук, юг, пространство, резервна, искра, говори, копие, петънце, скорост, заклинание, харчене, изразходване, спайк, разсипване, гръбначен стълб говори, лъжица, спорт, чучур, спрей, клон, клякам, калмар, стек, персонал, етап, петно, стълбище, залог, остаряло, дръжка, печат, щанд, зрелище, звезди, начало, състояние, пържола, кражба, пара, стомана, стръмен, стръв, пръчка, скован, все още, ходило, ужилване, воня, запас, камък, стоял, табуретка, навес, магазин, буря, история, печка, каишка, слама, бездомни, лента стил, захар, блато, рояк, пот, почистване, сладка, надута, пометена, бърза, свиня, люлка, свир, замах, маса, термини, техните, там, тези, дебели, нещо, мисля, трето, тези, три, днес, инструменти, общо, докосване, следа, търговия, пътека, влак, трамплин, боклук, протектора, лечение, дървета, племе, трик, тромп, войски, пъстърва, камион, истински, багажник, доверие, истина, чичо, под, до, стойност, посещение, глас, гласна, часовник, вода, вълни, къде, което, докато, бяло, цяло, чиито, крила, жена, жени, думи, свят, ще напиша, греша, написа, години, млади, през, действие, страх, съгласен, почти, винаги, сума, отговор, изглежда, около, стана, стана, преди, зад, принадлежат, освен, по-добре, избелване, блондинка, блуза, дъно, купено, задушено, клон, дъх, бриз, мост, светло, счупено, бронко, бронз, сърфиране, набиване, наричано, не, говеда, уловени, център, шанс, промяна, изберете, църква, кръг, килер, съединител, цвят, колона, общ, ъгъл, памук, курс, люлка, пастел, създаване, криза, пустиня, дизайн, директен, лекар, дракон, по време, ефект, или, енергия, двигател, достатъчно, цяла, с изключение на, очаквам, семейство, известен, баща, фигура, пълна, полет, цвете, гора, замръзване, приятел, страх, ресни, замразени, градина, поглед, бъг, грозде, грес, грух, земя, загриженост, инчове, вътре, остров, себе си, присъединил се, скочил, убил, дължина, повдигнат, слушал, малко, материя, мелодия, метод, среден, модерен, момент, месеци, майка, нация, забележка, номер, обект, офис, кислород, преминал, хора, период, човек, фраза, избрани, равнини, планета, растения, играч, моля, залог, изобилие, множествено число, паунда, похвала, молитва, красива, свещеник, принц, затвор, изтеглен, тласкан, повдигнат, по-скоро, наистина, причина, запис, регион, остават, доклад, резултат, връщане, ритъм, валцувани, оскъдни, училище,
изгарям, изстъргвай, драскам, крещя, екран, скрипт, свитък, втори, изглеждаше, трябва, тихо, прост, единичен, сестра, скица, сънлив, ръкав, лек, бавно, усмихнат, гладка, размазан, грабнат, кихане, реч, дух, splash, шина, гъба, навяхване, sprang, разпръскване, разпространение, пролет, спринт, кълнове, смърч, квадрат, скуош, скърцане, скърцане, скърцане, кашон, шприц, мачкам, стабилна, щапелни, нишесте, гладувам, статуя, стабилно, стерео, лепкава, стисна, бод, щам, направление, серия, поток, улица, строг, крачка, стачка, низ, лента, инсулт, разходка, силен, ударен, суфикс, лято, снабдяване, мостра, свиване, система, макар и към, пътуване, корито, долина, ходене, тегло, колела, прозорец, зима, вътре, чудо, жълто, против, вече, животни, друг, пристигнал, защото, вярвам, между, одеяло, цвят, брат, донесе, изгаряне, капитал, капитан, век, определено, климат, изкачи, дрехи, компания, сравни, съдържа, контрол, правилно, страна, покрито, крикет, ток, решено, десетичен, подробности, отдалечен, разделен, долари, рисуване, влязъл, вечер, точно, например, обясни, експрес, фактори, фермери, чувство, накрая, пръсти, цветя, напред, товари, приятели, генерал, гравитация, сам, история, обаче, сто, лов, включват насекоми, вместо това, смее се, писма, намира се, машина, мярка, членове, милиони, минути, сутрин, естествено, нищо, цифра, наблюдава, отвън, модел, може би, картина, планети, подготви, представяш, крендел, отпечатан, проблем, процес, продукция, продукт, програма, проект, обещание, местоимение, защита, предоставяне, бързо, достигнал, миди, наука, скутер, скрепер, надраскване, писък, секция, уреден, няколко, извика, подобен, тиган, чехъл, притискам, някой, специален, стискам, стадион, телбод, започна, станция, стреме, стомах, странно, участък, предмет, предполагам, повърхност, лястовица, пуловер, подсладени, подути, символи, учител, мисъл, чрез, неприятности, тромпет, обикновено, различен, селски, метеорологичен, западен, без, работници, написани, всъщност, допълнение, въпреки че, нещо, виелица, клонове, сграда, бизнес, деца, облекло, пълна, съставни, помислете, опишете, разделение, електрически, елементи, уравнение, всички, вълнуващи, упражнения, завършени, фракция, лунички, случи се, увеличаване, показват, индустрия, интерес, език,
материал, движение, северна, противоположна, приятна, позиция, възможно, практика, практика, скъпоценна, приготвена, принцеса, затворник, вероятно, продукти, собственост, получена, помни, повтаряна, скалион, драскане, драскане, изречение, отделно, рамо, войници, решение, южен, прекрасен, раздробен, поръсва, катерица, морска звезда, чорап, права, цедка, непознат, сила, по-силна, борба, студенти, изведнъж, изненада, заедно, триъгълник, себе си, прилагателно, красиво, начало, внимателно съгласна, продължава, определя, разработена, различна, трудна, посока, фабрики, следваща, хранителни стоки, важни, молекули, планини, необходима, параграф, президент, директор, професор, произнася се, пропелер, въпроси, представлява, нещо, понякога, пръскачка, изявление, опъната, носилка, предложени, срички, хиляди, подчертаване, черна дъска, условия, речник, разлика, открити, особено, всичко, опит, експеримент, фенерче, правителство, особено учени, стационарни, ягоди, вещества, самите, разбират,
"""