# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class TaskAddCollectionParameter(Model):
    """A collection of Azure Batch tasks to add.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The collection of tasks to add. The maximum count
     of tasks is 100. The total serialized size of this collection must be less
     than 1MB. If it is greater than 1MB (for example if each task has 100's of
     resource files or environment variables), the request will fail with code
     'RequestBodyTooLarge' and should be retried again with fewer tasks.
    :type value: list[~azure.batch.models.TaskAddParameter]
    """

    _validation = {
        'value': {'required': True, 'max_items': 100},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TaskAddParameter]'},
    }

    def __init__(self, **kwargs):
        super(TaskAddCollectionParameter, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
