# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ColorInfo(Model):
    """An object providing additional metadata describing color attributes.

    :param dominant_color_foreground: Possible dominant foreground color.
    :type dominant_color_foreground: str
    :param dominant_color_background: Possible dominant background color.
    :type dominant_color_background: str
    :param dominant_colors: An array of possible dominant colors.
    :type dominant_colors: list[str]
    :param accent_color: Possible accent color.
    :type accent_color: str
    :param is_bw_img: A value indicating if the image is black and white.
    :type is_bw_img: bool
    """

    _attribute_map = {
        'dominant_color_foreground': {'key': 'dominantColorForeground', 'type': 'str'},
        'dominant_color_background': {'key': 'dominantColorBackground', 'type': 'str'},
        'dominant_colors': {'key': 'dominantColors', 'type': '[str]'},
        'accent_color': {'key': 'accentColor', 'type': 'str'},
        'is_bw_img': {'key': 'isBWImg', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ColorInfo, self).__init__(**kwargs)
        self.dominant_color_foreground = kwargs.get('dominant_color_foreground', None)
        self.dominant_color_background = kwargs.get('dominant_color_background', None)
        self.dominant_colors = kwargs.get('dominant_colors', None)
        self.accent_color = kwargs.get('accent_color', None)
        self.is_bw_img = kwargs.get('is_bw_img', None)
