# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ActivityPolicy(Model):
    """Execution policy for an activity.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param timeout: Specifies the timeout for the activity to run. The default
     timeout is 7 days. Type: string (or Expression with resultType string),
     pattern: ((\\d+)\\.)?(\\d\\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
    :type timeout: object
    :param retry: Maximum ordinary retry attempts. Default is 0. Type: integer
     (or Expression with resultType integer), minimum: 0.
    :type retry: object
    :param retry_interval_in_seconds: Interval between each retry attempt (in
     seconds). The default is 30 sec.
    :type retry_interval_in_seconds: int
    :param secure_output: When set to true, Output from activity is considered
     as secure and will not be logged to monitoring.
    :type secure_output: bool
    """

    _validation = {
        'retry_interval_in_seconds': {'maximum': 86400, 'minimum': 30},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'timeout': {'key': 'timeout', 'type': 'object'},
        'retry': {'key': 'retry', 'type': 'object'},
        'retry_interval_in_seconds': {'key': 'retryIntervalInSeconds', 'type': 'int'},
        'secure_output': {'key': 'secureOutput', 'type': 'bool'},
    }

    def __init__(self, additional_properties=None, timeout=None, retry=None, retry_interval_in_seconds=None, secure_output=None):
        super(ActivityPolicy, self).__init__()
        self.additional_properties = additional_properties
        self.timeout = timeout
        self.retry = retry
        self.retry_interval_in_seconds = retry_interval_in_seconds
        self.secure_output = secure_output
