# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SenderAuthorization(Model):
    """the authorization used by the user who has performed the operation that led
    to this event. This captures the RBAC properties of the event. These
    usually include the 'action', 'role' and the 'scope'.

    :param action: the permissible actions. For instance:
     microsoft.support/supporttickets/write
    :type action: str
    :param role: the role of the user. For instance: Subscription Admin
    :type role: str
    :param scope: the scope.
    :type scope: str
    """

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'role': {'key': 'role', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
    }

    def __init__(self, *, action: str=None, role: str=None, scope: str=None, **kwargs) -> None:
        super(SenderAuthorization, self).__init__(**kwargs)
        self.action = action
        self.role = role
        self.scope = scope
