# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobExecutionTarget(Model):
    """The target that a job execution is executed on.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: The type of the target. Possible values include:
     'TargetGroup', 'SqlDatabase', 'SqlElasticPool', 'SqlShardMap', 'SqlServer'
    :vartype type: str or ~azure.mgmt.sql.models.JobTargetType
    :ivar server_name: The server name.
    :vartype server_name: str
    :ivar database_name: The database name.
    :vartype database_name: str
    """

    _validation = {
        'type': {'readonly': True},
        'server_name': {'readonly': True},
        'database_name': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(JobExecutionTarget, self).__init__(**kwargs)
        self.type = None
        self.server_name = None
        self.database_name = None
