# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResourceRequests(Model):
    """This type describes the requested resources for a given container. It
    describes the least amount of resources required for the container. A
    container can consume more than requested resources up to the specified
    limits before being restarted. Currently, the requested resources are
    treated as limits.

    All required parameters must be populated in order to send to Azure.

    :param memory_in_gb: Required. The memory request in GB for this
     container.
    :type memory_in_gb: float
    :param cpu: Required. Requested number of CPU cores. At present, only full
     cores are supported.
    :type cpu: float
    """

    _validation = {
        'memory_in_gb': {'required': True},
        'cpu': {'required': True},
    }

    _attribute_map = {
        'memory_in_gb': {'key': 'memoryInGB', 'type': 'float'},
        'cpu': {'key': 'cpu', 'type': 'float'},
    }

    def __init__(self, *, memory_in_gb: float, cpu: float, **kwargs) -> None:
        super(ResourceRequests, self).__init__(**kwargs)
        self.memory_in_gb = memory_in_gb
        self.cpu = cpu
