# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.mgmt.core import AsyncARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

from ._configuration import AzureMapsResourceProviderConfiguration
from .operations import AccountsOperations
from .operations import MapsOperations
from .operations import PrivateAtlasesOperations
from .operations import CreatorsOperations
from .. import models


class AzureMapsResourceProvider(object):
    """Resource Provider.

    :ivar accounts: AccountsOperations operations
    :vartype accounts: azure.mgmt.maps.aio.operations.AccountsOperations
    :ivar maps: MapsOperations operations
    :vartype maps: azure.mgmt.maps.aio.operations.MapsOperations
    :ivar private_atlases: PrivateAtlasesOperations operations
    :vartype private_atlases: azure.mgmt.maps.aio.operations.PrivateAtlasesOperations
    :ivar creators: CreatorsOperations operations
    :vartype creators: azure.mgmt.maps.aio.operations.CreatorsOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The ID of the target subscription.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = AzureMapsResourceProviderConfiguration(credential, subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.accounts = AccountsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.maps = MapsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.private_atlases = PrivateAtlasesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.creators = CreatorsOperations(
            self._client, self._config, self._serialize, self._deserialize)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "AzureMapsResourceProvider":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
