# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._anomaly_detector_client_enums import *


class AlignPolicy(msrest.serialization.Model):
    """AlignPolicy.

    :ivar align_mode: An optional field, indicating how we align different variables to the same
     time-range. Either Inner or Outer. Possible values include: "Inner", "Outer".
    :vartype align_mode: str or ~azure.ai.anomalydetector.models.AlignMode
    :ivar fill_na_method: An optional field, indicating how missing values will be filled. One of
     Previous, Subsequent, Linear, Zero, Fixed, and NotFill. Cannot be set to NotFill, when the
     alignMode is Outer. Possible values include: "Previous", "Subsequent", "Linear", "Zero",
     "Fixed", "NotFill".
    :vartype fill_na_method: str or ~azure.ai.anomalydetector.models.FillNAMethod
    :ivar padding_value: An optional field. Required when fillNAMethod is Fixed.
    :vartype padding_value: float
    """

    _attribute_map = {
        'align_mode': {'key': 'alignMode', 'type': 'str'},
        'fill_na_method': {'key': 'fillNAMethod', 'type': 'str'},
        'padding_value': {'key': 'paddingValue', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        align_mode: Optional[Union[str, "AlignMode"]] = None,
        fill_na_method: Optional[Union[str, "FillNAMethod"]] = None,
        padding_value: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword align_mode: An optional field, indicating how we align different variables to the same
         time-range. Either Inner or Outer. Possible values include: "Inner", "Outer".
        :paramtype align_mode: str or ~azure.ai.anomalydetector.models.AlignMode
        :keyword fill_na_method: An optional field, indicating how missing values will be filled. One
         of Previous, Subsequent, Linear, Zero, Fixed, and NotFill. Cannot be set to NotFill, when the
         alignMode is Outer. Possible values include: "Previous", "Subsequent", "Linear", "Zero",
         "Fixed", "NotFill".
        :paramtype fill_na_method: str or ~azure.ai.anomalydetector.models.FillNAMethod
        :keyword padding_value: An optional field. Required when fillNAMethod is Fixed.
        :paramtype padding_value: float
        """
        super(AlignPolicy, self).__init__(**kwargs)
        self.align_mode = align_mode
        self.fill_na_method = fill_na_method
        self.padding_value = padding_value


class AnomalyDetectorError(msrest.serialization.Model):
    """Error information returned by the API.

    :ivar code: The error code. Possible values include: "InvalidCustomInterval", "BadArgument",
     "InvalidGranularity", "InvalidPeriod", "InvalidModelArgument", "InvalidSeries",
     "InvalidJsonFormat", "RequiredGranularity", "RequiredSeries", "InvalidImputeMode",
     "InvalidImputeFixedValue".
    :vartype code: str or ~azure.ai.anomalydetector.models.AnomalyDetectorErrorCodes
    :ivar message: A message explaining the error reported by the service.
    :vartype message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[Union[str, "AnomalyDetectorErrorCodes"]] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: The error code. Possible values include: "InvalidCustomInterval", "BadArgument",
         "InvalidGranularity", "InvalidPeriod", "InvalidModelArgument", "InvalidSeries",
         "InvalidJsonFormat", "RequiredGranularity", "RequiredSeries", "InvalidImputeMode",
         "InvalidImputeFixedValue".
        :paramtype code: str or ~azure.ai.anomalydetector.models.AnomalyDetectorErrorCodes
        :keyword message: A message explaining the error reported by the service.
        :paramtype message: str
        """
        super(AnomalyDetectorError, self).__init__(**kwargs)
        self.code = code
        self.message = message


class AnomalyInterpretation(msrest.serialization.Model):
    """AnomalyInterpretation.

    :ivar variable:
    :vartype variable: str
    :ivar contribution_score:
    :vartype contribution_score: float
    :ivar correlation_changes:
    :vartype correlation_changes: ~azure.ai.anomalydetector.models.CorrelationChanges
    """

    _attribute_map = {
        'variable': {'key': 'variable', 'type': 'str'},
        'contribution_score': {'key': 'contributionScore', 'type': 'float'},
        'correlation_changes': {'key': 'correlationChanges', 'type': 'CorrelationChanges'},
    }

    def __init__(
        self,
        *,
        variable: Optional[str] = None,
        contribution_score: Optional[float] = None,
        correlation_changes: Optional["CorrelationChanges"] = None,
        **kwargs
    ):
        """
        :keyword variable:
        :paramtype variable: str
        :keyword contribution_score:
        :paramtype contribution_score: float
        :keyword correlation_changes:
        :paramtype correlation_changes: ~azure.ai.anomalydetector.models.CorrelationChanges
        """
        super(AnomalyInterpretation, self).__init__(**kwargs)
        self.variable = variable
        self.contribution_score = contribution_score
        self.correlation_changes = correlation_changes


class AnomalyState(msrest.serialization.Model):
    """AnomalyState.

    All required parameters must be populated in order to send to Azure.

    :ivar timestamp: Required. timestamp.
    :vartype timestamp: ~datetime.datetime
    :ivar value:
    :vartype value: ~azure.ai.anomalydetector.models.AnomalyValue
    :ivar errors: Error message for the current timestamp.
    :vartype errors: list[~azure.ai.anomalydetector.models.ErrorResponse]
    """

    _validation = {
        'timestamp': {'required': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': 'AnomalyValue'},
        'errors': {'key': 'errors', 'type': '[ErrorResponse]'},
    }

    def __init__(
        self,
        *,
        timestamp: datetime.datetime,
        value: Optional["AnomalyValue"] = None,
        errors: Optional[List["ErrorResponse"]] = None,
        **kwargs
    ):
        """
        :keyword timestamp: Required. timestamp.
        :paramtype timestamp: ~datetime.datetime
        :keyword value:
        :paramtype value: ~azure.ai.anomalydetector.models.AnomalyValue
        :keyword errors: Error message for the current timestamp.
        :paramtype errors: list[~azure.ai.anomalydetector.models.ErrorResponse]
        """
        super(AnomalyState, self).__init__(**kwargs)
        self.timestamp = timestamp
        self.value = value
        self.errors = errors


class AnomalyValue(msrest.serialization.Model):
    """AnomalyValue.

    All required parameters must be populated in order to send to Azure.

    :ivar is_anomaly: Required. True if an anomaly is detected at the current timestamp.
    :vartype is_anomaly: bool
    :ivar severity: Required. Indicates the significance of the anomaly. The higher the severity,
     the more significant the anomaly.
    :vartype severity: float
    :ivar score: Required. Raw score from the model.
    :vartype score: float
    :ivar interpretation:
    :vartype interpretation: list[~azure.ai.anomalydetector.models.AnomalyInterpretation]
    """

    _validation = {
        'is_anomaly': {'required': True},
        'severity': {'required': True, 'maximum': 1, 'minimum': 0},
        'score': {'required': True, 'maximum': 2, 'minimum': 0},
    }

    _attribute_map = {
        'is_anomaly': {'key': 'isAnomaly', 'type': 'bool'},
        'severity': {'key': 'severity', 'type': 'float'},
        'score': {'key': 'score', 'type': 'float'},
        'interpretation': {'key': 'interpretation', 'type': '[AnomalyInterpretation]'},
    }

    def __init__(
        self,
        *,
        is_anomaly: bool,
        severity: float,
        score: float,
        interpretation: Optional[List["AnomalyInterpretation"]] = None,
        **kwargs
    ):
        """
        :keyword is_anomaly: Required. True if an anomaly is detected at the current timestamp.
        :paramtype is_anomaly: bool
        :keyword severity: Required. Indicates the significance of the anomaly. The higher the
         severity, the more significant the anomaly.
        :paramtype severity: float
        :keyword score: Required. Raw score from the model.
        :paramtype score: float
        :keyword interpretation:
        :paramtype interpretation: list[~azure.ai.anomalydetector.models.AnomalyInterpretation]
        """
        super(AnomalyValue, self).__init__(**kwargs)
        self.is_anomaly = is_anomaly
        self.severity = severity
        self.score = score
        self.interpretation = interpretation


class ChangePointDetectRequest(msrest.serialization.Model):
    """The request of change point detection.

    All required parameters must be populated in order to send to Azure.

    :ivar series: Required. Time series data points. Points should be sorted by timestamp in
     ascending order to match the change point detection result.
    :vartype series: list[~azure.ai.anomalydetector.models.TimeSeriesPoint]
    :ivar granularity: Required. Can only be one of yearly, monthly, weekly, daily, hourly,
     minutely or secondly. Granularity is used for verify whether input series is valid. Possible
     values include: "yearly", "monthly", "weekly", "daily", "hourly", "minutely", "secondly",
     "microsecond", "none".
    :vartype granularity: str or ~azure.ai.anomalydetector.models.TimeGranularity
    :ivar custom_interval: Custom Interval is used to set non-standard time interval, for example,
     if the series is 5 minutes, request can be set as {"granularity":"minutely",
     "customInterval":5}.
    :vartype custom_interval: int
    :ivar period: Optional argument, periodic value of a time series. If the value is null or does
     not present, the API will determine the period automatically.
    :vartype period: int
    :ivar stable_trend_window: Optional argument, advanced model parameter, a default
     stableTrendWindow will be used in detection.
    :vartype stable_trend_window: int
    :ivar threshold: Optional argument, advanced model parameter, between 0.0-1.0, the lower the
     value is, the larger the trend error will be which means less change point will be accepted.
    :vartype threshold: float
    """

    _validation = {
        'series': {'required': True},
        'granularity': {'required': True},
    }

    _attribute_map = {
        'series': {'key': 'series', 'type': '[TimeSeriesPoint]'},
        'granularity': {'key': 'granularity', 'type': 'str'},
        'custom_interval': {'key': 'customInterval', 'type': 'int'},
        'period': {'key': 'period', 'type': 'int'},
        'stable_trend_window': {'key': 'stableTrendWindow', 'type': 'int'},
        'threshold': {'key': 'threshold', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        series: List["TimeSeriesPoint"],
        granularity: Union[str, "TimeGranularity"],
        custom_interval: Optional[int] = None,
        period: Optional[int] = None,
        stable_trend_window: Optional[int] = None,
        threshold: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword series: Required. Time series data points. Points should be sorted by timestamp in
         ascending order to match the change point detection result.
        :paramtype series: list[~azure.ai.anomalydetector.models.TimeSeriesPoint]
        :keyword granularity: Required. Can only be one of yearly, monthly, weekly, daily, hourly,
         minutely or secondly. Granularity is used for verify whether input series is valid. Possible
         values include: "yearly", "monthly", "weekly", "daily", "hourly", "minutely", "secondly",
         "microsecond", "none".
        :paramtype granularity: str or ~azure.ai.anomalydetector.models.TimeGranularity
        :keyword custom_interval: Custom Interval is used to set non-standard time interval, for
         example, if the series is 5 minutes, request can be set as {"granularity":"minutely",
         "customInterval":5}.
        :paramtype custom_interval: int
        :keyword period: Optional argument, periodic value of a time series. If the value is null or
         does not present, the API will determine the period automatically.
        :paramtype period: int
        :keyword stable_trend_window: Optional argument, advanced model parameter, a default
         stableTrendWindow will be used in detection.
        :paramtype stable_trend_window: int
        :keyword threshold: Optional argument, advanced model parameter, between 0.0-1.0, the lower the
         value is, the larger the trend error will be which means less change point will be accepted.
        :paramtype threshold: float
        """
        super(ChangePointDetectRequest, self).__init__(**kwargs)
        self.series = series
        self.granularity = granularity
        self.custom_interval = custom_interval
        self.period = period
        self.stable_trend_window = stable_trend_window
        self.threshold = threshold


class ChangePointDetectResponse(msrest.serialization.Model):
    """The response of change point detection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar period: Frequency extracted from the series, zero means no recurrent pattern has been
     found.
    :vartype period: int
    :ivar is_change_point: isChangePoint contains change point properties for each input point.
     True means an anomaly either negative or positive has been detected. The index of the array is
     consistent with the input series.
    :vartype is_change_point: list[bool]
    :ivar confidence_scores: the change point confidence of each point.
    :vartype confidence_scores: list[float]
    """

    _validation = {
        'period': {'readonly': True},
    }

    _attribute_map = {
        'period': {'key': 'period', 'type': 'int'},
        'is_change_point': {'key': 'isChangePoint', 'type': '[bool]'},
        'confidence_scores': {'key': 'confidenceScores', 'type': '[float]'},
    }

    def __init__(
        self,
        *,
        is_change_point: Optional[List[bool]] = None,
        confidence_scores: Optional[List[float]] = None,
        **kwargs
    ):
        """
        :keyword is_change_point: isChangePoint contains change point properties for each input point.
         True means an anomaly either negative or positive has been detected. The index of the array is
         consistent with the input series.
        :paramtype is_change_point: list[bool]
        :keyword confidence_scores: the change point confidence of each point.
        :paramtype confidence_scores: list[float]
        """
        super(ChangePointDetectResponse, self).__init__(**kwargs)
        self.period = None
        self.is_change_point = is_change_point
        self.confidence_scores = confidence_scores


class CorrelationChanges(msrest.serialization.Model):
    """CorrelationChanges.

    :ivar changed_variables: correlated variables.
    :vartype changed_variables: list[str]
    :ivar changed_values: changes in correlation.
    :vartype changed_values: list[float]
    """

    _attribute_map = {
        'changed_variables': {'key': 'changedVariables', 'type': '[str]'},
        'changed_values': {'key': 'changedValues', 'type': '[float]'},
    }

    def __init__(
        self,
        *,
        changed_variables: Optional[List[str]] = None,
        changed_values: Optional[List[float]] = None,
        **kwargs
    ):
        """
        :keyword changed_variables: correlated variables.
        :paramtype changed_variables: list[str]
        :keyword changed_values: changes in correlation.
        :paramtype changed_values: list[float]
        """
        super(CorrelationChanges, self).__init__(**kwargs)
        self.changed_variables = changed_variables
        self.changed_values = changed_values


class DetectionRequest(msrest.serialization.Model):
    """Detection request.

    All required parameters must be populated in order to send to Azure.

    :ivar source: Required. Source link to the input variables. Each variable should be a csv with
     two columns, ``timestamp`` and ``value``. The file name of the variable will be used as its
     name. The variables used in detection should be exactly the same with those used in the
     training phase.
    :vartype source: str
    :ivar start_time: Required. A required field, indicating the start time of data for detection.
     Should be date-time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Required. A required field, indicating the end time of data for detection.
     Should be date-time.
    :vartype end_time: ~datetime.datetime
    """

    _validation = {
        'source': {'required': True},
        'start_time': {'required': True},
        'end_time': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        source: str,
        start_time: datetime.datetime,
        end_time: datetime.datetime,
        **kwargs
    ):
        """
        :keyword source: Required. Source link to the input variables. Each variable should be a csv
         with two columns, ``timestamp`` and ``value``. The file name of the variable will be used as
         its name. The variables used in detection should be exactly the same with those used in the
         training phase.
        :paramtype source: str
        :keyword start_time: Required. A required field, indicating the start time of data for
         detection. Should be date-time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Required. A required field, indicating the end time of data for detection.
         Should be date-time.
        :paramtype end_time: ~datetime.datetime
        """
        super(DetectionRequest, self).__init__(**kwargs)
        self.source = source
        self.start_time = start_time
        self.end_time = end_time


class DetectionResult(msrest.serialization.Model):
    """Response of the given resultId.

    All required parameters must be populated in order to send to Azure.

    :ivar result_id: Required.
    :vartype result_id: str
    :ivar summary: Required.
    :vartype summary: ~azure.ai.anomalydetector.models.DetectionResultSummary
    :ivar results: Required. Detection result for each timestamp.
    :vartype results: list[~azure.ai.anomalydetector.models.AnomalyState]
    """

    _validation = {
        'result_id': {'required': True},
        'summary': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        'result_id': {'key': 'resultId', 'type': 'str'},
        'summary': {'key': 'summary', 'type': 'DetectionResultSummary'},
        'results': {'key': 'results', 'type': '[AnomalyState]'},
    }

    def __init__(
        self,
        *,
        result_id: str,
        summary: "DetectionResultSummary",
        results: List["AnomalyState"],
        **kwargs
    ):
        """
        :keyword result_id: Required.
        :paramtype result_id: str
        :keyword summary: Required.
        :paramtype summary: ~azure.ai.anomalydetector.models.DetectionResultSummary
        :keyword results: Required. Detection result for each timestamp.
        :paramtype results: list[~azure.ai.anomalydetector.models.AnomalyState]
        """
        super(DetectionResult, self).__init__(**kwargs)
        self.result_id = result_id
        self.summary = summary
        self.results = results


class DetectionResultSummary(msrest.serialization.Model):
    """DetectionResultSummary.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Required. Status of detection results. One of CREATED, RUNNING, READY, and
     FAILED. Possible values include: "CREATED", "RUNNING", "READY", "FAILED".
    :vartype status: str or ~azure.ai.anomalydetector.models.DetectionStatus
    :ivar errors: Error message when detection is failed.
    :vartype errors: list[~azure.ai.anomalydetector.models.ErrorResponse]
    :ivar variable_states:
    :vartype variable_states: list[~azure.ai.anomalydetector.models.VariableState]
    :ivar setup_info: Required. Detection request.
    :vartype setup_info: ~azure.ai.anomalydetector.models.DetectionRequest
    """

    _validation = {
        'status': {'required': True},
        'setup_info': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ErrorResponse]'},
        'variable_states': {'key': 'variableStates', 'type': '[VariableState]'},
        'setup_info': {'key': 'setupInfo', 'type': 'DetectionRequest'},
    }

    def __init__(
        self,
        *,
        status: Union[str, "DetectionStatus"],
        setup_info: "DetectionRequest",
        errors: Optional[List["ErrorResponse"]] = None,
        variable_states: Optional[List["VariableState"]] = None,
        **kwargs
    ):
        """
        :keyword status: Required. Status of detection results. One of CREATED, RUNNING, READY, and
         FAILED. Possible values include: "CREATED", "RUNNING", "READY", "FAILED".
        :paramtype status: str or ~azure.ai.anomalydetector.models.DetectionStatus
        :keyword errors: Error message when detection is failed.
        :paramtype errors: list[~azure.ai.anomalydetector.models.ErrorResponse]
        :keyword variable_states:
        :paramtype variable_states: list[~azure.ai.anomalydetector.models.VariableState]
        :keyword setup_info: Required. Detection request.
        :paramtype setup_info: ~azure.ai.anomalydetector.models.DetectionRequest
        """
        super(DetectionResultSummary, self).__init__(**kwargs)
        self.status = status
        self.errors = errors
        self.variable_states = variable_states
        self.setup_info = setup_info


class DetectRequest(msrest.serialization.Model):
    """The request of entire or last anomaly detection.

    All required parameters must be populated in order to send to Azure.

    :ivar series: Required. Time series data points. Points should be sorted by timestamp in
     ascending order to match the anomaly detection result. If the data is not sorted correctly or
     there is duplicated timestamp, the API will not work. In such case, an error message will be
     returned.
    :vartype series: list[~azure.ai.anomalydetector.models.TimeSeriesPoint]
    :ivar granularity: Optional argument, can be one of yearly, monthly, weekly, daily, hourly,
     minutely, secondly, microsecond or none. If granularity is not present, it will be none by
     default. If granularity is none, the timestamp property in time series point can be absent.
     Possible values include: "yearly", "monthly", "weekly", "daily", "hourly", "minutely",
     "secondly", "microsecond", "none".
    :vartype granularity: str or ~azure.ai.anomalydetector.models.TimeGranularity
    :ivar custom_interval: Custom Interval is used to set non-standard time interval, for example,
     if the series is 5 minutes, request can be set as {"granularity":"minutely",
     "customInterval":5}.
    :vartype custom_interval: int
    :ivar period: Optional argument, periodic value of a time series. If the value is null or does
     not present, the API will determine the period automatically.
    :vartype period: int
    :ivar max_anomaly_ratio: Optional argument, advanced model parameter, max anomaly ratio in a
     time series.
    :vartype max_anomaly_ratio: float
    :ivar sensitivity: Optional argument, advanced model parameter, between 0-99, the lower the
     value is, the larger the margin value will be which means less anomalies will be accepted.
    :vartype sensitivity: int
    :ivar impute_mode: Used to specify how to deal with missing values in the input series, it's
     used when granularity is not "none". Possible values include: "auto", "previous", "linear",
     "fixed", "zero", "notFill".
    :vartype impute_mode: str or ~azure.ai.anomalydetector.models.ImputeMode
    :ivar impute_fixed_value: Used to specify the value to fill, it's used when granularity is not
     "none" and imputeMode is "fixed".
    :vartype impute_fixed_value: float
    """

    _validation = {
        'series': {'required': True},
    }

    _attribute_map = {
        'series': {'key': 'series', 'type': '[TimeSeriesPoint]'},
        'granularity': {'key': 'granularity', 'type': 'str'},
        'custom_interval': {'key': 'customInterval', 'type': 'int'},
        'period': {'key': 'period', 'type': 'int'},
        'max_anomaly_ratio': {'key': 'maxAnomalyRatio', 'type': 'float'},
        'sensitivity': {'key': 'sensitivity', 'type': 'int'},
        'impute_mode': {'key': 'imputeMode', 'type': 'str'},
        'impute_fixed_value': {'key': 'imputeFixedValue', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        series: List["TimeSeriesPoint"],
        granularity: Optional[Union[str, "TimeGranularity"]] = None,
        custom_interval: Optional[int] = None,
        period: Optional[int] = None,
        max_anomaly_ratio: Optional[float] = None,
        sensitivity: Optional[int] = None,
        impute_mode: Optional[Union[str, "ImputeMode"]] = None,
        impute_fixed_value: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword series: Required. Time series data points. Points should be sorted by timestamp in
         ascending order to match the anomaly detection result. If the data is not sorted correctly or
         there is duplicated timestamp, the API will not work. In such case, an error message will be
         returned.
        :paramtype series: list[~azure.ai.anomalydetector.models.TimeSeriesPoint]
        :keyword granularity: Optional argument, can be one of yearly, monthly, weekly, daily, hourly,
         minutely, secondly, microsecond or none. If granularity is not present, it will be none by
         default. If granularity is none, the timestamp property in time series point can be absent.
         Possible values include: "yearly", "monthly", "weekly", "daily", "hourly", "minutely",
         "secondly", "microsecond", "none".
        :paramtype granularity: str or ~azure.ai.anomalydetector.models.TimeGranularity
        :keyword custom_interval: Custom Interval is used to set non-standard time interval, for
         example, if the series is 5 minutes, request can be set as {"granularity":"minutely",
         "customInterval":5}.
        :paramtype custom_interval: int
        :keyword period: Optional argument, periodic value of a time series. If the value is null or
         does not present, the API will determine the period automatically.
        :paramtype period: int
        :keyword max_anomaly_ratio: Optional argument, advanced model parameter, max anomaly ratio in a
         time series.
        :paramtype max_anomaly_ratio: float
        :keyword sensitivity: Optional argument, advanced model parameter, between 0-99, the lower the
         value is, the larger the margin value will be which means less anomalies will be accepted.
        :paramtype sensitivity: int
        :keyword impute_mode: Used to specify how to deal with missing values in the input series, it's
         used when granularity is not "none". Possible values include: "auto", "previous", "linear",
         "fixed", "zero", "notFill".
        :paramtype impute_mode: str or ~azure.ai.anomalydetector.models.ImputeMode
        :keyword impute_fixed_value: Used to specify the value to fill, it's used when granularity is
         not "none" and imputeMode is "fixed".
        :paramtype impute_fixed_value: float
        """
        super(DetectRequest, self).__init__(**kwargs)
        self.series = series
        self.granularity = granularity
        self.custom_interval = custom_interval
        self.period = period
        self.max_anomaly_ratio = max_anomaly_ratio
        self.sensitivity = sensitivity
        self.impute_mode = impute_mode
        self.impute_fixed_value = impute_fixed_value


class DiagnosticsInfo(msrest.serialization.Model):
    """DiagnosticsInfo.

    :ivar model_state:
    :vartype model_state: ~azure.ai.anomalydetector.models.ModelState
    :ivar variable_states:
    :vartype variable_states: list[~azure.ai.anomalydetector.models.VariableState]
    """

    _attribute_map = {
        'model_state': {'key': 'modelState', 'type': 'ModelState'},
        'variable_states': {'key': 'variableStates', 'type': '[VariableState]'},
    }

    def __init__(
        self,
        *,
        model_state: Optional["ModelState"] = None,
        variable_states: Optional[List["VariableState"]] = None,
        **kwargs
    ):
        """
        :keyword model_state:
        :paramtype model_state: ~azure.ai.anomalydetector.models.ModelState
        :keyword variable_states:
        :paramtype variable_states: list[~azure.ai.anomalydetector.models.VariableState]
        """
        super(DiagnosticsInfo, self).__init__(**kwargs)
        self.model_state = model_state
        self.variable_states = variable_states


class EntireDetectResponse(msrest.serialization.Model):
    """The response of entire anomaly detection.

    All required parameters must be populated in order to send to Azure.

    :ivar period: Required. Frequency extracted from the series, zero means no recurrent pattern
     has been found.
    :vartype period: int
    :ivar expected_values: Required. ExpectedValues contain expected value for each input point.
     The index of the array is consistent with the input series.
    :vartype expected_values: list[float]
    :ivar upper_margins: Required. UpperMargins contain upper margin of each input point.
     UpperMargin is used to calculate upperBoundary, which equals to expectedValue + (100 -
     marginScale)*upperMargin. Anomalies in response can be filtered by upperBoundary and
     lowerBoundary. By adjusting marginScale value, less significant anomalies can be filtered in
     client side. The index of the array is consistent with the input series.
    :vartype upper_margins: list[float]
    :ivar lower_margins: Required. LowerMargins contain lower margin of each input point.
     LowerMargin is used to calculate lowerBoundary, which equals to expectedValue - (100 -
     marginScale)*lowerMargin. Points between the boundary can be marked as normal ones in client
     side. The index of the array is consistent with the input series.
    :vartype lower_margins: list[float]
    :ivar is_anomaly: Required. IsAnomaly contains anomaly properties for each input point. True
     means an anomaly either negative or positive has been detected. The index of the array is
     consistent with the input series.
    :vartype is_anomaly: list[bool]
    :ivar is_negative_anomaly: Required. IsNegativeAnomaly contains anomaly status in negative
     direction for each input point. True means a negative anomaly has been detected. A negative
     anomaly means the point is detected as an anomaly and its real value is smaller than the
     expected one. The index of the array is consistent with the input series.
    :vartype is_negative_anomaly: list[bool]
    :ivar is_positive_anomaly: Required. IsPositiveAnomaly contain anomaly status in positive
     direction for each input point. True means a positive anomaly has been detected. A positive
     anomaly means the point is detected as an anomaly and its real value is larger than the
     expected one. The index of the array is consistent with the input series.
    :vartype is_positive_anomaly: list[bool]
    :ivar severity: The severity score for each input point. The larger the value is, the more
     sever the anomaly is. For normal points, the "severity" is always 0.
    :vartype severity: list[float]
    """

    _validation = {
        'period': {'required': True},
        'expected_values': {'required': True},
        'upper_margins': {'required': True},
        'lower_margins': {'required': True},
        'is_anomaly': {'required': True},
        'is_negative_anomaly': {'required': True},
        'is_positive_anomaly': {'required': True},
    }

    _attribute_map = {
        'period': {'key': 'period', 'type': 'int'},
        'expected_values': {'key': 'expectedValues', 'type': '[float]'},
        'upper_margins': {'key': 'upperMargins', 'type': '[float]'},
        'lower_margins': {'key': 'lowerMargins', 'type': '[float]'},
        'is_anomaly': {'key': 'isAnomaly', 'type': '[bool]'},
        'is_negative_anomaly': {'key': 'isNegativeAnomaly', 'type': '[bool]'},
        'is_positive_anomaly': {'key': 'isPositiveAnomaly', 'type': '[bool]'},
        'severity': {'key': 'severity', 'type': '[float]'},
    }

    def __init__(
        self,
        *,
        period: int,
        expected_values: List[float],
        upper_margins: List[float],
        lower_margins: List[float],
        is_anomaly: List[bool],
        is_negative_anomaly: List[bool],
        is_positive_anomaly: List[bool],
        severity: Optional[List[float]] = None,
        **kwargs
    ):
        """
        :keyword period: Required. Frequency extracted from the series, zero means no recurrent pattern
         has been found.
        :paramtype period: int
        :keyword expected_values: Required. ExpectedValues contain expected value for each input point.
         The index of the array is consistent with the input series.
        :paramtype expected_values: list[float]
        :keyword upper_margins: Required. UpperMargins contain upper margin of each input point.
         UpperMargin is used to calculate upperBoundary, which equals to expectedValue + (100 -
         marginScale)*upperMargin. Anomalies in response can be filtered by upperBoundary and
         lowerBoundary. By adjusting marginScale value, less significant anomalies can be filtered in
         client side. The index of the array is consistent with the input series.
        :paramtype upper_margins: list[float]
        :keyword lower_margins: Required. LowerMargins contain lower margin of each input point.
         LowerMargin is used to calculate lowerBoundary, which equals to expectedValue - (100 -
         marginScale)*lowerMargin. Points between the boundary can be marked as normal ones in client
         side. The index of the array is consistent with the input series.
        :paramtype lower_margins: list[float]
        :keyword is_anomaly: Required. IsAnomaly contains anomaly properties for each input point. True
         means an anomaly either negative or positive has been detected. The index of the array is
         consistent with the input series.
        :paramtype is_anomaly: list[bool]
        :keyword is_negative_anomaly: Required. IsNegativeAnomaly contains anomaly status in negative
         direction for each input point. True means a negative anomaly has been detected. A negative
         anomaly means the point is detected as an anomaly and its real value is smaller than the
         expected one. The index of the array is consistent with the input series.
        :paramtype is_negative_anomaly: list[bool]
        :keyword is_positive_anomaly: Required. IsPositiveAnomaly contain anomaly status in positive
         direction for each input point. True means a positive anomaly has been detected. A positive
         anomaly means the point is detected as an anomaly and its real value is larger than the
         expected one. The index of the array is consistent with the input series.
        :paramtype is_positive_anomaly: list[bool]
        :keyword severity: The severity score for each input point. The larger the value is, the more
         sever the anomaly is. For normal points, the "severity" is always 0.
        :paramtype severity: list[float]
        """
        super(EntireDetectResponse, self).__init__(**kwargs)
        self.period = period
        self.expected_values = expected_values
        self.upper_margins = upper_margins
        self.lower_margins = lower_margins
        self.is_anomaly = is_anomaly
        self.is_negative_anomaly = is_negative_anomaly
        self.is_positive_anomaly = is_positive_anomaly
        self.severity = severity


class ErrorResponse(msrest.serialization.Model):
    """ErrorResponse.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. The error code.
    :vartype code: str
    :ivar message: Required. The message explaining the error reported by the service.
    :vartype message: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        **kwargs
    ):
        """
        :keyword code: Required. The error code.
        :paramtype code: str
        :keyword message: Required. The message explaining the error reported by the service.
        :paramtype message: str
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class LastDetectionRequest(msrest.serialization.Model):
    """LastDetectionRequest.

    All required parameters must be populated in order to send to Azure.

    :ivar variables: Required. variables.
    :vartype variables: list[~azure.ai.anomalydetector.models.VariableValues]
    :ivar detecting_points: Required. number of timestamps on which the model detects.
    :vartype detecting_points: int
    """

    _validation = {
        'variables': {'required': True},
        'detecting_points': {'required': True},
    }

    _attribute_map = {
        'variables': {'key': 'variables', 'type': '[VariableValues]'},
        'detecting_points': {'key': 'detectingPoints', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        variables: List["VariableValues"],
        detecting_points: int,
        **kwargs
    ):
        """
        :keyword variables: Required. variables.
        :paramtype variables: list[~azure.ai.anomalydetector.models.VariableValues]
        :keyword detecting_points: Required. number of timestamps on which the model detects.
        :paramtype detecting_points: int
        """
        super(LastDetectionRequest, self).__init__(**kwargs)
        self.variables = variables
        self.detecting_points = detecting_points


class LastDetectionResult(msrest.serialization.Model):
    """LastDetectionResult.

    :ivar variable_states:
    :vartype variable_states: list[~azure.ai.anomalydetector.models.VariableState]
    :ivar results:
    :vartype results: list[~azure.ai.anomalydetector.models.AnomalyState]
    """

    _attribute_map = {
        'variable_states': {'key': 'variableStates', 'type': '[VariableState]'},
        'results': {'key': 'results', 'type': '[AnomalyState]'},
    }

    def __init__(
        self,
        *,
        variable_states: Optional[List["VariableState"]] = None,
        results: Optional[List["AnomalyState"]] = None,
        **kwargs
    ):
        """
        :keyword variable_states:
        :paramtype variable_states: list[~azure.ai.anomalydetector.models.VariableState]
        :keyword results:
        :paramtype results: list[~azure.ai.anomalydetector.models.AnomalyState]
        """
        super(LastDetectionResult, self).__init__(**kwargs)
        self.variable_states = variable_states
        self.results = results


class LastDetectResponse(msrest.serialization.Model):
    """The response of last anomaly detection.

    All required parameters must be populated in order to send to Azure.

    :ivar period: Required. Frequency extracted from the series, zero means no recurrent pattern
     has been found.
    :vartype period: int
    :ivar suggested_window: Required. Suggested input series points needed for detecting the latest
     point.
    :vartype suggested_window: int
    :ivar expected_value: Required. Expected value of the latest point.
    :vartype expected_value: float
    :ivar upper_margin: Required. Upper margin of the latest point. UpperMargin is used to
     calculate upperBoundary, which equals to expectedValue + (100 - marginScale)*upperMargin. If
     the value of latest point is between upperBoundary and lowerBoundary, it should be treated as
     normal value. By adjusting marginScale value, anomaly status of latest point can be changed.
    :vartype upper_margin: float
    :ivar lower_margin: Required. Lower margin of the latest point. LowerMargin is used to
     calculate lowerBoundary, which equals to expectedValue - (100 - marginScale)*lowerMargin.
    :vartype lower_margin: float
    :ivar is_anomaly: Required. Anomaly status of the latest point, true means the latest point is
     an anomaly either in negative direction or positive direction.
    :vartype is_anomaly: bool
    :ivar is_negative_anomaly: Required. Anomaly status in negative direction of the latest point.
     True means the latest point is an anomaly and its real value is smaller than the expected one.
    :vartype is_negative_anomaly: bool
    :ivar is_positive_anomaly: Required. Anomaly status in positive direction of the latest point.
     True means the latest point is an anomaly and its real value is larger than the expected one.
    :vartype is_positive_anomaly: bool
    :ivar severity: The severity score for the last input point. The larger the value is, the more
     sever the anomaly is. For normal points, the "severity" is always 0.
    :vartype severity: float
    """

    _validation = {
        'period': {'required': True},
        'suggested_window': {'required': True},
        'expected_value': {'required': True},
        'upper_margin': {'required': True},
        'lower_margin': {'required': True},
        'is_anomaly': {'required': True},
        'is_negative_anomaly': {'required': True},
        'is_positive_anomaly': {'required': True},
    }

    _attribute_map = {
        'period': {'key': 'period', 'type': 'int'},
        'suggested_window': {'key': 'suggestedWindow', 'type': 'int'},
        'expected_value': {'key': 'expectedValue', 'type': 'float'},
        'upper_margin': {'key': 'upperMargin', 'type': 'float'},
        'lower_margin': {'key': 'lowerMargin', 'type': 'float'},
        'is_anomaly': {'key': 'isAnomaly', 'type': 'bool'},
        'is_negative_anomaly': {'key': 'isNegativeAnomaly', 'type': 'bool'},
        'is_positive_anomaly': {'key': 'isPositiveAnomaly', 'type': 'bool'},
        'severity': {'key': 'severity', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        period: int,
        suggested_window: int,
        expected_value: float,
        upper_margin: float,
        lower_margin: float,
        is_anomaly: bool,
        is_negative_anomaly: bool,
        is_positive_anomaly: bool,
        severity: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword period: Required. Frequency extracted from the series, zero means no recurrent pattern
         has been found.
        :paramtype period: int
        :keyword suggested_window: Required. Suggested input series points needed for detecting the
         latest point.
        :paramtype suggested_window: int
        :keyword expected_value: Required. Expected value of the latest point.
        :paramtype expected_value: float
        :keyword upper_margin: Required. Upper margin of the latest point. UpperMargin is used to
         calculate upperBoundary, which equals to expectedValue + (100 - marginScale)*upperMargin. If
         the value of latest point is between upperBoundary and lowerBoundary, it should be treated as
         normal value. By adjusting marginScale value, anomaly status of latest point can be changed.
        :paramtype upper_margin: float
        :keyword lower_margin: Required. Lower margin of the latest point. LowerMargin is used to
         calculate lowerBoundary, which equals to expectedValue - (100 - marginScale)*lowerMargin.
        :paramtype lower_margin: float
        :keyword is_anomaly: Required. Anomaly status of the latest point, true means the latest point
         is an anomaly either in negative direction or positive direction.
        :paramtype is_anomaly: bool
        :keyword is_negative_anomaly: Required. Anomaly status in negative direction of the latest
         point. True means the latest point is an anomaly and its real value is smaller than the
         expected one.
        :paramtype is_negative_anomaly: bool
        :keyword is_positive_anomaly: Required. Anomaly status in positive direction of the latest
         point. True means the latest point is an anomaly and its real value is larger than the expected
         one.
        :paramtype is_positive_anomaly: bool
        :keyword severity: The severity score for the last input point. The larger the value is, the
         more sever the anomaly is. For normal points, the "severity" is always 0.
        :paramtype severity: float
        """
        super(LastDetectResponse, self).__init__(**kwargs)
        self.period = period
        self.suggested_window = suggested_window
        self.expected_value = expected_value
        self.upper_margin = upper_margin
        self.lower_margin = lower_margin
        self.is_anomaly = is_anomaly
        self.is_negative_anomaly = is_negative_anomaly
        self.is_positive_anomaly = is_positive_anomaly
        self.severity = severity


class Model(msrest.serialization.Model):
    """Response of getting a model.

    All required parameters must be populated in order to send to Azure.

    :ivar model_id: Required. Model identifier.
    :vartype model_id: str
    :ivar created_time: Required. Date and time (UTC) when the model was created.
    :vartype created_time: ~datetime.datetime
    :ivar last_updated_time: Required. Date and time (UTC) when the model was last updated.
    :vartype last_updated_time: ~datetime.datetime
    :ivar model_info: Train result of a model including status, errors and diagnose info for model
     and variables.
    :vartype model_info: ~azure.ai.anomalydetector.models.ModelInfo
    """

    _validation = {
        'model_id': {'required': True},
        'created_time': {'required': True},
        'last_updated_time': {'required': True},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'last_updated_time': {'key': 'lastUpdatedTime', 'type': 'iso-8601'},
        'model_info': {'key': 'modelInfo', 'type': 'ModelInfo'},
    }

    def __init__(
        self,
        *,
        model_id: str,
        created_time: datetime.datetime,
        last_updated_time: datetime.datetime,
        model_info: Optional["ModelInfo"] = None,
        **kwargs
    ):
        """
        :keyword model_id: Required. Model identifier.
        :paramtype model_id: str
        :keyword created_time: Required. Date and time (UTC) when the model was created.
        :paramtype created_time: ~datetime.datetime
        :keyword last_updated_time: Required. Date and time (UTC) when the model was last updated.
        :paramtype last_updated_time: ~datetime.datetime
        :keyword model_info: Train result of a model including status, errors and diagnose info for
         model and variables.
        :paramtype model_info: ~azure.ai.anomalydetector.models.ModelInfo
        """
        super(Model, self).__init__(**kwargs)
        self.model_id = model_id
        self.created_time = created_time
        self.last_updated_time = last_updated_time
        self.model_info = model_info


class ModelInfo(msrest.serialization.Model):
    """Train result of a model including status, errors and diagnose info for model and variables.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar sliding_window: An optional field, indicating how many previous points will be used to
     compute the anomaly score of the subsequent point.
    :vartype sliding_window: int
    :ivar align_policy:
    :vartype align_policy: ~azure.ai.anomalydetector.models.AlignPolicy
    :ivar source: Required. Source link to the input variables. Each variable should be a csv file
     with two columns, ``timestamp`` and ``value``. By default, the file name of the variable will
     be used as its variable name.
    :vartype source: str
    :ivar start_time: Required. A required field, indicating the start time of training data.
     Should be date-time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Required. A required field, indicating the end time of training data. Should be
     date-time.
    :vartype end_time: ~datetime.datetime
    :ivar display_name: An optional field. The name of the model whose maximum length is 24.
    :vartype display_name: str
    :ivar status: Model training status. Possible values include: "CREATED", "RUNNING", "READY",
     "FAILED".
    :vartype status: str or ~azure.ai.anomalydetector.models.ModelStatus
    :ivar errors: Error messages when failed to create a model.
    :vartype errors: list[~azure.ai.anomalydetector.models.ErrorResponse]
    :ivar diagnostics_info:
    :vartype diagnostics_info: ~azure.ai.anomalydetector.models.DiagnosticsInfo
    """

    _validation = {
        'source': {'required': True},
        'start_time': {'required': True},
        'end_time': {'required': True},
        'display_name': {'max_length': 24, 'min_length': 0},
        'status': {'readonly': True},
        'errors': {'readonly': True},
        'diagnostics_info': {'readonly': True},
    }

    _attribute_map = {
        'sliding_window': {'key': 'slidingWindow', 'type': 'int'},
        'align_policy': {'key': 'alignPolicy', 'type': 'AlignPolicy'},
        'source': {'key': 'source', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[ErrorResponse]'},
        'diagnostics_info': {'key': 'diagnosticsInfo', 'type': 'DiagnosticsInfo'},
    }

    def __init__(
        self,
        *,
        source: str,
        start_time: datetime.datetime,
        end_time: datetime.datetime,
        sliding_window: Optional[int] = None,
        align_policy: Optional["AlignPolicy"] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword sliding_window: An optional field, indicating how many previous points will be used to
         compute the anomaly score of the subsequent point.
        :paramtype sliding_window: int
        :keyword align_policy:
        :paramtype align_policy: ~azure.ai.anomalydetector.models.AlignPolicy
        :keyword source: Required. Source link to the input variables. Each variable should be a csv
         file with two columns, ``timestamp`` and ``value``. By default, the file name of the variable
         will be used as its variable name.
        :paramtype source: str
        :keyword start_time: Required. A required field, indicating the start time of training data.
         Should be date-time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Required. A required field, indicating the end time of training data. Should
         be date-time.
        :paramtype end_time: ~datetime.datetime
        :keyword display_name: An optional field. The name of the model whose maximum length is 24.
        :paramtype display_name: str
        """
        super(ModelInfo, self).__init__(**kwargs)
        self.sliding_window = sliding_window
        self.align_policy = align_policy
        self.source = source
        self.start_time = start_time
        self.end_time = end_time
        self.display_name = display_name
        self.status = None
        self.errors = None
        self.diagnostics_info = None


class ModelList(msrest.serialization.Model):
    """Response of listing models.

    All required parameters must be populated in order to send to Azure.

    :ivar models: Required. List of models.
    :vartype models: list[~azure.ai.anomalydetector.models.ModelSnapshot]
    :ivar current_count: Required. Current count of trained multivariate models.
    :vartype current_count: int
    :ivar max_count: Required. Max number of models that can be trained for this subscription.
    :vartype max_count: int
    :ivar next_link: The link to fetch more models.
    :vartype next_link: str
    """

    _validation = {
        'models': {'required': True},
        'current_count': {'required': True},
        'max_count': {'required': True},
    }

    _attribute_map = {
        'models': {'key': 'models', 'type': '[ModelSnapshot]'},
        'current_count': {'key': 'currentCount', 'type': 'int'},
        'max_count': {'key': 'maxCount', 'type': 'int'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        models: List["ModelSnapshot"],
        current_count: int,
        max_count: int,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword models: Required. List of models.
        :paramtype models: list[~azure.ai.anomalydetector.models.ModelSnapshot]
        :keyword current_count: Required. Current count of trained multivariate models.
        :paramtype current_count: int
        :keyword max_count: Required. Max number of models that can be trained for this subscription.
        :paramtype max_count: int
        :keyword next_link: The link to fetch more models.
        :paramtype next_link: str
        """
        super(ModelList, self).__init__(**kwargs)
        self.models = models
        self.current_count = current_count
        self.max_count = max_count
        self.next_link = next_link


class ModelSnapshot(msrest.serialization.Model):
    """ModelSnapshot.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar model_id: Required. Model identifier.
    :vartype model_id: str
    :ivar created_time: Required. Date and time (UTC) when the model was created.
    :vartype created_time: ~datetime.datetime
    :ivar last_updated_time: Required. Date and time (UTC) when the model was last updated.
    :vartype last_updated_time: ~datetime.datetime
    :ivar status: Required. Model training status. Possible values include: "CREATED", "RUNNING",
     "READY", "FAILED".
    :vartype status: str or ~azure.ai.anomalydetector.models.ModelStatus
    :ivar display_name:
    :vartype display_name: str
    :ivar variables_count: Required. Total number of variables.
    :vartype variables_count: int
    """

    _validation = {
        'model_id': {'required': True},
        'created_time': {'required': True},
        'last_updated_time': {'required': True},
        'status': {'required': True, 'readonly': True},
        'variables_count': {'required': True},
    }

    _attribute_map = {
        'model_id': {'key': 'modelId', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'last_updated_time': {'key': 'lastUpdatedTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'variables_count': {'key': 'variablesCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        model_id: str,
        created_time: datetime.datetime,
        last_updated_time: datetime.datetime,
        variables_count: int,
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword model_id: Required. Model identifier.
        :paramtype model_id: str
        :keyword created_time: Required. Date and time (UTC) when the model was created.
        :paramtype created_time: ~datetime.datetime
        :keyword last_updated_time: Required. Date and time (UTC) when the model was last updated.
        :paramtype last_updated_time: ~datetime.datetime
        :keyword display_name:
        :paramtype display_name: str
        :keyword variables_count: Required. Total number of variables.
        :paramtype variables_count: int
        """
        super(ModelSnapshot, self).__init__(**kwargs)
        self.model_id = model_id
        self.created_time = created_time
        self.last_updated_time = last_updated_time
        self.status = None
        self.display_name = display_name
        self.variables_count = variables_count


class ModelState(msrest.serialization.Model):
    """ModelState.

    :ivar epoch_ids: Epoch id.
    :vartype epoch_ids: list[int]
    :ivar train_losses:
    :vartype train_losses: list[float]
    :ivar validation_losses:
    :vartype validation_losses: list[float]
    :ivar latencies_in_seconds:
    :vartype latencies_in_seconds: list[float]
    """

    _attribute_map = {
        'epoch_ids': {'key': 'epochIds', 'type': '[int]'},
        'train_losses': {'key': 'trainLosses', 'type': '[float]'},
        'validation_losses': {'key': 'validationLosses', 'type': '[float]'},
        'latencies_in_seconds': {'key': 'latenciesInSeconds', 'type': '[float]'},
    }

    def __init__(
        self,
        *,
        epoch_ids: Optional[List[int]] = None,
        train_losses: Optional[List[float]] = None,
        validation_losses: Optional[List[float]] = None,
        latencies_in_seconds: Optional[List[float]] = None,
        **kwargs
    ):
        """
        :keyword epoch_ids: Epoch id.
        :paramtype epoch_ids: list[int]
        :keyword train_losses:
        :paramtype train_losses: list[float]
        :keyword validation_losses:
        :paramtype validation_losses: list[float]
        :keyword latencies_in_seconds:
        :paramtype latencies_in_seconds: list[float]
        """
        super(ModelState, self).__init__(**kwargs)
        self.epoch_ids = epoch_ids
        self.train_losses = train_losses
        self.validation_losses = validation_losses
        self.latencies_in_seconds = latencies_in_seconds


class TimeSeriesPoint(msrest.serialization.Model):
    """The definition of input timeseries points.

    All required parameters must be populated in order to send to Azure.

    :ivar timestamp: Optional argument, timestamp of a data point (ISO8601 format).
    :vartype timestamp: ~datetime.datetime
    :ivar value: Required. The measurement of that point, should be float.
    :vartype value: float
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        value: float,
        timestamp: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword timestamp: Optional argument, timestamp of a data point (ISO8601 format).
        :paramtype timestamp: ~datetime.datetime
        :keyword value: Required. The measurement of that point, should be float.
        :paramtype value: float
        """
        super(TimeSeriesPoint, self).__init__(**kwargs)
        self.timestamp = timestamp
        self.value = value


class VariableState(msrest.serialization.Model):
    """VariableState.

    :ivar variable: Variable name.
    :vartype variable: str
    :ivar filled_na_ratio: Proportion of NaN values filled of the variable.
    :vartype filled_na_ratio: float
    :ivar effective_count: Number of effective points counted.
    :vartype effective_count: int
    :ivar start_time: Start time of the variable.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the variable.
    :vartype end_time: ~datetime.datetime
    """

    _validation = {
        'filled_na_ratio': {'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'variable': {'key': 'variable', 'type': 'str'},
        'filled_na_ratio': {'key': 'filledNARatio', 'type': 'float'},
        'effective_count': {'key': 'effectiveCount', 'type': 'int'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        variable: Optional[str] = None,
        filled_na_ratio: Optional[float] = None,
        effective_count: Optional[int] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword variable: Variable name.
        :paramtype variable: str
        :keyword filled_na_ratio: Proportion of NaN values filled of the variable.
        :paramtype filled_na_ratio: float
        :keyword effective_count: Number of effective points counted.
        :paramtype effective_count: int
        :keyword start_time: Start time of the variable.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the variable.
        :paramtype end_time: ~datetime.datetime
        """
        super(VariableState, self).__init__(**kwargs)
        self.variable = variable
        self.filled_na_ratio = filled_na_ratio
        self.effective_count = effective_count
        self.start_time = start_time
        self.end_time = end_time


class VariableValues(msrest.serialization.Model):
    """VariableValues.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. variable name.
    :vartype name: str
    :ivar timestamps: Required. timestamps.
    :vartype timestamps: list[str]
    :ivar values: Required. values.
    :vartype values: list[float]
    """

    _validation = {
        'name': {'required': True},
        'timestamps': {'required': True},
        'values': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'timestamps': {'key': 'timestamps', 'type': '[str]'},
        'values': {'key': 'values', 'type': '[float]'},
    }

    def __init__(
        self,
        *,
        name: str,
        timestamps: List[str],
        values: List[float],
        **kwargs
    ):
        """
        :keyword name: Required. variable name.
        :paramtype name: str
        :keyword timestamps: Required. timestamps.
        :paramtype timestamps: list[str]
        :keyword values: Required. values.
        :paramtype values: list[float]
        """
        super(VariableValues, self).__init__(**kwargs)
        self.name = name
        self.timestamps = timestamps
        self.values = values
