# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._serialization import Serializer
from .._vendor import MixinABC

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_get_answers_request(*, project_name: str, deployment_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    api_version = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/:query-knowledgebases"

    # Construct parameters
    _params["projectName"] = _SERIALIZER.query("project_name", project_name, "str")
    _params["deploymentName"] = _SERIALIZER.query("deployment_name", deployment_name, "str")
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_answers_from_text_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
    api_version = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))  # type: str
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/:query-text"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class QuestionAnsweringClientOperationsMixin(MixinABC):
    @overload
    def get_answers(
        self,
        options: _models.AnswersOptions,
        *,
        project_name: str,
        deployment_name: str,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AnswersResult:
        """Answers the specified question using your knowledge base.

        Answers the specified question using your knowledge base.

        :param options: Post body of the request. Required.
        :type options: ~azure.ai.language.questionanswering.models.AnswersOptions
        :keyword project_name: The name of the project to use. Required.
        :paramtype project_name: str
        :keyword deployment_name: The name of the specific deployment of the project to use. Required.
        :paramtype deployment_name: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AnswersResult
        :rtype: ~azure.ai.language.questionanswering.models.AnswersResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def get_answers(
        self,
        options: IO,
        *,
        project_name: str,
        deployment_name: str,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AnswersResult:
        """Answers the specified question using your knowledge base.

        Answers the specified question using your knowledge base.

        :param options: Post body of the request. Required.
        :type options: IO
        :keyword project_name: The name of the project to use. Required.
        :paramtype project_name: str
        :keyword deployment_name: The name of the specific deployment of the project to use. Required.
        :paramtype deployment_name: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AnswersResult
        :rtype: ~azure.ai.language.questionanswering.models.AnswersResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def get_answers(
        self, options: Union[_models.AnswersOptions, IO], *, project_name: str, deployment_name: str, **kwargs: Any
    ) -> _models.AnswersResult:
        """Answers the specified question using your knowledge base.

        Answers the specified question using your knowledge base.

        :param options: Post body of the request. Is either a model type or a IO type. Required.
        :type options: ~azure.ai.language.questionanswering.models.AnswersOptions or IO
        :keyword project_name: The name of the project to use. Required.
        :paramtype project_name: str
        :keyword deployment_name: The name of the specific deployment of the project to use. Required.
        :paramtype deployment_name: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: AnswersResult
        :rtype: ~azure.ai.language.questionanswering.models.AnswersResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.AnswersResult]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(options, (IO, bytes)):
            _content = options
        else:
            _json = self._serialize.body(options, "AnswersOptions")

        request = build_get_answers_request(
            project_name=project_name,
            deployment_name=deployment_name,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("AnswersResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    def get_answers_from_text(
        self, options: _models.AnswersFromTextOptions, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AnswersFromTextResult:
        """Answers the specified question using the provided text in the body.

        Answers the specified question using the provided text in the body.

        :param options: Post body of the request. Required.
        :type options: ~azure.ai.language.questionanswering.models.AnswersFromTextOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AnswersFromTextResult
        :rtype: ~azure.ai.language.questionanswering.models.AnswersFromTextResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def get_answers_from_text(
        self, options: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AnswersFromTextResult:
        """Answers the specified question using the provided text in the body.

        Answers the specified question using the provided text in the body.

        :param options: Post body of the request. Required.
        :type options: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AnswersFromTextResult
        :rtype: ~azure.ai.language.questionanswering.models.AnswersFromTextResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def get_answers_from_text(
        self, options: Union[_models.AnswersFromTextOptions, IO], **kwargs: Any
    ) -> _models.AnswersFromTextResult:
        """Answers the specified question using the provided text in the body.

        Answers the specified question using the provided text in the body.

        :param options: Post body of the request. Is either a model type or a IO type. Required.
        :type options: ~azure.ai.language.questionanswering.models.AnswersFromTextOptions or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: AnswersFromTextResult
        :rtype: ~azure.ai.language.questionanswering.models.AnswersFromTextResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.AnswersFromTextResult]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(options, (IO, bytes)):
            _content = options
        else:
            _json = self._serialize.body(options, "AnswersFromTextOptions")

        request = build_get_answers_from_text_request(
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("AnswersFromTextResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
