# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Application(Resource):
    """Schema for Application properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    :ivar object_id: ObjectId of Application. (internal use).
    :vartype object_id: str
    :param description: Description of Application.
    :type description: str
    :param friendly_name: Friendly name of Application.
    :type friendly_name: str
    :param file_path: Specifies a path for the executable file for the application.
    :type file_path: str
    :param msix_package_family_name: Specifies the package family name for MSIX applications.
    :type msix_package_family_name: str
    :param msix_package_application_id: Specifies the package application Id for MSIX applications.
    :type msix_package_application_id: str
    :param application_type: Resource Type of Application. Possible values include: "InBuilt",
     "MsixApplication".
    :type application_type: str or ~desktop_virtualization_api_client.models.RemoteApplicationType
    :param command_line_setting: Required. Specifies whether this published application can be
     launched with command line arguments provided by the client, command line arguments specified
     at publish time, or no command line arguments at all. Possible values include: "DoNotAllow",
     "Allow", "Require".
    :type command_line_setting: str or ~desktop_virtualization_api_client.models.CommandLineSetting
    :param command_line_arguments: Command Line Arguments for Application.
    :type command_line_arguments: str
    :param show_in_portal: Specifies whether to show the RemoteApp program in the RD Web Access
     server.
    :type show_in_portal: bool
    :param icon_path: Path to icon.
    :type icon_path: str
    :param icon_index: Index of the icon.
    :type icon_index: int
    :ivar icon_hash: Hash of the icon.
    :vartype icon_hash: str
    :ivar icon_content: the icon a 64 bit string as a byte array.
    :vartype icon_content: bytearray
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'object_id': {'readonly': True},
        'command_line_setting': {'required': True},
        'icon_hash': {'readonly': True},
        'icon_content': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'object_id': {'key': 'properties.objectId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'file_path': {'key': 'properties.filePath', 'type': 'str'},
        'msix_package_family_name': {'key': 'properties.msixPackageFamilyName', 'type': 'str'},
        'msix_package_application_id': {'key': 'properties.msixPackageApplicationId', 'type': 'str'},
        'application_type': {'key': 'properties.applicationType', 'type': 'str'},
        'command_line_setting': {'key': 'properties.commandLineSetting', 'type': 'str'},
        'command_line_arguments': {'key': 'properties.commandLineArguments', 'type': 'str'},
        'show_in_portal': {'key': 'properties.showInPortal', 'type': 'bool'},
        'icon_path': {'key': 'properties.iconPath', 'type': 'str'},
        'icon_index': {'key': 'properties.iconIndex', 'type': 'int'},
        'icon_hash': {'key': 'properties.iconHash', 'type': 'str'},
        'icon_content': {'key': 'properties.iconContent', 'type': 'bytearray'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Application, self).__init__(**kwargs)
        self.system_data = None
        self.object_id = None
        self.description = kwargs.get('description', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.file_path = kwargs.get('file_path', None)
        self.msix_package_family_name = kwargs.get('msix_package_family_name', None)
        self.msix_package_application_id = kwargs.get('msix_package_application_id', None)
        self.application_type = kwargs.get('application_type', None)
        self.command_line_setting = kwargs['command_line_setting']
        self.command_line_arguments = kwargs.get('command_line_arguments', None)
        self.show_in_portal = kwargs.get('show_in_portal', None)
        self.icon_path = kwargs.get('icon_path', None)
        self.icon_index = kwargs.get('icon_index', None)
        self.icon_hash = None
        self.icon_content = None


class ResourceModelWithAllowedPropertySet(msrest.serialization.Model):
    """The resource model definition containing the full set of allowed properties for a resource. Except properties bag, there cannot be a top level property outside of this set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: The geo-location where the resource lives.
    :type location: str
    :param managed_by: The fully qualified resource ID of the resource that manages this resource.
     Indicates if this resource is managed by another Azure resource. If this is present, complete
     mode deployment will not delete the resource if it is removed from the template since it is
     managed by another resource.
    :type managed_by: str
    :param kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :type kind: str
    :ivar etag: The etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal etag convention.  Entity tags are used for
     comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in
     the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range
     (section 14.27) header fields.
    :vartype etag: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity:
    :type identity:
     ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetIdentity
    :param sku:
    :type sku: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetSku
    :param plan:
    :type plan: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetPlan
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'pattern': r'^[-\w\._,\(\)]+$'},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ResourceModelWithAllowedPropertySetIdentity'},
        'sku': {'key': 'sku', 'type': 'ResourceModelWithAllowedPropertySetSku'},
        'plan': {'key': 'plan', 'type': 'ResourceModelWithAllowedPropertySetPlan'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceModelWithAllowedPropertySet, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs.get('location', None)
        self.managed_by = kwargs.get('managed_by', None)
        self.kind = kwargs.get('kind', None)
        self.etag = None
        self.tags = kwargs.get('tags', None)
        self.identity = kwargs.get('identity', None)
        self.sku = kwargs.get('sku', None)
        self.plan = kwargs.get('plan', None)


class ApplicationGroup(ResourceModelWithAllowedPropertySet):
    """Represents a ApplicationGroup definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: The geo-location where the resource lives.
    :type location: str
    :param managed_by: The fully qualified resource ID of the resource that manages this resource.
     Indicates if this resource is managed by another Azure resource. If this is present, complete
     mode deployment will not delete the resource if it is removed from the template since it is
     managed by another resource.
    :type managed_by: str
    :param kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :type kind: str
    :ivar etag: The etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal etag convention.  Entity tags are used for
     comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in
     the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range
     (section 14.27) header fields.
    :vartype etag: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity:
    :type identity:
     ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetIdentity
    :param sku:
    :type sku: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetSku
    :param plan:
    :type plan: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetPlan
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    :ivar object_id: ObjectId of ApplicationGroup. (internal use).
    :vartype object_id: str
    :param description: Description of ApplicationGroup.
    :type description: str
    :param friendly_name: Friendly name of ApplicationGroup.
    :type friendly_name: str
    :param host_pool_arm_path: Required. HostPool arm path of ApplicationGroup.
    :type host_pool_arm_path: str
    :ivar workspace_arm_path: Workspace arm path of ApplicationGroup.
    :vartype workspace_arm_path: str
    :param application_group_type: Required. Resource Type of ApplicationGroup. Possible values
     include: "RemoteApp", "Desktop".
    :type application_group_type: str or
     ~desktop_virtualization_api_client.models.ApplicationGroupType
    :param migration_request: The registration info of HostPool.
    :type migration_request: ~desktop_virtualization_api_client.models.MigrationRequestProperties
    :ivar cloud_pc_resource: Is cloud pc resource.
    :vartype cloud_pc_resource: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'pattern': r'^[-\w\._,\(\)]+$'},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'object_id': {'readonly': True},
        'host_pool_arm_path': {'required': True},
        'workspace_arm_path': {'readonly': True},
        'application_group_type': {'required': True},
        'cloud_pc_resource': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ResourceModelWithAllowedPropertySetIdentity'},
        'sku': {'key': 'sku', 'type': 'ResourceModelWithAllowedPropertySetSku'},
        'plan': {'key': 'plan', 'type': 'ResourceModelWithAllowedPropertySetPlan'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'object_id': {'key': 'properties.objectId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'host_pool_arm_path': {'key': 'properties.hostPoolArmPath', 'type': 'str'},
        'workspace_arm_path': {'key': 'properties.workspaceArmPath', 'type': 'str'},
        'application_group_type': {'key': 'properties.applicationGroupType', 'type': 'str'},
        'migration_request': {'key': 'properties.migrationRequest', 'type': 'MigrationRequestProperties'},
        'cloud_pc_resource': {'key': 'properties.cloudPcResource', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGroup, self).__init__(**kwargs)
        self.system_data = None
        self.object_id = None
        self.description = kwargs.get('description', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.host_pool_arm_path = kwargs['host_pool_arm_path']
        self.workspace_arm_path = None
        self.application_group_type = kwargs['application_group_type']
        self.migration_request = kwargs.get('migration_request', None)
        self.cloud_pc_resource = None


class ApplicationGroupList(msrest.serialization.Model):
    """List of ApplicationGroup definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of ApplicationGroup definitions.
    :type value: list[~desktop_virtualization_api_client.models.ApplicationGroup]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGroupList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ApplicationGroupPatch(Resource):
    """ApplicationGroup properties that can be patched.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. tags to be updated.
    :type tags: dict[str, str]
    :param description: Description of ApplicationGroup.
    :type description: str
    :param friendly_name: Friendly name of ApplicationGroup.
    :type friendly_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationGroupPatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.description = kwargs.get('description', None)
        self.friendly_name = kwargs.get('friendly_name', None)


class ApplicationList(msrest.serialization.Model):
    """List of Application definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of Application definitions.
    :type value: list[~desktop_virtualization_api_client.models.Application]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Application]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ApplicationPatch(msrest.serialization.Model):
    """Application properties that can be patched.

    :param tags: A set of tags. tags to be updated.
    :type tags: dict[str, str]
    :param description: Description of Application.
    :type description: str
    :param friendly_name: Friendly name of Application.
    :type friendly_name: str
    :param file_path: Specifies a path for the executable file for the application.
    :type file_path: str
    :param command_line_setting: Specifies whether this published application can be launched with
     command line arguments provided by the client, command line arguments specified at publish
     time, or no command line arguments at all. Possible values include: "DoNotAllow", "Allow",
     "Require".
    :type command_line_setting: str or ~desktop_virtualization_api_client.models.CommandLineSetting
    :param command_line_arguments: Command Line Arguments for Application.
    :type command_line_arguments: str
    :param show_in_portal: Specifies whether to show the RemoteApp program in the RD Web Access
     server.
    :type show_in_portal: bool
    :param icon_path: Path to icon.
    :type icon_path: str
    :param icon_index: Index of the icon.
    :type icon_index: int
    :param msix_package_family_name: Specifies the package family name for MSIX applications.
    :type msix_package_family_name: str
    :param msix_package_application_id: Specifies the package application Id for MSIX applications.
    :type msix_package_application_id: str
    :param application_type: Resource Type of Application. Possible values include: "InBuilt",
     "MsixApplication".
    :type application_type: str or ~desktop_virtualization_api_client.models.RemoteApplicationType
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'file_path': {'key': 'properties.filePath', 'type': 'str'},
        'command_line_setting': {'key': 'properties.commandLineSetting', 'type': 'str'},
        'command_line_arguments': {'key': 'properties.commandLineArguments', 'type': 'str'},
        'show_in_portal': {'key': 'properties.showInPortal', 'type': 'bool'},
        'icon_path': {'key': 'properties.iconPath', 'type': 'str'},
        'icon_index': {'key': 'properties.iconIndex', 'type': 'int'},
        'msix_package_family_name': {'key': 'properties.msixPackageFamilyName', 'type': 'str'},
        'msix_package_application_id': {'key': 'properties.msixPackageApplicationId', 'type': 'str'},
        'application_type': {'key': 'properties.applicationType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplicationPatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.description = kwargs.get('description', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.file_path = kwargs.get('file_path', None)
        self.command_line_setting = kwargs.get('command_line_setting', None)
        self.command_line_arguments = kwargs.get('command_line_arguments', None)
        self.show_in_portal = kwargs.get('show_in_portal', None)
        self.icon_path = kwargs.get('icon_path', None)
        self.icon_index = kwargs.get('icon_index', None)
        self.msix_package_family_name = kwargs.get('msix_package_family_name', None)
        self.msix_package_application_id = kwargs.get('msix_package_application_id', None)
        self.application_type = kwargs.get('application_type', None)


class CloudErrorProperties(msrest.serialization.Model):
    """Cloud error object properties.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudErrorProperties, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class Desktop(Resource):
    """Schema for Desktop properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    :ivar object_id: ObjectId of Desktop. (internal use).
    :vartype object_id: str
    :param description: Description of Desktop.
    :type description: str
    :param friendly_name: Friendly name of Desktop.
    :type friendly_name: str
    :ivar icon_hash: Hash of the icon.
    :vartype icon_hash: str
    :ivar icon_content: The icon a 64 bit string as a byte array.
    :vartype icon_content: bytearray
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'object_id': {'readonly': True},
        'icon_hash': {'readonly': True},
        'icon_content': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'object_id': {'key': 'properties.objectId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'icon_hash': {'key': 'properties.iconHash', 'type': 'str'},
        'icon_content': {'key': 'properties.iconContent', 'type': 'bytearray'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Desktop, self).__init__(**kwargs)
        self.system_data = None
        self.object_id = None
        self.description = kwargs.get('description', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.icon_hash = None
        self.icon_content = None


class DesktopList(msrest.serialization.Model):
    """List of Desktop definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of Desktop definitions.
    :type value: list[~desktop_virtualization_api_client.models.Desktop]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Desktop]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DesktopList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class DesktopPatch(msrest.serialization.Model):
    """Desktop properties that can be patched.

    :param tags: A set of tags. tags to be updated.
    :type tags: dict[str, str]
    :param description: Description of Desktop.
    :type description: str
    :param friendly_name: Friendly name of Desktop.
    :type friendly_name: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DesktopPatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.description = kwargs.get('description', None)
        self.friendly_name = kwargs.get('friendly_name', None)


class ExpandMsixImage(Resource):
    """Represents the definition of contents retrieved after expanding the MSIX Image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param package_alias: Alias of MSIX Package.
    :type package_alias: str
    :param image_path: VHD/CIM image path on Network Share.
    :type image_path: str
    :param package_name: Package Name from appxmanifest.xml.
    :type package_name: str
    :param package_family_name: Package Family Name from appxmanifest.xml. Contains Package Name
     and Publisher name.
    :type package_family_name: str
    :param package_full_name: Package Full Name from appxmanifest.xml.
    :type package_full_name: str
    :param display_name: User friendly Name to be displayed in the portal.
    :type display_name: str
    :param package_relative_path: Relative Path to the package inside the image.
    :type package_relative_path: str
    :param is_regular_registration: Specifies how to register Package in feed.
    :type is_regular_registration: bool
    :param is_active: Make this version of the package the active one across the hostpool.
    :type is_active: bool
    :param package_dependencies: List of package dependencies.
    :type package_dependencies:
     list[~desktop_virtualization_api_client.models.MsixPackageDependencies]
    :param version: Package Version found in the appxmanifest.xml.
    :type version: str
    :param last_updated: Date Package was last updated, found in the appxmanifest.xml.
    :type last_updated: ~datetime.datetime
    :param package_applications: List of package applications.
    :type package_applications:
     list[~desktop_virtualization_api_client.models.MsixPackageApplications]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'package_alias': {'key': 'properties.packageAlias', 'type': 'str'},
        'image_path': {'key': 'properties.imagePath', 'type': 'str'},
        'package_name': {'key': 'properties.packageName', 'type': 'str'},
        'package_family_name': {'key': 'properties.packageFamilyName', 'type': 'str'},
        'package_full_name': {'key': 'properties.packageFullName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'package_relative_path': {'key': 'properties.packageRelativePath', 'type': 'str'},
        'is_regular_registration': {'key': 'properties.isRegularRegistration', 'type': 'bool'},
        'is_active': {'key': 'properties.isActive', 'type': 'bool'},
        'package_dependencies': {'key': 'properties.packageDependencies', 'type': '[MsixPackageDependencies]'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'last_updated': {'key': 'properties.lastUpdated', 'type': 'iso-8601'},
        'package_applications': {'key': 'properties.packageApplications', 'type': '[MsixPackageApplications]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpandMsixImage, self).__init__(**kwargs)
        self.package_alias = kwargs.get('package_alias', None)
        self.image_path = kwargs.get('image_path', None)
        self.package_name = kwargs.get('package_name', None)
        self.package_family_name = kwargs.get('package_family_name', None)
        self.package_full_name = kwargs.get('package_full_name', None)
        self.display_name = kwargs.get('display_name', None)
        self.package_relative_path = kwargs.get('package_relative_path', None)
        self.is_regular_registration = kwargs.get('is_regular_registration', None)
        self.is_active = kwargs.get('is_active', None)
        self.package_dependencies = kwargs.get('package_dependencies', None)
        self.version = kwargs.get('version', None)
        self.last_updated = kwargs.get('last_updated', None)
        self.package_applications = kwargs.get('package_applications', None)


class ExpandMsixImageList(msrest.serialization.Model):
    """List of MSIX package properties retrieved from MSIX Image expansion.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of MSIX package properties from give MSIX Image.
    :type value: list[~desktop_virtualization_api_client.models.ExpandMsixImage]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpandMsixImage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExpandMsixImageList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class HostPool(ResourceModelWithAllowedPropertySet):
    """Represents a HostPool definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: The geo-location where the resource lives.
    :type location: str
    :param managed_by: The fully qualified resource ID of the resource that manages this resource.
     Indicates if this resource is managed by another Azure resource. If this is present, complete
     mode deployment will not delete the resource if it is removed from the template since it is
     managed by another resource.
    :type managed_by: str
    :param kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :type kind: str
    :ivar etag: The etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal etag convention.  Entity tags are used for
     comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in
     the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range
     (section 14.27) header fields.
    :vartype etag: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity:
    :type identity:
     ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetIdentity
    :param sku:
    :type sku: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetSku
    :param plan:
    :type plan: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetPlan
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    :ivar object_id: ObjectId of HostPool. (internal use).
    :vartype object_id: str
    :param friendly_name: Friendly name of HostPool.
    :type friendly_name: str
    :param description: Description of HostPool.
    :type description: str
    :param host_pool_type: Required. HostPool type for desktop. Possible values include:
     "Personal", "Pooled", "BYODesktop".
    :type host_pool_type: str or ~desktop_virtualization_api_client.models.HostPoolType
    :param personal_desktop_assignment_type: PersonalDesktopAssignment type for HostPool. Possible
     values include: "Automatic", "Direct".
    :type personal_desktop_assignment_type: str or
     ~desktop_virtualization_api_client.models.PersonalDesktopAssignmentType
    :param custom_rdp_property: Custom rdp property of HostPool.
    :type custom_rdp_property: str
    :param max_session_limit: The max session limit of HostPool.
    :type max_session_limit: int
    :param load_balancer_type: Required. The type of the load balancer. Possible values include:
     "BreadthFirst", "DepthFirst", "Persistent".
    :type load_balancer_type: str or ~desktop_virtualization_api_client.models.LoadBalancerType
    :param ring: The ring number of HostPool.
    :type ring: int
    :param validation_environment: Is validation environment.
    :type validation_environment: bool
    :param registration_info: The registration info of HostPool.
    :type registration_info: ~desktop_virtualization_api_client.models.RegistrationInfo
    :param vm_template: VM template for sessionhosts configuration within hostpool.
    :type vm_template: str
    :ivar application_group_references: List of applicationGroup links.
    :vartype application_group_references: list[str]
    :param ssoadfs_authority: URL to customer ADFS server for signing WVD SSO certificates.
    :type ssoadfs_authority: str
    :param sso_client_id: ClientId for the registered Relying Party used to issue WVD SSO
     certificates.
    :type sso_client_id: str
    :param sso_client_secret_key_vault_path: Path to Azure KeyVault storing the secret used for
     communication to ADFS.
    :type sso_client_secret_key_vault_path: str
    :param sso_secret_type: The type of single sign on Secret Type. Possible values include:
     "SharedKey", "Certificate", "SharedKeyInKeyVault", "CertificateInKeyVault".
    :type sso_secret_type: str or ~desktop_virtualization_api_client.models.SSOSecretType
    :param preferred_app_group_type: Required. The type of preferred application group type,
     default to Desktop Application Group. Possible values include: "None", "Desktop",
     "RailApplications".
    :type preferred_app_group_type: str or
     ~desktop_virtualization_api_client.models.PreferredAppGroupType
    :param start_vm_on_connect: The flag to turn on/off StartVMOnConnect feature.
    :type start_vm_on_connect: bool
    :param migration_request: The registration info of HostPool.
    :type migration_request: ~desktop_virtualization_api_client.models.MigrationRequestProperties
    :ivar cloud_pc_resource: Is cloud pc resource.
    :vartype cloud_pc_resource: bool
    :param public_network_access: Enabled allows this resource to be accessed from both public and
     private networks, Disabled allows this resource to only be accessed via private endpoints.
     Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or
     ~desktop_virtualization_api_client.models.PublicNetworkAccess
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'pattern': r'^[-\w\._,\(\)]+$'},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'object_id': {'readonly': True},
        'host_pool_type': {'required': True},
        'load_balancer_type': {'required': True},
        'application_group_references': {'readonly': True},
        'preferred_app_group_type': {'required': True},
        'cloud_pc_resource': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ResourceModelWithAllowedPropertySetIdentity'},
        'sku': {'key': 'sku', 'type': 'ResourceModelWithAllowedPropertySetSku'},
        'plan': {'key': 'plan', 'type': 'ResourceModelWithAllowedPropertySetPlan'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'object_id': {'key': 'properties.objectId', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'host_pool_type': {'key': 'properties.hostPoolType', 'type': 'str'},
        'personal_desktop_assignment_type': {'key': 'properties.personalDesktopAssignmentType', 'type': 'str'},
        'custom_rdp_property': {'key': 'properties.customRdpProperty', 'type': 'str'},
        'max_session_limit': {'key': 'properties.maxSessionLimit', 'type': 'int'},
        'load_balancer_type': {'key': 'properties.loadBalancerType', 'type': 'str'},
        'ring': {'key': 'properties.ring', 'type': 'int'},
        'validation_environment': {'key': 'properties.validationEnvironment', 'type': 'bool'},
        'registration_info': {'key': 'properties.registrationInfo', 'type': 'RegistrationInfo'},
        'vm_template': {'key': 'properties.vmTemplate', 'type': 'str'},
        'application_group_references': {'key': 'properties.applicationGroupReferences', 'type': '[str]'},
        'ssoadfs_authority': {'key': 'properties.ssoadfsAuthority', 'type': 'str'},
        'sso_client_id': {'key': 'properties.ssoClientId', 'type': 'str'},
        'sso_client_secret_key_vault_path': {'key': 'properties.ssoClientSecretKeyVaultPath', 'type': 'str'},
        'sso_secret_type': {'key': 'properties.ssoSecretType', 'type': 'str'},
        'preferred_app_group_type': {'key': 'properties.preferredAppGroupType', 'type': 'str'},
        'start_vm_on_connect': {'key': 'properties.startVMOnConnect', 'type': 'bool'},
        'migration_request': {'key': 'properties.migrationRequest', 'type': 'MigrationRequestProperties'},
        'cloud_pc_resource': {'key': 'properties.cloudPcResource', 'type': 'bool'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostPool, self).__init__(**kwargs)
        self.system_data = None
        self.object_id = None
        self.friendly_name = kwargs.get('friendly_name', None)
        self.description = kwargs.get('description', None)
        self.host_pool_type = kwargs['host_pool_type']
        self.personal_desktop_assignment_type = kwargs.get('personal_desktop_assignment_type', None)
        self.custom_rdp_property = kwargs.get('custom_rdp_property', None)
        self.max_session_limit = kwargs.get('max_session_limit', None)
        self.load_balancer_type = kwargs['load_balancer_type']
        self.ring = kwargs.get('ring', None)
        self.validation_environment = kwargs.get('validation_environment', None)
        self.registration_info = kwargs.get('registration_info', None)
        self.vm_template = kwargs.get('vm_template', None)
        self.application_group_references = None
        self.ssoadfs_authority = kwargs.get('ssoadfs_authority', None)
        self.sso_client_id = kwargs.get('sso_client_id', None)
        self.sso_client_secret_key_vault_path = kwargs.get('sso_client_secret_key_vault_path', None)
        self.sso_secret_type = kwargs.get('sso_secret_type', None)
        self.preferred_app_group_type = kwargs['preferred_app_group_type']
        self.start_vm_on_connect = kwargs.get('start_vm_on_connect', None)
        self.migration_request = kwargs.get('migration_request', None)
        self.cloud_pc_resource = None
        self.public_network_access = kwargs.get('public_network_access', None)


class HostPoolList(msrest.serialization.Model):
    """List of HostPool definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of HostPool definitions.
    :type value: list[~desktop_virtualization_api_client.models.HostPool]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HostPool]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostPoolList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class HostPoolPatch(Resource):
    """HostPool properties that can be patched.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. tags to be updated.
    :type tags: dict[str, str]
    :param friendly_name: Friendly name of HostPool.
    :type friendly_name: str
    :param description: Description of HostPool.
    :type description: str
    :param custom_rdp_property: Custom rdp property of HostPool.
    :type custom_rdp_property: str
    :param max_session_limit: The max session limit of HostPool.
    :type max_session_limit: int
    :param personal_desktop_assignment_type: PersonalDesktopAssignment type for HostPool. Possible
     values include: "Automatic", "Direct".
    :type personal_desktop_assignment_type: str or
     ~desktop_virtualization_api_client.models.PersonalDesktopAssignmentType
    :param load_balancer_type: The type of the load balancer. Possible values include:
     "BreadthFirst", "DepthFirst", "Persistent".
    :type load_balancer_type: str or ~desktop_virtualization_api_client.models.LoadBalancerType
    :param ring: The ring number of HostPool.
    :type ring: int
    :param validation_environment: Is validation environment.
    :type validation_environment: bool
    :param registration_info: The registration info of HostPool.
    :type registration_info: ~desktop_virtualization_api_client.models.RegistrationInfoPatch
    :param vm_template: VM template for sessionhosts configuration within hostpool.
    :type vm_template: str
    :param ssoadfs_authority: URL to customer ADFS server for signing WVD SSO certificates.
    :type ssoadfs_authority: str
    :param sso_client_id: ClientId for the registered Relying Party used to issue WVD SSO
     certificates.
    :type sso_client_id: str
    :param sso_client_secret_key_vault_path: Path to Azure KeyVault storing the secret used for
     communication to ADFS.
    :type sso_client_secret_key_vault_path: str
    :param sso_secret_type: The type of single sign on Secret Type. Possible values include:
     "SharedKey", "Certificate", "SharedKeyInKeyVault", "CertificateInKeyVault".
    :type sso_secret_type: str or ~desktop_virtualization_api_client.models.SSOSecretType
    :param preferred_app_group_type: The type of preferred application group type, default to
     Desktop Application Group. Possible values include: "None", "Desktop", "RailApplications".
    :type preferred_app_group_type: str or
     ~desktop_virtualization_api_client.models.PreferredAppGroupType
    :param start_vm_on_connect: The flag to turn on/off StartVMOnConnect feature.
    :type start_vm_on_connect: bool
    :param public_network_access: Enabled to allow this resource to be access from the public
     network. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or
     ~desktop_virtualization_api_client.models.PublicNetworkAccess
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'custom_rdp_property': {'key': 'properties.customRdpProperty', 'type': 'str'},
        'max_session_limit': {'key': 'properties.maxSessionLimit', 'type': 'int'},
        'personal_desktop_assignment_type': {'key': 'properties.personalDesktopAssignmentType', 'type': 'str'},
        'load_balancer_type': {'key': 'properties.loadBalancerType', 'type': 'str'},
        'ring': {'key': 'properties.ring', 'type': 'int'},
        'validation_environment': {'key': 'properties.validationEnvironment', 'type': 'bool'},
        'registration_info': {'key': 'properties.registrationInfo', 'type': 'RegistrationInfoPatch'},
        'vm_template': {'key': 'properties.vmTemplate', 'type': 'str'},
        'ssoadfs_authority': {'key': 'properties.ssoadfsAuthority', 'type': 'str'},
        'sso_client_id': {'key': 'properties.ssoClientId', 'type': 'str'},
        'sso_client_secret_key_vault_path': {'key': 'properties.ssoClientSecretKeyVaultPath', 'type': 'str'},
        'sso_secret_type': {'key': 'properties.ssoSecretType', 'type': 'str'},
        'preferred_app_group_type': {'key': 'properties.preferredAppGroupType', 'type': 'str'},
        'start_vm_on_connect': {'key': 'properties.startVMOnConnect', 'type': 'bool'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HostPoolPatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.description = kwargs.get('description', None)
        self.custom_rdp_property = kwargs.get('custom_rdp_property', None)
        self.max_session_limit = kwargs.get('max_session_limit', None)
        self.personal_desktop_assignment_type = kwargs.get('personal_desktop_assignment_type', None)
        self.load_balancer_type = kwargs.get('load_balancer_type', None)
        self.ring = kwargs.get('ring', None)
        self.validation_environment = kwargs.get('validation_environment', None)
        self.registration_info = kwargs.get('registration_info', None)
        self.vm_template = kwargs.get('vm_template', None)
        self.ssoadfs_authority = kwargs.get('ssoadfs_authority', None)
        self.sso_client_id = kwargs.get('sso_client_id', None)
        self.sso_client_secret_key_vault_path = kwargs.get('sso_client_secret_key_vault_path', None)
        self.sso_secret_type = kwargs.get('sso_secret_type', None)
        self.preferred_app_group_type = kwargs.get('preferred_app_group_type', None)
        self.start_vm_on_connect = kwargs.get('start_vm_on_connect', None)
        self.public_network_access = kwargs.get('public_network_access', None)


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :param type: The identity type. The only acceptable values to pass in are None and
     "SystemAssigned". The default value is None.
    :type type: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)


class LogSpecification(msrest.serialization.Model):
    """Specifications of the Log for Azure Monitoring.

    :param name: Name of the log.
    :type name: str
    :param display_name: Localized friendly display name of the log.
    :type display_name: str
    :param blob_duration: Blob duration of the log.
    :type blob_duration: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogSpecification, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.blob_duration = kwargs.get('blob_duration', None)


class MigrationRequestProperties(msrest.serialization.Model):
    """Properties for arm migration.

    :param operation: The type of operation for migration. Possible values include: "Start",
     "Revoke", "Complete", "Hide", "Unhide".
    :type operation: str or ~desktop_virtualization_api_client.models.Operation
    :param migration_path: The path to the legacy object to migrate.
    :type migration_path: str
    """

    _attribute_map = {
        'operation': {'key': 'operation', 'type': 'str'},
        'migration_path': {'key': 'migrationPath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MigrationRequestProperties, self).__init__(**kwargs)
        self.operation = kwargs.get('operation', None)
        self.migration_path = kwargs.get('migration_path', None)


class MSIXImageURI(msrest.serialization.Model):
    """Represents URI referring to MSIX Image.

    :param uri: URI to Image.
    :type uri: str
    """

    _attribute_map = {
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MSIXImageURI, self).__init__(**kwargs)
        self.uri = kwargs.get('uri', None)


class MSIXPackage(Resource):
    """Schema for MSIX Package properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    :param image_path: VHD/CIM image path on Network Share.
    :type image_path: str
    :param package_name: Package Name from appxmanifest.xml.
    :type package_name: str
    :param package_family_name: Package Family Name from appxmanifest.xml. Contains Package Name
     and Publisher name.
    :type package_family_name: str
    :param display_name: User friendly Name to be displayed in the portal.
    :type display_name: str
    :param package_relative_path: Relative Path to the package inside the image.
    :type package_relative_path: str
    :param is_regular_registration: Specifies how to register Package in feed.
    :type is_regular_registration: bool
    :param is_active: Make this version of the package the active one across the hostpool.
    :type is_active: bool
    :param package_dependencies: List of package dependencies.
    :type package_dependencies:
     list[~desktop_virtualization_api_client.models.MsixPackageDependencies]
    :param version: Package Version found in the appxmanifest.xml.
    :type version: str
    :param last_updated: Date Package was last updated, found in the appxmanifest.xml.
    :type last_updated: ~datetime.datetime
    :param package_applications: List of package applications.
    :type package_applications:
     list[~desktop_virtualization_api_client.models.MsixPackageApplications]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'image_path': {'key': 'properties.imagePath', 'type': 'str'},
        'package_name': {'key': 'properties.packageName', 'type': 'str'},
        'package_family_name': {'key': 'properties.packageFamilyName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'package_relative_path': {'key': 'properties.packageRelativePath', 'type': 'str'},
        'is_regular_registration': {'key': 'properties.isRegularRegistration', 'type': 'bool'},
        'is_active': {'key': 'properties.isActive', 'type': 'bool'},
        'package_dependencies': {'key': 'properties.packageDependencies', 'type': '[MsixPackageDependencies]'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'last_updated': {'key': 'properties.lastUpdated', 'type': 'iso-8601'},
        'package_applications': {'key': 'properties.packageApplications', 'type': '[MsixPackageApplications]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MSIXPackage, self).__init__(**kwargs)
        self.system_data = None
        self.image_path = kwargs.get('image_path', None)
        self.package_name = kwargs.get('package_name', None)
        self.package_family_name = kwargs.get('package_family_name', None)
        self.display_name = kwargs.get('display_name', None)
        self.package_relative_path = kwargs.get('package_relative_path', None)
        self.is_regular_registration = kwargs.get('is_regular_registration', None)
        self.is_active = kwargs.get('is_active', None)
        self.package_dependencies = kwargs.get('package_dependencies', None)
        self.version = kwargs.get('version', None)
        self.last_updated = kwargs.get('last_updated', None)
        self.package_applications = kwargs.get('package_applications', None)


class MsixPackageApplications(msrest.serialization.Model):
    """Schema for MSIX Package Application properties.

    :param app_id: Package Application Id, found in appxmanifest.xml.
    :type app_id: str
    :param description: Description of Package Application.
    :type description: str
    :param app_user_model_id: Used to activate Package Application. Consists of Package Name and
     ApplicationID. Found in appxmanifest.xml.
    :type app_user_model_id: str
    :param friendly_name: User friendly name.
    :type friendly_name: str
    :param icon_image_name: User friendly name.
    :type icon_image_name: str
    :param raw_icon: the icon a 64 bit string as a byte array.
    :type raw_icon: bytearray
    :param raw_png: the icon a 64 bit string as a byte array.
    :type raw_png: bytearray
    """

    _attribute_map = {
        'app_id': {'key': 'appId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'app_user_model_id': {'key': 'appUserModelID', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'icon_image_name': {'key': 'iconImageName', 'type': 'str'},
        'raw_icon': {'key': 'rawIcon', 'type': 'bytearray'},
        'raw_png': {'key': 'rawPng', 'type': 'bytearray'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MsixPackageApplications, self).__init__(**kwargs)
        self.app_id = kwargs.get('app_id', None)
        self.description = kwargs.get('description', None)
        self.app_user_model_id = kwargs.get('app_user_model_id', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.icon_image_name = kwargs.get('icon_image_name', None)
        self.raw_icon = kwargs.get('raw_icon', None)
        self.raw_png = kwargs.get('raw_png', None)


class MsixPackageDependencies(msrest.serialization.Model):
    """Schema for MSIX Package Dependencies properties.

    :param dependency_name: Name of package dependency.
    :type dependency_name: str
    :param publisher: Name of dependency publisher.
    :type publisher: str
    :param min_version: Dependency version required.
    :type min_version: str
    """

    _attribute_map = {
        'dependency_name': {'key': 'dependencyName', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'min_version': {'key': 'minVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MsixPackageDependencies, self).__init__(**kwargs)
        self.dependency_name = kwargs.get('dependency_name', None)
        self.publisher = kwargs.get('publisher', None)
        self.min_version = kwargs.get('min_version', None)


class MSIXPackageList(msrest.serialization.Model):
    """List of MSIX Package definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of MSIX Package definitions.
    :type value: list[~desktop_virtualization_api_client.models.MSIXPackage]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MSIXPackage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MSIXPackageList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class MSIXPackagePatch(Resource):
    """MSIX Package properties that can be patched.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param is_active: Set a version of the package to be active across hostpool.
    :type is_active: bool
    :param is_regular_registration: Set Registration mode. Regular or Delayed.
    :type is_regular_registration: bool
    :param display_name: Display name for MSIX Package.
    :type display_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_active': {'key': 'properties.isActive', 'type': 'bool'},
        'is_regular_registration': {'key': 'properties.isRegularRegistration', 'type': 'bool'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MSIXPackagePatch, self).__init__(**kwargs)
        self.is_active = kwargs.get('is_active', None)
        self.is_regular_registration = kwargs.get('is_regular_registration', None)
        self.display_name = kwargs.get('display_name', None)


class OperationProperties(msrest.serialization.Model):
    """Properties of the operation.

    :param service_specification: Service specification payload.
    :type service_specification: ~desktop_virtualization_api_client.models.ServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationProperties, self).__init__(**kwargs)
        self.service_specification = kwargs.get('service_specification', None)


class Plan(msrest.serialization.Model):
    """Plan for the resource.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. A user defined name of the 3rd Party Artifact that is being procured.
    :type name: str
    :param publisher: Required. The publisher of the 3rd Party Artifact that is being bought. E.g.
     NewRelic.
    :type publisher: str
    :param product: Required. The 3rd Party artifact that is being procured. E.g. NewRelic. Product
     maps to the OfferID specified for the artifact at the time of Data Market onboarding.
    :type product: str
    :param promotion_code: A publisher provided promotion code as provisioned in Data Market for
     the said product/artifact.
    :type promotion_code: str
    :param version: The version of the desired product/artifact.
    :type version: str
    """

    _validation = {
        'name': {'required': True},
        'publisher': {'required': True},
        'product': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
        'promotion_code': {'key': 'promotionCode', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Plan, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.publisher = kwargs['publisher']
        self.product = kwargs['product']
        self.promotion_code = kwargs.get('promotion_code', None)
        self.version = kwargs.get('version', None)


class PrivateEndpoint(msrest.serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param private_endpoint: The resource of private end point.
    :type private_endpoint: ~desktop_virtualization_api_client.models.PrivateEndpoint
    :param private_link_service_connection_state: A collection of information about the state of
     the connection between service consumer and provider.
    :type private_link_service_connection_state:
     ~desktop_virtualization_api_client.models.PrivateLinkServiceConnectionState
    :param provisioning_state: The provisioning state of the private endpoint connection resource.
     Possible values include: "Succeeded", "Creating", "Deleting", "Failed".
    :type provisioning_state: str or
     ~desktop_virtualization_api_client.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class PrivateEndpointConnectionListResultWithSystemData(msrest.serialization.Model):
    """List of private endpoint connection associated with the specified storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: Array of private endpoint connections.
    :type value:
     list[~desktop_virtualization_api_client.models.PrivateEndpointConnectionWithSystemData]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnectionWithSystemData]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResultWithSystemData, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class PrivateEndpointConnectionWithSystemData(PrivateEndpointConnection):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param private_endpoint: The resource of private end point.
    :type private_endpoint: ~desktop_virtualization_api_client.models.PrivateEndpoint
    :param private_link_service_connection_state: A collection of information about the state of
     the connection between service consumer and provider.
    :type private_link_service_connection_state:
     ~desktop_virtualization_api_client.models.PrivateLinkServiceConnectionState
    :param provisioning_state: The provisioning state of the private endpoint connection resource.
     Possible values include: "Succeeded", "Creating", "Deleting", "Failed".
    :type provisioning_state: str or
     ~desktop_virtualization_api_client.models.PrivateEndpointConnectionProvisioningState
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionWithSystemData, self).__init__(**kwargs)
        self.system_data = None


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :param required_zone_names: The private link resource Private link DNS zone name.
    :type required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = kwargs.get('required_zone_names', None)


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: Array of private link resources.
    :type value: list[~desktop_virtualization_api_client.models.PrivateLinkResource]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :param status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Possible values include: "Pending", "Approved", "Rejected".
    :type status: str or
     ~desktop_virtualization_api_client.models.PrivateEndpointServiceConnectionStatus
    :param description: The reason for approval/rejection of the connection.
    :type description: str
    :param actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :type actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.description = kwargs.get('description', None)
        self.actions_required = kwargs.get('actions_required', None)


class RegistrationInfo(msrest.serialization.Model):
    """Represents a RegistrationInfo definition.

    :param expiration_time: Expiration time of registration token.
    :type expiration_time: ~datetime.datetime
    :param token: The registration token base64 encoded string.
    :type token: str
    :param registration_token_operation: The type of resetting the token. Possible values include:
     "Delete", "None", "Update".
    :type registration_token_operation: str or
     ~desktop_virtualization_api_client.models.RegistrationTokenOperation
    """

    _attribute_map = {
        'expiration_time': {'key': 'expirationTime', 'type': 'iso-8601'},
        'token': {'key': 'token', 'type': 'str'},
        'registration_token_operation': {'key': 'registrationTokenOperation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistrationInfo, self).__init__(**kwargs)
        self.expiration_time = kwargs.get('expiration_time', None)
        self.token = kwargs.get('token', None)
        self.registration_token_operation = kwargs.get('registration_token_operation', None)


class RegistrationInfoPatch(msrest.serialization.Model):
    """Represents a RegistrationInfo definition.

    :param expiration_time: Expiration time of registration token.
    :type expiration_time: ~datetime.datetime
    :param registration_token_operation: The type of resetting the token. Possible values include:
     "Delete", "None", "Update".
    :type registration_token_operation: str or
     ~desktop_virtualization_api_client.models.RegistrationTokenOperation
    """

    _attribute_map = {
        'expiration_time': {'key': 'expirationTime', 'type': 'iso-8601'},
        'registration_token_operation': {'key': 'registrationTokenOperation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistrationInfoPatch, self).__init__(**kwargs)
        self.expiration_time = kwargs.get('expiration_time', None)
        self.registration_token_operation = kwargs.get('registration_token_operation', None)


class ResourceModelWithAllowedPropertySetIdentity(Identity):
    """ResourceModelWithAllowedPropertySetIdentity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :param type: The identity type. The only acceptable values to pass in are None and
     "SystemAssigned". The default value is None.
    :type type: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceModelWithAllowedPropertySetIdentity, self).__init__(**kwargs)


class ResourceModelWithAllowedPropertySetPlan(Plan):
    """ResourceModelWithAllowedPropertySetPlan.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. A user defined name of the 3rd Party Artifact that is being procured.
    :type name: str
    :param publisher: Required. The publisher of the 3rd Party Artifact that is being bought. E.g.
     NewRelic.
    :type publisher: str
    :param product: Required. The 3rd Party artifact that is being procured. E.g. NewRelic. Product
     maps to the OfferID specified for the artifact at the time of Data Market onboarding.
    :type product: str
    :param promotion_code: A publisher provided promotion code as provisioned in Data Market for
     the said product/artifact.
    :type promotion_code: str
    :param version: The version of the desired product/artifact.
    :type version: str
    """

    _validation = {
        'name': {'required': True},
        'publisher': {'required': True},
        'product': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
        'promotion_code': {'key': 'promotionCode', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceModelWithAllowedPropertySetPlan, self).__init__(**kwargs)


class Sku(msrest.serialization.Model):
    """The resource model definition representing SKU.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the SKU. Ex - P3. It is typically a letter+number code.
    :type name: str
    :param tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
     "Standard", "Premium".
    :type tier: str or ~desktop_virtualization_api_client.models.SkuTier
    :param size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :type size: str
    :param family: If the service has different generations of hardware, for the same SKU, then
     that can be captured here.
    :type family: str
    :param capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.tier = kwargs.get('tier', None)
        self.size = kwargs.get('size', None)
        self.family = kwargs.get('family', None)
        self.capacity = kwargs.get('capacity', None)


class ResourceModelWithAllowedPropertySetSku(Sku):
    """ResourceModelWithAllowedPropertySetSku.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the SKU. Ex - P3. It is typically a letter+number code.
    :type name: str
    :param tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
     "Standard", "Premium".
    :type tier: str or ~desktop_virtualization_api_client.models.SkuTier
    :param size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :type size: str
    :param family: If the service has different generations of hardware, for the same SKU, then
     that can be captured here.
    :type family: str
    :param capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceModelWithAllowedPropertySetSku, self).__init__(**kwargs)


class ResourceProviderOperation(msrest.serialization.Model):
    """Supported operation of this resource provider.

    :param name: Operation name, in format of {provider}/{resource}/{operation}.
    :type name: str
    :param display: Display metadata associated with the operation.
    :type display: ~desktop_virtualization_api_client.models.ResourceProviderOperationDisplay
    :param is_data_action: Is a data action.
    :type is_data_action: bool
    :param properties: Properties of the operation.
    :type properties: ~desktop_virtualization_api_client.models.OperationProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'ResourceProviderOperationDisplay'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'OperationProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceProviderOperation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.is_data_action = kwargs.get('is_data_action', None)
        self.properties = kwargs.get('properties', None)


class ResourceProviderOperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :param provider: Resource provider: Microsoft Desktop Virtualization.
    :type provider: str
    :param resource: Resource on which the operation is performed.
    :type resource: str
    :param operation: Type of operation: get, read, delete, etc.
    :type operation: str
    :param description: Description of this operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceProviderOperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class ResourceProviderOperationList(msrest.serialization.Model):
    """Result of the request to list operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of operations supported by this resource provider.
    :type value: list[~desktop_virtualization_api_client.models.ResourceProviderOperation]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceProviderOperation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceProviderOperationList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ScalingHostPoolReference(msrest.serialization.Model):
    """Scaling plan reference to hostpool.

    :param host_pool_arm_path: Arm path of referenced hostpool.
    :type host_pool_arm_path: str
    :param scaling_plan_enabled: Is the scaling plan enabled for this hostpool.
    :type scaling_plan_enabled: bool
    """

    _attribute_map = {
        'host_pool_arm_path': {'key': 'hostPoolArmPath', 'type': 'str'},
        'scaling_plan_enabled': {'key': 'scalingPlanEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScalingHostPoolReference, self).__init__(**kwargs)
        self.host_pool_arm_path = kwargs.get('host_pool_arm_path', None)
        self.scaling_plan_enabled = kwargs.get('scaling_plan_enabled', None)


class ScalingPlan(ResourceModelWithAllowedPropertySet):
    """Represents a scaling plan definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: The geo-location where the resource lives.
    :type location: str
    :param managed_by: The fully qualified resource ID of the resource that manages this resource.
     Indicates if this resource is managed by another Azure resource. If this is present, complete
     mode deployment will not delete the resource if it is removed from the template since it is
     managed by another resource.
    :type managed_by: str
    :param kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :type kind: str
    :ivar etag: The etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal etag convention.  Entity tags are used for
     comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in
     the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range
     (section 14.27) header fields.
    :vartype etag: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity:
    :type identity:
     ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetIdentity
    :param sku:
    :type sku: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetSku
    :param plan:
    :type plan: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetPlan
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    :ivar object_id: ObjectId of scaling plan. (internal use).
    :vartype object_id: str
    :param description: Description of scaling plan.
    :type description: str
    :param friendly_name: User friendly name of scaling plan.
    :type friendly_name: str
    :param time_zone: Timezone of the scaling plan.
    :type time_zone: str
    :param host_pool_type: HostPool type for desktop. Possible values include: "Pooled".
    :type host_pool_type: str or ~desktop_virtualization_api_client.models.ScalingHostPoolType
    :param exclusion_tag: Exclusion tag for scaling plan.
    :type exclusion_tag: str
    :param schedules: List of ScalingSchedule definitions.
    :type schedules: list[~desktop_virtualization_api_client.models.ScalingSchedule]
    :param host_pool_references: List of ScalingHostPoolReference definitions.
    :type host_pool_references:
     list[~desktop_virtualization_api_client.models.ScalingHostPoolReference]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'pattern': r'^[-\w\._,\(\)]+$'},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'object_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ResourceModelWithAllowedPropertySetIdentity'},
        'sku': {'key': 'sku', 'type': 'ResourceModelWithAllowedPropertySetSku'},
        'plan': {'key': 'plan', 'type': 'ResourceModelWithAllowedPropertySetPlan'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'object_id': {'key': 'properties.objectId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'time_zone': {'key': 'properties.timeZone', 'type': 'str'},
        'host_pool_type': {'key': 'properties.hostPoolType', 'type': 'str'},
        'exclusion_tag': {'key': 'properties.exclusionTag', 'type': 'str'},
        'schedules': {'key': 'properties.schedules', 'type': '[ScalingSchedule]'},
        'host_pool_references': {'key': 'properties.hostPoolReferences', 'type': '[ScalingHostPoolReference]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScalingPlan, self).__init__(**kwargs)
        self.system_data = None
        self.object_id = None
        self.description = kwargs.get('description', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.time_zone = kwargs.get('time_zone', None)
        self.host_pool_type = kwargs.get('host_pool_type', None)
        self.exclusion_tag = kwargs.get('exclusion_tag', None)
        self.schedules = kwargs.get('schedules', None)
        self.host_pool_references = kwargs.get('host_pool_references', None)


class ScalingPlanList(msrest.serialization.Model):
    """List of scaling plan definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of scaling plan definitions.
    :type value: list[~desktop_virtualization_api_client.models.ScalingPlan]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ScalingPlan]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScalingPlanList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ScalingPlanPatch(msrest.serialization.Model):
    """Scaling plan properties that can be patched.

    :param tags: A set of tags. tags to be updated.
    :type tags: dict[str, str]
    :param description: Description of scaling plan.
    :type description: str
    :param friendly_name: User friendly name of scaling plan.
    :type friendly_name: str
    :param time_zone: Timezone of the scaling plan.
    :type time_zone: str
    :param exclusion_tag: Exclusion tag for scaling plan.
    :type exclusion_tag: str
    :param schedules: List of ScalingSchedule definitions.
    :type schedules: list[~desktop_virtualization_api_client.models.ScalingSchedule]
    :param host_pool_references: List of ScalingHostPoolReference definitions.
    :type host_pool_references:
     list[~desktop_virtualization_api_client.models.ScalingHostPoolReference]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'time_zone': {'key': 'properties.timeZone', 'type': 'str'},
        'exclusion_tag': {'key': 'properties.exclusionTag', 'type': 'str'},
        'schedules': {'key': 'properties.schedules', 'type': '[ScalingSchedule]'},
        'host_pool_references': {'key': 'properties.hostPoolReferences', 'type': '[ScalingHostPoolReference]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScalingPlanPatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.description = kwargs.get('description', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.time_zone = kwargs.get('time_zone', None)
        self.exclusion_tag = kwargs.get('exclusion_tag', None)
        self.schedules = kwargs.get('schedules', None)
        self.host_pool_references = kwargs.get('host_pool_references', None)


class ScalingSchedule(msrest.serialization.Model):
    """Scaling plan schedule.

    :param name: Name of the scaling schedule.
    :type name: str
    :param days_of_week: Set of days of the week on which this schedule is active.
    :type days_of_week: list[str or
     ~desktop_virtualization_api_client.models.ScalingScheduleDaysOfWeekItem]
    :param ramp_up_start_time: Starting time for ramp up period.
    :type ramp_up_start_time: ~desktop_virtualization_api_client.models.Time
    :param ramp_up_load_balancing_algorithm: Load balancing algorithm for ramp up period. Possible
     values include: "BreadthFirst", "DepthFirst".
    :type ramp_up_load_balancing_algorithm: str or
     ~desktop_virtualization_api_client.models.SessionHostLoadBalancingAlgorithm
    :param ramp_up_minimum_hosts_pct: Minimum host percentage for ramp up period.
    :type ramp_up_minimum_hosts_pct: int
    :param ramp_up_capacity_threshold_pct: Capacity threshold for ramp up period.
    :type ramp_up_capacity_threshold_pct: int
    :param peak_start_time: Starting time for peak period.
    :type peak_start_time: ~desktop_virtualization_api_client.models.Time
    :param peak_load_balancing_algorithm: Load balancing algorithm for peak period. Possible values
     include: "BreadthFirst", "DepthFirst".
    :type peak_load_balancing_algorithm: str or
     ~desktop_virtualization_api_client.models.SessionHostLoadBalancingAlgorithm
    :param ramp_down_start_time: Starting time for ramp down period.
    :type ramp_down_start_time: ~desktop_virtualization_api_client.models.Time
    :param ramp_down_load_balancing_algorithm: Load balancing algorithm for ramp down period.
     Possible values include: "BreadthFirst", "DepthFirst".
    :type ramp_down_load_balancing_algorithm: str or
     ~desktop_virtualization_api_client.models.SessionHostLoadBalancingAlgorithm
    :param ramp_down_minimum_hosts_pct: Minimum host percentage for ramp down period.
    :type ramp_down_minimum_hosts_pct: int
    :param ramp_down_capacity_threshold_pct: Capacity threshold for ramp down period.
    :type ramp_down_capacity_threshold_pct: int
    :param ramp_down_force_logoff_users: Should users be logged off forcefully from hosts.
    :type ramp_down_force_logoff_users: bool
    :param ramp_down_stop_hosts_when: Specifies when to stop hosts during ramp down period.
     Possible values include: "ZeroSessions", "ZeroActiveSessions".
    :type ramp_down_stop_hosts_when: str or ~desktop_virtualization_api_client.models.StopHostsWhen
    :param ramp_down_wait_time_minutes: Number of minutes to wait to stop hosts during ramp down
     period.
    :type ramp_down_wait_time_minutes: int
    :param ramp_down_notification_message: Notification message for users during ramp down period.
    :type ramp_down_notification_message: str
    :param off_peak_start_time: Starting time for off-peak period.
    :type off_peak_start_time: ~desktop_virtualization_api_client.models.Time
    :param off_peak_load_balancing_algorithm: Load balancing algorithm for off-peak period.
     Possible values include: "BreadthFirst", "DepthFirst".
    :type off_peak_load_balancing_algorithm: str or
     ~desktop_virtualization_api_client.models.SessionHostLoadBalancingAlgorithm
    """

    _validation = {
        'ramp_up_minimum_hosts_pct': {'maximum': 100, 'minimum': 0},
        'ramp_up_capacity_threshold_pct': {'maximum': 100, 'minimum': 1},
        'ramp_down_minimum_hosts_pct': {'maximum': 100, 'minimum': 0},
        'ramp_down_capacity_threshold_pct': {'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'days_of_week': {'key': 'daysOfWeek', 'type': '[str]'},
        'ramp_up_start_time': {'key': 'rampUpStartTime', 'type': 'Time'},
        'ramp_up_load_balancing_algorithm': {'key': 'rampUpLoadBalancingAlgorithm', 'type': 'str'},
        'ramp_up_minimum_hosts_pct': {'key': 'rampUpMinimumHostsPct', 'type': 'int'},
        'ramp_up_capacity_threshold_pct': {'key': 'rampUpCapacityThresholdPct', 'type': 'int'},
        'peak_start_time': {'key': 'peakStartTime', 'type': 'Time'},
        'peak_load_balancing_algorithm': {'key': 'peakLoadBalancingAlgorithm', 'type': 'str'},
        'ramp_down_start_time': {'key': 'rampDownStartTime', 'type': 'Time'},
        'ramp_down_load_balancing_algorithm': {'key': 'rampDownLoadBalancingAlgorithm', 'type': 'str'},
        'ramp_down_minimum_hosts_pct': {'key': 'rampDownMinimumHostsPct', 'type': 'int'},
        'ramp_down_capacity_threshold_pct': {'key': 'rampDownCapacityThresholdPct', 'type': 'int'},
        'ramp_down_force_logoff_users': {'key': 'rampDownForceLogoffUsers', 'type': 'bool'},
        'ramp_down_stop_hosts_when': {'key': 'rampDownStopHostsWhen', 'type': 'str'},
        'ramp_down_wait_time_minutes': {'key': 'rampDownWaitTimeMinutes', 'type': 'int'},
        'ramp_down_notification_message': {'key': 'rampDownNotificationMessage', 'type': 'str'},
        'off_peak_start_time': {'key': 'offPeakStartTime', 'type': 'Time'},
        'off_peak_load_balancing_algorithm': {'key': 'offPeakLoadBalancingAlgorithm', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScalingSchedule, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.days_of_week = kwargs.get('days_of_week', None)
        self.ramp_up_start_time = kwargs.get('ramp_up_start_time', None)
        self.ramp_up_load_balancing_algorithm = kwargs.get('ramp_up_load_balancing_algorithm', None)
        self.ramp_up_minimum_hosts_pct = kwargs.get('ramp_up_minimum_hosts_pct', None)
        self.ramp_up_capacity_threshold_pct = kwargs.get('ramp_up_capacity_threshold_pct', None)
        self.peak_start_time = kwargs.get('peak_start_time', None)
        self.peak_load_balancing_algorithm = kwargs.get('peak_load_balancing_algorithm', None)
        self.ramp_down_start_time = kwargs.get('ramp_down_start_time', None)
        self.ramp_down_load_balancing_algorithm = kwargs.get('ramp_down_load_balancing_algorithm', None)
        self.ramp_down_minimum_hosts_pct = kwargs.get('ramp_down_minimum_hosts_pct', None)
        self.ramp_down_capacity_threshold_pct = kwargs.get('ramp_down_capacity_threshold_pct', None)
        self.ramp_down_force_logoff_users = kwargs.get('ramp_down_force_logoff_users', None)
        self.ramp_down_stop_hosts_when = kwargs.get('ramp_down_stop_hosts_when', None)
        self.ramp_down_wait_time_minutes = kwargs.get('ramp_down_wait_time_minutes', None)
        self.ramp_down_notification_message = kwargs.get('ramp_down_notification_message', None)
        self.off_peak_start_time = kwargs.get('off_peak_start_time', None)
        self.off_peak_load_balancing_algorithm = kwargs.get('off_peak_load_balancing_algorithm', None)


class SendMessage(msrest.serialization.Model):
    """Represents message sent to a UserSession.

    :param message_title: Title of message.
    :type message_title: str
    :param message_body: Body of message.
    :type message_body: str
    """

    _attribute_map = {
        'message_title': {'key': 'messageTitle', 'type': 'str'},
        'message_body': {'key': 'messageBody', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SendMessage, self).__init__(**kwargs)
        self.message_title = kwargs.get('message_title', None)
        self.message_body = kwargs.get('message_body', None)


class ServiceSpecification(msrest.serialization.Model):
    """Service specification payload.

    :param log_specifications: Specifications of the Log for Azure Monitoring.
    :type log_specifications: list[~desktop_virtualization_api_client.models.LogSpecification]
    """

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = kwargs.get('log_specifications', None)


class SessionHost(Resource):
    """Represents a SessionHost definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    :ivar object_id: ObjectId of SessionHost. (internal use).
    :vartype object_id: str
    :param last_heart_beat: Last heart beat from SessionHost.
    :type last_heart_beat: ~datetime.datetime
    :param sessions: Number of sessions on SessionHost.
    :type sessions: int
    :param agent_version: Version of agent on SessionHost.
    :type agent_version: str
    :param allow_new_session: Allow a new session.
    :type allow_new_session: bool
    :ivar virtual_machine_id: Virtual Machine Id of SessionHost's underlying virtual machine.
    :vartype virtual_machine_id: str
    :ivar resource_id: Resource Id of SessionHost's underlying virtual machine.
    :vartype resource_id: str
    :param assigned_user: User assigned to SessionHost.
    :type assigned_user: str
    :param status: Status for a SessionHost. Possible values include: "Available", "Unavailable",
     "Shutdown", "Disconnected", "Upgrading", "UpgradeFailed", "NoHeartbeat", "NotJoinedToDomain",
     "DomainTrustRelationshipLost", "SxSStackListenerNotReady", "FSLogixNotHealthy",
     "NeedsAssistance".
    :type status: str or ~desktop_virtualization_api_client.models.Status
    :ivar status_timestamp: The timestamp of the status.
    :vartype status_timestamp: ~datetime.datetime
    :param os_version: The version of the OS on the session host.
    :type os_version: str
    :param sx_s_stack_version: The version of the side by side stack on the session host.
    :type sx_s_stack_version: str
    :param update_state: Update state of a SessionHost. Possible values include: "Initial",
     "Pending", "Started", "Succeeded", "Failed".
    :type update_state: str or ~desktop_virtualization_api_client.models.UpdateState
    :ivar last_update_time: The timestamp of the last update.
    :vartype last_update_time: ~datetime.datetime
    :param update_error_message: The error message.
    :type update_error_message: str
    :ivar session_host_health_check_results: List of SessionHostHealthCheckReports.
    :vartype session_host_health_check_results:
     list[~desktop_virtualization_api_client.models.SessionHostHealthCheckReport]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'object_id': {'readonly': True},
        'virtual_machine_id': {'readonly': True},
        'resource_id': {'readonly': True},
        'status_timestamp': {'readonly': True},
        'last_update_time': {'readonly': True},
        'session_host_health_check_results': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'object_id': {'key': 'properties.objectId', 'type': 'str'},
        'last_heart_beat': {'key': 'properties.lastHeartBeat', 'type': 'iso-8601'},
        'sessions': {'key': 'properties.sessions', 'type': 'int'},
        'agent_version': {'key': 'properties.agentVersion', 'type': 'str'},
        'allow_new_session': {'key': 'properties.allowNewSession', 'type': 'bool'},
        'virtual_machine_id': {'key': 'properties.virtualMachineId', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'assigned_user': {'key': 'properties.assignedUser', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'status_timestamp': {'key': 'properties.statusTimestamp', 'type': 'iso-8601'},
        'os_version': {'key': 'properties.osVersion', 'type': 'str'},
        'sx_s_stack_version': {'key': 'properties.sxSStackVersion', 'type': 'str'},
        'update_state': {'key': 'properties.updateState', 'type': 'str'},
        'last_update_time': {'key': 'properties.lastUpdateTime', 'type': 'iso-8601'},
        'update_error_message': {'key': 'properties.updateErrorMessage', 'type': 'str'},
        'session_host_health_check_results': {'key': 'properties.sessionHostHealthCheckResults', 'type': '[SessionHostHealthCheckReport]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SessionHost, self).__init__(**kwargs)
        self.system_data = None
        self.object_id = None
        self.last_heart_beat = kwargs.get('last_heart_beat', None)
        self.sessions = kwargs.get('sessions', None)
        self.agent_version = kwargs.get('agent_version', None)
        self.allow_new_session = kwargs.get('allow_new_session', None)
        self.virtual_machine_id = None
        self.resource_id = None
        self.assigned_user = kwargs.get('assigned_user', None)
        self.status = kwargs.get('status', None)
        self.status_timestamp = None
        self.os_version = kwargs.get('os_version', None)
        self.sx_s_stack_version = kwargs.get('sx_s_stack_version', None)
        self.update_state = kwargs.get('update_state', None)
        self.last_update_time = None
        self.update_error_message = kwargs.get('update_error_message', None)
        self.session_host_health_check_results = None


class SessionHostHealthCheckFailureDetails(msrest.serialization.Model):
    """Contains details on the failure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar message: Failure message: hints on what is wrong and how to recover.
    :vartype message: str
    :ivar error_code: Error code corresponding for the failure.
    :vartype error_code: int
    :ivar last_health_check_date_time: The timestamp of the last update.
    :vartype last_health_check_date_time: ~datetime.datetime
    """

    _validation = {
        'message': {'readonly': True},
        'error_code': {'readonly': True},
        'last_health_check_date_time': {'readonly': True},
    }

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'error_code': {'key': 'errorCode', 'type': 'int'},
        'last_health_check_date_time': {'key': 'lastHealthCheckDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SessionHostHealthCheckFailureDetails, self).__init__(**kwargs)
        self.message = None
        self.error_code = None
        self.last_health_check_date_time = None


class SessionHostHealthCheckReport(msrest.serialization.Model):
    """The report for session host information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar health_check_name: Represents the name of the health check operation performed. Possible
     values include: "DomainJoinedCheck", "DomainTrustCheck", "FSLogixHealthCheck",
     "SxSStackListenerCheck", "UrlsAccessibleCheck", "MonitoringAgentCheck", "DomainReachable",
     "WebRTCRedirectorCheck", "SupportedEncryptionCheck", "MetaDataServiceCheck",
     "AppAttachHealthCheck".
    :vartype health_check_name: str or ~desktop_virtualization_api_client.models.HealthCheckName
    :ivar health_check_result: Represents the Health state of the health check we performed.
     Possible values include: "Unknown", "HealthCheckSucceeded", "HealthCheckFailed",
     "SessionHostShutdown".
    :vartype health_check_result: str or
     ~desktop_virtualization_api_client.models.HealthCheckResult
    :ivar additional_failure_details: Additional detailed information on the failure.
    :vartype additional_failure_details:
     ~desktop_virtualization_api_client.models.SessionHostHealthCheckFailureDetails
    """

    _validation = {
        'health_check_name': {'readonly': True},
        'health_check_result': {'readonly': True},
        'additional_failure_details': {'readonly': True},
    }

    _attribute_map = {
        'health_check_name': {'key': 'healthCheckName', 'type': 'str'},
        'health_check_result': {'key': 'healthCheckResult', 'type': 'str'},
        'additional_failure_details': {'key': 'additionalFailureDetails', 'type': 'SessionHostHealthCheckFailureDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SessionHostHealthCheckReport, self).__init__(**kwargs)
        self.health_check_name = None
        self.health_check_result = None
        self.additional_failure_details = None


class SessionHostList(msrest.serialization.Model):
    """List of SessionHost definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of SessionHost definitions.
    :type value: list[~desktop_virtualization_api_client.models.SessionHost]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SessionHost]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SessionHostList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class SessionHostPatch(Resource):
    """SessionHost properties that can be patched.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param allow_new_session: Allow a new session.
    :type allow_new_session: bool
    :param assigned_user: User assigned to SessionHost.
    :type assigned_user: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'allow_new_session': {'key': 'properties.allowNewSession', 'type': 'bool'},
        'assigned_user': {'key': 'properties.assignedUser', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SessionHostPatch, self).__init__(**kwargs)
        self.allow_new_session = kwargs.get('allow_new_session', None)
        self.assigned_user = kwargs.get('assigned_user', None)


class StartMenuItem(Resource):
    """Represents a StartMenuItem definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param app_alias: Alias of StartMenuItem.
    :type app_alias: str
    :param file_path: Path to the file of StartMenuItem.
    :type file_path: str
    :param command_line_arguments: Command line arguments for StartMenuItem.
    :type command_line_arguments: str
    :param icon_path: Path to the icon.
    :type icon_path: str
    :param icon_index: Index of the icon.
    :type icon_index: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'app_alias': {'key': 'properties.appAlias', 'type': 'str'},
        'file_path': {'key': 'properties.filePath', 'type': 'str'},
        'command_line_arguments': {'key': 'properties.commandLineArguments', 'type': 'str'},
        'icon_path': {'key': 'properties.iconPath', 'type': 'str'},
        'icon_index': {'key': 'properties.iconIndex', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StartMenuItem, self).__init__(**kwargs)
        self.app_alias = kwargs.get('app_alias', None)
        self.file_path = kwargs.get('file_path', None)
        self.command_line_arguments = kwargs.get('command_line_arguments', None)
        self.icon_path = kwargs.get('icon_path', None)
        self.icon_index = kwargs.get('icon_index', None)


class StartMenuItemList(msrest.serialization.Model):
    """List of StartMenuItem definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of StartMenuItem definitions.
    :type value: list[~desktop_virtualization_api_client.models.StartMenuItem]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StartMenuItem]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StartMenuItemList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~desktop_virtualization_api_client.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~desktop_virtualization_api_client.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class Time(msrest.serialization.Model):
    """The time for a scaling action to occur.

    All required parameters must be populated in order to send to Azure.

    :param hour: Required. The hour.
    :type hour: int
    :param minute: Required. The minute.
    :type minute: int
    """

    _validation = {
        'hour': {'required': True, 'maximum': 23, 'minimum': 0},
        'minute': {'required': True, 'maximum': 59, 'minimum': 0},
    }

    _attribute_map = {
        'hour': {'key': 'hour', 'type': 'int'},
        'minute': {'key': 'minute', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Time, self).__init__(**kwargs)
        self.hour = kwargs['hour']
        self.minute = kwargs['minute']


class UserSession(Resource):
    """Represents a UserSession definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    :ivar object_id: ObjectId of user session. (internal use).
    :vartype object_id: str
    :param user_principal_name: The user principal name.
    :type user_principal_name: str
    :param application_type: Application type of application. Possible values include: "RemoteApp",
     "Desktop".
    :type application_type: str or ~desktop_virtualization_api_client.models.ApplicationType
    :param session_state: State of user session. Possible values include: "Unknown", "Active",
     "Disconnected", "Pending", "LogOff", "UserProfileDiskMounted".
    :type session_state: str or ~desktop_virtualization_api_client.models.SessionState
    :param active_directory_user_name: The active directory user name.
    :type active_directory_user_name: str
    :param create_time: The timestamp of the user session create.
    :type create_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'object_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'object_id': {'key': 'properties.objectId', 'type': 'str'},
        'user_principal_name': {'key': 'properties.userPrincipalName', 'type': 'str'},
        'application_type': {'key': 'properties.applicationType', 'type': 'str'},
        'session_state': {'key': 'properties.sessionState', 'type': 'str'},
        'active_directory_user_name': {'key': 'properties.activeDirectoryUserName', 'type': 'str'},
        'create_time': {'key': 'properties.createTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserSession, self).__init__(**kwargs)
        self.system_data = None
        self.object_id = None
        self.user_principal_name = kwargs.get('user_principal_name', None)
        self.application_type = kwargs.get('application_type', None)
        self.session_state = kwargs.get('session_state', None)
        self.active_directory_user_name = kwargs.get('active_directory_user_name', None)
        self.create_time = kwargs.get('create_time', None)


class UserSessionList(msrest.serialization.Model):
    """List of UserSession definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of UserSession definitions.
    :type value: list[~desktop_virtualization_api_client.models.UserSession]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UserSession]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserSessionList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class Workspace(ResourceModelWithAllowedPropertySet):
    """Represents a Workspace definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: The geo-location where the resource lives.
    :type location: str
    :param managed_by: The fully qualified resource ID of the resource that manages this resource.
     Indicates if this resource is managed by another Azure resource. If this is present, complete
     mode deployment will not delete the resource if it is removed from the template since it is
     managed by another resource.
    :type managed_by: str
    :param kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :type kind: str
    :ivar etag: The etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal etag convention.  Entity tags are used for
     comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in
     the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range
     (section 14.27) header fields.
    :vartype etag: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity:
    :type identity:
     ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetIdentity
    :param sku:
    :type sku: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetSku
    :param plan:
    :type plan: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetPlan
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    :ivar object_id: ObjectId of Workspace. (internal use).
    :vartype object_id: str
    :param description: Description of Workspace.
    :type description: str
    :param friendly_name: Friendly name of Workspace.
    :type friendly_name: str
    :param application_group_references: List of applicationGroup resource Ids.
    :type application_group_references: list[str]
    :ivar cloud_pc_resource: Is cloud pc resource.
    :vartype cloud_pc_resource: bool
    :param public_network_access: Enabled allows this resource to be accessed from both public and
     private networks, Disabled allows this resource to only be accessed via private endpoints.
     Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or
     ~desktop_virtualization_api_client.models.PublicNetworkAccess
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'pattern': r'^[-\w\._,\(\)]+$'},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'object_id': {'readonly': True},
        'cloud_pc_resource': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ResourceModelWithAllowedPropertySetIdentity'},
        'sku': {'key': 'sku', 'type': 'ResourceModelWithAllowedPropertySetSku'},
        'plan': {'key': 'plan', 'type': 'ResourceModelWithAllowedPropertySetPlan'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'object_id': {'key': 'properties.objectId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'application_group_references': {'key': 'properties.applicationGroupReferences', 'type': '[str]'},
        'cloud_pc_resource': {'key': 'properties.cloudPcResource', 'type': 'bool'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Workspace, self).__init__(**kwargs)
        self.system_data = None
        self.object_id = None
        self.description = kwargs.get('description', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.application_group_references = kwargs.get('application_group_references', None)
        self.cloud_pc_resource = None
        self.public_network_access = kwargs.get('public_network_access', None)


class WorkspaceList(msrest.serialization.Model):
    """List of Workspace definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of Workspace definitions.
    :type value: list[~desktop_virtualization_api_client.models.Workspace]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Workspace]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspaceList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class WorkspacePatch(msrest.serialization.Model):
    """Workspace properties that can be patched.

    :param tags: A set of tags. tags to be updated.
    :type tags: dict[str, str]
    :param description: Description of Workspace.
    :type description: str
    :param friendly_name: Friendly name of Workspace.
    :type friendly_name: str
    :param application_group_references: List of applicationGroup links.
    :type application_group_references: list[str]
    :param public_network_access: Enabled to allow this resource to be access from the public
     network. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or
     ~desktop_virtualization_api_client.models.PublicNetworkAccess
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'application_group_references': {'key': 'properties.applicationGroupReferences', 'type': '[str]'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspacePatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.description = kwargs.get('description', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.application_group_references = kwargs.get('application_group_references', None)
        self.public_network_access = kwargs.get('public_network_access', None)
