# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._desktop_virtualization_api_client_enums import *


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Application(Resource):
    """Schema for Application properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    :ivar object_id: ObjectId of Application. (internal use).
    :vartype object_id: str
    :param description: Description of Application.
    :type description: str
    :param friendly_name: Friendly name of Application.
    :type friendly_name: str
    :param file_path: Specifies a path for the executable file for the application.
    :type file_path: str
    :param msix_package_family_name: Specifies the package family name for MSIX applications.
    :type msix_package_family_name: str
    :param msix_package_application_id: Specifies the package application Id for MSIX applications.
    :type msix_package_application_id: str
    :param application_type: Resource Type of Application. Possible values include: "InBuilt",
     "MsixApplication".
    :type application_type: str or ~desktop_virtualization_api_client.models.RemoteApplicationType
    :param command_line_setting: Required. Specifies whether this published application can be
     launched with command line arguments provided by the client, command line arguments specified
     at publish time, or no command line arguments at all. Possible values include: "DoNotAllow",
     "Allow", "Require".
    :type command_line_setting: str or ~desktop_virtualization_api_client.models.CommandLineSetting
    :param command_line_arguments: Command Line Arguments for Application.
    :type command_line_arguments: str
    :param show_in_portal: Specifies whether to show the RemoteApp program in the RD Web Access
     server.
    :type show_in_portal: bool
    :param icon_path: Path to icon.
    :type icon_path: str
    :param icon_index: Index of the icon.
    :type icon_index: int
    :ivar icon_hash: Hash of the icon.
    :vartype icon_hash: str
    :ivar icon_content: the icon a 64 bit string as a byte array.
    :vartype icon_content: bytearray
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'object_id': {'readonly': True},
        'command_line_setting': {'required': True},
        'icon_hash': {'readonly': True},
        'icon_content': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'object_id': {'key': 'properties.objectId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'file_path': {'key': 'properties.filePath', 'type': 'str'},
        'msix_package_family_name': {'key': 'properties.msixPackageFamilyName', 'type': 'str'},
        'msix_package_application_id': {'key': 'properties.msixPackageApplicationId', 'type': 'str'},
        'application_type': {'key': 'properties.applicationType', 'type': 'str'},
        'command_line_setting': {'key': 'properties.commandLineSetting', 'type': 'str'},
        'command_line_arguments': {'key': 'properties.commandLineArguments', 'type': 'str'},
        'show_in_portal': {'key': 'properties.showInPortal', 'type': 'bool'},
        'icon_path': {'key': 'properties.iconPath', 'type': 'str'},
        'icon_index': {'key': 'properties.iconIndex', 'type': 'int'},
        'icon_hash': {'key': 'properties.iconHash', 'type': 'str'},
        'icon_content': {'key': 'properties.iconContent', 'type': 'bytearray'},
    }

    def __init__(
        self,
        *,
        command_line_setting: Union[str, "CommandLineSetting"],
        description: Optional[str] = None,
        friendly_name: Optional[str] = None,
        file_path: Optional[str] = None,
        msix_package_family_name: Optional[str] = None,
        msix_package_application_id: Optional[str] = None,
        application_type: Optional[Union[str, "RemoteApplicationType"]] = None,
        command_line_arguments: Optional[str] = None,
        show_in_portal: Optional[bool] = None,
        icon_path: Optional[str] = None,
        icon_index: Optional[int] = None,
        **kwargs
    ):
        super(Application, self).__init__(**kwargs)
        self.system_data = None
        self.object_id = None
        self.description = description
        self.friendly_name = friendly_name
        self.file_path = file_path
        self.msix_package_family_name = msix_package_family_name
        self.msix_package_application_id = msix_package_application_id
        self.application_type = application_type
        self.command_line_setting = command_line_setting
        self.command_line_arguments = command_line_arguments
        self.show_in_portal = show_in_portal
        self.icon_path = icon_path
        self.icon_index = icon_index
        self.icon_hash = None
        self.icon_content = None


class ResourceModelWithAllowedPropertySet(msrest.serialization.Model):
    """The resource model definition containing the full set of allowed properties for a resource. Except properties bag, there cannot be a top level property outside of this set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: The geo-location where the resource lives.
    :type location: str
    :param managed_by: The fully qualified resource ID of the resource that manages this resource.
     Indicates if this resource is managed by another Azure resource. If this is present, complete
     mode deployment will not delete the resource if it is removed from the template since it is
     managed by another resource.
    :type managed_by: str
    :param kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :type kind: str
    :ivar etag: The etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal etag convention.  Entity tags are used for
     comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in
     the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range
     (section 14.27) header fields.
    :vartype etag: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity:
    :type identity:
     ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetIdentity
    :param sku:
    :type sku: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetSku
    :param plan:
    :type plan: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetPlan
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'pattern': r'^[-\w\._,\(\)]+$'},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ResourceModelWithAllowedPropertySetIdentity'},
        'sku': {'key': 'sku', 'type': 'ResourceModelWithAllowedPropertySetSku'},
        'plan': {'key': 'plan', 'type': 'ResourceModelWithAllowedPropertySetPlan'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        managed_by: Optional[str] = None,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ResourceModelWithAllowedPropertySetIdentity"] = None,
        sku: Optional["ResourceModelWithAllowedPropertySetSku"] = None,
        plan: Optional["ResourceModelWithAllowedPropertySetPlan"] = None,
        **kwargs
    ):
        super(ResourceModelWithAllowedPropertySet, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.managed_by = managed_by
        self.kind = kind
        self.etag = None
        self.tags = tags
        self.identity = identity
        self.sku = sku
        self.plan = plan


class ApplicationGroup(ResourceModelWithAllowedPropertySet):
    """Represents a ApplicationGroup definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: The geo-location where the resource lives.
    :type location: str
    :param managed_by: The fully qualified resource ID of the resource that manages this resource.
     Indicates if this resource is managed by another Azure resource. If this is present, complete
     mode deployment will not delete the resource if it is removed from the template since it is
     managed by another resource.
    :type managed_by: str
    :param kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :type kind: str
    :ivar etag: The etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal etag convention.  Entity tags are used for
     comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in
     the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range
     (section 14.27) header fields.
    :vartype etag: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity:
    :type identity:
     ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetIdentity
    :param sku:
    :type sku: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetSku
    :param plan:
    :type plan: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetPlan
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    :ivar object_id: ObjectId of ApplicationGroup. (internal use).
    :vartype object_id: str
    :param description: Description of ApplicationGroup.
    :type description: str
    :param friendly_name: Friendly name of ApplicationGroup.
    :type friendly_name: str
    :param host_pool_arm_path: Required. HostPool arm path of ApplicationGroup.
    :type host_pool_arm_path: str
    :ivar workspace_arm_path: Workspace arm path of ApplicationGroup.
    :vartype workspace_arm_path: str
    :param application_group_type: Required. Resource Type of ApplicationGroup. Possible values
     include: "RemoteApp", "Desktop".
    :type application_group_type: str or
     ~desktop_virtualization_api_client.models.ApplicationGroupType
    :param migration_request: The registration info of HostPool.
    :type migration_request: ~desktop_virtualization_api_client.models.MigrationRequestProperties
    :ivar cloud_pc_resource: Is cloud pc resource.
    :vartype cloud_pc_resource: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'pattern': r'^[-\w\._,\(\)]+$'},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'object_id': {'readonly': True},
        'host_pool_arm_path': {'required': True},
        'workspace_arm_path': {'readonly': True},
        'application_group_type': {'required': True},
        'cloud_pc_resource': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ResourceModelWithAllowedPropertySetIdentity'},
        'sku': {'key': 'sku', 'type': 'ResourceModelWithAllowedPropertySetSku'},
        'plan': {'key': 'plan', 'type': 'ResourceModelWithAllowedPropertySetPlan'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'object_id': {'key': 'properties.objectId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'host_pool_arm_path': {'key': 'properties.hostPoolArmPath', 'type': 'str'},
        'workspace_arm_path': {'key': 'properties.workspaceArmPath', 'type': 'str'},
        'application_group_type': {'key': 'properties.applicationGroupType', 'type': 'str'},
        'migration_request': {'key': 'properties.migrationRequest', 'type': 'MigrationRequestProperties'},
        'cloud_pc_resource': {'key': 'properties.cloudPcResource', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        host_pool_arm_path: str,
        application_group_type: Union[str, "ApplicationGroupType"],
        location: Optional[str] = None,
        managed_by: Optional[str] = None,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ResourceModelWithAllowedPropertySetIdentity"] = None,
        sku: Optional["ResourceModelWithAllowedPropertySetSku"] = None,
        plan: Optional["ResourceModelWithAllowedPropertySetPlan"] = None,
        description: Optional[str] = None,
        friendly_name: Optional[str] = None,
        migration_request: Optional["MigrationRequestProperties"] = None,
        **kwargs
    ):
        super(ApplicationGroup, self).__init__(location=location, managed_by=managed_by, kind=kind, tags=tags, identity=identity, sku=sku, plan=plan, **kwargs)
        self.system_data = None
        self.object_id = None
        self.description = description
        self.friendly_name = friendly_name
        self.host_pool_arm_path = host_pool_arm_path
        self.workspace_arm_path = None
        self.application_group_type = application_group_type
        self.migration_request = migration_request
        self.cloud_pc_resource = None


class ApplicationGroupList(msrest.serialization.Model):
    """List of ApplicationGroup definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of ApplicationGroup definitions.
    :type value: list[~desktop_virtualization_api_client.models.ApplicationGroup]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ApplicationGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ApplicationGroup"]] = None,
        **kwargs
    ):
        super(ApplicationGroupList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ApplicationGroupPatch(Resource):
    """ApplicationGroup properties that can be patched.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. tags to be updated.
    :type tags: dict[str, str]
    :param description: Description of ApplicationGroup.
    :type description: str
    :param friendly_name: Friendly name of ApplicationGroup.
    :type friendly_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        friendly_name: Optional[str] = None,
        **kwargs
    ):
        super(ApplicationGroupPatch, self).__init__(**kwargs)
        self.tags = tags
        self.description = description
        self.friendly_name = friendly_name


class ApplicationList(msrest.serialization.Model):
    """List of Application definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of Application definitions.
    :type value: list[~desktop_virtualization_api_client.models.Application]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Application]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Application"]] = None,
        **kwargs
    ):
        super(ApplicationList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ApplicationPatch(msrest.serialization.Model):
    """Application properties that can be patched.

    :param tags: A set of tags. tags to be updated.
    :type tags: dict[str, str]
    :param description: Description of Application.
    :type description: str
    :param friendly_name: Friendly name of Application.
    :type friendly_name: str
    :param file_path: Specifies a path for the executable file for the application.
    :type file_path: str
    :param command_line_setting: Specifies whether this published application can be launched with
     command line arguments provided by the client, command line arguments specified at publish
     time, or no command line arguments at all. Possible values include: "DoNotAllow", "Allow",
     "Require".
    :type command_line_setting: str or ~desktop_virtualization_api_client.models.CommandLineSetting
    :param command_line_arguments: Command Line Arguments for Application.
    :type command_line_arguments: str
    :param show_in_portal: Specifies whether to show the RemoteApp program in the RD Web Access
     server.
    :type show_in_portal: bool
    :param icon_path: Path to icon.
    :type icon_path: str
    :param icon_index: Index of the icon.
    :type icon_index: int
    :param msix_package_family_name: Specifies the package family name for MSIX applications.
    :type msix_package_family_name: str
    :param msix_package_application_id: Specifies the package application Id for MSIX applications.
    :type msix_package_application_id: str
    :param application_type: Resource Type of Application. Possible values include: "InBuilt",
     "MsixApplication".
    :type application_type: str or ~desktop_virtualization_api_client.models.RemoteApplicationType
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'file_path': {'key': 'properties.filePath', 'type': 'str'},
        'command_line_setting': {'key': 'properties.commandLineSetting', 'type': 'str'},
        'command_line_arguments': {'key': 'properties.commandLineArguments', 'type': 'str'},
        'show_in_portal': {'key': 'properties.showInPortal', 'type': 'bool'},
        'icon_path': {'key': 'properties.iconPath', 'type': 'str'},
        'icon_index': {'key': 'properties.iconIndex', 'type': 'int'},
        'msix_package_family_name': {'key': 'properties.msixPackageFamilyName', 'type': 'str'},
        'msix_package_application_id': {'key': 'properties.msixPackageApplicationId', 'type': 'str'},
        'application_type': {'key': 'properties.applicationType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        friendly_name: Optional[str] = None,
        file_path: Optional[str] = None,
        command_line_setting: Optional[Union[str, "CommandLineSetting"]] = None,
        command_line_arguments: Optional[str] = None,
        show_in_portal: Optional[bool] = None,
        icon_path: Optional[str] = None,
        icon_index: Optional[int] = None,
        msix_package_family_name: Optional[str] = None,
        msix_package_application_id: Optional[str] = None,
        application_type: Optional[Union[str, "RemoteApplicationType"]] = None,
        **kwargs
    ):
        super(ApplicationPatch, self).__init__(**kwargs)
        self.tags = tags
        self.description = description
        self.friendly_name = friendly_name
        self.file_path = file_path
        self.command_line_setting = command_line_setting
        self.command_line_arguments = command_line_arguments
        self.show_in_portal = show_in_portal
        self.icon_path = icon_path
        self.icon_index = icon_index
        self.msix_package_family_name = msix_package_family_name
        self.msix_package_application_id = msix_package_application_id
        self.application_type = application_type


class CloudErrorProperties(msrest.serialization.Model):
    """Cloud error object properties.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(CloudErrorProperties, self).__init__(**kwargs)
        self.code = code
        self.message = message


class Desktop(Resource):
    """Schema for Desktop properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    :ivar object_id: ObjectId of Desktop. (internal use).
    :vartype object_id: str
    :param description: Description of Desktop.
    :type description: str
    :param friendly_name: Friendly name of Desktop.
    :type friendly_name: str
    :ivar icon_hash: Hash of the icon.
    :vartype icon_hash: str
    :ivar icon_content: The icon a 64 bit string as a byte array.
    :vartype icon_content: bytearray
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'object_id': {'readonly': True},
        'icon_hash': {'readonly': True},
        'icon_content': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'object_id': {'key': 'properties.objectId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'icon_hash': {'key': 'properties.iconHash', 'type': 'str'},
        'icon_content': {'key': 'properties.iconContent', 'type': 'bytearray'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        friendly_name: Optional[str] = None,
        **kwargs
    ):
        super(Desktop, self).__init__(**kwargs)
        self.system_data = None
        self.object_id = None
        self.description = description
        self.friendly_name = friendly_name
        self.icon_hash = None
        self.icon_content = None


class DesktopList(msrest.serialization.Model):
    """List of Desktop definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of Desktop definitions.
    :type value: list[~desktop_virtualization_api_client.models.Desktop]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Desktop]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Desktop"]] = None,
        **kwargs
    ):
        super(DesktopList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class DesktopPatch(msrest.serialization.Model):
    """Desktop properties that can be patched.

    :param tags: A set of tags. tags to be updated.
    :type tags: dict[str, str]
    :param description: Description of Desktop.
    :type description: str
    :param friendly_name: Friendly name of Desktop.
    :type friendly_name: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        friendly_name: Optional[str] = None,
        **kwargs
    ):
        super(DesktopPatch, self).__init__(**kwargs)
        self.tags = tags
        self.description = description
        self.friendly_name = friendly_name


class ExpandMsixImage(Resource):
    """Represents the definition of contents retrieved after expanding the MSIX Image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param package_alias: Alias of MSIX Package.
    :type package_alias: str
    :param image_path: VHD/CIM image path on Network Share.
    :type image_path: str
    :param package_name: Package Name from appxmanifest.xml.
    :type package_name: str
    :param package_family_name: Package Family Name from appxmanifest.xml. Contains Package Name
     and Publisher name.
    :type package_family_name: str
    :param package_full_name: Package Full Name from appxmanifest.xml.
    :type package_full_name: str
    :param display_name: User friendly Name to be displayed in the portal.
    :type display_name: str
    :param package_relative_path: Relative Path to the package inside the image.
    :type package_relative_path: str
    :param is_regular_registration: Specifies how to register Package in feed.
    :type is_regular_registration: bool
    :param is_active: Make this version of the package the active one across the hostpool.
    :type is_active: bool
    :param package_dependencies: List of package dependencies.
    :type package_dependencies:
     list[~desktop_virtualization_api_client.models.MsixPackageDependencies]
    :param version: Package Version found in the appxmanifest.xml.
    :type version: str
    :param last_updated: Date Package was last updated, found in the appxmanifest.xml.
    :type last_updated: ~datetime.datetime
    :param package_applications: List of package applications.
    :type package_applications:
     list[~desktop_virtualization_api_client.models.MsixPackageApplications]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'package_alias': {'key': 'properties.packageAlias', 'type': 'str'},
        'image_path': {'key': 'properties.imagePath', 'type': 'str'},
        'package_name': {'key': 'properties.packageName', 'type': 'str'},
        'package_family_name': {'key': 'properties.packageFamilyName', 'type': 'str'},
        'package_full_name': {'key': 'properties.packageFullName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'package_relative_path': {'key': 'properties.packageRelativePath', 'type': 'str'},
        'is_regular_registration': {'key': 'properties.isRegularRegistration', 'type': 'bool'},
        'is_active': {'key': 'properties.isActive', 'type': 'bool'},
        'package_dependencies': {'key': 'properties.packageDependencies', 'type': '[MsixPackageDependencies]'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'last_updated': {'key': 'properties.lastUpdated', 'type': 'iso-8601'},
        'package_applications': {'key': 'properties.packageApplications', 'type': '[MsixPackageApplications]'},
    }

    def __init__(
        self,
        *,
        package_alias: Optional[str] = None,
        image_path: Optional[str] = None,
        package_name: Optional[str] = None,
        package_family_name: Optional[str] = None,
        package_full_name: Optional[str] = None,
        display_name: Optional[str] = None,
        package_relative_path: Optional[str] = None,
        is_regular_registration: Optional[bool] = None,
        is_active: Optional[bool] = None,
        package_dependencies: Optional[List["MsixPackageDependencies"]] = None,
        version: Optional[str] = None,
        last_updated: Optional[datetime.datetime] = None,
        package_applications: Optional[List["MsixPackageApplications"]] = None,
        **kwargs
    ):
        super(ExpandMsixImage, self).__init__(**kwargs)
        self.package_alias = package_alias
        self.image_path = image_path
        self.package_name = package_name
        self.package_family_name = package_family_name
        self.package_full_name = package_full_name
        self.display_name = display_name
        self.package_relative_path = package_relative_path
        self.is_regular_registration = is_regular_registration
        self.is_active = is_active
        self.package_dependencies = package_dependencies
        self.version = version
        self.last_updated = last_updated
        self.package_applications = package_applications


class ExpandMsixImageList(msrest.serialization.Model):
    """List of MSIX package properties retrieved from MSIX Image expansion.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of MSIX package properties from give MSIX Image.
    :type value: list[~desktop_virtualization_api_client.models.ExpandMsixImage]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExpandMsixImage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ExpandMsixImage"]] = None,
        **kwargs
    ):
        super(ExpandMsixImageList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class HostPool(ResourceModelWithAllowedPropertySet):
    """Represents a HostPool definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: The geo-location where the resource lives.
    :type location: str
    :param managed_by: The fully qualified resource ID of the resource that manages this resource.
     Indicates if this resource is managed by another Azure resource. If this is present, complete
     mode deployment will not delete the resource if it is removed from the template since it is
     managed by another resource.
    :type managed_by: str
    :param kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :type kind: str
    :ivar etag: The etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal etag convention.  Entity tags are used for
     comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in
     the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range
     (section 14.27) header fields.
    :vartype etag: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity:
    :type identity:
     ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetIdentity
    :param sku:
    :type sku: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetSku
    :param plan:
    :type plan: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetPlan
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    :ivar object_id: ObjectId of HostPool. (internal use).
    :vartype object_id: str
    :param friendly_name: Friendly name of HostPool.
    :type friendly_name: str
    :param description: Description of HostPool.
    :type description: str
    :param host_pool_type: Required. HostPool type for desktop. Possible values include:
     "Personal", "Pooled", "BYODesktop".
    :type host_pool_type: str or ~desktop_virtualization_api_client.models.HostPoolType
    :param personal_desktop_assignment_type: PersonalDesktopAssignment type for HostPool. Possible
     values include: "Automatic", "Direct".
    :type personal_desktop_assignment_type: str or
     ~desktop_virtualization_api_client.models.PersonalDesktopAssignmentType
    :param custom_rdp_property: Custom rdp property of HostPool.
    :type custom_rdp_property: str
    :param max_session_limit: The max session limit of HostPool.
    :type max_session_limit: int
    :param load_balancer_type: Required. The type of the load balancer. Possible values include:
     "BreadthFirst", "DepthFirst", "Persistent".
    :type load_balancer_type: str or ~desktop_virtualization_api_client.models.LoadBalancerType
    :param ring: The ring number of HostPool.
    :type ring: int
    :param validation_environment: Is validation environment.
    :type validation_environment: bool
    :param registration_info: The registration info of HostPool.
    :type registration_info: ~desktop_virtualization_api_client.models.RegistrationInfo
    :param vm_template: VM template for sessionhosts configuration within hostpool.
    :type vm_template: str
    :ivar application_group_references: List of applicationGroup links.
    :vartype application_group_references: list[str]
    :param ssoadfs_authority: URL to customer ADFS server for signing WVD SSO certificates.
    :type ssoadfs_authority: str
    :param sso_client_id: ClientId for the registered Relying Party used to issue WVD SSO
     certificates.
    :type sso_client_id: str
    :param sso_client_secret_key_vault_path: Path to Azure KeyVault storing the secret used for
     communication to ADFS.
    :type sso_client_secret_key_vault_path: str
    :param sso_secret_type: The type of single sign on Secret Type. Possible values include:
     "SharedKey", "Certificate", "SharedKeyInKeyVault", "CertificateInKeyVault".
    :type sso_secret_type: str or ~desktop_virtualization_api_client.models.SSOSecretType
    :param preferred_app_group_type: Required. The type of preferred application group type,
     default to Desktop Application Group. Possible values include: "None", "Desktop",
     "RailApplications".
    :type preferred_app_group_type: str or
     ~desktop_virtualization_api_client.models.PreferredAppGroupType
    :param start_vm_on_connect: The flag to turn on/off StartVMOnConnect feature.
    :type start_vm_on_connect: bool
    :param migration_request: The registration info of HostPool.
    :type migration_request: ~desktop_virtualization_api_client.models.MigrationRequestProperties
    :ivar cloud_pc_resource: Is cloud pc resource.
    :vartype cloud_pc_resource: bool
    :param public_network_access: Enabled allows this resource to be accessed from both public and
     private networks, Disabled allows this resource to only be accessed via private endpoints.
     Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or
     ~desktop_virtualization_api_client.models.PublicNetworkAccess
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'pattern': r'^[-\w\._,\(\)]+$'},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'object_id': {'readonly': True},
        'host_pool_type': {'required': True},
        'load_balancer_type': {'required': True},
        'application_group_references': {'readonly': True},
        'preferred_app_group_type': {'required': True},
        'cloud_pc_resource': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ResourceModelWithAllowedPropertySetIdentity'},
        'sku': {'key': 'sku', 'type': 'ResourceModelWithAllowedPropertySetSku'},
        'plan': {'key': 'plan', 'type': 'ResourceModelWithAllowedPropertySetPlan'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'object_id': {'key': 'properties.objectId', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'host_pool_type': {'key': 'properties.hostPoolType', 'type': 'str'},
        'personal_desktop_assignment_type': {'key': 'properties.personalDesktopAssignmentType', 'type': 'str'},
        'custom_rdp_property': {'key': 'properties.customRdpProperty', 'type': 'str'},
        'max_session_limit': {'key': 'properties.maxSessionLimit', 'type': 'int'},
        'load_balancer_type': {'key': 'properties.loadBalancerType', 'type': 'str'},
        'ring': {'key': 'properties.ring', 'type': 'int'},
        'validation_environment': {'key': 'properties.validationEnvironment', 'type': 'bool'},
        'registration_info': {'key': 'properties.registrationInfo', 'type': 'RegistrationInfo'},
        'vm_template': {'key': 'properties.vmTemplate', 'type': 'str'},
        'application_group_references': {'key': 'properties.applicationGroupReferences', 'type': '[str]'},
        'ssoadfs_authority': {'key': 'properties.ssoadfsAuthority', 'type': 'str'},
        'sso_client_id': {'key': 'properties.ssoClientId', 'type': 'str'},
        'sso_client_secret_key_vault_path': {'key': 'properties.ssoClientSecretKeyVaultPath', 'type': 'str'},
        'sso_secret_type': {'key': 'properties.ssoSecretType', 'type': 'str'},
        'preferred_app_group_type': {'key': 'properties.preferredAppGroupType', 'type': 'str'},
        'start_vm_on_connect': {'key': 'properties.startVMOnConnect', 'type': 'bool'},
        'migration_request': {'key': 'properties.migrationRequest', 'type': 'MigrationRequestProperties'},
        'cloud_pc_resource': {'key': 'properties.cloudPcResource', 'type': 'bool'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_pool_type: Union[str, "HostPoolType"],
        load_balancer_type: Union[str, "LoadBalancerType"],
        preferred_app_group_type: Union[str, "PreferredAppGroupType"],
        location: Optional[str] = None,
        managed_by: Optional[str] = None,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ResourceModelWithAllowedPropertySetIdentity"] = None,
        sku: Optional["ResourceModelWithAllowedPropertySetSku"] = None,
        plan: Optional["ResourceModelWithAllowedPropertySetPlan"] = None,
        friendly_name: Optional[str] = None,
        description: Optional[str] = None,
        personal_desktop_assignment_type: Optional[Union[str, "PersonalDesktopAssignmentType"]] = None,
        custom_rdp_property: Optional[str] = None,
        max_session_limit: Optional[int] = None,
        ring: Optional[int] = None,
        validation_environment: Optional[bool] = None,
        registration_info: Optional["RegistrationInfo"] = None,
        vm_template: Optional[str] = None,
        ssoadfs_authority: Optional[str] = None,
        sso_client_id: Optional[str] = None,
        sso_client_secret_key_vault_path: Optional[str] = None,
        sso_secret_type: Optional[Union[str, "SSOSecretType"]] = None,
        start_vm_on_connect: Optional[bool] = None,
        migration_request: Optional["MigrationRequestProperties"] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        **kwargs
    ):
        super(HostPool, self).__init__(location=location, managed_by=managed_by, kind=kind, tags=tags, identity=identity, sku=sku, plan=plan, **kwargs)
        self.system_data = None
        self.object_id = None
        self.friendly_name = friendly_name
        self.description = description
        self.host_pool_type = host_pool_type
        self.personal_desktop_assignment_type = personal_desktop_assignment_type
        self.custom_rdp_property = custom_rdp_property
        self.max_session_limit = max_session_limit
        self.load_balancer_type = load_balancer_type
        self.ring = ring
        self.validation_environment = validation_environment
        self.registration_info = registration_info
        self.vm_template = vm_template
        self.application_group_references = None
        self.ssoadfs_authority = ssoadfs_authority
        self.sso_client_id = sso_client_id
        self.sso_client_secret_key_vault_path = sso_client_secret_key_vault_path
        self.sso_secret_type = sso_secret_type
        self.preferred_app_group_type = preferred_app_group_type
        self.start_vm_on_connect = start_vm_on_connect
        self.migration_request = migration_request
        self.cloud_pc_resource = None
        self.public_network_access = public_network_access


class HostPoolList(msrest.serialization.Model):
    """List of HostPool definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of HostPool definitions.
    :type value: list[~desktop_virtualization_api_client.models.HostPool]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HostPool]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["HostPool"]] = None,
        **kwargs
    ):
        super(HostPoolList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class HostPoolPatch(Resource):
    """HostPool properties that can be patched.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. tags to be updated.
    :type tags: dict[str, str]
    :param friendly_name: Friendly name of HostPool.
    :type friendly_name: str
    :param description: Description of HostPool.
    :type description: str
    :param custom_rdp_property: Custom rdp property of HostPool.
    :type custom_rdp_property: str
    :param max_session_limit: The max session limit of HostPool.
    :type max_session_limit: int
    :param personal_desktop_assignment_type: PersonalDesktopAssignment type for HostPool. Possible
     values include: "Automatic", "Direct".
    :type personal_desktop_assignment_type: str or
     ~desktop_virtualization_api_client.models.PersonalDesktopAssignmentType
    :param load_balancer_type: The type of the load balancer. Possible values include:
     "BreadthFirst", "DepthFirst", "Persistent".
    :type load_balancer_type: str or ~desktop_virtualization_api_client.models.LoadBalancerType
    :param ring: The ring number of HostPool.
    :type ring: int
    :param validation_environment: Is validation environment.
    :type validation_environment: bool
    :param registration_info: The registration info of HostPool.
    :type registration_info: ~desktop_virtualization_api_client.models.RegistrationInfoPatch
    :param vm_template: VM template for sessionhosts configuration within hostpool.
    :type vm_template: str
    :param ssoadfs_authority: URL to customer ADFS server for signing WVD SSO certificates.
    :type ssoadfs_authority: str
    :param sso_client_id: ClientId for the registered Relying Party used to issue WVD SSO
     certificates.
    :type sso_client_id: str
    :param sso_client_secret_key_vault_path: Path to Azure KeyVault storing the secret used for
     communication to ADFS.
    :type sso_client_secret_key_vault_path: str
    :param sso_secret_type: The type of single sign on Secret Type. Possible values include:
     "SharedKey", "Certificate", "SharedKeyInKeyVault", "CertificateInKeyVault".
    :type sso_secret_type: str or ~desktop_virtualization_api_client.models.SSOSecretType
    :param preferred_app_group_type: The type of preferred application group type, default to
     Desktop Application Group. Possible values include: "None", "Desktop", "RailApplications".
    :type preferred_app_group_type: str or
     ~desktop_virtualization_api_client.models.PreferredAppGroupType
    :param start_vm_on_connect: The flag to turn on/off StartVMOnConnect feature.
    :type start_vm_on_connect: bool
    :param public_network_access: Enabled to allow this resource to be access from the public
     network. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or
     ~desktop_virtualization_api_client.models.PublicNetworkAccess
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'custom_rdp_property': {'key': 'properties.customRdpProperty', 'type': 'str'},
        'max_session_limit': {'key': 'properties.maxSessionLimit', 'type': 'int'},
        'personal_desktop_assignment_type': {'key': 'properties.personalDesktopAssignmentType', 'type': 'str'},
        'load_balancer_type': {'key': 'properties.loadBalancerType', 'type': 'str'},
        'ring': {'key': 'properties.ring', 'type': 'int'},
        'validation_environment': {'key': 'properties.validationEnvironment', 'type': 'bool'},
        'registration_info': {'key': 'properties.registrationInfo', 'type': 'RegistrationInfoPatch'},
        'vm_template': {'key': 'properties.vmTemplate', 'type': 'str'},
        'ssoadfs_authority': {'key': 'properties.ssoadfsAuthority', 'type': 'str'},
        'sso_client_id': {'key': 'properties.ssoClientId', 'type': 'str'},
        'sso_client_secret_key_vault_path': {'key': 'properties.ssoClientSecretKeyVaultPath', 'type': 'str'},
        'sso_secret_type': {'key': 'properties.ssoSecretType', 'type': 'str'},
        'preferred_app_group_type': {'key': 'properties.preferredAppGroupType', 'type': 'str'},
        'start_vm_on_connect': {'key': 'properties.startVMOnConnect', 'type': 'bool'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        friendly_name: Optional[str] = None,
        description: Optional[str] = None,
        custom_rdp_property: Optional[str] = None,
        max_session_limit: Optional[int] = None,
        personal_desktop_assignment_type: Optional[Union[str, "PersonalDesktopAssignmentType"]] = None,
        load_balancer_type: Optional[Union[str, "LoadBalancerType"]] = None,
        ring: Optional[int] = None,
        validation_environment: Optional[bool] = None,
        registration_info: Optional["RegistrationInfoPatch"] = None,
        vm_template: Optional[str] = None,
        ssoadfs_authority: Optional[str] = None,
        sso_client_id: Optional[str] = None,
        sso_client_secret_key_vault_path: Optional[str] = None,
        sso_secret_type: Optional[Union[str, "SSOSecretType"]] = None,
        preferred_app_group_type: Optional[Union[str, "PreferredAppGroupType"]] = None,
        start_vm_on_connect: Optional[bool] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        **kwargs
    ):
        super(HostPoolPatch, self).__init__(**kwargs)
        self.tags = tags
        self.friendly_name = friendly_name
        self.description = description
        self.custom_rdp_property = custom_rdp_property
        self.max_session_limit = max_session_limit
        self.personal_desktop_assignment_type = personal_desktop_assignment_type
        self.load_balancer_type = load_balancer_type
        self.ring = ring
        self.validation_environment = validation_environment
        self.registration_info = registration_info
        self.vm_template = vm_template
        self.ssoadfs_authority = ssoadfs_authority
        self.sso_client_id = sso_client_id
        self.sso_client_secret_key_vault_path = sso_client_secret_key_vault_path
        self.sso_secret_type = sso_secret_type
        self.preferred_app_group_type = preferred_app_group_type
        self.start_vm_on_connect = start_vm_on_connect
        self.public_network_access = public_network_access


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :param type: The identity type. The only acceptable values to pass in are None and
     "SystemAssigned". The default value is None.
    :type type: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class LogSpecification(msrest.serialization.Model):
    """Specifications of the Log for Azure Monitoring.

    :param name: Name of the log.
    :type name: str
    :param display_name: Localized friendly display name of the log.
    :type display_name: str
    :param blob_duration: Blob duration of the log.
    :type blob_duration: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs
    ):
        super(LogSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class MigrationRequestProperties(msrest.serialization.Model):
    """Properties for arm migration.

    :param operation: The type of operation for migration. Possible values include: "Start",
     "Revoke", "Complete", "Hide", "Unhide".
    :type operation: str or ~desktop_virtualization_api_client.models.Operation
    :param migration_path: The path to the legacy object to migrate.
    :type migration_path: str
    """

    _attribute_map = {
        'operation': {'key': 'operation', 'type': 'str'},
        'migration_path': {'key': 'migrationPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        operation: Optional[Union[str, "Operation"]] = None,
        migration_path: Optional[str] = None,
        **kwargs
    ):
        super(MigrationRequestProperties, self).__init__(**kwargs)
        self.operation = operation
        self.migration_path = migration_path


class MSIXImageURI(msrest.serialization.Model):
    """Represents URI referring to MSIX Image.

    :param uri: URI to Image.
    :type uri: str
    """

    _attribute_map = {
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: Optional[str] = None,
        **kwargs
    ):
        super(MSIXImageURI, self).__init__(**kwargs)
        self.uri = uri


class MSIXPackage(Resource):
    """Schema for MSIX Package properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    :param image_path: VHD/CIM image path on Network Share.
    :type image_path: str
    :param package_name: Package Name from appxmanifest.xml.
    :type package_name: str
    :param package_family_name: Package Family Name from appxmanifest.xml. Contains Package Name
     and Publisher name.
    :type package_family_name: str
    :param display_name: User friendly Name to be displayed in the portal.
    :type display_name: str
    :param package_relative_path: Relative Path to the package inside the image.
    :type package_relative_path: str
    :param is_regular_registration: Specifies how to register Package in feed.
    :type is_regular_registration: bool
    :param is_active: Make this version of the package the active one across the hostpool.
    :type is_active: bool
    :param package_dependencies: List of package dependencies.
    :type package_dependencies:
     list[~desktop_virtualization_api_client.models.MsixPackageDependencies]
    :param version: Package Version found in the appxmanifest.xml.
    :type version: str
    :param last_updated: Date Package was last updated, found in the appxmanifest.xml.
    :type last_updated: ~datetime.datetime
    :param package_applications: List of package applications.
    :type package_applications:
     list[~desktop_virtualization_api_client.models.MsixPackageApplications]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'image_path': {'key': 'properties.imagePath', 'type': 'str'},
        'package_name': {'key': 'properties.packageName', 'type': 'str'},
        'package_family_name': {'key': 'properties.packageFamilyName', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'package_relative_path': {'key': 'properties.packageRelativePath', 'type': 'str'},
        'is_regular_registration': {'key': 'properties.isRegularRegistration', 'type': 'bool'},
        'is_active': {'key': 'properties.isActive', 'type': 'bool'},
        'package_dependencies': {'key': 'properties.packageDependencies', 'type': '[MsixPackageDependencies]'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'last_updated': {'key': 'properties.lastUpdated', 'type': 'iso-8601'},
        'package_applications': {'key': 'properties.packageApplications', 'type': '[MsixPackageApplications]'},
    }

    def __init__(
        self,
        *,
        image_path: Optional[str] = None,
        package_name: Optional[str] = None,
        package_family_name: Optional[str] = None,
        display_name: Optional[str] = None,
        package_relative_path: Optional[str] = None,
        is_regular_registration: Optional[bool] = None,
        is_active: Optional[bool] = None,
        package_dependencies: Optional[List["MsixPackageDependencies"]] = None,
        version: Optional[str] = None,
        last_updated: Optional[datetime.datetime] = None,
        package_applications: Optional[List["MsixPackageApplications"]] = None,
        **kwargs
    ):
        super(MSIXPackage, self).__init__(**kwargs)
        self.system_data = None
        self.image_path = image_path
        self.package_name = package_name
        self.package_family_name = package_family_name
        self.display_name = display_name
        self.package_relative_path = package_relative_path
        self.is_regular_registration = is_regular_registration
        self.is_active = is_active
        self.package_dependencies = package_dependencies
        self.version = version
        self.last_updated = last_updated
        self.package_applications = package_applications


class MsixPackageApplications(msrest.serialization.Model):
    """Schema for MSIX Package Application properties.

    :param app_id: Package Application Id, found in appxmanifest.xml.
    :type app_id: str
    :param description: Description of Package Application.
    :type description: str
    :param app_user_model_id: Used to activate Package Application. Consists of Package Name and
     ApplicationID. Found in appxmanifest.xml.
    :type app_user_model_id: str
    :param friendly_name: User friendly name.
    :type friendly_name: str
    :param icon_image_name: User friendly name.
    :type icon_image_name: str
    :param raw_icon: the icon a 64 bit string as a byte array.
    :type raw_icon: bytearray
    :param raw_png: the icon a 64 bit string as a byte array.
    :type raw_png: bytearray
    """

    _attribute_map = {
        'app_id': {'key': 'appId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'app_user_model_id': {'key': 'appUserModelID', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'icon_image_name': {'key': 'iconImageName', 'type': 'str'},
        'raw_icon': {'key': 'rawIcon', 'type': 'bytearray'},
        'raw_png': {'key': 'rawPng', 'type': 'bytearray'},
    }

    def __init__(
        self,
        *,
        app_id: Optional[str] = None,
        description: Optional[str] = None,
        app_user_model_id: Optional[str] = None,
        friendly_name: Optional[str] = None,
        icon_image_name: Optional[str] = None,
        raw_icon: Optional[bytearray] = None,
        raw_png: Optional[bytearray] = None,
        **kwargs
    ):
        super(MsixPackageApplications, self).__init__(**kwargs)
        self.app_id = app_id
        self.description = description
        self.app_user_model_id = app_user_model_id
        self.friendly_name = friendly_name
        self.icon_image_name = icon_image_name
        self.raw_icon = raw_icon
        self.raw_png = raw_png


class MsixPackageDependencies(msrest.serialization.Model):
    """Schema for MSIX Package Dependencies properties.

    :param dependency_name: Name of package dependency.
    :type dependency_name: str
    :param publisher: Name of dependency publisher.
    :type publisher: str
    :param min_version: Dependency version required.
    :type min_version: str
    """

    _attribute_map = {
        'dependency_name': {'key': 'dependencyName', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'min_version': {'key': 'minVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        dependency_name: Optional[str] = None,
        publisher: Optional[str] = None,
        min_version: Optional[str] = None,
        **kwargs
    ):
        super(MsixPackageDependencies, self).__init__(**kwargs)
        self.dependency_name = dependency_name
        self.publisher = publisher
        self.min_version = min_version


class MSIXPackageList(msrest.serialization.Model):
    """List of MSIX Package definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of MSIX Package definitions.
    :type value: list[~desktop_virtualization_api_client.models.MSIXPackage]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MSIXPackage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["MSIXPackage"]] = None,
        **kwargs
    ):
        super(MSIXPackageList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class MSIXPackagePatch(Resource):
    """MSIX Package properties that can be patched.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param is_active: Set a version of the package to be active across hostpool.
    :type is_active: bool
    :param is_regular_registration: Set Registration mode. Regular or Delayed.
    :type is_regular_registration: bool
    :param display_name: Display name for MSIX Package.
    :type display_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_active': {'key': 'properties.isActive', 'type': 'bool'},
        'is_regular_registration': {'key': 'properties.isRegularRegistration', 'type': 'bool'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        is_active: Optional[bool] = None,
        is_regular_registration: Optional[bool] = None,
        display_name: Optional[str] = None,
        **kwargs
    ):
        super(MSIXPackagePatch, self).__init__(**kwargs)
        self.is_active = is_active
        self.is_regular_registration = is_regular_registration
        self.display_name = display_name


class OperationProperties(msrest.serialization.Model):
    """Properties of the operation.

    :param service_specification: Service specification payload.
    :type service_specification: ~desktop_virtualization_api_client.models.ServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        *,
        service_specification: Optional["ServiceSpecification"] = None,
        **kwargs
    ):
        super(OperationProperties, self).__init__(**kwargs)
        self.service_specification = service_specification


class Plan(msrest.serialization.Model):
    """Plan for the resource.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. A user defined name of the 3rd Party Artifact that is being procured.
    :type name: str
    :param publisher: Required. The publisher of the 3rd Party Artifact that is being bought. E.g.
     NewRelic.
    :type publisher: str
    :param product: Required. The 3rd Party artifact that is being procured. E.g. NewRelic. Product
     maps to the OfferID specified for the artifact at the time of Data Market onboarding.
    :type product: str
    :param promotion_code: A publisher provided promotion code as provisioned in Data Market for
     the said product/artifact.
    :type promotion_code: str
    :param version: The version of the desired product/artifact.
    :type version: str
    """

    _validation = {
        'name': {'required': True},
        'publisher': {'required': True},
        'product': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
        'promotion_code': {'key': 'promotionCode', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        publisher: str,
        product: str,
        promotion_code: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        super(Plan, self).__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code
        self.version = version


class PrivateEndpoint(msrest.serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param private_endpoint: The resource of private end point.
    :type private_endpoint: ~desktop_virtualization_api_client.models.PrivateEndpoint
    :param private_link_service_connection_state: A collection of information about the state of
     the connection between service consumer and provider.
    :type private_link_service_connection_state:
     ~desktop_virtualization_api_client.models.PrivateLinkServiceConnectionState
    :param provisioning_state: The provisioning state of the private endpoint connection resource.
     Possible values include: "Succeeded", "Creating", "Deleting", "Failed".
    :type provisioning_state: str or
     ~desktop_virtualization_api_client.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionState"] = None,
        provisioning_state: Optional[Union[str, "PrivateEndpointConnectionProvisioningState"]] = None,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class PrivateEndpointConnectionListResultWithSystemData(msrest.serialization.Model):
    """List of private endpoint connection associated with the specified storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: Array of private endpoint connections.
    :type value:
     list[~desktop_virtualization_api_client.models.PrivateEndpointConnectionWithSystemData]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnectionWithSystemData]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateEndpointConnectionWithSystemData"]] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResultWithSystemData, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PrivateEndpointConnectionWithSystemData(PrivateEndpointConnection):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param private_endpoint: The resource of private end point.
    :type private_endpoint: ~desktop_virtualization_api_client.models.PrivateEndpoint
    :param private_link_service_connection_state: A collection of information about the state of
     the connection between service consumer and provider.
    :type private_link_service_connection_state:
     ~desktop_virtualization_api_client.models.PrivateLinkServiceConnectionState
    :param provisioning_state: The provisioning state of the private endpoint connection resource.
     Possible values include: "Succeeded", "Creating", "Deleting", "Failed".
    :type provisioning_state: str or
     ~desktop_virtualization_api_client.models.PrivateEndpointConnectionProvisioningState
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionState"] = None,
        provisioning_state: Optional[Union[str, "PrivateEndpointConnectionProvisioningState"]] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionWithSystemData, self).__init__(private_endpoint=private_endpoint, private_link_service_connection_state=private_link_service_connection_state, provisioning_state=provisioning_state, **kwargs)
        self.system_data = None


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :param required_zone_names: The private link resource Private link DNS zone name.
    :type required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        required_zone_names: Optional[List[str]] = None,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: Array of private link resources.
    :type value: list[~desktop_virtualization_api_client.models.PrivateLinkResource]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateLinkResource"]] = None,
        **kwargs
    ):
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :param status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Possible values include: "Pending", "Approved", "Rejected".
    :type status: str or
     ~desktop_virtualization_api_client.models.PrivateEndpointServiceConnectionStatus
    :param description: The reason for approval/rejection of the connection.
    :type description: str
    :param actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :type actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class RegistrationInfo(msrest.serialization.Model):
    """Represents a RegistrationInfo definition.

    :param expiration_time: Expiration time of registration token.
    :type expiration_time: ~datetime.datetime
    :param token: The registration token base64 encoded string.
    :type token: str
    :param registration_token_operation: The type of resetting the token. Possible values include:
     "Delete", "None", "Update".
    :type registration_token_operation: str or
     ~desktop_virtualization_api_client.models.RegistrationTokenOperation
    """

    _attribute_map = {
        'expiration_time': {'key': 'expirationTime', 'type': 'iso-8601'},
        'token': {'key': 'token', 'type': 'str'},
        'registration_token_operation': {'key': 'registrationTokenOperation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        expiration_time: Optional[datetime.datetime] = None,
        token: Optional[str] = None,
        registration_token_operation: Optional[Union[str, "RegistrationTokenOperation"]] = None,
        **kwargs
    ):
        super(RegistrationInfo, self).__init__(**kwargs)
        self.expiration_time = expiration_time
        self.token = token
        self.registration_token_operation = registration_token_operation


class RegistrationInfoPatch(msrest.serialization.Model):
    """Represents a RegistrationInfo definition.

    :param expiration_time: Expiration time of registration token.
    :type expiration_time: ~datetime.datetime
    :param registration_token_operation: The type of resetting the token. Possible values include:
     "Delete", "None", "Update".
    :type registration_token_operation: str or
     ~desktop_virtualization_api_client.models.RegistrationTokenOperation
    """

    _attribute_map = {
        'expiration_time': {'key': 'expirationTime', 'type': 'iso-8601'},
        'registration_token_operation': {'key': 'registrationTokenOperation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        expiration_time: Optional[datetime.datetime] = None,
        registration_token_operation: Optional[Union[str, "RegistrationTokenOperation"]] = None,
        **kwargs
    ):
        super(RegistrationInfoPatch, self).__init__(**kwargs)
        self.expiration_time = expiration_time
        self.registration_token_operation = registration_token_operation


class ResourceModelWithAllowedPropertySetIdentity(Identity):
    """ResourceModelWithAllowedPropertySetIdentity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :param type: The identity type. The only acceptable values to pass in are None and
     "SystemAssigned". The default value is None.
    :type type: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        **kwargs
    ):
        super(ResourceModelWithAllowedPropertySetIdentity, self).__init__(type=type, **kwargs)


class ResourceModelWithAllowedPropertySetPlan(Plan):
    """ResourceModelWithAllowedPropertySetPlan.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. A user defined name of the 3rd Party Artifact that is being procured.
    :type name: str
    :param publisher: Required. The publisher of the 3rd Party Artifact that is being bought. E.g.
     NewRelic.
    :type publisher: str
    :param product: Required. The 3rd Party artifact that is being procured. E.g. NewRelic. Product
     maps to the OfferID specified for the artifact at the time of Data Market onboarding.
    :type product: str
    :param promotion_code: A publisher provided promotion code as provisioned in Data Market for
     the said product/artifact.
    :type promotion_code: str
    :param version: The version of the desired product/artifact.
    :type version: str
    """

    _validation = {
        'name': {'required': True},
        'publisher': {'required': True},
        'product': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
        'promotion_code': {'key': 'promotionCode', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        publisher: str,
        product: str,
        promotion_code: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        super(ResourceModelWithAllowedPropertySetPlan, self).__init__(name=name, publisher=publisher, product=product, promotion_code=promotion_code, version=version, **kwargs)


class Sku(msrest.serialization.Model):
    """The resource model definition representing SKU.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the SKU. Ex - P3. It is typically a letter+number code.
    :type name: str
    :param tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
     "Standard", "Premium".
    :type tier: str or ~desktop_virtualization_api_client.models.SkuTier
    :param size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :type size: str
    :param family: If the service has different generations of hardware, for the same SKU, then
     that can be captured here.
    :type family: str
    :param capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        tier: Optional[Union[str, "SkuTier"]] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity


class ResourceModelWithAllowedPropertySetSku(Sku):
    """ResourceModelWithAllowedPropertySetSku.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the SKU. Ex - P3. It is typically a letter+number code.
    :type name: str
    :param tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Possible values include: "Free", "Basic",
     "Standard", "Premium".
    :type tier: str or ~desktop_virtualization_api_client.models.SkuTier
    :param size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :type size: str
    :param family: If the service has different generations of hardware, for the same SKU, then
     that can be captured here.
    :type family: str
    :param capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        tier: Optional[Union[str, "SkuTier"]] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(ResourceModelWithAllowedPropertySetSku, self).__init__(name=name, tier=tier, size=size, family=family, capacity=capacity, **kwargs)


class ResourceProviderOperation(msrest.serialization.Model):
    """Supported operation of this resource provider.

    :param name: Operation name, in format of {provider}/{resource}/{operation}.
    :type name: str
    :param display: Display metadata associated with the operation.
    :type display: ~desktop_virtualization_api_client.models.ResourceProviderOperationDisplay
    :param is_data_action: Is a data action.
    :type is_data_action: bool
    :param properties: Properties of the operation.
    :type properties: ~desktop_virtualization_api_client.models.OperationProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'ResourceProviderOperationDisplay'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'OperationProperties'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["ResourceProviderOperationDisplay"] = None,
        is_data_action: Optional[bool] = None,
        properties: Optional["OperationProperties"] = None,
        **kwargs
    ):
        super(ResourceProviderOperation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.is_data_action = is_data_action
        self.properties = properties


class ResourceProviderOperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :param provider: Resource provider: Microsoft Desktop Virtualization.
    :type provider: str
    :param resource: Resource on which the operation is performed.
    :type resource: str
    :param operation: Type of operation: get, read, delete, etc.
    :type operation: str
    :param description: Description of this operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(ResourceProviderOperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ResourceProviderOperationList(msrest.serialization.Model):
    """Result of the request to list operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of operations supported by this resource provider.
    :type value: list[~desktop_virtualization_api_client.models.ResourceProviderOperation]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceProviderOperation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ResourceProviderOperation"]] = None,
        **kwargs
    ):
        super(ResourceProviderOperationList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ScalingHostPoolReference(msrest.serialization.Model):
    """Scaling plan reference to hostpool.

    :param host_pool_arm_path: Arm path of referenced hostpool.
    :type host_pool_arm_path: str
    :param scaling_plan_enabled: Is the scaling plan enabled for this hostpool.
    :type scaling_plan_enabled: bool
    """

    _attribute_map = {
        'host_pool_arm_path': {'key': 'hostPoolArmPath', 'type': 'str'},
        'scaling_plan_enabled': {'key': 'scalingPlanEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        host_pool_arm_path: Optional[str] = None,
        scaling_plan_enabled: Optional[bool] = None,
        **kwargs
    ):
        super(ScalingHostPoolReference, self).__init__(**kwargs)
        self.host_pool_arm_path = host_pool_arm_path
        self.scaling_plan_enabled = scaling_plan_enabled


class ScalingPlan(ResourceModelWithAllowedPropertySet):
    """Represents a scaling plan definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: The geo-location where the resource lives.
    :type location: str
    :param managed_by: The fully qualified resource ID of the resource that manages this resource.
     Indicates if this resource is managed by another Azure resource. If this is present, complete
     mode deployment will not delete the resource if it is removed from the template since it is
     managed by another resource.
    :type managed_by: str
    :param kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :type kind: str
    :ivar etag: The etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal etag convention.  Entity tags are used for
     comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in
     the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range
     (section 14.27) header fields.
    :vartype etag: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity:
    :type identity:
     ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetIdentity
    :param sku:
    :type sku: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetSku
    :param plan:
    :type plan: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetPlan
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    :ivar object_id: ObjectId of scaling plan. (internal use).
    :vartype object_id: str
    :param description: Description of scaling plan.
    :type description: str
    :param friendly_name: User friendly name of scaling plan.
    :type friendly_name: str
    :param time_zone: Timezone of the scaling plan.
    :type time_zone: str
    :param host_pool_type: HostPool type for desktop. Possible values include: "Pooled".
    :type host_pool_type: str or ~desktop_virtualization_api_client.models.ScalingHostPoolType
    :param exclusion_tag: Exclusion tag for scaling plan.
    :type exclusion_tag: str
    :param schedules: List of ScalingSchedule definitions.
    :type schedules: list[~desktop_virtualization_api_client.models.ScalingSchedule]
    :param host_pool_references: List of ScalingHostPoolReference definitions.
    :type host_pool_references:
     list[~desktop_virtualization_api_client.models.ScalingHostPoolReference]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'pattern': r'^[-\w\._,\(\)]+$'},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'object_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ResourceModelWithAllowedPropertySetIdentity'},
        'sku': {'key': 'sku', 'type': 'ResourceModelWithAllowedPropertySetSku'},
        'plan': {'key': 'plan', 'type': 'ResourceModelWithAllowedPropertySetPlan'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'object_id': {'key': 'properties.objectId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'time_zone': {'key': 'properties.timeZone', 'type': 'str'},
        'host_pool_type': {'key': 'properties.hostPoolType', 'type': 'str'},
        'exclusion_tag': {'key': 'properties.exclusionTag', 'type': 'str'},
        'schedules': {'key': 'properties.schedules', 'type': '[ScalingSchedule]'},
        'host_pool_references': {'key': 'properties.hostPoolReferences', 'type': '[ScalingHostPoolReference]'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        managed_by: Optional[str] = None,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ResourceModelWithAllowedPropertySetIdentity"] = None,
        sku: Optional["ResourceModelWithAllowedPropertySetSku"] = None,
        plan: Optional["ResourceModelWithAllowedPropertySetPlan"] = None,
        description: Optional[str] = None,
        friendly_name: Optional[str] = None,
        time_zone: Optional[str] = None,
        host_pool_type: Optional[Union[str, "ScalingHostPoolType"]] = None,
        exclusion_tag: Optional[str] = None,
        schedules: Optional[List["ScalingSchedule"]] = None,
        host_pool_references: Optional[List["ScalingHostPoolReference"]] = None,
        **kwargs
    ):
        super(ScalingPlan, self).__init__(location=location, managed_by=managed_by, kind=kind, tags=tags, identity=identity, sku=sku, plan=plan, **kwargs)
        self.system_data = None
        self.object_id = None
        self.description = description
        self.friendly_name = friendly_name
        self.time_zone = time_zone
        self.host_pool_type = host_pool_type
        self.exclusion_tag = exclusion_tag
        self.schedules = schedules
        self.host_pool_references = host_pool_references


class ScalingPlanList(msrest.serialization.Model):
    """List of scaling plan definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of scaling plan definitions.
    :type value: list[~desktop_virtualization_api_client.models.ScalingPlan]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ScalingPlan]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ScalingPlan"]] = None,
        **kwargs
    ):
        super(ScalingPlanList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ScalingPlanPatch(msrest.serialization.Model):
    """Scaling plan properties that can be patched.

    :param tags: A set of tags. tags to be updated.
    :type tags: dict[str, str]
    :param description: Description of scaling plan.
    :type description: str
    :param friendly_name: User friendly name of scaling plan.
    :type friendly_name: str
    :param time_zone: Timezone of the scaling plan.
    :type time_zone: str
    :param exclusion_tag: Exclusion tag for scaling plan.
    :type exclusion_tag: str
    :param schedules: List of ScalingSchedule definitions.
    :type schedules: list[~desktop_virtualization_api_client.models.ScalingSchedule]
    :param host_pool_references: List of ScalingHostPoolReference definitions.
    :type host_pool_references:
     list[~desktop_virtualization_api_client.models.ScalingHostPoolReference]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'time_zone': {'key': 'properties.timeZone', 'type': 'str'},
        'exclusion_tag': {'key': 'properties.exclusionTag', 'type': 'str'},
        'schedules': {'key': 'properties.schedules', 'type': '[ScalingSchedule]'},
        'host_pool_references': {'key': 'properties.hostPoolReferences', 'type': '[ScalingHostPoolReference]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        friendly_name: Optional[str] = None,
        time_zone: Optional[str] = None,
        exclusion_tag: Optional[str] = None,
        schedules: Optional[List["ScalingSchedule"]] = None,
        host_pool_references: Optional[List["ScalingHostPoolReference"]] = None,
        **kwargs
    ):
        super(ScalingPlanPatch, self).__init__(**kwargs)
        self.tags = tags
        self.description = description
        self.friendly_name = friendly_name
        self.time_zone = time_zone
        self.exclusion_tag = exclusion_tag
        self.schedules = schedules
        self.host_pool_references = host_pool_references


class ScalingSchedule(msrest.serialization.Model):
    """Scaling plan schedule.

    :param name: Name of the scaling schedule.
    :type name: str
    :param days_of_week: Set of days of the week on which this schedule is active.
    :type days_of_week: list[str or
     ~desktop_virtualization_api_client.models.ScalingScheduleDaysOfWeekItem]
    :param ramp_up_start_time: Starting time for ramp up period.
    :type ramp_up_start_time: ~desktop_virtualization_api_client.models.Time
    :param ramp_up_load_balancing_algorithm: Load balancing algorithm for ramp up period. Possible
     values include: "BreadthFirst", "DepthFirst".
    :type ramp_up_load_balancing_algorithm: str or
     ~desktop_virtualization_api_client.models.SessionHostLoadBalancingAlgorithm
    :param ramp_up_minimum_hosts_pct: Minimum host percentage for ramp up period.
    :type ramp_up_minimum_hosts_pct: int
    :param ramp_up_capacity_threshold_pct: Capacity threshold for ramp up period.
    :type ramp_up_capacity_threshold_pct: int
    :param peak_start_time: Starting time for peak period.
    :type peak_start_time: ~desktop_virtualization_api_client.models.Time
    :param peak_load_balancing_algorithm: Load balancing algorithm for peak period. Possible values
     include: "BreadthFirst", "DepthFirst".
    :type peak_load_balancing_algorithm: str or
     ~desktop_virtualization_api_client.models.SessionHostLoadBalancingAlgorithm
    :param ramp_down_start_time: Starting time for ramp down period.
    :type ramp_down_start_time: ~desktop_virtualization_api_client.models.Time
    :param ramp_down_load_balancing_algorithm: Load balancing algorithm for ramp down period.
     Possible values include: "BreadthFirst", "DepthFirst".
    :type ramp_down_load_balancing_algorithm: str or
     ~desktop_virtualization_api_client.models.SessionHostLoadBalancingAlgorithm
    :param ramp_down_minimum_hosts_pct: Minimum host percentage for ramp down period.
    :type ramp_down_minimum_hosts_pct: int
    :param ramp_down_capacity_threshold_pct: Capacity threshold for ramp down period.
    :type ramp_down_capacity_threshold_pct: int
    :param ramp_down_force_logoff_users: Should users be logged off forcefully from hosts.
    :type ramp_down_force_logoff_users: bool
    :param ramp_down_stop_hosts_when: Specifies when to stop hosts during ramp down period.
     Possible values include: "ZeroSessions", "ZeroActiveSessions".
    :type ramp_down_stop_hosts_when: str or ~desktop_virtualization_api_client.models.StopHostsWhen
    :param ramp_down_wait_time_minutes: Number of minutes to wait to stop hosts during ramp down
     period.
    :type ramp_down_wait_time_minutes: int
    :param ramp_down_notification_message: Notification message for users during ramp down period.
    :type ramp_down_notification_message: str
    :param off_peak_start_time: Starting time for off-peak period.
    :type off_peak_start_time: ~desktop_virtualization_api_client.models.Time
    :param off_peak_load_balancing_algorithm: Load balancing algorithm for off-peak period.
     Possible values include: "BreadthFirst", "DepthFirst".
    :type off_peak_load_balancing_algorithm: str or
     ~desktop_virtualization_api_client.models.SessionHostLoadBalancingAlgorithm
    """

    _validation = {
        'ramp_up_minimum_hosts_pct': {'maximum': 100, 'minimum': 0},
        'ramp_up_capacity_threshold_pct': {'maximum': 100, 'minimum': 1},
        'ramp_down_minimum_hosts_pct': {'maximum': 100, 'minimum': 0},
        'ramp_down_capacity_threshold_pct': {'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'days_of_week': {'key': 'daysOfWeek', 'type': '[str]'},
        'ramp_up_start_time': {'key': 'rampUpStartTime', 'type': 'Time'},
        'ramp_up_load_balancing_algorithm': {'key': 'rampUpLoadBalancingAlgorithm', 'type': 'str'},
        'ramp_up_minimum_hosts_pct': {'key': 'rampUpMinimumHostsPct', 'type': 'int'},
        'ramp_up_capacity_threshold_pct': {'key': 'rampUpCapacityThresholdPct', 'type': 'int'},
        'peak_start_time': {'key': 'peakStartTime', 'type': 'Time'},
        'peak_load_balancing_algorithm': {'key': 'peakLoadBalancingAlgorithm', 'type': 'str'},
        'ramp_down_start_time': {'key': 'rampDownStartTime', 'type': 'Time'},
        'ramp_down_load_balancing_algorithm': {'key': 'rampDownLoadBalancingAlgorithm', 'type': 'str'},
        'ramp_down_minimum_hosts_pct': {'key': 'rampDownMinimumHostsPct', 'type': 'int'},
        'ramp_down_capacity_threshold_pct': {'key': 'rampDownCapacityThresholdPct', 'type': 'int'},
        'ramp_down_force_logoff_users': {'key': 'rampDownForceLogoffUsers', 'type': 'bool'},
        'ramp_down_stop_hosts_when': {'key': 'rampDownStopHostsWhen', 'type': 'str'},
        'ramp_down_wait_time_minutes': {'key': 'rampDownWaitTimeMinutes', 'type': 'int'},
        'ramp_down_notification_message': {'key': 'rampDownNotificationMessage', 'type': 'str'},
        'off_peak_start_time': {'key': 'offPeakStartTime', 'type': 'Time'},
        'off_peak_load_balancing_algorithm': {'key': 'offPeakLoadBalancingAlgorithm', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        days_of_week: Optional[List[Union[str, "ScalingScheduleDaysOfWeekItem"]]] = None,
        ramp_up_start_time: Optional["Time"] = None,
        ramp_up_load_balancing_algorithm: Optional[Union[str, "SessionHostLoadBalancingAlgorithm"]] = None,
        ramp_up_minimum_hosts_pct: Optional[int] = None,
        ramp_up_capacity_threshold_pct: Optional[int] = None,
        peak_start_time: Optional["Time"] = None,
        peak_load_balancing_algorithm: Optional[Union[str, "SessionHostLoadBalancingAlgorithm"]] = None,
        ramp_down_start_time: Optional["Time"] = None,
        ramp_down_load_balancing_algorithm: Optional[Union[str, "SessionHostLoadBalancingAlgorithm"]] = None,
        ramp_down_minimum_hosts_pct: Optional[int] = None,
        ramp_down_capacity_threshold_pct: Optional[int] = None,
        ramp_down_force_logoff_users: Optional[bool] = None,
        ramp_down_stop_hosts_when: Optional[Union[str, "StopHostsWhen"]] = None,
        ramp_down_wait_time_minutes: Optional[int] = None,
        ramp_down_notification_message: Optional[str] = None,
        off_peak_start_time: Optional["Time"] = None,
        off_peak_load_balancing_algorithm: Optional[Union[str, "SessionHostLoadBalancingAlgorithm"]] = None,
        **kwargs
    ):
        super(ScalingSchedule, self).__init__(**kwargs)
        self.name = name
        self.days_of_week = days_of_week
        self.ramp_up_start_time = ramp_up_start_time
        self.ramp_up_load_balancing_algorithm = ramp_up_load_balancing_algorithm
        self.ramp_up_minimum_hosts_pct = ramp_up_minimum_hosts_pct
        self.ramp_up_capacity_threshold_pct = ramp_up_capacity_threshold_pct
        self.peak_start_time = peak_start_time
        self.peak_load_balancing_algorithm = peak_load_balancing_algorithm
        self.ramp_down_start_time = ramp_down_start_time
        self.ramp_down_load_balancing_algorithm = ramp_down_load_balancing_algorithm
        self.ramp_down_minimum_hosts_pct = ramp_down_minimum_hosts_pct
        self.ramp_down_capacity_threshold_pct = ramp_down_capacity_threshold_pct
        self.ramp_down_force_logoff_users = ramp_down_force_logoff_users
        self.ramp_down_stop_hosts_when = ramp_down_stop_hosts_when
        self.ramp_down_wait_time_minutes = ramp_down_wait_time_minutes
        self.ramp_down_notification_message = ramp_down_notification_message
        self.off_peak_start_time = off_peak_start_time
        self.off_peak_load_balancing_algorithm = off_peak_load_balancing_algorithm


class SendMessage(msrest.serialization.Model):
    """Represents message sent to a UserSession.

    :param message_title: Title of message.
    :type message_title: str
    :param message_body: Body of message.
    :type message_body: str
    """

    _attribute_map = {
        'message_title': {'key': 'messageTitle', 'type': 'str'},
        'message_body': {'key': 'messageBody', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message_title: Optional[str] = None,
        message_body: Optional[str] = None,
        **kwargs
    ):
        super(SendMessage, self).__init__(**kwargs)
        self.message_title = message_title
        self.message_body = message_body


class ServiceSpecification(msrest.serialization.Model):
    """Service specification payload.

    :param log_specifications: Specifications of the Log for Azure Monitoring.
    :type log_specifications: list[~desktop_virtualization_api_client.models.LogSpecification]
    """

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
    }

    def __init__(
        self,
        *,
        log_specifications: Optional[List["LogSpecification"]] = None,
        **kwargs
    ):
        super(ServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = log_specifications


class SessionHost(Resource):
    """Represents a SessionHost definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    :ivar object_id: ObjectId of SessionHost. (internal use).
    :vartype object_id: str
    :param last_heart_beat: Last heart beat from SessionHost.
    :type last_heart_beat: ~datetime.datetime
    :param sessions: Number of sessions on SessionHost.
    :type sessions: int
    :param agent_version: Version of agent on SessionHost.
    :type agent_version: str
    :param allow_new_session: Allow a new session.
    :type allow_new_session: bool
    :ivar virtual_machine_id: Virtual Machine Id of SessionHost's underlying virtual machine.
    :vartype virtual_machine_id: str
    :ivar resource_id: Resource Id of SessionHost's underlying virtual machine.
    :vartype resource_id: str
    :param assigned_user: User assigned to SessionHost.
    :type assigned_user: str
    :param status: Status for a SessionHost. Possible values include: "Available", "Unavailable",
     "Shutdown", "Disconnected", "Upgrading", "UpgradeFailed", "NoHeartbeat", "NotJoinedToDomain",
     "DomainTrustRelationshipLost", "SxSStackListenerNotReady", "FSLogixNotHealthy",
     "NeedsAssistance".
    :type status: str or ~desktop_virtualization_api_client.models.Status
    :ivar status_timestamp: The timestamp of the status.
    :vartype status_timestamp: ~datetime.datetime
    :param os_version: The version of the OS on the session host.
    :type os_version: str
    :param sx_s_stack_version: The version of the side by side stack on the session host.
    :type sx_s_stack_version: str
    :param update_state: Update state of a SessionHost. Possible values include: "Initial",
     "Pending", "Started", "Succeeded", "Failed".
    :type update_state: str or ~desktop_virtualization_api_client.models.UpdateState
    :ivar last_update_time: The timestamp of the last update.
    :vartype last_update_time: ~datetime.datetime
    :param update_error_message: The error message.
    :type update_error_message: str
    :ivar session_host_health_check_results: List of SessionHostHealthCheckReports.
    :vartype session_host_health_check_results:
     list[~desktop_virtualization_api_client.models.SessionHostHealthCheckReport]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'object_id': {'readonly': True},
        'virtual_machine_id': {'readonly': True},
        'resource_id': {'readonly': True},
        'status_timestamp': {'readonly': True},
        'last_update_time': {'readonly': True},
        'session_host_health_check_results': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'object_id': {'key': 'properties.objectId', 'type': 'str'},
        'last_heart_beat': {'key': 'properties.lastHeartBeat', 'type': 'iso-8601'},
        'sessions': {'key': 'properties.sessions', 'type': 'int'},
        'agent_version': {'key': 'properties.agentVersion', 'type': 'str'},
        'allow_new_session': {'key': 'properties.allowNewSession', 'type': 'bool'},
        'virtual_machine_id': {'key': 'properties.virtualMachineId', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'assigned_user': {'key': 'properties.assignedUser', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'status_timestamp': {'key': 'properties.statusTimestamp', 'type': 'iso-8601'},
        'os_version': {'key': 'properties.osVersion', 'type': 'str'},
        'sx_s_stack_version': {'key': 'properties.sxSStackVersion', 'type': 'str'},
        'update_state': {'key': 'properties.updateState', 'type': 'str'},
        'last_update_time': {'key': 'properties.lastUpdateTime', 'type': 'iso-8601'},
        'update_error_message': {'key': 'properties.updateErrorMessage', 'type': 'str'},
        'session_host_health_check_results': {'key': 'properties.sessionHostHealthCheckResults', 'type': '[SessionHostHealthCheckReport]'},
    }

    def __init__(
        self,
        *,
        last_heart_beat: Optional[datetime.datetime] = None,
        sessions: Optional[int] = None,
        agent_version: Optional[str] = None,
        allow_new_session: Optional[bool] = None,
        assigned_user: Optional[str] = None,
        status: Optional[Union[str, "Status"]] = None,
        os_version: Optional[str] = None,
        sx_s_stack_version: Optional[str] = None,
        update_state: Optional[Union[str, "UpdateState"]] = None,
        update_error_message: Optional[str] = None,
        **kwargs
    ):
        super(SessionHost, self).__init__(**kwargs)
        self.system_data = None
        self.object_id = None
        self.last_heart_beat = last_heart_beat
        self.sessions = sessions
        self.agent_version = agent_version
        self.allow_new_session = allow_new_session
        self.virtual_machine_id = None
        self.resource_id = None
        self.assigned_user = assigned_user
        self.status = status
        self.status_timestamp = None
        self.os_version = os_version
        self.sx_s_stack_version = sx_s_stack_version
        self.update_state = update_state
        self.last_update_time = None
        self.update_error_message = update_error_message
        self.session_host_health_check_results = None


class SessionHostHealthCheckFailureDetails(msrest.serialization.Model):
    """Contains details on the failure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar message: Failure message: hints on what is wrong and how to recover.
    :vartype message: str
    :ivar error_code: Error code corresponding for the failure.
    :vartype error_code: int
    :ivar last_health_check_date_time: The timestamp of the last update.
    :vartype last_health_check_date_time: ~datetime.datetime
    """

    _validation = {
        'message': {'readonly': True},
        'error_code': {'readonly': True},
        'last_health_check_date_time': {'readonly': True},
    }

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'error_code': {'key': 'errorCode', 'type': 'int'},
        'last_health_check_date_time': {'key': 'lastHealthCheckDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SessionHostHealthCheckFailureDetails, self).__init__(**kwargs)
        self.message = None
        self.error_code = None
        self.last_health_check_date_time = None


class SessionHostHealthCheckReport(msrest.serialization.Model):
    """The report for session host information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar health_check_name: Represents the name of the health check operation performed. Possible
     values include: "DomainJoinedCheck", "DomainTrustCheck", "FSLogixHealthCheck",
     "SxSStackListenerCheck", "UrlsAccessibleCheck", "MonitoringAgentCheck", "DomainReachable",
     "WebRTCRedirectorCheck", "SupportedEncryptionCheck", "MetaDataServiceCheck",
     "AppAttachHealthCheck".
    :vartype health_check_name: str or ~desktop_virtualization_api_client.models.HealthCheckName
    :ivar health_check_result: Represents the Health state of the health check we performed.
     Possible values include: "Unknown", "HealthCheckSucceeded", "HealthCheckFailed",
     "SessionHostShutdown".
    :vartype health_check_result: str or
     ~desktop_virtualization_api_client.models.HealthCheckResult
    :ivar additional_failure_details: Additional detailed information on the failure.
    :vartype additional_failure_details:
     ~desktop_virtualization_api_client.models.SessionHostHealthCheckFailureDetails
    """

    _validation = {
        'health_check_name': {'readonly': True},
        'health_check_result': {'readonly': True},
        'additional_failure_details': {'readonly': True},
    }

    _attribute_map = {
        'health_check_name': {'key': 'healthCheckName', 'type': 'str'},
        'health_check_result': {'key': 'healthCheckResult', 'type': 'str'},
        'additional_failure_details': {'key': 'additionalFailureDetails', 'type': 'SessionHostHealthCheckFailureDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SessionHostHealthCheckReport, self).__init__(**kwargs)
        self.health_check_name = None
        self.health_check_result = None
        self.additional_failure_details = None


class SessionHostList(msrest.serialization.Model):
    """List of SessionHost definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of SessionHost definitions.
    :type value: list[~desktop_virtualization_api_client.models.SessionHost]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SessionHost]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SessionHost"]] = None,
        **kwargs
    ):
        super(SessionHostList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SessionHostPatch(Resource):
    """SessionHost properties that can be patched.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param allow_new_session: Allow a new session.
    :type allow_new_session: bool
    :param assigned_user: User assigned to SessionHost.
    :type assigned_user: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'allow_new_session': {'key': 'properties.allowNewSession', 'type': 'bool'},
        'assigned_user': {'key': 'properties.assignedUser', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        allow_new_session: Optional[bool] = None,
        assigned_user: Optional[str] = None,
        **kwargs
    ):
        super(SessionHostPatch, self).__init__(**kwargs)
        self.allow_new_session = allow_new_session
        self.assigned_user = assigned_user


class StartMenuItem(Resource):
    """Represents a StartMenuItem definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param app_alias: Alias of StartMenuItem.
    :type app_alias: str
    :param file_path: Path to the file of StartMenuItem.
    :type file_path: str
    :param command_line_arguments: Command line arguments for StartMenuItem.
    :type command_line_arguments: str
    :param icon_path: Path to the icon.
    :type icon_path: str
    :param icon_index: Index of the icon.
    :type icon_index: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'app_alias': {'key': 'properties.appAlias', 'type': 'str'},
        'file_path': {'key': 'properties.filePath', 'type': 'str'},
        'command_line_arguments': {'key': 'properties.commandLineArguments', 'type': 'str'},
        'icon_path': {'key': 'properties.iconPath', 'type': 'str'},
        'icon_index': {'key': 'properties.iconIndex', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        app_alias: Optional[str] = None,
        file_path: Optional[str] = None,
        command_line_arguments: Optional[str] = None,
        icon_path: Optional[str] = None,
        icon_index: Optional[int] = None,
        **kwargs
    ):
        super(StartMenuItem, self).__init__(**kwargs)
        self.app_alias = app_alias
        self.file_path = file_path
        self.command_line_arguments = command_line_arguments
        self.icon_path = icon_path
        self.icon_index = icon_index


class StartMenuItemList(msrest.serialization.Model):
    """List of StartMenuItem definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of StartMenuItem definitions.
    :type value: list[~desktop_virtualization_api_client.models.StartMenuItem]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StartMenuItem]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["StartMenuItem"]] = None,
        **kwargs
    ):
        super(StartMenuItemList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~desktop_virtualization_api_client.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~desktop_virtualization_api_client.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class Time(msrest.serialization.Model):
    """The time for a scaling action to occur.

    All required parameters must be populated in order to send to Azure.

    :param hour: Required. The hour.
    :type hour: int
    :param minute: Required. The minute.
    :type minute: int
    """

    _validation = {
        'hour': {'required': True, 'maximum': 23, 'minimum': 0},
        'minute': {'required': True, 'maximum': 59, 'minimum': 0},
    }

    _attribute_map = {
        'hour': {'key': 'hour', 'type': 'int'},
        'minute': {'key': 'minute', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        hour: int,
        minute: int,
        **kwargs
    ):
        super(Time, self).__init__(**kwargs)
        self.hour = hour
        self.minute = minute


class UserSession(Resource):
    """Represents a UserSession definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    :ivar object_id: ObjectId of user session. (internal use).
    :vartype object_id: str
    :param user_principal_name: The user principal name.
    :type user_principal_name: str
    :param application_type: Application type of application. Possible values include: "RemoteApp",
     "Desktop".
    :type application_type: str or ~desktop_virtualization_api_client.models.ApplicationType
    :param session_state: State of user session. Possible values include: "Unknown", "Active",
     "Disconnected", "Pending", "LogOff", "UserProfileDiskMounted".
    :type session_state: str or ~desktop_virtualization_api_client.models.SessionState
    :param active_directory_user_name: The active directory user name.
    :type active_directory_user_name: str
    :param create_time: The timestamp of the user session create.
    :type create_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'object_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'object_id': {'key': 'properties.objectId', 'type': 'str'},
        'user_principal_name': {'key': 'properties.userPrincipalName', 'type': 'str'},
        'application_type': {'key': 'properties.applicationType', 'type': 'str'},
        'session_state': {'key': 'properties.sessionState', 'type': 'str'},
        'active_directory_user_name': {'key': 'properties.activeDirectoryUserName', 'type': 'str'},
        'create_time': {'key': 'properties.createTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        user_principal_name: Optional[str] = None,
        application_type: Optional[Union[str, "ApplicationType"]] = None,
        session_state: Optional[Union[str, "SessionState"]] = None,
        active_directory_user_name: Optional[str] = None,
        create_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(UserSession, self).__init__(**kwargs)
        self.system_data = None
        self.object_id = None
        self.user_principal_name = user_principal_name
        self.application_type = application_type
        self.session_state = session_state
        self.active_directory_user_name = active_directory_user_name
        self.create_time = create_time


class UserSessionList(msrest.serialization.Model):
    """List of UserSession definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of UserSession definitions.
    :type value: list[~desktop_virtualization_api_client.models.UserSession]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UserSession]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["UserSession"]] = None,
        **kwargs
    ):
        super(UserSessionList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class Workspace(ResourceModelWithAllowedPropertySet):
    """Represents a Workspace definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param location: The geo-location where the resource lives.
    :type location: str
    :param managed_by: The fully qualified resource ID of the resource that manages this resource.
     Indicates if this resource is managed by another Azure resource. If this is present, complete
     mode deployment will not delete the resource if it is removed from the template since it is
     managed by another resource.
    :type managed_by: str
    :param kind: Metadata used by portal/tooling/etc to render different UX experiences for
     resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported,
     the resource provider must validate and persist this value.
    :type kind: str
    :ivar etag: The etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal etag convention.  Entity tags are used for
     comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in
     the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range
     (section 14.27) header fields.
    :vartype etag: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity:
    :type identity:
     ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetIdentity
    :param sku:
    :type sku: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetSku
    :param plan:
    :type plan: ~desktop_virtualization_api_client.models.ResourceModelWithAllowedPropertySetPlan
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~desktop_virtualization_api_client.models.SystemData
    :ivar object_id: ObjectId of Workspace. (internal use).
    :vartype object_id: str
    :param description: Description of Workspace.
    :type description: str
    :param friendly_name: Friendly name of Workspace.
    :type friendly_name: str
    :param application_group_references: List of applicationGroup resource Ids.
    :type application_group_references: list[str]
    :ivar cloud_pc_resource: Is cloud pc resource.
    :vartype cloud_pc_resource: bool
    :param public_network_access: Enabled allows this resource to be accessed from both public and
     private networks, Disabled allows this resource to only be accessed via private endpoints.
     Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or
     ~desktop_virtualization_api_client.models.PublicNetworkAccess
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'pattern': r'^[-\w\._,\(\)]+$'},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'object_id': {'readonly': True},
        'cloud_pc_resource': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ResourceModelWithAllowedPropertySetIdentity'},
        'sku': {'key': 'sku', 'type': 'ResourceModelWithAllowedPropertySetSku'},
        'plan': {'key': 'plan', 'type': 'ResourceModelWithAllowedPropertySetPlan'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'object_id': {'key': 'properties.objectId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'application_group_references': {'key': 'properties.applicationGroupReferences', 'type': '[str]'},
        'cloud_pc_resource': {'key': 'properties.cloudPcResource', 'type': 'bool'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        managed_by: Optional[str] = None,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ResourceModelWithAllowedPropertySetIdentity"] = None,
        sku: Optional["ResourceModelWithAllowedPropertySetSku"] = None,
        plan: Optional["ResourceModelWithAllowedPropertySetPlan"] = None,
        description: Optional[str] = None,
        friendly_name: Optional[str] = None,
        application_group_references: Optional[List[str]] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        **kwargs
    ):
        super(Workspace, self).__init__(location=location, managed_by=managed_by, kind=kind, tags=tags, identity=identity, sku=sku, plan=plan, **kwargs)
        self.system_data = None
        self.object_id = None
        self.description = description
        self.friendly_name = friendly_name
        self.application_group_references = application_group_references
        self.cloud_pc_resource = None
        self.public_network_access = public_network_access


class WorkspaceList(msrest.serialization.Model):
    """List of Workspace definitions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of Workspace definitions.
    :type value: list[~desktop_virtualization_api_client.models.Workspace]
    :ivar next_link: Link to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Workspace]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Workspace"]] = None,
        **kwargs
    ):
        super(WorkspaceList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class WorkspacePatch(msrest.serialization.Model):
    """Workspace properties that can be patched.

    :param tags: A set of tags. tags to be updated.
    :type tags: dict[str, str]
    :param description: Description of Workspace.
    :type description: str
    :param friendly_name: Friendly name of Workspace.
    :type friendly_name: str
    :param application_group_references: List of applicationGroup links.
    :type application_group_references: list[str]
    :param public_network_access: Enabled to allow this resource to be access from the public
     network. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or
     ~desktop_virtualization_api_client.models.PublicNetworkAccess
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'application_group_references': {'key': 'properties.applicationGroupReferences', 'type': '[str]'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        friendly_name: Optional[str] = None,
        application_group_references: Optional[List[str]] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        **kwargs
    ):
        super(WorkspacePatch, self).__init__(**kwargs)
        self.tags = tags
        self.description = description
        self.friendly_name = friendly_name
        self.application_group_references = application_group_references
        self.public_network_access = public_network_access
