# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Codec(_serialization.Model):
    """Describes the basic properties of all codecs.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    Audio, CopyAudio, CopyVideo, Video

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar label: An optional label for the codec. The label can be used to control muxing behavior.
    :vartype label: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "label": {"key": "label", "type": "str"},
    }

    _subtype_map = {
        "odata_type": {
            "#Microsoft.Media.Audio": "Audio",
            "#Microsoft.Media.CopyAudio": "CopyAudio",
            "#Microsoft.Media.CopyVideo": "CopyVideo",
            "#Microsoft.Media.Video": "Video",
        }
    }

    def __init__(self, *, label: Optional[str] = None, **kwargs):
        """
        :keyword label: An optional label for the codec. The label can be used to control muxing
         behavior.
        :paramtype label: str
        """
        super().__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.label = label


class Audio(Codec):
    """Defines the common properties for all audio codecs.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AacAudio

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar label: An optional label for the codec. The label can be used to control muxing behavior.
    :vartype label: str
    :ivar channels: The number of channels in the audio.
    :vartype channels: int
    :ivar sampling_rate: The sampling rate to use for encoding in hertz.
    :vartype sampling_rate: int
    :ivar bitrate: The bitrate, in bits per second, of the output encoded audio.
    :vartype bitrate: int
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "channels": {"key": "channels", "type": "int"},
        "sampling_rate": {"key": "samplingRate", "type": "int"},
        "bitrate": {"key": "bitrate", "type": "int"},
    }

    _subtype_map = {"odata_type": {"#Microsoft.Media.AacAudio": "AacAudio"}}

    def __init__(
        self,
        *,
        label: Optional[str] = None,
        channels: Optional[int] = None,
        sampling_rate: Optional[int] = None,
        bitrate: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword label: An optional label for the codec. The label can be used to control muxing
         behavior.
        :paramtype label: str
        :keyword channels: The number of channels in the audio.
        :paramtype channels: int
        :keyword sampling_rate: The sampling rate to use for encoding in hertz.
        :paramtype sampling_rate: int
        :keyword bitrate: The bitrate, in bits per second, of the output encoded audio.
        :paramtype bitrate: int
        """
        super().__init__(label=label, **kwargs)
        self.odata_type = "#Microsoft.Media.Audio"  # type: str
        self.channels = channels
        self.sampling_rate = sampling_rate
        self.bitrate = bitrate


class AacAudio(Audio):
    """Describes Advanced Audio Codec (AAC) audio encoding settings.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar label: An optional label for the codec. The label can be used to control muxing behavior.
    :vartype label: str
    :ivar channels: The number of channels in the audio.
    :vartype channels: int
    :ivar sampling_rate: The sampling rate to use for encoding in hertz.
    :vartype sampling_rate: int
    :ivar bitrate: The bitrate, in bits per second, of the output encoded audio.
    :vartype bitrate: int
    :ivar profile: The encoding profile to be used when encoding audio with AAC. Known values are:
     "AacLc", "HeAacV1", and "HeAacV2".
    :vartype profile: str or ~azure.mgmt.media.models.AacAudioProfile
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "channels": {"key": "channels", "type": "int"},
        "sampling_rate": {"key": "samplingRate", "type": "int"},
        "bitrate": {"key": "bitrate", "type": "int"},
        "profile": {"key": "profile", "type": "str"},
    }

    def __init__(
        self,
        *,
        label: Optional[str] = None,
        channels: Optional[int] = None,
        sampling_rate: Optional[int] = None,
        bitrate: Optional[int] = None,
        profile: Optional[Union[str, "_models.AacAudioProfile"]] = None,
        **kwargs
    ):
        """
        :keyword label: An optional label for the codec. The label can be used to control muxing
         behavior.
        :paramtype label: str
        :keyword channels: The number of channels in the audio.
        :paramtype channels: int
        :keyword sampling_rate: The sampling rate to use for encoding in hertz.
        :paramtype sampling_rate: int
        :keyword bitrate: The bitrate, in bits per second, of the output encoded audio.
        :paramtype bitrate: int
        :keyword profile: The encoding profile to be used when encoding audio with AAC. Known values
         are: "AacLc", "HeAacV1", and "HeAacV2".
        :paramtype profile: str or ~azure.mgmt.media.models.AacAudioProfile
        """
        super().__init__(label=label, channels=channels, sampling_rate=sampling_rate, bitrate=bitrate, **kwargs)
        self.odata_type = "#Microsoft.Media.AacAudio"  # type: str
        self.profile = profile


class ClipTime(_serialization.Model):
    """Base class for specifying a clip time. Use sub classes of this class to specify the time position in the media.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AbsoluteClipTime, UtcClipTime

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
    }

    _subtype_map = {
        "odata_type": {
            "#Microsoft.Media.AbsoluteClipTime": "AbsoluteClipTime",
            "#Microsoft.Media.UtcClipTime": "UtcClipTime",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class AbsoluteClipTime(ClipTime):
    """Specifies the clip time as an absolute time position in the media file.  The absolute time can point to a different position depending on whether the media file starts from a timestamp of zero or not.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar time: The time position on the timeline of the input media. It is usually specified as an
     ISO8601 period. e.g PT30S for 30 seconds. Required.
    :vartype time: ~datetime.timedelta
    """

    _validation = {
        "odata_type": {"required": True},
        "time": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "time": {"key": "time", "type": "duration"},
    }

    def __init__(self, *, time: datetime.timedelta, **kwargs):
        """
        :keyword time: The time position on the timeline of the input media. It is usually specified as
         an ISO8601 period. e.g PT30S for 30 seconds. Required.
        :paramtype time: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.AbsoluteClipTime"  # type: str
        self.time = time


class AccessControl(_serialization.Model):
    """AccessControl.

    :ivar default_action: The behavior for IP access control in Key Delivery. Known values are:
     "Allow" and "Deny".
    :vartype default_action: str or ~azure.mgmt.media.models.DefaultAction
    :ivar ip_allow_list: The IP allow list for access control in Key Delivery. If the default
     action is set to 'Allow', the IP allow list must be empty.
    :vartype ip_allow_list: list[str]
    """

    _attribute_map = {
        "default_action": {"key": "defaultAction", "type": "str"},
        "ip_allow_list": {"key": "ipAllowList", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        default_action: Optional[Union[str, "_models.DefaultAction"]] = None,
        ip_allow_list: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword default_action: The behavior for IP access control in Key Delivery. Known values are:
         "Allow" and "Deny".
        :paramtype default_action: str or ~azure.mgmt.media.models.DefaultAction
        :keyword ip_allow_list: The IP allow list for access control in Key Delivery. If the default
         action is set to 'Allow', the IP allow list must be empty.
        :paramtype ip_allow_list: list[str]
        """
        super().__init__(**kwargs)
        self.default_action = default_action
        self.ip_allow_list = ip_allow_list


class AccountEncryption(_serialization.Model):
    """AccountEncryption.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The type of key used to encrypt the Account Key. Required. Known values are:
     "SystemKey" and "CustomerKey".
    :vartype type: str or ~azure.mgmt.media.models.AccountEncryptionKeyType
    :ivar key_vault_properties: The properties of the key used to encrypt the account.
    :vartype key_vault_properties: ~azure.mgmt.media.models.KeyVaultProperties
    :ivar identity: The Key Vault identity.
    :vartype identity: ~azure.mgmt.media.models.ResourceIdentity
    :ivar status: The current status of the Key Vault mapping.
    :vartype status: str
    """

    _validation = {
        "type": {"required": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "key_vault_properties": {"key": "keyVaultProperties", "type": "KeyVaultProperties"},
        "identity": {"key": "identity", "type": "ResourceIdentity"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.AccountEncryptionKeyType"],
        key_vault_properties: Optional["_models.KeyVaultProperties"] = None,
        identity: Optional["_models.ResourceIdentity"] = None,
        **kwargs
    ):
        """
        :keyword type: The type of key used to encrypt the Account Key. Required. Known values are:
         "SystemKey" and "CustomerKey".
        :paramtype type: str or ~azure.mgmt.media.models.AccountEncryptionKeyType
        :keyword key_vault_properties: The properties of the key used to encrypt the account.
        :paramtype key_vault_properties: ~azure.mgmt.media.models.KeyVaultProperties
        :keyword identity: The Key Vault identity.
        :paramtype identity: ~azure.mgmt.media.models.ResourceIdentity
        """
        super().__init__(**kwargs)
        self.type = type
        self.key_vault_properties = key_vault_properties
        self.identity = identity
        self.status = None


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)


class AccountFilter(ProxyResource):
    """An Account Filter.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    :ivar presentation_time_range: The presentation time range.
    :vartype presentation_time_range: ~azure.mgmt.media.models.PresentationTimeRange
    :ivar first_quality: The first quality.
    :vartype first_quality: ~azure.mgmt.media.models.FirstQuality
    :ivar tracks: The tracks selection conditions.
    :vartype tracks: list[~azure.mgmt.media.models.FilterTrackSelection]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "presentation_time_range": {"key": "properties.presentationTimeRange", "type": "PresentationTimeRange"},
        "first_quality": {"key": "properties.firstQuality", "type": "FirstQuality"},
        "tracks": {"key": "properties.tracks", "type": "[FilterTrackSelection]"},
    }

    def __init__(
        self,
        *,
        presentation_time_range: Optional["_models.PresentationTimeRange"] = None,
        first_quality: Optional["_models.FirstQuality"] = None,
        tracks: Optional[List["_models.FilterTrackSelection"]] = None,
        **kwargs
    ):
        """
        :keyword presentation_time_range: The presentation time range.
        :paramtype presentation_time_range: ~azure.mgmt.media.models.PresentationTimeRange
        :keyword first_quality: The first quality.
        :paramtype first_quality: ~azure.mgmt.media.models.FirstQuality
        :keyword tracks: The tracks selection conditions.
        :paramtype tracks: list[~azure.mgmt.media.models.FilterTrackSelection]
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.presentation_time_range = presentation_time_range
        self.first_quality = first_quality
        self.tracks = tracks


class AccountFilterCollection(_serialization.Model):
    """A collection of AccountFilter items.

    :ivar value: A collection of AccountFilter items.
    :vartype value: list[~azure.mgmt.media.models.AccountFilter]
    :ivar odata_next_link: A link to the next page of the collection (when the collection contains
     too many results to return in one response).
    :vartype odata_next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AccountFilter]"},
        "odata_next_link": {"key": "@odata\\.nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AccountFilter"]] = None, odata_next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A collection of AccountFilter items.
        :paramtype value: list[~azure.mgmt.media.models.AccountFilter]
        :keyword odata_next_link: A link to the next page of the collection (when the collection
         contains too many results to return in one response).
        :paramtype odata_next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.odata_next_link = odata_next_link


class AkamaiAccessControl(_serialization.Model):
    """Akamai access control.

    :ivar akamai_signature_header_authentication_key_list: authentication key list.
    :vartype akamai_signature_header_authentication_key_list:
     list[~azure.mgmt.media.models.AkamaiSignatureHeaderAuthenticationKey]
    """

    _attribute_map = {
        "akamai_signature_header_authentication_key_list": {
            "key": "akamaiSignatureHeaderAuthenticationKeyList",
            "type": "[AkamaiSignatureHeaderAuthenticationKey]",
        },
    }

    def __init__(
        self,
        *,
        akamai_signature_header_authentication_key_list: Optional[
            List["_models.AkamaiSignatureHeaderAuthenticationKey"]
        ] = None,
        **kwargs
    ):
        """
        :keyword akamai_signature_header_authentication_key_list: authentication key list.
        :paramtype akamai_signature_header_authentication_key_list:
         list[~azure.mgmt.media.models.AkamaiSignatureHeaderAuthenticationKey]
        """
        super().__init__(**kwargs)
        self.akamai_signature_header_authentication_key_list = akamai_signature_header_authentication_key_list


class AkamaiSignatureHeaderAuthenticationKey(_serialization.Model):
    """Akamai Signature Header authentication key.

    :ivar identifier: identifier of the key.
    :vartype identifier: str
    :ivar base64_key: authentication key.
    :vartype base64_key: str
    :ivar expiration: The expiration time of the authentication key.
    :vartype expiration: ~datetime.datetime
    """

    _attribute_map = {
        "identifier": {"key": "identifier", "type": "str"},
        "base64_key": {"key": "base64Key", "type": "str"},
        "expiration": {"key": "expiration", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        identifier: Optional[str] = None,
        base64_key: Optional[str] = None,
        expiration: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword identifier: identifier of the key.
        :paramtype identifier: str
        :keyword base64_key: authentication key.
        :paramtype base64_key: str
        :keyword expiration: The expiration time of the authentication key.
        :paramtype expiration: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.identifier = identifier
        self.base64_key = base64_key
        self.expiration = expiration


class ArmStreamingEndpointCapacity(_serialization.Model):
    """The streaming endpoint sku capacity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar scale_type:
    :vartype scale_type: str
    :ivar default: The streaming endpoint default capacity.
    :vartype default: int
    :ivar minimum: The streaming endpoint minimum capacity.
    :vartype minimum: int
    :ivar maximum: The streaming endpoint maximum capacity.
    :vartype maximum: int
    """

    _validation = {
        "scale_type": {"readonly": True},
    }

    _attribute_map = {
        "scale_type": {"key": "scaleType", "type": "str"},
        "default": {"key": "default", "type": "int"},
        "minimum": {"key": "minimum", "type": "int"},
        "maximum": {"key": "maximum", "type": "int"},
    }

    def __init__(
        self, *, default: Optional[int] = None, minimum: Optional[int] = None, maximum: Optional[int] = None, **kwargs
    ):
        """
        :keyword default: The streaming endpoint default capacity.
        :paramtype default: int
        :keyword minimum: The streaming endpoint minimum capacity.
        :paramtype minimum: int
        :keyword maximum: The streaming endpoint maximum capacity.
        :paramtype maximum: int
        """
        super().__init__(**kwargs)
        self.scale_type = None
        self.default = default
        self.minimum = minimum
        self.maximum = maximum


class ArmStreamingEndpointCurrentSku(_serialization.Model):
    """The streaming endpoint current sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The streaming endpoint sku name.
    :vartype name: str
    :ivar capacity: The streaming endpoint sku capacity.
    :vartype capacity: int
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(self, *, capacity: Optional[int] = None, **kwargs):
        """
        :keyword capacity: The streaming endpoint sku capacity.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = None
        self.capacity = capacity


class ArmStreamingEndpointSku(_serialization.Model):
    """The streaming endpoint sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The streaming endpoint sku name.
    :vartype name: str
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None


class ArmStreamingEndpointSkuInfo(_serialization.Model):
    """ArmStreamingEndpointSkuInfo.

    :ivar resource_type:
    :vartype resource_type: str
    :ivar capacity: The streaming endpoint sku capacity.
    :vartype capacity: ~azure.mgmt.media.models.ArmStreamingEndpointCapacity
    :ivar sku: The streaming endpoint sku.
    :vartype sku: ~azure.mgmt.media.models.ArmStreamingEndpointSku
    """

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "capacity": {"key": "capacity", "type": "ArmStreamingEndpointCapacity"},
        "sku": {"key": "sku", "type": "ArmStreamingEndpointSku"},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        capacity: Optional["_models.ArmStreamingEndpointCapacity"] = None,
        sku: Optional["_models.ArmStreamingEndpointSku"] = None,
        **kwargs
    ):
        """
        :keyword resource_type:
        :paramtype resource_type: str
        :keyword capacity: The streaming endpoint sku capacity.
        :paramtype capacity: ~azure.mgmt.media.models.ArmStreamingEndpointCapacity
        :keyword sku: The streaming endpoint sku.
        :paramtype sku: ~azure.mgmt.media.models.ArmStreamingEndpointSku
        """
        super().__init__(**kwargs)
        self.resource_type = resource_type
        self.capacity = capacity
        self.sku = sku


class Asset(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """An Asset.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    :ivar asset_id: The Asset ID.
    :vartype asset_id: str
    :ivar created: The creation date of the Asset.
    :vartype created: ~datetime.datetime
    :ivar last_modified: The last modified date of the Asset.
    :vartype last_modified: ~datetime.datetime
    :ivar alternate_id: The alternate ID of the Asset.
    :vartype alternate_id: str
    :ivar description: The Asset description.
    :vartype description: str
    :ivar container: The name of the asset blob container.
    :vartype container: str
    :ivar storage_account_name: The name of the storage account.
    :vartype storage_account_name: str
    :ivar storage_encryption_format: The Asset encryption format. One of None or
     MediaStorageEncryption. Known values are: "None" and "MediaStorageClientEncryption".
    :vartype storage_encryption_format: str or
     ~azure.mgmt.media.models.AssetStorageEncryptionFormat
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "asset_id": {"readonly": True},
        "created": {"readonly": True},
        "last_modified": {"readonly": True},
        "storage_encryption_format": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "asset_id": {"key": "properties.assetId", "type": "str"},
        "created": {"key": "properties.created", "type": "iso-8601"},
        "last_modified": {"key": "properties.lastModified", "type": "iso-8601"},
        "alternate_id": {"key": "properties.alternateId", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "container": {"key": "properties.container", "type": "str"},
        "storage_account_name": {"key": "properties.storageAccountName", "type": "str"},
        "storage_encryption_format": {"key": "properties.storageEncryptionFormat", "type": "str"},
    }

    def __init__(
        self,
        *,
        alternate_id: Optional[str] = None,
        description: Optional[str] = None,
        container: Optional[str] = None,
        storage_account_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword alternate_id: The alternate ID of the Asset.
        :paramtype alternate_id: str
        :keyword description: The Asset description.
        :paramtype description: str
        :keyword container: The name of the asset blob container.
        :paramtype container: str
        :keyword storage_account_name: The name of the storage account.
        :paramtype storage_account_name: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.asset_id = None
        self.created = None
        self.last_modified = None
        self.alternate_id = alternate_id
        self.description = description
        self.container = container
        self.storage_account_name = storage_account_name
        self.storage_encryption_format = None


class AssetCollection(_serialization.Model):
    """A collection of Asset items.

    :ivar value: A collection of Asset items.
    :vartype value: list[~azure.mgmt.media.models.Asset]
    :ivar odata_next_link: A link to the next page of the collection (when the collection contains
     too many results to return in one response).
    :vartype odata_next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Asset]"},
        "odata_next_link": {"key": "@odata\\.nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Asset"]] = None, odata_next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A collection of Asset items.
        :paramtype value: list[~azure.mgmt.media.models.Asset]
        :keyword odata_next_link: A link to the next page of the collection (when the collection
         contains too many results to return in one response).
        :paramtype odata_next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.odata_next_link = odata_next_link


class AssetContainerSas(_serialization.Model):
    """The Asset Storage container SAS URLs.

    :ivar asset_container_sas_urls: The list of Asset container SAS URLs.
    :vartype asset_container_sas_urls: list[str]
    """

    _attribute_map = {
        "asset_container_sas_urls": {"key": "assetContainerSasUrls", "type": "[str]"},
    }

    def __init__(self, *, asset_container_sas_urls: Optional[List[str]] = None, **kwargs):
        """
        :keyword asset_container_sas_urls: The list of Asset container SAS URLs.
        :paramtype asset_container_sas_urls: list[str]
        """
        super().__init__(**kwargs)
        self.asset_container_sas_urls = asset_container_sas_urls


class AssetFileEncryptionMetadata(_serialization.Model):
    """The Asset File Storage encryption metadata.

    All required parameters must be populated in order to send to Azure.

    :ivar initialization_vector: The Asset File initialization vector.
    :vartype initialization_vector: str
    :ivar asset_file_name: The Asset File name.
    :vartype asset_file_name: str
    :ivar asset_file_id: The Asset File Id. Required.
    :vartype asset_file_id: str
    """

    _validation = {
        "asset_file_id": {"required": True},
    }

    _attribute_map = {
        "initialization_vector": {"key": "initializationVector", "type": "str"},
        "asset_file_name": {"key": "assetFileName", "type": "str"},
        "asset_file_id": {"key": "assetFileId", "type": "str"},
    }

    def __init__(
        self,
        *,
        asset_file_id: str,
        initialization_vector: Optional[str] = None,
        asset_file_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword initialization_vector: The Asset File initialization vector.
        :paramtype initialization_vector: str
        :keyword asset_file_name: The Asset File name.
        :paramtype asset_file_name: str
        :keyword asset_file_id: The Asset File Id. Required.
        :paramtype asset_file_id: str
        """
        super().__init__(**kwargs)
        self.initialization_vector = initialization_vector
        self.asset_file_name = asset_file_name
        self.asset_file_id = asset_file_id


class AssetFilter(ProxyResource):
    """An Asset Filter.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    :ivar presentation_time_range: The presentation time range.
    :vartype presentation_time_range: ~azure.mgmt.media.models.PresentationTimeRange
    :ivar first_quality: The first quality.
    :vartype first_quality: ~azure.mgmt.media.models.FirstQuality
    :ivar tracks: The tracks selection conditions.
    :vartype tracks: list[~azure.mgmt.media.models.FilterTrackSelection]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "presentation_time_range": {"key": "properties.presentationTimeRange", "type": "PresentationTimeRange"},
        "first_quality": {"key": "properties.firstQuality", "type": "FirstQuality"},
        "tracks": {"key": "properties.tracks", "type": "[FilterTrackSelection]"},
    }

    def __init__(
        self,
        *,
        presentation_time_range: Optional["_models.PresentationTimeRange"] = None,
        first_quality: Optional["_models.FirstQuality"] = None,
        tracks: Optional[List["_models.FilterTrackSelection"]] = None,
        **kwargs
    ):
        """
        :keyword presentation_time_range: The presentation time range.
        :paramtype presentation_time_range: ~azure.mgmt.media.models.PresentationTimeRange
        :keyword first_quality: The first quality.
        :paramtype first_quality: ~azure.mgmt.media.models.FirstQuality
        :keyword tracks: The tracks selection conditions.
        :paramtype tracks: list[~azure.mgmt.media.models.FilterTrackSelection]
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.presentation_time_range = presentation_time_range
        self.first_quality = first_quality
        self.tracks = tracks


class AssetFilterCollection(_serialization.Model):
    """A collection of AssetFilter items.

    :ivar value: A collection of AssetFilter items.
    :vartype value: list[~azure.mgmt.media.models.AssetFilter]
    :ivar odata_next_link: A link to the next page of the collection (when the collection contains
     too many results to return in one response).
    :vartype odata_next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AssetFilter]"},
        "odata_next_link": {"key": "@odata\\.nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AssetFilter"]] = None, odata_next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A collection of AssetFilter items.
        :paramtype value: list[~azure.mgmt.media.models.AssetFilter]
        :keyword odata_next_link: A link to the next page of the collection (when the collection
         contains too many results to return in one response).
        :paramtype odata_next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.odata_next_link = odata_next_link


class AssetStreamingLocator(_serialization.Model):
    """Properties of the Streaming Locator.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Streaming Locator name.
    :vartype name: str
    :ivar asset_name: Asset Name.
    :vartype asset_name: str
    :ivar created: The creation time of the Streaming Locator.
    :vartype created: ~datetime.datetime
    :ivar start_time: The start time of the Streaming Locator.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the Streaming Locator.
    :vartype end_time: ~datetime.datetime
    :ivar streaming_locator_id: StreamingLocatorId of the Streaming Locator.
    :vartype streaming_locator_id: str
    :ivar streaming_policy_name: Name of the Streaming Policy used by this Streaming Locator.
    :vartype streaming_policy_name: str
    :ivar default_content_key_policy_name: Name of the default ContentKeyPolicy used by this
     Streaming Locator.
    :vartype default_content_key_policy_name: str
    """

    _validation = {
        "name": {"readonly": True},
        "asset_name": {"readonly": True},
        "created": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "streaming_locator_id": {"readonly": True},
        "streaming_policy_name": {"readonly": True},
        "default_content_key_policy_name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "asset_name": {"key": "assetName", "type": "str"},
        "created": {"key": "created", "type": "iso-8601"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "streaming_locator_id": {"key": "streamingLocatorId", "type": "str"},
        "streaming_policy_name": {"key": "streamingPolicyName", "type": "str"},
        "default_content_key_policy_name": {"key": "defaultContentKeyPolicyName", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.asset_name = None
        self.created = None
        self.start_time = None
        self.end_time = None
        self.streaming_locator_id = None
        self.streaming_policy_name = None
        self.default_content_key_policy_name = None


class AssetTrack(ProxyResource):
    """An Asset Track resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar track: Detailed information about a track in the asset.
    :vartype track: ~azure.mgmt.media.models.TrackBase
    :ivar provisioning_state: Provisioning state of the asset track. Known values are: "Failed",
     "InProgress", and "Succeeded".
    :vartype provisioning_state: str or ~azure.mgmt.media.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "track": {"key": "properties.track", "type": "TrackBase"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, track: Optional["_models.TrackBase"] = None, **kwargs):
        """
        :keyword track: Detailed information about a track in the asset.
        :paramtype track: ~azure.mgmt.media.models.TrackBase
        """
        super().__init__(**kwargs)
        self.track = track
        self.provisioning_state = None


class AssetTrackCollection(_serialization.Model):
    """A collection of AssetTrack items.

    :ivar value: A collection of AssetTrack items.
    :vartype value: list[~azure.mgmt.media.models.AssetTrack]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AssetTrack]"},
    }

    def __init__(self, *, value: Optional[List["_models.AssetTrack"]] = None, **kwargs):
        """
        :keyword value: A collection of AssetTrack items.
        :paramtype value: list[~azure.mgmt.media.models.AssetTrack]
        """
        super().__init__(**kwargs)
        self.value = value


class AssetTrackOperationStatus(_serialization.Model):
    """Status of asset track operation.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Operation identifier. Required.
    :vartype name: str
    :ivar id: Operation resource ID.
    :vartype id: str
    :ivar start_time: Operation start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Operation end time.
    :vartype end_time: ~datetime.datetime
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar error: The error detail.
    :vartype error: ~azure.mgmt.media.models.ErrorDetail
    """

    _validation = {
        "name": {"required": True},
        "status": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(
        self,
        *,
        name: str,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        error: Optional["_models.ErrorDetail"] = None,
        **kwargs
    ):
        """
        :keyword name: Operation identifier. Required.
        :paramtype name: str
        :keyword id: Operation resource ID.
        :paramtype id: str
        :keyword start_time: Operation start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Operation end time.
        :paramtype end_time: ~datetime.datetime
        :keyword status: Operation status. Required.
        :paramtype status: str
        :keyword error: The error detail.
        :paramtype error: ~azure.mgmt.media.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.start_time = start_time
        self.end_time = end_time
        self.status = status
        self.error = error


class AsyncOperationResult(_serialization.Model):
    """The status of an async operation.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.media.models.ErrorDetail
    :ivar name: Operation Id of the async operation.
    :vartype name: str
    :ivar status: Operation status of the async operation. Known values are: "Succeeded", "Failed",
     and "InProgress".
    :vartype status: str or ~azure.mgmt.media.models.AsyncOperationStatus
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
        name: Optional[str] = None,
        status: Optional[Union[str, "_models.AsyncOperationStatus"]] = None,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.media.models.ErrorDetail
        :keyword name: Operation Id of the async operation.
        :paramtype name: str
        :keyword status: Operation status of the async operation. Known values are: "Succeeded",
         "Failed", and "InProgress".
        :paramtype status: str or ~azure.mgmt.media.models.AsyncOperationStatus
        """
        super().__init__(**kwargs)
        self.error = error
        self.name = name
        self.status = status


class Preset(_serialization.Model):
    """Base type for all Presets, which define the recipe or instructions on how the input media files should be processed.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AudioAnalyzerPreset, BuiltInStandardEncoderPreset, FaceDetectorPreset, StandardEncoderPreset

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
    }

    _subtype_map = {
        "odata_type": {
            "#Microsoft.Media.AudioAnalyzerPreset": "AudioAnalyzerPreset",
            "#Microsoft.Media.BuiltInStandardEncoderPreset": "BuiltInStandardEncoderPreset",
            "#Microsoft.Media.FaceDetectorPreset": "FaceDetectorPreset",
            "#Microsoft.Media.StandardEncoderPreset": "StandardEncoderPreset",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class AudioAnalyzerPreset(Preset):
    """The Audio Analyzer preset applies a pre-defined set of AI-based analysis operations, including speech transcription. Currently, the preset supports processing of content with a single audio track.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    VideoAnalyzerPreset

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar audio_language: The language for the audio payload in the input using the BCP-47 format
     of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is
     recommended that you specify it. The language must be specified explicitly for
     AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If
     the language isn't specified or set to null, automatic language detection will choose the first
     language detected and process with the selected language for the duration of the file. It does
     not currently support dynamically switching between languages after the first language is
     detected. The automatic detection works best with audio recordings with clearly discernable
     speech. If automatic detection fails to find the language, transcription would fallback to
     'en-US'." The list of supported languages is available here:
     https://go.microsoft.com/fwlink/?linkid=2109463.
    :vartype audio_language: str
    :ivar mode: Determines the set of audio analysis operations to be performed. If unspecified,
     the Standard AudioAnalysisMode would be chosen. Known values are: "Standard" and "Basic".
    :vartype mode: str or ~azure.mgmt.media.models.AudioAnalysisMode
    :ivar experimental_options: Dictionary containing key value pairs for parameters not exposed in
     the preset itself.
    :vartype experimental_options: dict[str, str]
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "audio_language": {"key": "audioLanguage", "type": "str"},
        "mode": {"key": "mode", "type": "str"},
        "experimental_options": {"key": "experimentalOptions", "type": "{str}"},
    }

    _subtype_map = {"odata_type": {"#Microsoft.Media.VideoAnalyzerPreset": "VideoAnalyzerPreset"}}

    def __init__(
        self,
        *,
        audio_language: Optional[str] = None,
        mode: Optional[Union[str, "_models.AudioAnalysisMode"]] = None,
        experimental_options: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword audio_language: The language for the audio payload in the input using the BCP-47
         format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it
         is recommended that you specify it. The language must be specified explicitly for
         AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If
         the language isn't specified or set to null, automatic language detection will choose the first
         language detected and process with the selected language for the duration of the file. It does
         not currently support dynamically switching between languages after the first language is
         detected. The automatic detection works best with audio recordings with clearly discernable
         speech. If automatic detection fails to find the language, transcription would fallback to
         'en-US'." The list of supported languages is available here:
         https://go.microsoft.com/fwlink/?linkid=2109463.
        :paramtype audio_language: str
        :keyword mode: Determines the set of audio analysis operations to be performed. If unspecified,
         the Standard AudioAnalysisMode would be chosen. Known values are: "Standard" and "Basic".
        :paramtype mode: str or ~azure.mgmt.media.models.AudioAnalysisMode
        :keyword experimental_options: Dictionary containing key value pairs for parameters not exposed
         in the preset itself.
        :paramtype experimental_options: dict[str, str]
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.AudioAnalyzerPreset"  # type: str
        self.audio_language = audio_language
        self.mode = mode
        self.experimental_options = experimental_options


class Overlay(_serialization.Model):
    """Base type for all overlays - image, audio or video.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AudioOverlay, VideoOverlay

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar input_label: The label of the job input which is to be used as an overlay. The Input must
     specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an
     audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See
     https://aka.ms/mesformats for the complete list of supported audio and video file formats.
     Required.
    :vartype input_label: str
    :ivar start: The start position, with reference to the input video, at which the overlay
     starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5
     seconds into the input video. If not specified the overlay starts from the beginning of the
     input video.
    :vartype start: ~datetime.timedelta
    :ivar end: The end position, with reference to the input video, at which the overlay ends. The
     value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into
     the input video. If not specified or the value is greater than the input video duration, the
     overlay will be applied until the end of the input video if the overlay media duration is
     greater than the input video duration, else the overlay will last as long as the overlay media
     duration.
    :vartype end: ~datetime.timedelta
    :ivar fade_in_duration: The duration over which the overlay fades in onto the input video. The
     value should be in ISO 8601 duration format. If not specified the default behavior is to have
     no fade in (same as PT0S).
    :vartype fade_in_duration: ~datetime.timedelta
    :ivar fade_out_duration: The duration over which the overlay fades out of the input video. The
     value should be in ISO 8601 duration format. If not specified the default behavior is to have
     no fade out (same as PT0S).
    :vartype fade_out_duration: ~datetime.timedelta
    :ivar audio_gain_level: The gain level of audio in the overlay. The value should be in the
     range [0, 1.0]. The default is 1.0.
    :vartype audio_gain_level: float
    """

    _validation = {
        "odata_type": {"required": True},
        "input_label": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "input_label": {"key": "inputLabel", "type": "str"},
        "start": {"key": "start", "type": "duration"},
        "end": {"key": "end", "type": "duration"},
        "fade_in_duration": {"key": "fadeInDuration", "type": "duration"},
        "fade_out_duration": {"key": "fadeOutDuration", "type": "duration"},
        "audio_gain_level": {"key": "audioGainLevel", "type": "float"},
    }

    _subtype_map = {
        "odata_type": {"#Microsoft.Media.AudioOverlay": "AudioOverlay", "#Microsoft.Media.VideoOverlay": "VideoOverlay"}
    }

    def __init__(
        self,
        *,
        input_label: str,
        start: Optional[datetime.timedelta] = None,
        end: Optional[datetime.timedelta] = None,
        fade_in_duration: Optional[datetime.timedelta] = None,
        fade_out_duration: Optional[datetime.timedelta] = None,
        audio_gain_level: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword input_label: The label of the job input which is to be used as an overlay. The Input
         must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or
         an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See
         https://aka.ms/mesformats for the complete list of supported audio and video file formats.
         Required.
        :paramtype input_label: str
        :keyword start: The start position, with reference to the input video, at which the overlay
         starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5
         seconds into the input video. If not specified the overlay starts from the beginning of the
         input video.
        :paramtype start: ~datetime.timedelta
        :keyword end: The end position, with reference to the input video, at which the overlay ends.
         The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds
         into the input video. If not specified or the value is greater than the input video duration,
         the overlay will be applied until the end of the input video if the overlay media duration is
         greater than the input video duration, else the overlay will last as long as the overlay media
         duration.
        :paramtype end: ~datetime.timedelta
        :keyword fade_in_duration: The duration over which the overlay fades in onto the input video.
         The value should be in ISO 8601 duration format. If not specified the default behavior is to
         have no fade in (same as PT0S).
        :paramtype fade_in_duration: ~datetime.timedelta
        :keyword fade_out_duration: The duration over which the overlay fades out of the input video.
         The value should be in ISO 8601 duration format. If not specified the default behavior is to
         have no fade out (same as PT0S).
        :paramtype fade_out_duration: ~datetime.timedelta
        :keyword audio_gain_level: The gain level of audio in the overlay. The value should be in the
         range [0, 1.0]. The default is 1.0.
        :paramtype audio_gain_level: float
        """
        super().__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.input_label = input_label
        self.start = start
        self.end = end
        self.fade_in_duration = fade_in_duration
        self.fade_out_duration = fade_out_duration
        self.audio_gain_level = audio_gain_level


class AudioOverlay(Overlay):
    """Describes the properties of an audio overlay.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar input_label: The label of the job input which is to be used as an overlay. The Input must
     specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an
     audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See
     https://aka.ms/mesformats for the complete list of supported audio and video file formats.
     Required.
    :vartype input_label: str
    :ivar start: The start position, with reference to the input video, at which the overlay
     starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5
     seconds into the input video. If not specified the overlay starts from the beginning of the
     input video.
    :vartype start: ~datetime.timedelta
    :ivar end: The end position, with reference to the input video, at which the overlay ends. The
     value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into
     the input video. If not specified or the value is greater than the input video duration, the
     overlay will be applied until the end of the input video if the overlay media duration is
     greater than the input video duration, else the overlay will last as long as the overlay media
     duration.
    :vartype end: ~datetime.timedelta
    :ivar fade_in_duration: The duration over which the overlay fades in onto the input video. The
     value should be in ISO 8601 duration format. If not specified the default behavior is to have
     no fade in (same as PT0S).
    :vartype fade_in_duration: ~datetime.timedelta
    :ivar fade_out_duration: The duration over which the overlay fades out of the input video. The
     value should be in ISO 8601 duration format. If not specified the default behavior is to have
     no fade out (same as PT0S).
    :vartype fade_out_duration: ~datetime.timedelta
    :ivar audio_gain_level: The gain level of audio in the overlay. The value should be in the
     range [0, 1.0]. The default is 1.0.
    :vartype audio_gain_level: float
    """

    _validation = {
        "odata_type": {"required": True},
        "input_label": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "input_label": {"key": "inputLabel", "type": "str"},
        "start": {"key": "start", "type": "duration"},
        "end": {"key": "end", "type": "duration"},
        "fade_in_duration": {"key": "fadeInDuration", "type": "duration"},
        "fade_out_duration": {"key": "fadeOutDuration", "type": "duration"},
        "audio_gain_level": {"key": "audioGainLevel", "type": "float"},
    }

    def __init__(
        self,
        *,
        input_label: str,
        start: Optional[datetime.timedelta] = None,
        end: Optional[datetime.timedelta] = None,
        fade_in_duration: Optional[datetime.timedelta] = None,
        fade_out_duration: Optional[datetime.timedelta] = None,
        audio_gain_level: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword input_label: The label of the job input which is to be used as an overlay. The Input
         must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or
         an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See
         https://aka.ms/mesformats for the complete list of supported audio and video file formats.
         Required.
        :paramtype input_label: str
        :keyword start: The start position, with reference to the input video, at which the overlay
         starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5
         seconds into the input video. If not specified the overlay starts from the beginning of the
         input video.
        :paramtype start: ~datetime.timedelta
        :keyword end: The end position, with reference to the input video, at which the overlay ends.
         The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds
         into the input video. If not specified or the value is greater than the input video duration,
         the overlay will be applied until the end of the input video if the overlay media duration is
         greater than the input video duration, else the overlay will last as long as the overlay media
         duration.
        :paramtype end: ~datetime.timedelta
        :keyword fade_in_duration: The duration over which the overlay fades in onto the input video.
         The value should be in ISO 8601 duration format. If not specified the default behavior is to
         have no fade in (same as PT0S).
        :paramtype fade_in_duration: ~datetime.timedelta
        :keyword fade_out_duration: The duration over which the overlay fades out of the input video.
         The value should be in ISO 8601 duration format. If not specified the default behavior is to
         have no fade out (same as PT0S).
        :paramtype fade_out_duration: ~datetime.timedelta
        :keyword audio_gain_level: The gain level of audio in the overlay. The value should be in the
         range [0, 1.0]. The default is 1.0.
        :paramtype audio_gain_level: float
        """
        super().__init__(
            input_label=input_label,
            start=start,
            end=end,
            fade_in_duration=fade_in_duration,
            fade_out_duration=fade_out_duration,
            audio_gain_level=audio_gain_level,
            **kwargs
        )
        self.odata_type = "#Microsoft.Media.AudioOverlay"  # type: str


class TrackBase(_serialization.Model):
    """Base type for concrete track types. A derived type must be used to represent the Track.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AudioTrack, TextTrack, VideoTrack

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
    }

    _subtype_map = {
        "odata_type": {
            "#Microsoft.Media.AudioTrack": "AudioTrack",
            "#Microsoft.Media.TextTrack": "TextTrack",
            "#Microsoft.Media.VideoTrack": "VideoTrack",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class AudioTrack(TrackBase):
    """Represents an audio track in the asset.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar file_name: The file name to the source file. This file is located in the storage
     container of the asset.
    :vartype file_name: str
    :ivar display_name: The display name of the audio track on a video player. In HLS, this maps to
     the NAME attribute of EXT-X-MEDIA.
    :vartype display_name: str
    :ivar language_code: The RFC5646 language code for the audio track.
    :vartype language_code: str
    :ivar hls_settings: The HLS specific setting for the audio track.
    :vartype hls_settings: ~azure.mgmt.media.models.HlsSettings
    :ivar dash_settings: The DASH specific setting for the audio track.
    :vartype dash_settings: ~azure.mgmt.media.models.DashSettings
    :ivar mpeg4_track_id: The MPEG-4 audio track ID for the audio track.
    :vartype mpeg4_track_id: int
    :ivar bit_rate: The stream bit rate for the audio track.
    :vartype bit_rate: int
    """

    _validation = {
        "odata_type": {"required": True},
        "bit_rate": {"readonly": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "language_code": {"key": "languageCode", "type": "str"},
        "hls_settings": {"key": "hlsSettings", "type": "HlsSettings"},
        "dash_settings": {"key": "dashSettings", "type": "DashSettings"},
        "mpeg4_track_id": {"key": "mpeg4TrackId", "type": "int"},
        "bit_rate": {"key": "bitRate", "type": "int"},
    }

    def __init__(
        self,
        *,
        file_name: Optional[str] = None,
        display_name: Optional[str] = None,
        language_code: Optional[str] = None,
        hls_settings: Optional["_models.HlsSettings"] = None,
        dash_settings: Optional["_models.DashSettings"] = None,
        mpeg4_track_id: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword file_name: The file name to the source file. This file is located in the storage
         container of the asset.
        :paramtype file_name: str
        :keyword display_name: The display name of the audio track on a video player. In HLS, this maps
         to the NAME attribute of EXT-X-MEDIA.
        :paramtype display_name: str
        :keyword language_code: The RFC5646 language code for the audio track.
        :paramtype language_code: str
        :keyword hls_settings: The HLS specific setting for the audio track.
        :paramtype hls_settings: ~azure.mgmt.media.models.HlsSettings
        :keyword dash_settings: The DASH specific setting for the audio track.
        :paramtype dash_settings: ~azure.mgmt.media.models.DashSettings
        :keyword mpeg4_track_id: The MPEG-4 audio track ID for the audio track.
        :paramtype mpeg4_track_id: int
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.AudioTrack"  # type: str
        self.file_name = file_name
        self.display_name = display_name
        self.language_code = language_code
        self.hls_settings = hls_settings
        self.dash_settings = dash_settings
        self.mpeg4_track_id = mpeg4_track_id
        self.bit_rate = None


class TrackDescriptor(_serialization.Model):
    """Base type for all TrackDescriptor types, which define the metadata and selection for tracks that should be processed by a Job.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AudioTrackDescriptor, VideoTrackDescriptor

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
    }

    _subtype_map = {
        "odata_type": {
            "#Microsoft.Media.AudioTrackDescriptor": "AudioTrackDescriptor",
            "#Microsoft.Media.VideoTrackDescriptor": "VideoTrackDescriptor",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class AudioTrackDescriptor(TrackDescriptor):
    """A TrackSelection to select audio tracks.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    SelectAudioTrackByAttribute, SelectAudioTrackById

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar channel_mapping: Optional designation for single channel audio tracks.  Can be used to
     combine the tracks into stereo or multi-channel audio tracks. Known values are: "FrontLeft",
     "FrontRight", "Center", "LowFrequencyEffects", "BackLeft", "BackRight", "StereoLeft", and
     "StereoRight".
    :vartype channel_mapping: str or ~azure.mgmt.media.models.ChannelMapping
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "channel_mapping": {"key": "channelMapping", "type": "str"},
    }

    _subtype_map = {
        "odata_type": {
            "#Microsoft.Media.SelectAudioTrackByAttribute": "SelectAudioTrackByAttribute",
            "#Microsoft.Media.SelectAudioTrackById": "SelectAudioTrackById",
        }
    }

    def __init__(self, *, channel_mapping: Optional[Union[str, "_models.ChannelMapping"]] = None, **kwargs):
        """
        :keyword channel_mapping: Optional designation for single channel audio tracks.  Can be used to
         combine the tracks into stereo or multi-channel audio tracks. Known values are: "FrontLeft",
         "FrontRight", "Center", "LowFrequencyEffects", "BackLeft", "BackRight", "StereoLeft", and
         "StereoRight".
        :paramtype channel_mapping: str or ~azure.mgmt.media.models.ChannelMapping
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.AudioTrackDescriptor"  # type: str
        self.channel_mapping = channel_mapping


class BuiltInStandardEncoderPreset(Preset):
    """Describes a built-in preset for encoding the input video with the Standard Encoder.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar configurations: Optional configuration settings for encoder. Configurations is only
     supported for ContentAwareEncoding and H265ContentAwareEncoding BuiltInStandardEncoderPreset.
    :vartype configurations: ~azure.mgmt.media.models.PresetConfigurations
    :ivar preset_name: The built-in preset to be used for encoding videos. Required. Known values
     are: "H264SingleBitrateSD", "H264SingleBitrate720p", "H264SingleBitrate1080p",
     "AdaptiveStreaming", "AACGoodQualityAudio", "ContentAwareEncodingExperimental",
     "ContentAwareEncoding", "CopyAllBitrateNonInterleaved", "H264MultipleBitrate1080p",
     "H264MultipleBitrate720p", "H264MultipleBitrateSD", "H265ContentAwareEncoding",
     "H265AdaptiveStreaming", "H265SingleBitrate720p", "H265SingleBitrate1080p", and
     "H265SingleBitrate4K".
    :vartype preset_name: str or ~azure.mgmt.media.models.EncoderNamedPreset
    """

    _validation = {
        "odata_type": {"required": True},
        "preset_name": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "configurations": {"key": "configurations", "type": "PresetConfigurations"},
        "preset_name": {"key": "presetName", "type": "str"},
    }

    def __init__(
        self,
        *,
        preset_name: Union[str, "_models.EncoderNamedPreset"],
        configurations: Optional["_models.PresetConfigurations"] = None,
        **kwargs
    ):
        """
        :keyword configurations: Optional configuration settings for encoder. Configurations is only
         supported for ContentAwareEncoding and H265ContentAwareEncoding BuiltInStandardEncoderPreset.
        :paramtype configurations: ~azure.mgmt.media.models.PresetConfigurations
        :keyword preset_name: The built-in preset to be used for encoding videos. Required. Known
         values are: "H264SingleBitrateSD", "H264SingleBitrate720p", "H264SingleBitrate1080p",
         "AdaptiveStreaming", "AACGoodQualityAudio", "ContentAwareEncodingExperimental",
         "ContentAwareEncoding", "CopyAllBitrateNonInterleaved", "H264MultipleBitrate1080p",
         "H264MultipleBitrate720p", "H264MultipleBitrateSD", "H265ContentAwareEncoding",
         "H265AdaptiveStreaming", "H265SingleBitrate720p", "H265SingleBitrate1080p", and
         "H265SingleBitrate4K".
        :paramtype preset_name: str or ~azure.mgmt.media.models.EncoderNamedPreset
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.BuiltInStandardEncoderPreset"  # type: str
        self.configurations = configurations
        self.preset_name = preset_name


class CbcsDrmConfiguration(_serialization.Model):
    """Class to specify DRM configurations of CommonEncryptionCbcs scheme in Streaming Policy.

    :ivar fair_play: FairPlay configurations.
    :vartype fair_play: ~azure.mgmt.media.models.StreamingPolicyFairPlayConfiguration
    :ivar play_ready: PlayReady configurations.
    :vartype play_ready: ~azure.mgmt.media.models.StreamingPolicyPlayReadyConfiguration
    :ivar widevine: Widevine configurations.
    :vartype widevine: ~azure.mgmt.media.models.StreamingPolicyWidevineConfiguration
    """

    _attribute_map = {
        "fair_play": {"key": "fairPlay", "type": "StreamingPolicyFairPlayConfiguration"},
        "play_ready": {"key": "playReady", "type": "StreamingPolicyPlayReadyConfiguration"},
        "widevine": {"key": "widevine", "type": "StreamingPolicyWidevineConfiguration"},
    }

    def __init__(
        self,
        *,
        fair_play: Optional["_models.StreamingPolicyFairPlayConfiguration"] = None,
        play_ready: Optional["_models.StreamingPolicyPlayReadyConfiguration"] = None,
        widevine: Optional["_models.StreamingPolicyWidevineConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword fair_play: FairPlay configurations.
        :paramtype fair_play: ~azure.mgmt.media.models.StreamingPolicyFairPlayConfiguration
        :keyword play_ready: PlayReady configurations.
        :paramtype play_ready: ~azure.mgmt.media.models.StreamingPolicyPlayReadyConfiguration
        :keyword widevine: Widevine configurations.
        :paramtype widevine: ~azure.mgmt.media.models.StreamingPolicyWidevineConfiguration
        """
        super().__init__(**kwargs)
        self.fair_play = fair_play
        self.play_ready = play_ready
        self.widevine = widevine


class CencDrmConfiguration(_serialization.Model):
    """Class to specify DRM configurations of CommonEncryptionCenc scheme in Streaming Policy.

    :ivar play_ready: PlayReady configurations.
    :vartype play_ready: ~azure.mgmt.media.models.StreamingPolicyPlayReadyConfiguration
    :ivar widevine: Widevine configurations.
    :vartype widevine: ~azure.mgmt.media.models.StreamingPolicyWidevineConfiguration
    """

    _attribute_map = {
        "play_ready": {"key": "playReady", "type": "StreamingPolicyPlayReadyConfiguration"},
        "widevine": {"key": "widevine", "type": "StreamingPolicyWidevineConfiguration"},
    }

    def __init__(
        self,
        *,
        play_ready: Optional["_models.StreamingPolicyPlayReadyConfiguration"] = None,
        widevine: Optional["_models.StreamingPolicyWidevineConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword play_ready: PlayReady configurations.
        :paramtype play_ready: ~azure.mgmt.media.models.StreamingPolicyPlayReadyConfiguration
        :keyword widevine: Widevine configurations.
        :paramtype widevine: ~azure.mgmt.media.models.StreamingPolicyWidevineConfiguration
        """
        super().__init__(**kwargs)
        self.play_ready = play_ready
        self.widevine = widevine


class CheckNameAvailabilityInput(_serialization.Model):
    """The input to the check name availability request.

    :ivar name: The account name.
    :vartype name: str
    :ivar type: The account type. For a Media Services account, this should be 'MediaServices'.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, type: Optional[str] = None, **kwargs):
        """
        :keyword name: The account name.
        :paramtype name: str
        :keyword type: The account type. For a Media Services account, this should be 'MediaServices'.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class ClearKeyEncryptionConfiguration(_serialization.Model):
    """Class to specify ClearKey configuration of common encryption schemes in Streaming Policy.

    :ivar custom_keys_acquisition_url_template: Template for the URL of the custom service
     delivering content keys to end user players. Not required when using Azure Media Services for
     issuing licenses. The template supports replaceable tokens that the service will update at
     runtime with the value specific to the request.  The currently supported token value is
     {AlternativeMediaId}, which is replaced with the value of
     StreamingLocatorId.AlternativeMediaId.
    :vartype custom_keys_acquisition_url_template: str
    """

    _attribute_map = {
        "custom_keys_acquisition_url_template": {"key": "customKeysAcquisitionUrlTemplate", "type": "str"},
    }

    def __init__(self, *, custom_keys_acquisition_url_template: Optional[str] = None, **kwargs):
        """
        :keyword custom_keys_acquisition_url_template: Template for the URL of the custom service
         delivering content keys to end user players. Not required when using Azure Media Services for
         issuing licenses. The template supports replaceable tokens that the service will update at
         runtime with the value specific to the request.  The currently supported token value is
         {AlternativeMediaId}, which is replaced with the value of
         StreamingLocatorId.AlternativeMediaId.
        :paramtype custom_keys_acquisition_url_template: str
        """
        super().__init__(**kwargs)
        self.custom_keys_acquisition_url_template = custom_keys_acquisition_url_template


class CommonEncryptionCbcs(_serialization.Model):
    """Class for CommonEncryptionCbcs encryption scheme.

    :ivar enabled_protocols: Representing supported protocols.
    :vartype enabled_protocols: ~azure.mgmt.media.models.EnabledProtocols
    :ivar clear_tracks: Representing which tracks should not be encrypted.
    :vartype clear_tracks: list[~azure.mgmt.media.models.TrackSelection]
    :ivar content_keys: Representing default content key for each encryption scheme and separate
     content keys for specific tracks.
    :vartype content_keys: ~azure.mgmt.media.models.StreamingPolicyContentKeys
    :ivar drm: Configuration of DRMs for current encryption scheme.
    :vartype drm: ~azure.mgmt.media.models.CbcsDrmConfiguration
    :ivar clear_key_encryption_configuration: Optional configuration supporting ClearKey in
     CommonEncryptionCbcs encryption scheme.
    :vartype clear_key_encryption_configuration:
     ~azure.mgmt.media.models.ClearKeyEncryptionConfiguration
    """

    _attribute_map = {
        "enabled_protocols": {"key": "enabledProtocols", "type": "EnabledProtocols"},
        "clear_tracks": {"key": "clearTracks", "type": "[TrackSelection]"},
        "content_keys": {"key": "contentKeys", "type": "StreamingPolicyContentKeys"},
        "drm": {"key": "drm", "type": "CbcsDrmConfiguration"},
        "clear_key_encryption_configuration": {
            "key": "clearKeyEncryptionConfiguration",
            "type": "ClearKeyEncryptionConfiguration",
        },
    }

    def __init__(
        self,
        *,
        enabled_protocols: Optional["_models.EnabledProtocols"] = None,
        clear_tracks: Optional[List["_models.TrackSelection"]] = None,
        content_keys: Optional["_models.StreamingPolicyContentKeys"] = None,
        drm: Optional["_models.CbcsDrmConfiguration"] = None,
        clear_key_encryption_configuration: Optional["_models.ClearKeyEncryptionConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword enabled_protocols: Representing supported protocols.
        :paramtype enabled_protocols: ~azure.mgmt.media.models.EnabledProtocols
        :keyword clear_tracks: Representing which tracks should not be encrypted.
        :paramtype clear_tracks: list[~azure.mgmt.media.models.TrackSelection]
        :keyword content_keys: Representing default content key for each encryption scheme and separate
         content keys for specific tracks.
        :paramtype content_keys: ~azure.mgmt.media.models.StreamingPolicyContentKeys
        :keyword drm: Configuration of DRMs for current encryption scheme.
        :paramtype drm: ~azure.mgmt.media.models.CbcsDrmConfiguration
        :keyword clear_key_encryption_configuration: Optional configuration supporting ClearKey in
         CommonEncryptionCbcs encryption scheme.
        :paramtype clear_key_encryption_configuration:
         ~azure.mgmt.media.models.ClearKeyEncryptionConfiguration
        """
        super().__init__(**kwargs)
        self.enabled_protocols = enabled_protocols
        self.clear_tracks = clear_tracks
        self.content_keys = content_keys
        self.drm = drm
        self.clear_key_encryption_configuration = clear_key_encryption_configuration


class CommonEncryptionCenc(_serialization.Model):
    """Class for envelope encryption scheme.

    :ivar enabled_protocols: Representing supported protocols.
    :vartype enabled_protocols: ~azure.mgmt.media.models.EnabledProtocols
    :ivar clear_tracks: Representing which tracks should not be encrypted.
    :vartype clear_tracks: list[~azure.mgmt.media.models.TrackSelection]
    :ivar content_keys: Representing default content key for each encryption scheme and separate
     content keys for specific tracks.
    :vartype content_keys: ~azure.mgmt.media.models.StreamingPolicyContentKeys
    :ivar drm: Configuration of DRMs for CommonEncryptionCenc encryption scheme.
    :vartype drm: ~azure.mgmt.media.models.CencDrmConfiguration
    :ivar clear_key_encryption_configuration: Optional configuration supporting ClearKey in
     CommonEncryptionCenc encryption scheme.
    :vartype clear_key_encryption_configuration:
     ~azure.mgmt.media.models.ClearKeyEncryptionConfiguration
    """

    _attribute_map = {
        "enabled_protocols": {"key": "enabledProtocols", "type": "EnabledProtocols"},
        "clear_tracks": {"key": "clearTracks", "type": "[TrackSelection]"},
        "content_keys": {"key": "contentKeys", "type": "StreamingPolicyContentKeys"},
        "drm": {"key": "drm", "type": "CencDrmConfiguration"},
        "clear_key_encryption_configuration": {
            "key": "clearKeyEncryptionConfiguration",
            "type": "ClearKeyEncryptionConfiguration",
        },
    }

    def __init__(
        self,
        *,
        enabled_protocols: Optional["_models.EnabledProtocols"] = None,
        clear_tracks: Optional[List["_models.TrackSelection"]] = None,
        content_keys: Optional["_models.StreamingPolicyContentKeys"] = None,
        drm: Optional["_models.CencDrmConfiguration"] = None,
        clear_key_encryption_configuration: Optional["_models.ClearKeyEncryptionConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword enabled_protocols: Representing supported protocols.
        :paramtype enabled_protocols: ~azure.mgmt.media.models.EnabledProtocols
        :keyword clear_tracks: Representing which tracks should not be encrypted.
        :paramtype clear_tracks: list[~azure.mgmt.media.models.TrackSelection]
        :keyword content_keys: Representing default content key for each encryption scheme and separate
         content keys for specific tracks.
        :paramtype content_keys: ~azure.mgmt.media.models.StreamingPolicyContentKeys
        :keyword drm: Configuration of DRMs for CommonEncryptionCenc encryption scheme.
        :paramtype drm: ~azure.mgmt.media.models.CencDrmConfiguration
        :keyword clear_key_encryption_configuration: Optional configuration supporting ClearKey in
         CommonEncryptionCenc encryption scheme.
        :paramtype clear_key_encryption_configuration:
         ~azure.mgmt.media.models.ClearKeyEncryptionConfiguration
        """
        super().__init__(**kwargs)
        self.enabled_protocols = enabled_protocols
        self.clear_tracks = clear_tracks
        self.content_keys = content_keys
        self.drm = drm
        self.clear_key_encryption_configuration = clear_key_encryption_configuration


class ContentKeyPolicy(ProxyResource):
    """A Content Key Policy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    :ivar policy_id: The legacy Policy ID.
    :vartype policy_id: str
    :ivar created: The creation date of the Policy.
    :vartype created: ~datetime.datetime
    :ivar last_modified: The last modified date of the Policy.
    :vartype last_modified: ~datetime.datetime
    :ivar description: A description for the Policy.
    :vartype description: str
    :ivar options: The Key Policy options.
    :vartype options: list[~azure.mgmt.media.models.ContentKeyPolicyOption]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "policy_id": {"readonly": True},
        "created": {"readonly": True},
        "last_modified": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "policy_id": {"key": "properties.policyId", "type": "str"},
        "created": {"key": "properties.created", "type": "iso-8601"},
        "last_modified": {"key": "properties.lastModified", "type": "iso-8601"},
        "description": {"key": "properties.description", "type": "str"},
        "options": {"key": "properties.options", "type": "[ContentKeyPolicyOption]"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        options: Optional[List["_models.ContentKeyPolicyOption"]] = None,
        **kwargs
    ):
        """
        :keyword description: A description for the Policy.
        :paramtype description: str
        :keyword options: The Key Policy options.
        :paramtype options: list[~azure.mgmt.media.models.ContentKeyPolicyOption]
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.policy_id = None
        self.created = None
        self.last_modified = None
        self.description = description
        self.options = options


class ContentKeyPolicyConfiguration(_serialization.Model):
    """Base class for Content Key Policy configuration. A derived class must be used to create a configuration.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ContentKeyPolicyClearKeyConfiguration, ContentKeyPolicyFairPlayConfiguration,
    ContentKeyPolicyPlayReadyConfiguration, ContentKeyPolicyUnknownConfiguration,
    ContentKeyPolicyWidevineConfiguration

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
    }

    _subtype_map = {
        "odata_type": {
            "#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration": "ContentKeyPolicyClearKeyConfiguration",
            "#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration": "ContentKeyPolicyFairPlayConfiguration",
            "#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration": "ContentKeyPolicyPlayReadyConfiguration",
            "#Microsoft.Media.ContentKeyPolicyUnknownConfiguration": "ContentKeyPolicyUnknownConfiguration",
            "#Microsoft.Media.ContentKeyPolicyWidevineConfiguration": "ContentKeyPolicyWidevineConfiguration",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class ContentKeyPolicyClearKeyConfiguration(ContentKeyPolicyConfiguration):
    """Represents a configuration for non-DRM keys.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.ContentKeyPolicyClearKeyConfiguration"  # type: str


class ContentKeyPolicyCollection(_serialization.Model):
    """A collection of ContentKeyPolicy items.

    :ivar value: A collection of ContentKeyPolicy items.
    :vartype value: list[~azure.mgmt.media.models.ContentKeyPolicy]
    :ivar odata_next_link: A link to the next page of the collection (when the collection contains
     too many results to return in one response).
    :vartype odata_next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ContentKeyPolicy]"},
        "odata_next_link": {"key": "@odata\\.nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ContentKeyPolicy"]] = None,
        odata_next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A collection of ContentKeyPolicy items.
        :paramtype value: list[~azure.mgmt.media.models.ContentKeyPolicy]
        :keyword odata_next_link: A link to the next page of the collection (when the collection
         contains too many results to return in one response).
        :paramtype odata_next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.odata_next_link = odata_next_link


class ContentKeyPolicyFairPlayConfiguration(ContentKeyPolicyConfiguration):
    """Specifies a configuration for FairPlay licenses.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar ask: The key that must be used as FairPlay Application Secret key. Required.
    :vartype ask: bytes
    :ivar fair_play_pfx_password: The password encrypting FairPlay certificate in PKCS 12 (pfx)
     format. Required.
    :vartype fair_play_pfx_password: str
    :ivar fair_play_pfx: The Base64 representation of FairPlay certificate in PKCS 12 (pfx) format
     (including private key). Required.
    :vartype fair_play_pfx: str
    :ivar rental_and_lease_key_type: The rental and lease key type. Required. Known values are:
     "Unknown", "Undefined", "DualExpiry", "PersistentUnlimited", and "PersistentLimited".
    :vartype rental_and_lease_key_type: str or
     ~azure.mgmt.media.models.ContentKeyPolicyFairPlayRentalAndLeaseKeyType
    :ivar rental_duration: The rental duration. Must be greater than or equal to 0. Required.
    :vartype rental_duration: int
    :ivar offline_rental_configuration: Offline rental policy.
    :vartype offline_rental_configuration:
     ~azure.mgmt.media.models.ContentKeyPolicyFairPlayOfflineRentalConfiguration
    """

    _validation = {
        "odata_type": {"required": True},
        "ask": {"required": True},
        "fair_play_pfx_password": {"required": True},
        "fair_play_pfx": {"required": True},
        "rental_and_lease_key_type": {"required": True},
        "rental_duration": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "ask": {"key": "ask", "type": "bytearray"},
        "fair_play_pfx_password": {"key": "fairPlayPfxPassword", "type": "str"},
        "fair_play_pfx": {"key": "fairPlayPfx", "type": "str"},
        "rental_and_lease_key_type": {"key": "rentalAndLeaseKeyType", "type": "str"},
        "rental_duration": {"key": "rentalDuration", "type": "int"},
        "offline_rental_configuration": {
            "key": "offlineRentalConfiguration",
            "type": "ContentKeyPolicyFairPlayOfflineRentalConfiguration",
        },
    }

    def __init__(
        self,
        *,
        ask: bytes,
        fair_play_pfx_password: str,
        fair_play_pfx: str,
        rental_and_lease_key_type: Union[str, "_models.ContentKeyPolicyFairPlayRentalAndLeaseKeyType"],
        rental_duration: int,
        offline_rental_configuration: Optional["_models.ContentKeyPolicyFairPlayOfflineRentalConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword ask: The key that must be used as FairPlay Application Secret key. Required.
        :paramtype ask: bytes
        :keyword fair_play_pfx_password: The password encrypting FairPlay certificate in PKCS 12 (pfx)
         format. Required.
        :paramtype fair_play_pfx_password: str
        :keyword fair_play_pfx: The Base64 representation of FairPlay certificate in PKCS 12 (pfx)
         format (including private key). Required.
        :paramtype fair_play_pfx: str
        :keyword rental_and_lease_key_type: The rental and lease key type. Required. Known values are:
         "Unknown", "Undefined", "DualExpiry", "PersistentUnlimited", and "PersistentLimited".
        :paramtype rental_and_lease_key_type: str or
         ~azure.mgmt.media.models.ContentKeyPolicyFairPlayRentalAndLeaseKeyType
        :keyword rental_duration: The rental duration. Must be greater than or equal to 0. Required.
        :paramtype rental_duration: int
        :keyword offline_rental_configuration: Offline rental policy.
        :paramtype offline_rental_configuration:
         ~azure.mgmt.media.models.ContentKeyPolicyFairPlayOfflineRentalConfiguration
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.ContentKeyPolicyFairPlayConfiguration"  # type: str
        self.ask = ask
        self.fair_play_pfx_password = fair_play_pfx_password
        self.fair_play_pfx = fair_play_pfx
        self.rental_and_lease_key_type = rental_and_lease_key_type
        self.rental_duration = rental_duration
        self.offline_rental_configuration = offline_rental_configuration


class ContentKeyPolicyFairPlayOfflineRentalConfiguration(_serialization.Model):
    """ContentKeyPolicyFairPlayOfflineRentalConfiguration.

    All required parameters must be populated in order to send to Azure.

    :ivar playback_duration_seconds: Playback duration. Required.
    :vartype playback_duration_seconds: int
    :ivar storage_duration_seconds: Storage duration. Required.
    :vartype storage_duration_seconds: int
    """

    _validation = {
        "playback_duration_seconds": {"required": True},
        "storage_duration_seconds": {"required": True},
    }

    _attribute_map = {
        "playback_duration_seconds": {"key": "playbackDurationSeconds", "type": "int"},
        "storage_duration_seconds": {"key": "storageDurationSeconds", "type": "int"},
    }

    def __init__(self, *, playback_duration_seconds: int, storage_duration_seconds: int, **kwargs):
        """
        :keyword playback_duration_seconds: Playback duration. Required.
        :paramtype playback_duration_seconds: int
        :keyword storage_duration_seconds: Storage duration. Required.
        :paramtype storage_duration_seconds: int
        """
        super().__init__(**kwargs)
        self.playback_duration_seconds = playback_duration_seconds
        self.storage_duration_seconds = storage_duration_seconds


class ContentKeyPolicyRestriction(_serialization.Model):
    """Base class for Content Key Policy restrictions. A derived class must be used to create a restriction.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ContentKeyPolicyOpenRestriction, ContentKeyPolicyTokenRestriction,
    ContentKeyPolicyUnknownRestriction

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
    }

    _subtype_map = {
        "odata_type": {
            "#Microsoft.Media.ContentKeyPolicyOpenRestriction": "ContentKeyPolicyOpenRestriction",
            "#Microsoft.Media.ContentKeyPolicyTokenRestriction": "ContentKeyPolicyTokenRestriction",
            "#Microsoft.Media.ContentKeyPolicyUnknownRestriction": "ContentKeyPolicyUnknownRestriction",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class ContentKeyPolicyOpenRestriction(ContentKeyPolicyRestriction):
    """Represents an open restriction. License or key will be delivered on every request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.ContentKeyPolicyOpenRestriction"  # type: str


class ContentKeyPolicyOption(_serialization.Model):
    """Represents a policy option.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar policy_option_id: The legacy Policy Option ID.
    :vartype policy_option_id: str
    :ivar name: The Policy Option description.
    :vartype name: str
    :ivar configuration: The key delivery configuration. Required.
    :vartype configuration: ~azure.mgmt.media.models.ContentKeyPolicyConfiguration
    :ivar restriction: The requirements that must be met to deliver keys with this configuration.
     Required.
    :vartype restriction: ~azure.mgmt.media.models.ContentKeyPolicyRestriction
    """

    _validation = {
        "policy_option_id": {"readonly": True},
        "configuration": {"required": True},
        "restriction": {"required": True},
    }

    _attribute_map = {
        "policy_option_id": {"key": "policyOptionId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "configuration": {"key": "configuration", "type": "ContentKeyPolicyConfiguration"},
        "restriction": {"key": "restriction", "type": "ContentKeyPolicyRestriction"},
    }

    def __init__(
        self,
        *,
        configuration: "_models.ContentKeyPolicyConfiguration",
        restriction: "_models.ContentKeyPolicyRestriction",
        name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The Policy Option description.
        :paramtype name: str
        :keyword configuration: The key delivery configuration. Required.
        :paramtype configuration: ~azure.mgmt.media.models.ContentKeyPolicyConfiguration
        :keyword restriction: The requirements that must be met to deliver keys with this
         configuration. Required.
        :paramtype restriction: ~azure.mgmt.media.models.ContentKeyPolicyRestriction
        """
        super().__init__(**kwargs)
        self.policy_option_id = None
        self.name = name
        self.configuration = configuration
        self.restriction = restriction


class ContentKeyPolicyPlayReadyConfiguration(ContentKeyPolicyConfiguration):
    """Specifies a configuration for PlayReady licenses.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar licenses: The PlayReady licenses. Required.
    :vartype licenses: list[~azure.mgmt.media.models.ContentKeyPolicyPlayReadyLicense]
    :ivar response_custom_data: The custom response data.
    :vartype response_custom_data: str
    """

    _validation = {
        "odata_type": {"required": True},
        "licenses": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "licenses": {"key": "licenses", "type": "[ContentKeyPolicyPlayReadyLicense]"},
        "response_custom_data": {"key": "responseCustomData", "type": "str"},
    }

    def __init__(
        self,
        *,
        licenses: List["_models.ContentKeyPolicyPlayReadyLicense"],
        response_custom_data: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword licenses: The PlayReady licenses. Required.
        :paramtype licenses: list[~azure.mgmt.media.models.ContentKeyPolicyPlayReadyLicense]
        :keyword response_custom_data: The custom response data.
        :paramtype response_custom_data: str
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.ContentKeyPolicyPlayReadyConfiguration"  # type: str
        self.licenses = licenses
        self.response_custom_data = response_custom_data


class ContentKeyPolicyPlayReadyContentKeyLocation(_serialization.Model):
    """Base class for content key ID location. A derived class must be used to represent the location.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader,
    ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
    }

    _subtype_map = {
        "odata_type": {
            "#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader": "ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader",
            "#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier": "ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader(ContentKeyPolicyPlayReadyContentKeyLocation):
    """Specifies that the content key ID is in the PlayReady header.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader"  # type: str


class ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier(ContentKeyPolicyPlayReadyContentKeyLocation):
    """Specifies that the content key ID is specified in the PlayReady configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar key_id: The content key ID. Required.
    :vartype key_id: str
    """

    _validation = {
        "odata_type": {"required": True},
        "key_id": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "key_id": {"key": "keyId", "type": "str"},
    }

    def __init__(self, *, key_id: str, **kwargs):
        """
        :keyword key_id: The content key ID. Required.
        :paramtype key_id: str
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier"  # type: str
        self.key_id = key_id


class ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction(_serialization.Model):
    """Configures the Explicit Analog Television Output Restriction control bits. For further details see the PlayReady Compliance Rules.

    All required parameters must be populated in order to send to Azure.

    :ivar best_effort: Indicates whether this restriction is enforced on a Best Effort basis.
     Required.
    :vartype best_effort: bool
    :ivar configuration_data: Configures the restriction control bits. Must be between 0 and 3
     inclusive. Required.
    :vartype configuration_data: int
    """

    _validation = {
        "best_effort": {"required": True},
        "configuration_data": {"required": True},
    }

    _attribute_map = {
        "best_effort": {"key": "bestEffort", "type": "bool"},
        "configuration_data": {"key": "configurationData", "type": "int"},
    }

    def __init__(self, *, best_effort: bool, configuration_data: int, **kwargs):
        """
        :keyword best_effort: Indicates whether this restriction is enforced on a Best Effort basis.
         Required.
        :paramtype best_effort: bool
        :keyword configuration_data: Configures the restriction control bits. Must be between 0 and 3
         inclusive. Required.
        :paramtype configuration_data: int
        """
        super().__init__(**kwargs)
        self.best_effort = best_effort
        self.configuration_data = configuration_data


class ContentKeyPolicyPlayReadyLicense(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The PlayReady license.

    All required parameters must be populated in order to send to Azure.

    :ivar allow_test_devices: A flag indicating whether test devices can use the license. Required.
    :vartype allow_test_devices: bool
    :ivar security_level: The security level. Known values are: "Unknown", "SL150", "SL2000", and
     "SL3000".
    :vartype security_level: str or ~azure.mgmt.media.models.SecurityLevel
    :ivar begin_date: The begin date of license.
    :vartype begin_date: ~datetime.datetime
    :ivar expiration_date: The expiration date of license.
    :vartype expiration_date: ~datetime.datetime
    :ivar relative_begin_date: The relative begin date of license.
    :vartype relative_begin_date: ~datetime.timedelta
    :ivar relative_expiration_date: The relative expiration date of license.
    :vartype relative_expiration_date: ~datetime.timedelta
    :ivar grace_period: The grace period of license.
    :vartype grace_period: ~datetime.timedelta
    :ivar play_right: The license PlayRight.
    :vartype play_right: ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyPlayRight
    :ivar license_type: The license type. Required. Known values are: "Unknown", "NonPersistent",
     and "Persistent".
    :vartype license_type: str or ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyLicenseType
    :ivar content_key_location: The content key location. Required.
    :vartype content_key_location:
     ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyContentKeyLocation
    :ivar content_type: The PlayReady content type. Required. Known values are: "Unknown",
     "Unspecified", "UltraVioletDownload", and "UltraVioletStreaming".
    :vartype content_type: str or ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyContentType
    """

    _validation = {
        "allow_test_devices": {"required": True},
        "license_type": {"required": True},
        "content_key_location": {"required": True},
        "content_type": {"required": True},
    }

    _attribute_map = {
        "allow_test_devices": {"key": "allowTestDevices", "type": "bool"},
        "security_level": {"key": "securityLevel", "type": "str"},
        "begin_date": {"key": "beginDate", "type": "iso-8601"},
        "expiration_date": {"key": "expirationDate", "type": "iso-8601"},
        "relative_begin_date": {"key": "relativeBeginDate", "type": "duration"},
        "relative_expiration_date": {"key": "relativeExpirationDate", "type": "duration"},
        "grace_period": {"key": "gracePeriod", "type": "duration"},
        "play_right": {"key": "playRight", "type": "ContentKeyPolicyPlayReadyPlayRight"},
        "license_type": {"key": "licenseType", "type": "str"},
        "content_key_location": {"key": "contentKeyLocation", "type": "ContentKeyPolicyPlayReadyContentKeyLocation"},
        "content_type": {"key": "contentType", "type": "str"},
    }

    def __init__(
        self,
        *,
        allow_test_devices: bool,
        license_type: Union[str, "_models.ContentKeyPolicyPlayReadyLicenseType"],
        content_key_location: "_models.ContentKeyPolicyPlayReadyContentKeyLocation",
        content_type: Union[str, "_models.ContentKeyPolicyPlayReadyContentType"],
        security_level: Optional[Union[str, "_models.SecurityLevel"]] = None,
        begin_date: Optional[datetime.datetime] = None,
        expiration_date: Optional[datetime.datetime] = None,
        relative_begin_date: Optional[datetime.timedelta] = None,
        relative_expiration_date: Optional[datetime.timedelta] = None,
        grace_period: Optional[datetime.timedelta] = None,
        play_right: Optional["_models.ContentKeyPolicyPlayReadyPlayRight"] = None,
        **kwargs
    ):
        """
        :keyword allow_test_devices: A flag indicating whether test devices can use the license.
         Required.
        :paramtype allow_test_devices: bool
        :keyword security_level: The security level. Known values are: "Unknown", "SL150", "SL2000",
         and "SL3000".
        :paramtype security_level: str or ~azure.mgmt.media.models.SecurityLevel
        :keyword begin_date: The begin date of license.
        :paramtype begin_date: ~datetime.datetime
        :keyword expiration_date: The expiration date of license.
        :paramtype expiration_date: ~datetime.datetime
        :keyword relative_begin_date: The relative begin date of license.
        :paramtype relative_begin_date: ~datetime.timedelta
        :keyword relative_expiration_date: The relative expiration date of license.
        :paramtype relative_expiration_date: ~datetime.timedelta
        :keyword grace_period: The grace period of license.
        :paramtype grace_period: ~datetime.timedelta
        :keyword play_right: The license PlayRight.
        :paramtype play_right: ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyPlayRight
        :keyword license_type: The license type. Required. Known values are: "Unknown",
         "NonPersistent", and "Persistent".
        :paramtype license_type: str or ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyLicenseType
        :keyword content_key_location: The content key location. Required.
        :paramtype content_key_location:
         ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyContentKeyLocation
        :keyword content_type: The PlayReady content type. Required. Known values are: "Unknown",
         "Unspecified", "UltraVioletDownload", and "UltraVioletStreaming".
        :paramtype content_type: str or ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyContentType
        """
        super().__init__(**kwargs)
        self.allow_test_devices = allow_test_devices
        self.security_level = security_level
        self.begin_date = begin_date
        self.expiration_date = expiration_date
        self.relative_begin_date = relative_begin_date
        self.relative_expiration_date = relative_expiration_date
        self.grace_period = grace_period
        self.play_right = play_right
        self.license_type = license_type
        self.content_key_location = content_key_location
        self.content_type = content_type


class ContentKeyPolicyPlayReadyPlayRight(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Configures the Play Right in the PlayReady license.

    All required parameters must be populated in order to send to Azure.

    :ivar first_play_expiration: The amount of time that the license is valid after the license is
     first used to play content.
    :vartype first_play_expiration: ~datetime.timedelta
    :ivar scms_restriction: Configures the Serial Copy Management System (SCMS) in the license.
     Must be between 0 and 3 inclusive.
    :vartype scms_restriction: int
    :ivar agc_and_color_stripe_restriction: Configures Automatic Gain Control (AGC) and Color
     Stripe in the license. Must be between 0 and 3 inclusive.
    :vartype agc_and_color_stripe_restriction: int
    :ivar explicit_analog_television_output_restriction: Configures the Explicit Analog Television
     Output Restriction in the license. Configuration data must be between 0 and 3 inclusive.
    :vartype explicit_analog_television_output_restriction:
     ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction
    :ivar digital_video_only_content_restriction: Enables the Image Constraint For Analog Component
     Video Restriction in the license. Required.
    :vartype digital_video_only_content_restriction: bool
    :ivar image_constraint_for_analog_component_video_restriction: Enables the Image Constraint For
     Analog Component Video Restriction in the license. Required.
    :vartype image_constraint_for_analog_component_video_restriction: bool
    :ivar image_constraint_for_analog_computer_monitor_restriction: Enables the Image Constraint
     For Analog Component Video Restriction in the license. Required.
    :vartype image_constraint_for_analog_computer_monitor_restriction: bool
    :ivar allow_passing_video_content_to_unknown_output: Configures Unknown output handling
     settings of the license. Required. Known values are: "Unknown", "NotAllowed", "Allowed", and
     "AllowedWithVideoConstriction".
    :vartype allow_passing_video_content_to_unknown_output: str or
     ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyUnknownOutputPassingOption
    :ivar uncompressed_digital_video_opl: Specifies the output protection level for uncompressed
     digital video.
    :vartype uncompressed_digital_video_opl: int
    :ivar compressed_digital_video_opl: Specifies the output protection level for compressed
     digital video.
    :vartype compressed_digital_video_opl: int
    :ivar analog_video_opl: Specifies the output protection level for compressed digital audio.
    :vartype analog_video_opl: int
    :ivar compressed_digital_audio_opl: Specifies the output protection level for compressed
     digital audio.
    :vartype compressed_digital_audio_opl: int
    :ivar uncompressed_digital_audio_opl: Specifies the output protection level for uncompressed
     digital audio.
    :vartype uncompressed_digital_audio_opl: int
    """

    _validation = {
        "digital_video_only_content_restriction": {"required": True},
        "image_constraint_for_analog_component_video_restriction": {"required": True},
        "image_constraint_for_analog_computer_monitor_restriction": {"required": True},
        "allow_passing_video_content_to_unknown_output": {"required": True},
    }

    _attribute_map = {
        "first_play_expiration": {"key": "firstPlayExpiration", "type": "duration"},
        "scms_restriction": {"key": "scmsRestriction", "type": "int"},
        "agc_and_color_stripe_restriction": {"key": "agcAndColorStripeRestriction", "type": "int"},
        "explicit_analog_television_output_restriction": {
            "key": "explicitAnalogTelevisionOutputRestriction",
            "type": "ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction",
        },
        "digital_video_only_content_restriction": {"key": "digitalVideoOnlyContentRestriction", "type": "bool"},
        "image_constraint_for_analog_component_video_restriction": {
            "key": "imageConstraintForAnalogComponentVideoRestriction",
            "type": "bool",
        },
        "image_constraint_for_analog_computer_monitor_restriction": {
            "key": "imageConstraintForAnalogComputerMonitorRestriction",
            "type": "bool",
        },
        "allow_passing_video_content_to_unknown_output": {
            "key": "allowPassingVideoContentToUnknownOutput",
            "type": "str",
        },
        "uncompressed_digital_video_opl": {"key": "uncompressedDigitalVideoOpl", "type": "int"},
        "compressed_digital_video_opl": {"key": "compressedDigitalVideoOpl", "type": "int"},
        "analog_video_opl": {"key": "analogVideoOpl", "type": "int"},
        "compressed_digital_audio_opl": {"key": "compressedDigitalAudioOpl", "type": "int"},
        "uncompressed_digital_audio_opl": {"key": "uncompressedDigitalAudioOpl", "type": "int"},
    }

    def __init__(
        self,
        *,
        digital_video_only_content_restriction: bool,
        image_constraint_for_analog_component_video_restriction: bool,
        image_constraint_for_analog_computer_monitor_restriction: bool,
        allow_passing_video_content_to_unknown_output: Union[
            str, "_models.ContentKeyPolicyPlayReadyUnknownOutputPassingOption"
        ],
        first_play_expiration: Optional[datetime.timedelta] = None,
        scms_restriction: Optional[int] = None,
        agc_and_color_stripe_restriction: Optional[int] = None,
        explicit_analog_television_output_restriction: Optional[
            "_models.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction"
        ] = None,
        uncompressed_digital_video_opl: Optional[int] = None,
        compressed_digital_video_opl: Optional[int] = None,
        analog_video_opl: Optional[int] = None,
        compressed_digital_audio_opl: Optional[int] = None,
        uncompressed_digital_audio_opl: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword first_play_expiration: The amount of time that the license is valid after the license
         is first used to play content.
        :paramtype first_play_expiration: ~datetime.timedelta
        :keyword scms_restriction: Configures the Serial Copy Management System (SCMS) in the license.
         Must be between 0 and 3 inclusive.
        :paramtype scms_restriction: int
        :keyword agc_and_color_stripe_restriction: Configures Automatic Gain Control (AGC) and Color
         Stripe in the license. Must be between 0 and 3 inclusive.
        :paramtype agc_and_color_stripe_restriction: int
        :keyword explicit_analog_television_output_restriction: Configures the Explicit Analog
         Television Output Restriction in the license. Configuration data must be between 0 and 3
         inclusive.
        :paramtype explicit_analog_television_output_restriction:
         ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction
        :keyword digital_video_only_content_restriction: Enables the Image Constraint For Analog
         Component Video Restriction in the license. Required.
        :paramtype digital_video_only_content_restriction: bool
        :keyword image_constraint_for_analog_component_video_restriction: Enables the Image Constraint
         For Analog Component Video Restriction in the license. Required.
        :paramtype image_constraint_for_analog_component_video_restriction: bool
        :keyword image_constraint_for_analog_computer_monitor_restriction: Enables the Image Constraint
         For Analog Component Video Restriction in the license. Required.
        :paramtype image_constraint_for_analog_computer_monitor_restriction: bool
        :keyword allow_passing_video_content_to_unknown_output: Configures Unknown output handling
         settings of the license. Required. Known values are: "Unknown", "NotAllowed", "Allowed", and
         "AllowedWithVideoConstriction".
        :paramtype allow_passing_video_content_to_unknown_output: str or
         ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyUnknownOutputPassingOption
        :keyword uncompressed_digital_video_opl: Specifies the output protection level for uncompressed
         digital video.
        :paramtype uncompressed_digital_video_opl: int
        :keyword compressed_digital_video_opl: Specifies the output protection level for compressed
         digital video.
        :paramtype compressed_digital_video_opl: int
        :keyword analog_video_opl: Specifies the output protection level for compressed digital audio.
        :paramtype analog_video_opl: int
        :keyword compressed_digital_audio_opl: Specifies the output protection level for compressed
         digital audio.
        :paramtype compressed_digital_audio_opl: int
        :keyword uncompressed_digital_audio_opl: Specifies the output protection level for uncompressed
         digital audio.
        :paramtype uncompressed_digital_audio_opl: int
        """
        super().__init__(**kwargs)
        self.first_play_expiration = first_play_expiration
        self.scms_restriction = scms_restriction
        self.agc_and_color_stripe_restriction = agc_and_color_stripe_restriction
        self.explicit_analog_television_output_restriction = explicit_analog_television_output_restriction
        self.digital_video_only_content_restriction = digital_video_only_content_restriction
        self.image_constraint_for_analog_component_video_restriction = (
            image_constraint_for_analog_component_video_restriction
        )
        self.image_constraint_for_analog_computer_monitor_restriction = (
            image_constraint_for_analog_computer_monitor_restriction
        )
        self.allow_passing_video_content_to_unknown_output = allow_passing_video_content_to_unknown_output
        self.uncompressed_digital_video_opl = uncompressed_digital_video_opl
        self.compressed_digital_video_opl = compressed_digital_video_opl
        self.analog_video_opl = analog_video_opl
        self.compressed_digital_audio_opl = compressed_digital_audio_opl
        self.uncompressed_digital_audio_opl = uncompressed_digital_audio_opl


class ContentKeyPolicyProperties(_serialization.Model):
    """The properties of the Content Key Policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar policy_id: The legacy Policy ID.
    :vartype policy_id: str
    :ivar created: The creation date of the Policy.
    :vartype created: ~datetime.datetime
    :ivar last_modified: The last modified date of the Policy.
    :vartype last_modified: ~datetime.datetime
    :ivar description: A description for the Policy.
    :vartype description: str
    :ivar options: The Key Policy options. Required.
    :vartype options: list[~azure.mgmt.media.models.ContentKeyPolicyOption]
    """

    _validation = {
        "policy_id": {"readonly": True},
        "created": {"readonly": True},
        "last_modified": {"readonly": True},
        "options": {"required": True},
    }

    _attribute_map = {
        "policy_id": {"key": "policyId", "type": "str"},
        "created": {"key": "created", "type": "iso-8601"},
        "last_modified": {"key": "lastModified", "type": "iso-8601"},
        "description": {"key": "description", "type": "str"},
        "options": {"key": "options", "type": "[ContentKeyPolicyOption]"},
    }

    def __init__(self, *, options: List["_models.ContentKeyPolicyOption"], description: Optional[str] = None, **kwargs):
        """
        :keyword description: A description for the Policy.
        :paramtype description: str
        :keyword options: The Key Policy options. Required.
        :paramtype options: list[~azure.mgmt.media.models.ContentKeyPolicyOption]
        """
        super().__init__(**kwargs)
        self.policy_id = None
        self.created = None
        self.last_modified = None
        self.description = description
        self.options = options


class ContentKeyPolicyRestrictionTokenKey(_serialization.Model):
    """Base class for Content Key Policy key for token validation. A derived class must be used to create a token key.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ContentKeyPolicyRsaTokenKey, ContentKeyPolicySymmetricTokenKey,
    ContentKeyPolicyX509CertificateTokenKey

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
    }

    _subtype_map = {
        "odata_type": {
            "#Microsoft.Media.ContentKeyPolicyRsaTokenKey": "ContentKeyPolicyRsaTokenKey",
            "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey": "ContentKeyPolicySymmetricTokenKey",
            "#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey": "ContentKeyPolicyX509CertificateTokenKey",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class ContentKeyPolicyRsaTokenKey(ContentKeyPolicyRestrictionTokenKey):
    """Specifies a RSA key for token validation.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar exponent: The RSA Parameter exponent. Required.
    :vartype exponent: bytes
    :ivar modulus: The RSA Parameter modulus. Required.
    :vartype modulus: bytes
    """

    _validation = {
        "odata_type": {"required": True},
        "exponent": {"required": True},
        "modulus": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "exponent": {"key": "exponent", "type": "bytearray"},
        "modulus": {"key": "modulus", "type": "bytearray"},
    }

    def __init__(self, *, exponent: bytes, modulus: bytes, **kwargs):
        """
        :keyword exponent: The RSA Parameter exponent. Required.
        :paramtype exponent: bytes
        :keyword modulus: The RSA Parameter modulus. Required.
        :paramtype modulus: bytes
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.ContentKeyPolicyRsaTokenKey"  # type: str
        self.exponent = exponent
        self.modulus = modulus


class ContentKeyPolicySymmetricTokenKey(ContentKeyPolicyRestrictionTokenKey):
    """Specifies a symmetric key for token validation.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar key_value: The key value of the key. Required.
    :vartype key_value: bytes
    """

    _validation = {
        "odata_type": {"required": True},
        "key_value": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "key_value": {"key": "keyValue", "type": "bytearray"},
    }

    def __init__(self, *, key_value: bytes, **kwargs):
        """
        :keyword key_value: The key value of the key. Required.
        :paramtype key_value: bytes
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.ContentKeyPolicySymmetricTokenKey"  # type: str
        self.key_value = key_value


class ContentKeyPolicyTokenClaim(_serialization.Model):
    """Represents a token claim.

    :ivar claim_type: Token claim type.
    :vartype claim_type: str
    :ivar claim_value: Token claim value.
    :vartype claim_value: str
    """

    _attribute_map = {
        "claim_type": {"key": "claimType", "type": "str"},
        "claim_value": {"key": "claimValue", "type": "str"},
    }

    def __init__(self, *, claim_type: Optional[str] = None, claim_value: Optional[str] = None, **kwargs):
        """
        :keyword claim_type: Token claim type.
        :paramtype claim_type: str
        :keyword claim_value: Token claim value.
        :paramtype claim_value: str
        """
        super().__init__(**kwargs)
        self.claim_type = claim_type
        self.claim_value = claim_value


class ContentKeyPolicyTokenRestriction(ContentKeyPolicyRestriction):
    """Represents a token restriction. Provided token must match these requirements for successful license or key delivery.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar issuer: The token issuer. Required.
    :vartype issuer: str
    :ivar audience: The audience for the token. Required.
    :vartype audience: str
    :ivar primary_verification_key: The primary verification key. Required.
    :vartype primary_verification_key: ~azure.mgmt.media.models.ContentKeyPolicyRestrictionTokenKey
    :ivar alternate_verification_keys: A list of alternative verification keys.
    :vartype alternate_verification_keys:
     list[~azure.mgmt.media.models.ContentKeyPolicyRestrictionTokenKey]
    :ivar required_claims: A list of required token claims.
    :vartype required_claims: list[~azure.mgmt.media.models.ContentKeyPolicyTokenClaim]
    :ivar restriction_token_type: The type of token. Required. Known values are: "Unknown", "Swt",
     and "Jwt".
    :vartype restriction_token_type: str or
     ~azure.mgmt.media.models.ContentKeyPolicyRestrictionTokenType
    :ivar open_id_connect_discovery_document: The OpenID connect discovery document.
    :vartype open_id_connect_discovery_document: str
    """

    _validation = {
        "odata_type": {"required": True},
        "issuer": {"required": True},
        "audience": {"required": True},
        "primary_verification_key": {"required": True},
        "restriction_token_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "issuer": {"key": "issuer", "type": "str"},
        "audience": {"key": "audience", "type": "str"},
        "primary_verification_key": {"key": "primaryVerificationKey", "type": "ContentKeyPolicyRestrictionTokenKey"},
        "alternate_verification_keys": {
            "key": "alternateVerificationKeys",
            "type": "[ContentKeyPolicyRestrictionTokenKey]",
        },
        "required_claims": {"key": "requiredClaims", "type": "[ContentKeyPolicyTokenClaim]"},
        "restriction_token_type": {"key": "restrictionTokenType", "type": "str"},
        "open_id_connect_discovery_document": {"key": "openIdConnectDiscoveryDocument", "type": "str"},
    }

    def __init__(
        self,
        *,
        issuer: str,
        audience: str,
        primary_verification_key: "_models.ContentKeyPolicyRestrictionTokenKey",
        restriction_token_type: Union[str, "_models.ContentKeyPolicyRestrictionTokenType"],
        alternate_verification_keys: Optional[List["_models.ContentKeyPolicyRestrictionTokenKey"]] = None,
        required_claims: Optional[List["_models.ContentKeyPolicyTokenClaim"]] = None,
        open_id_connect_discovery_document: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword issuer: The token issuer. Required.
        :paramtype issuer: str
        :keyword audience: The audience for the token. Required.
        :paramtype audience: str
        :keyword primary_verification_key: The primary verification key. Required.
        :paramtype primary_verification_key:
         ~azure.mgmt.media.models.ContentKeyPolicyRestrictionTokenKey
        :keyword alternate_verification_keys: A list of alternative verification keys.
        :paramtype alternate_verification_keys:
         list[~azure.mgmt.media.models.ContentKeyPolicyRestrictionTokenKey]
        :keyword required_claims: A list of required token claims.
        :paramtype required_claims: list[~azure.mgmt.media.models.ContentKeyPolicyTokenClaim]
        :keyword restriction_token_type: The type of token. Required. Known values are: "Unknown",
         "Swt", and "Jwt".
        :paramtype restriction_token_type: str or
         ~azure.mgmt.media.models.ContentKeyPolicyRestrictionTokenType
        :keyword open_id_connect_discovery_document: The OpenID connect discovery document.
        :paramtype open_id_connect_discovery_document: str
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.ContentKeyPolicyTokenRestriction"  # type: str
        self.issuer = issuer
        self.audience = audience
        self.primary_verification_key = primary_verification_key
        self.alternate_verification_keys = alternate_verification_keys
        self.required_claims = required_claims
        self.restriction_token_type = restriction_token_type
        self.open_id_connect_discovery_document = open_id_connect_discovery_document


class ContentKeyPolicyUnknownConfiguration(ContentKeyPolicyConfiguration):
    """Represents a ContentKeyPolicyConfiguration that is unavailable in the current API version.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.ContentKeyPolicyUnknownConfiguration"  # type: str


class ContentKeyPolicyUnknownRestriction(ContentKeyPolicyRestriction):
    """Represents a ContentKeyPolicyRestriction that is unavailable in the current API version.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.ContentKeyPolicyUnknownRestriction"  # type: str


class ContentKeyPolicyWidevineConfiguration(ContentKeyPolicyConfiguration):
    """Specifies a configuration for Widevine licenses.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar widevine_template: The Widevine template. Required.
    :vartype widevine_template: str
    """

    _validation = {
        "odata_type": {"required": True},
        "widevine_template": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "widevine_template": {"key": "widevineTemplate", "type": "str"},
    }

    def __init__(self, *, widevine_template: str, **kwargs):
        """
        :keyword widevine_template: The Widevine template. Required.
        :paramtype widevine_template: str
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.ContentKeyPolicyWidevineConfiguration"  # type: str
        self.widevine_template = widevine_template


class ContentKeyPolicyX509CertificateTokenKey(ContentKeyPolicyRestrictionTokenKey):
    """Specifies a certificate for token validation.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar raw_body: The raw data field of a certificate in PKCS 12 format (X509Certificate2 in
     .NET). Required.
    :vartype raw_body: bytes
    """

    _validation = {
        "odata_type": {"required": True},
        "raw_body": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "raw_body": {"key": "rawBody", "type": "bytearray"},
    }

    def __init__(self, *, raw_body: bytes, **kwargs):
        """
        :keyword raw_body: The raw data field of a certificate in PKCS 12 format (X509Certificate2 in
         .NET). Required.
        :paramtype raw_body: bytes
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.ContentKeyPolicyX509CertificateTokenKey"  # type: str
        self.raw_body = raw_body


class CopyAudio(Codec):
    """A codec flag, which tells the encoder to copy the input audio bitstream.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar label: An optional label for the codec. The label can be used to control muxing behavior.
    :vartype label: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "label": {"key": "label", "type": "str"},
    }

    def __init__(self, *, label: Optional[str] = None, **kwargs):
        """
        :keyword label: An optional label for the codec. The label can be used to control muxing
         behavior.
        :paramtype label: str
        """
        super().__init__(label=label, **kwargs)
        self.odata_type = "#Microsoft.Media.CopyAudio"  # type: str


class CopyVideo(Codec):
    """A codec flag, which tells the encoder to copy the input video bitstream without re-encoding.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar label: An optional label for the codec. The label can be used to control muxing behavior.
    :vartype label: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "label": {"key": "label", "type": "str"},
    }

    def __init__(self, *, label: Optional[str] = None, **kwargs):
        """
        :keyword label: An optional label for the codec. The label can be used to control muxing
         behavior.
        :paramtype label: str
        """
        super().__init__(label=label, **kwargs)
        self.odata_type = "#Microsoft.Media.CopyVideo"  # type: str


class CrossSiteAccessPolicies(_serialization.Model):
    """The client access policy.

    :ivar client_access_policy: The content of clientaccesspolicy.xml used by Silverlight.
    :vartype client_access_policy: str
    :ivar cross_domain_policy: The content of crossdomain.xml used by Silverlight.
    :vartype cross_domain_policy: str
    """

    _attribute_map = {
        "client_access_policy": {"key": "clientAccessPolicy", "type": "str"},
        "cross_domain_policy": {"key": "crossDomainPolicy", "type": "str"},
    }

    def __init__(
        self, *, client_access_policy: Optional[str] = None, cross_domain_policy: Optional[str] = None, **kwargs
    ):
        """
        :keyword client_access_policy: The content of clientaccesspolicy.xml used by Silverlight.
        :paramtype client_access_policy: str
        :keyword cross_domain_policy: The content of crossdomain.xml used by Silverlight.
        :paramtype cross_domain_policy: str
        """
        super().__init__(**kwargs)
        self.client_access_policy = client_access_policy
        self.cross_domain_policy = cross_domain_policy


class DashSettings(_serialization.Model):
    """The DASH setting for a track.

    :ivar role: The role for the DASH setting.
    :vartype role: str
    """

    _attribute_map = {
        "role": {"key": "role", "type": "str"},
    }

    def __init__(self, *, role: Optional[str] = None, **kwargs):
        """
        :keyword role: The role for the DASH setting.
        :paramtype role: str
        """
        super().__init__(**kwargs)
        self.role = role


class DefaultKey(_serialization.Model):
    """Class to specify properties of default content key for each encryption scheme.

    :ivar label: Label can be used to specify Content Key when creating a Streaming Locator.
    :vartype label: str
    :ivar policy_name: Policy used by Default Key.
    :vartype policy_name: str
    """

    _attribute_map = {
        "label": {"key": "label", "type": "str"},
        "policy_name": {"key": "policyName", "type": "str"},
    }

    def __init__(self, *, label: Optional[str] = None, policy_name: Optional[str] = None, **kwargs):
        """
        :keyword label: Label can be used to specify Content Key when creating a Streaming Locator.
        :paramtype label: str
        :keyword policy_name: Policy used by Default Key.
        :paramtype policy_name: str
        """
        super().__init__(**kwargs)
        self.label = label
        self.policy_name = policy_name


class Deinterlace(_serialization.Model):
    """Describes the de-interlacing settings.

    :ivar parity: The field parity for de-interlacing, defaults to Auto. Known values are: "Auto",
     "TopFieldFirst", and "BottomFieldFirst".
    :vartype parity: str or ~azure.mgmt.media.models.DeinterlaceParity
    :ivar mode: The deinterlacing mode. Defaults to AutoPixelAdaptive. Known values are: "Off" and
     "AutoPixelAdaptive".
    :vartype mode: str or ~azure.mgmt.media.models.DeinterlaceMode
    """

    _attribute_map = {
        "parity": {"key": "parity", "type": "str"},
        "mode": {"key": "mode", "type": "str"},
    }

    def __init__(
        self,
        *,
        parity: Optional[Union[str, "_models.DeinterlaceParity"]] = None,
        mode: Optional[Union[str, "_models.DeinterlaceMode"]] = None,
        **kwargs
    ):
        """
        :keyword parity: The field parity for de-interlacing, defaults to Auto. Known values are:
         "Auto", "TopFieldFirst", and "BottomFieldFirst".
        :paramtype parity: str or ~azure.mgmt.media.models.DeinterlaceParity
        :keyword mode: The deinterlacing mode. Defaults to AutoPixelAdaptive. Known values are: "Off"
         and "AutoPixelAdaptive".
        :paramtype mode: str or ~azure.mgmt.media.models.DeinterlaceMode
        """
        super().__init__(**kwargs)
        self.parity = parity
        self.mode = mode


class EdgePolicies(_serialization.Model):
    """EdgePolicies.

    :ivar usage_data_collection_policy:
    :vartype usage_data_collection_policy: ~azure.mgmt.media.models.EdgeUsageDataCollectionPolicy
    """

    _attribute_map = {
        "usage_data_collection_policy": {"key": "usageDataCollectionPolicy", "type": "EdgeUsageDataCollectionPolicy"},
    }

    def __init__(
        self, *, usage_data_collection_policy: Optional["_models.EdgeUsageDataCollectionPolicy"] = None, **kwargs
    ):
        """
        :keyword usage_data_collection_policy:
        :paramtype usage_data_collection_policy: ~azure.mgmt.media.models.EdgeUsageDataCollectionPolicy
        """
        super().__init__(**kwargs)
        self.usage_data_collection_policy = usage_data_collection_policy


class EdgeUsageDataCollectionPolicy(_serialization.Model):
    """EdgeUsageDataCollectionPolicy.

    :ivar data_collection_frequency: Usage data collection frequency in ISO 8601 duration format
     e.g. PT10M , PT5H.
    :vartype data_collection_frequency: str
    :ivar data_reporting_frequency: Usage data reporting frequency in ISO 8601 duration format e.g.
     PT10M , PT5H.
    :vartype data_reporting_frequency: str
    :ivar max_allowed_unreported_usage_duration: Maximum time for which the functionality of the
     device will not be hampered for not reporting the usage data.
    :vartype max_allowed_unreported_usage_duration: str
    :ivar event_hub_details: Details of Event Hub where the usage will be reported.
    :vartype event_hub_details: ~azure.mgmt.media.models.EdgeUsageDataEventHub
    """

    _attribute_map = {
        "data_collection_frequency": {"key": "dataCollectionFrequency", "type": "str"},
        "data_reporting_frequency": {"key": "dataReportingFrequency", "type": "str"},
        "max_allowed_unreported_usage_duration": {"key": "maxAllowedUnreportedUsageDuration", "type": "str"},
        "event_hub_details": {"key": "eventHubDetails", "type": "EdgeUsageDataEventHub"},
    }

    def __init__(
        self,
        *,
        data_collection_frequency: Optional[str] = None,
        data_reporting_frequency: Optional[str] = None,
        max_allowed_unreported_usage_duration: Optional[str] = None,
        event_hub_details: Optional["_models.EdgeUsageDataEventHub"] = None,
        **kwargs
    ):
        """
        :keyword data_collection_frequency: Usage data collection frequency in ISO 8601 duration format
         e.g. PT10M , PT5H.
        :paramtype data_collection_frequency: str
        :keyword data_reporting_frequency: Usage data reporting frequency in ISO 8601 duration format
         e.g. PT10M , PT5H.
        :paramtype data_reporting_frequency: str
        :keyword max_allowed_unreported_usage_duration: Maximum time for which the functionality of the
         device will not be hampered for not reporting the usage data.
        :paramtype max_allowed_unreported_usage_duration: str
        :keyword event_hub_details: Details of Event Hub where the usage will be reported.
        :paramtype event_hub_details: ~azure.mgmt.media.models.EdgeUsageDataEventHub
        """
        super().__init__(**kwargs)
        self.data_collection_frequency = data_collection_frequency
        self.data_reporting_frequency = data_reporting_frequency
        self.max_allowed_unreported_usage_duration = max_allowed_unreported_usage_duration
        self.event_hub_details = event_hub_details


class EdgeUsageDataEventHub(_serialization.Model):
    """EdgeUsageDataEventHub.

    :ivar name: Name of the Event Hub where usage will be reported.
    :vartype name: str
    :ivar namespace: Namespace of the Event Hub where usage will be reported.
    :vartype namespace: str
    :ivar token: SAS token needed to interact with Event Hub.
    :vartype token: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "namespace": {"key": "namespace", "type": "str"},
        "token": {"key": "token", "type": "str"},
    }

    def __init__(
        self, *, name: Optional[str] = None, namespace: Optional[str] = None, token: Optional[str] = None, **kwargs
    ):
        """
        :keyword name: Name of the Event Hub where usage will be reported.
        :paramtype name: str
        :keyword namespace: Namespace of the Event Hub where usage will be reported.
        :paramtype namespace: str
        :keyword token: SAS token needed to interact with Event Hub.
        :paramtype token: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.namespace = namespace
        self.token = token


class EnabledProtocols(_serialization.Model):
    """Class to specify which protocols are enabled.

    All required parameters must be populated in order to send to Azure.

    :ivar download: Enable Download protocol or not. Required.
    :vartype download: bool
    :ivar dash: Enable DASH protocol or not. Required.
    :vartype dash: bool
    :ivar hls: Enable HLS protocol or not. Required.
    :vartype hls: bool
    :ivar smooth_streaming: Enable SmoothStreaming protocol or not. Required.
    :vartype smooth_streaming: bool
    """

    _validation = {
        "download": {"required": True},
        "dash": {"required": True},
        "hls": {"required": True},
        "smooth_streaming": {"required": True},
    }

    _attribute_map = {
        "download": {"key": "download", "type": "bool"},
        "dash": {"key": "dash", "type": "bool"},
        "hls": {"key": "hls", "type": "bool"},
        "smooth_streaming": {"key": "smoothStreaming", "type": "bool"},
    }

    def __init__(self, *, download: bool, dash: bool, hls: bool, smooth_streaming: bool, **kwargs):
        """
        :keyword download: Enable Download protocol or not. Required.
        :paramtype download: bool
        :keyword dash: Enable DASH protocol or not. Required.
        :paramtype dash: bool
        :keyword hls: Enable HLS protocol or not. Required.
        :paramtype hls: bool
        :keyword smooth_streaming: Enable SmoothStreaming protocol or not. Required.
        :paramtype smooth_streaming: bool
        """
        super().__init__(**kwargs)
        self.download = download
        self.dash = dash
        self.hls = hls
        self.smooth_streaming = smooth_streaming


class EntityNameAvailabilityCheckOutput(_serialization.Model):
    """The response from the check name availability request.

    All required parameters must be populated in order to send to Azure.

    :ivar name_available: Specifies if the name is available. Required.
    :vartype name_available: bool
    :ivar reason: Specifies the reason if the name is not available.
    :vartype reason: str
    :ivar message: Specifies the detailed reason if the name is not available.
    :vartype message: str
    """

    _validation = {
        "name_available": {"required": True},
    }

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, name_available: bool, reason: Optional[str] = None, message: Optional[str] = None, **kwargs):
        """
        :keyword name_available: Specifies if the name is available. Required.
        :paramtype name_available: bool
        :keyword reason: Specifies the reason if the name is not available.
        :paramtype reason: str
        :keyword message: Specifies the detailed reason if the name is not available.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class EnvelopeEncryption(_serialization.Model):
    """Class for EnvelopeEncryption encryption scheme.

    :ivar enabled_protocols: Representing supported protocols.
    :vartype enabled_protocols: ~azure.mgmt.media.models.EnabledProtocols
    :ivar clear_tracks: Representing which tracks should not be encrypted.
    :vartype clear_tracks: list[~azure.mgmt.media.models.TrackSelection]
    :ivar content_keys: Representing default content key for each encryption scheme and separate
     content keys for specific tracks.
    :vartype content_keys: ~azure.mgmt.media.models.StreamingPolicyContentKeys
    :ivar custom_key_acquisition_url_template: Template for the URL of the custom service
     delivering keys to end user players.  Not required when using Azure Media Services for issuing
     keys.  The template supports replaceable tokens that the service will update at runtime with
     the value specific to the request.  The currently supported token values are
     {AlternativeMediaId}, which is replaced with the value of
     StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of
     identifier of the key being requested.
    :vartype custom_key_acquisition_url_template: str
    """

    _attribute_map = {
        "enabled_protocols": {"key": "enabledProtocols", "type": "EnabledProtocols"},
        "clear_tracks": {"key": "clearTracks", "type": "[TrackSelection]"},
        "content_keys": {"key": "contentKeys", "type": "StreamingPolicyContentKeys"},
        "custom_key_acquisition_url_template": {"key": "customKeyAcquisitionUrlTemplate", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled_protocols: Optional["_models.EnabledProtocols"] = None,
        clear_tracks: Optional[List["_models.TrackSelection"]] = None,
        content_keys: Optional["_models.StreamingPolicyContentKeys"] = None,
        custom_key_acquisition_url_template: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword enabled_protocols: Representing supported protocols.
        :paramtype enabled_protocols: ~azure.mgmt.media.models.EnabledProtocols
        :keyword clear_tracks: Representing which tracks should not be encrypted.
        :paramtype clear_tracks: list[~azure.mgmt.media.models.TrackSelection]
        :keyword content_keys: Representing default content key for each encryption scheme and separate
         content keys for specific tracks.
        :paramtype content_keys: ~azure.mgmt.media.models.StreamingPolicyContentKeys
        :keyword custom_key_acquisition_url_template: Template for the URL of the custom service
         delivering keys to end user players.  Not required when using Azure Media Services for issuing
         keys.  The template supports replaceable tokens that the service will update at runtime with
         the value specific to the request.  The currently supported token values are
         {AlternativeMediaId}, which is replaced with the value of
         StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of
         identifier of the key being requested.
        :paramtype custom_key_acquisition_url_template: str
        """
        super().__init__(**kwargs)
        self.enabled_protocols = enabled_protocols
        self.clear_tracks = clear_tracks
        self.content_keys = content_keys
        self.custom_key_acquisition_url_template = custom_key_acquisition_url_template


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.media.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.media.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.media.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.media.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class FaceDetectorPreset(Preset):
    """Describes all the settings to be used when analyzing a video in order to detect (and optionally redact) all the faces present.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar resolution: Specifies the maximum resolution at which your video is analyzed. The default
     behavior is "SourceResolution," which will keep the input video at its original resolution when
     analyzed. Using "StandardDefinition" will resize input videos to standard definition while
     preserving the appropriate aspect ratio. It will only resize if the video is of higher
     resolution. For example, a 1920x1080 input would be scaled to 640x360 before processing.
     Switching to "StandardDefinition" will reduce the time it takes to process high resolution
     video. It may also reduce the cost of using this component (see
     https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics for details).
     However, faces that end up being too small in the resized video may not be detected. Known
     values are: "SourceResolution" and "StandardDefinition".
    :vartype resolution: str or ~azure.mgmt.media.models.AnalysisResolution
    :ivar mode: This mode provides the ability to choose between the following settings: 1) Analyze
     - For detection only.This mode generates a metadata JSON file marking appearances of faces
     throughout the video.Where possible, appearances of the same person are assigned the same ID.
     2) Combined - Additionally redacts(blurs) detected faces. 3) Redact - This enables a 2-pass
     process, allowing for selective redaction of a subset of detected faces.It takes in the
     metadata file from a prior analyze pass, along with the source video, and a user-selected
     subset of IDs that require redaction. Known values are: "Analyze", "Redact", and "Combined".
    :vartype mode: str or ~azure.mgmt.media.models.FaceRedactorMode
    :ivar blur_type: Blur type. Known values are: "Box", "Low", "Med", "High", and "Black".
    :vartype blur_type: str or ~azure.mgmt.media.models.BlurType
    :ivar experimental_options: Dictionary containing key value pairs for parameters not exposed in
     the preset itself.
    :vartype experimental_options: dict[str, str]
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "resolution": {"key": "resolution", "type": "str"},
        "mode": {"key": "mode", "type": "str"},
        "blur_type": {"key": "blurType", "type": "str"},
        "experimental_options": {"key": "experimentalOptions", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        resolution: Optional[Union[str, "_models.AnalysisResolution"]] = None,
        mode: Optional[Union[str, "_models.FaceRedactorMode"]] = None,
        blur_type: Optional[Union[str, "_models.BlurType"]] = None,
        experimental_options: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword resolution: Specifies the maximum resolution at which your video is analyzed. The
         default behavior is "SourceResolution," which will keep the input video at its original
         resolution when analyzed. Using "StandardDefinition" will resize input videos to standard
         definition while preserving the appropriate aspect ratio. It will only resize if the video is
         of higher resolution. For example, a 1920x1080 input would be scaled to 640x360 before
         processing. Switching to "StandardDefinition" will reduce the time it takes to process high
         resolution video. It may also reduce the cost of using this component (see
         https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics for details).
         However, faces that end up being too small in the resized video may not be detected. Known
         values are: "SourceResolution" and "StandardDefinition".
        :paramtype resolution: str or ~azure.mgmt.media.models.AnalysisResolution
        :keyword mode: This mode provides the ability to choose between the following settings: 1)
         Analyze - For detection only.This mode generates a metadata JSON file marking appearances of
         faces throughout the video.Where possible, appearances of the same person are assigned the same
         ID. 2) Combined - Additionally redacts(blurs) detected faces. 3) Redact - This enables a 2-pass
         process, allowing for selective redaction of a subset of detected faces.It takes in the
         metadata file from a prior analyze pass, along with the source video, and a user-selected
         subset of IDs that require redaction. Known values are: "Analyze", "Redact", and "Combined".
        :paramtype mode: str or ~azure.mgmt.media.models.FaceRedactorMode
        :keyword blur_type: Blur type. Known values are: "Box", "Low", "Med", "High", and "Black".
        :paramtype blur_type: str or ~azure.mgmt.media.models.BlurType
        :keyword experimental_options: Dictionary containing key value pairs for parameters not exposed
         in the preset itself.
        :paramtype experimental_options: dict[str, str]
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.FaceDetectorPreset"  # type: str
        self.resolution = resolution
        self.mode = mode
        self.blur_type = blur_type
        self.experimental_options = experimental_options


class Filters(_serialization.Model):
    """Describes all the filtering operations, such as de-interlacing, rotation etc. that are to be applied to the input media before encoding.

    :ivar deinterlace: The de-interlacing settings.
    :vartype deinterlace: ~azure.mgmt.media.models.Deinterlace
    :ivar rotation: The rotation, if any, to be applied to the input video, before it is encoded.
     Default is Auto. Known values are: "Auto", "None", "Rotate0", "Rotate90", "Rotate180", and
     "Rotate270".
    :vartype rotation: str or ~azure.mgmt.media.models.Rotation
    :ivar crop: The parameters for the rectangular window with which to crop the input video.
    :vartype crop: ~azure.mgmt.media.models.Rectangle
    :ivar overlays: The properties of overlays to be applied to the input video. These could be
     audio, image or video overlays.
    :vartype overlays: list[~azure.mgmt.media.models.Overlay]
    """

    _attribute_map = {
        "deinterlace": {"key": "deinterlace", "type": "Deinterlace"},
        "rotation": {"key": "rotation", "type": "str"},
        "crop": {"key": "crop", "type": "Rectangle"},
        "overlays": {"key": "overlays", "type": "[Overlay]"},
    }

    def __init__(
        self,
        *,
        deinterlace: Optional["_models.Deinterlace"] = None,
        rotation: Optional[Union[str, "_models.Rotation"]] = None,
        crop: Optional["_models.Rectangle"] = None,
        overlays: Optional[List["_models.Overlay"]] = None,
        **kwargs
    ):
        """
        :keyword deinterlace: The de-interlacing settings.
        :paramtype deinterlace: ~azure.mgmt.media.models.Deinterlace
        :keyword rotation: The rotation, if any, to be applied to the input video, before it is
         encoded. Default is Auto. Known values are: "Auto", "None", "Rotate0", "Rotate90", "Rotate180",
         and "Rotate270".
        :paramtype rotation: str or ~azure.mgmt.media.models.Rotation
        :keyword crop: The parameters for the rectangular window with which to crop the input video.
        :paramtype crop: ~azure.mgmt.media.models.Rectangle
        :keyword overlays: The properties of overlays to be applied to the input video. These could be
         audio, image or video overlays.
        :paramtype overlays: list[~azure.mgmt.media.models.Overlay]
        """
        super().__init__(**kwargs)
        self.deinterlace = deinterlace
        self.rotation = rotation
        self.crop = crop
        self.overlays = overlays


class FilterTrackPropertyCondition(_serialization.Model):
    """The class to specify one track property condition.

    All required parameters must be populated in order to send to Azure.

    :ivar property: The track property type. Required. Known values are: "Unknown", "Type", "Name",
     "Language", "FourCC", and "Bitrate".
    :vartype property: str or ~azure.mgmt.media.models.FilterTrackPropertyType
    :ivar value: The track property value. Required.
    :vartype value: str
    :ivar operation: The track property condition operation. Required. Known values are: "Equal"
     and "NotEqual".
    :vartype operation: str or ~azure.mgmt.media.models.FilterTrackPropertyCompareOperation
    """

    _validation = {
        "property": {"required": True},
        "value": {"required": True},
        "operation": {"required": True},
    }

    _attribute_map = {
        "property": {"key": "property", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
    }

    def __init__(
        self,
        *,
        property: Union[str, "_models.FilterTrackPropertyType"],
        value: str,
        operation: Union[str, "_models.FilterTrackPropertyCompareOperation"],
        **kwargs
    ):
        """
        :keyword property: The track property type. Required. Known values are: "Unknown", "Type",
         "Name", "Language", "FourCC", and "Bitrate".
        :paramtype property: str or ~azure.mgmt.media.models.FilterTrackPropertyType
        :keyword value: The track property value. Required.
        :paramtype value: str
        :keyword operation: The track property condition operation. Required. Known values are: "Equal"
         and "NotEqual".
        :paramtype operation: str or ~azure.mgmt.media.models.FilterTrackPropertyCompareOperation
        """
        super().__init__(**kwargs)
        self.property = property
        self.value = value
        self.operation = operation


class FilterTrackSelection(_serialization.Model):
    """Representing a list of FilterTrackPropertyConditions to select a track.  The filters are combined using a logical AND operation.

    All required parameters must be populated in order to send to Azure.

    :ivar track_selections: The track selections. Required.
    :vartype track_selections: list[~azure.mgmt.media.models.FilterTrackPropertyCondition]
    """

    _validation = {
        "track_selections": {"required": True},
    }

    _attribute_map = {
        "track_selections": {"key": "trackSelections", "type": "[FilterTrackPropertyCondition]"},
    }

    def __init__(self, *, track_selections: List["_models.FilterTrackPropertyCondition"], **kwargs):
        """
        :keyword track_selections: The track selections. Required.
        :paramtype track_selections: list[~azure.mgmt.media.models.FilterTrackPropertyCondition]
        """
        super().__init__(**kwargs)
        self.track_selections = track_selections


class FirstQuality(_serialization.Model):
    """Filter First Quality.

    All required parameters must be populated in order to send to Azure.

    :ivar bitrate: The first quality bitrate. Required.
    :vartype bitrate: int
    """

    _validation = {
        "bitrate": {"required": True},
    }

    _attribute_map = {
        "bitrate": {"key": "bitrate", "type": "int"},
    }

    def __init__(self, *, bitrate: int, **kwargs):
        """
        :keyword bitrate: The first quality bitrate. Required.
        :paramtype bitrate: int
        """
        super().__init__(**kwargs)
        self.bitrate = bitrate


class Format(_serialization.Model):
    """Base class for output.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ImageFormat, MultiBitrateFormat

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar filename_pattern: The pattern of the file names for the generated output files. The
     following macros are supported in the file name: {Basename} - An expansion macro that will use
     the name of the input video file. If the base name(the file suffix is not included) of the
     input video file is less than 32 characters long, the base name of input video files will be
     used. If the length of base name of the input video file exceeds 32 characters, the base name
     is truncated to the first 32 characters in total length. {Extension} - The appropriate
     extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique
     index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not
     applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video
     resolution. Any unsubstituted macros will be collapsed and removed from the filename. Required.
    :vartype filename_pattern: str
    """

    _validation = {
        "odata_type": {"required": True},
        "filename_pattern": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "filename_pattern": {"key": "filenamePattern", "type": "str"},
    }

    _subtype_map = {
        "odata_type": {
            "#Microsoft.Media.ImageFormat": "ImageFormat",
            "#Microsoft.Media.MultiBitrateFormat": "MultiBitrateFormat",
        }
    }

    def __init__(self, *, filename_pattern: str, **kwargs):
        """
        :keyword filename_pattern: The pattern of the file names for the generated output files. The
         following macros are supported in the file name: {Basename} - An expansion macro that will use
         the name of the input video file. If the base name(the file suffix is not included) of the
         input video file is less than 32 characters long, the base name of input video files will be
         used. If the length of base name of the input video file exceeds 32 characters, the base name
         is truncated to the first 32 characters in total length. {Extension} - The appropriate
         extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique
         index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not
         applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video
         resolution. Any unsubstituted macros will be collapsed and removed from the filename. Required.
        :paramtype filename_pattern: str
        """
        super().__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.filename_pattern = filename_pattern


class InputDefinition(_serialization.Model):
    """Base class for defining an input. Use sub classes of this class to specify tracks selections and related metadata.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FromAllInputFile, FromEachInputFile, InputFile

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar included_tracks: The list of TrackDescriptors which define the metadata and selection of
     tracks in the input.
    :vartype included_tracks: list[~azure.mgmt.media.models.TrackDescriptor]
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "included_tracks": {"key": "includedTracks", "type": "[TrackDescriptor]"},
    }

    _subtype_map = {
        "odata_type": {
            "#Microsoft.Media.FromAllInputFile": "FromAllInputFile",
            "#Microsoft.Media.FromEachInputFile": "FromEachInputFile",
            "#Microsoft.Media.InputFile": "InputFile",
        }
    }

    def __init__(self, *, included_tracks: Optional[List["_models.TrackDescriptor"]] = None, **kwargs):
        """
        :keyword included_tracks: The list of TrackDescriptors which define the metadata and selection
         of tracks in the input.
        :paramtype included_tracks: list[~azure.mgmt.media.models.TrackDescriptor]
        """
        super().__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.included_tracks = included_tracks


class FromAllInputFile(InputDefinition):
    """An InputDefinition that looks across all of the files provided to select tracks specified by the IncludedTracks property. Generally used with the AudioTrackByAttribute and VideoTrackByAttribute to allow selection of a single track across a set of input files.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar included_tracks: The list of TrackDescriptors which define the metadata and selection of
     tracks in the input.
    :vartype included_tracks: list[~azure.mgmt.media.models.TrackDescriptor]
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "included_tracks": {"key": "includedTracks", "type": "[TrackDescriptor]"},
    }

    def __init__(self, *, included_tracks: Optional[List["_models.TrackDescriptor"]] = None, **kwargs):
        """
        :keyword included_tracks: The list of TrackDescriptors which define the metadata and selection
         of tracks in the input.
        :paramtype included_tracks: list[~azure.mgmt.media.models.TrackDescriptor]
        """
        super().__init__(included_tracks=included_tracks, **kwargs)
        self.odata_type = "#Microsoft.Media.FromAllInputFile"  # type: str


class FromEachInputFile(InputDefinition):
    """An InputDefinition that looks at each input file provided to select tracks specified by the IncludedTracks property. Generally used with the AudioTrackByAttribute and VideoTrackByAttribute to select tracks from each file given.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar included_tracks: The list of TrackDescriptors which define the metadata and selection of
     tracks in the input.
    :vartype included_tracks: list[~azure.mgmt.media.models.TrackDescriptor]
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "included_tracks": {"key": "includedTracks", "type": "[TrackDescriptor]"},
    }

    def __init__(self, *, included_tracks: Optional[List["_models.TrackDescriptor"]] = None, **kwargs):
        """
        :keyword included_tracks: The list of TrackDescriptors which define the metadata and selection
         of tracks in the input.
        :paramtype included_tracks: list[~azure.mgmt.media.models.TrackDescriptor]
        """
        super().__init__(included_tracks=included_tracks, **kwargs)
        self.odata_type = "#Microsoft.Media.FromEachInputFile"  # type: str


class Layer(_serialization.Model):
    """The encoder can be configured to produce video and/or images (thumbnails) at different resolutions, by specifying a layer for each desired resolution. A layer represents the properties for the video or image at a resolution.

    :ivar width: The width of the output video for this layer. The value can be absolute (in
     pixels) or relative (in percentage). For example 50% means the output video has half as many
     pixels in width as the input.
    :vartype width: str
    :ivar height: The height of the output video for this layer. The value can be absolute (in
     pixels) or relative (in percentage). For example 50% means the output video has half as many
     pixels in height as the input.
    :vartype height: str
    :ivar label: The alphanumeric label for this layer, which can be used in multiplexing different
     video and audio layers, or in naming the output file.
    :vartype label: str
    """

    _attribute_map = {
        "width": {"key": "width", "type": "str"},
        "height": {"key": "height", "type": "str"},
        "label": {"key": "label", "type": "str"},
    }

    def __init__(
        self, *, width: Optional[str] = None, height: Optional[str] = None, label: Optional[str] = None, **kwargs
    ):
        """
        :keyword width: The width of the output video for this layer. The value can be absolute (in
         pixels) or relative (in percentage). For example 50% means the output video has half as many
         pixels in width as the input.
        :paramtype width: str
        :keyword height: The height of the output video for this layer. The value can be absolute (in
         pixels) or relative (in percentage). For example 50% means the output video has half as many
         pixels in height as the input.
        :paramtype height: str
        :keyword label: The alphanumeric label for this layer, which can be used in multiplexing
         different video and audio layers, or in naming the output file.
        :paramtype label: str
        """
        super().__init__(**kwargs)
        self.width = width
        self.height = height
        self.label = label


class VideoLayer(Layer):
    """Describes the settings to be used when encoding the input video into a desired output bitrate layer.

    All required parameters must be populated in order to send to Azure.

    :ivar width: The width of the output video for this layer. The value can be absolute (in
     pixels) or relative (in percentage). For example 50% means the output video has half as many
     pixels in width as the input.
    :vartype width: str
    :ivar height: The height of the output video for this layer. The value can be absolute (in
     pixels) or relative (in percentage). For example 50% means the output video has half as many
     pixels in height as the input.
    :vartype height: str
    :ivar label: The alphanumeric label for this layer, which can be used in multiplexing different
     video and audio layers, or in naming the output file.
    :vartype label: str
    :ivar bitrate: The average bitrate in bits per second at which to encode the input video when
     generating this layer. This is a required field. Required.
    :vartype bitrate: int
    :ivar max_bitrate: The maximum bitrate (in bits per second), at which the VBV buffer should be
     assumed to refill. If not specified, defaults to the same value as bitrate.
    :vartype max_bitrate: int
    :ivar b_frames: The number of B-frames to be used when encoding this layer.  If not specified,
     the encoder chooses an appropriate number based on the video profile and level.
    :vartype b_frames: int
    :ivar frame_rate: The frame rate (in frames per second) at which to encode this layer. The
     value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the
     form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame
     rates based on the profile and level. If it is not specified, the encoder will use the same
     frame rate as the input video.
    :vartype frame_rate: str
    :ivar slices: The number of slices to be used when encoding this layer. If not specified,
     default is zero, which means that encoder will use a single slice for each frame.
    :vartype slices: int
    :ivar adaptive_b_frame: Whether or not adaptive B-frames are to be used when encoding this
     layer. If not specified, the encoder will turn it on whenever the video profile permits its
     use.
    :vartype adaptive_b_frame: bool
    """

    _validation = {
        "bitrate": {"required": True},
    }

    _attribute_map = {
        "width": {"key": "width", "type": "str"},
        "height": {"key": "height", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "bitrate": {"key": "bitrate", "type": "int"},
        "max_bitrate": {"key": "maxBitrate", "type": "int"},
        "b_frames": {"key": "bFrames", "type": "int"},
        "frame_rate": {"key": "frameRate", "type": "str"},
        "slices": {"key": "slices", "type": "int"},
        "adaptive_b_frame": {"key": "adaptiveBFrame", "type": "bool"},
    }

    def __init__(
        self,
        *,
        bitrate: int,
        width: Optional[str] = None,
        height: Optional[str] = None,
        label: Optional[str] = None,
        max_bitrate: Optional[int] = None,
        b_frames: Optional[int] = None,
        frame_rate: Optional[str] = None,
        slices: Optional[int] = None,
        adaptive_b_frame: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword width: The width of the output video for this layer. The value can be absolute (in
         pixels) or relative (in percentage). For example 50% means the output video has half as many
         pixels in width as the input.
        :paramtype width: str
        :keyword height: The height of the output video for this layer. The value can be absolute (in
         pixels) or relative (in percentage). For example 50% means the output video has half as many
         pixels in height as the input.
        :paramtype height: str
        :keyword label: The alphanumeric label for this layer, which can be used in multiplexing
         different video and audio layers, or in naming the output file.
        :paramtype label: str
        :keyword bitrate: The average bitrate in bits per second at which to encode the input video
         when generating this layer. This is a required field. Required.
        :paramtype bitrate: int
        :keyword max_bitrate: The maximum bitrate (in bits per second), at which the VBV buffer should
         be assumed to refill. If not specified, defaults to the same value as bitrate.
        :paramtype max_bitrate: int
        :keyword b_frames: The number of B-frames to be used when encoding this layer.  If not
         specified, the encoder chooses an appropriate number based on the video profile and level.
        :paramtype b_frames: int
        :keyword frame_rate: The frame rate (in frames per second) at which to encode this layer. The
         value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the
         form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame
         rates based on the profile and level. If it is not specified, the encoder will use the same
         frame rate as the input video.
        :paramtype frame_rate: str
        :keyword slices: The number of slices to be used when encoding this layer. If not specified,
         default is zero, which means that encoder will use a single slice for each frame.
        :paramtype slices: int
        :keyword adaptive_b_frame: Whether or not adaptive B-frames are to be used when encoding this
         layer. If not specified, the encoder will turn it on whenever the video profile permits its
         use.
        :paramtype adaptive_b_frame: bool
        """
        super().__init__(width=width, height=height, label=label, **kwargs)
        self.bitrate = bitrate
        self.max_bitrate = max_bitrate
        self.b_frames = b_frames
        self.frame_rate = frame_rate
        self.slices = slices
        self.adaptive_b_frame = adaptive_b_frame


class H264Layer(VideoLayer):  # pylint: disable=too-many-instance-attributes
    """Describes the settings to be used when encoding the input video into a desired output bitrate layer with the H.264 video codec.

    All required parameters must be populated in order to send to Azure.

    :ivar width: The width of the output video for this layer. The value can be absolute (in
     pixels) or relative (in percentage). For example 50% means the output video has half as many
     pixels in width as the input.
    :vartype width: str
    :ivar height: The height of the output video for this layer. The value can be absolute (in
     pixels) or relative (in percentage). For example 50% means the output video has half as many
     pixels in height as the input.
    :vartype height: str
    :ivar label: The alphanumeric label for this layer, which can be used in multiplexing different
     video and audio layers, or in naming the output file.
    :vartype label: str
    :ivar bitrate: The average bitrate in bits per second at which to encode the input video when
     generating this layer. This is a required field. Required.
    :vartype bitrate: int
    :ivar max_bitrate: The maximum bitrate (in bits per second), at which the VBV buffer should be
     assumed to refill. If not specified, defaults to the same value as bitrate.
    :vartype max_bitrate: int
    :ivar b_frames: The number of B-frames to be used when encoding this layer.  If not specified,
     the encoder chooses an appropriate number based on the video profile and level.
    :vartype b_frames: int
    :ivar frame_rate: The frame rate (in frames per second) at which to encode this layer. The
     value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the
     form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame
     rates based on the profile and level. If it is not specified, the encoder will use the same
     frame rate as the input video.
    :vartype frame_rate: str
    :ivar slices: The number of slices to be used when encoding this layer. If not specified,
     default is zero, which means that encoder will use a single slice for each frame.
    :vartype slices: int
    :ivar adaptive_b_frame: Whether or not adaptive B-frames are to be used when encoding this
     layer. If not specified, the encoder will turn it on whenever the video profile permits its
     use.
    :vartype adaptive_b_frame: bool
    :ivar profile: We currently support Baseline, Main, High, High422, High444. Default is Auto.
     Known values are: "Auto", "Baseline", "Main", "High", "High422", and "High444".
    :vartype profile: str or ~azure.mgmt.media.models.H264VideoProfile
    :ivar level: We currently support Level up to 6.2. The value can be Auto, or a number that
     matches the H.264 profile. If not specified, the default is Auto, which lets the encoder choose
     the Level that is appropriate for this layer.
    :vartype level: str
    :ivar buffer_window: The VBV buffer window length. The value should be in ISO 8601 format. The
     value should be in the range [0.1-100] seconds. The default is 5 seconds (for example, PT5S).
    :vartype buffer_window: ~datetime.timedelta
    :ivar crf: The value of CRF to be used when encoding this layer. This setting takes effect when
     RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51,
     where lower values would result in better quality, at the expense of higher file sizes. Higher
     values mean more compression, but at some point quality degradation will be noticed. Default
     value is 23.
    :vartype crf: float
    :ivar reference_frames: The number of reference frames to be used when encoding this layer. If
     not specified, the encoder determines an appropriate number based on the encoder complexity
     setting.
    :vartype reference_frames: int
    :ivar entropy_mode: The entropy mode to be used for this layer. If not specified, the encoder
     chooses the mode that is appropriate for the profile and level. Known values are: "Cabac" and
     "Cavlc".
    :vartype entropy_mode: str or ~azure.mgmt.media.models.EntropyMode
    """

    _validation = {
        "bitrate": {"required": True},
    }

    _attribute_map = {
        "width": {"key": "width", "type": "str"},
        "height": {"key": "height", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "bitrate": {"key": "bitrate", "type": "int"},
        "max_bitrate": {"key": "maxBitrate", "type": "int"},
        "b_frames": {"key": "bFrames", "type": "int"},
        "frame_rate": {"key": "frameRate", "type": "str"},
        "slices": {"key": "slices", "type": "int"},
        "adaptive_b_frame": {"key": "adaptiveBFrame", "type": "bool"},
        "profile": {"key": "profile", "type": "str"},
        "level": {"key": "level", "type": "str"},
        "buffer_window": {"key": "bufferWindow", "type": "duration"},
        "crf": {"key": "crf", "type": "float"},
        "reference_frames": {"key": "referenceFrames", "type": "int"},
        "entropy_mode": {"key": "entropyMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        bitrate: int,
        width: Optional[str] = None,
        height: Optional[str] = None,
        label: Optional[str] = None,
        max_bitrate: Optional[int] = None,
        b_frames: Optional[int] = None,
        frame_rate: Optional[str] = None,
        slices: Optional[int] = None,
        adaptive_b_frame: Optional[bool] = None,
        profile: Optional[Union[str, "_models.H264VideoProfile"]] = None,
        level: Optional[str] = None,
        buffer_window: Optional[datetime.timedelta] = None,
        crf: Optional[float] = None,
        reference_frames: Optional[int] = None,
        entropy_mode: Optional[Union[str, "_models.EntropyMode"]] = None,
        **kwargs
    ):
        """
        :keyword width: The width of the output video for this layer. The value can be absolute (in
         pixels) or relative (in percentage). For example 50% means the output video has half as many
         pixels in width as the input.
        :paramtype width: str
        :keyword height: The height of the output video for this layer. The value can be absolute (in
         pixels) or relative (in percentage). For example 50% means the output video has half as many
         pixels in height as the input.
        :paramtype height: str
        :keyword label: The alphanumeric label for this layer, which can be used in multiplexing
         different video and audio layers, or in naming the output file.
        :paramtype label: str
        :keyword bitrate: The average bitrate in bits per second at which to encode the input video
         when generating this layer. This is a required field. Required.
        :paramtype bitrate: int
        :keyword max_bitrate: The maximum bitrate (in bits per second), at which the VBV buffer should
         be assumed to refill. If not specified, defaults to the same value as bitrate.
        :paramtype max_bitrate: int
        :keyword b_frames: The number of B-frames to be used when encoding this layer.  If not
         specified, the encoder chooses an appropriate number based on the video profile and level.
        :paramtype b_frames: int
        :keyword frame_rate: The frame rate (in frames per second) at which to encode this layer. The
         value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the
         form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame
         rates based on the profile and level. If it is not specified, the encoder will use the same
         frame rate as the input video.
        :paramtype frame_rate: str
        :keyword slices: The number of slices to be used when encoding this layer. If not specified,
         default is zero, which means that encoder will use a single slice for each frame.
        :paramtype slices: int
        :keyword adaptive_b_frame: Whether or not adaptive B-frames are to be used when encoding this
         layer. If not specified, the encoder will turn it on whenever the video profile permits its
         use.
        :paramtype adaptive_b_frame: bool
        :keyword profile: We currently support Baseline, Main, High, High422, High444. Default is Auto.
         Known values are: "Auto", "Baseline", "Main", "High", "High422", and "High444".
        :paramtype profile: str or ~azure.mgmt.media.models.H264VideoProfile
        :keyword level: We currently support Level up to 6.2. The value can be Auto, or a number that
         matches the H.264 profile. If not specified, the default is Auto, which lets the encoder choose
         the Level that is appropriate for this layer.
        :paramtype level: str
        :keyword buffer_window: The VBV buffer window length. The value should be in ISO 8601 format.
         The value should be in the range [0.1-100] seconds. The default is 5 seconds (for example,
         PT5S).
        :paramtype buffer_window: ~datetime.timedelta
        :keyword crf: The value of CRF to be used when encoding this layer. This setting takes effect
         when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and
         51, where lower values would result in better quality, at the expense of higher file sizes.
         Higher values mean more compression, but at some point quality degradation will be noticed.
         Default value is 23.
        :paramtype crf: float
        :keyword reference_frames: The number of reference frames to be used when encoding this layer.
         If not specified, the encoder determines an appropriate number based on the encoder complexity
         setting.
        :paramtype reference_frames: int
        :keyword entropy_mode: The entropy mode to be used for this layer. If not specified, the
         encoder chooses the mode that is appropriate for the profile and level. Known values are:
         "Cabac" and "Cavlc".
        :paramtype entropy_mode: str or ~azure.mgmt.media.models.EntropyMode
        """
        super().__init__(
            width=width,
            height=height,
            label=label,
            bitrate=bitrate,
            max_bitrate=max_bitrate,
            b_frames=b_frames,
            frame_rate=frame_rate,
            slices=slices,
            adaptive_b_frame=adaptive_b_frame,
            **kwargs
        )
        self.profile = profile
        self.level = level
        self.buffer_window = buffer_window
        self.crf = crf
        self.reference_frames = reference_frames
        self.entropy_mode = entropy_mode


class Video(Codec):
    """Describes the basic properties for encoding the input video.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    H264Video, H265Video, Image

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar label: An optional label for the codec. The label can be used to control muxing behavior.
    :vartype label: str
    :ivar key_frame_interval: The distance between two key frames. The value should be non-zero in
     the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note
     that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval
     value will follow the input source setting.
    :vartype key_frame_interval: ~datetime.timedelta
    :ivar stretch_mode: The resizing mode - how the input video will be resized to fit the desired
     output resolution(s). Default is AutoSize. Known values are: "None", "AutoSize", and "AutoFit".
    :vartype stretch_mode: str or ~azure.mgmt.media.models.StretchMode
    :ivar sync_mode: The Video Sync Mode. Known values are: "Auto", "Passthrough", "Cfr", and
     "Vfr".
    :vartype sync_mode: str or ~azure.mgmt.media.models.VideoSyncMode
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "key_frame_interval": {"key": "keyFrameInterval", "type": "duration"},
        "stretch_mode": {"key": "stretchMode", "type": "str"},
        "sync_mode": {"key": "syncMode", "type": "str"},
    }

    _subtype_map = {
        "odata_type": {
            "#Microsoft.Media.H264Video": "H264Video",
            "#Microsoft.Media.H265Video": "H265Video",
            "#Microsoft.Media.Image": "Image",
        }
    }

    def __init__(
        self,
        *,
        label: Optional[str] = None,
        key_frame_interval: Optional[datetime.timedelta] = None,
        stretch_mode: Optional[Union[str, "_models.StretchMode"]] = None,
        sync_mode: Optional[Union[str, "_models.VideoSyncMode"]] = None,
        **kwargs
    ):
        """
        :keyword label: An optional label for the codec. The label can be used to control muxing
         behavior.
        :paramtype label: str
        :keyword key_frame_interval: The distance between two key frames. The value should be non-zero
         in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S).
         Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the
         KeyFrameInterval value will follow the input source setting.
        :paramtype key_frame_interval: ~datetime.timedelta
        :keyword stretch_mode: The resizing mode - how the input video will be resized to fit the
         desired output resolution(s). Default is AutoSize. Known values are: "None", "AutoSize", and
         "AutoFit".
        :paramtype stretch_mode: str or ~azure.mgmt.media.models.StretchMode
        :keyword sync_mode: The Video Sync Mode. Known values are: "Auto", "Passthrough", "Cfr", and
         "Vfr".
        :paramtype sync_mode: str or ~azure.mgmt.media.models.VideoSyncMode
        """
        super().__init__(label=label, **kwargs)
        self.odata_type = "#Microsoft.Media.Video"  # type: str
        self.key_frame_interval = key_frame_interval
        self.stretch_mode = stretch_mode
        self.sync_mode = sync_mode


class H264Video(Video):
    """Describes all the properties for encoding a video with the H.264 codec.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar label: An optional label for the codec. The label can be used to control muxing behavior.
    :vartype label: str
    :ivar key_frame_interval: The distance between two key frames. The value should be non-zero in
     the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note
     that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval
     value will follow the input source setting.
    :vartype key_frame_interval: ~datetime.timedelta
    :ivar stretch_mode: The resizing mode - how the input video will be resized to fit the desired
     output resolution(s). Default is AutoSize. Known values are: "None", "AutoSize", and "AutoFit".
    :vartype stretch_mode: str or ~azure.mgmt.media.models.StretchMode
    :ivar sync_mode: The Video Sync Mode. Known values are: "Auto", "Passthrough", "Cfr", and
     "Vfr".
    :vartype sync_mode: str or ~azure.mgmt.media.models.VideoSyncMode
    :ivar complexity: Tells the encoder how to choose its encoding settings. The default value is
     Balanced. Known values are: "Speed", "Balanced", and "Quality".
    :vartype complexity: str or ~azure.mgmt.media.models.H264Complexity
    :ivar layers: The collection of output H.264 layers to be produced by the encoder.
    :vartype layers: list[~azure.mgmt.media.models.H264Layer]
    :ivar rate_control_mode: The video rate control mode. Known values are: "ABR", "CBR", and
     "CRF".
    :vartype rate_control_mode: str or ~azure.mgmt.media.models.H264RateControlMode
    :ivar scene_change_detection: Whether or not the encoder should insert key frames at scene
     changes. If not specified, the default is false. This flag should be set to true only when the
     encoder is being configured to produce a single output video.
    :vartype scene_change_detection: bool
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "key_frame_interval": {"key": "keyFrameInterval", "type": "duration"},
        "stretch_mode": {"key": "stretchMode", "type": "str"},
        "sync_mode": {"key": "syncMode", "type": "str"},
        "complexity": {"key": "complexity", "type": "str"},
        "layers": {"key": "layers", "type": "[H264Layer]"},
        "rate_control_mode": {"key": "rateControlMode", "type": "str"},
        "scene_change_detection": {"key": "sceneChangeDetection", "type": "bool"},
    }

    def __init__(
        self,
        *,
        label: Optional[str] = None,
        key_frame_interval: Optional[datetime.timedelta] = None,
        stretch_mode: Optional[Union[str, "_models.StretchMode"]] = None,
        sync_mode: Optional[Union[str, "_models.VideoSyncMode"]] = None,
        complexity: Optional[Union[str, "_models.H264Complexity"]] = None,
        layers: Optional[List["_models.H264Layer"]] = None,
        rate_control_mode: Optional[Union[str, "_models.H264RateControlMode"]] = None,
        scene_change_detection: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword label: An optional label for the codec. The label can be used to control muxing
         behavior.
        :paramtype label: str
        :keyword key_frame_interval: The distance between two key frames. The value should be non-zero
         in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S).
         Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the
         KeyFrameInterval value will follow the input source setting.
        :paramtype key_frame_interval: ~datetime.timedelta
        :keyword stretch_mode: The resizing mode - how the input video will be resized to fit the
         desired output resolution(s). Default is AutoSize. Known values are: "None", "AutoSize", and
         "AutoFit".
        :paramtype stretch_mode: str or ~azure.mgmt.media.models.StretchMode
        :keyword sync_mode: The Video Sync Mode. Known values are: "Auto", "Passthrough", "Cfr", and
         "Vfr".
        :paramtype sync_mode: str or ~azure.mgmt.media.models.VideoSyncMode
        :keyword complexity: Tells the encoder how to choose its encoding settings. The default value
         is Balanced. Known values are: "Speed", "Balanced", and "Quality".
        :paramtype complexity: str or ~azure.mgmt.media.models.H264Complexity
        :keyword layers: The collection of output H.264 layers to be produced by the encoder.
        :paramtype layers: list[~azure.mgmt.media.models.H264Layer]
        :keyword rate_control_mode: The video rate control mode. Known values are: "ABR", "CBR", and
         "CRF".
        :paramtype rate_control_mode: str or ~azure.mgmt.media.models.H264RateControlMode
        :keyword scene_change_detection: Whether or not the encoder should insert key frames at scene
         changes. If not specified, the default is false. This flag should be set to true only when the
         encoder is being configured to produce a single output video.
        :paramtype scene_change_detection: bool
        """
        super().__init__(
            label=label, key_frame_interval=key_frame_interval, stretch_mode=stretch_mode, sync_mode=sync_mode, **kwargs
        )
        self.odata_type = "#Microsoft.Media.H264Video"  # type: str
        self.complexity = complexity
        self.layers = layers
        self.rate_control_mode = rate_control_mode
        self.scene_change_detection = scene_change_detection


class H265VideoLayer(Layer):
    """Describes the settings to be used when encoding the input video into a desired output bitrate layer.

    All required parameters must be populated in order to send to Azure.

    :ivar width: The width of the output video for this layer. The value can be absolute (in
     pixels) or relative (in percentage). For example 50% means the output video has half as many
     pixels in width as the input.
    :vartype width: str
    :ivar height: The height of the output video for this layer. The value can be absolute (in
     pixels) or relative (in percentage). For example 50% means the output video has half as many
     pixels in height as the input.
    :vartype height: str
    :ivar label: The alphanumeric label for this layer, which can be used in multiplexing different
     video and audio layers, or in naming the output file.
    :vartype label: str
    :ivar bitrate: The average bitrate in bits per second at which to encode the input video when
     generating this layer. For example: a target bitrate of 3000Kbps or 3Mbps means this value
     should be 3000000 This is a required field. Required.
    :vartype bitrate: int
    :ivar max_bitrate: The maximum bitrate (in bits per second), at which the VBV buffer should be
     assumed to refill. If not specified, defaults to the same value as bitrate.
    :vartype max_bitrate: int
    :ivar b_frames: The number of B-frames to be used when encoding this layer.  If not specified,
     the encoder chooses an appropriate number based on the video profile and level.
    :vartype b_frames: int
    :ivar frame_rate: The frame rate (in frames per second) at which to encode this layer. The
     value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the
     form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame
     rates based on the profile and level. If it is not specified, the encoder will use the same
     frame rate as the input video.
    :vartype frame_rate: str
    :ivar slices: The number of slices to be used when encoding this layer. If not specified,
     default is zero, which means that encoder will use a single slice for each frame.
    :vartype slices: int
    :ivar adaptive_b_frame: Specifies whether or not adaptive B-frames are to be used when encoding
     this layer. If not specified, the encoder will turn it on whenever the video profile permits
     its use.
    :vartype adaptive_b_frame: bool
    """

    _validation = {
        "bitrate": {"required": True},
    }

    _attribute_map = {
        "width": {"key": "width", "type": "str"},
        "height": {"key": "height", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "bitrate": {"key": "bitrate", "type": "int"},
        "max_bitrate": {"key": "maxBitrate", "type": "int"},
        "b_frames": {"key": "bFrames", "type": "int"},
        "frame_rate": {"key": "frameRate", "type": "str"},
        "slices": {"key": "slices", "type": "int"},
        "adaptive_b_frame": {"key": "adaptiveBFrame", "type": "bool"},
    }

    def __init__(
        self,
        *,
        bitrate: int,
        width: Optional[str] = None,
        height: Optional[str] = None,
        label: Optional[str] = None,
        max_bitrate: Optional[int] = None,
        b_frames: Optional[int] = None,
        frame_rate: Optional[str] = None,
        slices: Optional[int] = None,
        adaptive_b_frame: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword width: The width of the output video for this layer. The value can be absolute (in
         pixels) or relative (in percentage). For example 50% means the output video has half as many
         pixels in width as the input.
        :paramtype width: str
        :keyword height: The height of the output video for this layer. The value can be absolute (in
         pixels) or relative (in percentage). For example 50% means the output video has half as many
         pixels in height as the input.
        :paramtype height: str
        :keyword label: The alphanumeric label for this layer, which can be used in multiplexing
         different video and audio layers, or in naming the output file.
        :paramtype label: str
        :keyword bitrate: The average bitrate in bits per second at which to encode the input video
         when generating this layer. For example: a target bitrate of 3000Kbps or 3Mbps means this value
         should be 3000000 This is a required field. Required.
        :paramtype bitrate: int
        :keyword max_bitrate: The maximum bitrate (in bits per second), at which the VBV buffer should
         be assumed to refill. If not specified, defaults to the same value as bitrate.
        :paramtype max_bitrate: int
        :keyword b_frames: The number of B-frames to be used when encoding this layer.  If not
         specified, the encoder chooses an appropriate number based on the video profile and level.
        :paramtype b_frames: int
        :keyword frame_rate: The frame rate (in frames per second) at which to encode this layer. The
         value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the
         form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame
         rates based on the profile and level. If it is not specified, the encoder will use the same
         frame rate as the input video.
        :paramtype frame_rate: str
        :keyword slices: The number of slices to be used when encoding this layer. If not specified,
         default is zero, which means that encoder will use a single slice for each frame.
        :paramtype slices: int
        :keyword adaptive_b_frame: Specifies whether or not adaptive B-frames are to be used when
         encoding this layer. If not specified, the encoder will turn it on whenever the video profile
         permits its use.
        :paramtype adaptive_b_frame: bool
        """
        super().__init__(width=width, height=height, label=label, **kwargs)
        self.bitrate = bitrate
        self.max_bitrate = max_bitrate
        self.b_frames = b_frames
        self.frame_rate = frame_rate
        self.slices = slices
        self.adaptive_b_frame = adaptive_b_frame


class H265Layer(H265VideoLayer):  # pylint: disable=too-many-instance-attributes
    """Describes the settings to be used when encoding the input video into a desired output bitrate layer with the H.265 video codec.

    All required parameters must be populated in order to send to Azure.

    :ivar width: The width of the output video for this layer. The value can be absolute (in
     pixels) or relative (in percentage). For example 50% means the output video has half as many
     pixels in width as the input.
    :vartype width: str
    :ivar height: The height of the output video for this layer. The value can be absolute (in
     pixels) or relative (in percentage). For example 50% means the output video has half as many
     pixels in height as the input.
    :vartype height: str
    :ivar label: The alphanumeric label for this layer, which can be used in multiplexing different
     video and audio layers, or in naming the output file.
    :vartype label: str
    :ivar bitrate: The average bitrate in bits per second at which to encode the input video when
     generating this layer. For example: a target bitrate of 3000Kbps or 3Mbps means this value
     should be 3000000 This is a required field. Required.
    :vartype bitrate: int
    :ivar max_bitrate: The maximum bitrate (in bits per second), at which the VBV buffer should be
     assumed to refill. If not specified, defaults to the same value as bitrate.
    :vartype max_bitrate: int
    :ivar b_frames: The number of B-frames to be used when encoding this layer.  If not specified,
     the encoder chooses an appropriate number based on the video profile and level.
    :vartype b_frames: int
    :ivar frame_rate: The frame rate (in frames per second) at which to encode this layer. The
     value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the
     form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame
     rates based on the profile and level. If it is not specified, the encoder will use the same
     frame rate as the input video.
    :vartype frame_rate: str
    :ivar slices: The number of slices to be used when encoding this layer. If not specified,
     default is zero, which means that encoder will use a single slice for each frame.
    :vartype slices: int
    :ivar adaptive_b_frame: Specifies whether or not adaptive B-frames are to be used when encoding
     this layer. If not specified, the encoder will turn it on whenever the video profile permits
     its use.
    :vartype adaptive_b_frame: bool
    :ivar profile: We currently support Main. Default is Auto. Known values are: "Auto", "Main",
     and "Main10".
    :vartype profile: str or ~azure.mgmt.media.models.H265VideoProfile
    :ivar level: We currently support Level up to 6.2. The value can be Auto, or a number that
     matches the H.265 profile. If not specified, the default is Auto, which lets the encoder choose
     the Level that is appropriate for this layer.
    :vartype level: str
    :ivar buffer_window: The VBV buffer window length. The value should be in ISO 8601 format. The
     value should be in the range [0.1-100] seconds. The default is 5 seconds (for example, PT5S).
    :vartype buffer_window: ~datetime.timedelta
    :ivar crf: The value of CRF to be used when encoding this layer. This setting takes effect when
     RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and 51,
     where lower values would result in better quality, at the expense of higher file sizes. Higher
     values mean more compression, but at some point quality degradation will be noticed. Default
     value is 28.
    :vartype crf: float
    :ivar reference_frames: The number of reference frames to be used when encoding this layer. If
     not specified, the encoder determines an appropriate number based on the encoder complexity
     setting.
    :vartype reference_frames: int
    """

    _validation = {
        "bitrate": {"required": True},
    }

    _attribute_map = {
        "width": {"key": "width", "type": "str"},
        "height": {"key": "height", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "bitrate": {"key": "bitrate", "type": "int"},
        "max_bitrate": {"key": "maxBitrate", "type": "int"},
        "b_frames": {"key": "bFrames", "type": "int"},
        "frame_rate": {"key": "frameRate", "type": "str"},
        "slices": {"key": "slices", "type": "int"},
        "adaptive_b_frame": {"key": "adaptiveBFrame", "type": "bool"},
        "profile": {"key": "profile", "type": "str"},
        "level": {"key": "level", "type": "str"},
        "buffer_window": {"key": "bufferWindow", "type": "duration"},
        "crf": {"key": "crf", "type": "float"},
        "reference_frames": {"key": "referenceFrames", "type": "int"},
    }

    def __init__(
        self,
        *,
        bitrate: int,
        width: Optional[str] = None,
        height: Optional[str] = None,
        label: Optional[str] = None,
        max_bitrate: Optional[int] = None,
        b_frames: Optional[int] = None,
        frame_rate: Optional[str] = None,
        slices: Optional[int] = None,
        adaptive_b_frame: Optional[bool] = None,
        profile: Optional[Union[str, "_models.H265VideoProfile"]] = None,
        level: Optional[str] = None,
        buffer_window: Optional[datetime.timedelta] = None,
        crf: Optional[float] = None,
        reference_frames: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword width: The width of the output video for this layer. The value can be absolute (in
         pixels) or relative (in percentage). For example 50% means the output video has half as many
         pixels in width as the input.
        :paramtype width: str
        :keyword height: The height of the output video for this layer. The value can be absolute (in
         pixels) or relative (in percentage). For example 50% means the output video has half as many
         pixels in height as the input.
        :paramtype height: str
        :keyword label: The alphanumeric label for this layer, which can be used in multiplexing
         different video and audio layers, or in naming the output file.
        :paramtype label: str
        :keyword bitrate: The average bitrate in bits per second at which to encode the input video
         when generating this layer. For example: a target bitrate of 3000Kbps or 3Mbps means this value
         should be 3000000 This is a required field. Required.
        :paramtype bitrate: int
        :keyword max_bitrate: The maximum bitrate (in bits per second), at which the VBV buffer should
         be assumed to refill. If not specified, defaults to the same value as bitrate.
        :paramtype max_bitrate: int
        :keyword b_frames: The number of B-frames to be used when encoding this layer.  If not
         specified, the encoder chooses an appropriate number based on the video profile and level.
        :paramtype b_frames: int
        :keyword frame_rate: The frame rate (in frames per second) at which to encode this layer. The
         value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the
         form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame
         rates based on the profile and level. If it is not specified, the encoder will use the same
         frame rate as the input video.
        :paramtype frame_rate: str
        :keyword slices: The number of slices to be used when encoding this layer. If not specified,
         default is zero, which means that encoder will use a single slice for each frame.
        :paramtype slices: int
        :keyword adaptive_b_frame: Specifies whether or not adaptive B-frames are to be used when
         encoding this layer. If not specified, the encoder will turn it on whenever the video profile
         permits its use.
        :paramtype adaptive_b_frame: bool
        :keyword profile: We currently support Main. Default is Auto. Known values are: "Auto", "Main",
         and "Main10".
        :paramtype profile: str or ~azure.mgmt.media.models.H265VideoProfile
        :keyword level: We currently support Level up to 6.2. The value can be Auto, or a number that
         matches the H.265 profile. If not specified, the default is Auto, which lets the encoder choose
         the Level that is appropriate for this layer.
        :paramtype level: str
        :keyword buffer_window: The VBV buffer window length. The value should be in ISO 8601 format.
         The value should be in the range [0.1-100] seconds. The default is 5 seconds (for example,
         PT5S).
        :paramtype buffer_window: ~datetime.timedelta
        :keyword crf: The value of CRF to be used when encoding this layer. This setting takes effect
         when RateControlMode of video codec is set at CRF mode. The range of CRF value is between 0 and
         51, where lower values would result in better quality, at the expense of higher file sizes.
         Higher values mean more compression, but at some point quality degradation will be noticed.
         Default value is 28.
        :paramtype crf: float
        :keyword reference_frames: The number of reference frames to be used when encoding this layer.
         If not specified, the encoder determines an appropriate number based on the encoder complexity
         setting.
        :paramtype reference_frames: int
        """
        super().__init__(
            width=width,
            height=height,
            label=label,
            bitrate=bitrate,
            max_bitrate=max_bitrate,
            b_frames=b_frames,
            frame_rate=frame_rate,
            slices=slices,
            adaptive_b_frame=adaptive_b_frame,
            **kwargs
        )
        self.profile = profile
        self.level = level
        self.buffer_window = buffer_window
        self.crf = crf
        self.reference_frames = reference_frames


class H265Video(Video):
    """Describes all the properties for encoding a video with the H.265 codec.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar label: An optional label for the codec. The label can be used to control muxing behavior.
    :vartype label: str
    :ivar key_frame_interval: The distance between two key frames. The value should be non-zero in
     the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note
     that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval
     value will follow the input source setting.
    :vartype key_frame_interval: ~datetime.timedelta
    :ivar stretch_mode: The resizing mode - how the input video will be resized to fit the desired
     output resolution(s). Default is AutoSize. Known values are: "None", "AutoSize", and "AutoFit".
    :vartype stretch_mode: str or ~azure.mgmt.media.models.StretchMode
    :ivar sync_mode: The Video Sync Mode. Known values are: "Auto", "Passthrough", "Cfr", and
     "Vfr".
    :vartype sync_mode: str or ~azure.mgmt.media.models.VideoSyncMode
    :ivar scene_change_detection: Specifies whether or not the encoder should insert key frames at
     scene changes. If not specified, the default is false. This flag should be set to true only
     when the encoder is being configured to produce a single output video.
    :vartype scene_change_detection: bool
    :ivar complexity: Tells the encoder how to choose its encoding settings.  Quality will provide
     for a higher compression ratio but at a higher cost and longer compute time.  Speed will
     produce a relatively larger file but is faster and more economical. The default value is
     Balanced. Known values are: "Speed", "Balanced", and "Quality".
    :vartype complexity: str or ~azure.mgmt.media.models.H265Complexity
    :ivar layers: The collection of output H.265 layers to be produced by the encoder.
    :vartype layers: list[~azure.mgmt.media.models.H265Layer]
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "key_frame_interval": {"key": "keyFrameInterval", "type": "duration"},
        "stretch_mode": {"key": "stretchMode", "type": "str"},
        "sync_mode": {"key": "syncMode", "type": "str"},
        "scene_change_detection": {"key": "sceneChangeDetection", "type": "bool"},
        "complexity": {"key": "complexity", "type": "str"},
        "layers": {"key": "layers", "type": "[H265Layer]"},
    }

    def __init__(
        self,
        *,
        label: Optional[str] = None,
        key_frame_interval: Optional[datetime.timedelta] = None,
        stretch_mode: Optional[Union[str, "_models.StretchMode"]] = None,
        sync_mode: Optional[Union[str, "_models.VideoSyncMode"]] = None,
        scene_change_detection: Optional[bool] = None,
        complexity: Optional[Union[str, "_models.H265Complexity"]] = None,
        layers: Optional[List["_models.H265Layer"]] = None,
        **kwargs
    ):
        """
        :keyword label: An optional label for the codec. The label can be used to control muxing
         behavior.
        :paramtype label: str
        :keyword key_frame_interval: The distance between two key frames. The value should be non-zero
         in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S).
         Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the
         KeyFrameInterval value will follow the input source setting.
        :paramtype key_frame_interval: ~datetime.timedelta
        :keyword stretch_mode: The resizing mode - how the input video will be resized to fit the
         desired output resolution(s). Default is AutoSize. Known values are: "None", "AutoSize", and
         "AutoFit".
        :paramtype stretch_mode: str or ~azure.mgmt.media.models.StretchMode
        :keyword sync_mode: The Video Sync Mode. Known values are: "Auto", "Passthrough", "Cfr", and
         "Vfr".
        :paramtype sync_mode: str or ~azure.mgmt.media.models.VideoSyncMode
        :keyword scene_change_detection: Specifies whether or not the encoder should insert key frames
         at scene changes. If not specified, the default is false. This flag should be set to true only
         when the encoder is being configured to produce a single output video.
        :paramtype scene_change_detection: bool
        :keyword complexity: Tells the encoder how to choose its encoding settings.  Quality will
         provide for a higher compression ratio but at a higher cost and longer compute time.  Speed
         will produce a relatively larger file but is faster and more economical. The default value is
         Balanced. Known values are: "Speed", "Balanced", and "Quality".
        :paramtype complexity: str or ~azure.mgmt.media.models.H265Complexity
        :keyword layers: The collection of output H.265 layers to be produced by the encoder.
        :paramtype layers: list[~azure.mgmt.media.models.H265Layer]
        """
        super().__init__(
            label=label, key_frame_interval=key_frame_interval, stretch_mode=stretch_mode, sync_mode=sync_mode, **kwargs
        )
        self.odata_type = "#Microsoft.Media.H265Video"  # type: str
        self.scene_change_detection = scene_change_detection
        self.complexity = complexity
        self.layers = layers


class Hls(_serialization.Model):
    """HTTP Live Streaming (HLS) packing setting for the live output.

    :ivar fragments_per_ts_segment: The number of fragments in an HTTP Live Streaming (HLS) TS
     segment in the output of the live event. This value does not affect the packing ratio for HLS
     CMAF output.
    :vartype fragments_per_ts_segment: int
    """

    _attribute_map = {
        "fragments_per_ts_segment": {"key": "fragmentsPerTsSegment", "type": "int"},
    }

    def __init__(self, *, fragments_per_ts_segment: Optional[int] = None, **kwargs):
        """
        :keyword fragments_per_ts_segment: The number of fragments in an HTTP Live Streaming (HLS) TS
         segment in the output of the live event. This value does not affect the packing ratio for HLS
         CMAF output.
        :paramtype fragments_per_ts_segment: int
        """
        super().__init__(**kwargs)
        self.fragments_per_ts_segment = fragments_per_ts_segment


class HlsSettings(_serialization.Model):
    """The HLS setting for a track.

    :ivar default: The default for the HLS setting.
    :vartype default: bool
    :ivar forced: The forced for the HLS setting.
    :vartype forced: bool
    :ivar characteristics: The characteristics for the HLS setting.
    :vartype characteristics: str
    """

    _attribute_map = {
        "default": {"key": "default", "type": "bool"},
        "forced": {"key": "forced", "type": "bool"},
        "characteristics": {"key": "characteristics", "type": "str"},
    }

    def __init__(
        self,
        *,
        default: Optional[bool] = None,
        forced: Optional[bool] = None,
        characteristics: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword default: The default for the HLS setting.
        :paramtype default: bool
        :keyword forced: The forced for the HLS setting.
        :paramtype forced: bool
        :keyword characteristics: The characteristics for the HLS setting.
        :paramtype characteristics: str
        """
        super().__init__(**kwargs)
        self.default = default
        self.forced = forced
        self.characteristics = characteristics


class Image(Video):
    """Describes the basic properties for generating thumbnails from the input video.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    JpgImage, PngImage

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar label: An optional label for the codec. The label can be used to control muxing behavior.
    :vartype label: str
    :ivar key_frame_interval: The distance between two key frames. The value should be non-zero in
     the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note
     that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval
     value will follow the input source setting.
    :vartype key_frame_interval: ~datetime.timedelta
    :ivar stretch_mode: The resizing mode - how the input video will be resized to fit the desired
     output resolution(s). Default is AutoSize. Known values are: "None", "AutoSize", and "AutoFit".
    :vartype stretch_mode: str or ~azure.mgmt.media.models.StretchMode
    :ivar sync_mode: The Video Sync Mode. Known values are: "Auto", "Passthrough", "Cfr", and
     "Vfr".
    :vartype sync_mode: str or ~azure.mgmt.media.models.VideoSyncMode
    :ivar start: The position in the input video from where to start generating thumbnails. The
     value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count
     (For example, 10 to start at the 10th frame), or a relative value to stream duration (For
     example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the
     encoder to select the best thumbnail from the first few seconds of the video and will only
     produce one thumbnail, no matter what other settings are for Step and Range. The default value
     is macro {Best}. Required.
    :vartype start: str
    :ivar step: The intervals at which thumbnails are generated. The value can be in ISO 8601
     format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30
     for one image every 30 frames), or a relative value to stream duration (For example, 10% for
     one image every 10% of stream duration). Note: Step value will affect the first generated
     thumbnail, which may not be exactly the one specified at transform preset start time. This is
     due to the encoder, which tries to select the best thumbnail between start time and Step
     position from start time as the first output. As the default value is 10%, it means if stream
     has long duration, the first generated thumbnail might be far away from the one specified at
     start time. Try to select reasonable value for Step if the first thumbnail is expected close to
     start time, or set Range value at 1 if only one thumbnail is needed at start time.
    :vartype step: str
    :ivar range: The position relative to transform preset start time in the input video at which
     to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to
     stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop
     at the 300th frame from the frame at start time. If this value is 1, it means only producing
     one thumbnail at start time), or a relative value to the stream duration (For example, 50% to
     stop at half of stream duration from start time). The default value is 100%, which means to
     stop at the end of the stream.
    :vartype range: str
    """

    _validation = {
        "odata_type": {"required": True},
        "start": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "key_frame_interval": {"key": "keyFrameInterval", "type": "duration"},
        "stretch_mode": {"key": "stretchMode", "type": "str"},
        "sync_mode": {"key": "syncMode", "type": "str"},
        "start": {"key": "start", "type": "str"},
        "step": {"key": "step", "type": "str"},
        "range": {"key": "range", "type": "str"},
    }

    _subtype_map = {"odata_type": {"#Microsoft.Media.JpgImage": "JpgImage", "#Microsoft.Media.PngImage": "PngImage"}}

    def __init__(
        self,
        *,
        start: str,
        label: Optional[str] = None,
        key_frame_interval: Optional[datetime.timedelta] = None,
        stretch_mode: Optional[Union[str, "_models.StretchMode"]] = None,
        sync_mode: Optional[Union[str, "_models.VideoSyncMode"]] = None,
        step: Optional[str] = None,
        range: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword label: An optional label for the codec. The label can be used to control muxing
         behavior.
        :paramtype label: str
        :keyword key_frame_interval: The distance between two key frames. The value should be non-zero
         in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S).
         Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the
         KeyFrameInterval value will follow the input source setting.
        :paramtype key_frame_interval: ~datetime.timedelta
        :keyword stretch_mode: The resizing mode - how the input video will be resized to fit the
         desired output resolution(s). Default is AutoSize. Known values are: "None", "AutoSize", and
         "AutoFit".
        :paramtype stretch_mode: str or ~azure.mgmt.media.models.StretchMode
        :keyword sync_mode: The Video Sync Mode. Known values are: "Auto", "Passthrough", "Cfr", and
         "Vfr".
        :paramtype sync_mode: str or ~azure.mgmt.media.models.VideoSyncMode
        :keyword start: The position in the input video from where to start generating thumbnails. The
         value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count
         (For example, 10 to start at the 10th frame), or a relative value to stream duration (For
         example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the
         encoder to select the best thumbnail from the first few seconds of the video and will only
         produce one thumbnail, no matter what other settings are for Step and Range. The default value
         is macro {Best}. Required.
        :paramtype start: str
        :keyword step: The intervals at which thumbnails are generated. The value can be in ISO 8601
         format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30
         for one image every 30 frames), or a relative value to stream duration (For example, 10% for
         one image every 10% of stream duration). Note: Step value will affect the first generated
         thumbnail, which may not be exactly the one specified at transform preset start time. This is
         due to the encoder, which tries to select the best thumbnail between start time and Step
         position from start time as the first output. As the default value is 10%, it means if stream
         has long duration, the first generated thumbnail might be far away from the one specified at
         start time. Try to select reasonable value for Step if the first thumbnail is expected close to
         start time, or set Range value at 1 if only one thumbnail is needed at start time.
        :paramtype step: str
        :keyword range: The position relative to transform preset start time in the input video at
         which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S
         to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to
         stop at the 300th frame from the frame at start time. If this value is 1, it means only
         producing one thumbnail at start time), or a relative value to the stream duration (For
         example, 50% to stop at half of stream duration from start time). The default value is 100%,
         which means to stop at the end of the stream.
        :paramtype range: str
        """
        super().__init__(
            label=label, key_frame_interval=key_frame_interval, stretch_mode=stretch_mode, sync_mode=sync_mode, **kwargs
        )
        self.odata_type = "#Microsoft.Media.Image"  # type: str
        self.start = start
        self.step = step
        self.range = range


class ImageFormat(Format):
    """Describes the properties for an output image file.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    JpgFormat, PngFormat

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar filename_pattern: The pattern of the file names for the generated output files. The
     following macros are supported in the file name: {Basename} - An expansion macro that will use
     the name of the input video file. If the base name(the file suffix is not included) of the
     input video file is less than 32 characters long, the base name of input video files will be
     used. If the length of base name of the input video file exceeds 32 characters, the base name
     is truncated to the first 32 characters in total length. {Extension} - The appropriate
     extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique
     index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not
     applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video
     resolution. Any unsubstituted macros will be collapsed and removed from the filename. Required.
    :vartype filename_pattern: str
    """

    _validation = {
        "odata_type": {"required": True},
        "filename_pattern": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "filename_pattern": {"key": "filenamePattern", "type": "str"},
    }

    _subtype_map = {
        "odata_type": {"#Microsoft.Media.JpgFormat": "JpgFormat", "#Microsoft.Media.PngFormat": "PngFormat"}
    }

    def __init__(self, *, filename_pattern: str, **kwargs):
        """
        :keyword filename_pattern: The pattern of the file names for the generated output files. The
         following macros are supported in the file name: {Basename} - An expansion macro that will use
         the name of the input video file. If the base name(the file suffix is not included) of the
         input video file is less than 32 characters long, the base name of input video files will be
         used. If the length of base name of the input video file exceeds 32 characters, the base name
         is truncated to the first 32 characters in total length. {Extension} - The appropriate
         extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique
         index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not
         applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video
         resolution. Any unsubstituted macros will be collapsed and removed from the filename. Required.
        :paramtype filename_pattern: str
        """
        super().__init__(filename_pattern=filename_pattern, **kwargs)
        self.odata_type = "#Microsoft.Media.ImageFormat"  # type: str


class InputFile(InputDefinition):
    """An InputDefinition for a single file.  TrackSelections are scoped to the file specified.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar included_tracks: The list of TrackDescriptors which define the metadata and selection of
     tracks in the input.
    :vartype included_tracks: list[~azure.mgmt.media.models.TrackDescriptor]
    :ivar filename: Name of the file that this input definition applies to.
    :vartype filename: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "included_tracks": {"key": "includedTracks", "type": "[TrackDescriptor]"},
        "filename": {"key": "filename", "type": "str"},
    }

    def __init__(
        self,
        *,
        included_tracks: Optional[List["_models.TrackDescriptor"]] = None,
        filename: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword included_tracks: The list of TrackDescriptors which define the metadata and selection
         of tracks in the input.
        :paramtype included_tracks: list[~azure.mgmt.media.models.TrackDescriptor]
        :keyword filename: Name of the file that this input definition applies to.
        :paramtype filename: str
        """
        super().__init__(included_tracks=included_tracks, **kwargs)
        self.odata_type = "#Microsoft.Media.InputFile"  # type: str
        self.filename = filename


class IPAccessControl(_serialization.Model):
    """The IP access control.

    :ivar allow: The IP allow list.
    :vartype allow: list[~azure.mgmt.media.models.IPRange]
    """

    _attribute_map = {
        "allow": {"key": "allow", "type": "[IPRange]"},
    }

    def __init__(self, *, allow: Optional[List["_models.IPRange"]] = None, **kwargs):
        """
        :keyword allow: The IP allow list.
        :paramtype allow: list[~azure.mgmt.media.models.IPRange]
        """
        super().__init__(**kwargs)
        self.allow = allow


class IPRange(_serialization.Model):
    """The IP address range in the CIDR scheme.

    :ivar name: The friendly name for the IP address range.
    :vartype name: str
    :ivar address: The IP address.
    :vartype address: str
    :ivar subnet_prefix_length: The subnet mask prefix length (see CIDR notation).
    :vartype subnet_prefix_length: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "address": {"key": "address", "type": "str"},
        "subnet_prefix_length": {"key": "subnetPrefixLength", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        address: Optional[str] = None,
        subnet_prefix_length: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: The friendly name for the IP address range.
        :paramtype name: str
        :keyword address: The IP address.
        :paramtype address: str
        :keyword subnet_prefix_length: The subnet mask prefix length (see CIDR notation).
        :paramtype subnet_prefix_length: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.address = address
        self.subnet_prefix_length = subnet_prefix_length


class Job(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """A Job resource type. The progress and state can be obtained by polling a Job or subscribing to events using EventGrid.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    :ivar created: The UTC date and time when the customer has created the Job, in
     'YYYY-MM-DDThh:mm:ssZ' format.
    :vartype created: ~datetime.datetime
    :ivar state: The current state of the job. Known values are: "Canceled", "Canceling", "Error",
     "Finished", "Processing", "Queued", and "Scheduled".
    :vartype state: str or ~azure.mgmt.media.models.JobState
    :ivar description: Optional customer supplied description of the Job.
    :vartype description: str
    :ivar input: The inputs for the Job.
    :vartype input: ~azure.mgmt.media.models.JobInput
    :ivar last_modified: The UTC date and time when the customer has last updated the Job, in
     'YYYY-MM-DDThh:mm:ssZ' format.
    :vartype last_modified: ~datetime.datetime
    :ivar outputs: The outputs for the Job.
    :vartype outputs: list[~azure.mgmt.media.models.JobOutput]
    :ivar priority: Priority with which the job should be processed. Higher priority jobs are
     processed before lower priority jobs. If not set, the default is normal. Known values are:
     "Low", "Normal", and "High".
    :vartype priority: str or ~azure.mgmt.media.models.Priority
    :ivar correlation_data: Customer provided key, value pairs that will be returned in Job and
     JobOutput state events.
    :vartype correlation_data: dict[str, str]
    :ivar start_time: The UTC date and time at which this Job began processing.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The UTC date and time at which this Job finished processing.
    :vartype end_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "created": {"readonly": True},
        "state": {"readonly": True},
        "last_modified": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "created": {"key": "properties.created", "type": "iso-8601"},
        "state": {"key": "properties.state", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "input": {"key": "properties.input", "type": "JobInput"},
        "last_modified": {"key": "properties.lastModified", "type": "iso-8601"},
        "outputs": {"key": "properties.outputs", "type": "[JobOutput]"},
        "priority": {"key": "properties.priority", "type": "str"},
        "correlation_data": {"key": "properties.correlationData", "type": "{str}"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "end_time": {"key": "properties.endTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        input: Optional["_models.JobInput"] = None,
        outputs: Optional[List["_models.JobOutput"]] = None,
        priority: Optional[Union[str, "_models.Priority"]] = None,
        correlation_data: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword description: Optional customer supplied description of the Job.
        :paramtype description: str
        :keyword input: The inputs for the Job.
        :paramtype input: ~azure.mgmt.media.models.JobInput
        :keyword outputs: The outputs for the Job.
        :paramtype outputs: list[~azure.mgmt.media.models.JobOutput]
        :keyword priority: Priority with which the job should be processed. Higher priority jobs are
         processed before lower priority jobs. If not set, the default is normal. Known values are:
         "Low", "Normal", and "High".
        :paramtype priority: str or ~azure.mgmt.media.models.Priority
        :keyword correlation_data: Customer provided key, value pairs that will be returned in Job and
         JobOutput state events.
        :paramtype correlation_data: dict[str, str]
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.created = None
        self.state = None
        self.description = description
        self.input = input
        self.last_modified = None
        self.outputs = outputs
        self.priority = priority
        self.correlation_data = correlation_data
        self.start_time = None
        self.end_time = None


class JobCollection(_serialization.Model):
    """A collection of Job items.

    :ivar value: A collection of Job items.
    :vartype value: list[~azure.mgmt.media.models.Job]
    :ivar odata_next_link: A link to the next page of the collection (when the collection contains
     too many results to return in one response).
    :vartype odata_next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Job]"},
        "odata_next_link": {"key": "@odata\\.nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Job"]] = None, odata_next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: A collection of Job items.
        :paramtype value: list[~azure.mgmt.media.models.Job]
        :keyword odata_next_link: A link to the next page of the collection (when the collection
         contains too many results to return in one response).
        :paramtype odata_next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.odata_next_link = odata_next_link


class JobError(_serialization.Model):
    """Details of JobOutput errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code describing the error. Known values are: "ServiceError",
     "ServiceTransientError", "DownloadNotAccessible", "DownloadTransientError",
     "UploadNotAccessible", "UploadTransientError", "ConfigurationUnsupported", "ContentMalformed",
     and "ContentUnsupported".
    :vartype code: str or ~azure.mgmt.media.models.JobErrorCode
    :ivar message: A human-readable language-dependent representation of the error.
    :vartype message: str
    :ivar category: Helps with categorization of errors. Known values are: "Service", "Download",
     "Upload", "Configuration", and "Content".
    :vartype category: str or ~azure.mgmt.media.models.JobErrorCategory
    :ivar retry: Indicates that it may be possible to retry the Job. If retry is unsuccessful,
     please contact Azure support via Azure Portal. Known values are: "DoNotRetry" and "MayRetry".
    :vartype retry: str or ~azure.mgmt.media.models.JobRetry
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~azure.mgmt.media.models.JobErrorDetail]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "category": {"readonly": True},
        "retry": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "retry": {"key": "retry", "type": "str"},
        "details": {"key": "details", "type": "[JobErrorDetail]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.category = None
        self.retry = None
        self.details = None


class JobErrorDetail(_serialization.Model):
    """Details of JobOutput errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code describing the error detail.
    :vartype code: str
    :ivar message: A human-readable representation of the error.
    :vartype message: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None


class JobInput(_serialization.Model):
    """Base class for inputs to a Job.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    JobInputClip, JobInputSequence, JobInputs

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
    }

    _subtype_map = {
        "odata_type": {
            "#Microsoft.Media.JobInputClip": "JobInputClip",
            "#Microsoft.Media.JobInputSequence": "JobInputSequence",
            "#Microsoft.Media.JobInputs": "JobInputs",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class JobInputClip(JobInput):
    """Represents input files for a Job.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    JobInputAsset, JobInputHttp

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar files: List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query
     strings will not be returned in service responses to prevent sensitive data exposure.
    :vartype files: list[str]
    :ivar start: Defines a point on the timeline of the input media at which processing will start.
     Defaults to the beginning of the input media.
    :vartype start: ~azure.mgmt.media.models.ClipTime
    :ivar end: Defines a point on the timeline of the input media at which processing will end.
     Defaults to the end of the input media.
    :vartype end: ~azure.mgmt.media.models.ClipTime
    :ivar label: A label that is assigned to a JobInputClip, that is used to satisfy a reference
     used in the Transform. For example, a Transform can be authored so as to take an image file
     with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When
     submitting a Job, exactly one of the JobInputs should be the image file, and it should have the
     label 'xyz'.
    :vartype label: str
    :ivar input_definitions: Defines a list of InputDefinitions. For each InputDefinition, it
     defines a list of track selections and related metadata.
    :vartype input_definitions: list[~azure.mgmt.media.models.InputDefinition]
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "files": {"key": "files", "type": "[str]"},
        "start": {"key": "start", "type": "ClipTime"},
        "end": {"key": "end", "type": "ClipTime"},
        "label": {"key": "label", "type": "str"},
        "input_definitions": {"key": "inputDefinitions", "type": "[InputDefinition]"},
    }

    _subtype_map = {
        "odata_type": {
            "#Microsoft.Media.JobInputAsset": "JobInputAsset",
            "#Microsoft.Media.JobInputHttp": "JobInputHttp",
        }
    }

    def __init__(
        self,
        *,
        files: Optional[List[str]] = None,
        start: Optional["_models.ClipTime"] = None,
        end: Optional["_models.ClipTime"] = None,
        label: Optional[str] = None,
        input_definitions: Optional[List["_models.InputDefinition"]] = None,
        **kwargs
    ):
        """
        :keyword files: List of files. Required for JobInputHttp. Maximum of 4000 characters each.
         Query strings will not be returned in service responses to prevent sensitive data exposure.
        :paramtype files: list[str]
        :keyword start: Defines a point on the timeline of the input media at which processing will
         start. Defaults to the beginning of the input media.
        :paramtype start: ~azure.mgmt.media.models.ClipTime
        :keyword end: Defines a point on the timeline of the input media at which processing will end.
         Defaults to the end of the input media.
        :paramtype end: ~azure.mgmt.media.models.ClipTime
        :keyword label: A label that is assigned to a JobInputClip, that is used to satisfy a reference
         used in the Transform. For example, a Transform can be authored so as to take an image file
         with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When
         submitting a Job, exactly one of the JobInputs should be the image file, and it should have the
         label 'xyz'.
        :paramtype label: str
        :keyword input_definitions: Defines a list of InputDefinitions. For each InputDefinition, it
         defines a list of track selections and related metadata.
        :paramtype input_definitions: list[~azure.mgmt.media.models.InputDefinition]
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.JobInputClip"  # type: str
        self.files = files
        self.start = start
        self.end = end
        self.label = label
        self.input_definitions = input_definitions


class JobInputAsset(JobInputClip):
    """Represents an Asset for input into a Job.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar files: List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query
     strings will not be returned in service responses to prevent sensitive data exposure.
    :vartype files: list[str]
    :ivar start: Defines a point on the timeline of the input media at which processing will start.
     Defaults to the beginning of the input media.
    :vartype start: ~azure.mgmt.media.models.ClipTime
    :ivar end: Defines a point on the timeline of the input media at which processing will end.
     Defaults to the end of the input media.
    :vartype end: ~azure.mgmt.media.models.ClipTime
    :ivar label: A label that is assigned to a JobInputClip, that is used to satisfy a reference
     used in the Transform. For example, a Transform can be authored so as to take an image file
     with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When
     submitting a Job, exactly one of the JobInputs should be the image file, and it should have the
     label 'xyz'.
    :vartype label: str
    :ivar input_definitions: Defines a list of InputDefinitions. For each InputDefinition, it
     defines a list of track selections and related metadata.
    :vartype input_definitions: list[~azure.mgmt.media.models.InputDefinition]
    :ivar asset_name: The name of the input Asset. Required.
    :vartype asset_name: str
    """

    _validation = {
        "odata_type": {"required": True},
        "asset_name": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "files": {"key": "files", "type": "[str]"},
        "start": {"key": "start", "type": "ClipTime"},
        "end": {"key": "end", "type": "ClipTime"},
        "label": {"key": "label", "type": "str"},
        "input_definitions": {"key": "inputDefinitions", "type": "[InputDefinition]"},
        "asset_name": {"key": "assetName", "type": "str"},
    }

    def __init__(
        self,
        *,
        asset_name: str,
        files: Optional[List[str]] = None,
        start: Optional["_models.ClipTime"] = None,
        end: Optional["_models.ClipTime"] = None,
        label: Optional[str] = None,
        input_definitions: Optional[List["_models.InputDefinition"]] = None,
        **kwargs
    ):
        """
        :keyword files: List of files. Required for JobInputHttp. Maximum of 4000 characters each.
         Query strings will not be returned in service responses to prevent sensitive data exposure.
        :paramtype files: list[str]
        :keyword start: Defines a point on the timeline of the input media at which processing will
         start. Defaults to the beginning of the input media.
        :paramtype start: ~azure.mgmt.media.models.ClipTime
        :keyword end: Defines a point on the timeline of the input media at which processing will end.
         Defaults to the end of the input media.
        :paramtype end: ~azure.mgmt.media.models.ClipTime
        :keyword label: A label that is assigned to a JobInputClip, that is used to satisfy a reference
         used in the Transform. For example, a Transform can be authored so as to take an image file
         with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When
         submitting a Job, exactly one of the JobInputs should be the image file, and it should have the
         label 'xyz'.
        :paramtype label: str
        :keyword input_definitions: Defines a list of InputDefinitions. For each InputDefinition, it
         defines a list of track selections and related metadata.
        :paramtype input_definitions: list[~azure.mgmt.media.models.InputDefinition]
        :keyword asset_name: The name of the input Asset. Required.
        :paramtype asset_name: str
        """
        super().__init__(files=files, start=start, end=end, label=label, input_definitions=input_definitions, **kwargs)
        self.odata_type = "#Microsoft.Media.JobInputAsset"  # type: str
        self.asset_name = asset_name


class JobInputHttp(JobInputClip):
    """Represents HTTPS job input.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar files: List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query
     strings will not be returned in service responses to prevent sensitive data exposure.
    :vartype files: list[str]
    :ivar start: Defines a point on the timeline of the input media at which processing will start.
     Defaults to the beginning of the input media.
    :vartype start: ~azure.mgmt.media.models.ClipTime
    :ivar end: Defines a point on the timeline of the input media at which processing will end.
     Defaults to the end of the input media.
    :vartype end: ~azure.mgmt.media.models.ClipTime
    :ivar label: A label that is assigned to a JobInputClip, that is used to satisfy a reference
     used in the Transform. For example, a Transform can be authored so as to take an image file
     with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When
     submitting a Job, exactly one of the JobInputs should be the image file, and it should have the
     label 'xyz'.
    :vartype label: str
    :ivar input_definitions: Defines a list of InputDefinitions. For each InputDefinition, it
     defines a list of track selections and related metadata.
    :vartype input_definitions: list[~azure.mgmt.media.models.InputDefinition]
    :ivar base_uri: Base URI for HTTPS job input. It will be concatenated with provided file names.
     If no base uri is given, then the provided file list is assumed to be fully qualified uris.
     Maximum length of 4000 characters. The query strings will not be returned in service responses
     to prevent sensitive data exposure.
    :vartype base_uri: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "files": {"key": "files", "type": "[str]"},
        "start": {"key": "start", "type": "ClipTime"},
        "end": {"key": "end", "type": "ClipTime"},
        "label": {"key": "label", "type": "str"},
        "input_definitions": {"key": "inputDefinitions", "type": "[InputDefinition]"},
        "base_uri": {"key": "baseUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        files: Optional[List[str]] = None,
        start: Optional["_models.ClipTime"] = None,
        end: Optional["_models.ClipTime"] = None,
        label: Optional[str] = None,
        input_definitions: Optional[List["_models.InputDefinition"]] = None,
        base_uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword files: List of files. Required for JobInputHttp. Maximum of 4000 characters each.
         Query strings will not be returned in service responses to prevent sensitive data exposure.
        :paramtype files: list[str]
        :keyword start: Defines a point on the timeline of the input media at which processing will
         start. Defaults to the beginning of the input media.
        :paramtype start: ~azure.mgmt.media.models.ClipTime
        :keyword end: Defines a point on the timeline of the input media at which processing will end.
         Defaults to the end of the input media.
        :paramtype end: ~azure.mgmt.media.models.ClipTime
        :keyword label: A label that is assigned to a JobInputClip, that is used to satisfy a reference
         used in the Transform. For example, a Transform can be authored so as to take an image file
         with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When
         submitting a Job, exactly one of the JobInputs should be the image file, and it should have the
         label 'xyz'.
        :paramtype label: str
        :keyword input_definitions: Defines a list of InputDefinitions. For each InputDefinition, it
         defines a list of track selections and related metadata.
        :paramtype input_definitions: list[~azure.mgmt.media.models.InputDefinition]
        :keyword base_uri: Base URI for HTTPS job input. It will be concatenated with provided file
         names. If no base uri is given, then the provided file list is assumed to be fully qualified
         uris. Maximum length of 4000 characters. The query strings will not be returned in service
         responses to prevent sensitive data exposure.
        :paramtype base_uri: str
        """
        super().__init__(files=files, start=start, end=end, label=label, input_definitions=input_definitions, **kwargs)
        self.odata_type = "#Microsoft.Media.JobInputHttp"  # type: str
        self.base_uri = base_uri


class JobInputs(JobInput):
    """Describes a list of inputs to a Job.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar inputs: List of inputs to a Job.
    :vartype inputs: list[~azure.mgmt.media.models.JobInput]
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "inputs": {"key": "inputs", "type": "[JobInput]"},
    }

    def __init__(self, *, inputs: Optional[List["_models.JobInput"]] = None, **kwargs):
        """
        :keyword inputs: List of inputs to a Job.
        :paramtype inputs: list[~azure.mgmt.media.models.JobInput]
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.JobInputs"  # type: str
        self.inputs = inputs


class JobInputSequence(JobInput):
    """A Sequence contains an ordered list of Clips where each clip is a JobInput.  The Sequence will be treated as a single input.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar inputs: JobInputs that make up the timeline.
    :vartype inputs: list[~azure.mgmt.media.models.JobInputClip]
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "inputs": {"key": "inputs", "type": "[JobInputClip]"},
    }

    def __init__(self, *, inputs: Optional[List["_models.JobInputClip"]] = None, **kwargs):
        """
        :keyword inputs: JobInputs that make up the timeline.
        :paramtype inputs: list[~azure.mgmt.media.models.JobInputClip]
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.JobInputSequence"  # type: str
        self.inputs = inputs


class JobOutput(_serialization.Model):
    """Describes all the properties of a JobOutput.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    JobOutputAsset

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar error: If the JobOutput is in the Error state, it contains the details of the error.
    :vartype error: ~azure.mgmt.media.models.JobError
    :ivar preset_override: A preset used to override the preset in the corresponding transform
     output.
    :vartype preset_override: ~azure.mgmt.media.models.Preset
    :ivar state: Describes the state of the JobOutput. Known values are: "Canceled", "Canceling",
     "Error", "Finished", "Processing", "Queued", and "Scheduled".
    :vartype state: str or ~azure.mgmt.media.models.JobState
    :ivar progress: If the JobOutput is in a Processing state, this contains the Job completion
     percentage. The value is an estimate and not intended to be used to predict Job completion
     times. To determine if the JobOutput is complete, use the State property.
    :vartype progress: int
    :ivar label: A label that is assigned to a JobOutput in order to help uniquely identify it.
     This is useful when your Transform has more than one TransformOutput, whereby your Job has more
     than one JobOutput. In such cases, when you submit the Job, you will add two or more
     JobOutputs, in the same order as TransformOutputs in the Transform. Subsequently, when you
     retrieve the Job, either through events or on a GET request, you can use the label to easily
     identify the JobOutput. If a label is not provided, a default value of
     '{presetName}_{outputIndex}' will be used, where the preset name is the name of the preset in
     the corresponding TransformOutput and the output index is the relative index of the this
     JobOutput within the Job. Note that this index is the same as the relative index of the
     corresponding TransformOutput within its Transform.
    :vartype label: str
    :ivar start_time: The UTC date and time at which this Job Output began processing.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The UTC date and time at which this Job Output finished processing.
    :vartype end_time: ~datetime.datetime
    """

    _validation = {
        "odata_type": {"required": True},
        "error": {"readonly": True},
        "state": {"readonly": True},
        "progress": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "error": {"key": "error", "type": "JobError"},
        "preset_override": {"key": "presetOverride", "type": "Preset"},
        "state": {"key": "state", "type": "str"},
        "progress": {"key": "progress", "type": "int"},
        "label": {"key": "label", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
    }

    _subtype_map = {"odata_type": {"#Microsoft.Media.JobOutputAsset": "JobOutputAsset"}}

    def __init__(self, *, preset_override: Optional["_models.Preset"] = None, label: Optional[str] = None, **kwargs):
        """
        :keyword preset_override: A preset used to override the preset in the corresponding transform
         output.
        :paramtype preset_override: ~azure.mgmt.media.models.Preset
        :keyword label: A label that is assigned to a JobOutput in order to help uniquely identify it.
         This is useful when your Transform has more than one TransformOutput, whereby your Job has more
         than one JobOutput. In such cases, when you submit the Job, you will add two or more
         JobOutputs, in the same order as TransformOutputs in the Transform. Subsequently, when you
         retrieve the Job, either through events or on a GET request, you can use the label to easily
         identify the JobOutput. If a label is not provided, a default value of
         '{presetName}_{outputIndex}' will be used, where the preset name is the name of the preset in
         the corresponding TransformOutput and the output index is the relative index of the this
         JobOutput within the Job. Note that this index is the same as the relative index of the
         corresponding TransformOutput within its Transform.
        :paramtype label: str
        """
        super().__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.error = None
        self.preset_override = preset_override
        self.state = None
        self.progress = None
        self.label = label
        self.start_time = None
        self.end_time = None


class JobOutputAsset(JobOutput):
    """Represents an Asset used as a JobOutput.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar error: If the JobOutput is in the Error state, it contains the details of the error.
    :vartype error: ~azure.mgmt.media.models.JobError
    :ivar preset_override: A preset used to override the preset in the corresponding transform
     output.
    :vartype preset_override: ~azure.mgmt.media.models.Preset
    :ivar state: Describes the state of the JobOutput. Known values are: "Canceled", "Canceling",
     "Error", "Finished", "Processing", "Queued", and "Scheduled".
    :vartype state: str or ~azure.mgmt.media.models.JobState
    :ivar progress: If the JobOutput is in a Processing state, this contains the Job completion
     percentage. The value is an estimate and not intended to be used to predict Job completion
     times. To determine if the JobOutput is complete, use the State property.
    :vartype progress: int
    :ivar label: A label that is assigned to a JobOutput in order to help uniquely identify it.
     This is useful when your Transform has more than one TransformOutput, whereby your Job has more
     than one JobOutput. In such cases, when you submit the Job, you will add two or more
     JobOutputs, in the same order as TransformOutputs in the Transform. Subsequently, when you
     retrieve the Job, either through events or on a GET request, you can use the label to easily
     identify the JobOutput. If a label is not provided, a default value of
     '{presetName}_{outputIndex}' will be used, where the preset name is the name of the preset in
     the corresponding TransformOutput and the output index is the relative index of the this
     JobOutput within the Job. Note that this index is the same as the relative index of the
     corresponding TransformOutput within its Transform.
    :vartype label: str
    :ivar start_time: The UTC date and time at which this Job Output began processing.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The UTC date and time at which this Job Output finished processing.
    :vartype end_time: ~datetime.datetime
    :ivar asset_name: The name of the output Asset. Required.
    :vartype asset_name: str
    """

    _validation = {
        "odata_type": {"required": True},
        "error": {"readonly": True},
        "state": {"readonly": True},
        "progress": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "asset_name": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "error": {"key": "error", "type": "JobError"},
        "preset_override": {"key": "presetOverride", "type": "Preset"},
        "state": {"key": "state", "type": "str"},
        "progress": {"key": "progress", "type": "int"},
        "label": {"key": "label", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "asset_name": {"key": "assetName", "type": "str"},
    }

    def __init__(
        self,
        *,
        asset_name: str,
        preset_override: Optional["_models.Preset"] = None,
        label: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword preset_override: A preset used to override the preset in the corresponding transform
         output.
        :paramtype preset_override: ~azure.mgmt.media.models.Preset
        :keyword label: A label that is assigned to a JobOutput in order to help uniquely identify it.
         This is useful when your Transform has more than one TransformOutput, whereby your Job has more
         than one JobOutput. In such cases, when you submit the Job, you will add two or more
         JobOutputs, in the same order as TransformOutputs in the Transform. Subsequently, when you
         retrieve the Job, either through events or on a GET request, you can use the label to easily
         identify the JobOutput. If a label is not provided, a default value of
         '{presetName}_{outputIndex}' will be used, where the preset name is the name of the preset in
         the corresponding TransformOutput and the output index is the relative index of the this
         JobOutput within the Job. Note that this index is the same as the relative index of the
         corresponding TransformOutput within its Transform.
        :paramtype label: str
        :keyword asset_name: The name of the output Asset. Required.
        :paramtype asset_name: str
        """
        super().__init__(preset_override=preset_override, label=label, **kwargs)
        self.odata_type = "#Microsoft.Media.JobOutputAsset"  # type: str
        self.asset_name = asset_name


class JpgFormat(ImageFormat):
    """Describes the settings for producing JPEG thumbnails.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar filename_pattern: The pattern of the file names for the generated output files. The
     following macros are supported in the file name: {Basename} - An expansion macro that will use
     the name of the input video file. If the base name(the file suffix is not included) of the
     input video file is less than 32 characters long, the base name of input video files will be
     used. If the length of base name of the input video file exceeds 32 characters, the base name
     is truncated to the first 32 characters in total length. {Extension} - The appropriate
     extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique
     index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not
     applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video
     resolution. Any unsubstituted macros will be collapsed and removed from the filename. Required.
    :vartype filename_pattern: str
    """

    _validation = {
        "odata_type": {"required": True},
        "filename_pattern": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "filename_pattern": {"key": "filenamePattern", "type": "str"},
    }

    def __init__(self, *, filename_pattern: str, **kwargs):
        """
        :keyword filename_pattern: The pattern of the file names for the generated output files. The
         following macros are supported in the file name: {Basename} - An expansion macro that will use
         the name of the input video file. If the base name(the file suffix is not included) of the
         input video file is less than 32 characters long, the base name of input video files will be
         used. If the length of base name of the input video file exceeds 32 characters, the base name
         is truncated to the first 32 characters in total length. {Extension} - The appropriate
         extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique
         index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not
         applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video
         resolution. Any unsubstituted macros will be collapsed and removed from the filename. Required.
        :paramtype filename_pattern: str
        """
        super().__init__(filename_pattern=filename_pattern, **kwargs)
        self.odata_type = "#Microsoft.Media.JpgFormat"  # type: str


class JpgImage(Image):
    """Describes the properties for producing a series of JPEG images from the input video.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar label: An optional label for the codec. The label can be used to control muxing behavior.
    :vartype label: str
    :ivar key_frame_interval: The distance between two key frames. The value should be non-zero in
     the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note
     that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval
     value will follow the input source setting.
    :vartype key_frame_interval: ~datetime.timedelta
    :ivar stretch_mode: The resizing mode - how the input video will be resized to fit the desired
     output resolution(s). Default is AutoSize. Known values are: "None", "AutoSize", and "AutoFit".
    :vartype stretch_mode: str or ~azure.mgmt.media.models.StretchMode
    :ivar sync_mode: The Video Sync Mode. Known values are: "Auto", "Passthrough", "Cfr", and
     "Vfr".
    :vartype sync_mode: str or ~azure.mgmt.media.models.VideoSyncMode
    :ivar start: The position in the input video from where to start generating thumbnails. The
     value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count
     (For example, 10 to start at the 10th frame), or a relative value to stream duration (For
     example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the
     encoder to select the best thumbnail from the first few seconds of the video and will only
     produce one thumbnail, no matter what other settings are for Step and Range. The default value
     is macro {Best}. Required.
    :vartype start: str
    :ivar step: The intervals at which thumbnails are generated. The value can be in ISO 8601
     format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30
     for one image every 30 frames), or a relative value to stream duration (For example, 10% for
     one image every 10% of stream duration). Note: Step value will affect the first generated
     thumbnail, which may not be exactly the one specified at transform preset start time. This is
     due to the encoder, which tries to select the best thumbnail between start time and Step
     position from start time as the first output. As the default value is 10%, it means if stream
     has long duration, the first generated thumbnail might be far away from the one specified at
     start time. Try to select reasonable value for Step if the first thumbnail is expected close to
     start time, or set Range value at 1 if only one thumbnail is needed at start time.
    :vartype step: str
    :ivar range: The position relative to transform preset start time in the input video at which
     to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to
     stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop
     at the 300th frame from the frame at start time. If this value is 1, it means only producing
     one thumbnail at start time), or a relative value to the stream duration (For example, 50% to
     stop at half of stream duration from start time). The default value is 100%, which means to
     stop at the end of the stream.
    :vartype range: str
    :ivar layers: A collection of output JPEG image layers to be produced by the encoder.
    :vartype layers: list[~azure.mgmt.media.models.JpgLayer]
    :ivar sprite_column: Sets the number of columns used in thumbnail sprite image.  The number of
     rows are automatically calculated and a VTT file is generated with the coordinate mappings for
     each thumbnail in the sprite. Note: this value should be a positive integer and a proper value
     is recommended so that the output image resolution will not go beyond JPEG maximum pixel
     resolution limit 65535x65535.
    :vartype sprite_column: int
    """

    _validation = {
        "odata_type": {"required": True},
        "start": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "key_frame_interval": {"key": "keyFrameInterval", "type": "duration"},
        "stretch_mode": {"key": "stretchMode", "type": "str"},
        "sync_mode": {"key": "syncMode", "type": "str"},
        "start": {"key": "start", "type": "str"},
        "step": {"key": "step", "type": "str"},
        "range": {"key": "range", "type": "str"},
        "layers": {"key": "layers", "type": "[JpgLayer]"},
        "sprite_column": {"key": "spriteColumn", "type": "int"},
    }

    def __init__(
        self,
        *,
        start: str,
        label: Optional[str] = None,
        key_frame_interval: Optional[datetime.timedelta] = None,
        stretch_mode: Optional[Union[str, "_models.StretchMode"]] = None,
        sync_mode: Optional[Union[str, "_models.VideoSyncMode"]] = None,
        step: Optional[str] = None,
        range: Optional[str] = None,
        layers: Optional[List["_models.JpgLayer"]] = None,
        sprite_column: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword label: An optional label for the codec. The label can be used to control muxing
         behavior.
        :paramtype label: str
        :keyword key_frame_interval: The distance between two key frames. The value should be non-zero
         in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S).
         Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the
         KeyFrameInterval value will follow the input source setting.
        :paramtype key_frame_interval: ~datetime.timedelta
        :keyword stretch_mode: The resizing mode - how the input video will be resized to fit the
         desired output resolution(s). Default is AutoSize. Known values are: "None", "AutoSize", and
         "AutoFit".
        :paramtype stretch_mode: str or ~azure.mgmt.media.models.StretchMode
        :keyword sync_mode: The Video Sync Mode. Known values are: "Auto", "Passthrough", "Cfr", and
         "Vfr".
        :paramtype sync_mode: str or ~azure.mgmt.media.models.VideoSyncMode
        :keyword start: The position in the input video from where to start generating thumbnails. The
         value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count
         (For example, 10 to start at the 10th frame), or a relative value to stream duration (For
         example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the
         encoder to select the best thumbnail from the first few seconds of the video and will only
         produce one thumbnail, no matter what other settings are for Step and Range. The default value
         is macro {Best}. Required.
        :paramtype start: str
        :keyword step: The intervals at which thumbnails are generated. The value can be in ISO 8601
         format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30
         for one image every 30 frames), or a relative value to stream duration (For example, 10% for
         one image every 10% of stream duration). Note: Step value will affect the first generated
         thumbnail, which may not be exactly the one specified at transform preset start time. This is
         due to the encoder, which tries to select the best thumbnail between start time and Step
         position from start time as the first output. As the default value is 10%, it means if stream
         has long duration, the first generated thumbnail might be far away from the one specified at
         start time. Try to select reasonable value for Step if the first thumbnail is expected close to
         start time, or set Range value at 1 if only one thumbnail is needed at start time.
        :paramtype step: str
        :keyword range: The position relative to transform preset start time in the input video at
         which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S
         to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to
         stop at the 300th frame from the frame at start time. If this value is 1, it means only
         producing one thumbnail at start time), or a relative value to the stream duration (For
         example, 50% to stop at half of stream duration from start time). The default value is 100%,
         which means to stop at the end of the stream.
        :paramtype range: str
        :keyword layers: A collection of output JPEG image layers to be produced by the encoder.
        :paramtype layers: list[~azure.mgmt.media.models.JpgLayer]
        :keyword sprite_column: Sets the number of columns used in thumbnail sprite image.  The number
         of rows are automatically calculated and a VTT file is generated with the coordinate mappings
         for each thumbnail in the sprite. Note: this value should be a positive integer and a proper
         value is recommended so that the output image resolution will not go beyond JPEG maximum pixel
         resolution limit 65535x65535.
        :paramtype sprite_column: int
        """
        super().__init__(
            label=label,
            key_frame_interval=key_frame_interval,
            stretch_mode=stretch_mode,
            sync_mode=sync_mode,
            start=start,
            step=step,
            range=range,
            **kwargs
        )
        self.odata_type = "#Microsoft.Media.JpgImage"  # type: str
        self.layers = layers
        self.sprite_column = sprite_column


class JpgLayer(Layer):
    """Describes the settings to produce a JPEG image from the input video.

    :ivar width: The width of the output video for this layer. The value can be absolute (in
     pixels) or relative (in percentage). For example 50% means the output video has half as many
     pixels in width as the input.
    :vartype width: str
    :ivar height: The height of the output video for this layer. The value can be absolute (in
     pixels) or relative (in percentage). For example 50% means the output video has half as many
     pixels in height as the input.
    :vartype height: str
    :ivar label: The alphanumeric label for this layer, which can be used in multiplexing different
     video and audio layers, or in naming the output file.
    :vartype label: str
    :ivar quality: The compression quality of the JPEG output. Range is from 0-100 and the default
     is 70.
    :vartype quality: int
    """

    _attribute_map = {
        "width": {"key": "width", "type": "str"},
        "height": {"key": "height", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "quality": {"key": "quality", "type": "int"},
    }

    def __init__(
        self,
        *,
        width: Optional[str] = None,
        height: Optional[str] = None,
        label: Optional[str] = None,
        quality: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword width: The width of the output video for this layer. The value can be absolute (in
         pixels) or relative (in percentage). For example 50% means the output video has half as many
         pixels in width as the input.
        :paramtype width: str
        :keyword height: The height of the output video for this layer. The value can be absolute (in
         pixels) or relative (in percentage). For example 50% means the output video has half as many
         pixels in height as the input.
        :paramtype height: str
        :keyword label: The alphanumeric label for this layer, which can be used in multiplexing
         different video and audio layers, or in naming the output file.
        :paramtype label: str
        :keyword quality: The compression quality of the JPEG output. Range is from 0-100 and the
         default is 70.
        :paramtype quality: int
        """
        super().__init__(width=width, height=height, label=label, **kwargs)
        self.quality = quality


class KeyDelivery(_serialization.Model):
    """KeyDelivery.

    :ivar access_control: The access control properties for Key Delivery.
    :vartype access_control: ~azure.mgmt.media.models.AccessControl
    """

    _attribute_map = {
        "access_control": {"key": "accessControl", "type": "AccessControl"},
    }

    def __init__(self, *, access_control: Optional["_models.AccessControl"] = None, **kwargs):
        """
        :keyword access_control: The access control properties for Key Delivery.
        :paramtype access_control: ~azure.mgmt.media.models.AccessControl
        """
        super().__init__(**kwargs)
        self.access_control = access_control


class KeyVaultProperties(_serialization.Model):
    """KeyVaultProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key_identifier: The URL of the Key Vault key used to encrypt the account. The key may
     either be versioned (for example https://vault/keys/mykey/version1) or reference a key without
     a version (for example https://vault/keys/mykey).
    :vartype key_identifier: str
    :ivar current_key_identifier: The current key used to encrypt the Media Services account,
     including the key version.
    :vartype current_key_identifier: str
    """

    _validation = {
        "current_key_identifier": {"readonly": True},
    }

    _attribute_map = {
        "key_identifier": {"key": "keyIdentifier", "type": "str"},
        "current_key_identifier": {"key": "currentKeyIdentifier", "type": "str"},
    }

    def __init__(self, *, key_identifier: Optional[str] = None, **kwargs):
        """
        :keyword key_identifier: The URL of the Key Vault key used to encrypt the account. The key may
         either be versioned (for example https://vault/keys/mykey/version1) or reference a key without
         a version (for example https://vault/keys/mykey).
        :paramtype key_identifier: str
        """
        super().__init__(**kwargs)
        self.key_identifier = key_identifier
        self.current_key_identifier = None


class ListContainerSasInput(_serialization.Model):
    """The parameters to the list SAS request.

    :ivar permissions: The permissions to set on the SAS URL. Known values are: "Read",
     "ReadWrite", and "ReadWriteDelete".
    :vartype permissions: str or ~azure.mgmt.media.models.AssetContainerPermission
    :ivar expiry_time: The SAS URL expiration time.  This must be less than 24 hours from the
     current time.
    :vartype expiry_time: ~datetime.datetime
    """

    _attribute_map = {
        "permissions": {"key": "permissions", "type": "str"},
        "expiry_time": {"key": "expiryTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        permissions: Optional[Union[str, "_models.AssetContainerPermission"]] = None,
        expiry_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword permissions: The permissions to set on the SAS URL. Known values are: "Read",
         "ReadWrite", and "ReadWriteDelete".
        :paramtype permissions: str or ~azure.mgmt.media.models.AssetContainerPermission
        :keyword expiry_time: The SAS URL expiration time.  This must be less than 24 hours from the
         current time.
        :paramtype expiry_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.permissions = permissions
        self.expiry_time = expiry_time


class ListContentKeysResponse(_serialization.Model):
    """Class of response for listContentKeys action.

    :ivar content_keys: ContentKeys used by current Streaming Locator.
    :vartype content_keys: list[~azure.mgmt.media.models.StreamingLocatorContentKey]
    """

    _attribute_map = {
        "content_keys": {"key": "contentKeys", "type": "[StreamingLocatorContentKey]"},
    }

    def __init__(self, *, content_keys: Optional[List["_models.StreamingLocatorContentKey"]] = None, **kwargs):
        """
        :keyword content_keys: ContentKeys used by current Streaming Locator.
        :paramtype content_keys: list[~azure.mgmt.media.models.StreamingLocatorContentKey]
        """
        super().__init__(**kwargs)
        self.content_keys = content_keys


class ListEdgePoliciesInput(_serialization.Model):
    """ListEdgePoliciesInput.

    :ivar device_id: Unique identifier of the edge device.
    :vartype device_id: str
    """

    _attribute_map = {
        "device_id": {"key": "deviceId", "type": "str"},
    }

    def __init__(self, *, device_id: Optional[str] = None, **kwargs):
        """
        :keyword device_id: Unique identifier of the edge device.
        :paramtype device_id: str
        """
        super().__init__(**kwargs)
        self.device_id = device_id


class ListPathsResponse(_serialization.Model):
    """Class of response for listPaths action.

    :ivar streaming_paths: Streaming Paths supported by current Streaming Locator.
    :vartype streaming_paths: list[~azure.mgmt.media.models.StreamingPath]
    :ivar download_paths: Download Paths supported by current Streaming Locator.
    :vartype download_paths: list[str]
    """

    _attribute_map = {
        "streaming_paths": {"key": "streamingPaths", "type": "[StreamingPath]"},
        "download_paths": {"key": "downloadPaths", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        streaming_paths: Optional[List["_models.StreamingPath"]] = None,
        download_paths: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword streaming_paths: Streaming Paths supported by current Streaming Locator.
        :paramtype streaming_paths: list[~azure.mgmt.media.models.StreamingPath]
        :keyword download_paths: Download Paths supported by current Streaming Locator.
        :paramtype download_paths: list[str]
        """
        super().__init__(**kwargs)
        self.streaming_paths = streaming_paths
        self.download_paths = download_paths


class ListStreamingLocatorsResponse(_serialization.Model):
    """The Streaming Locators associated with this Asset.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar streaming_locators: The list of Streaming Locators.
    :vartype streaming_locators: list[~azure.mgmt.media.models.AssetStreamingLocator]
    """

    _validation = {
        "streaming_locators": {"readonly": True},
    }

    _attribute_map = {
        "streaming_locators": {"key": "streamingLocators", "type": "[AssetStreamingLocator]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.streaming_locators = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class LiveEvent(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The live event.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    :ivar description: A description for the live event.
    :vartype description: str
    :ivar input: Live event input settings. It defines how the live event receives input from a
     contribution encoder.
    :vartype input: ~azure.mgmt.media.models.LiveEventInput
    :ivar preview: Live event preview settings. Preview allows live event producers to preview the
     live streaming content without creating any live output.
    :vartype preview: ~azure.mgmt.media.models.LiveEventPreview
    :ivar encoding: Encoding settings for the live event. It configures whether a live encoder is
     used for the live event and settings for the live encoder if it is used.
    :vartype encoding: ~azure.mgmt.media.models.LiveEventEncoding
    :ivar transcriptions: Live transcription settings for the live event. See
     https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live
     transcription feature.
    :vartype transcriptions: list[~azure.mgmt.media.models.LiveEventTranscription]
    :ivar provisioning_state: The provisioning state of the live event.
    :vartype provisioning_state: str
    :ivar resource_state: The resource state of the live event. See
     https://go.microsoft.com/fwlink/?linkid=2139012 for more information. Known values are:
     "Stopped", "Allocating", "StandBy", "Starting", "Running", "Stopping", and "Deleting".
    :vartype resource_state: str or ~azure.mgmt.media.models.LiveEventResourceState
    :ivar cross_site_access_policies: Live event cross site access policies.
    :vartype cross_site_access_policies: ~azure.mgmt.media.models.CrossSiteAccessPolicies
    :ivar use_static_hostname: Specifies whether a static hostname would be assigned to the live
     event preview and ingest endpoints. This value can only be updated if the live event is in
     Standby state.
    :vartype use_static_hostname: bool
    :ivar hostname_prefix: When useStaticHostname is set to true, the hostnamePrefix specifies the
     first part of the hostname assigned to the live event preview and ingest endpoints. The final
     hostname would be a combination of this prefix, the media service account name and a short code
     for the Azure Media Services data center.
    :vartype hostname_prefix: str
    :ivar stream_options: The options to use for the LiveEvent. This value is specified at creation
     time and cannot be updated. The valid values for the array entry values are 'Default' and
     'LowLatency'.
    :vartype stream_options: list[str or ~azure.mgmt.media.models.StreamOptionsFlag]
    :ivar created: The creation time for the live event.
    :vartype created: ~datetime.datetime
    :ivar last_modified: The last modified time of the live event.
    :vartype last_modified: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "resource_state": {"readonly": True},
        "created": {"readonly": True},
        "last_modified": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "input": {"key": "properties.input", "type": "LiveEventInput"},
        "preview": {"key": "properties.preview", "type": "LiveEventPreview"},
        "encoding": {"key": "properties.encoding", "type": "LiveEventEncoding"},
        "transcriptions": {"key": "properties.transcriptions", "type": "[LiveEventTranscription]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_state": {"key": "properties.resourceState", "type": "str"},
        "cross_site_access_policies": {"key": "properties.crossSiteAccessPolicies", "type": "CrossSiteAccessPolicies"},
        "use_static_hostname": {"key": "properties.useStaticHostname", "type": "bool"},
        "hostname_prefix": {"key": "properties.hostnamePrefix", "type": "str"},
        "stream_options": {"key": "properties.streamOptions", "type": "[str]"},
        "created": {"key": "properties.created", "type": "iso-8601"},
        "last_modified": {"key": "properties.lastModified", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        input: Optional["_models.LiveEventInput"] = None,
        preview: Optional["_models.LiveEventPreview"] = None,
        encoding: Optional["_models.LiveEventEncoding"] = None,
        transcriptions: Optional[List["_models.LiveEventTranscription"]] = None,
        cross_site_access_policies: Optional["_models.CrossSiteAccessPolicies"] = None,
        use_static_hostname: Optional[bool] = None,
        hostname_prefix: Optional[str] = None,
        stream_options: Optional[List[Union[str, "_models.StreamOptionsFlag"]]] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword description: A description for the live event.
        :paramtype description: str
        :keyword input: Live event input settings. It defines how the live event receives input from a
         contribution encoder.
        :paramtype input: ~azure.mgmt.media.models.LiveEventInput
        :keyword preview: Live event preview settings. Preview allows live event producers to preview
         the live streaming content without creating any live output.
        :paramtype preview: ~azure.mgmt.media.models.LiveEventPreview
        :keyword encoding: Encoding settings for the live event. It configures whether a live encoder
         is used for the live event and settings for the live encoder if it is used.
        :paramtype encoding: ~azure.mgmt.media.models.LiveEventEncoding
        :keyword transcriptions: Live transcription settings for the live event. See
         https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live
         transcription feature.
        :paramtype transcriptions: list[~azure.mgmt.media.models.LiveEventTranscription]
        :keyword cross_site_access_policies: Live event cross site access policies.
        :paramtype cross_site_access_policies: ~azure.mgmt.media.models.CrossSiteAccessPolicies
        :keyword use_static_hostname: Specifies whether a static hostname would be assigned to the live
         event preview and ingest endpoints. This value can only be updated if the live event is in
         Standby state.
        :paramtype use_static_hostname: bool
        :keyword hostname_prefix: When useStaticHostname is set to true, the hostnamePrefix specifies
         the first part of the hostname assigned to the live event preview and ingest endpoints. The
         final hostname would be a combination of this prefix, the media service account name and a
         short code for the Azure Media Services data center.
        :paramtype hostname_prefix: str
        :keyword stream_options: The options to use for the LiveEvent. This value is specified at
         creation time and cannot be updated. The valid values for the array entry values are 'Default'
         and 'LowLatency'.
        :paramtype stream_options: list[str or ~azure.mgmt.media.models.StreamOptionsFlag]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.system_data = None
        self.description = description
        self.input = input
        self.preview = preview
        self.encoding = encoding
        self.transcriptions = transcriptions
        self.provisioning_state = None
        self.resource_state = None
        self.cross_site_access_policies = cross_site_access_policies
        self.use_static_hostname = use_static_hostname
        self.hostname_prefix = hostname_prefix
        self.stream_options = stream_options
        self.created = None
        self.last_modified = None


class LiveEventActionInput(_serialization.Model):
    """The LiveEvent action input parameter definition.

    :ivar remove_outputs_on_stop: The flag indicates whether live outputs are automatically deleted
     when live event is being stopped. Deleting live outputs do not delete the underlying assets.
    :vartype remove_outputs_on_stop: bool
    """

    _attribute_map = {
        "remove_outputs_on_stop": {"key": "removeOutputsOnStop", "type": "bool"},
    }

    def __init__(self, *, remove_outputs_on_stop: Optional[bool] = None, **kwargs):
        """
        :keyword remove_outputs_on_stop: The flag indicates whether live outputs are automatically
         deleted when live event is being stopped. Deleting live outputs do not delete the underlying
         assets.
        :paramtype remove_outputs_on_stop: bool
        """
        super().__init__(**kwargs)
        self.remove_outputs_on_stop = remove_outputs_on_stop


class LiveEventEncoding(_serialization.Model):
    """Specifies the live event type and optional encoding settings for encoding live events.

    :ivar encoding_type: Live event type. When encodingType is set to PassthroughBasic or
     PassthroughStandard, the service simply passes through the incoming video and audio layer(s) to
     the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the
     incoming stream into multiple bitrates or layers. See
     https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be
     modified after the live event is created. Known values are: "None", "Standard", "Premium1080p",
     "PassthroughBasic", and "PassthroughStandard".
    :vartype encoding_type: str or ~azure.mgmt.media.models.LiveEventEncodingType
    :ivar preset_name: The optional encoding preset name, used when encodingType is not None. This
     value is specified at creation time and cannot be updated. If the encodingType is set to
     Standard, then the default preset name is ‘Default720p’. Else if the encodingType is set to
     Premium1080p, the default preset is ‘Default1080p’.
    :vartype preset_name: str
    :ivar stretch_mode: Specifies how the input video will be resized to fit the desired output
     resolution(s). Default is None. Known values are: "None", "AutoSize", and "AutoFit".
    :vartype stretch_mode: str or ~azure.mgmt.media.models.StretchMode
    :ivar key_frame_interval: Use an ISO 8601 time value between 0.5 to 20 seconds to specify the
     output fragment length for the video and audio tracks of an encoding live event. For example,
     use PT2S to indicate 2 seconds. For the video track it also defines the key frame interval, or
     the length of a GoP (group of pictures).   If this value is not set for an encoding live event,
     the fragment duration defaults to 2 seconds. The value cannot be set for pass-through live
     events.
    :vartype key_frame_interval: ~datetime.timedelta
    """

    _attribute_map = {
        "encoding_type": {"key": "encodingType", "type": "str"},
        "preset_name": {"key": "presetName", "type": "str"},
        "stretch_mode": {"key": "stretchMode", "type": "str"},
        "key_frame_interval": {"key": "keyFrameInterval", "type": "duration"},
    }

    def __init__(
        self,
        *,
        encoding_type: Optional[Union[str, "_models.LiveEventEncodingType"]] = None,
        preset_name: Optional[str] = None,
        stretch_mode: Optional[Union[str, "_models.StretchMode"]] = None,
        key_frame_interval: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword encoding_type: Live event type. When encodingType is set to PassthroughBasic or
         PassthroughStandard, the service simply passes through the incoming video and audio layer(s) to
         the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the
         incoming stream into multiple bitrates or layers. See
         https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be
         modified after the live event is created. Known values are: "None", "Standard", "Premium1080p",
         "PassthroughBasic", and "PassthroughStandard".
        :paramtype encoding_type: str or ~azure.mgmt.media.models.LiveEventEncodingType
        :keyword preset_name: The optional encoding preset name, used when encodingType is not None.
         This value is specified at creation time and cannot be updated. If the encodingType is set to
         Standard, then the default preset name is ‘Default720p’. Else if the encodingType is set to
         Premium1080p, the default preset is ‘Default1080p’.
        :paramtype preset_name: str
        :keyword stretch_mode: Specifies how the input video will be resized to fit the desired output
         resolution(s). Default is None. Known values are: "None", "AutoSize", and "AutoFit".
        :paramtype stretch_mode: str or ~azure.mgmt.media.models.StretchMode
        :keyword key_frame_interval: Use an ISO 8601 time value between 0.5 to 20 seconds to specify
         the output fragment length for the video and audio tracks of an encoding live event. For
         example, use PT2S to indicate 2 seconds. For the video track it also defines the key frame
         interval, or the length of a GoP (group of pictures).   If this value is not set for an
         encoding live event, the fragment duration defaults to 2 seconds. The value cannot be set for
         pass-through live events.
        :paramtype key_frame_interval: ~datetime.timedelta
        """
        super().__init__(**kwargs)
        self.encoding_type = encoding_type
        self.preset_name = preset_name
        self.stretch_mode = stretch_mode
        self.key_frame_interval = key_frame_interval


class LiveEventEndpoint(_serialization.Model):
    """The live event endpoint.

    :ivar protocol: The endpoint protocol.
    :vartype protocol: str
    :ivar url: The endpoint URL.
    :vartype url: str
    """

    _attribute_map = {
        "protocol": {"key": "protocol", "type": "str"},
        "url": {"key": "url", "type": "str"},
    }

    def __init__(self, *, protocol: Optional[str] = None, url: Optional[str] = None, **kwargs):
        """
        :keyword protocol: The endpoint protocol.
        :paramtype protocol: str
        :keyword url: The endpoint URL.
        :paramtype url: str
        """
        super().__init__(**kwargs)
        self.protocol = protocol
        self.url = url


class LiveEventInput(_serialization.Model):
    """The live event input.

    All required parameters must be populated in order to send to Azure.

    :ivar streaming_protocol: The input protocol for the live event. This is specified at creation
     time and cannot be updated. Required. Known values are: "FragmentedMP4" and "RTMP".
    :vartype streaming_protocol: str or ~azure.mgmt.media.models.LiveEventInputProtocol
    :ivar access_control: Access control for live event input.
    :vartype access_control: ~azure.mgmt.media.models.LiveEventInputAccessControl
    :ivar key_frame_interval_duration: ISO 8601 time duration of the key frame interval duration of
     the input. This value sets the EXT-X-TARGETDURATION property in the HLS output. For example,
     use PT2S to indicate 2 seconds. Leave the value empty for encoding live events.
    :vartype key_frame_interval_duration: str
    :ivar access_token: A UUID in string form to uniquely identify the stream. This can be
     specified at creation time but cannot be updated. If omitted, the service will generate a
     unique value.
    :vartype access_token: str
    :ivar endpoints: The input endpoints for the live event.
    :vartype endpoints: list[~azure.mgmt.media.models.LiveEventEndpoint]
    """

    _validation = {
        "streaming_protocol": {"required": True},
    }

    _attribute_map = {
        "streaming_protocol": {"key": "streamingProtocol", "type": "str"},
        "access_control": {"key": "accessControl", "type": "LiveEventInputAccessControl"},
        "key_frame_interval_duration": {"key": "keyFrameIntervalDuration", "type": "str"},
        "access_token": {"key": "accessToken", "type": "str"},
        "endpoints": {"key": "endpoints", "type": "[LiveEventEndpoint]"},
    }

    def __init__(
        self,
        *,
        streaming_protocol: Union[str, "_models.LiveEventInputProtocol"],
        access_control: Optional["_models.LiveEventInputAccessControl"] = None,
        key_frame_interval_duration: Optional[str] = None,
        access_token: Optional[str] = None,
        endpoints: Optional[List["_models.LiveEventEndpoint"]] = None,
        **kwargs
    ):
        """
        :keyword streaming_protocol: The input protocol for the live event. This is specified at
         creation time and cannot be updated. Required. Known values are: "FragmentedMP4" and "RTMP".
        :paramtype streaming_protocol: str or ~azure.mgmt.media.models.LiveEventInputProtocol
        :keyword access_control: Access control for live event input.
        :paramtype access_control: ~azure.mgmt.media.models.LiveEventInputAccessControl
        :keyword key_frame_interval_duration: ISO 8601 time duration of the key frame interval duration
         of the input. This value sets the EXT-X-TARGETDURATION property in the HLS output. For example,
         use PT2S to indicate 2 seconds. Leave the value empty for encoding live events.
        :paramtype key_frame_interval_duration: str
        :keyword access_token: A UUID in string form to uniquely identify the stream. This can be
         specified at creation time but cannot be updated. If omitted, the service will generate a
         unique value.
        :paramtype access_token: str
        :keyword endpoints: The input endpoints for the live event.
        :paramtype endpoints: list[~azure.mgmt.media.models.LiveEventEndpoint]
        """
        super().__init__(**kwargs)
        self.streaming_protocol = streaming_protocol
        self.access_control = access_control
        self.key_frame_interval_duration = key_frame_interval_duration
        self.access_token = access_token
        self.endpoints = endpoints


class LiveEventInputAccessControl(_serialization.Model):
    """The IP access control for live event input.

    :ivar ip: The IP access control properties.
    :vartype ip: ~azure.mgmt.media.models.IPAccessControl
    """

    _attribute_map = {
        "ip": {"key": "ip", "type": "IPAccessControl"},
    }

    def __init__(self, *, ip: Optional["_models.IPAccessControl"] = None, **kwargs):
        """
        :keyword ip: The IP access control properties.
        :paramtype ip: ~azure.mgmt.media.models.IPAccessControl
        """
        super().__init__(**kwargs)
        self.ip = ip


class LiveEventInputTrackSelection(_serialization.Model):
    """A track selection condition. This property is reserved for future use, any value set on this property will be ignored.

    :ivar property: Property name to select. This property is reserved for future use, any value
     set on this property will be ignored.
    :vartype property: str
    :ivar operation: Comparing operation. This property is reserved for future use, any value set
     on this property will be ignored.
    :vartype operation: str
    :ivar value: Property value to select. This property is reserved for future use, any value set
     on this property will be ignored.
    :vartype value: str
    """

    _attribute_map = {
        "property": {"key": "property", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self, *, property: Optional[str] = None, operation: Optional[str] = None, value: Optional[str] = None, **kwargs
    ):
        """
        :keyword property: Property name to select. This property is reserved for future use, any value
         set on this property will be ignored.
        :paramtype property: str
        :keyword operation: Comparing operation. This property is reserved for future use, any value
         set on this property will be ignored.
        :paramtype operation: str
        :keyword value: Property value to select. This property is reserved for future use, any value
         set on this property will be ignored.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.property = property
        self.operation = operation
        self.value = value


class LiveEventListResult(_serialization.Model):
    """The LiveEvent list result.

    :ivar value: The result of the List Live Event operation.
    :vartype value: list[~azure.mgmt.media.models.LiveEvent]
    :ivar odata_count: The number of result.
    :vartype odata_count: int
    :ivar odata_next_link: The link to the next set of results. Not empty if value contains
     incomplete list of live outputs.
    :vartype odata_next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[LiveEvent]"},
        "odata_count": {"key": "@odata\\.count", "type": "int"},
        "odata_next_link": {"key": "@odata\\.nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.LiveEvent"]] = None,
        odata_count: Optional[int] = None,
        odata_next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The result of the List Live Event operation.
        :paramtype value: list[~azure.mgmt.media.models.LiveEvent]
        :keyword odata_count: The number of result.
        :paramtype odata_count: int
        :keyword odata_next_link: The link to the next set of results. Not empty if value contains
         incomplete list of live outputs.
        :paramtype odata_next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.odata_count = odata_count
        self.odata_next_link = odata_next_link


class LiveEventOutputTranscriptionTrack(_serialization.Model):
    """Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.

    All required parameters must be populated in order to send to Azure.

    :ivar track_name: The output track name. This property is reserved for future use, any value
     set on this property will be ignored. Required.
    :vartype track_name: str
    """

    _validation = {
        "track_name": {"required": True},
    }

    _attribute_map = {
        "track_name": {"key": "trackName", "type": "str"},
    }

    def __init__(self, *, track_name: str, **kwargs):
        """
        :keyword track_name: The output track name. This property is reserved for future use, any value
         set on this property will be ignored. Required.
        :paramtype track_name: str
        """
        super().__init__(**kwargs)
        self.track_name = track_name


class LiveEventPreview(_serialization.Model):
    """Live event preview settings.

    :ivar endpoints: The endpoints for preview. Do not share the preview URL with the live event
     audience.
    :vartype endpoints: list[~azure.mgmt.media.models.LiveEventEndpoint]
    :ivar access_control: The access control for live event preview.
    :vartype access_control: ~azure.mgmt.media.models.LiveEventPreviewAccessControl
    :ivar preview_locator: The identifier of the preview locator in Guid format. Specifying this at
     creation time allows the caller to know the preview locator url before the event is created. If
     omitted, the service will generate a random identifier. This value cannot be updated once the
     live event is created.
    :vartype preview_locator: str
    :ivar streaming_policy_name: The name of streaming policy used for the live event preview. This
     value is specified at creation time and cannot be updated.
    :vartype streaming_policy_name: str
    :ivar alternative_media_id: An alternative media identifier associated with the streaming
     locator created for the preview. This value is specified at creation time and cannot be
     updated. The identifier can be used in the CustomLicenseAcquisitionUrlTemplate or the
     CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName
     field.
    :vartype alternative_media_id: str
    """

    _attribute_map = {
        "endpoints": {"key": "endpoints", "type": "[LiveEventEndpoint]"},
        "access_control": {"key": "accessControl", "type": "LiveEventPreviewAccessControl"},
        "preview_locator": {"key": "previewLocator", "type": "str"},
        "streaming_policy_name": {"key": "streamingPolicyName", "type": "str"},
        "alternative_media_id": {"key": "alternativeMediaId", "type": "str"},
    }

    def __init__(
        self,
        *,
        endpoints: Optional[List["_models.LiveEventEndpoint"]] = None,
        access_control: Optional["_models.LiveEventPreviewAccessControl"] = None,
        preview_locator: Optional[str] = None,
        streaming_policy_name: Optional[str] = None,
        alternative_media_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword endpoints: The endpoints for preview. Do not share the preview URL with the live event
         audience.
        :paramtype endpoints: list[~azure.mgmt.media.models.LiveEventEndpoint]
        :keyword access_control: The access control for live event preview.
        :paramtype access_control: ~azure.mgmt.media.models.LiveEventPreviewAccessControl
        :keyword preview_locator: The identifier of the preview locator in Guid format. Specifying this
         at creation time allows the caller to know the preview locator url before the event is created.
         If omitted, the service will generate a random identifier. This value cannot be updated once
         the live event is created.
        :paramtype preview_locator: str
        :keyword streaming_policy_name: The name of streaming policy used for the live event preview.
         This value is specified at creation time and cannot be updated.
        :paramtype streaming_policy_name: str
        :keyword alternative_media_id: An alternative media identifier associated with the streaming
         locator created for the preview. This value is specified at creation time and cannot be
         updated. The identifier can be used in the CustomLicenseAcquisitionUrlTemplate or the
         CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName
         field.
        :paramtype alternative_media_id: str
        """
        super().__init__(**kwargs)
        self.endpoints = endpoints
        self.access_control = access_control
        self.preview_locator = preview_locator
        self.streaming_policy_name = streaming_policy_name
        self.alternative_media_id = alternative_media_id


class LiveEventPreviewAccessControl(_serialization.Model):
    """The IP access control for the live event preview endpoint.

    :ivar ip: The IP access control properties.
    :vartype ip: ~azure.mgmt.media.models.IPAccessControl
    """

    _attribute_map = {
        "ip": {"key": "ip", "type": "IPAccessControl"},
    }

    def __init__(self, *, ip: Optional["_models.IPAccessControl"] = None, **kwargs):
        """
        :keyword ip: The IP access control properties.
        :paramtype ip: ~azure.mgmt.media.models.IPAccessControl
        """
        super().__init__(**kwargs)
        self.ip = ip


class LiveEventTranscription(_serialization.Model):
    """Describes the transcription tracks in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.

    :ivar language: Specifies the language (locale) to be used for speech-to-text transcription –
     it should match the spoken language in the audio track. The value should be in BCP-47 format
     (e.g: 'en-US'). See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about
     the live transcription feature and the list of supported languages.
    :vartype language: str
    :ivar input_track_selection: Provides a mechanism to select the audio track in the input live
     feed, to which speech-to-text transcription is applied. This property is reserved for future
     use, any value set on this property will be ignored.
    :vartype input_track_selection: list[~azure.mgmt.media.models.LiveEventInputTrackSelection]
    :ivar output_transcription_track: Describes a transcription track in the output of a live
     event, generated using speech-to-text transcription. This property is reserved for future use,
     any value set on this property will be ignored.
    :vartype output_transcription_track: ~azure.mgmt.media.models.LiveEventOutputTranscriptionTrack
    """

    _attribute_map = {
        "language": {"key": "language", "type": "str"},
        "input_track_selection": {"key": "inputTrackSelection", "type": "[LiveEventInputTrackSelection]"},
        "output_transcription_track": {"key": "outputTranscriptionTrack", "type": "LiveEventOutputTranscriptionTrack"},
    }

    def __init__(
        self,
        *,
        language: Optional[str] = None,
        input_track_selection: Optional[List["_models.LiveEventInputTrackSelection"]] = None,
        output_transcription_track: Optional["_models.LiveEventOutputTranscriptionTrack"] = None,
        **kwargs
    ):
        """
        :keyword language: Specifies the language (locale) to be used for speech-to-text transcription
         – it should match the spoken language in the audio track. The value should be in BCP-47 format
         (e.g: 'en-US'). See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about
         the live transcription feature and the list of supported languages.
        :paramtype language: str
        :keyword input_track_selection: Provides a mechanism to select the audio track in the input
         live feed, to which speech-to-text transcription is applied. This property is reserved for
         future use, any value set on this property will be ignored.
        :paramtype input_track_selection: list[~azure.mgmt.media.models.LiveEventInputTrackSelection]
        :keyword output_transcription_track: Describes a transcription track in the output of a live
         event, generated using speech-to-text transcription. This property is reserved for future use,
         any value set on this property will be ignored.
        :paramtype output_transcription_track:
         ~azure.mgmt.media.models.LiveEventOutputTranscriptionTrack
        """
        super().__init__(**kwargs)
        self.language = language
        self.input_track_selection = input_track_selection
        self.output_transcription_track = output_transcription_track


class LiveOutput(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """The Live Output.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    :ivar description: The description of the live output.
    :vartype description: str
    :ivar asset_name: The asset that the live output will write to.
    :vartype asset_name: str
    :ivar archive_window_length: ISO 8601 time between 1 minute to 25 hours to indicate the maximum
     content length that can be archived in the asset for this live output. This also sets the
     maximum content length for the rewind window. For example, use PT1H30M to indicate 1 hour and
     30 minutes of archive window.
    :vartype archive_window_length: ~datetime.timedelta
    :ivar rewind_window_length: ISO 8601 time between 1 minute to the duration of
     archiveWindowLength to control seek-able window length during Live. The service won't use this
     property once LiveOutput stops. The archived VOD will have full content with original
     ArchiveWindowLength. For example, use PT1H30M to indicate 1 hour and 30 minutes of rewind
     window length. Service will use implicit default value 30m only if Live Event enables LL.
    :vartype rewind_window_length: ~datetime.timedelta
    :ivar manifest_name: The manifest file name. If not provided, the service will generate one
     automatically.
    :vartype manifest_name: str
    :ivar hls: HTTP Live Streaming (HLS) packing setting for the live output.
    :vartype hls: ~azure.mgmt.media.models.Hls
    :ivar output_snap_time: The initial timestamp that the live output will start at, any content
     before this value will not be archived.
    :vartype output_snap_time: int
    :ivar created: The creation time the live output.
    :vartype created: ~datetime.datetime
    :ivar last_modified: The time the live output was last modified.
    :vartype last_modified: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the live output.
    :vartype provisioning_state: str
    :ivar resource_state: The resource state of the live output. Known values are: "Creating",
     "Running", and "Deleting".
    :vartype resource_state: str or ~azure.mgmt.media.models.LiveOutputResourceState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "created": {"readonly": True},
        "last_modified": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "resource_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "asset_name": {"key": "properties.assetName", "type": "str"},
        "archive_window_length": {"key": "properties.archiveWindowLength", "type": "duration"},
        "rewind_window_length": {"key": "properties.rewindWindowLength", "type": "duration"},
        "manifest_name": {"key": "properties.manifestName", "type": "str"},
        "hls": {"key": "properties.hls", "type": "Hls"},
        "output_snap_time": {"key": "properties.outputSnapTime", "type": "int"},
        "created": {"key": "properties.created", "type": "iso-8601"},
        "last_modified": {"key": "properties.lastModified", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_state": {"key": "properties.resourceState", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        asset_name: Optional[str] = None,
        archive_window_length: Optional[datetime.timedelta] = None,
        rewind_window_length: Optional[datetime.timedelta] = None,
        manifest_name: Optional[str] = None,
        hls: Optional["_models.Hls"] = None,
        output_snap_time: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword description: The description of the live output.
        :paramtype description: str
        :keyword asset_name: The asset that the live output will write to.
        :paramtype asset_name: str
        :keyword archive_window_length: ISO 8601 time between 1 minute to 25 hours to indicate the
         maximum content length that can be archived in the asset for this live output. This also sets
         the maximum content length for the rewind window. For example, use PT1H30M to indicate 1 hour
         and 30 minutes of archive window.
        :paramtype archive_window_length: ~datetime.timedelta
        :keyword rewind_window_length: ISO 8601 time between 1 minute to the duration of
         archiveWindowLength to control seek-able window length during Live. The service won't use this
         property once LiveOutput stops. The archived VOD will have full content with original
         ArchiveWindowLength. For example, use PT1H30M to indicate 1 hour and 30 minutes of rewind
         window length. Service will use implicit default value 30m only if Live Event enables LL.
        :paramtype rewind_window_length: ~datetime.timedelta
        :keyword manifest_name: The manifest file name. If not provided, the service will generate one
         automatically.
        :paramtype manifest_name: str
        :keyword hls: HTTP Live Streaming (HLS) packing setting for the live output.
        :paramtype hls: ~azure.mgmt.media.models.Hls
        :keyword output_snap_time: The initial timestamp that the live output will start at, any
         content before this value will not be archived.
        :paramtype output_snap_time: int
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.description = description
        self.asset_name = asset_name
        self.archive_window_length = archive_window_length
        self.rewind_window_length = rewind_window_length
        self.manifest_name = manifest_name
        self.hls = hls
        self.output_snap_time = output_snap_time
        self.created = None
        self.last_modified = None
        self.provisioning_state = None
        self.resource_state = None


class LiveOutputListResult(_serialization.Model):
    """The LiveOutput list result.

    :ivar value: The result of the List LiveOutput operation.
    :vartype value: list[~azure.mgmt.media.models.LiveOutput]
    :ivar odata_count: The number of result.
    :vartype odata_count: int
    :ivar odata_next_link: The link to the next set of results. Not empty if value contains
     incomplete list of live outputs.
    :vartype odata_next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[LiveOutput]"},
        "odata_count": {"key": "@odata\\.count", "type": "int"},
        "odata_next_link": {"key": "@odata\\.nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.LiveOutput"]] = None,
        odata_count: Optional[int] = None,
        odata_next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The result of the List LiveOutput operation.
        :paramtype value: list[~azure.mgmt.media.models.LiveOutput]
        :keyword odata_count: The number of result.
        :paramtype odata_count: int
        :keyword odata_next_link: The link to the next set of results. Not empty if value contains
         incomplete list of live outputs.
        :paramtype odata_next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.odata_count = odata_count
        self.odata_next_link = odata_next_link


class LogSpecification(_serialization.Model):
    """A diagnostic log emitted by service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The diagnostic log category name.
    :vartype name: str
    :ivar display_name: The diagnostic log category display name.
    :vartype display_name: str
    :ivar blob_duration: The time range for requests in each blob.
    :vartype blob_duration: str
    """

    _validation = {
        "name": {"readonly": True},
        "display_name": {"readonly": True},
        "blob_duration": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.display_name = None
        self.blob_duration = None


class MediaService(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """A Media Services account.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    :ivar identity: The Managed Identity for the Media Services account.
    :vartype identity: ~azure.mgmt.media.models.MediaServiceIdentity
    :ivar media_service_id: The Media Services account ID.
    :vartype media_service_id: str
    :ivar storage_accounts: The storage accounts for this resource.
    :vartype storage_accounts: list[~azure.mgmt.media.models.StorageAccount]
    :ivar storage_authentication: Known values are: "System" and "ManagedIdentity".
    :vartype storage_authentication: str or ~azure.mgmt.media.models.StorageAuthentication
    :ivar encryption: The account encryption properties.
    :vartype encryption: ~azure.mgmt.media.models.AccountEncryption
    :ivar key_delivery: The Key Delivery properties for Media Services account.
    :vartype key_delivery: ~azure.mgmt.media.models.KeyDelivery
    :ivar public_network_access: Whether or not public network access is allowed for resources
     under the Media Services account. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.media.models.PublicNetworkAccess
    :ivar provisioning_state: Provisioning state of the Media Services account. Known values are:
     "Failed", "InProgress", and "Succeeded".
    :vartype provisioning_state: str or ~azure.mgmt.media.models.ProvisioningState
    :ivar private_endpoint_connections: The Private Endpoint Connections created for the Media
     Service account.
    :vartype private_endpoint_connections: list[~azure.mgmt.media.models.PrivateEndpointConnection]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "media_service_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "identity": {"key": "identity", "type": "MediaServiceIdentity"},
        "media_service_id": {"key": "properties.mediaServiceId", "type": "str"},
        "storage_accounts": {"key": "properties.storageAccounts", "type": "[StorageAccount]"},
        "storage_authentication": {"key": "properties.storageAuthentication", "type": "str"},
        "encryption": {"key": "properties.encryption", "type": "AccountEncryption"},
        "key_delivery": {"key": "properties.keyDelivery", "type": "KeyDelivery"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.MediaServiceIdentity"] = None,
        storage_accounts: Optional[List["_models.StorageAccount"]] = None,
        storage_authentication: Optional[Union[str, "_models.StorageAuthentication"]] = None,
        encryption: Optional["_models.AccountEncryption"] = None,
        key_delivery: Optional["_models.KeyDelivery"] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: The Managed Identity for the Media Services account.
        :paramtype identity: ~azure.mgmt.media.models.MediaServiceIdentity
        :keyword storage_accounts: The storage accounts for this resource.
        :paramtype storage_accounts: list[~azure.mgmt.media.models.StorageAccount]
        :keyword storage_authentication: Known values are: "System" and "ManagedIdentity".
        :paramtype storage_authentication: str or ~azure.mgmt.media.models.StorageAuthentication
        :keyword encryption: The account encryption properties.
        :paramtype encryption: ~azure.mgmt.media.models.AccountEncryption
        :keyword key_delivery: The Key Delivery properties for Media Services account.
        :paramtype key_delivery: ~azure.mgmt.media.models.KeyDelivery
        :keyword public_network_access: Whether or not public network access is allowed for resources
         under the Media Services account. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.media.models.PublicNetworkAccess
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.system_data = None
        self.identity = identity
        self.media_service_id = None
        self.storage_accounts = storage_accounts
        self.storage_authentication = storage_authentication
        self.encryption = encryption
        self.key_delivery = key_delivery
        self.public_network_access = public_network_access
        self.provisioning_state = None
        self.private_endpoint_connections = None


class MediaServiceCollection(_serialization.Model):
    """A collection of MediaService items.

    :ivar value: A collection of MediaService items.
    :vartype value: list[~azure.mgmt.media.models.MediaService]
    :ivar odata_next_link: A link to the next page of the collection (when the collection contains
     too many results to return in one response).
    :vartype odata_next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MediaService]"},
        "odata_next_link": {"key": "@odata\\.nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.MediaService"]] = None, odata_next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A collection of MediaService items.
        :paramtype value: list[~azure.mgmt.media.models.MediaService]
        :keyword odata_next_link: A link to the next page of the collection (when the collection
         contains too many results to return in one response).
        :paramtype odata_next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.odata_next_link = odata_next_link


class MediaServiceIdentity(_serialization.Model):
    """MediaServiceIdentity.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The identity type. Required.
    :vartype type: str
    :ivar principal_id: The Principal ID of the identity.
    :vartype principal_id: str
    :ivar tenant_id: The Tenant ID of the identity.
    :vartype tenant_id: str
    :ivar user_assigned_identities: The user assigned managed identities.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.media.models.UserAssignedManagedIdentity]
    """

    _validation = {
        "type": {"required": True},
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedManagedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: str,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedManagedIdentity"]] = None,
        **kwargs
    ):
        """
        :keyword type: The identity type. Required.
        :paramtype type: str
        :keyword user_assigned_identities: The user assigned managed identities.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.media.models.UserAssignedManagedIdentity]
        """
        super().__init__(**kwargs)
        self.type = type
        self.principal_id = None
        self.tenant_id = None
        self.user_assigned_identities = user_assigned_identities


class MediaServiceOperationStatus(_serialization.Model):
    """Status of media service operation.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Operation identifier. Required.
    :vartype name: str
    :ivar id: Operation resource ID.
    :vartype id: str
    :ivar start_time: Operation start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Operation end time.
    :vartype end_time: ~datetime.datetime
    :ivar status: Operation status. Required.
    :vartype status: str
    :ivar error: The error detail.
    :vartype error: ~azure.mgmt.media.models.ErrorDetail
    """

    _validation = {
        "name": {"required": True},
        "status": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(
        self,
        *,
        name: str,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        error: Optional["_models.ErrorDetail"] = None,
        **kwargs
    ):
        """
        :keyword name: Operation identifier. Required.
        :paramtype name: str
        :keyword id: Operation resource ID.
        :paramtype id: str
        :keyword start_time: Operation start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Operation end time.
        :paramtype end_time: ~datetime.datetime
        :keyword status: Operation status. Required.
        :paramtype status: str
        :keyword error: The error detail.
        :paramtype error: ~azure.mgmt.media.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.start_time = start_time
        self.end_time = end_time
        self.status = status
        self.error = error


class MediaServiceUpdate(_serialization.Model):
    """A Media Services account update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The Managed Identity for the Media Services account.
    :vartype identity: ~azure.mgmt.media.models.MediaServiceIdentity
    :ivar media_service_id: The Media Services account ID.
    :vartype media_service_id: str
    :ivar storage_accounts: The storage accounts for this resource.
    :vartype storage_accounts: list[~azure.mgmt.media.models.StorageAccount]
    :ivar storage_authentication: Known values are: "System" and "ManagedIdentity".
    :vartype storage_authentication: str or ~azure.mgmt.media.models.StorageAuthentication
    :ivar encryption: The account encryption properties.
    :vartype encryption: ~azure.mgmt.media.models.AccountEncryption
    :ivar key_delivery: The Key Delivery properties for Media Services account.
    :vartype key_delivery: ~azure.mgmt.media.models.KeyDelivery
    :ivar public_network_access: Whether or not public network access is allowed for resources
     under the Media Services account. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.media.models.PublicNetworkAccess
    :ivar provisioning_state: Provisioning state of the Media Services account. Known values are:
     "Failed", "InProgress", and "Succeeded".
    :vartype provisioning_state: str or ~azure.mgmt.media.models.ProvisioningState
    :ivar private_endpoint_connections: The Private Endpoint Connections created for the Media
     Service account.
    :vartype private_endpoint_connections: list[~azure.mgmt.media.models.PrivateEndpointConnection]
    """

    _validation = {
        "media_service_id": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "MediaServiceIdentity"},
        "media_service_id": {"key": "properties.mediaServiceId", "type": "str"},
        "storage_accounts": {"key": "properties.storageAccounts", "type": "[StorageAccount]"},
        "storage_authentication": {"key": "properties.storageAuthentication", "type": "str"},
        "encryption": {"key": "properties.encryption", "type": "AccountEncryption"},
        "key_delivery": {"key": "properties.keyDelivery", "type": "KeyDelivery"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.MediaServiceIdentity"] = None,
        storage_accounts: Optional[List["_models.StorageAccount"]] = None,
        storage_authentication: Optional[Union[str, "_models.StorageAuthentication"]] = None,
        encryption: Optional["_models.AccountEncryption"] = None,
        key_delivery: Optional["_models.KeyDelivery"] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The Managed Identity for the Media Services account.
        :paramtype identity: ~azure.mgmt.media.models.MediaServiceIdentity
        :keyword storage_accounts: The storage accounts for this resource.
        :paramtype storage_accounts: list[~azure.mgmt.media.models.StorageAccount]
        :keyword storage_authentication: Known values are: "System" and "ManagedIdentity".
        :paramtype storage_authentication: str or ~azure.mgmt.media.models.StorageAuthentication
        :keyword encryption: The account encryption properties.
        :paramtype encryption: ~azure.mgmt.media.models.AccountEncryption
        :keyword key_delivery: The Key Delivery properties for Media Services account.
        :paramtype key_delivery: ~azure.mgmt.media.models.KeyDelivery
        :keyword public_network_access: Whether or not public network access is allowed for resources
         under the Media Services account. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.media.models.PublicNetworkAccess
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.media_service_id = None
        self.storage_accounts = storage_accounts
        self.storage_authentication = storage_authentication
        self.encryption = encryption
        self.key_delivery = key_delivery
        self.public_network_access = public_network_access
        self.provisioning_state = None
        self.private_endpoint_connections = None


class MetricDimension(_serialization.Model):
    """A metric dimension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The metric dimension name.
    :vartype name: str
    :ivar display_name: The display name for the dimension.
    :vartype display_name: str
    :ivar to_be_exported_for_shoebox: Whether to export metric to shoebox.
    :vartype to_be_exported_for_shoebox: bool
    """

    _validation = {
        "name": {"readonly": True},
        "display_name": {"readonly": True},
        "to_be_exported_for_shoebox": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "to_be_exported_for_shoebox": {"key": "toBeExportedForShoebox", "type": "bool"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.display_name = None
        self.to_be_exported_for_shoebox = None


class MetricSpecification(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """A metric emitted by service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The metric name.
    :vartype name: str
    :ivar display_name: The metric display name.
    :vartype display_name: str
    :ivar display_description: The metric display description.
    :vartype display_description: str
    :ivar unit: The metric unit. Known values are: "Bytes", "Count", and "Milliseconds".
    :vartype unit: str or ~azure.mgmt.media.models.MetricUnit
    :ivar aggregation_type: The metric aggregation type. Known values are: "Average", "Count", and
     "Total".
    :vartype aggregation_type: str or ~azure.mgmt.media.models.MetricAggregationType
    :ivar lock_aggregation_type: The metric lock aggregation type. Known values are: "Average",
     "Count", and "Total".
    :vartype lock_aggregation_type: str or ~azure.mgmt.media.models.MetricAggregationType
    :ivar supported_aggregation_types: Supported aggregation types.
    :vartype supported_aggregation_types: list[str]
    :ivar dimensions: The metric dimensions.
    :vartype dimensions: list[~azure.mgmt.media.models.MetricDimension]
    :ivar enable_regional_mdm_account: Indicates whether regional MDM account is enabled.
    :vartype enable_regional_mdm_account: bool
    :ivar source_mdm_account: The source MDM account.
    :vartype source_mdm_account: str
    :ivar source_mdm_namespace: The source MDM namespace.
    :vartype source_mdm_namespace: str
    :ivar supported_time_grain_types: The supported time grain types.
    :vartype supported_time_grain_types: list[str]
    """

    _validation = {
        "name": {"readonly": True},
        "display_name": {"readonly": True},
        "display_description": {"readonly": True},
        "unit": {"readonly": True},
        "aggregation_type": {"readonly": True},
        "lock_aggregation_type": {"readonly": True},
        "dimensions": {"readonly": True},
        "enable_regional_mdm_account": {"readonly": True},
        "source_mdm_account": {"readonly": True},
        "source_mdm_namespace": {"readonly": True},
        "supported_time_grain_types": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "lock_aggregation_type": {"key": "lockAggregationType", "type": "str"},
        "supported_aggregation_types": {"key": "supportedAggregationTypes", "type": "[str]"},
        "dimensions": {"key": "dimensions", "type": "[MetricDimension]"},
        "enable_regional_mdm_account": {"key": "enableRegionalMdmAccount", "type": "bool"},
        "source_mdm_account": {"key": "sourceMdmAccount", "type": "str"},
        "source_mdm_namespace": {"key": "sourceMdmNamespace", "type": "str"},
        "supported_time_grain_types": {"key": "supportedTimeGrainTypes", "type": "[str]"},
    }

    def __init__(self, *, supported_aggregation_types: Optional[List[str]] = None, **kwargs):
        """
        :keyword supported_aggregation_types: Supported aggregation types.
        :paramtype supported_aggregation_types: list[str]
        """
        super().__init__(**kwargs)
        self.name = None
        self.display_name = None
        self.display_description = None
        self.unit = None
        self.aggregation_type = None
        self.lock_aggregation_type = None
        self.supported_aggregation_types = supported_aggregation_types
        self.dimensions = None
        self.enable_regional_mdm_account = None
        self.source_mdm_account = None
        self.source_mdm_namespace = None
        self.supported_time_grain_types = None


class MultiBitrateFormat(Format):
    """Describes the properties for producing a collection of GOP aligned multi-bitrate files. The default behavior is to produce one output file for each video layer which is muxed together with all the audios. The exact output files produced can be controlled by specifying the outputFiles collection.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    Mp4Format, TransportStreamFormat

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar filename_pattern: The pattern of the file names for the generated output files. The
     following macros are supported in the file name: {Basename} - An expansion macro that will use
     the name of the input video file. If the base name(the file suffix is not included) of the
     input video file is less than 32 characters long, the base name of input video files will be
     used. If the length of base name of the input video file exceeds 32 characters, the base name
     is truncated to the first 32 characters in total length. {Extension} - The appropriate
     extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique
     index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not
     applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video
     resolution. Any unsubstituted macros will be collapsed and removed from the filename. Required.
    :vartype filename_pattern: str
    :ivar output_files: The list of output files to produce.  Each entry in the list is a set of
     audio and video layer labels to be muxed together .
    :vartype output_files: list[~azure.mgmt.media.models.OutputFile]
    """

    _validation = {
        "odata_type": {"required": True},
        "filename_pattern": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "filename_pattern": {"key": "filenamePattern", "type": "str"},
        "output_files": {"key": "outputFiles", "type": "[OutputFile]"},
    }

    _subtype_map = {
        "odata_type": {
            "#Microsoft.Media.Mp4Format": "Mp4Format",
            "#Microsoft.Media.TransportStreamFormat": "TransportStreamFormat",
        }
    }

    def __init__(self, *, filename_pattern: str, output_files: Optional[List["_models.OutputFile"]] = None, **kwargs):
        """
        :keyword filename_pattern: The pattern of the file names for the generated output files. The
         following macros are supported in the file name: {Basename} - An expansion macro that will use
         the name of the input video file. If the base name(the file suffix is not included) of the
         input video file is less than 32 characters long, the base name of input video files will be
         used. If the length of base name of the input video file exceeds 32 characters, the base name
         is truncated to the first 32 characters in total length. {Extension} - The appropriate
         extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique
         index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not
         applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video
         resolution. Any unsubstituted macros will be collapsed and removed from the filename. Required.
        :paramtype filename_pattern: str
        :keyword output_files: The list of output files to produce.  Each entry in the list is a set of
         audio and video layer labels to be muxed together .
        :paramtype output_files: list[~azure.mgmt.media.models.OutputFile]
        """
        super().__init__(filename_pattern=filename_pattern, **kwargs)
        self.odata_type = "#Microsoft.Media.MultiBitrateFormat"  # type: str
        self.output_files = output_files


class Mp4Format(MultiBitrateFormat):
    """Describes the properties for an output ISO MP4 file.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar filename_pattern: The pattern of the file names for the generated output files. The
     following macros are supported in the file name: {Basename} - An expansion macro that will use
     the name of the input video file. If the base name(the file suffix is not included) of the
     input video file is less than 32 characters long, the base name of input video files will be
     used. If the length of base name of the input video file exceeds 32 characters, the base name
     is truncated to the first 32 characters in total length. {Extension} - The appropriate
     extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique
     index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not
     applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video
     resolution. Any unsubstituted macros will be collapsed and removed from the filename. Required.
    :vartype filename_pattern: str
    :ivar output_files: The list of output files to produce.  Each entry in the list is a set of
     audio and video layer labels to be muxed together .
    :vartype output_files: list[~azure.mgmt.media.models.OutputFile]
    """

    _validation = {
        "odata_type": {"required": True},
        "filename_pattern": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "filename_pattern": {"key": "filenamePattern", "type": "str"},
        "output_files": {"key": "outputFiles", "type": "[OutputFile]"},
    }

    def __init__(self, *, filename_pattern: str, output_files: Optional[List["_models.OutputFile"]] = None, **kwargs):
        """
        :keyword filename_pattern: The pattern of the file names for the generated output files. The
         following macros are supported in the file name: {Basename} - An expansion macro that will use
         the name of the input video file. If the base name(the file suffix is not included) of the
         input video file is less than 32 characters long, the base name of input video files will be
         used. If the length of base name of the input video file exceeds 32 characters, the base name
         is truncated to the first 32 characters in total length. {Extension} - The appropriate
         extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique
         index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not
         applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video
         resolution. Any unsubstituted macros will be collapsed and removed from the filename. Required.
        :paramtype filename_pattern: str
        :keyword output_files: The list of output files to produce.  Each entry in the list is a set of
         audio and video layer labels to be muxed together .
        :paramtype output_files: list[~azure.mgmt.media.models.OutputFile]
        """
        super().__init__(filename_pattern=filename_pattern, output_files=output_files, **kwargs)
        self.odata_type = "#Microsoft.Media.Mp4Format"  # type: str


class NoEncryption(_serialization.Model):
    """Class for NoEncryption scheme.

    :ivar enabled_protocols: Representing supported protocols.
    :vartype enabled_protocols: ~azure.mgmt.media.models.EnabledProtocols
    """

    _attribute_map = {
        "enabled_protocols": {"key": "enabledProtocols", "type": "EnabledProtocols"},
    }

    def __init__(self, *, enabled_protocols: Optional["_models.EnabledProtocols"] = None, **kwargs):
        """
        :keyword enabled_protocols: Representing supported protocols.
        :paramtype enabled_protocols: ~azure.mgmt.media.models.EnabledProtocols
        """
        super().__init__(**kwargs)
        self.enabled_protocols = enabled_protocols


class Operation(_serialization.Model):
    """An operation.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The operation name. Required.
    :vartype name: str
    :ivar display: The operation display name.
    :vartype display: ~azure.mgmt.media.models.OperationDisplay
    :ivar origin: Origin of the operation.
    :vartype origin: str
    :ivar properties: Operation properties format.
    :vartype properties: ~azure.mgmt.media.models.Properties
    :ivar is_data_action: Whether the operation applies to data-plane.
    :vartype is_data_action: bool
    :ivar action_type: Indicates the action type. "Internal"
    :vartype action_type: str or ~azure.mgmt.media.models.ActionType
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "Properties"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["_models.Properties"] = None,
        is_data_action: Optional[bool] = None,
        action_type: Optional[Union[str, "_models.ActionType"]] = None,
        **kwargs
    ):
        """
        :keyword name: The operation name. Required.
        :paramtype name: str
        :keyword display: The operation display name.
        :paramtype display: ~azure.mgmt.media.models.OperationDisplay
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        :keyword properties: Operation properties format.
        :paramtype properties: ~azure.mgmt.media.models.Properties
        :keyword is_data_action: Whether the operation applies to data-plane.
        :paramtype is_data_action: bool
        :keyword action_type: Indicates the action type. "Internal"
        :paramtype action_type: str or ~azure.mgmt.media.models.ActionType
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties
        self.is_data_action = is_data_action
        self.action_type = action_type


class OperationCollection(_serialization.Model):
    """A collection of Operation items.

    :ivar value: A collection of Operation items.
    :vartype value: list[~azure.mgmt.media.models.Operation]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(self, *, value: Optional[List["_models.Operation"]] = None, **kwargs):
        """
        :keyword value: A collection of Operation items.
        :paramtype value: list[~azure.mgmt.media.models.Operation]
        """
        super().__init__(**kwargs)
        self.value = value


class OperationDisplay(_serialization.Model):
    """Operation details.

    :ivar provider: The service provider.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: The operation type.
    :vartype operation: str
    :ivar description: The operation description.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: The service provider.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: The operation type.
        :paramtype operation: str
        :keyword description: The operation description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OutputFile(_serialization.Model):
    """Represents an output file produced.

    All required parameters must be populated in order to send to Azure.

    :ivar labels: The list of labels that describe how the encoder should multiplex video and audio
     into an output file. For example, if the encoder is producing two video layers with labels v1
     and v2, and one audio layer with label a1, then an array like '[v1, a1]' tells the encoder to
     produce an output file with the video track represented by v1 and the audio track represented
     by a1. Required.
    :vartype labels: list[str]
    """

    _validation = {
        "labels": {"required": True},
    }

    _attribute_map = {
        "labels": {"key": "labels", "type": "[str]"},
    }

    def __init__(self, *, labels: List[str], **kwargs):
        """
        :keyword labels: The list of labels that describe how the encoder should multiplex video and
         audio into an output file. For example, if the encoder is producing two video layers with
         labels v1 and v2, and one audio layer with label a1, then an array like '[v1, a1]' tells the
         encoder to produce an output file with the video track represented by v1 and the audio track
         represented by a1. Required.
        :paramtype labels: list[str]
        """
        super().__init__(**kwargs)
        self.labels = labels


class PngFormat(ImageFormat):
    """Describes the settings for producing PNG thumbnails.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar filename_pattern: The pattern of the file names for the generated output files. The
     following macros are supported in the file name: {Basename} - An expansion macro that will use
     the name of the input video file. If the base name(the file suffix is not included) of the
     input video file is less than 32 characters long, the base name of input video files will be
     used. If the length of base name of the input video file exceeds 32 characters, the base name
     is truncated to the first 32 characters in total length. {Extension} - The appropriate
     extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique
     index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not
     applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video
     resolution. Any unsubstituted macros will be collapsed and removed from the filename. Required.
    :vartype filename_pattern: str
    """

    _validation = {
        "odata_type": {"required": True},
        "filename_pattern": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "filename_pattern": {"key": "filenamePattern", "type": "str"},
    }

    def __init__(self, *, filename_pattern: str, **kwargs):
        """
        :keyword filename_pattern: The pattern of the file names for the generated output files. The
         following macros are supported in the file name: {Basename} - An expansion macro that will use
         the name of the input video file. If the base name(the file suffix is not included) of the
         input video file is less than 32 characters long, the base name of input video files will be
         used. If the length of base name of the input video file exceeds 32 characters, the base name
         is truncated to the first 32 characters in total length. {Extension} - The appropriate
         extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique
         index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not
         applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video
         resolution. Any unsubstituted macros will be collapsed and removed from the filename. Required.
        :paramtype filename_pattern: str
        """
        super().__init__(filename_pattern=filename_pattern, **kwargs)
        self.odata_type = "#Microsoft.Media.PngFormat"  # type: str


class PngImage(Image):
    """Describes the properties for producing a series of PNG images from the input video.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar label: An optional label for the codec. The label can be used to control muxing behavior.
    :vartype label: str
    :ivar key_frame_interval: The distance between two key frames. The value should be non-zero in
     the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note
     that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval
     value will follow the input source setting.
    :vartype key_frame_interval: ~datetime.timedelta
    :ivar stretch_mode: The resizing mode - how the input video will be resized to fit the desired
     output resolution(s). Default is AutoSize. Known values are: "None", "AutoSize", and "AutoFit".
    :vartype stretch_mode: str or ~azure.mgmt.media.models.StretchMode
    :ivar sync_mode: The Video Sync Mode. Known values are: "Auto", "Passthrough", "Cfr", and
     "Vfr".
    :vartype sync_mode: str or ~azure.mgmt.media.models.VideoSyncMode
    :ivar start: The position in the input video from where to start generating thumbnails. The
     value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count
     (For example, 10 to start at the 10th frame), or a relative value to stream duration (For
     example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the
     encoder to select the best thumbnail from the first few seconds of the video and will only
     produce one thumbnail, no matter what other settings are for Step and Range. The default value
     is macro {Best}. Required.
    :vartype start: str
    :ivar step: The intervals at which thumbnails are generated. The value can be in ISO 8601
     format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30
     for one image every 30 frames), or a relative value to stream duration (For example, 10% for
     one image every 10% of stream duration). Note: Step value will affect the first generated
     thumbnail, which may not be exactly the one specified at transform preset start time. This is
     due to the encoder, which tries to select the best thumbnail between start time and Step
     position from start time as the first output. As the default value is 10%, it means if stream
     has long duration, the first generated thumbnail might be far away from the one specified at
     start time. Try to select reasonable value for Step if the first thumbnail is expected close to
     start time, or set Range value at 1 if only one thumbnail is needed at start time.
    :vartype step: str
    :ivar range: The position relative to transform preset start time in the input video at which
     to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to
     stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop
     at the 300th frame from the frame at start time. If this value is 1, it means only producing
     one thumbnail at start time), or a relative value to the stream duration (For example, 50% to
     stop at half of stream duration from start time). The default value is 100%, which means to
     stop at the end of the stream.
    :vartype range: str
    :ivar layers: A collection of output PNG image layers to be produced by the encoder.
    :vartype layers: list[~azure.mgmt.media.models.PngLayer]
    """

    _validation = {
        "odata_type": {"required": True},
        "start": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "key_frame_interval": {"key": "keyFrameInterval", "type": "duration"},
        "stretch_mode": {"key": "stretchMode", "type": "str"},
        "sync_mode": {"key": "syncMode", "type": "str"},
        "start": {"key": "start", "type": "str"},
        "step": {"key": "step", "type": "str"},
        "range": {"key": "range", "type": "str"},
        "layers": {"key": "layers", "type": "[PngLayer]"},
    }

    def __init__(
        self,
        *,
        start: str,
        label: Optional[str] = None,
        key_frame_interval: Optional[datetime.timedelta] = None,
        stretch_mode: Optional[Union[str, "_models.StretchMode"]] = None,
        sync_mode: Optional[Union[str, "_models.VideoSyncMode"]] = None,
        step: Optional[str] = None,
        range: Optional[str] = None,
        layers: Optional[List["_models.PngLayer"]] = None,
        **kwargs
    ):
        """
        :keyword label: An optional label for the codec. The label can be used to control muxing
         behavior.
        :paramtype label: str
        :keyword key_frame_interval: The distance between two key frames. The value should be non-zero
         in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S).
         Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the
         KeyFrameInterval value will follow the input source setting.
        :paramtype key_frame_interval: ~datetime.timedelta
        :keyword stretch_mode: The resizing mode - how the input video will be resized to fit the
         desired output resolution(s). Default is AutoSize. Known values are: "None", "AutoSize", and
         "AutoFit".
        :paramtype stretch_mode: str or ~azure.mgmt.media.models.StretchMode
        :keyword sync_mode: The Video Sync Mode. Known values are: "Auto", "Passthrough", "Cfr", and
         "Vfr".
        :paramtype sync_mode: str or ~azure.mgmt.media.models.VideoSyncMode
        :keyword start: The position in the input video from where to start generating thumbnails. The
         value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count
         (For example, 10 to start at the 10th frame), or a relative value to stream duration (For
         example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the
         encoder to select the best thumbnail from the first few seconds of the video and will only
         produce one thumbnail, no matter what other settings are for Step and Range. The default value
         is macro {Best}. Required.
        :paramtype start: str
        :keyword step: The intervals at which thumbnails are generated. The value can be in ISO 8601
         format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30
         for one image every 30 frames), or a relative value to stream duration (For example, 10% for
         one image every 10% of stream duration). Note: Step value will affect the first generated
         thumbnail, which may not be exactly the one specified at transform preset start time. This is
         due to the encoder, which tries to select the best thumbnail between start time and Step
         position from start time as the first output. As the default value is 10%, it means if stream
         has long duration, the first generated thumbnail might be far away from the one specified at
         start time. Try to select reasonable value for Step if the first thumbnail is expected close to
         start time, or set Range value at 1 if only one thumbnail is needed at start time.
        :paramtype step: str
        :keyword range: The position relative to transform preset start time in the input video at
         which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S
         to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to
         stop at the 300th frame from the frame at start time. If this value is 1, it means only
         producing one thumbnail at start time), or a relative value to the stream duration (For
         example, 50% to stop at half of stream duration from start time). The default value is 100%,
         which means to stop at the end of the stream.
        :paramtype range: str
        :keyword layers: A collection of output PNG image layers to be produced by the encoder.
        :paramtype layers: list[~azure.mgmt.media.models.PngLayer]
        """
        super().__init__(
            label=label,
            key_frame_interval=key_frame_interval,
            stretch_mode=stretch_mode,
            sync_mode=sync_mode,
            start=start,
            step=step,
            range=range,
            **kwargs
        )
        self.odata_type = "#Microsoft.Media.PngImage"  # type: str
        self.layers = layers


class PngLayer(Layer):
    """Describes the settings to produce a PNG image from the input video.

    :ivar width: The width of the output video for this layer. The value can be absolute (in
     pixels) or relative (in percentage). For example 50% means the output video has half as many
     pixels in width as the input.
    :vartype width: str
    :ivar height: The height of the output video for this layer. The value can be absolute (in
     pixels) or relative (in percentage). For example 50% means the output video has half as many
     pixels in height as the input.
    :vartype height: str
    :ivar label: The alphanumeric label for this layer, which can be used in multiplexing different
     video and audio layers, or in naming the output file.
    :vartype label: str
    """

    _attribute_map = {
        "width": {"key": "width", "type": "str"},
        "height": {"key": "height", "type": "str"},
        "label": {"key": "label", "type": "str"},
    }

    def __init__(
        self, *, width: Optional[str] = None, height: Optional[str] = None, label: Optional[str] = None, **kwargs
    ):
        """
        :keyword width: The width of the output video for this layer. The value can be absolute (in
         pixels) or relative (in percentage). For example 50% means the output video has half as many
         pixels in width as the input.
        :paramtype width: str
        :keyword height: The height of the output video for this layer. The value can be absolute (in
         pixels) or relative (in percentage). For example 50% means the output video has half as many
         pixels in height as the input.
        :paramtype height: str
        :keyword label: The alphanumeric label for this layer, which can be used in multiplexing
         different video and audio layers, or in naming the output file.
        :paramtype label: str
        """
        super().__init__(width=width, height=height, label=label, **kwargs)


class PresentationTimeRange(_serialization.Model):
    """The presentation time range, this is asset related and not recommended for Account Filter.

    :ivar start_timestamp: The absolute start time boundary.
    :vartype start_timestamp: int
    :ivar end_timestamp: The absolute end time boundary.
    :vartype end_timestamp: int
    :ivar presentation_window_duration: The relative to end sliding window.
    :vartype presentation_window_duration: int
    :ivar live_backoff_duration: The relative to end right edge.
    :vartype live_backoff_duration: int
    :ivar timescale: The time scale of time stamps.
    :vartype timescale: int
    :ivar force_end_timestamp: The indicator of forcing existing of end time stamp.
    :vartype force_end_timestamp: bool
    """

    _attribute_map = {
        "start_timestamp": {"key": "startTimestamp", "type": "int"},
        "end_timestamp": {"key": "endTimestamp", "type": "int"},
        "presentation_window_duration": {"key": "presentationWindowDuration", "type": "int"},
        "live_backoff_duration": {"key": "liveBackoffDuration", "type": "int"},
        "timescale": {"key": "timescale", "type": "int"},
        "force_end_timestamp": {"key": "forceEndTimestamp", "type": "bool"},
    }

    def __init__(
        self,
        *,
        start_timestamp: Optional[int] = None,
        end_timestamp: Optional[int] = None,
        presentation_window_duration: Optional[int] = None,
        live_backoff_duration: Optional[int] = None,
        timescale: Optional[int] = None,
        force_end_timestamp: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword start_timestamp: The absolute start time boundary.
        :paramtype start_timestamp: int
        :keyword end_timestamp: The absolute end time boundary.
        :paramtype end_timestamp: int
        :keyword presentation_window_duration: The relative to end sliding window.
        :paramtype presentation_window_duration: int
        :keyword live_backoff_duration: The relative to end right edge.
        :paramtype live_backoff_duration: int
        :keyword timescale: The time scale of time stamps.
        :paramtype timescale: int
        :keyword force_end_timestamp: The indicator of forcing existing of end time stamp.
        :paramtype force_end_timestamp: bool
        """
        super().__init__(**kwargs)
        self.start_timestamp = start_timestamp
        self.end_timestamp = end_timestamp
        self.presentation_window_duration = presentation_window_duration
        self.live_backoff_duration = live_backoff_duration
        self.timescale = timescale
        self.force_end_timestamp = force_end_timestamp


class PresetConfigurations(_serialization.Model):
    """An object of optional configuration settings for encoder.

    :ivar complexity: Allows you to configure the encoder settings to control the balance between
     speed and quality. Example: set Complexity as Speed for faster encoding but less compression
     efficiency. Known values are: "Speed", "Balanced", and "Quality".
    :vartype complexity: str or ~azure.mgmt.media.models.Complexity
    :ivar interleave_output: Sets the interleave mode of the output to control how audio and video
     are stored in the container format. Example: set InterleavedOutput as NonInterleavedOutput to
     produce audio-only and video-only outputs in separate MP4 files. Known values are:
     "NonInterleavedOutput" and "InterleavedOutput".
    :vartype interleave_output: str or ~azure.mgmt.media.models.InterleaveOutput
    :ivar key_frame_interval_in_seconds: The key frame interval in seconds. Example: set
     KeyFrameIntervalInSeconds as 2 to reduce the playback buffering for some players.
    :vartype key_frame_interval_in_seconds: float
    :ivar max_bitrate_bps: The maximum bitrate in bits per second (threshold for the top video
     layer). Example: set MaxBitrateBps as 6000000 to avoid producing very high bitrate outputs for
     contents with high complexity.
    :vartype max_bitrate_bps: int
    :ivar max_height: The maximum height of output video layers. Example: set MaxHeight as 720 to
     produce output layers up to 720P even if the input is 4K.
    :vartype max_height: int
    :ivar max_layers: The maximum number of output video layers. Example: set MaxLayers as 4 to
     make sure at most 4 output layers are produced to control the overall cost of the encoding job.
    :vartype max_layers: int
    :ivar min_bitrate_bps: The minimum bitrate in bits per second (threshold for the bottom video
     layer). Example: set MinBitrateBps as 200000 to have a bottom layer that covers users with low
     network bandwidth.
    :vartype min_bitrate_bps: int
    :ivar min_height: The minimum height of output video layers. Example: set MinHeight as 360 to
     avoid output layers of smaller resolutions like 180P.
    :vartype min_height: int
    """

    _attribute_map = {
        "complexity": {"key": "complexity", "type": "str"},
        "interleave_output": {"key": "interleaveOutput", "type": "str"},
        "key_frame_interval_in_seconds": {"key": "keyFrameIntervalInSeconds", "type": "float"},
        "max_bitrate_bps": {"key": "maxBitrateBps", "type": "int"},
        "max_height": {"key": "maxHeight", "type": "int"},
        "max_layers": {"key": "maxLayers", "type": "int"},
        "min_bitrate_bps": {"key": "minBitrateBps", "type": "int"},
        "min_height": {"key": "minHeight", "type": "int"},
    }

    def __init__(
        self,
        *,
        complexity: Optional[Union[str, "_models.Complexity"]] = None,
        interleave_output: Optional[Union[str, "_models.InterleaveOutput"]] = None,
        key_frame_interval_in_seconds: Optional[float] = None,
        max_bitrate_bps: Optional[int] = None,
        max_height: Optional[int] = None,
        max_layers: Optional[int] = None,
        min_bitrate_bps: Optional[int] = None,
        min_height: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword complexity: Allows you to configure the encoder settings to control the balance
         between speed and quality. Example: set Complexity as Speed for faster encoding but less
         compression efficiency. Known values are: "Speed", "Balanced", and "Quality".
        :paramtype complexity: str or ~azure.mgmt.media.models.Complexity
        :keyword interleave_output: Sets the interleave mode of the output to control how audio and
         video are stored in the container format. Example: set InterleavedOutput as
         NonInterleavedOutput to produce audio-only and video-only outputs in separate MP4 files. Known
         values are: "NonInterleavedOutput" and "InterleavedOutput".
        :paramtype interleave_output: str or ~azure.mgmt.media.models.InterleaveOutput
        :keyword key_frame_interval_in_seconds: The key frame interval in seconds. Example: set
         KeyFrameIntervalInSeconds as 2 to reduce the playback buffering for some players.
        :paramtype key_frame_interval_in_seconds: float
        :keyword max_bitrate_bps: The maximum bitrate in bits per second (threshold for the top video
         layer). Example: set MaxBitrateBps as 6000000 to avoid producing very high bitrate outputs for
         contents with high complexity.
        :paramtype max_bitrate_bps: int
        :keyword max_height: The maximum height of output video layers. Example: set MaxHeight as 720
         to produce output layers up to 720P even if the input is 4K.
        :paramtype max_height: int
        :keyword max_layers: The maximum number of output video layers. Example: set MaxLayers as 4 to
         make sure at most 4 output layers are produced to control the overall cost of the encoding job.
        :paramtype max_layers: int
        :keyword min_bitrate_bps: The minimum bitrate in bits per second (threshold for the bottom
         video layer). Example: set MinBitrateBps as 200000 to have a bottom layer that covers users
         with low network bandwidth.
        :paramtype min_bitrate_bps: int
        :keyword min_height: The minimum height of output video layers. Example: set MinHeight as 360
         to avoid output layers of smaller resolutions like 180P.
        :paramtype min_height: int
        """
        super().__init__(**kwargs)
        self.complexity = complexity
        self.interleave_output = interleave_output
        self.key_frame_interval_in_seconds = key_frame_interval_in_seconds
        self.max_bitrate_bps = max_bitrate_bps
        self.max_height = max_height
        self.max_layers = max_layers
        self.min_bitrate_bps = min_bitrate_bps
        self.min_height = min_height


class PrivateEndpoint(_serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~azure.mgmt.media.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.media.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.media.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        """
        :keyword private_endpoint: The resource of private end point.
        :paramtype private_endpoint: ~azure.mgmt.media.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.media.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(_serialization.Model):
    """List of private endpoint connection associated with the specified storage account.

    :ivar value: Array of private endpoint connections.
    :vartype value: list[~azure.mgmt.media.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs):
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value: list[~azure.mgmt.media.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, *, required_zone_names: Optional[List[str]] = None, **kwargs):
        """
        :keyword required_zone_names: The private link resource Private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.media.models.PrivateLinkResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs):
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.media.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or ~azure.mgmt.media.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", and "Rejected".
        :paramtype status: str or ~azure.mgmt.media.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class Properties(_serialization.Model):
    """The service specification property.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_specification: The service specifications.
    :vartype service_specification: ~azure.mgmt.media.models.ServiceSpecification
    """

    _validation = {
        "service_specification": {"readonly": True},
    }

    _attribute_map = {
        "service_specification": {"key": "serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.service_specification = None


class Rectangle(_serialization.Model):
    """Describes the properties of a rectangular window applied to the input media before processing it.

    :ivar left: The number of pixels from the left-margin. This can be absolute pixel value (e.g
     100), or relative to the size of the video (For example, 50%).
    :vartype left: str
    :ivar top: The number of pixels from the top-margin. This can be absolute pixel value (e.g
     100), or relative to the size of the video (For example, 50%).
    :vartype top: str
    :ivar width: The width of the rectangular region in pixels. This can be absolute pixel value
     (e.g 100), or relative to the size of the video (For example, 50%).
    :vartype width: str
    :ivar height: The height of the rectangular region in pixels. This can be absolute pixel value
     (e.g 100), or relative to the size of the video (For example, 50%).
    :vartype height: str
    """

    _attribute_map = {
        "left": {"key": "left", "type": "str"},
        "top": {"key": "top", "type": "str"},
        "width": {"key": "width", "type": "str"},
        "height": {"key": "height", "type": "str"},
    }

    def __init__(
        self,
        *,
        left: Optional[str] = None,
        top: Optional[str] = None,
        width: Optional[str] = None,
        height: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword left: The number of pixels from the left-margin. This can be absolute pixel value (e.g
         100), or relative to the size of the video (For example, 50%).
        :paramtype left: str
        :keyword top: The number of pixels from the top-margin. This can be absolute pixel value (e.g
         100), or relative to the size of the video (For example, 50%).
        :paramtype top: str
        :keyword width: The width of the rectangular region in pixels. This can be absolute pixel value
         (e.g 100), or relative to the size of the video (For example, 50%).
        :paramtype width: str
        :keyword height: The height of the rectangular region in pixels. This can be absolute pixel
         value (e.g 100), or relative to the size of the video (For example, 50%).
        :paramtype height: str
        """
        super().__init__(**kwargs)
        self.left = left
        self.top = top
        self.width = width
        self.height = height


class ResourceIdentity(_serialization.Model):
    """ResourceIdentity.

    All required parameters must be populated in order to send to Azure.

    :ivar user_assigned_identity: The user assigned managed identity's ARM ID to use when accessing
     a resource.
    :vartype user_assigned_identity: str
    :ivar use_system_assigned_identity: Indicates whether to use System Assigned Managed Identity.
     Mutual exclusive with User Assigned Managed Identity. Required.
    :vartype use_system_assigned_identity: bool
    """

    _validation = {
        "use_system_assigned_identity": {"required": True},
    }

    _attribute_map = {
        "user_assigned_identity": {"key": "userAssignedIdentity", "type": "str"},
        "use_system_assigned_identity": {"key": "useSystemAssignedIdentity", "type": "bool"},
    }

    def __init__(self, *, use_system_assigned_identity: bool, user_assigned_identity: Optional[str] = None, **kwargs):
        """
        :keyword user_assigned_identity: The user assigned managed identity's ARM ID to use when
         accessing a resource.
        :paramtype user_assigned_identity: str
        :keyword use_system_assigned_identity: Indicates whether to use System Assigned Managed
         Identity. Mutual exclusive with User Assigned Managed Identity. Required.
        :paramtype use_system_assigned_identity: bool
        """
        super().__init__(**kwargs)
        self.user_assigned_identity = user_assigned_identity
        self.use_system_assigned_identity = use_system_assigned_identity


class SelectAudioTrackByAttribute(AudioTrackDescriptor):
    """Select audio tracks from the input by specifying an attribute and an attribute filter.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar channel_mapping: Optional designation for single channel audio tracks.  Can be used to
     combine the tracks into stereo or multi-channel audio tracks. Known values are: "FrontLeft",
     "FrontRight", "Center", "LowFrequencyEffects", "BackLeft", "BackRight", "StereoLeft", and
     "StereoRight".
    :vartype channel_mapping: str or ~azure.mgmt.media.models.ChannelMapping
    :ivar attribute: The TrackAttribute to filter the tracks by. Required. Known values are:
     "Bitrate" and "Language".
    :vartype attribute: str or ~azure.mgmt.media.models.TrackAttribute
    :ivar filter: The type of AttributeFilter to apply to the TrackAttribute in order to select the
     tracks. Required. Known values are: "All", "Top", "Bottom", and "ValueEquals".
    :vartype filter: str or ~azure.mgmt.media.models.AttributeFilter
    :ivar filter_value: The value to filter the tracks by.  Only used when
     AttributeFilter.ValueEquals is specified for the Filter property.
    :vartype filter_value: str
    """

    _validation = {
        "odata_type": {"required": True},
        "attribute": {"required": True},
        "filter": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "channel_mapping": {"key": "channelMapping", "type": "str"},
        "attribute": {"key": "attribute", "type": "str"},
        "filter": {"key": "filter", "type": "str"},
        "filter_value": {"key": "filterValue", "type": "str"},
    }

    def __init__(
        self,
        *,
        attribute: Union[str, "_models.TrackAttribute"],
        filter: Union[str, "_models.AttributeFilter"],  # pylint: disable=redefined-builtin
        channel_mapping: Optional[Union[str, "_models.ChannelMapping"]] = None,
        filter_value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword channel_mapping: Optional designation for single channel audio tracks.  Can be used to
         combine the tracks into stereo or multi-channel audio tracks. Known values are: "FrontLeft",
         "FrontRight", "Center", "LowFrequencyEffects", "BackLeft", "BackRight", "StereoLeft", and
         "StereoRight".
        :paramtype channel_mapping: str or ~azure.mgmt.media.models.ChannelMapping
        :keyword attribute: The TrackAttribute to filter the tracks by. Required. Known values are:
         "Bitrate" and "Language".
        :paramtype attribute: str or ~azure.mgmt.media.models.TrackAttribute
        :keyword filter: The type of AttributeFilter to apply to the TrackAttribute in order to select
         the tracks. Required. Known values are: "All", "Top", "Bottom", and "ValueEquals".
        :paramtype filter: str or ~azure.mgmt.media.models.AttributeFilter
        :keyword filter_value: The value to filter the tracks by.  Only used when
         AttributeFilter.ValueEquals is specified for the Filter property.
        :paramtype filter_value: str
        """
        super().__init__(channel_mapping=channel_mapping, **kwargs)
        self.odata_type = "#Microsoft.Media.SelectAudioTrackByAttribute"  # type: str
        self.attribute = attribute
        self.filter = filter
        self.filter_value = filter_value


class SelectAudioTrackById(AudioTrackDescriptor):
    """Select audio tracks from the input by specifying a track identifier.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar channel_mapping: Optional designation for single channel audio tracks.  Can be used to
     combine the tracks into stereo or multi-channel audio tracks. Known values are: "FrontLeft",
     "FrontRight", "Center", "LowFrequencyEffects", "BackLeft", "BackRight", "StereoLeft", and
     "StereoRight".
    :vartype channel_mapping: str or ~azure.mgmt.media.models.ChannelMapping
    :ivar track_id: Track identifier to select. Required.
    :vartype track_id: int
    """

    _validation = {
        "odata_type": {"required": True},
        "track_id": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "channel_mapping": {"key": "channelMapping", "type": "str"},
        "track_id": {"key": "trackId", "type": "int"},
    }

    def __init__(
        self, *, track_id: int, channel_mapping: Optional[Union[str, "_models.ChannelMapping"]] = None, **kwargs
    ):
        """
        :keyword channel_mapping: Optional designation for single channel audio tracks.  Can be used to
         combine the tracks into stereo or multi-channel audio tracks. Known values are: "FrontLeft",
         "FrontRight", "Center", "LowFrequencyEffects", "BackLeft", "BackRight", "StereoLeft", and
         "StereoRight".
        :paramtype channel_mapping: str or ~azure.mgmt.media.models.ChannelMapping
        :keyword track_id: Track identifier to select. Required.
        :paramtype track_id: int
        """
        super().__init__(channel_mapping=channel_mapping, **kwargs)
        self.odata_type = "#Microsoft.Media.SelectAudioTrackById"  # type: str
        self.track_id = track_id


class VideoTrackDescriptor(TrackDescriptor):
    """A TrackSelection to select video tracks.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    SelectVideoTrackByAttribute, SelectVideoTrackById

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
    }

    _subtype_map = {
        "odata_type": {
            "#Microsoft.Media.SelectVideoTrackByAttribute": "SelectVideoTrackByAttribute",
            "#Microsoft.Media.SelectVideoTrackById": "SelectVideoTrackById",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.VideoTrackDescriptor"  # type: str


class SelectVideoTrackByAttribute(VideoTrackDescriptor):
    """Select video tracks from the input by specifying an attribute and an attribute filter.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar attribute: The TrackAttribute to filter the tracks by. Required. Known values are:
     "Bitrate" and "Language".
    :vartype attribute: str or ~azure.mgmt.media.models.TrackAttribute
    :ivar filter: The type of AttributeFilter to apply to the TrackAttribute in order to select the
     tracks. Required. Known values are: "All", "Top", "Bottom", and "ValueEquals".
    :vartype filter: str or ~azure.mgmt.media.models.AttributeFilter
    :ivar filter_value: The value to filter the tracks by.  Only used when
     AttributeFilter.ValueEquals is specified for the Filter property. For TrackAttribute.Bitrate,
     this should be an integer value in bits per second (e.g: '1500000').  The
     TrackAttribute.Language is not supported for video tracks.
    :vartype filter_value: str
    """

    _validation = {
        "odata_type": {"required": True},
        "attribute": {"required": True},
        "filter": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "attribute": {"key": "attribute", "type": "str"},
        "filter": {"key": "filter", "type": "str"},
        "filter_value": {"key": "filterValue", "type": "str"},
    }

    def __init__(
        self,
        *,
        attribute: Union[str, "_models.TrackAttribute"],
        filter: Union[str, "_models.AttributeFilter"],  # pylint: disable=redefined-builtin
        filter_value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword attribute: The TrackAttribute to filter the tracks by. Required. Known values are:
         "Bitrate" and "Language".
        :paramtype attribute: str or ~azure.mgmt.media.models.TrackAttribute
        :keyword filter: The type of AttributeFilter to apply to the TrackAttribute in order to select
         the tracks. Required. Known values are: "All", "Top", "Bottom", and "ValueEquals".
        :paramtype filter: str or ~azure.mgmt.media.models.AttributeFilter
        :keyword filter_value: The value to filter the tracks by.  Only used when
         AttributeFilter.ValueEquals is specified for the Filter property. For TrackAttribute.Bitrate,
         this should be an integer value in bits per second (e.g: '1500000').  The
         TrackAttribute.Language is not supported for video tracks.
        :paramtype filter_value: str
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.SelectVideoTrackByAttribute"  # type: str
        self.attribute = attribute
        self.filter = filter
        self.filter_value = filter_value


class SelectVideoTrackById(VideoTrackDescriptor):
    """Select video tracks from the input by specifying a track identifier.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar track_id: Track identifier to select. Required.
    :vartype track_id: int
    """

    _validation = {
        "odata_type": {"required": True},
        "track_id": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "track_id": {"key": "trackId", "type": "int"},
    }

    def __init__(self, *, track_id: int, **kwargs):
        """
        :keyword track_id: Track identifier to select. Required.
        :paramtype track_id: int
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.SelectVideoTrackById"  # type: str
        self.track_id = track_id


class ServiceSpecification(_serialization.Model):
    """The service metric specifications.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar log_specifications: List of log specifications.
    :vartype log_specifications: list[~azure.mgmt.media.models.LogSpecification]
    :ivar metric_specifications: List of metric specifications.
    :vartype metric_specifications: list[~azure.mgmt.media.models.MetricSpecification]
    """

    _validation = {
        "log_specifications": {"readonly": True},
        "metric_specifications": {"readonly": True},
    }

    _attribute_map = {
        "log_specifications": {"key": "logSpecifications", "type": "[LogSpecification]"},
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.log_specifications = None
        self.metric_specifications = None


class StandardEncoderPreset(Preset):
    """Describes all the settings to be used when encoding the input video with the Standard Encoder.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar filters: One or more filtering operations that are applied to the input media before
     encoding.
    :vartype filters: ~azure.mgmt.media.models.Filters
    :ivar codecs: The list of codecs to be used when encoding the input video. Required.
    :vartype codecs: list[~azure.mgmt.media.models.Codec]
    :ivar formats: The list of outputs to be produced by the encoder. Required.
    :vartype formats: list[~azure.mgmt.media.models.Format]
    """

    _validation = {
        "odata_type": {"required": True},
        "codecs": {"required": True},
        "formats": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "filters": {"key": "filters", "type": "Filters"},
        "codecs": {"key": "codecs", "type": "[Codec]"},
        "formats": {"key": "formats", "type": "[Format]"},
    }

    def __init__(
        self,
        *,
        codecs: List["_models.Codec"],
        formats: List["_models.Format"],
        filters: Optional["_models.Filters"] = None,
        **kwargs
    ):
        """
        :keyword filters: One or more filtering operations that are applied to the input media before
         encoding.
        :paramtype filters: ~azure.mgmt.media.models.Filters
        :keyword codecs: The list of codecs to be used when encoding the input video. Required.
        :paramtype codecs: list[~azure.mgmt.media.models.Codec]
        :keyword formats: The list of outputs to be produced by the encoder. Required.
        :paramtype formats: list[~azure.mgmt.media.models.Format]
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.StandardEncoderPreset"  # type: str
        self.filters = filters
        self.codecs = codecs
        self.formats = formats


class StorageAccount(_serialization.Model):
    """The storage account details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The ID of the storage account resource. Media Services relies on tables and queues as
     well as blobs, so the primary storage account must be a Standard Storage account (either
     Microsoft.ClassicStorage or Microsoft.Storage). Blob only storage accounts can be added as
     secondary storage accounts.
    :vartype id: str
    :ivar type: The type of the storage account. Required. Known values are: "Primary" and
     "Secondary".
    :vartype type: str or ~azure.mgmt.media.models.StorageAccountType
    :ivar identity: The storage account identity.
    :vartype identity: ~azure.mgmt.media.models.ResourceIdentity
    :ivar status: The current status of the storage account mapping.
    :vartype status: str
    """

    _validation = {
        "type": {"required": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "identity": {"key": "identity", "type": "ResourceIdentity"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.StorageAccountType"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        identity: Optional["_models.ResourceIdentity"] = None,
        **kwargs
    ):
        """
        :keyword id: The ID of the storage account resource. Media Services relies on tables and queues
         as well as blobs, so the primary storage account must be a Standard Storage account (either
         Microsoft.ClassicStorage or Microsoft.Storage). Blob only storage accounts can be added as
         secondary storage accounts.
        :paramtype id: str
        :keyword type: The type of the storage account. Required. Known values are: "Primary" and
         "Secondary".
        :paramtype type: str or ~azure.mgmt.media.models.StorageAccountType
        :keyword identity: The storage account identity.
        :paramtype identity: ~azure.mgmt.media.models.ResourceIdentity
        """
        super().__init__(**kwargs)
        self.id = id
        self.type = type
        self.identity = identity
        self.status = None


class StorageEncryptedAssetDecryptionData(_serialization.Model):
    """Data needed to decrypt asset files encrypted with legacy storage encryption.

    :ivar key: The Asset File storage encryption key.
    :vartype key: bytes
    :ivar asset_file_encryption_metadata: Asset File encryption metadata.
    :vartype asset_file_encryption_metadata:
     list[~azure.mgmt.media.models.AssetFileEncryptionMetadata]
    """

    _attribute_map = {
        "key": {"key": "key", "type": "bytearray"},
        "asset_file_encryption_metadata": {
            "key": "assetFileEncryptionMetadata",
            "type": "[AssetFileEncryptionMetadata]",
        },
    }

    def __init__(
        self,
        *,
        key: Optional[bytes] = None,
        asset_file_encryption_metadata: Optional[List["_models.AssetFileEncryptionMetadata"]] = None,
        **kwargs
    ):
        """
        :keyword key: The Asset File storage encryption key.
        :paramtype key: bytes
        :keyword asset_file_encryption_metadata: Asset File encryption metadata.
        :paramtype asset_file_encryption_metadata:
         list[~azure.mgmt.media.models.AssetFileEncryptionMetadata]
        """
        super().__init__(**kwargs)
        self.key = key
        self.asset_file_encryption_metadata = asset_file_encryption_metadata


class StreamingEndpoint(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The streaming endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    :ivar sku: The streaming endpoint sku.
    :vartype sku: ~azure.mgmt.media.models.ArmStreamingEndpointCurrentSku
    :ivar description: The streaming endpoint description.
    :vartype description: str
    :ivar scale_units: The number of scale units. Use the Scale operation to adjust this value.
    :vartype scale_units: int
    :ivar availability_set_name: This feature is deprecated, do not set a value for this property.
    :vartype availability_set_name: str
    :ivar access_control: The access control definition of the streaming endpoint.
    :vartype access_control: ~azure.mgmt.media.models.StreamingEndpointAccessControl
    :ivar max_cache_age: Max cache age.
    :vartype max_cache_age: int
    :ivar custom_host_names: The custom host names of the streaming endpoint.
    :vartype custom_host_names: list[str]
    :ivar host_name: The streaming endpoint host name.
    :vartype host_name: str
    :ivar cdn_enabled: The CDN enabled flag.
    :vartype cdn_enabled: bool
    :ivar cdn_provider: The CDN provider name.
    :vartype cdn_provider: str
    :ivar cdn_profile: The CDN profile name.
    :vartype cdn_profile: str
    :ivar provisioning_state: The provisioning state of the streaming endpoint.
    :vartype provisioning_state: str
    :ivar resource_state: The resource state of the streaming endpoint. Known values are:
     "Stopped", "Starting", "Running", "Stopping", "Deleting", and "Scaling".
    :vartype resource_state: str or ~azure.mgmt.media.models.StreamingEndpointResourceState
    :ivar cross_site_access_policies: The streaming endpoint access policies.
    :vartype cross_site_access_policies: ~azure.mgmt.media.models.CrossSiteAccessPolicies
    :ivar free_trial_end_time: The free trial expiration time.
    :vartype free_trial_end_time: ~datetime.datetime
    :ivar created: The exact time the streaming endpoint was created.
    :vartype created: ~datetime.datetime
    :ivar last_modified: The exact time the streaming endpoint was last modified.
    :vartype last_modified: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "host_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "resource_state": {"readonly": True},
        "free_trial_end_time": {"readonly": True},
        "created": {"readonly": True},
        "last_modified": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "sku": {"key": "sku", "type": "ArmStreamingEndpointCurrentSku"},
        "description": {"key": "properties.description", "type": "str"},
        "scale_units": {"key": "properties.scaleUnits", "type": "int"},
        "availability_set_name": {"key": "properties.availabilitySetName", "type": "str"},
        "access_control": {"key": "properties.accessControl", "type": "StreamingEndpointAccessControl"},
        "max_cache_age": {"key": "properties.maxCacheAge", "type": "int"},
        "custom_host_names": {"key": "properties.customHostNames", "type": "[str]"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "cdn_enabled": {"key": "properties.cdnEnabled", "type": "bool"},
        "cdn_provider": {"key": "properties.cdnProvider", "type": "str"},
        "cdn_profile": {"key": "properties.cdnProfile", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_state": {"key": "properties.resourceState", "type": "str"},
        "cross_site_access_policies": {"key": "properties.crossSiteAccessPolicies", "type": "CrossSiteAccessPolicies"},
        "free_trial_end_time": {"key": "properties.freeTrialEndTime", "type": "iso-8601"},
        "created": {"key": "properties.created", "type": "iso-8601"},
        "last_modified": {"key": "properties.lastModified", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.ArmStreamingEndpointCurrentSku"] = None,
        description: Optional[str] = None,
        scale_units: Optional[int] = None,
        availability_set_name: Optional[str] = None,
        access_control: Optional["_models.StreamingEndpointAccessControl"] = None,
        max_cache_age: Optional[int] = None,
        custom_host_names: Optional[List[str]] = None,
        cdn_enabled: Optional[bool] = None,
        cdn_provider: Optional[str] = None,
        cdn_profile: Optional[str] = None,
        cross_site_access_policies: Optional["_models.CrossSiteAccessPolicies"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword sku: The streaming endpoint sku.
        :paramtype sku: ~azure.mgmt.media.models.ArmStreamingEndpointCurrentSku
        :keyword description: The streaming endpoint description.
        :paramtype description: str
        :keyword scale_units: The number of scale units. Use the Scale operation to adjust this value.
        :paramtype scale_units: int
        :keyword availability_set_name: This feature is deprecated, do not set a value for this
         property.
        :paramtype availability_set_name: str
        :keyword access_control: The access control definition of the streaming endpoint.
        :paramtype access_control: ~azure.mgmt.media.models.StreamingEndpointAccessControl
        :keyword max_cache_age: Max cache age.
        :paramtype max_cache_age: int
        :keyword custom_host_names: The custom host names of the streaming endpoint.
        :paramtype custom_host_names: list[str]
        :keyword cdn_enabled: The CDN enabled flag.
        :paramtype cdn_enabled: bool
        :keyword cdn_provider: The CDN provider name.
        :paramtype cdn_provider: str
        :keyword cdn_profile: The CDN profile name.
        :paramtype cdn_profile: str
        :keyword cross_site_access_policies: The streaming endpoint access policies.
        :paramtype cross_site_access_policies: ~azure.mgmt.media.models.CrossSiteAccessPolicies
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.system_data = None
        self.sku = sku
        self.description = description
        self.scale_units = scale_units
        self.availability_set_name = availability_set_name
        self.access_control = access_control
        self.max_cache_age = max_cache_age
        self.custom_host_names = custom_host_names
        self.host_name = None
        self.cdn_enabled = cdn_enabled
        self.cdn_provider = cdn_provider
        self.cdn_profile = cdn_profile
        self.provisioning_state = None
        self.resource_state = None
        self.cross_site_access_policies = cross_site_access_policies
        self.free_trial_end_time = None
        self.created = None
        self.last_modified = None


class StreamingEndpointAccessControl(_serialization.Model):
    """Streaming endpoint access control definition.

    :ivar akamai: The access control of Akamai.
    :vartype akamai: ~azure.mgmt.media.models.AkamaiAccessControl
    :ivar ip: The IP access control of the streaming endpoint.
    :vartype ip: ~azure.mgmt.media.models.IPAccessControl
    """

    _attribute_map = {
        "akamai": {"key": "akamai", "type": "AkamaiAccessControl"},
        "ip": {"key": "ip", "type": "IPAccessControl"},
    }

    def __init__(
        self,
        *,
        akamai: Optional["_models.AkamaiAccessControl"] = None,
        ip: Optional["_models.IPAccessControl"] = None,
        **kwargs
    ):
        """
        :keyword akamai: The access control of Akamai.
        :paramtype akamai: ~azure.mgmt.media.models.AkamaiAccessControl
        :keyword ip: The IP access control of the streaming endpoint.
        :paramtype ip: ~azure.mgmt.media.models.IPAccessControl
        """
        super().__init__(**kwargs)
        self.akamai = akamai
        self.ip = ip


class StreamingEndpointListResult(_serialization.Model):
    """The streaming endpoint list result.

    :ivar value: The result of the List StreamingEndpoint operation.
    :vartype value: list[~azure.mgmt.media.models.StreamingEndpoint]
    :ivar odata_count: The number of result.
    :vartype odata_count: int
    :ivar odata_next_link: The link to the next set of results. Not empty if value contains
     incomplete list of streaming endpoints.
    :vartype odata_next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[StreamingEndpoint]"},
        "odata_count": {"key": "@odata\\.count", "type": "int"},
        "odata_next_link": {"key": "@odata\\.nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.StreamingEndpoint"]] = None,
        odata_count: Optional[int] = None,
        odata_next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The result of the List StreamingEndpoint operation.
        :paramtype value: list[~azure.mgmt.media.models.StreamingEndpoint]
        :keyword odata_count: The number of result.
        :paramtype odata_count: int
        :keyword odata_next_link: The link to the next set of results. Not empty if value contains
         incomplete list of streaming endpoints.
        :paramtype odata_next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.odata_count = odata_count
        self.odata_next_link = odata_next_link


class StreamingEndpointSkuInfoListResult(_serialization.Model):
    """StreamingEndpointSkuInfoListResult.

    :ivar value: The result of the List StreamingEndpoint skus.
    :vartype value: list[~azure.mgmt.media.models.ArmStreamingEndpointSkuInfo]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ArmStreamingEndpointSkuInfo]"},
    }

    def __init__(self, *, value: Optional[List["_models.ArmStreamingEndpointSkuInfo"]] = None, **kwargs):
        """
        :keyword value: The result of the List StreamingEndpoint skus.
        :paramtype value: list[~azure.mgmt.media.models.ArmStreamingEndpointSkuInfo]
        """
        super().__init__(**kwargs)
        self.value = value


class StreamingEntityScaleUnit(_serialization.Model):
    """scale units definition.

    :ivar scale_unit: The scale unit number of the streaming endpoint.
    :vartype scale_unit: int
    """

    _attribute_map = {
        "scale_unit": {"key": "scaleUnit", "type": "int"},
    }

    def __init__(self, *, scale_unit: Optional[int] = None, **kwargs):
        """
        :keyword scale_unit: The scale unit number of the streaming endpoint.
        :paramtype scale_unit: int
        """
        super().__init__(**kwargs)
        self.scale_unit = scale_unit


class StreamingLocator(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """A Streaming Locator resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    :ivar asset_name: Asset Name.
    :vartype asset_name: str
    :ivar created: The creation time of the Streaming Locator.
    :vartype created: ~datetime.datetime
    :ivar start_time: The start time of the Streaming Locator.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the Streaming Locator.
    :vartype end_time: ~datetime.datetime
    :ivar streaming_locator_id: The StreamingLocatorId of the Streaming Locator.
    :vartype streaming_locator_id: str
    :ivar streaming_policy_name: Name of the Streaming Policy used by this Streaming Locator.
     Either specify the name of Streaming Policy you created or use one of the predefined Streaming
     Policies. The predefined Streaming Policies available are: 'Predefined_DownloadOnly',
     'Predefined_ClearStreamingOnly', 'Predefined_DownloadAndClearStreaming', 'Predefined_ClearKey',
     'Predefined_MultiDrmCencStreaming' and 'Predefined_MultiDrmStreaming'.
    :vartype streaming_policy_name: str
    :ivar default_content_key_policy_name: Name of the default ContentKeyPolicy used by this
     Streaming Locator.
    :vartype default_content_key_policy_name: str
    :ivar content_keys: The ContentKeys used by this Streaming Locator.
    :vartype content_keys: list[~azure.mgmt.media.models.StreamingLocatorContentKey]
    :ivar alternative_media_id: Alternative Media ID of this Streaming Locator.
    :vartype alternative_media_id: str
    :ivar filters: A list of asset or account filters which apply to this streaming locator.
    :vartype filters: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "created": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "asset_name": {"key": "properties.assetName", "type": "str"},
        "created": {"key": "properties.created", "type": "iso-8601"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "end_time": {"key": "properties.endTime", "type": "iso-8601"},
        "streaming_locator_id": {"key": "properties.streamingLocatorId", "type": "str"},
        "streaming_policy_name": {"key": "properties.streamingPolicyName", "type": "str"},
        "default_content_key_policy_name": {"key": "properties.defaultContentKeyPolicyName", "type": "str"},
        "content_keys": {"key": "properties.contentKeys", "type": "[StreamingLocatorContentKey]"},
        "alternative_media_id": {"key": "properties.alternativeMediaId", "type": "str"},
        "filters": {"key": "properties.filters", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        asset_name: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        streaming_locator_id: Optional[str] = None,
        streaming_policy_name: Optional[str] = None,
        default_content_key_policy_name: Optional[str] = None,
        content_keys: Optional[List["_models.StreamingLocatorContentKey"]] = None,
        alternative_media_id: Optional[str] = None,
        filters: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword asset_name: Asset Name.
        :paramtype asset_name: str
        :keyword start_time: The start time of the Streaming Locator.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the Streaming Locator.
        :paramtype end_time: ~datetime.datetime
        :keyword streaming_locator_id: The StreamingLocatorId of the Streaming Locator.
        :paramtype streaming_locator_id: str
        :keyword streaming_policy_name: Name of the Streaming Policy used by this Streaming Locator.
         Either specify the name of Streaming Policy you created or use one of the predefined Streaming
         Policies. The predefined Streaming Policies available are: 'Predefined_DownloadOnly',
         'Predefined_ClearStreamingOnly', 'Predefined_DownloadAndClearStreaming', 'Predefined_ClearKey',
         'Predefined_MultiDrmCencStreaming' and 'Predefined_MultiDrmStreaming'.
        :paramtype streaming_policy_name: str
        :keyword default_content_key_policy_name: Name of the default ContentKeyPolicy used by this
         Streaming Locator.
        :paramtype default_content_key_policy_name: str
        :keyword content_keys: The ContentKeys used by this Streaming Locator.
        :paramtype content_keys: list[~azure.mgmt.media.models.StreamingLocatorContentKey]
        :keyword alternative_media_id: Alternative Media ID of this Streaming Locator.
        :paramtype alternative_media_id: str
        :keyword filters: A list of asset or account filters which apply to this streaming locator.
        :paramtype filters: list[str]
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.asset_name = asset_name
        self.created = None
        self.start_time = start_time
        self.end_time = end_time
        self.streaming_locator_id = streaming_locator_id
        self.streaming_policy_name = streaming_policy_name
        self.default_content_key_policy_name = default_content_key_policy_name
        self.content_keys = content_keys
        self.alternative_media_id = alternative_media_id
        self.filters = filters


class StreamingLocatorCollection(_serialization.Model):
    """A collection of StreamingLocator items.

    :ivar value: A collection of StreamingLocator items.
    :vartype value: list[~azure.mgmt.media.models.StreamingLocator]
    :ivar odata_next_link: A link to the next page of the collection (when the collection contains
     too many results to return in one response).
    :vartype odata_next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[StreamingLocator]"},
        "odata_next_link": {"key": "@odata\\.nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.StreamingLocator"]] = None,
        odata_next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A collection of StreamingLocator items.
        :paramtype value: list[~azure.mgmt.media.models.StreamingLocator]
        :keyword odata_next_link: A link to the next page of the collection (when the collection
         contains too many results to return in one response).
        :paramtype odata_next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.odata_next_link = odata_next_link


class StreamingLocatorContentKey(_serialization.Model):
    """Class for content key in Streaming Locator.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: ID of Content Key. Required.
    :vartype id: str
    :ivar type: Encryption type of Content Key. Known values are: "CommonEncryptionCenc",
     "CommonEncryptionCbcs", and "EnvelopeEncryption".
    :vartype type: str or ~azure.mgmt.media.models.StreamingLocatorContentKeyType
    :ivar label_reference_in_streaming_policy: Label of Content Key as specified in the Streaming
     Policy.
    :vartype label_reference_in_streaming_policy: str
    :ivar value: Value of Content Key.
    :vartype value: str
    :ivar policy_name: ContentKeyPolicy used by Content Key.
    :vartype policy_name: str
    :ivar tracks: Tracks which use this Content Key.
    :vartype tracks: list[~azure.mgmt.media.models.TrackSelection]
    """

    _validation = {
        "id": {"required": True},
        "type": {"readonly": True},
        "policy_name": {"readonly": True},
        "tracks": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "label_reference_in_streaming_policy": {"key": "labelReferenceInStreamingPolicy", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "policy_name": {"key": "policyName", "type": "str"},
        "tracks": {"key": "tracks", "type": "[TrackSelection]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        label_reference_in_streaming_policy: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: ID of Content Key. Required.
        :paramtype id: str
        :keyword label_reference_in_streaming_policy: Label of Content Key as specified in the
         Streaming Policy.
        :paramtype label_reference_in_streaming_policy: str
        :keyword value: Value of Content Key.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.type = None
        self.label_reference_in_streaming_policy = label_reference_in_streaming_policy
        self.value = value
        self.policy_name = None
        self.tracks = None


class StreamingPath(_serialization.Model):
    """Class of paths for streaming.

    All required parameters must be populated in order to send to Azure.

    :ivar streaming_protocol: Streaming protocol. Required. Known values are: "Hls", "Dash",
     "SmoothStreaming", and "Download".
    :vartype streaming_protocol: str or ~azure.mgmt.media.models.StreamingPolicyStreamingProtocol
    :ivar encryption_scheme: Encryption scheme. Required. Known values are: "NoEncryption",
     "EnvelopeEncryption", "CommonEncryptionCenc", and "CommonEncryptionCbcs".
    :vartype encryption_scheme: str or ~azure.mgmt.media.models.EncryptionScheme
    :ivar paths: Streaming paths for each protocol and encryptionScheme pair.
    :vartype paths: list[str]
    """

    _validation = {
        "streaming_protocol": {"required": True},
        "encryption_scheme": {"required": True},
    }

    _attribute_map = {
        "streaming_protocol": {"key": "streamingProtocol", "type": "str"},
        "encryption_scheme": {"key": "encryptionScheme", "type": "str"},
        "paths": {"key": "paths", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        streaming_protocol: Union[str, "_models.StreamingPolicyStreamingProtocol"],
        encryption_scheme: Union[str, "_models.EncryptionScheme"],
        paths: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword streaming_protocol: Streaming protocol. Required. Known values are: "Hls", "Dash",
         "SmoothStreaming", and "Download".
        :paramtype streaming_protocol: str or ~azure.mgmt.media.models.StreamingPolicyStreamingProtocol
        :keyword encryption_scheme: Encryption scheme. Required. Known values are: "NoEncryption",
         "EnvelopeEncryption", "CommonEncryptionCenc", and "CommonEncryptionCbcs".
        :paramtype encryption_scheme: str or ~azure.mgmt.media.models.EncryptionScheme
        :keyword paths: Streaming paths for each protocol and encryptionScheme pair.
        :paramtype paths: list[str]
        """
        super().__init__(**kwargs)
        self.streaming_protocol = streaming_protocol
        self.encryption_scheme = encryption_scheme
        self.paths = paths


class StreamingPolicy(ProxyResource):
    """A Streaming Policy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    :ivar created: Creation time of Streaming Policy.
    :vartype created: ~datetime.datetime
    :ivar default_content_key_policy_name: Default ContentKey used by current Streaming Policy.
    :vartype default_content_key_policy_name: str
    :ivar envelope_encryption: Configuration of EnvelopeEncryption.
    :vartype envelope_encryption: ~azure.mgmt.media.models.EnvelopeEncryption
    :ivar common_encryption_cenc: Configuration of CommonEncryptionCenc.
    :vartype common_encryption_cenc: ~azure.mgmt.media.models.CommonEncryptionCenc
    :ivar common_encryption_cbcs: Configuration of CommonEncryptionCbcs.
    :vartype common_encryption_cbcs: ~azure.mgmt.media.models.CommonEncryptionCbcs
    :ivar no_encryption: Configurations of NoEncryption.
    :vartype no_encryption: ~azure.mgmt.media.models.NoEncryption
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "created": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "created": {"key": "properties.created", "type": "iso-8601"},
        "default_content_key_policy_name": {"key": "properties.defaultContentKeyPolicyName", "type": "str"},
        "envelope_encryption": {"key": "properties.envelopeEncryption", "type": "EnvelopeEncryption"},
        "common_encryption_cenc": {"key": "properties.commonEncryptionCenc", "type": "CommonEncryptionCenc"},
        "common_encryption_cbcs": {"key": "properties.commonEncryptionCbcs", "type": "CommonEncryptionCbcs"},
        "no_encryption": {"key": "properties.noEncryption", "type": "NoEncryption"},
    }

    def __init__(
        self,
        *,
        default_content_key_policy_name: Optional[str] = None,
        envelope_encryption: Optional["_models.EnvelopeEncryption"] = None,
        common_encryption_cenc: Optional["_models.CommonEncryptionCenc"] = None,
        common_encryption_cbcs: Optional["_models.CommonEncryptionCbcs"] = None,
        no_encryption: Optional["_models.NoEncryption"] = None,
        **kwargs
    ):
        """
        :keyword default_content_key_policy_name: Default ContentKey used by current Streaming Policy.
        :paramtype default_content_key_policy_name: str
        :keyword envelope_encryption: Configuration of EnvelopeEncryption.
        :paramtype envelope_encryption: ~azure.mgmt.media.models.EnvelopeEncryption
        :keyword common_encryption_cenc: Configuration of CommonEncryptionCenc.
        :paramtype common_encryption_cenc: ~azure.mgmt.media.models.CommonEncryptionCenc
        :keyword common_encryption_cbcs: Configuration of CommonEncryptionCbcs.
        :paramtype common_encryption_cbcs: ~azure.mgmt.media.models.CommonEncryptionCbcs
        :keyword no_encryption: Configurations of NoEncryption.
        :paramtype no_encryption: ~azure.mgmt.media.models.NoEncryption
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.created = None
        self.default_content_key_policy_name = default_content_key_policy_name
        self.envelope_encryption = envelope_encryption
        self.common_encryption_cenc = common_encryption_cenc
        self.common_encryption_cbcs = common_encryption_cbcs
        self.no_encryption = no_encryption


class StreamingPolicyCollection(_serialization.Model):
    """A collection of StreamingPolicy items.

    :ivar value: A collection of StreamingPolicy items.
    :vartype value: list[~azure.mgmt.media.models.StreamingPolicy]
    :ivar odata_next_link: A link to the next page of the collection (when the collection contains
     too many results to return in one response).
    :vartype odata_next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[StreamingPolicy]"},
        "odata_next_link": {"key": "@odata\\.nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.StreamingPolicy"]] = None,
        odata_next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: A collection of StreamingPolicy items.
        :paramtype value: list[~azure.mgmt.media.models.StreamingPolicy]
        :keyword odata_next_link: A link to the next page of the collection (when the collection
         contains too many results to return in one response).
        :paramtype odata_next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.odata_next_link = odata_next_link


class StreamingPolicyContentKey(_serialization.Model):
    """Class to specify properties of content key.

    :ivar label: Label can be used to specify Content Key when creating a Streaming Locator.
    :vartype label: str
    :ivar policy_name: Policy used by Content Key.
    :vartype policy_name: str
    :ivar tracks: Tracks which use this content key.
    :vartype tracks: list[~azure.mgmt.media.models.TrackSelection]
    """

    _attribute_map = {
        "label": {"key": "label", "type": "str"},
        "policy_name": {"key": "policyName", "type": "str"},
        "tracks": {"key": "tracks", "type": "[TrackSelection]"},
    }

    def __init__(
        self,
        *,
        label: Optional[str] = None,
        policy_name: Optional[str] = None,
        tracks: Optional[List["_models.TrackSelection"]] = None,
        **kwargs
    ):
        """
        :keyword label: Label can be used to specify Content Key when creating a Streaming Locator.
        :paramtype label: str
        :keyword policy_name: Policy used by Content Key.
        :paramtype policy_name: str
        :keyword tracks: Tracks which use this content key.
        :paramtype tracks: list[~azure.mgmt.media.models.TrackSelection]
        """
        super().__init__(**kwargs)
        self.label = label
        self.policy_name = policy_name
        self.tracks = tracks


class StreamingPolicyContentKeys(_serialization.Model):
    """Class to specify properties of all content keys in Streaming Policy.

    :ivar default_key: Default content key for an encryption scheme.
    :vartype default_key: ~azure.mgmt.media.models.DefaultKey
    :ivar key_to_track_mappings: Representing tracks needs separate content key.
    :vartype key_to_track_mappings: list[~azure.mgmt.media.models.StreamingPolicyContentKey]
    """

    _attribute_map = {
        "default_key": {"key": "defaultKey", "type": "DefaultKey"},
        "key_to_track_mappings": {"key": "keyToTrackMappings", "type": "[StreamingPolicyContentKey]"},
    }

    def __init__(
        self,
        *,
        default_key: Optional["_models.DefaultKey"] = None,
        key_to_track_mappings: Optional[List["_models.StreamingPolicyContentKey"]] = None,
        **kwargs
    ):
        """
        :keyword default_key: Default content key for an encryption scheme.
        :paramtype default_key: ~azure.mgmt.media.models.DefaultKey
        :keyword key_to_track_mappings: Representing tracks needs separate content key.
        :paramtype key_to_track_mappings: list[~azure.mgmt.media.models.StreamingPolicyContentKey]
        """
        super().__init__(**kwargs)
        self.default_key = default_key
        self.key_to_track_mappings = key_to_track_mappings


class StreamingPolicyFairPlayConfiguration(_serialization.Model):
    """Class to specify configurations of FairPlay in Streaming Policy.

    All required parameters must be populated in order to send to Azure.

    :ivar custom_license_acquisition_url_template: Template for the URL of the custom service
     delivering licenses to end user players.  Not required when using Azure Media Services for
     issuing licenses.  The template supports replaceable tokens that the service will update at
     runtime with the value specific to the request.  The currently supported token values are
     {AlternativeMediaId}, which is replaced with the value of
     StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of
     identifier of the key being requested.
    :vartype custom_license_acquisition_url_template: str
    :ivar allow_persistent_license: All license to be persistent or not. Required.
    :vartype allow_persistent_license: bool
    """

    _validation = {
        "allow_persistent_license": {"required": True},
    }

    _attribute_map = {
        "custom_license_acquisition_url_template": {"key": "customLicenseAcquisitionUrlTemplate", "type": "str"},
        "allow_persistent_license": {"key": "allowPersistentLicense", "type": "bool"},
    }

    def __init__(
        self, *, allow_persistent_license: bool, custom_license_acquisition_url_template: Optional[str] = None, **kwargs
    ):
        """
        :keyword custom_license_acquisition_url_template: Template for the URL of the custom service
         delivering licenses to end user players.  Not required when using Azure Media Services for
         issuing licenses.  The template supports replaceable tokens that the service will update at
         runtime with the value specific to the request.  The currently supported token values are
         {AlternativeMediaId}, which is replaced with the value of
         StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of
         identifier of the key being requested.
        :paramtype custom_license_acquisition_url_template: str
        :keyword allow_persistent_license: All license to be persistent or not. Required.
        :paramtype allow_persistent_license: bool
        """
        super().__init__(**kwargs)
        self.custom_license_acquisition_url_template = custom_license_acquisition_url_template
        self.allow_persistent_license = allow_persistent_license


class StreamingPolicyPlayReadyConfiguration(_serialization.Model):
    """Class to specify configurations of PlayReady in Streaming Policy.

    :ivar custom_license_acquisition_url_template: Template for the URL of the custom service
     delivering licenses to end user players.  Not required when using Azure Media Services for
     issuing licenses.  The template supports replaceable tokens that the service will update at
     runtime with the value specific to the request.  The currently supported token values are
     {AlternativeMediaId}, which is replaced with the value of
     StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of
     identifier of the key being requested.
    :vartype custom_license_acquisition_url_template: str
    :ivar play_ready_custom_attributes: Custom attributes for PlayReady.
    :vartype play_ready_custom_attributes: str
    """

    _attribute_map = {
        "custom_license_acquisition_url_template": {"key": "customLicenseAcquisitionUrlTemplate", "type": "str"},
        "play_ready_custom_attributes": {"key": "playReadyCustomAttributes", "type": "str"},
    }

    def __init__(
        self,
        *,
        custom_license_acquisition_url_template: Optional[str] = None,
        play_ready_custom_attributes: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword custom_license_acquisition_url_template: Template for the URL of the custom service
         delivering licenses to end user players.  Not required when using Azure Media Services for
         issuing licenses.  The template supports replaceable tokens that the service will update at
         runtime with the value specific to the request.  The currently supported token values are
         {AlternativeMediaId}, which is replaced with the value of
         StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of
         identifier of the key being requested.
        :paramtype custom_license_acquisition_url_template: str
        :keyword play_ready_custom_attributes: Custom attributes for PlayReady.
        :paramtype play_ready_custom_attributes: str
        """
        super().__init__(**kwargs)
        self.custom_license_acquisition_url_template = custom_license_acquisition_url_template
        self.play_ready_custom_attributes = play_ready_custom_attributes


class StreamingPolicyWidevineConfiguration(_serialization.Model):
    """Class to specify configurations of Widevine in Streaming Policy.

    :ivar custom_license_acquisition_url_template: Template for the URL of the custom service
     delivering licenses to end user players.  Not required when using Azure Media Services for
     issuing licenses.  The template supports replaceable tokens that the service will update at
     runtime with the value specific to the request.  The currently supported token values are
     {AlternativeMediaId}, which is replaced with the value of
     StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of
     identifier of the key being requested.
    :vartype custom_license_acquisition_url_template: str
    """

    _attribute_map = {
        "custom_license_acquisition_url_template": {"key": "customLicenseAcquisitionUrlTemplate", "type": "str"},
    }

    def __init__(self, *, custom_license_acquisition_url_template: Optional[str] = None, **kwargs):
        """
        :keyword custom_license_acquisition_url_template: Template for the URL of the custom service
         delivering licenses to end user players.  Not required when using Azure Media Services for
         issuing licenses.  The template supports replaceable tokens that the service will update at
         runtime with the value specific to the request.  The currently supported token values are
         {AlternativeMediaId}, which is replaced with the value of
         StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of
         identifier of the key being requested.
        :paramtype custom_license_acquisition_url_template: str
        """
        super().__init__(**kwargs)
        self.custom_license_acquisition_url_template = custom_license_acquisition_url_template


class SyncStorageKeysInput(_serialization.Model):
    """The input to the sync storage keys request.

    :ivar id: The ID of the storage account resource.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: The ID of the storage account resource.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.media.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.media.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.media.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.media.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TextTrack(TrackBase):
    """Represents a text track in an asset. A text track is usually used for sparse data related to the audio or video tracks.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar file_name: The file name to the source file. This file is located in the storage
     container of the asset.
    :vartype file_name: str
    :ivar display_name: The display name of the text track on a video player. In HLS, this maps to
     the NAME attribute of EXT-X-MEDIA.
    :vartype display_name: str
    :ivar language_code: The RFC5646 language code for the text track.
    :vartype language_code: str
    :ivar player_visibility: When PlayerVisibility is set to "Visible", the text track will be
     present in the DASH manifest or HLS playlist when requested by a client. When the
     PlayerVisibility is set to "Hidden", the text will not be available to the client. The default
     value is "Visible". Known values are: "Hidden" and "Visible".
    :vartype player_visibility: str or ~azure.mgmt.media.models.Visibility
    :ivar hls_settings: The HLS specific setting for the text track.
    :vartype hls_settings: ~azure.mgmt.media.models.HlsSettings
    """

    _validation = {
        "odata_type": {"required": True},
        "language_code": {"readonly": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "language_code": {"key": "languageCode", "type": "str"},
        "player_visibility": {"key": "playerVisibility", "type": "str"},
        "hls_settings": {"key": "hlsSettings", "type": "HlsSettings"},
    }

    def __init__(
        self,
        *,
        file_name: Optional[str] = None,
        display_name: Optional[str] = None,
        player_visibility: Optional[Union[str, "_models.Visibility"]] = None,
        hls_settings: Optional["_models.HlsSettings"] = None,
        **kwargs
    ):
        """
        :keyword file_name: The file name to the source file. This file is located in the storage
         container of the asset.
        :paramtype file_name: str
        :keyword display_name: The display name of the text track on a video player. In HLS, this maps
         to the NAME attribute of EXT-X-MEDIA.
        :paramtype display_name: str
        :keyword player_visibility: When PlayerVisibility is set to "Visible", the text track will be
         present in the DASH manifest or HLS playlist when requested by a client. When the
         PlayerVisibility is set to "Hidden", the text will not be available to the client. The default
         value is "Visible". Known values are: "Hidden" and "Visible".
        :paramtype player_visibility: str or ~azure.mgmt.media.models.Visibility
        :keyword hls_settings: The HLS specific setting for the text track.
        :paramtype hls_settings: ~azure.mgmt.media.models.HlsSettings
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.TextTrack"  # type: str
        self.file_name = file_name
        self.display_name = display_name
        self.language_code = None
        self.player_visibility = player_visibility
        self.hls_settings = hls_settings


class TrackPropertyCondition(_serialization.Model):
    """Class to specify one track property condition.

    All required parameters must be populated in order to send to Azure.

    :ivar property: Track property type. Required. Known values are: "Unknown" and "FourCC".
    :vartype property: str or ~azure.mgmt.media.models.TrackPropertyType
    :ivar operation: Track property condition operation. Required. Known values are: "Unknown" and
     "Equal".
    :vartype operation: str or ~azure.mgmt.media.models.TrackPropertyCompareOperation
    :ivar value: Track property value.
    :vartype value: str
    """

    _validation = {
        "property": {"required": True},
        "operation": {"required": True},
    }

    _attribute_map = {
        "property": {"key": "property", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self,
        *,
        property: Union[str, "_models.TrackPropertyType"],
        operation: Union[str, "_models.TrackPropertyCompareOperation"],
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword property: Track property type. Required. Known values are: "Unknown" and "FourCC".
        :paramtype property: str or ~azure.mgmt.media.models.TrackPropertyType
        :keyword operation: Track property condition operation. Required. Known values are: "Unknown"
         and "Equal".
        :paramtype operation: str or ~azure.mgmt.media.models.TrackPropertyCompareOperation
        :keyword value: Track property value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.property = property
        self.operation = operation
        self.value = value


class TrackSelection(_serialization.Model):
    """Class to select a track.

    :ivar track_selections: TrackSelections is a track property condition list which can specify
     track(s).
    :vartype track_selections: list[~azure.mgmt.media.models.TrackPropertyCondition]
    """

    _attribute_map = {
        "track_selections": {"key": "trackSelections", "type": "[TrackPropertyCondition]"},
    }

    def __init__(self, *, track_selections: Optional[List["_models.TrackPropertyCondition"]] = None, **kwargs):
        """
        :keyword track_selections: TrackSelections is a track property condition list which can specify
         track(s).
        :paramtype track_selections: list[~azure.mgmt.media.models.TrackPropertyCondition]
        """
        super().__init__(**kwargs)
        self.track_selections = track_selections


class Transform(ProxyResource):
    """A Transform encapsulates the rules or instructions for generating desired outputs from input media, such as by transcoding or by extracting insights. After the Transform is created, it can be applied to input media by creating Jobs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata relating to this resource.
    :vartype system_data: ~azure.mgmt.media.models.SystemData
    :ivar created: The UTC date and time when the Transform was created, in 'YYYY-MM-DDThh:mm:ssZ'
     format.
    :vartype created: ~datetime.datetime
    :ivar description: An optional verbose description of the Transform.
    :vartype description: str
    :ivar last_modified: The UTC date and time when the Transform was last updated, in
     'YYYY-MM-DDThh:mm:ssZ' format.
    :vartype last_modified: ~datetime.datetime
    :ivar outputs: An array of one or more TransformOutputs that the Transform should generate.
    :vartype outputs: list[~azure.mgmt.media.models.TransformOutput]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "created": {"readonly": True},
        "last_modified": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "created": {"key": "properties.created", "type": "iso-8601"},
        "description": {"key": "properties.description", "type": "str"},
        "last_modified": {"key": "properties.lastModified", "type": "iso-8601"},
        "outputs": {"key": "properties.outputs", "type": "[TransformOutput]"},
    }

    def __init__(
        self, *, description: Optional[str] = None, outputs: Optional[List["_models.TransformOutput"]] = None, **kwargs
    ):
        """
        :keyword description: An optional verbose description of the Transform.
        :paramtype description: str
        :keyword outputs: An array of one or more TransformOutputs that the Transform should generate.
        :paramtype outputs: list[~azure.mgmt.media.models.TransformOutput]
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.created = None
        self.description = description
        self.last_modified = None
        self.outputs = outputs


class TransformCollection(_serialization.Model):
    """A collection of Transform items.

    :ivar value: A collection of Transform items.
    :vartype value: list[~azure.mgmt.media.models.Transform]
    :ivar odata_next_link: A link to the next page of the collection (when the collection contains
     too many results to return in one response).
    :vartype odata_next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Transform]"},
        "odata_next_link": {"key": "@odata\\.nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Transform"]] = None, odata_next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A collection of Transform items.
        :paramtype value: list[~azure.mgmt.media.models.Transform]
        :keyword odata_next_link: A link to the next page of the collection (when the collection
         contains too many results to return in one response).
        :paramtype odata_next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.odata_next_link = odata_next_link


class TransformOutput(_serialization.Model):
    """Describes the properties of a TransformOutput, which are the rules to be applied while generating the desired output.

    All required parameters must be populated in order to send to Azure.

    :ivar on_error: A Transform can define more than one outputs. This property defines what the
     service should do when one output fails - either continue to produce other outputs, or, stop
     the other outputs. The overall Job state will not reflect failures of outputs that are
     specified with 'ContinueJob'. The default is 'StopProcessingJob'. Known values are:
     "StopProcessingJob" and "ContinueJob".
    :vartype on_error: str or ~azure.mgmt.media.models.OnErrorType
    :ivar relative_priority: Sets the relative priority of the TransformOutputs within a Transform.
     This sets the priority that the service uses for processing TransformOutputs. The default
     priority is Normal. Known values are: "Low", "Normal", and "High".
    :vartype relative_priority: str or ~azure.mgmt.media.models.Priority
    :ivar preset: Preset that describes the operations that will be used to modify, transcode, or
     extract insights from the source file to generate the output. Required.
    :vartype preset: ~azure.mgmt.media.models.Preset
    """

    _validation = {
        "preset": {"required": True},
    }

    _attribute_map = {
        "on_error": {"key": "onError", "type": "str"},
        "relative_priority": {"key": "relativePriority", "type": "str"},
        "preset": {"key": "preset", "type": "Preset"},
    }

    def __init__(
        self,
        *,
        preset: "_models.Preset",
        on_error: Optional[Union[str, "_models.OnErrorType"]] = None,
        relative_priority: Optional[Union[str, "_models.Priority"]] = None,
        **kwargs
    ):
        """
        :keyword on_error: A Transform can define more than one outputs. This property defines what the
         service should do when one output fails - either continue to produce other outputs, or, stop
         the other outputs. The overall Job state will not reflect failures of outputs that are
         specified with 'ContinueJob'. The default is 'StopProcessingJob'. Known values are:
         "StopProcessingJob" and "ContinueJob".
        :paramtype on_error: str or ~azure.mgmt.media.models.OnErrorType
        :keyword relative_priority: Sets the relative priority of the TransformOutputs within a
         Transform. This sets the priority that the service uses for processing TransformOutputs. The
         default priority is Normal. Known values are: "Low", "Normal", and "High".
        :paramtype relative_priority: str or ~azure.mgmt.media.models.Priority
        :keyword preset: Preset that describes the operations that will be used to modify, transcode,
         or extract insights from the source file to generate the output. Required.
        :paramtype preset: ~azure.mgmt.media.models.Preset
        """
        super().__init__(**kwargs)
        self.on_error = on_error
        self.relative_priority = relative_priority
        self.preset = preset


class TransportStreamFormat(MultiBitrateFormat):
    """Describes the properties for generating an MPEG-2 Transport Stream (ISO/IEC 13818-1) output video file(s).

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar filename_pattern: The pattern of the file names for the generated output files. The
     following macros are supported in the file name: {Basename} - An expansion macro that will use
     the name of the input video file. If the base name(the file suffix is not included) of the
     input video file is less than 32 characters long, the base name of input video files will be
     used. If the length of base name of the input video file exceeds 32 characters, the base name
     is truncated to the first 32 characters in total length. {Extension} - The appropriate
     extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique
     index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not
     applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video
     resolution. Any unsubstituted macros will be collapsed and removed from the filename. Required.
    :vartype filename_pattern: str
    :ivar output_files: The list of output files to produce.  Each entry in the list is a set of
     audio and video layer labels to be muxed together .
    :vartype output_files: list[~azure.mgmt.media.models.OutputFile]
    """

    _validation = {
        "odata_type": {"required": True},
        "filename_pattern": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "filename_pattern": {"key": "filenamePattern", "type": "str"},
        "output_files": {"key": "outputFiles", "type": "[OutputFile]"},
    }

    def __init__(self, *, filename_pattern: str, output_files: Optional[List["_models.OutputFile"]] = None, **kwargs):
        """
        :keyword filename_pattern: The pattern of the file names for the generated output files. The
         following macros are supported in the file name: {Basename} - An expansion macro that will use
         the name of the input video file. If the base name(the file suffix is not included) of the
         input video file is less than 32 characters long, the base name of input video files will be
         used. If the length of base name of the input video file exceeds 32 characters, the base name
         is truncated to the first 32 characters in total length. {Extension} - The appropriate
         extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique
         index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not
         applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video
         resolution. Any unsubstituted macros will be collapsed and removed from the filename. Required.
        :paramtype filename_pattern: str
        :keyword output_files: The list of output files to produce.  Each entry in the list is a set of
         audio and video layer labels to be muxed together .
        :paramtype output_files: list[~azure.mgmt.media.models.OutputFile]
        """
        super().__init__(filename_pattern=filename_pattern, output_files=output_files, **kwargs)
        self.odata_type = "#Microsoft.Media.TransportStreamFormat"  # type: str


class UserAssignedManagedIdentity(_serialization.Model):
    """UserAssignedManagedIdentity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar client_id: The client ID.
    :vartype client_id: str
    :ivar principal_id: The principal ID.
    :vartype principal_id: str
    """

    _validation = {
        "client_id": {"readonly": True},
        "principal_id": {"readonly": True},
    }

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.client_id = None
        self.principal_id = None


class UtcClipTime(ClipTime):
    """Specifies the clip time as a Utc time position in the media file.  The Utc time can point to a different position depending on whether the media file starts from a timestamp of zero or not.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar time: The time position on the timeline of the input media based on Utc time. Required.
    :vartype time: ~datetime.datetime
    """

    _validation = {
        "odata_type": {"required": True},
        "time": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "time": {"key": "time", "type": "iso-8601"},
    }

    def __init__(self, *, time: datetime.datetime, **kwargs):
        """
        :keyword time: The time position on the timeline of the input media based on Utc time.
         Required.
        :paramtype time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.UtcClipTime"  # type: str
        self.time = time


class VideoAnalyzerPreset(AudioAnalyzerPreset):
    """A video analyzer preset that extracts insights (rich metadata) from both audio and video, and outputs a JSON format file.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar audio_language: The language for the audio payload in the input using the BCP-47 format
     of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is
     recommended that you specify it. The language must be specified explicitly for
     AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If
     the language isn't specified or set to null, automatic language detection will choose the first
     language detected and process with the selected language for the duration of the file. It does
     not currently support dynamically switching between languages after the first language is
     detected. The automatic detection works best with audio recordings with clearly discernable
     speech. If automatic detection fails to find the language, transcription would fallback to
     'en-US'." The list of supported languages is available here:
     https://go.microsoft.com/fwlink/?linkid=2109463.
    :vartype audio_language: str
    :ivar mode: Determines the set of audio analysis operations to be performed. If unspecified,
     the Standard AudioAnalysisMode would be chosen. Known values are: "Standard" and "Basic".
    :vartype mode: str or ~azure.mgmt.media.models.AudioAnalysisMode
    :ivar experimental_options: Dictionary containing key value pairs for parameters not exposed in
     the preset itself.
    :vartype experimental_options: dict[str, str]
    :ivar insights_to_extract: Defines the type of insights that you want the service to generate.
     The allowed values are 'AudioInsightsOnly', 'VideoInsightsOnly', and 'AllInsights'. The default
     is AllInsights. If you set this to AllInsights and the input is audio only, then only audio
     insights are generated. Similarly if the input is video only, then only video insights are
     generated. It is recommended that you not use AudioInsightsOnly if you expect some of your
     inputs to be video only; or use VideoInsightsOnly if you expect some of your inputs to be audio
     only. Your Jobs in such conditions would error out. Known values are: "AudioInsightsOnly",
     "VideoInsightsOnly", and "AllInsights".
    :vartype insights_to_extract: str or ~azure.mgmt.media.models.InsightsType
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "audio_language": {"key": "audioLanguage", "type": "str"},
        "mode": {"key": "mode", "type": "str"},
        "experimental_options": {"key": "experimentalOptions", "type": "{str}"},
        "insights_to_extract": {"key": "insightsToExtract", "type": "str"},
    }

    def __init__(
        self,
        *,
        audio_language: Optional[str] = None,
        mode: Optional[Union[str, "_models.AudioAnalysisMode"]] = None,
        experimental_options: Optional[Dict[str, str]] = None,
        insights_to_extract: Optional[Union[str, "_models.InsightsType"]] = None,
        **kwargs
    ):
        """
        :keyword audio_language: The language for the audio payload in the input using the BCP-47
         format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it
         is recommended that you specify it. The language must be specified explicitly for
         AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If
         the language isn't specified or set to null, automatic language detection will choose the first
         language detected and process with the selected language for the duration of the file. It does
         not currently support dynamically switching between languages after the first language is
         detected. The automatic detection works best with audio recordings with clearly discernable
         speech. If automatic detection fails to find the language, transcription would fallback to
         'en-US'." The list of supported languages is available here:
         https://go.microsoft.com/fwlink/?linkid=2109463.
        :paramtype audio_language: str
        :keyword mode: Determines the set of audio analysis operations to be performed. If unspecified,
         the Standard AudioAnalysisMode would be chosen. Known values are: "Standard" and "Basic".
        :paramtype mode: str or ~azure.mgmt.media.models.AudioAnalysisMode
        :keyword experimental_options: Dictionary containing key value pairs for parameters not exposed
         in the preset itself.
        :paramtype experimental_options: dict[str, str]
        :keyword insights_to_extract: Defines the type of insights that you want the service to
         generate. The allowed values are 'AudioInsightsOnly', 'VideoInsightsOnly', and 'AllInsights'.
         The default is AllInsights. If you set this to AllInsights and the input is audio only, then
         only audio insights are generated. Similarly if the input is video only, then only video
         insights are generated. It is recommended that you not use AudioInsightsOnly if you expect some
         of your inputs to be video only; or use VideoInsightsOnly if you expect some of your inputs to
         be audio only. Your Jobs in such conditions would error out. Known values are:
         "AudioInsightsOnly", "VideoInsightsOnly", and "AllInsights".
        :paramtype insights_to_extract: str or ~azure.mgmt.media.models.InsightsType
        """
        super().__init__(audio_language=audio_language, mode=mode, experimental_options=experimental_options, **kwargs)
        self.odata_type = "#Microsoft.Media.VideoAnalyzerPreset"  # type: str
        self.insights_to_extract = insights_to_extract


class VideoOverlay(Overlay):
    """Describes the properties of a video overlay.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    :ivar input_label: The label of the job input which is to be used as an overlay. The Input must
     specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an
     audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See
     https://aka.ms/mesformats for the complete list of supported audio and video file formats.
     Required.
    :vartype input_label: str
    :ivar start: The start position, with reference to the input video, at which the overlay
     starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5
     seconds into the input video. If not specified the overlay starts from the beginning of the
     input video.
    :vartype start: ~datetime.timedelta
    :ivar end: The end position, with reference to the input video, at which the overlay ends. The
     value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into
     the input video. If not specified or the value is greater than the input video duration, the
     overlay will be applied until the end of the input video if the overlay media duration is
     greater than the input video duration, else the overlay will last as long as the overlay media
     duration.
    :vartype end: ~datetime.timedelta
    :ivar fade_in_duration: The duration over which the overlay fades in onto the input video. The
     value should be in ISO 8601 duration format. If not specified the default behavior is to have
     no fade in (same as PT0S).
    :vartype fade_in_duration: ~datetime.timedelta
    :ivar fade_out_duration: The duration over which the overlay fades out of the input video. The
     value should be in ISO 8601 duration format. If not specified the default behavior is to have
     no fade out (same as PT0S).
    :vartype fade_out_duration: ~datetime.timedelta
    :ivar audio_gain_level: The gain level of audio in the overlay. The value should be in the
     range [0, 1.0]. The default is 1.0.
    :vartype audio_gain_level: float
    :ivar position: The location in the input video where the overlay is applied.
    :vartype position: ~azure.mgmt.media.models.Rectangle
    :ivar opacity: The opacity of the overlay. This is a value in the range [0 - 1.0]. Default is
     1.0 which mean the overlay is opaque.
    :vartype opacity: float
    :ivar crop_rectangle: An optional rectangular window used to crop the overlay image or video.
    :vartype crop_rectangle: ~azure.mgmt.media.models.Rectangle
    """

    _validation = {
        "odata_type": {"required": True},
        "input_label": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
        "input_label": {"key": "inputLabel", "type": "str"},
        "start": {"key": "start", "type": "duration"},
        "end": {"key": "end", "type": "duration"},
        "fade_in_duration": {"key": "fadeInDuration", "type": "duration"},
        "fade_out_duration": {"key": "fadeOutDuration", "type": "duration"},
        "audio_gain_level": {"key": "audioGainLevel", "type": "float"},
        "position": {"key": "position", "type": "Rectangle"},
        "opacity": {"key": "opacity", "type": "float"},
        "crop_rectangle": {"key": "cropRectangle", "type": "Rectangle"},
    }

    def __init__(
        self,
        *,
        input_label: str,
        start: Optional[datetime.timedelta] = None,
        end: Optional[datetime.timedelta] = None,
        fade_in_duration: Optional[datetime.timedelta] = None,
        fade_out_duration: Optional[datetime.timedelta] = None,
        audio_gain_level: Optional[float] = None,
        position: Optional["_models.Rectangle"] = None,
        opacity: Optional[float] = None,
        crop_rectangle: Optional["_models.Rectangle"] = None,
        **kwargs
    ):
        """
        :keyword input_label: The label of the job input which is to be used as an overlay. The Input
         must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or
         an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See
         https://aka.ms/mesformats for the complete list of supported audio and video file formats.
         Required.
        :paramtype input_label: str
        :keyword start: The start position, with reference to the input video, at which the overlay
         starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5
         seconds into the input video. If not specified the overlay starts from the beginning of the
         input video.
        :paramtype start: ~datetime.timedelta
        :keyword end: The end position, with reference to the input video, at which the overlay ends.
         The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds
         into the input video. If not specified or the value is greater than the input video duration,
         the overlay will be applied until the end of the input video if the overlay media duration is
         greater than the input video duration, else the overlay will last as long as the overlay media
         duration.
        :paramtype end: ~datetime.timedelta
        :keyword fade_in_duration: The duration over which the overlay fades in onto the input video.
         The value should be in ISO 8601 duration format. If not specified the default behavior is to
         have no fade in (same as PT0S).
        :paramtype fade_in_duration: ~datetime.timedelta
        :keyword fade_out_duration: The duration over which the overlay fades out of the input video.
         The value should be in ISO 8601 duration format. If not specified the default behavior is to
         have no fade out (same as PT0S).
        :paramtype fade_out_duration: ~datetime.timedelta
        :keyword audio_gain_level: The gain level of audio in the overlay. The value should be in the
         range [0, 1.0]. The default is 1.0.
        :paramtype audio_gain_level: float
        :keyword position: The location in the input video where the overlay is applied.
        :paramtype position: ~azure.mgmt.media.models.Rectangle
        :keyword opacity: The opacity of the overlay. This is a value in the range [0 - 1.0]. Default
         is 1.0 which mean the overlay is opaque.
        :paramtype opacity: float
        :keyword crop_rectangle: An optional rectangular window used to crop the overlay image or
         video.
        :paramtype crop_rectangle: ~azure.mgmt.media.models.Rectangle
        """
        super().__init__(
            input_label=input_label,
            start=start,
            end=end,
            fade_in_duration=fade_in_duration,
            fade_out_duration=fade_out_duration,
            audio_gain_level=audio_gain_level,
            **kwargs
        )
        self.odata_type = "#Microsoft.Media.VideoOverlay"  # type: str
        self.position = position
        self.opacity = opacity
        self.crop_rectangle = crop_rectangle


class VideoTrack(TrackBase):
    """Represents a video track in the asset.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: The discriminator for derived types. Required.
    :vartype odata_type: str
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "odata_type": {"key": "@odata\\.type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.odata_type = "#Microsoft.Media.VideoTrack"  # type: str
