# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    import __init__ as _models


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        """
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class Appliance(TrackedResource):
    """Appliances definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.resourceconnector.models.Identity
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.resourceconnector.models.SystemData
    :ivar distro: Represents a supported Fabric/Infra. (AKSEdge etc...). Known values are:
     "AKSEdge". Default value: "AKSEdge".
    :vartype distro: str or ~azure.mgmt.resourceconnector.models.Distro
    :ivar infrastructure_config: Contains infrastructure information about the Appliance.
    :vartype infrastructure_config:
     ~azure.mgmt.resourceconnector.models.AppliancePropertiesInfrastructureConfig
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar public_key: Certificates pair used to download MSI certificate from HIS.
    :vartype public_key: str
    :ivar status: Appliance’s health and state of connection to on-prem. Known values are:
     "WaitingForHeartbeat", "Validating", "Connecting", "Connected", "Running",
     "PreparingForUpgrade", "UpgradePrerequisitesCompleted", "PreUpgrade", "UpdatingCloudOperator",
     "WaitingForCloudOperator", "UpdatingCAPI", "UpdatingCluster", "PostUpgrade", "UpgradeComplete",
     "UpgradeClusterExtensionFailedToDelete", "UpgradeFailed", "Offline", "None".
    :vartype status: str or ~azure.mgmt.resourceconnector.models.Status
    :ivar version: Version of the Appliance.
    :vartype version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'distro': {'key': 'properties.distro', 'type': 'str'},
        'infrastructure_config': {'key': 'properties.infrastructureConfig', 'type': 'AppliancePropertiesInfrastructureConfig'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'public_key': {'key': 'properties.publicKey', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.Identity"] = None,
        distro: Optional[Union[str, "_models.Distro"]] = "AKSEdge",
        infrastructure_config: Optional["_models.AppliancePropertiesInfrastructureConfig"] = None,
        public_key: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword identity: Identity for the resource.
        :paramtype identity: ~azure.mgmt.resourceconnector.models.Identity
        :keyword distro: Represents a supported Fabric/Infra. (AKSEdge etc...). Known values are:
         "AKSEdge". Default value: "AKSEdge".
        :paramtype distro: str or ~azure.mgmt.resourceconnector.models.Distro
        :keyword infrastructure_config: Contains infrastructure information about the Appliance.
        :paramtype infrastructure_config:
         ~azure.mgmt.resourceconnector.models.AppliancePropertiesInfrastructureConfig
        :keyword public_key: Certificates pair used to download MSI certificate from HIS.
        :paramtype public_key: str
        :keyword version: Version of the Appliance.
        :paramtype version: str
        """
        super(Appliance, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.system_data = None
        self.distro = distro
        self.infrastructure_config = infrastructure_config
        self.provisioning_state = None
        self.public_key = public_key
        self.status = None
        self.version = version


class ApplianceCredentialKubeconfig(msrest.serialization.Model):
    """Cluster User Credential appliance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name which contains the role of the kubeconfig. Known values are: "clusterUser",
     "clusterCustomerUser".
    :vartype name: str or ~azure.mgmt.resourceconnector.models.AccessProfileType
    :ivar value: Contains the kubeconfig value.
    :vartype value: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApplianceCredentialKubeconfig, self).__init__(**kwargs)
        self.name = None
        self.value = None


class ApplianceListClusterCustomerUserCredentialResults(msrest.serialization.Model):
    """The List Cluster Customer User Credential Results appliance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kubeconfigs: The list of appliance kubeconfigs.
    :vartype kubeconfigs: list[~azure.mgmt.resourceconnector.models.ApplianceCredentialKubeconfig]
    :ivar ssh_keys: Map of Customer User Public and Private SSH Keys.
    :vartype ssh_keys: dict[str, ~azure.mgmt.resourceconnector.models.SSHKey]
    """

    _validation = {
        'kubeconfigs': {'readonly': True},
        'ssh_keys': {'readonly': True},
    }

    _attribute_map = {
        'kubeconfigs': {'key': 'kubeconfigs', 'type': '[ApplianceCredentialKubeconfig]'},
        'ssh_keys': {'key': 'sshKeys', 'type': '{SSHKey}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApplianceListClusterCustomerUserCredentialResults, self).__init__(**kwargs)
        self.kubeconfigs = None
        self.ssh_keys = None


class ApplianceListCredentialResults(msrest.serialization.Model):
    """The List Cluster User Credential appliance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hybrid_connection_config: Contains the REP (rendezvous endpoint) and “Listener” access
     token from notification service (NS).
    :vartype hybrid_connection_config: ~azure.mgmt.resourceconnector.models.HybridConnectionConfig
    :ivar kubeconfigs: The list of appliance kubeconfigs.
    :vartype kubeconfigs: list[~azure.mgmt.resourceconnector.models.ApplianceCredentialKubeconfig]
    """

    _validation = {
        'hybrid_connection_config': {'readonly': True},
        'kubeconfigs': {'readonly': True},
    }

    _attribute_map = {
        'hybrid_connection_config': {'key': 'hybridConnectionConfig', 'type': 'HybridConnectionConfig'},
        'kubeconfigs': {'key': 'kubeconfigs', 'type': '[ApplianceCredentialKubeconfig]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApplianceListCredentialResults, self).__init__(**kwargs)
        self.hybrid_connection_config = None
        self.kubeconfigs = None


class ApplianceListResult(msrest.serialization.Model):
    """The List Appliances operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    :ivar value: The list of Appliances.
    :vartype value: list[~azure.mgmt.resourceconnector.models.Appliance]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Appliance]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApplianceListResult, self).__init__(**kwargs)
        self.next_link = None
        self.value = None


class ApplianceOperation(msrest.serialization.Model):
    """Appliances operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_data_action: Is this Operation a data plane operation.
    :vartype is_data_action: bool
    :ivar name: The name of the compute operation.
    :vartype name: str
    :ivar origin: The origin of the compute operation.
    :vartype origin: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    """

    _validation = {
        'is_data_action': {'readonly': True},
        'name': {'readonly': True},
        'origin': {'readonly': True},
        'description': {'readonly': True},
        'operation': {'readonly': True},
        'provider': {'readonly': True},
        'resource': {'readonly': True},
    }

    _attribute_map = {
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'origin': {'key': 'origin', 'type': 'str'},
        'description': {'key': 'display.description', 'type': 'str'},
        'operation': {'key': 'display.operation', 'type': 'str'},
        'provider': {'key': 'display.provider', 'type': 'str'},
        'resource': {'key': 'display.resource', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ApplianceOperation, self).__init__(**kwargs)
        self.is_data_action = None
        self.name = None
        self.origin = None
        self.description = None
        self.operation = None
        self.provider = None
        self.resource = None


class ApplianceOperationsList(msrest.serialization.Model):
    """Lists of Appliances operations.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: Next page of operations.
    :vartype next_link: str
    :ivar value: Required. Array of applianceOperation.
    :vartype value: list[~azure.mgmt.resourceconnector.models.ApplianceOperation]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ApplianceOperation]'},
    }

    def __init__(
        self,
        *,
        value: List["_models.ApplianceOperation"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link: Next page of operations.
        :paramtype next_link: str
        :keyword value: Required. Array of applianceOperation.
        :paramtype value: list[~azure.mgmt.resourceconnector.models.ApplianceOperation]
        """
        super(ApplianceOperationsList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class AppliancePropertiesInfrastructureConfig(msrest.serialization.Model):
    """Contains infrastructure information about the Appliance.

    :ivar provider: Information about the connected appliance. Known values are: "VMWare", "HCI",
     "SCVMM", "KubeVirt", "OpenStack".
    :vartype provider: str or ~azure.mgmt.resourceconnector.models.Provider
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[Union[str, "_models.Provider"]] = None,
        **kwargs
    ):
        """
        :keyword provider: Information about the connected appliance. Known values are: "VMWare",
         "HCI", "SCVMM", "KubeVirt", "OpenStack".
        :paramtype provider: str or ~azure.mgmt.resourceconnector.models.Provider
        """
        super(AppliancePropertiesInfrastructureConfig, self).__init__(**kwargs)
        self.provider = provider


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.resourceconnector.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.resourceconnector.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.resourceconnector.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.resourceconnector.models.ErrorDetail
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class HybridConnectionConfig(msrest.serialization.Model):
    """Contains the REP (rendezvous endpoint) and “Listener” access token from notification service (NS).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar expiration_time: Timestamp when this token will be expired.
    :vartype expiration_time: long
    :ivar hybrid_connection_name: Name of the connection.
    :vartype hybrid_connection_name: str
    :ivar relay: Name of the notification service.
    :vartype relay: str
    :ivar token: Listener access token.
    :vartype token: str
    """

    _validation = {
        'expiration_time': {'readonly': True},
        'hybrid_connection_name': {'readonly': True},
        'relay': {'readonly': True},
        'token': {'readonly': True},
    }

    _attribute_map = {
        'expiration_time': {'key': 'expirationTime', 'type': 'long'},
        'hybrid_connection_name': {'key': 'hybridConnectionName', 'type': 'str'},
        'relay': {'key': 'relay', 'type': 'str'},
        'token': {'key': 'token', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(HybridConnectionConfig, self).__init__(**kwargs)
        self.expiration_time = None
        self.hybrid_connection_name = None
        self.relay = None
        self.token = None


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Known values are: "SystemAssigned", "None".
    :vartype type: str or ~azure.mgmt.resourceconnector.models.ResourceIdentityType
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        **kwargs
    ):
        """
        :keyword type: The identity type. Known values are: "SystemAssigned", "None".
        :paramtype type: str or ~azure.mgmt.resourceconnector.models.ResourceIdentityType
        """
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class PatchableAppliance(msrest.serialization.Model):
    """The Appliances patchable resource definition.

    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(PatchableAppliance, self).__init__(**kwargs)
        self.tags = tags


class SSHKey(msrest.serialization.Model):
    """Appliance SSHKey definition.

    :ivar private_key: User Private Key.
    :vartype private_key: str
    :ivar public_key: User Public Key.
    :vartype public_key: str
    """

    _attribute_map = {
        'private_key': {'key': 'privateKey', 'type': 'str'},
        'public_key': {'key': 'publicKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_key: Optional[str] = None,
        public_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword private_key: User Private Key.
        :paramtype private_key: str
        :keyword public_key: User Public Key.
        :paramtype public_key: str
        """
        super(SSHKey, self).__init__(**kwargs)
        self.private_key = private_key
        self.public_key = public_key


class SupportedVersion(msrest.serialization.Model):
    """The SupportedVersion object for appliance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar metadata: This is the metadata of the supported newer version.
    :vartype metadata: ~azure.mgmt.resourceconnector.models.SupportedVersionMetadata
    :ivar version: The newer version available for upgrade.
    :vartype version: str
    """

    _validation = {
        'metadata': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'metadata': {'key': 'metadata', 'type': 'SupportedVersionMetadata'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SupportedVersion, self).__init__(**kwargs)
        self.metadata = None
        self.version = None


class SupportedVersionCatalogVersion(msrest.serialization.Model):
    """The SupportedVersionCatalogVersion object for appliance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar data: The newer supported version catalog version data.
    :vartype data: ~azure.mgmt.resourceconnector.models.SupportedVersionCatalogVersionData
    :ivar name: The catalog version name for the version available for upgrade.
    :vartype name: str
    :ivar namespace: The catalog version namespace for the version available for upgrade.
    :vartype namespace: str
    """

    _validation = {
        'data': {'readonly': True},
        'name': {'readonly': True},
        'namespace': {'readonly': True},
    }

    _attribute_map = {
        'data': {'key': 'data', 'type': 'SupportedVersionCatalogVersionData'},
        'name': {'key': 'name', 'type': 'str'},
        'namespace': {'key': 'namespace', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SupportedVersionCatalogVersion, self).__init__(**kwargs)
        self.data = None
        self.name = None
        self.namespace = None


class SupportedVersionCatalogVersionData(msrest.serialization.Model):
    """The SupportedVersionCatalogVersionData object for appliance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar audience: The image audience name for the version available for upgrade.
    :vartype audience: str
    :ivar catalog: The image catalog name for the version available for upgrade.
    :vartype catalog: str
    :ivar offer: The image offer name for the version available for upgrade.
    :vartype offer: str
    :ivar version: The image version for the version available for upgrade.
    :vartype version: str
    """

    _validation = {
        'audience': {'readonly': True},
        'catalog': {'readonly': True},
        'offer': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'audience': {'key': 'audience', 'type': 'str'},
        'catalog': {'key': 'catalog', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SupportedVersionCatalogVersionData, self).__init__(**kwargs)
        self.audience = None
        self.catalog = None
        self.offer = None
        self.version = None


class SupportedVersionMetadata(msrest.serialization.Model):
    """The SupportedVersionMetadata object for appliance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar catalog_version: The newer supported version catalog version.
    :vartype catalog_version: ~azure.mgmt.resourceconnector.models.SupportedVersionCatalogVersion
    """

    _validation = {
        'catalog_version': {'readonly': True},
    }

    _attribute_map = {
        'catalog_version': {'key': 'catalogVersion', 'type': 'SupportedVersionCatalogVersion'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SupportedVersionMetadata, self).__init__(**kwargs)
        self.catalog_version = None


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure.mgmt.resourceconnector.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.resourceconnector.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~azure.mgmt.resourceconnector.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.resourceconnector.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UpgradeGraph(msrest.serialization.Model):
    """The Upgrade Graph for appliance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The appliance resource path.
    :vartype id: str
    :ivar name: The release train name.
    :vartype name: str
    :ivar properties: The properties of supported version.
    :vartype properties: ~azure.mgmt.resourceconnector.models.UpgradeGraphProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'UpgradeGraphProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.UpgradeGraphProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties: The properties of supported version.
        :paramtype properties: ~azure.mgmt.resourceconnector.models.UpgradeGraphProperties
        """
        super(UpgradeGraph, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.properties = properties


class UpgradeGraphProperties(msrest.serialization.Model):
    """The Upgrade Graph Properties for appliance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar appliance_version: The current appliance version.
    :vartype appliance_version: str
    :ivar supported_versions: This contains the current version and supported upgrade versions.
    :vartype supported_versions: list[~azure.mgmt.resourceconnector.models.SupportedVersion]
    """

    _validation = {
        'appliance_version': {'readonly': True},
        'supported_versions': {'readonly': True},
    }

    _attribute_map = {
        'appliance_version': {'key': 'applianceVersion', 'type': 'str'},
        'supported_versions': {'key': 'supportedVersions', 'type': '[SupportedVersion]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(UpgradeGraphProperties, self).__init__(**kwargs)
        self.appliance_version = None
        self.supported_versions = None
