/*
 *  Copyright (c) 2011 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree. An additional intellectual property rights grant can be found
 *  in the file PATENTS.  All contributing project authors may
 *  be found in the AUTHORS file in the root of the source tree.
 */

#ifndef WEBRTC_MODULES_AUDIO_CODING_TEST_SPATIALAUDIO_H_
#define WEBRTC_MODULES_AUDIO_CODING_TEST_SPATIALAUDIO_H_

#include "webrtc/base/scoped_ptr.h"
#include "webrtc/modules/audio_coding/include/audio_coding_module.h"
#include "webrtc/modules/audio_coding/test/ACMTest.h"
#include "webrtc/modules/audio_coding/test/Channel.h"
#include "webrtc/modules/audio_coding/test/PCMFile.h"
#include "webrtc/modules/audio_coding/test/utility.h"

#define MAX_FILE_NAME_LENGTH_BYTE 500

namespace webrtc {

class SpatialAudio : public ACMTest {
 public:
  SpatialAudio(int testMode);
  ~SpatialAudio();

  void Perform();
 private:
  int16_t Setup();
  void EncodeDecode(double leftPanning, double rightPanning);
  void EncodeDecode();

  rtc::scoped_ptr<AudioCodingModule> _acmLeft;
  rtc::scoped_ptr<AudioCodingModule> _acmRight;
  rtc::scoped_ptr<AudioCodingModule> _acmReceiver;
  Channel* _channel;
  PCMFile _inFile;
  PCMFile _outFile;
  int _testMode;
};

}  // namespace webrtc

#endif  // WEBRTC_MODULES_AUDIO_CODING_TEST_SPATIALAUDIO_H_
