# Announce: Rakudo Perl 6 compiler, Release #122 (2018.04)

On behalf of the Rakudo development team, I’m very happy to announce the
April 2018 release of Rakudo Perl 6 #122. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo.

Upcoming releases in 2018 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <https://rakudo.org/files/rakudo>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] — it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<https://rakudo.org/files/star>.

The changes in this release are outlined below:

New in 2018.04:
  + Fixes:
    + Fixed bug mapping windows1252/windows1251 without a dash [c9c5f341]
    + Made sure .encode and .decode accept the same encoding aliases [5298b7aa]
    + Fixed `infix:<o>` identity function [87e43c4a]
    + Made builds reproducible [16daf02f]
    + Made build of NQP modules reproducible [2c882d96]
    + Fixed explosion in List.combinations(Range) [624b3f0c]
    + Consistified &combinations/&permutations with method forms [29dcde10]
    + Made .produce/.reduce nodal [08eb465f]
    + Fixed Channel iterator failing if Nil was sent [bdd8143e]
    + Fixed value drift & precision issues in Num creation [8422d7b4][17446fc1]
    + Made sure that values of `once` blocks are deconted [f97398cf][53c02d85]
    + Made Supply.interval a serial Supply [7572983a]
    + Fixed bug with iteration of negative empty character classes [20495f09]
    + Fixed crash in loop + FIRST + LAST when it's wanted [cfc6b109][879b3340]
    + Fixed error for .native-descriptor on closed handle [5d554ba3][c6c25159]
    + Fixed QAST::Block migration in `with` + loop-comprehended `for` [fc192212]
    + Fixed `infix:<->($n)` to not negate [edbbc442]
    + Fixed crash in double-sink `for ... { Package::foo }` [4402839a]
    + Fixed thinko in CURR conditional [9bcc8e52]
    + Fixed crash with unknown column in RAKUDO_REPORT_COLUMNS [c015f08d]
    + Fixed substr to handle non-int arguments properly  [f0c85125]
    + Fixed hang in IO::Socket::INET.lines [6e37c7f0]
    + Made Setty.perl consistent with Baggy/Mixy.perl [c0212af9]
    + Fixed set difference for Bag (-) List [344a64e9]
    + Fixed @a[]:v and @a[*]:v to filter out deleted elements [08b951c8]
    + Fixed precision/value drift with Complex literals [43026662]
    + Fixed crash in NativeCall when calling into a C++ library [db8b218f]
    + Fixed dispatch with IO::Socket::INET.new: :!listen [ceeb3a00]
    + Fixed unwanted consumption of Seqs [9e6ae276]
    + Fixed proto .arity/.count for all core multi subs [4b5d36f3]
        [6a65ed02][d17f7535][859178b0]
    + Various improvements to produced messages [db7361a3][299dc6fc]
        [54137e8b][6c2f2445][5fee5891][91fe6b63][6cdee60d][4b2512a2]
  + Additions:
    + Added support for "api" adverb when loading modules [32c5c83c]
    + Added strict, replacement options for IO::Handle, Str.encode
        [6458811a][2760753d][37fc2883]
    + Added ShiftJIS decode/encode support [646f9211][f4863601]
    + Added a way to get child process ID via Proc::Async [1321917d]
    + Added Proc.pid [05816139][5ad102ea]
    + Added fails-like routine in Test.pm6 [4abfd4ca]
    + Added Array.grab [a0e5e880][a393ff69]
    + Added support for "const" marked return values in C++
        functions (NativeCall) [9b3a0b6f]
    + Added gist methods to AbsolutePath, NQP and Perl6 repositories [8f3237c2]
  + Build system:
    + Added missing tools/build/check-nqp-version.pl [26518055]
    + Fixed build when using a different nqp than the one in $PATH [eb71edcc]
    + Fixed the Makefile on Solaris [affeaa79]
    + Fixed build system not noticing change to BOOTSTRAP.nqp [2ae3f484]
  + Efficiency:
    + Made HyperIteratorBatcher.produce-batch 3x faster [684a50d1]
    + Made .hyper.grep batch producer at least 23% faster [3e9b705e][1c4eebe5]
    + Made Iterator.push-exactly about 8% faster [9d784dd0]
    + Made `grep :kv .pull-one` 1.5x faster [c40f0254]
    + Made `grep :p .pull-one` 1.5x faster [5db9ebc4]
    + Made `squish :as .pull-one` 1.5x faster [d2c88bcc]
    + Made `squish() .pull-one` 1.6x faster [c41b79c0]
    + Made `grep :k .push-all` 1.5x faster [e3aef509]
    + Made Blob/Buf comparisons up to 30% faster [9ffb06b2]
    + Made Capture.FLATTENABLE_(LIST|HASH) 30% faster [768cf9f2]
    + Made List cmp 20x faster [0d7b42fb][126d8a84][082f8152]
    + Made ORDER() about 7% faster (affects `infix:<cmp>`) [32b3ddc7]
    + Made List.roll($n) 6% faster [c71ff664][7327a33a]
    + Micro-optimized the Awaitable role (up to 10% faster) [266f4a22]
    + Made List.pick about 30% faster [de68bfc1]
    + Made List.roll about 20x faster [c53fde3e]
    + Made Map/TypedHash.roll about 30% faster [6a6bb23d][5981f81b]
    + Made unwrapped `dispatch:<var>` curriable (`*.&uc` 7.6x faster) [f174d4b4]
    + Made `%h<a>:delete` and `%h<a>:exists` about 1.5x faster [d3eefa21]
    + Made `@a[1]:delete` and `@a[1]:exists` about 1.5x faster [6ad6dcbb]
    + Implemented optimized Iterator methods for `42 xx ...` [5f256bae]
    + Made copying native arrays about 9% faster [5ec4a5ab]
    + Made CurriedRoleHOW.accept_type 1% faster [8c265f9b]
    + Made `my int @a = ^100` about 40% faster [e8ec81db]
    + Made int(8|16|32|64)/num(32|64) array initialization 9x faster [40815d16]
    + Made `my @a = ^100; my int @b = @a` about 9x as fast [b5318e6e]
    + Made native array iterator about 1% faster [a2d8c96b][bd238a7c]
    + Made native array.splice up to 47x faster [d1b3809a]
    + Made native array.STORE(Seq) about 2x faster [72473bd0]
    + Made native array.splice(offset,size,Seq) about 13x faster [a39d382e]
    + Made %h.head 2x faster [91421874]
    + Made Complex.Str 5%-10% faster [5ef05612]
    + ThreadPoolScheduler optimizations [4ef28a7b][8f4a5a53][d4254216]
        [d0fbe744][c71fa17d][3468f690][637147af][17ca56b4][5bab5865]
        [aaacc5a4][ae91db88][f8c44164][924310c5][b22421e7][ac5cf2bb]
    + Other minor optimizations
        [dc921b60][caacb2e4][67f91572][739fd9c9][f4255d5a][6f42d19e]
        [828cd4a8][232197da][8ce20ae1][75b6651b][18252b60][31b072c6]
        [ec265706][153e892d][0344925f][81dbe4cb][348e6f45][6a66b359]
        [c2eae41c][9f8231c6][72dfddfa][24ddff73][eefccc18][0756076b]
        [a3da6ac5][8e2ee64e][29b7f464][111f67a4][7c510611][82b19b1f]
        [74b75599][850765f7][1f98b1bb][617624f5][a53811cd][d9869e53]
        [7b5ccaa6][518f2c31][d393b828][12a38f1f]
  + Internal:
    + Many improvements to .hyper and .race [7d978fb2][22849592]
        [34b294d2][ae0cbc30][7af3b648][9532e9c3][d75f4cfc]
    + Moved proto method splice: Mu -> Any [88d61bd9]
    + ±Inf/NaN are now treated as any other Num [e348b8f2]
    + Made sure native array splice won't splice from itself [28629905]


The following people contributed to this release:

Zoffix Znet, Elizabeth Mattijsen, Pawel Murias, Will "Coke" Coleda,
Luca Ferrari, Aleks-Daniel Jakimenko-Aleksejev, cfa,
陈梓立, Christian Bartolomäus, Stefan Seifert, Jonathan Worthington,
Samantha McVey, Jeremy Studer, Juan Julián Merelo Guervós, Timo Paulssen,
Ronald Schmidt, Daniel Green, Jan-Olof Hendig, Patrick Spek, Moritz Lenz,
Matthias Bloch, Jonas Kramer, Ben Davies, Tobias Leich,
Wenzel P. P. Peppmeyer, Itsuki Toyota, Larry Wall, CC, Stefan Fischer,
Christopher Bottoms, Dan Book, Brad Gilbert, dariusantia, ilyash-b

as well as

Bart Wiegmans, Paweł Murias, cc, gerd

If you would like to contribute or find out more information, visit
<https://perl6.org>, <https://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put “Perl 6 Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#123), is tentatively scheduled for 2018-05-19.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory
documentation, and other software that can be used with the Rakudo
compiler to enhance its utility.
