#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: bisar
class: CommandLineTool
cwlVersion: v1.0
doc: "This program reads three-letter mappings of bisulfite reads and computes local\
  \ pairwise four-letter realignments using an advanced statistical alignment model.\n\
  \n\n\nFor more information, visit http://www.seqan.de"
inputs:
- doc: Filename for output-file output file
  id: param_output-file_filename
  inputBinding:
    prefix: -output-file
  label: Filename for output-file output file
  type: string
- default: '3.0'
  doc: Max. error rate in 3-letter alphabet.
  id: param_max3-error
  inputBinding:
    prefix: -max3-error
  label: Max. error rate in 3-letter alphabet.
  type:
  - 'null'
  - double
- default: '4.0'
  doc: Max. error rate in 4-letter alphabet.
  id: param_max4-error
  inputBinding:
    prefix: -max4-error
  label: Max. error rate in 4-letter alphabet.
  type:
  - 'null'
  - double
- default: '1.0'
  doc: Min required mapping quality.
  id: param_min-mapq
  inputBinding:
    prefix: -min-mapq
  label: Min required mapping quality.
  type:
  - 'null'
  - double
- default: 'false'
  doc: Use empirical substitution error frequencies of Illumina sequencing data for
    alignment scoring scheme (corresponding to Dohm et al. 2008).
  id: param_ns-subst-errors
  inputBinding:
    prefix: -ns-subst-errors
  label: Use empirical substitution error frequencies of Illumina sequencing data
    for alignment scoring scheme (corresponding to Dohm et al. 2008).
  type:
  - 'null'
  - string
- default: 'false'
  doc: Use empirical insertion error frequencies of Illumina sequencing data for alignment
    scoring scheme (corresponding to Minoche et al. 2011).
  id: param_ns-ins-errors
  inputBinding:
    prefix: -ns-ins-errors
  label: Use empirical insertion error frequencies of Illumina sequencing data for
    alignment scoring scheme (corresponding to Minoche et al. 2011).
  type:
  - 'null'
  - string
- default: 'false'
  doc: Use empirical deletion error frequencies of Illumina sequencing data for alignment
    scoring scheme (corresponding to Minoche et al. 2011).
  id: param_ns-del-errors
  inputBinding:
    prefix: -ns-del-errors
  label: Use empirical deletion error frequencies of Illumina sequencing data for
    alignment scoring scheme (corresponding to Minoche et al. 2011).
  type:
  - 'null'
  - string
- default: '0.001'
  doc: Deletion error rate.
  id: param_del-error-rate
  inputBinding:
    prefix: -del-error-rate
  label: Deletion error rate.
  type:
  - 'null'
  - double
- default: '-4.5'
  doc: Gap open score (original, must be proportional to mismatch scores).
  id: param_gap-open-score
  inputBinding:
    prefix: -gap-open-score
  label: Gap open score (original, must be proportional to mismatch scores).
  type:
  - 'null'
  - double
- default: '-2.0'
  doc: Gap extend score.
  id: param_gap-extend-score
  inputBinding:
    prefix: -gap-extend-score
  label: Gap extend score.
  type:
  - 'null'
  - double
- default: '0.99'
  doc: Bisulfite conversion rate.
  id: param_bs-conversion-rate
  inputBinding:
    prefix: -bs-conversion-rate
  label: Bisulfite conversion rate.
  type:
  - 'null'
  - double
- default: '0.5'
  doc: Global methylation rate.
  id: param_global-meth-rate
  inputBinding:
    prefix: -global-meth-rate
  label: Global methylation rate.
  type:
  - 'null'
  - double
- default: '0.9'
  doc: Sequence identity used for substitution matrix.
  id: param_seq-identity
  inputBinding:
    prefix: -seq-identity
  label: Sequence identity used for substitution matrix.
  type:
  - 'null'
  - double
- default: '0.01'
  doc: Rate of Ns in reference sequence.
  id: param_ref-n
  inputBinding:
    prefix: -ref-n
  label: Rate of Ns in reference sequence.
  type:
  - 'null'
  - double
- default: 'false'
  doc: Set verbosity to a minimum.
  id: param_quiet
  inputBinding:
    prefix: -quiet
  label: Set verbosity to a minimum.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable verbose output.
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: Enable verbose output.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable very verbose output.
  id: param_very-verbose
  inputBinding:
    prefix: -very-verbose
  label: Enable very verbose output.
  type:
  - 'null'
  - string
- doc: SAM input file containing three-letter read alignments (must be sorted by query
    names).
  id: param_argument-0
  inputBinding:
    prefix: -argument-0
  label: SAM input file containing three-letter read alignments (must be sorted by
    query names).
  type: File
- doc: A reference genome file.
  id: param_argument-1
  inputBinding:
    prefix: -argument-1
  label: A reference genome file.
  type: File
- doc: Either one (single-end) or two (paired-end) read files.
  id: param_argument-2
  inputBinding:
    prefix: -argument-2
  label: Either one (single-end) or two (paired-end) read files.
  type: File
label: Pairwise four-letter realignment computation for bisulfite reads
outputs:
- doc: Mapping output file.
  id: param_output-file
  label: Mapping output file.
  outputBinding:
    glob: $(inputs.param_output-file_filename)
  type: File
