#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: insegt
class: CommandLineTool
cwlVersion: v1.0
doc: "INSEGT is a tool to analyze alignments of RNA-Seq reads (single-end or paired-end)\
  \ by using gene-annotations.\nInput to INSEGT is a SAM file containing the alignments\
  \ and a file containing the annotations of the reference genome, either in GFF or\
  \ GTF format.\n\n\n\nFor more information, visit http://www.seqan.de"
inputs:
- doc: Filename for read-output output file
  id: param_read-output_filename
  inputBinding:
    prefix: -read-output
  label: Filename for read-output output file
  type:
  - 'null'
  - string
- doc: Filename for anno-output output file
  id: param_anno-output_filename
  inputBinding:
    prefix: -anno-output
  label: Filename for anno-output output file
  type:
  - 'null'
  - string
- doc: Filename for tuple-output output file
  id: param_tuple-output_filename
  inputBinding:
    prefix: -tuple-output
  label: Filename for tuple-output output file
  type:
  - 'null'
  - string
- doc: Output filename for fusion-output, which contains exon tuple of gene fusions
    (Advanced option, currently no output port for KNIME).
  id: param_fusion-output
  inputBinding:
    prefix: -fusion-output
  label: Output filename for fusion-output, which contains exon tuple of gene fusions
    (Advanced option, currently no output port for KNIME).
  type:
  - 'null'
  - string
- default: '2'
  doc: ntuple
  id: param_ntuple
  inputBinding:
    prefix: -ntuple
  label: ntuple
  type:
  - 'null'
  - int
- default: '5'
  doc: Offset to short alignment-intervals for search.
  id: param_offset-interval
  inputBinding:
    prefix: -offset-interval
  label: Offset to short alignment-intervals for search.
  type:
  - 'null'
  - int
- default: '5'
  doc: Threshold for allowed gaps in alignment (not introns).
  id: param_threshold-gaps
  inputBinding:
    prefix: -threshold-gaps
  label: Threshold for allowed gaps in alignment (not introns).
  type:
  - 'null'
  - int
- default: '1'
  doc: Threshold for min. count of tuple for output.
  id: param_threshold-count
  inputBinding:
    prefix: -threshold-count
  label: Threshold for min. count of tuple for output.
  type:
  - 'null'
  - int
- default: '0.0'
  doc: Threshold for min. RPKM of tuple for output.
  id: param_threshold-rpkm
  inputBinding:
    prefix: -threshold-rpkm
  label: Threshold for min. RPKM of tuple for output.
  type:
  - 'null'
  - double
- default: 'false'
  doc: Create only maxTuple (which are spanned by the whole read).
  id: param_max-tuple
  inputBinding:
    prefix: -max-tuple
  label: Create only maxTuple (which are spanned by the whole read).
  type:
  - 'null'
  - string
- default: 'false'
  doc: Create only Tuple of exact length n. By default all tuple up to the given length
    are computed (if -m is set, -e will be ignored).
  id: param_exact-ntuple
  inputBinding:
    prefix: -exact-ntuple
  label: Create only Tuple of exact length n. By default all tuple up to the given
    length are computed (if -m is set, -e will be ignored).
  type:
  - 'null'
  - string
- default: 'false'
  doc: Orientation of reads is unknown.
  id: param_unknown-orientation
  inputBinding:
    prefix: -unknown-orientation
  label: Orientation of reads is unknown.
  type:
  - 'null'
  - string
- doc: ''
  id: param_argument-0
  inputBinding:
    prefix: -argument-0
  label: ''
  type: File
- doc: ''
  id: param_argument-1
  inputBinding:
    prefix: -argument-1
  label: ''
  type: File
label: INtersecting SEcond Generation sequencing daTa with annotation
outputs:
- doc: Output filename for read-output, which contains the mapped annotations followed
    by their parent annotation.
  id: param_read-output
  label: Output filename for read-output, which contains the mapped annotations followed
    by their parent annotation.
  outputBinding:
    glob: $(inputs.param_read-output_filename)
  type:
  - 'null'
  - File
- doc: Output filename for anno-output, which contains the annotations similar to
    the GFF input and additionally the counts of the mapped reads and the normalized
    expression levels in RPKM.
  id: param_anno-output
  label: Output filename for anno-output, which contains the annotations similar to
    the GFF input and additionally the counts of the mapped reads and the normalized
    expression levels in RPKM.
  outputBinding:
    glob: $(inputs.param_anno-output_filename)
  type:
  - 'null'
  - File
- doc: Output filename for tuple-output, which contains exon tuples connected by reads
    or matepairs.
  id: param_tuple-output
  label: Output filename for tuple-output, which contains exon tuples connected by
    reads or matepairs.
  outputBinding:
    glob: $(inputs.param_tuple-output_filename)
  type:
  - 'null'
  - File
