#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: rabema_build_gold_standard
class: CommandLineTool
cwlVersion: v1.0
doc: "This program allows one to build a RABEMA gold standard.  The input is a reference\
  \ FASTA file and a perfect SAM/BAM map (e.g. created using RazerS 3 in full-sensitivity\
  \ mode).\nThe input SAM/BAM file must be sorted by coordinate.  The program will\
  \ create a FASTA index file REF.fa.fai for fast random access to the reference.\n\
  \n\n\nFor more information, visit http://www.seqan.de"
inputs:
- default: 'false'
  doc: Enable verbose output.
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: Enable verbose output.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable even more verbose output.
  id: param_very-verbose
  inputBinding:
    prefix: -very-verbose
  label: Enable even more verbose output.
  type:
  - 'null'
  - string
- doc: Filename for out-gsi output file
  id: param_out-gsi_filename
  inputBinding:
    prefix: -out-gsi
  label: Filename for out-gsi output file
  type: string
- doc: Path to load reference FASTA from.
  id: param_reference
  inputBinding:
    prefix: -reference
  label: Path to load reference FASTA from.
  type: File
- doc: Path to load the "perfect" SAM/BAM file from.
  id: param_in-bam
  inputBinding:
    prefix: -in-bam
  label: Path to load the "perfect" SAM/BAM file from.
  type:
  - 'null'
  - File
- default: 'false'
  doc: Enable oracle mode.  This is used for simulated data when the input SAM/BAM
    file gives exactly one position that is considered as the true sample position.
  id: param_oracle-mode
  inputBinding:
    prefix: -oracle-mode
  label: Enable oracle mode.  This is used for simulated data when the input SAM/BAM
    file gives exactly one position that is considered as the true sample position.
  type:
  - 'null'
  - string
- default: 'false'
  doc: When set, N matches all characters without penalty.
  id: param_match-N
  inputBinding:
    prefix: -match-N
  label: When set, N matches all characters without penalty.
  type:
  - 'null'
  - string
- default: edit
  doc: 'Set distance metric.  Valid values: hamming, edit.  Default: edit.'
  id: param_distance-metric
  inputBinding:
    prefix: -distance-metric
  label: 'Set distance metric.  Valid values: hamming, edit.  Default: edit.'
  type:
  - 'null'
  - string
- default: '0'
  doc: Maximal error rate to build gold standard for in percent.  This parameter is
    an integer and relative to the read length.  In case of oracle mode, the error
    rate for the read at the sampling position is used and RATE is used as a cutoff
    threshold.
  id: param_max-error
  inputBinding:
    prefix: -max-error
  label: Maximal error rate to build gold standard for in percent.  This parameter
    is an integer and relative to the read length.  In case of oracle mode, the error
    rate for the read at the sampling position is used and RATE is used as a cutoff
    threshold.
  type:
  - 'null'
  - int
label: RABEMA Gold Standard Builder
outputs:
- doc: Path to write the resulting GSI file to.
  id: param_out-gsi
  label: Path to write the resulting GSI file to.
  outputBinding:
    glob: $(inputs.param_out-gsi_filename)
  type: File
